# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-

class EdictSource():
	def __init__(self):
		self.edict_header = '？？？ /EDICT, EDICT_SUB(P), EDICT2 Japanese-English Electronic Dictionary Files/Copyright Electronic Dictionary Research & Development Group - 2010/Created: 2011-05-25/'
		self.edict_body = '''・ [なかぐろ] /(n) middle dot (typographical symbol used between parallel terms, names in katakana, etc.)/full-stop mark at mid-character height/interpoint (interword separation)/
・ [なかぽち] /(n) middle dot (typographical symbol used between parallel terms, names in katakana, etc.)/full-stop mark at mid-character height/interpoint (interword separation)/
・ [なかぽつ] /(n) middle dot (typographical symbol used between parallel terms, names in katakana, etc.)/full-stop mark at mid-character height/interpoint (interword separation)/
・ [なかポツ] /(n) middle dot (typographical symbol used between parallel terms, names in katakana, etc.)/full-stop mark at mid-character height/interpoint (interword separation)/
ヽ /(n) repetition mark in katakana/
ヾ /(n) voiced repetition mark in katakana/
ゝ /(n) repetition mark in hiragana/
ゞ /(n) voiced repetition mark in hiragana/
〃 [おなじ] /(n) ditto mark/
〃 [おなじく] /(n) ditto mark/
仝 [どうじょう] /(n) "as above" mark/
々 [おなじ] /(n) repetition of kanji (sometimes voiced)/
々 [おなじく] /(n) repetition of kanji (sometimes voiced)/
々 [くりかえし] /(n) repetition of kanji (sometimes voiced)/
々 [どうのじてん] /(n) repetition of kanji (sometimes voiced)/
々 [のま] /(n) repetition of kanji (sometimes voiced)/
〆 [しめ] /(n) end or closure mark/
〆る [しめる] /(v1,vt) (1) to total/to sum/(2) to make sushi adding a mixture of vinegar and salt/
〆切 [しめきり] /(n) closing/cut-off/end/deadline/Closed/No Entrance/
〆切り [しめきり] /(n) closing/cut-off/end/deadline/Closed/No Entrance/
〆切る [しめきる] /(v5r,vt) to close up/to shut up (e.g. behind doors)/to cut off (e.g. because a deadline has expired)/
〆切日 [しめきりび] /(n) time limit/closing day/deadline/
〆粕 [しめかす] /(n) oil cake/scrap cake/
〇 [かんすうじゼロ] /(n) "kanji" zero/
〇 [まる] /(iK) (n) (1) circle (sometimes used for zero)/(2) 'correct' (when marking)/
〇〇 [まるまる] /(n) symbol used as a placeholder (either because a number of other words could be used in that position, or because of censorship)/
ー /(n) long vowel mark (usually only used in katakana)/
〜 [にょろ] /(n) tilde/
〜朝時代 [〜ちょうじだい] /(exp) the era of the ... dynasty/the ... reign/
〜年生まれ [〜ねんうまれ] /(exp) born in .../
＋α [プラスアルファ] /(n) a little more than usual (wasei: plus alpha)/bribe money added to a regular fee/and then some/
× [ばつ] /(n) (1) x-mark (used to indicate an incorrect answer in a test, etc.)/
× [ぺけ] /(n) (1) x-mark (used to indicate an incorrect answer in a test, etc.)/
＠ [アットマーク] /(n) "at" mark/
＠系 [アットけい] /(n) roguelike (character display computer game)/
○ [かんすうじゼロ] /(iK) (n) "kanji" zero/
○ [まる] /(n) (1) circle (sometimes used for zero)/(2) 'correct' (when marking)/
○×テスト [まるばつテスト] /(n) true-false test/yes-no test/
◎ [にじゅうまる] /(n) double circle/'good work' (equiv. of silver star awarded to children at school)/
△ [さんかく] /(n) average (e.g. as a mark for homework)/weak/
※ [こめじるし] /(n) rice symbol/note (supplementary information) symbol/symbol with an "x" and four dots/
※印 [こめじるし] /(n) rice symbol/note (supplementary information) symbol/symbol with an "x" and four dots/
〒 [ゆうびんきごう] /(n) (abbr) (Japanese) postal symbol/post office/post/postal service/mail/
→ [やじるし] /(n) arrow (mark or symbol)/directional marker or indicator/
← [やじるし] /(n) arrow (mark or symbol)/directional marker or indicator/
↑ [やじるし] /(n) arrow (mark or symbol)/directional marker or indicator/
↓ [やじるし] /(n) arrow (mark or symbol)/directional marker or indicator/
≒ [おおよそ] /(adv,n) (uk) about/roughly/as a rule/approximately/
０９０金融 [ゼロキューゼロきんゆう] /(n) "090" financing/loan sharks operating from a cellphone (i.e. without a fixed phone number)/
１ [いち] /(num,pref) (1) one/(suf) (2) best in/the most (...) in (where an adjective follows)/
１ [ひと] /(num,pref) (1) one/
１０００円 [せんえん] /(n) 1000 yen/(P)/
１００円ショップ [ひゃくえんショップ] /(n) hundred-yen store/(P)/
１００円玉 [ひゃくえんだま] /(n) 100 yen coin/
１００均 [ひゃっきん] /(n) 100 yen shop/(P)/
１０月 [じゅうがつ] /(n-adv) October/(P)/
１０個１組 [じっこいちくみ] /(n) (comp) decade/
１０進 [じっしん] /(adj-na,adj-no) decimal/denary/deciam/
１０進 [じゅっしん] /(adj-na,adj-no) decimal/denary/deciam/
１０進２進変換 [じっしんにしんへんかん] /(n) (comp) decimal to binary conversion/
１０進演算 [じっしんえんざん] /(n) (comp) decimal arithmetic/
１０進演算子 [じっしんえんざんし] /(n) (comp) decimal operator/
１０進基数 [じっしんきすう] /(n) (comp) decimal radix/
１０進小数 [じっしんしょうすう] /(n) (comp) decimal fraction/
１０進小数点 [じっしんしょうすうてん] /(n) (comp) decimal point/
１０進数 [じっしんすう] /(n) (comp) decimal/decimal digit/decimal number/
１０進法 [じっしんほう] /(n) decimal system/
１０代 [じゅうだい] /(n,adj-no) (1) the teens (10-19)/teenage/(n) (2) the tenth generation/(P)/
１０日 [とおか] /(n) (1) the tenth day of the month/(2) ten days/(P)/
１１０番 [ひゃくとおばん] /(n,vs) police emergency tel. no. (in Japan)/(P)/
１１９番 [ひゃくじゅうきゅうばん] /(n) ambulance and fire brigade emergency tel. no. (in Japan)/
１１月 [じゅういちがつ] /(n-adv) November/(P)/
１２月 [じゅうにがつ] /(n-adv) December/(P)/
１６進法 [じゅうろくしんほう] /(n) (comp) hexadecimal/hexadecimal notation/
１８６７年憲法法 [せんはっぴゃくろくじゅうしちねんけんぽうほう] /(n) Constitution Act 1867 (which established Canada)/
１８禁 [じゅうはちきん] /(n) 18 certificate/R-18/restricted to those 18 years or older/
１９８２年憲法 [せんきゅうひゃくはちじゅうにねんけんぽう] /(n) Constitution Act, 1982 (part of the Canadian Constitution)/
１つ [ひとつ] /(num) (1) one/(n) (2) for one thing (often used in itemized lists)/(3) (after a noun) only/(4) (with a verb in negative form) (not) even/(n-adv) (5) just (i.e. "just try it")/
１パイント [いちパイント] /(n) one pint/
１羽 [いちわ] /(n) one (bird)/
１回生 [いっかいせい] /(n) first year (college) student/freshman/
１割 [いちわり] /(n) ten percent/(P)/
１月 [いちがつ] /(n-adv) January/(P)/
１限目 [いちげんめ] /(n) first period (e.g. first class in school day)/
１個あたり [いっこあたり] /(n,ctr) each/per piece/
１個当り [いっこあたり] /(n,ctr) each/per piece/
１次キャッシュ [いっしキャッシュ] /(n) (comp) level 1 cache/
１次コイル [いちじコイル] /(n) primary coil/primary winding (in transformer)/
１人 [いちにん] /(n) (1) one person/
１人 [ひとり] /(n) (1) one person/(2) alone/unmarried/solitary/
１人あたり [ひとりあたり] /(exp,adv) per person/per capita/per head/
１人きり [ひとりきり] /(n,adv) all on one's own/
１人っきり [ひとりっきり] /(n,adv) all on one's own/
１人っ切り [ひとりっきり] /(n,adv) all on one's own/
１人切り [ひとりきり] /(n,adv) all on one's own/
１人当たり [ひとりあたり] /(exp,adv) per person/per capita/per head/
１切れ [ひときれ] /(n) slice/small piece/
１対１の通信 [いちたいいちのつうしん] /(n) (comp) one to one communication/
１対一 [いったいいち] /(n,adj-no) one-to-one/
１対多 [いちたいた] /(n,adj-no) one-to-many/
１斗缶 [いっとかん] /(n) eighteen litre drum/
１度だけ [いちどだけ] /(exp) only once/
１等 [いっとう] /(n,adj-no) first-class/first-rank/A1/the most/the best/(P)/
１等軍曹 [いっとうぐんそう] /(n) sergeant first-class/
１等国 [いっとうこく] /(n) first-class power/
１等車 [いっとうしゃ] /(n) first-class carriage (coach)/
１等賞 [いっとうしょう] /(n) first place prize/blue ribbon/
１等親 [いっとうしん] /(n) first-degree relative/member of one's immediate family/
１等星 [いっとうせい] /(n) first-magnitude star/
１等卒 [いっとうそつ] /(n) private first-class/
１等地 [いっとうち] /(n) best (residential) district (in town)/
１等兵 [いっとうへい] /(n) private (e-2)/pfc/
１等陸士 [いっとうりくし] /(n) private first-class/
１日 [いちじつ] /(n) (1) first day of the month/(2) one day/
１日 [いちにち] /(n) (1) first day of the month/(2) one day/
１日 [ひとえ] /(ok) (n) (1) first day of the month/(2) one day/
１日 [ひとひ] /(ok) (n) (1) first day of the month/(2) one day/
１枚 [いちまい] /(n) one thin flat object/one sheet/
１万円 [いちまんえん] /(n) 10,000 Yen/
２ [に] /(num) two/
２ [ふ] /(num) two/
２ [ふう] /(num) two/
２ [ふた] /(num) two/
２０００年対応 [にせんねんたいおう] /(exp) Y2K compliant/
２０００年問題 [にせんねんもんだい] /(n) Y2K bug/year 2000 problem/
２０００年問題対応 [にせんねんもんだいたいおう] /(exp) Y2K compliant/
２０００年問題対策済み [にせんねんもんだいたいさくずみ] /(n) Y2K compliant/
２０歳 [はたち] /(n) (1) 20 years old/
２０世紀 [にじっせいき] /(n) twentieth century/
２０世紀 [にじゅっせいき] /(n) twentieth century/
２０日 [はつか] /(n) (1) twentieth (day of the month)/(2) twenty days/
２４時間 [にじゅうよじかん] /(n) 24 hours/twenty-four hours/
２７年テーゼ [にじゅうしちねんテーゼ] /(n) 1927 Theses/Comintern policy documents regarding capitalism, imperialism, and a possible revolution in Japan/
２ちゃんねら [にちゃんねら] /(n) 2channeler/2chan user/
２ちゃんねらー [にちゃんねらー] /(n) 2channeler/2chan user/
２ちゃんねる [にちゃんねる] /(n) (comp) 2channel (Japanese online forum)/
２つ [ふたつ] /(num) two/
２つに１つ [ふたつにひとつ] /(exp) one of two (possibilities, alternatives, etc.)/
２のべき [にのべき] /(n) power of two/
２の冪 [にのべき] /(n) power of two/
２ルート化 [にルートか] /(n) (comp) (link, path) redundancy/
２回生 [にかいせい] /(n) second year (college) student/sophomore/
２割 [にわり] /(n) 20 percent/(P)/
２月 [にがつ] /(n-adv) February/(P)/
２項式 [にこうしき] /(n,adj-no) (comp) binomial/
２時 [にじ] /(n-t) two o'clock/
２次局 [にじきょく] /(n) (comp) secondary station/
２進−５進 [にしんごしん] /(n) (comp) biquinary/
２進−５進法 [にしんーごしんほう] /(n) (comp) biquinary notation/
２進５進 [にしんごしん] /(n) (comp) biquinary/
２進データ同期通信 [にしんデータどうきつうしん] /(n) (comp) binary synchronous communication/
２進演算 [にしんえんざん] /(n) (comp) binary arithmetic operation/
２進化１０進コード [にしんかじっしんコード] /(n) (comp) binary-coded decimal code/
２進化１０進数 [にしんかじっしんすう] /(n) (comp) binary coded decimal/BCD/
２進化１０進表示法 [にしんかじっしんひょうじほう] /(n) (comp) binary-coded decimal representation/
２進化１０進法 [にしんかじっしんほう] /(n) (comp) binary-coded decimal notation/
２進加算器 [にしんかさんき] /(n) (comp) binary adder/
２進数 [にしんすう] /(n) binary digits/
２進数字 [にしんすうじ] /(n) (comp) binary digit/
２人きり [ふたりきり] /(n) just the two of them/
２人っきり [ふたりっきり] /(n) just the two of them/
２人っ切り [ふたりっきり] /(n) just the two of them/
２人とも [ふたりとも] /(n) both (people)/
２人乗り [ふたりのり] /(n,vs) two people using the same (vehicle) (often two on a bike)/
２人切り [ふたりきり] /(n) just the two of them/
２組 [ふたくみ] /(n) two classes/double/two sets/
２通 [につう] /(n) two copies/
２度と [にどと] /(adv) never again (with negative verb)/
２度寝 [にどね] /(n,vs) going back to sleep (e.g. after waking up in the morning)/
２等 [にとう] /(n) second class/
２等軍曹 [にとうぐんそう] /(n) staff sergeant/
２等車 [にとうしゃ] /(n) second class carriage/
２等賞 [にとうしょう] /(n) second prize/
２等親 [にとうしん] /(n) second-degree relative/
２等分 [にとうぶん] /(n,vs) bisection/
２等分線 [にとうぶんせん] /(n) bisector/
２等兵 [にとうへい] /(n) private (e-1)/
２等辺３角形 [にとうへんさんかくけい] /(n) isosceles triangle/
２等辺３角形 [にとうへんさんかっけい] /(n) isosceles triangle/
２日 [ふつか] /(n) (1) second day of the month/(2) two days/
２倍 [にばい] /(n) double/twice/twofold/
２番目 [にばんめ] /(n) second (in a series)/
２部上場企業 [にぶじょうじょうきぎょう] /(n) Second Section company (on the Tokyo Stock Exchange)/
２変量補間 [にへんりょうほかん] /(n) (comp) bivariable interpolation/
２本立て映画 [にほんたてえいが] /(n) double feature (movie)/
２枚 [にまい] /(n) two sheets (pieces) (of paper)/
３ [さん] /(num) (1) three/(pref) (2) tri-/
３ [み] /(num) (1) three/(pref) (2) tri-/
３２ビットの広い [さんじゅうにビットのひろい] /(n) (comp) 32 bits wide/
３２年テーゼ [さんじゅうにねんテーゼ] /(n) 1932 Theses/Comintern policy documents urging overthrow of Japan's imperial and metayage systems/
３Ｄ [さんディー] /(n) 3D/three dimensional/
３Ｄ [スリーディー] /(n) 3D/three dimensional/
３Ｄ映画 [さんディーえいが] /(n) 3D movie/
３Ｄ映像 [さんディーえいぞう] /(n) 3D image/
３Ｐ [さんピー] /(n) (col) (sens) threesome/
３つ [みっつ] /(num) three/
３カードモンテ [スリーカードモンテ] /(n) three-card monte (card game)/
３回生 [さんかいせい] /(n) third year (college) student/junior/
３角形 [さんかくけい] /(n,adj-no) triangle/three-cornered polygon/
３角形 [さんかっけい] /(n,adj-no) triangle/three-cornered polygon/
３月 [さんがつ] /(n-adv) March/(P)/
３元材料 [さんげんざいりょう] /(n) ternary material (e.g. semiconductor)/
３時 [さんじ] /(n-adv) (1) 3 o'clock/(2) 3 o'clock snack/
３時のおやつ [さんじのおやつ] /(exp) afternoon refreshment/afternoon tea/
３次元 [さんじげん] /(n) three dimensions/three dimensional/3D/3-D/(P)/
３人殺し [さんにんころし] /(n) triple murder/
３人殺し [さんにんごろし] /(n) triple murder/
３人乗り [さんにんのり] /(n) three people on the same vehicle (usu. bike)/
３組 [さんくみ] /(n) set of three/three sets/three classes/
３組 [みくみ] /(n) set of three/three sets/three classes/
３等 [さんとう] /(n) third class/
３等軍曹 [さんとうぐんそう] /(n) sergeant/
３等賞 [さんとうしょう] /(n) third prize/
３等親 [さんとうしん] /(n) third degree of kinship/
３等星 [さんとうせい] /(n) third magnitude star/
３等分 [さんとうぶん] /(n,vs) trisect/
３日 [みっか] /(n) (1) the third day of the month/(2) three days/
３倍 [さんばい] /(n) three-fold/three times/
３部 [さんぶ] /(n) three parts/three copies/
３本立て映画 [さんぼんたてえいが] /(n) triple feature (movie)/
３枚 [さんまい] /(n) (1) three flat objects (e.g. tickets, pieces of cloth, etc.)/(2) filleting (a fish)/
４ [し] /(num) four/
４ [よ] /(num) four/
４ [よん] /(num) four/
４ＷＤ [よんダブリューディー] /(n) four-wheel drive (vehicle)/
４つ [よっつ] /(num) four/
４ヵ年 [よんかねん] /(adj-pn) quadrennial/
４ヶ年 [よんかねん] /(adj-pn) quadrennial/
４回生 [よんかいせい] /(n) fourth year (college) student/senior/
４月 [しがつ] /(n-adv) April/(P)/
４月テーゼ [しがつテーゼ] /(n) April Theses/series of directives issued by Lenin after his return from exile/
４月馬鹿 [しがつばか] /(n) (1) April fool/(2) April fool's day/
４元材料 [よんげんざいりょう] /(n) quaternary material (e.g. semiconductor)/
４当５落 [よんとうごらく] /(exp) sleep four hours pass, sleep five hours fail/four-pass, five fail/
４日 [よっか] /(n) (1) fourth day of month/(2) four days/
５ [い] /(num) five/
５ [いつ] /(num) five/
５ [ご] /(num) five/
５００円玉 [ごひゃくえんだま] /(n) 500 yen coin/
５つ [いつつ] /(num) five/
５月 [ごがつ] /(n-adv) May/(P)/
５叉路 [ごさろ] /(n) five-forked road/five-road junction/
５日 [いつか] /(n) (1) the fifth day of the month/(2) five days/
６ [む] /(num) six/
６ [むう] /(num) six/
６ [ろく] /(num) six/
６つ [むっつ] /(num) six/
６つ [むつ] /(num) six/
６月 [ろくがつ] /(n-adv) June/(P)/
６日 [むいか] /(n) (1) sixth day of the month/(2) six days/
６日 [むゆか] /(ok) (n) (1) sixth day of the month/(2) six days/
６日 [むよか] /(ok) (n) (1) sixth day of the month/(2) six days/
７ [しち] /(num) (1) seven/(pref) (2) hepta-/
７ [な] /(num) (1) seven/(pref) (2) hepta-/
７ [なな] /(num) (1) seven/(pref) (2) hepta-/
７つ [ななつ] /(num) seven/
７月 [しちがつ] /(n-adv) July/(P)/
７月王政 [しちがつおうせい] /(n) (French) July Monarchy/
７日 [なぬか] /(n-adv) (1) the seventh day of the month/(2) seven days/
７日 [なのか] /(n-adv) (1) the seventh day of the month/(2) seven days/
８ [はち] /(num) eight/
８ [や] /(num) eight/
８３会 [はちさんかい] /(n) collectively, the 83 new LDP members of parliament elected in the Sept. 2005 general election/
８つ [やっつ] /(num) eight/
８つ [やつ] /(num) eight/
８の字 [はちのじ] /(n) (1) figure eight/figure of eight/
８月 [はちがつ] /(n-adv) August/(P)/
８進数 [はちしんすう] /(n) (comp) octal/base 8/
８日 [ようか] /(n) (1) the eighth day of the month/(2) eight days/
９ [きゅう] /(num) nine/
９ [く] /(num) nine/
９ [ここ] /(num) nine/
９ [ここの] /(num) nine/
９ [この] /(num) nine/
９１１事件 [きゅういちいちじけん] /(n) September 11th attacks/
９つ [ここのつ] /(num) nine/
９月 [くがつ] /(n-adv) September/(P)/
９日 [ここぬか] /(ok) (n) (1) the ninth day of the month/(2) nine days/
９日 [ここのか] /(n) (1) the ninth day of the month/(2) nine days/
Ａ [エー] /(n) A/a/
Ａ．Ｄ． [エーディー] /(n) AD (Anno Domini)/
ＡＡ会議 [エーエーかいぎ] /(n) Afro-Asian Conference (1955)/
ＡＢＣ順 [エービーシーじゅん] /(n) alphabetical order/
ＡＢＯ式血液型 [エービーオーしきけつえきがた] /(n) ABO blood type/
ＡＢ型 [エービーがた] /(n) type AB (blood, etc.)/
ＡＣ [エーシー] /(n) adult children/
ＡＣＬ [エーシーエル] /(n) (comp) ACL/
ＡＣＭ [エーシーエム] /(n) (comp) ACM/
ＡＣＯＳ [エーコス] /(n) (comp) ACOS/
ＡＣＲＳ [エーシーアールエス] /(n) Advisory Committee on Reactor Safeguards/ACRS/
ＡＤ [エーディー] /(n) AD (Anno Domini)/
ＡＤＥＳＳ [アデス] /(n) Automated Data Editing and Switching System/ADESS/
ＡＤＨＤ [エーディーエッチディー] /(n) attention-deficit hyperactivity disorder/ADHD/
ＡＤＰ [エーディーピー] /(n) adenosine diphosphate/ADP/
ＡＤＳＬ [エーディーエスエル] /(n) (comp) asymmetric digital subscriber line/ADSL/
ＡＧＲ [エージーアール] /(n) advanced gas-cooled reactor/AGR/
ＡＩ [エーアイ] /(n) artificial intelligence/AI/
ＡＩＤＳ [エイズ] /(n) (uk) acquired immune deficiency syndrome/AIDS/(P)/
ＡＩＤ人工授精 [ひはいぐうしゃかんじんこうじゅせい] /(n) artificial insemination by donor/
ＡＩＨ人工授精 [はいぐうしゃかんじんこうじゅせい] /(n) artificial insemination by sperm from husband/
ＡＫＹ [エーケイワイ] /(n) (sl) not noticing mood implicit to situations, conversations, etc./
ＡＬＤ [エイエルディー] /(n) atomic layer deposition/ALD/
ＡＬＥ [エイエルイー] /(n) atomic layer epitaxy/ALE/
ＡＬＳ [エーエルエス] /(n) (abbr) amyotrophic lateral sclerosis/ALS/
ＡＬＴ [エイエルティー] /(exp) assistant language teacher (technical term used in Japan)/ALT/
ＡＭＰ [エーエムピー] /(n) adenosine monophosphate (AMP)/
ＡＯ [エーオー] /(n) admissions office/admission office/
ＡＯＣＥ [エーオーシーイー] /(n) (comp) AOCE/
ＡＯＬ [エーオーエル] /(n) (comp) AOL/
ＡＰ通信社 [エーピーつうしんしゃ] /(n) Associated Press/
ＡＳＥＡＮ [アセアン] /(n) Association of Southeast Asian Nations/ASEAN/
ＡＴＩＣＳ [アティックス] /(n) Automobile Traffic Information & Control System/ATICS/
ＡＴＭ [エーティーエム] /(n) (1) automatic teller machine/ATM/automated teller machine/(2) asynchronous transfer mode/ATM/(3) anti-tank missile/ATM/(P)/
ＡＴＰ [エーティーピー] /(n) adenosine triphosphate/ATP/
ＡＴ互換機 [エーティーごかんき] /(n) (comp) AT-compatible/
ＡＶ [アダルトビデオ] /(n) porn video (from adult video)/
ＡＶ女優 [エーヴイじょゆう] /(n) female porn star/
Ａ級戦犯 [エーきゅうせんぱん] /(n) class-A war criminal/
Ａ型 [エーがた] /(n) type A (blood, influenza, hepatitis, etc.)/
Ａ型肝炎 [エーがたかんえん] /(n) hepatitis A/
Ａ系 [エーけい] /(n,adj-no) (abbr) (sl) Akihabara style/nerdy/
Ｂ [ビー] /(n) B/b/
Ｂ．Ｃ． [ビーシー] /(n) BC (before Christ)/
Ｂ５２ [ビーごじゅうに] /(n) B-52 Stratofortress/B-52 Bomber/
ＢＢＣ [ビービーシー] /(n) British Broadcasting Corporation/BBC/
ＢＢＳ [ビービーエス] /(n) bulletin board system/BBS/
ＢＣ [ビーシー] /(n) BC (before Christ)/
ＢＣＧ [ビーシージー] /(n) Bacille Calmette-Guerin (tuberculosis vaccine)/BCG/
ＢＣＧ陽転 [ビーシージーようてん] /(n) (obsc) positive tuberculin conversion after a BCG vaccination/
ＢＣ級戦犯 [ビーシーきゅうせんぱん] /(n) class-B and class-C war criminals/
ＢＤ [ビーディー] /(n) Blu-ray Disc/BD/
ＢＤＳＭ [ビーディーエスエム] /(n) bondage, discipline & sadomasochism/BDSM/
ＢＧＭ [ビージーエム] /(n) background music/BGM/(P)/
ＢＬ [ビーエル] /(n) (1) male homosexuality/(2) bill of lading/BL/
ＢＬコミック [ビーエルコミック] /(n) (col) comic featuring male homosexuality (wasei: boys love)/
ＢＯＤ [ビーオーディー] /(n) (1) biochemical oxygen demand/BOD/(2) bandwidth-on-demand/
ＢＳＥ [ビーエスイー] /(n) bovine spongiform encephalopathy/BSE/
ＢＳＬ [ビーエスエル] /(n) biosafety level/BSL/
ＢＷＲ [ビーダブリューアール] /(n) boiling-water reactor/BWR/
Ｂａｓｅ６４ [ベースろくじゅうよん] /(n) Base64/binary data/text data encoding conversion defined by MIME/
Ｂスプライン関数 [ビースプラインかんすう] /(n) (comp) B-spline/
Ｂリンパ球 [ビーリンパきゅう] /(n) B lymphocyte/B cell/
Ｂ型 [ビーがた] /(n) type B (blood, influenza, hepatitis, etc.)/
Ｂ型肝炎 [ビーがたかんえん] /(n) hepatitis B/
Ｂ系 [ビーけい] /(n,adj-no) (sl) hip-hop culture/Black culture (esp. breakdancing culture)/
Ｂ細胞 [ビーさいぼう] /(n) B cell/B lymphocyte/
Ｂ専 [ビーせん] /(n) (sl) attraction to ugly people/
Ｂ淋巴球 [ビーリンパきゅう] /(n) B lymphocyte/B cell/
Ｃ [シー] /(n) C/c/
Ｃ＋＋言語 [シープラスプラスげんご] /(n) C++/C plus plus/
Ｃ３植物 [シーさんしょくぶつ] /(n) C3 plant (any plant, such as rice, that uses C3 carbon fixation)/
Ｃ４植物 [シーよんしょくぶつ] /(n) C4 plant (any plant, such as corn, that uses C4 carbon fixation)/
ＣＡＤ [キャド] /(n) (comp) computer-aided design/CAD/
ＣＡＩ [シーエーアイ] /(n) (comp) computer-assisted instruction/CAI/computer-aided instruction/
ＣＡＭ [キャム] /(n) (comp) computer-aided manufacturing/CAM/
ＣＡＭ植物 [カムしょくぶつ] /(n) CAM plant (any plant, such as the pineapple, that uses crassulacean acid metabolism)/
ＣＡＮＤＵ炉 [キャンドゥろ] /(n) CANDU reactor/Candu reactor/
ＣＡＴＶ [シーエーティービー] /(n) community antenna television/CATV/
ＣＡＴＶ [シーエーティーブイ] /(n) community antenna television/CATV/
ＣＡＴＶインターネット [シーエーティーブイインターネット] /(n) cable internet/
ＣＢ [シービー] /(n) (1) Citizens' Band/CB (radio)/(2) convertible bond/(3) chronic bronchitis/(4) chemical and biological (weapons)/(5) center back/(6) community business/
ＣＤ [シーディー] /(n) (1) compact disk/CD/(2) cash dispenser/(3) (negotiable) certificate of deposit/
ＣＤ−ＤＡ [シーディーディーエー] /(n) (comp) CD-DA/
ＣＤ−Ｒ [シーディーアール] /(n) (comp) CD-R/
ＣＤ−ＲＯＭ [シーディーロム] /(n) compact disk read-only memory/CD-ROM/
ＣＤＤＡ [シーディーディーエー] /(n) (comp) CD-DA/
ＣＤＲ [シーディーアール] /(n) (comp) CD-R/
ＣＤＲＯＭ [シーディーロム] /(n) compact disk read-only memory/CD-ROM/
ＣＤプレーヤー [シーディープレーヤー] /(n) CD player/(P)/
ＣＤプレイヤー [シーディープレイヤー] /(n) CD player/
ＣＤラジカセ [シーディーラジカセ] /(n) CD radio-cassette/
ＣＥＯ [シーイーオー] /(n) chief executive officer/CEO/
ＣＦ [シーエフ] /(n) commercial film/CF/
ＣＦＣ [シーエフシー] /(n) (1) chlorofluorocarbon/CFC/(2) Common Fund for Commodities/CFC/
ＣＦＩＴ [シーフィット] /(n) Controlled Flight Into Terrain/CFIT/
ＣＧ [シージー] /(n) (comp) computer graphics/CG/
ＣＧＩ [シージーアイ] /(n) (1) (comp) common gateway interface/CGI/(2) computer generated imagery/CGI/
ＣＧＳ単位系 [シージーエスたんいけい] /(n) centimetre-gram-second system of units/
ＣＩＡ [シーアイエー] /(n) Central Intelligence Agency/CIA/
ＣＩＳ [シーアイエス] /(n) (1) Commonwealth of Independent States/CIS/(2) critical incident stress/CIS/
ＣＩＳＣ [シスク] /(n) (comp) complex instruction set computer/CISC/
ＣＭ [シーエム] /(n) CM/commercial message/(P)/
ＣＮＮ [シーエヌエヌ] /(n) CNN/Cable News Network/
ＣＯＤ [シーオーディー] /(n) (1) chemical oxygen demand/COD/(2) cash on delivery/COD/
ＣＯＳＭＥＴＳ [コスメッツ] /(n) (comp) Computer System for Meteorological Services/COSMETS/
ＣＲＴ [シーアルティー] /(n) cathode-ray tube/CRT/
ＣＴ [シーティー] /(n) (comp) CT (computerized tomography)/
ＣＴＣ [シーティーシー] /(n) centralized traffic control (centralised)/CTC/
ＣＴＳ [シーティーエス] /(n) (1) (comp) computerized typesetting system (computerised)/CTS/(2) cold type system/CTS/
ＣＴスキャナー [シーティースキャナー] /(n) CT scanner/
Ｃカード [シーカード] /(n) card carried by divers to prove they are certified/
Ｃ型 [シーがた] /(n) type C (hepatitis, etc.)/
Ｃ型肝炎 [シーがたかんえん] /(n) hepatitis C/
Ｃ言語 [シーげんご] /(n) (comp) C programming language/
Ｄ [ディー] /(n) D/d/
ＤＡＴ [ダット] /(n) digital audiotape/DAT/
ＤＡＴ [ディーエーティー] /(n) digital audiotape/DAT/
ＤＢＭＳ [ディービーエムエス] /(n) (comp) database management system/DBMS/
ＤＤＩ [ディーディーアイ] /(n) dideoxyinosine/didanosine/DDI/ddI/
ＤＤＴ [ディーディーティー] /(n) dichlorodiphenyl-trichloro-ethane/DDT/
ＤＩＮ [ヂン] /(n) Deutsches Institut fuer Normung/DIN/German Institute for Standardization/
ＤＩＮＫＳ [ディンクス] /(n) dinks (double-income, no kids)/childless working couple/
ＤＩＮバルブ [ディンバルブ] /(n) DIN type scuba tank valve/
ＤＪ [ディージェー] /(n) DJ/disc jockey/
ＤＬ [ディーエル] /(n) (comp) download/
ＤＭＡ [ディーエムエー] /(n) (comp) direct memory access/DMA/
ＤＮＡ [ディーエヌエー] /(n) deoxyribonucleic acid/DNA/
ＤＮＡウイルス [ディーエヌエーウイルス] /(n) DNA virus/
ＤＮＡクローニング [ディーエヌエークローニング] /(n) DNA cloning/
ＤＮＡ鑑定 [ディーエヌエーかんてい] /(n) DNA test/
ＤＮＳ [ディーエヌエス] /(n) (comp) DNS/Domain Name System/
ＤＱＮ [ドキュン] /(n) (sl) dumb-ass (person or corporation)/
ＤＲＳ理論 [でぃーあーるえすりろん] /(n) discourse representation structure theory/
ＤＶＤ [ディーブイディー] /(n) digital versatile disc/DVD/
ＤＶＤ−Ｒ [ディーブイディーアール] /(n) DVD-R (digital versatile disc recordable)/
ＤＶＤ−ＲＡＭ [ディーブイディーラム] /(n) (comp) DVD-RAM/
ＤＶＤ−ＲＯＭ [ディーブイディーロム] /(n) (comp) DVD-ROM/
ＤＶＤＲ [ディーブイディーアール] /(n) DVD-R (digital versatile disc recordable)/
ＤＶＤＲＡＭ [ディーブイディーラム] /(n) (comp) DVD-RAM/
ＤＶＤＲＯＭ [ディーブイディーロム] /(n) (comp) DVD-ROM/
ＤＶＤオーディオ [ディーブイディーオーディオ] /(n) DVD-Audio/
ＤＶＤビデオ [ディーブイディービデオ] /(n) Digital Versatile Disc video/DVD video/
ＤＶＤプレーヤー [ディーブイディープレーヤー] /(n) DVD player/(P)/
ＤＶＤレコーダー [ディーブイディーレコーダー] /(n) DVD recorder/
ＤｏＳ攻撃 [ディーオーエスこうげき] /(n) (comp) denial-of-service (DoS) attack/
Ｄ層 [ディーそう] /(n) D layer (of the ionosphere)/
Ｅ [イー] /(n) E/e/
ＥＢＭ [イービーエム] /(n) evidence-based medicine/EBM/
ＥＢウイルス [イービーウイルス] /(n) Epstein-Barr virus/EBV/
ＥＣＣＳ [イーシーシーエス] /(n) emergency core cooling system/ECCS/
ＥＤＴＡ [イーディーティーエー] /(n) ethylenediaminetetraacetic acid/EDTA/
ＥＥＰＲＯＭ [イーイープロム] /(n) (comp) electrically erasable programmable read-only memory/EEPROM/E2PROM/
ＥＦＦ [イーエフエフ] /(n) (1) Extended Fund Facility/EFF/(2) Electronic Frontier Foundation/EFF/
ＥＲＩＣ [エリック] /(n) Educational Resources Information Center/ERIC/
ＥＳＰ [イーエスピー] /(n) extrasensory perception/ESP/
ＥＳ細胞 [イーエスさいぼう] /(n) (abbr) embryonic stem cell/
ＥＴＣ [イーティーシー] /(n) electronic toll collection system/ETC/
ＥＴＲ [イーティーアール] /(n) engineering testing reactor/ETR/
ＥＵ [イーユー] /(n) EU/European Union/
Ｅメール [イーメール] /(n) (comp) email/electronic mail/
Ｅメールアドレス [イーメールアドレス] /(n) (comp) email address/
Ｅ層 [イーそう] /(n) E layer (of the ionosphere)/
Ｆ [エフ] /(n) F/f/
ＦＢＩ [エフビーアイ] /(n) Federal Bureau of Investigation/FBI/
ＦＦＴ [エフエフティー] /(n) fast-fourier-transform/FFT/
ＦＧＭ [エフジーエム] /(n) female genital mutilation/FGM/female circumcision/female genital cutting/
ＦＭ [エフエム] /(n) FM/frequency modulation/
ＦＭチューナー [エフエムチューナー] /(n) FM tuner/
ＦＳＨ [エフエスエッチ] /(n) follicle-stimulating hormone/FSH/
ＦＴＡ [エフティーエー] /(n) (1) Free Trade Agreement/(2) free-trade area/
ＦＴＴＨ [エフティーティーエッチ] /(n) fiber to the home (fibre)/FTTH/home fiber optic cable installation/
ＦＴＴｘ [エフティーティーエックス] /(n) fiber to the x (generic term for any network architecture that uses optical fiber) (fibre)/FTTx/
Ｆナンバー [エフナンバー] /(n) f-number (photography)/
Ｆ層 [エフそう] /(n) F layer (of the ionosphere)/
Ｇ [ジー] /(n) G/g/
ＧＡＢＡ [ギャバ] /(n) gamma-aminobutyric acid (GABA)/
ＧＡＴＴ [ガット] /(n) General Agreement on Tariffs and Trade/GATT/
ＧＢ理論 [ジービーりろん] /(n) (ling) government-binding theory/government and binding theory/
ＧＤＰ [ジーディーピー] /(n) gross domestic product/GDP/
ＧＨＱ [ジーエッチキュー] /(n) General Headquarters (office of the Supreme Commander of the Allied Powers)/GHQ/
ＧＮＰ [ジーエヌピー] /(n) gross national product/GNP/
ＧＮＰデフレーター [ジーエヌピーデフレーター] /(n) GNP deflator/
ＧＯＰ [ゴップ] /(n) Grand Old Party (Republican Party of the United States)/GOP/
ＧＳＲ [ジーエスアール] /(n) galvanic skin response/GSR/
ＧＵＩ [ジーユーアイ] /(n) graphical user interface/GUI/(P)/
ＧＵＴ [ジーユーティー] /(n) grand unified theory/GUT/
ＧＷ [ジーダブリュー] /(n) golden week/
Ｇｏｏｇｌｅ八分 [グーグルはちぶ] /(n) (of a website) being delisted or censored by the Google search engine/
Ｇスポット [ジースポット] /(n) Grafenberg spot (G-spot)/
Ｇメン [ジーメン] /(n) FBI agent (lit: G-men, government men)/
Ｇ様 [ジーさま] /(n) (sl) euph. for cockroach/
Ｈ [エイチ] /(n) (1) H/h/(adj-na,n) (2) (uk) indecent/lewd/frisky/sexy/(vs) (3) (uk) to have sex/
Ｈ [エッチ] /(n) (1) H/h/(adj-na,n) (2) (uk) indecent/lewd/frisky/sexy/(vs) (3) (uk) to have sex/
ＨＣＦＣ [エッチシーエフシー] /(n) hydrochlorofluorocarbon/HCFC/
ＨＤ・ＤＶＤ [エッチディー・ディーブイディー] /(n) high-definition digital versatile disc (HD DVD, high-definition DVD)/
ＨＤＤ [エイチディーディー] /(n) (comp) hard disk drive/HDD/
ＨＤＤ [エッチディーディー] /(n) (comp) hard disk drive/HDD/
ＨＤＤＶＤ [エッチディーディーブイディー] /(n) high-definition digital versatile disc (HD DVD, high-definition DVD)/
ＨＤＳＬ [エッチディーエスエル] /(n) (comp) high-bit-rate digital subscriber line/HDSL/
ＨＦＣ [エッチエフシー] /(n) (1) hydrofluorocarbon/HFC/(2) hybrid fiber coax/HFC/
ＨＩＩ領域 [エイチツーりょういき] /(n) H II region/
ＨＩＶ [エッチアイブイ] /(n) human immunodeficiency virus/HIV/
ＨＬＡ抗原 [エッチエルエーこうげん] /(n) human leukocyte antigen/
ＨＰ [エイチピー] /(n) (1) horsepower/HP/(2) home page/(3) half-pipe (i.e. in snowboarding)/(4) HP (i.e. a 'hit point' in a role-playing game)/
ＨＰ [エッチピー] /(n) (1) horsepower/HP/(2) home page/(3) half-pipe (i.e. in snowboarding)/(4) HP (i.e. a 'hit point' in a role-playing game)/
ＨＰＶ [エッチピーブイ] /(n) human papilloma virus/HPV/
ＨＰＶ検査 [エッチピーブイけんさ] /(n) HPV test/test for human papilloma virus/
ＨＲ図 [エッチアールず] /(n) (abbr) Hertzsprung-Russel diagram/HR diagram/
ＨＴＭＬ [エッチティーエムエル] /(n) (comp) hypertext markup language/HTML/
ＨＴＴＰ [エイチティーティーピー] /(n) Hypertext Transfer Protocol/http/
ＨＴＴＰ [エッチティーティーピー] /(n) Hypertext Transfer Protocol/http/
ＨＷＲ [エッチダブリューアール] /(n) heavy-water reactor/HWR/
Ｈな映画 [エッチなえいが] /(n) pornographic film/salacious film/
Ｈビデオ [エッチビデオ] /(n) pornographic video/salacious video/
Ｉ [アイ] /(n) I/i/
ＩＣＢＭ [アイシービーエム] /(n) intercontinental ballistic missile/ICBM/
ＩＣカード [アイシーカード] /(n) IC card/smart card/
ＩＣタグ [アイシータグ] /(n) IC tag (integrated circuit tag, used as an alternative to bar codes)/
ＩＣレコーダー [アイシーレコーダー] /(n) IC recorder/
ＩＤ [アイディー] /(n) identification/ID/identity/
ＩＤカード [アイディーカード] /(n) ID card/identification card/
ＩＤ番号 [アイディーばんごう] /(n) ID number/
ＩＥＥＥ [アイイーイーイー] /(n) Institute of Electrical and Electronics Engineers/IEEE/
ＩＥＥＥ [アイトリプルイー] /(n) Institute of Electrical and Electronics Engineers/IEEE/
ＩＨ調理器 [アイエッチちょうりき] /(n) induction cooker/
ＩＭ [アイエム] /(n) (1) instant messaging (messenger, message)/IM/(2) (comp) input method/IM/
ＩＭＯ [アイエムオー] /(n) (1) International Mathematical Olympiad/IMO/(2) International Maritime Organization/IMO/(3) International Meteorological Organization/IMO/
ＩＮＡＨ [アイナ] /(n) isonicotinic acid hydrazide/INAH/
ＩＯ [アイオー] /(n) (comp) input-output/
ＩＰ [アイピー] /(n) Internet Protocol/IP/
ＩＰＣＣ [アイピーシーシー] /(n) Intergovernmental Panel on Climate Change/IPCC/
ＩＰアドレス [アイピーアドレス] /(n) Internet Protocol address/IP address/
ＩＰ電話 [アイピーでんわ] /(n) voice over IP (VoIP)/Internet protocol telephony/IP telephony/Internet telephony/
ＩＲＢＭ [アイアールビーエム] /(n) intermediate-range ballistic missile/IRBM/
ＩＳＤＮ [アイエスディーエン] /(n) integrated services digital network/ISDN/
ＩＳＰ [アイエスピー] /(n) Internet Service Provider/ISP/
ＩＴ [アイティー] /(n) (comp) information technology/IT/
ＩＴＵ勧告 [アイティーユーかんこく] /(n) (comp) ITU Recommendation/
Ｉノード [アイノード] /(n) (comp) i-node (Unix)/
Ｊ [ジェー] /(n) J/j/
ＪＡＳ [ジャス] /(n) Japanese Agricultural Standard/JAS/
ＪＡＳＤＡＱ [ジャスダック] /(n) Japanese Association Of Securities Dealers Automated Quotations (JASDAQ)/
ＪＡＳＤＡＱ市場 [ジャスダックいちば] /(n) JASDAQ market/
ＪＡＳＲＡＣ [ジャスラック] /(n) Japanese Society for Rights of Authors, Composers and Publishers/JASRAC/
ＪＡＳマーク [ジャスマーク] /(n) JAS mark/
ＪＥＴＲＯ [ジェトロ] /(n) Japanese External Trade Organization (Organisation)/JETRO/
ＪＩＳ [ジス] /(n) (comp) Japanese Industrial Standard/JIS/
ＪＭＴＲ [ジェーエムティーアール] /(n) Japan Material Test Reactor/JMTR/
ＪＰＤＲ [ジェーピーディーアール] /(n) Japan Power Demonstration Reactor/JPDR/
ＪＲ [ジェーアール] /(n) Japan Railways/JR/(P)/
Ｊカーブ効果 [ジェーカーブこうか] /(n) J-curve effect/
Ｋ [ケー] /(n) K/k/
Ｋ−１ [ケイワン] /(n) K-1 (Japanese kick-boxing promotion)/
Ｋ−Ｔ境界 [ケイーティーきょうかい] /(n) K-T boundary (between the Cretaceous Period and the Tertiary Period)/
ＫＧＢ [カーゲーベー] /(n) KGB (former Soviet Union intelligency agency) (rus: Komitet Gosudarstvennoi Bezopasnosti)/
ＫＧＢ [ケージービー] /(n) KGB (former Soviet Union intelligency agency) (rus: Komitet Gosudarstvennoi Bezopasnosti)/
ＫＫＫ [ケーケーケー] /(n) (abbr) Ku Klux Klan/KKK/
ＫＴ境界 [ケイティーきょうかい] /(n) K-T boundary (between the Cretaceous Period and the Tertiary Period)/
ＫＹ [ケーワイ] /(n) being unable to read the situation/
ＫＹ [ケイーワイ] /(n) being unable to read the situation/
Ｋ粒子 [ケーりゅうし] /(n) K-meson/kaon/
Ｌ [エル] /(n) L/l/
ＬＡＮ [ラン] /(n) (comp) local area network/LAN/
ＬＡＮエミュレーション [ランエミュレーション] /(n) (comp) LAN emulation/
ＬＡＰ [ラップ] /(n) link access protocol/LAP/
ＬＣＤ [エルシーディー] /(n) liquid crystal display/LCD/
ＬＤＬ [エルディーエル] /(n) Low-density lipoprotein/LDL/
ＬＥＤ [エルイーディー] /(n) light-emitting diode/LED/
ＬＦＧ [エルエフジー] /(n) (ling) lexical-functional grammar/LFG/
ＬＬ [エルエル] /(n) language laboratory/LL/
ＬＬＣ [エルエルシー] /(n) (1) (comp) logical link control/LLC/(2) long-life coolant/LLC/
ＬＯＣＡ [ロカ] /(n) loss-of-coolant accident/LOCA/
ＬＰＥ [エルピーイー] /(n) liquid phase epitaxy/LPE/
ＬＰＳ [エルピーエス] /(n) lipopolysaccharide/LPS/
ＬＳＤ [エルエスディー] /(n) lysergic acid diethylamide/LSD/
ＬＷＲ [エルダブリューアール] /(n) light-water reactor/LWR/
Ｍ [エム] /(n) (1) (abbr) letter 'M'/(2) Mega/(3) (col) masochist/masochistic/
ＭＢＥ [エムビーイー] /(n) molecular beam epitaxy/MBE/
ＭＥＴＩ [メティ] /(n) Ministry of Economy, Trade and Industry/METI/
ＭＩＤＩ [ミディ] /(n) musical instrument digital interface/MIDI/
ＭＩＤＩ [ミディー] /(n) musical instrument digital interface/MIDI/
ＭＩＭＥ [マイム] /(n) (comp) Multipurpose Internet Mail Extension/MIME/
ＭＩＳ [エムアイエス] /(n) management information system (MIS)/
ＭＩＳ [ミス] /(n) management information system (MIS)/
ＭＭＲワクチン [エムエムアールワクチン] /(n) MMR vaccine (for measles, mumps and rubella)/
ＭＮＰ [エムエヌピー] /(n) mobile number portability/MNP/
ＭＮ式血液型 [エムエヌしきけつえきがた] /(n) MN blood type/
ＭＯＤチップ [モッドチップ] /(n) mod chip/
ＭＯＸ燃料 [モックスねんりょう] /(n) mixed oxide fuel/MOX fuel/
ＭＰ３ [エムピースリー] /(n) (comp) MP3/(P)/
ＭＰ３プレーヤー [エムピースリープレーヤー] /(n) (comp) MP3 player/(P)/
ＭＲＩ [エムアールアイ] /(n) magnetic resonance imaging/MRI/
ＭＲＳＡ [エムアールエスエー] /(n) methicillin-resistant staphylococcus aureus/MRSA/
ＭＴＲ [エムティーアール] /(n) material testing reactor/MTR/
ＭｉＧ [ミグ] /(n) (uk) Mig (Russian aeroplane, airplane)/MIG/
Ｍ字開脚 [エムじかいきゃく] /(n) pornographic pose (spreading one's legs open wide with knees bent, creating the shape of the letter 'M')/
Ｍ走 [メートルそう] /(suf) -meter race (after number)/
Ｍ理論 [エムりろん] /(n) M-theory ("master theory" that unifies the five superstring theories)/
Ｎ [エヌ] /(n) N/n/
ＮＡＤ [エヌエーディー] /(n) nicotinamide adenine dinucleotide (NAD)/
ＮＡＤ [ナッド] /(n) nicotinamide adenine dinucleotide (NAD)/
ＮＡＫ [ナック] /(n) (comp) negative acknowledgement/NAK/
ＮＡＰＳ [ナプス] /(n) Numerical Analysis and Prediction System/NAPS/
ＮＡＳＡ [ナサ] /(n) National Aeronautics and Space Administration/NASA/
ＮＡＳＤＡＱ [ナスダック] /(n) National Association of Securities Dealers Automated Quotations/NASDAQ/
ＮＡＴＯ [ナトー] /(n) North Atlantic Treaty Organization (Organisation)/NATO/
ＮＤフィルタ [エヌディーフィルター] /(n) neutral-density filter/neutral filter/
ＮＥＥＴ [ニート] /(n) NEET (young people not in education, employment or training)/
ＮＧ [エヌジ] /(n,adj-na) (1) NG/no good/(2) gaffe or "blooper" in TV or movies/
ＮＧ [エヌジー] /(n,adj-na) (1) NG/no good/(2) gaffe or "blooper" in TV or movies/
ＮＨＫ [エヌエッチケー] /(n) Japan Broadcasting Corporation/Nihon Housou Kyoukai/NHK/
ＮＨＫ教育テレビ [エヌエッチケーきょういくテレビ] /(n) NHK Educational TV/
ＮＨＫ教育テレビジョン [エヌエッチケーきょういくテレビジョン] /(n) NHK Educational TV/
ＮＨＫ受信料 [エヌエッチケーじゅしんりょう] /(n) NHK fees/
ＮＩＭＢＹ [ニンビー] /(n) NIMBY (not in my back yard)/Nimby/
ＮＭＲ [エヌエムアール] /(n) nuclear magnetic resonance/NMR/
ＮＯｘ [エヌオーエックス] /(n) nitrogen oxide/NOx/
ＮＯｘ [ノックス] /(n) nitrogen oxide/NOx/
ＮＰＯ [エヌピーオー] /(n) nonprofit organization/Not-for-Profit Organization/
ＮＰＯ法 [エヌピーオーほう] /(n) the NPO Law (1998)/Law Concerning the Promotion of Specific Non-Profit Organization Activities/
ＮＰＯ法人 [エヌピーオーほうじん] /(n) incorporated nonprofit organization/
ＮＰＳ [エヌピーエス] /(n) nuclear power station/NPS/
ＮＲＣ [エヌアールシー] /(n) (1) Nuclear Regulatory Commission/NRC/(2) National Research Council/NRC/
ＮＴＴ [エヌティーティー] /(n) Nippon Telegraph and Telephone Corporation/NTT/
ＮＵＬＬＰＯ [なるぽ] /(n) (uk) (sl) null pointer exception (in the Java programming language)/
ＮＵＬＬＰＯ [ぬるぽ] /(n) (uk) (sl) null pointer exception (in the Java programming language)/
ＮＵＬＬＰＯ [ナルポ] /(n) (uk) (sl) null pointer exception (in the Java programming language)/
ＮＵＬＬＰＯ [ヌルポ] /(n) (uk) (sl) null pointer exception (in the Java programming language)/
ＮａＫ [ナク] /(n) NaK (sodium-potassium alloy)/
ＮａＫ [ナック] /(n) NaK (sodium-potassium alloy)/
ＮａＮ [エヌエーエヌ] /(n) (comp) not a number/NaN/
ＮａＮ [ナン] /(n) (comp) not a number/NaN/
Ｎ響 [エヌきょう] /(n) (abbr) NHK Symphony Orchestra/
Ｏ [オー] /(n) O/o/
ＯＡ [オーエー] /(n) office automation/OA/
ＯＢ [オービー] /(n) (1) old boy/OB/(2) out-of-bounds/
ＯＥＭ [オーイーエム] /(n) (comp) original equipment manufacturer/OEM/
ＯＧ [オージー] /(n) (1) old girl/former female student/(2) office girl/
ＯＫ [オーケー] /(n) (col) OK/
ＯＫ [オッケー] /(n) (col) OK/
ＯＬ [オーエル] /(n) (abbr) (sens) OL/office lady/
ＯＳ [オーエス] /(n) (comp) operating system/OS/
ＯＴＣ [オーティーシー] /(n) over-the-counter drug/
ＯＴＣ薬 [オーティーシーやく] /(n) over-the-counter drug/
ＯＶ [オーブイ] /(n) (abbr) film released direct-to-video/
ＯＶＡ [オーブイエー] /(n) (abbr) animated film released direct-to-video/
Ｏバック [オーバック] /(n) O-back/skirt with peek-a-boo hole in rump/
Ｏリング [オーリング] /(n) O-ring/loop of elastomer used as a gasket/
Ｏ型 [オーがた] /(n) type O (blood, etc.)/
Ｐ [ピー] /(n) P/p/
ＰＢＸ [ピービーエックス] /(n) Private Branch eXchange/PBX/
ＰＣ [ピーシー] /(n) (comp) PC/personal computer/
ＰＣＩ [ピーシーアイ] /(n) (comp) PCI/
ＰＣＲ法 [ピーシーアールほう] /(n) polymerase chain reaction (method) (PCR)/
ＰＤＡ [ピーディーエー] /(n) personal digital assistant/PDA/
ＰＥＲ [パー] /(n) price-earnings ratio/PER/
ＰＥＴ [ペット] /(n) (1) polyethylene terephthalate/PET/(2) positron emission tomography/PET/
ＰＥＴボトル [ペットボトル] /(n) (uk) PET bottle (clear plastic beverage bottle)/
ＰＨＳ [ピーエイチエス] /(n) personal handyphone system/PHS/
ＰＨＳ [ピーエッチエス] /(n) personal handyphone system/PHS/
ＰＫＯ [ピーケーオー] /(n) peacekeeping operations/PKO/
ＰＬ教団 [ピーエルきょうだん] /(n) Church of Perfect Liberty (religious group founded in Japan in 1924)/
ＰＭ [ピーエム] /(n) (1) (comp) (abbr) private message/PM/(n-t) (2) post-meridiem/afternoon/
ＰＲ [ピーアール] /(n) public relations/PR/
ＰＴＡ [ピーティーエー] /(n) Parent-Teacher Association/PTA/
ＰＴＳＤ [ピーティーエスディー] /(n) post-traumatic stress disorder/PTSD/
ＰＵＲＥＸ [ピューレックス] /(n) plutonium-uranium extraction/PUREX/
ＰＶ [ピーブイ] /(n) (1) promotional video/music video/(2) page view/
ＰＶＣ [ピーブイシー] /(n) polyvinyl chloride/PVC/
ＰＶＣ管 [ピーブイシーかん] /(n) (abbr) polyvinyl chloride pipe/PVC pipe/
ＰＷＲ [ピーダブリューアール] /(n) pressurized-water reactor/PWR/
Ｐタイル [ピータイル] /(n) vinyl floor tile (typically 30 cm square)/
Ｐバルブ [ピーバルブ] /(n) P-valve/urinal built into a diver's dry suit/
Ｐ波 [ピーは] /(n) P-wave (e.g. of earthquake)/primary wave/
Ｑ [キュー] /(n) Q/q/
ＱＯＬ [キューオーエル] /(n) quality of life/QOL/
ＱＲコード [キューアーコード] /(n) quick response code (2-dimensional bar code commonly used by Japanese mobile phones to link to URLs)/QR code/
ＱＲコード [キューアールコード] /(n) quick response code (2-dimensional bar code commonly used by Japanese mobile phones to link to URLs)/QR code/
ＱＴ延長症候群 [きゅうちーえんちょうしょうこうぐん] /(n) long QT syndrome/
Ｑ熱 [キューねつ] /(n) Q fever (extremely contagious bacterial disease with flu-like symptoms)/
Ｒ [アール] /(n) (1) R/r/(2) (math) radius/(3) (uk) curve/
Ｒ＆Ｄ [アールアンドディー] /(n) research and development/R&D/
ＲＡＭ [ラム] /(n) random-access memory/RAM/
ＲＡＳ [ラス] /(n) (1) remote access service/RAS/(2) reliability, availability, serviceability/RAS/
ＲＣ造 [アールシーぞう] /(n) reinforced concrete construction/
ＲＥＭ [レム] /(n) rapid eye movement/REM/
ＲＥＭ睡眠 [レムすいみん] /(n) REM sleep/
ＲＦ [アールエフ] /(n) radio frequency (RF)/
ＲＦ−ＩＤ [アールエフアイディー] /(n) RFID (radio frequency identification)/
ＲＦＩＤ [アールエフアイディー] /(n) RFID (radio frequency identification)/
ＲＦタグ [アールエフタグ] /(n) RFID tag/
ＲＩＳＣ [リスク] /(n) (comp) reduced instruction set computer/RISC/
ＲＮＡ [アールエヌエー] /(n) ribonucleic acid/RNA/
ＲＮＡウイルス [アールエヌエーウイルス] /(n) RNA virus/
ＲＯＭ [ロム] /(n) (1) read-only memory/ROM/(2) lurker (on a forum)/read-only member/
ＲＳ２３２ケーブル [アールエスにさんにケーブル] /(n) rs232 cable/
ＲＳウイルス [アールエスウイルス] /(n) RS virus (respiratory syncytial virus)/
ＲＵ４８６ [アールユーよんはちろく] /(n) RU-486 (trademarked development name of mifepristone)/RU 486/
ＲＶ [アールブイ] /(n) (1) recreational vehicle/RV/sports utility vehicle/SUV/(2) reactor vessel/(3) reentry vehicle/(4) Revised Version/RV/
ＲＶ車 [アールブイしゃ] /(n) sports utility vehicle/SUV/four wheel drive (car or minivan)/lit: recreational vehicle (RV) (usu. not camper or motor home)/
Ｒｈ因子 [アールエッチいんし] /(n) Rh factor (Rhesus factor)/
Ｒｈ式血液型 [アールエッチしきけつえきがた] /(n) Rh blood type/
Ｓ [エス] /(n) (1) (abbr) letter "S" (abbr. for sister, south, steam, etc.)/(2) (abbr) sadistic/sadist/
ＳＡＲＳ [サーズ] /(n) severe acute respiratory syndrome/SARS/
ＳＢ [エスビー] /(n) (1) store brand/(2) straight bond/(3) station break/(4) sideback/(5) social business/
ＳＣＩＤ [スキッド] /(n,adj-f) severe combined immune deficiency/severe combined immunodeficiency/SCID/
ＳＣＩＤマウス [スキッドマウス] /(n) SCID mouse (severe combined immune deficiency)/
ＳＤＳＬ [エスディーエスエル] /(n) (comp) symmetric digital subscriber line/SDSL/
ＳＤ法 [エスディーほう] /(n) semantic differential/
ＳＦ [エスエフ] /(n) SF/science fiction/
ＳＩＭカード [シムカード] /(n) SIM card/
ＳＩＭロック解除 [シムロックかいじょ] /(n) SIM unlock/SIM lock cancellation/
ＳＩＳ [シス] /(n) strategic information system (SIS)/
ＳＬ [エスエル] /(n) steam locomotive/
ＳＬＢＭ [エスエルビーエム] /(n) submarine-launched ballistic missile/SLBM/
ＳＬＥ [エスエルイー] /(n) systemic lupus erythematosus/SLE/
ＳＮＡＰ [スナップ] /(n) Systems for Nuclear Auxiliary Power/SNAP/
ＳＮＰ [エスエヌピー] /(n) (1) Scottish National Party (SNP)/
ＳＮＰ [スニップ] /(n) (1) single nucleotide polymorphism (SNP)/
ＳＮＳ [エスエヌエス] /(n) social networking service/SNS/
ＳＯＳ [エスオーエス] /(n) save our souls/SOS/
ＳＯｘ [エスオーエックス] /(n) sulfur oxide (SO, SO2, etc.)/sulphur oxide/
ＳＯｘ [ソックス] /(n) sulfur oxide (SO, SO2, etc.)/sulphur oxide/
ＳＲＣ造 [エスアールシーぞう] /(n) steel-framed reinforced concrete construction/
ＳＳ [エスエス] /(n) (1) speed-sensitive/(2) suspended solids/(3) Schutzstaffel/SS/(4) service station/(5) sporty sedan/(6) shortstop/(7) steamship/(8) secret service/
ＳＳＬ [エスエスエル] /(n) secure socket layer/SSL/
ＳＳＰＥ [エスエスピーイー] /(n) subacute sclerosing panencephalitis/SSPE/
ＳＴＯＬ [エストール] /(n) short take-off and landing/STOL/
ＳＴＯＬ [ストール] /(n) short take-off and landing/STOL/
Ｓ状結腸 [エスじょうけっちょう] /(n) sigmoid colon/
Ｓ造 [エスぞう] /(n) steel construction/
Ｓ波 [エスは] /(n) S-wave (e.g. of earthquake)/secondary wave/
Ｔ [ティー] /(n) T/t/
ＴＢ [テーベー] /(n) tuberculosis/TB/
ＴＣＡ回路 [ティーシーエーかいろ] /(n) TCA (tricarboxylic acid) cycle/
ＴＥＵ [ティーイーユー] /(n) twenty foot equivalent unit (container)/TEU/
ＴＧＶ [テジェヴェ] /(n) TGV (fre: train a grande vitesse)/high-speed train/
ＴＯＥＦＬ [トーフル] /(n) Test of English as a Foreign Language/TOEFL/
ＴＯＥＦＬ [トッフル] /(n) Test of English as a Foreign Language/TOEFL/
ＴＯＥＦＬ [トフル] /(n) Test of English as a Foreign Language/TOEFL/
ＴＯＰＩＸ [トピックス] /(n) Tokyo Stock Price Index/TOPIX/
ＴＰＯ [ティーピーオー] /(n) time, place, occasion/TPO/
ＴＳＬ [ティーエスエル] /(n) techno-superliner (high-speed Japanese cargo ship)/TSL/
Ｔシャツ [ティーシャツ] /(n) T-shirt/
Ｔバック [ティーバック] /(n) T-back/bikini thong/(P)/
Ｔリンパ球 [ティーリンパきゅう] /(n) T cell/T lymphocyte/
Ｔ細胞 [ティーさいぼう] /(n) T cell/T lymphocyte/
Ｔ字路 [ティーじろ] /(n) T junction/
Ｔ淋巴球 [ティーリンパきゅう] /(n) T cell/T lymphocyte/
Ｕ [ユー] /(n) U/u/
ＵＡ能力の登録 [ユーエーのうりょくのとうろく] /(n) (comp) UA capabilities registration/
ＵＦＯ [ユーフォー] /(n) unidentified flying object/UFO/
ＵＨＦ [ユーエッチエフ] /(n) ultrahigh frequency/UHF/
ＵＭＡ [ユーエムエー] /(n) (comp) Unlicensed Mobile Access/UMA/
ＵＭＡ [ユーマ] /(n) (abbr) unidentified mysterious animal/
ＵＮ [ユーエン] /(n) United Nations/UN/
ＵＮＥＰ [ユネップ] /(n) United Nations Environment Program/UNEP/
ＵＮＩＣＥＦ [ユニセフ] /(n) United Nations Children's Fund (formerly Children's Emergency Fund)/UNICEF/
ＵＲＬ [ユーアールエル] /(n) uniform resouce locator/URL/
ＵＳＢ [ユーエスビー] /(n) (comp) universal serial bus/USB/
ＵＳＢハブ [ユーエスビーハブ] /(n) (comp) USB hub/
ＵＳＢバスパワー [ユーエスビーバスパワー] /(n) (comp) USB bus power/
ＵＳＢメモリー [ユーエスビーメモリー] /(n) (comp) USB flash drive/USB memory stick/thumb drive/
Ｕターン [ユーターン] /(n,vs) U-turn/
Ｕボート [ユーボート] /(n) U-boat/submarine/
Ｕ字溝 [ユーじこう] /(n) U-shaped gutter/
Ｖ [ブイ] /(n) (1) V/v/(2) victory/
Ｖ [ヴィー] /(n) (1) V/v/(2) victory/
ＶＤＳＬ [ブイディーエスエル] /(n) very-high-bit-rate digital subscriber line/VDSL/
ＶＨＦ [ブイエッチエフ] /(n) very high frequency/VHF/
ＶＩＳＡカード [ビザカード] /(n) Visa (credit) card/
ＶＰＥ [ヴイピーイー] /(n) vapor-phase epitaxy/VPE/
ＶＲＥ [ブイアールイー] /(n) vancomycin-resistant enterococcus/VRE/
ＶＳ [ブイエス] /(conj) versus (vs, v.)/
ＶＴＲ [ブイティーアール] /(n) videotape recorder/VTR/
ＶＴＲ [ブイティアール] /(ik) (n) videotape recorder/VTR/
ＶＸガス [ブイエックスガス] /(n) VX gas/
Ｖサイン [ブイサイン] /(n) V-sign/hand gesture similar to the peace sign, representing victory or happiness/
Ｖシネマ [ブイシネマ] /(n) film released direct-to-video (trademark of Toei Company) (wasei: V-cinema)/
Ｖ系 [ヴィジュアルけい] /(n) visual-kei (Japanese rock indies style)/
Ｗ [ダブリュー] /(n) W/w/
ＷＡＮ [ワン] /(n) wide area network/WAN/
ＷＭＯ [ダブリューエムオー] /(n) World Meteorological Organization/WMO/
ＷＷＷ [ダブリューダブリューダブリュー] /(n) (1) world wide web/WWW/(2) World Weather Watch/WWW/
ＷＹＳＩＷＹＧ [ウィジウィグ] /(n) what you see is what you get/WYSIWYG/
Ｗ杯 [ダブルはい] /(n) World Cup (soccer)/
Ｘ [エックス] /(n) (1) X/x/(2) unknown quantity/an unknown/
ＸＭＬ [エックスエムエル] /(n) (comp) extensible markup language/XML/
ＸＯ醤 [エックスオーじゃん] /(n) XO sauce (spicy seafood sauce used primarily in Cantonese cooking)/
Ｘデー [エックスデー] /(n) (col) day in the near future when a major event is expected to occur (wasei: X-day)/
Ｘマス [エックスマス] /(n) Xmas/Christmas/
Ｘ光線 [エックスこうせん] /(n) (obsc) X-ray/
Ｘ染色体 [エックスせんしょくたい] /(n) X chromosome/
Ｘ線 [エックスせん] /(n) X-ray/(P)/
Ｘ線撮影 [エックスせんさつえい] /(n) x-ray photography/
Ｘ端末 [エックスたんまつ] /(n) (comp) Xterm/Xterminal/
Ｙ [ワイ] /(n) Y/y/
Ｙシャツ [ワイシャツ] /(n) (uk) (abbr) shirt (wasei: white shirt)/business shirt/dress shirt/(P)/
Ｙ染色体 [ワイせんしょくたい] /(n) Y chromosome/
Ｙ染色体アダム [ワイせんしょくたいアダム] /(n) Y-chromosomal Adam/
Ｚ [ゼット] /(n) Z/z/
Ｚ [ゼッド] /(n) Z/z/
ａ [エー] /(n) A/a/
ｂ [ビー] /(n) B/b/
ｂｅ動詞 [ビーどうし] /(n) (ling) the 'to be' verb/
ｃ [シー] /(n) C/c/
ｄ [ディー] /(n) D/d/
ｄｄＩ [ディーディーアイ] /(n) dideoxyinosine/didanosine/DDI/ddI/
ｅ [イー] /(n) E/e/
ｅラーニング [イーラーニング] /(n) e-learning/
ｆ [エフ] /(n) F/f/
ｇ [ジー] /(n) G/g/
ｈ [エイチ] /(n) (1) H/h/(adj-na,n) (2) (uk) indecent/lewd/frisky/sexy/(vs) (3) (uk) to have sex/
ｈ [エッチ] /(n) (1) H/h/(adj-na,n) (2) (uk) indecent/lewd/frisky/sexy/(vs) (3) (uk) to have sex/
ｈｏｇｅ [ほげ] /(n) (comp) foobar-style name for a dummy variable/
ｈｐ [エイチピー] /(n) (1) horsepower/HP/(2) harp/
ｈｐ [エッチピー] /(n) (1) horsepower/HP/(2) harp/
ｈｔｔｐ [エイチティーティーピー] /(n) Hypertext Transfer Protocol/http/
ｈｔｔｐ [エッチティーティーピー] /(n) Hypertext Transfer Protocol/http/
ｉ [アイ] /(n) I/i/
ｊ [ジェー] /(n) J/j/
ｋ [ケー] /(n) K/k/
ｌ [エル] /(n) L/l/
ｍＲＮＡ [エムアールエヌエー] /(n) messenger RNA/mRNA/
ｍｉｘｉ [ミクシ] /(n) Mixi (Japanese social networking website)/
ｍｉｘｉ疲れ [ミクシィづかれ] /(n) (sl) growing tired of the mixi community due to constant use and quitting/
ｎ [エヌ] /(n) N/n/
ｏ [オー] /(n) O/o/
ｐ [ピー] /(n) P/p/
ｐＨ [ピーエイチ] /(n) pH (measure of acidity)/concentration of hydrogen ions/
ｐＨ [ペーハー] /(n) pH (measure of acidity)/concentration of hydrogen ions/
ｑ [キュー] /(n) Q/q/
ｒ [アール] /(n) (1) R/r/(2) (math) radius/(3) (uk) curve/
ｒｅｍ [レム] /(n) rem (unit of radiation dose)/
ｔ [ティー] /(n) T/t/
ｔＲＮＡ [ティーアールエヌエー] /(n) transfer RNA/tRNA/
ｔｏ不定詞 [ツーふていし] /(n) (ling) to-infitinitive/full infinitive/
ｕ [ユー] /(n) U/u/
ｖ [ブイ] /(n) (1) V/v/(2) victory/
ｖ [ヴィー] /(n) (1) V/v/(2) victory/
ｗ [ダブリュー] /(n) W/w/
ｗｅｂ拍手 [ウェブはくしゅ] /(n) system for showing appreciation to the author of a web-site (lit: web-applause)/virtual applause/
ｘ [エックス] /(n) (1) X/x/(2) unknown quantity/an unknown/
ｘＤＳＬ [エックスディーエスエル] /(n) (comp) x digital subscriber line/xDSL/
ｘｘ [ちょめちょめ] /(n) (m-sl) blankety-blank/bleep/used in place of sensitive word (often sexually related)/
ｙ [ワイ] /(n) Y/y/
ｚ [ゼット] /(n) Z/z/
ｚ [ゼッド] /(n) Z/z/
あ /(int) (1) Ah! (expression of surprise, recollection, etc.)/Oh!/(2) Hey! (to get someone's attention)/
あーあ /(int) oh no (used as an expression of despair or when giving up)/sigh of boredom or disgust/oh boy/
あーた /(n) (sl) you (slang for anta, often used by a wife addressing her husband)/
ああ /(adv) like that (used for something or someone distant from both speaker and listener)/so/(P)/
ああいう /(exp,adj-pn) that sort of/like that/(P)/
ああいう風に [ああいうふうに] /(exp) (uk) in that way/like that/
ああいった /(exp,adj-f) that sort of/like that/
ああした /(exp,adj-pn) that sort of/like that/
ああしろこうしろ /(exp) do this, do that/dos and don'ts/
ああそうそう /(int) (1) (col) oh yes!/(2) I remember/Oh, now I remember/
ああだこうだ /(exp) this, that and the other/this and that/
ああでもないこうでもない /(exp) humming and hawing/shilly-shallying/
ああゆう /(exp,adj-pn) that sort of/like that/
ああ見えても [ああみえても] /(exp) despite appearances/
ああ言えばこう言う [ああいえばこういう] /(exp) to have a comeback (i.e. a reason, or rationalization) for every remark/
あいうえお順 [あいうえおじゅん] /(n) aiueo-order/(table) index based on the kana syllabary order/
あいきょう /(n) salted (pickled) ayu eggs baked in mother ayu/
あいさつ回り [あいさつまわり] /(n) New Year courtesy calls/
あいそ笑 [あいそわらい] /(n,vs) insincere smile/ingratiating smile/forced smile/
あいそ笑い [あいそわらい] /(n,vs) insincere smile/ingratiating smile/forced smile/
あいた /(int) Ouch!/
あいたた /(int) Ouch!/
あいたっ /(int) Ouch!/
あいた口が塞がらぬ [あいたくちがふさがらぬ] /(exp,adj-f) surprising/shocking/jaw-dropping/
あいた口も塞がらぬ [あいたくちもふさがらぬ] /(exp,adj-f) surprising/shocking/jaw-dropping/
あいつら /(n) they/(P)/
あいの子 [あいのこ] /(n) (derog) person of mixed parentage/crossbreed/Eurasian/mulatto/hybrid/
あいの手 [あいのて] /(io) (n) (1) interlude/(2) interjection/interruption/
あいまいな内容モデル [あいまいなないようモデル] /(n) (comp) ambiguous content model/
あいまい検索 [あいまいけんさく] /(n) (comp) fuzzy reference/ambiguous search/ambiguous retrieval/
あいまい制御 [あいまいせいぎょ] /(n) (comp) fuzzy control/
あいまい性 [あいまいせい] /(n) ambiguity/fuzziness/
あいまい度 [あいまいど] /(n) (comp) equivocation/
あいまい理論 [あいまいりろん] /(n) (comp) fuzzy theory/
あいまい量 [あいまいりょう] /(n) (comp) equivocation/
あいまい論理 [あいまいろんり] /(n) (comp) fuzzy logic/
あい変らず [あいかわらず] /(adv,n) as ever/as usual/the same/
あい変わらず [あいかわらず] /(adv,n) as ever/as usual/the same/
あい昧 [あいまい] /(adj-na,n) (1) vague/ambiguous/unclear/(2) (math) (comp) fuzzy/
あい路 [あいろ] /(n) defile/narrow path/bottleneck/
あうんの呼吸 [あうんのこきゅう] /(n) the harmonizing, mentally and physically, of two parties engaged in an activity/
あえか /(adj-na) (poet) delicate/gentle/fleeting/
あえぎ声 [あえぎごえ] /(n) heavy breathing/
あえ物 [あえもの] /(n) (food) chopped fish, shellfish or vegetables, dressed with (miso or other) sauce/
あおがら /(n) blue tit (Parus caeruleus)/
あおぎ見る [あおぎみる] /(v1,vt) to look upwards/to look up/
あおた /(n) blue shark (Prionace glauca, species of circumglobal requiem shark)/
あおなぎ /(n) shark (esp. the blue shark, Prionace glauca)/
あおば /(n) (obs) (former) regular (stops at every station) Touhoku-line Shinkansen/
あおばせせり /(n) (uk) blue-winged skipper butterfly/
あおり止め [あおりどめ] /(n) doorstop/
あおり立てる [あおりたてる] /(v1,vt) to flap strongly/to stir up fiercely/
あお向け [あおむけ] /(n) face up/
あかし暮らす [あかしくらす] /(v5s) to spend one's days and nights doing .../
あかの他人 [あかのたにん] /(exp,n) complete stranger/
あかまた /(n) Ryukyu odd-tooth snake (Dinodon semicarinatum)/
あかんべ /(int,n) facial gesture of pulling one's eyelid down and sticking out one's tongue/
あかんべい /(int,n) facial gesture of pulling one's eyelid down and sticking out one's tongue/
あかんべえ /(int,n) facial gesture of pulling one's eyelid down and sticking out one's tongue/
あか抜ける [あかぬける] /(v1) to refine/
あがり症 [あがりしょう] /(n) stage fright/social anxiety disorder/social phobia/
あがり性 [あがりしょう] /(n) stage fright/social anxiety disorder/social phobia/
あがり湯 [あがりゆ] /(n) clean hot bath water for rinsing/
あがり目 [あがりめ] /(n) (1) eyes slanted upward/(2) rising tendency/
あきたこまち /(n) Akitakomachi (variety of rice)/
あきまへん /(adj-na) (ksb:) no good/unacceptable/
あきれて物が言えない [あきれてものがいえない] /(exp,adj-i) utterly scandalized/
あきれ返る [あきれかえる] /(v5r,vi) to be utterly amazed/to be stunned/
あき場所 [あきばしょ] /(n) autumn (fall) (September) sumo tournament, held in Tokyo/
あくあく /(n) (uk) (on-mim) bird's chirping sound/
あくが強い [あくがつよい] /(exp,adj-i) (1) having a strong alkaline taste/harsh to the taste/(2) excessively strong-willed/fiercely individualistic/strongly idiosyncratic/
あくの強い [あくのつよい] /(adj-i) (1) harsh tasting/strongly alkaline tasting/(2) excessively strong-willed/fiercely individualistic/strongly idiosyncratic/
あくる日 [あくるひ] /(n-adv,n-t) next day/following day/
あくを取る [あくをとる] /(exp,v5r) to skim the scum from broth or liquid/to skim (a liquid)/
あく洗い [あくあらい] /(n) scouring/washing vegetables in lye/
あく促 [あくせく] /(adv-to,vs) fussily/busily/sedulously/worrying about (small things)/
あく抜き [あくぬき] /(n,vs) removal of astringent taste (e.g. by cooking)/
あぐら鼻 [あぐらばな] /(n) snub nose/flat nose with flattened nostrils/
あけおめ /(exp) (abbr) Happy New Year/
あけおめことよろ /(exp) (col) (abbr) abbreviation of "akemashite omedetou, kotoshi mo yoroshiku onegaishimasu"/
あけっ放し [あけっぱなし] /(adj-na,n) (1) leaving open/leaving ajar/(2) outspoken/frank/
あけ烏 [あけがらす] /(n) (1) daybreak sound of a crow/(2) (name of) poetry anthology/
あげくの果て [あげくのはて] /(adv,n) finally/in the end/on top of all that/
あげ間 [あげまん] /(n) (uk) (col) woman purported to bring good luck to the man she is near/
あげ物 [あげもの] /(n) (food) deep-fried food/
あこう鯛 [あこうだい] /(n) (1) (uk) Matsubara's red rockfish (Sebastes matsubarae)/(2) (food) Pacific ocean perch (Sebastes alutus)/
あごが干上がる [あごがひあがる] /(exp,v5r) to lose one's means of livelihood/to become unable to earn a living/
あごで使う [あごでつかう] /(exp,v5u) (1) to set somebody to work in an arrogant fashion/to push somebody around/to indicate by pointing one's chin/(2) (sl) to chatter/to jaw/to jabber/
あごで人を使う [あごでひとをつかう] /(exp,v5u) to set somebody to work in an arrogant fashion/to push somebody around/to indicate someone by pointing one's chin/
あさぎり型護衛艦 [あさぎりがたごえいかん] /(n) Asagiri class destroyer/
あさだ /(n) Japanese hop hornbeam/ostrya japonica/
あさひ /(n) skips-most-stations Jouetsu-line Shinkansen/
あさま山荘事件 [あさまさんそうじけん] /(n) Asama-Sanso incident (famous hostage crisis and police siege in Feb. 1972)/
あさ湯 [あさゆ] /(n) morning bath/
あさ飯 [あさはん] /(n) breakfast/
あさ飯 [あさめし] /(n) breakfast/
あざーす /(exp) (abbr) (sl) thank you/
あざーっす /(exp) (abbr) (sl) thank you/
あざとい /(adj-i) clever/sly/cunning/pushy/
あざ笑う [あざわらう] /(v5u,vt) (uk) to sneer at/to ridicule/
あしきり /(n) (arch) cutting off the leg at the knee (form of punishment in ancient China)/
あしらい /(n) treatment/reception/
あしらう /(v5u,vt) to arrange/to treat/to handle/to deal with/
あし毛 [あしげ] /(n,adj-no) grey (horse coat color)/gray/
あずま屋 [あずまや] /(n) arbor/arbour/bower/summer house/square gazebo/
あぜ道 [あぜみち] /(n) footpath between rice fields/
あそばせ言葉 [あそばせことば] /(n) polite language used by women/
あそび女 [あそびめ] /(n) (arch) prostitute/
あたご型護衛艦 [あたごがたごえいかん] /(n) Atago class destroyer/
あたふた /(adv-to) (on-mim) in a hurry/hastily/in feverish haste/
あたぼう /(adj-na) (sl) natural/reasonable/obvious/
あたり前 [あたりまえ] /(adj-na,n,adj-no) (1) natural/reasonable/obvious/(2) usual/common/ordinary/
あだ花 [あだばな] /(n) (1) non-fruit-bearing flower/(2) something that is flashy with no content/
あだ事 [あだごと] /(n) trivial matter/
あだ討ち [あだうち] /(n) vengeance/revenge/retaliation/
あだ名 [あだな] /(n,vs) nickname/
あちゃー /(int) stone the crows/blow me down/oops/uh oh/expression of annoyed surprise or shock/
あっかんべー /(int,n) facial gesture of pulling one's eyelid down and sticking out one's tongue/
あっかんべえ /(int,n) facial gesture of pulling one's eyelid down and sticking out one's tongue/
あっけらかんと /(adv) quite indifferent/looking blank/looking as though one has nothing at all to do with what is going on/
あっさり /(adv,adv-to,vs) (on-mim) easily/readily/quickly/(P)/
あっさりした /(adj-f) simple/light/easy/openhearted/(P)/
あっそ /(int) hmmmmm (lackadaisical, noncommittal reply)/
あっちゃ /(int) stone the crows/blow me down/oops/uh oh/expression of annoyed surprise or shock/
あっち行け [あっちいけ] /(exp) get away from me!/
あってなきがごとき /(exp) (1) virtually nonexistent/negligible/(2) absolutely useless/
あっての /(adj-f) which can exist solely due to the presence of/whose existence is determined entirely by/which owes everything to/(P)/
あっと /(adv) (on-mim) in a surprising way/
あっという間 [あっというま] /(exp) a blink of time (lit: the time it takes to say "Ah!")/
あっという間に [あっというまに] /(exp) just like that (lit: in the time it takes to say "Ah!")/in the twinkling of an eye/in the blink of an eye/
あっとゆう間 [あっとゆうま] /(exp) a blink of time (lit: the time it takes to say "Ah!")/
あっとゆう間に [あっとゆうまに] /(exp) just like that (lit: in the time it takes to say "Ah!")/in the twinkling of an eye/in the blink of an eye/
あっと言う間 [あっというま] /(exp) a blink of time (lit: the time it takes to say "Ah!")/
あっと言う間 [あっとゆうま] /(exp) a blink of time (lit: the time it takes to say "Ah!")/
あっと言う間に [あっというまに] /(exp) just like that (lit: in the time it takes to say "Ah!")/in the twinkling of an eye/in the blink of an eye/
あっと言う間に [あっとゆうまに] /(exp) just like that (lit: in the time it takes to say "Ah!")/in the twinkling of an eye/in the blink of an eye/
あっと言わせる [あっといわせる] /(exp,v1) to startle/to surprise/
あっぱっぱ /(n) loose-fitting summer dress/
あっぷあっぷ /(adv,n,vs) floundering and almost drowning/
あっ化 [あっか] /(n,vs,adj-no) (suffer) deterioration/growing worse/aggravation/degeneration/corruption/
あっ気 [あっけ] /(n) taken aback/dumbfounded/
あっ砕 [あっさい] /(n,vs) crushing/
あっ搾 [あっさく] /(n,vs) pressure/compression/
あっ殺 [あっさつ] /(n,vs) crushing to death/
あっ死 [あっし] /(n,vs) crushing to death/
あっ縮 [あっしゅく] /(n,vs) compression/condensation/constriction/compaction/
あっ勝 [あっしょう] /(n,vs) complete victory/
あっ制 [あっせい] /(n) oppression/tyranny/despotism/
あっ旋 [あっせん] /(n,vs) (1) kind offices/services/through the good offices of/influence/(2) intercession/mediation/
あっ倒 [あっとう] /(n,vs) overwhelm/overpower/overwhelming/
あてなき旅 [あてなきたび] /(n) journey without a destination/
あて外れ [あてはずれ] /(n,adj-na) disappointment/
あて字 [あてじ] /(n) kanji used as a phonetic symbol, instead of for the meaning/phonetic-equivalent character/substitute character/
あて先 [あてさき] /(n) address/destination/
あて先変更 [あてさきへんこう] /(n) (comp) redirection/
あて先変更の発信者による禁止 [あてさきへんこうのはっしんしゃによるきんし] /(n) (comp) redirection disallowed originator/
あて馬 [あてうま] /(n) stallion brought close to a mare to test her readiness to mate/stalking horse/spoiler/
あて名 [あてな] /(n) (addressee's) name/(recipient's) name and address/
あで姿 [あですがた] /(n) charming figure/alluring figure/
あと一歩 [あといっぽ] /(adv,adj-na) one more/another/the other/not quite/not very good/
あと口 [あとくち] /(n) (1) aftertaste/(2) later (in line or in turn, etc.)/
あどけない /(adj-i) innocent/cherubic/
あなた任せ [あなたまかせ] /(exp) leaving everything to Buddha's providence/depending on others/leaving things to others/
あなた方 [あなたがた] /(pn,adj-no) (hon) you (plural)/
あに図らんや [あにはからんや] /(exp) contrary to one's expectations/to one's surprise/
あねさん被り [あねさんかぶり] /(n) towel wrapped around a woman's head/
あの /(int) say/well/errr .../(P)/
あのー /(int) say/well/errr .../
あのう /(int) say/well/errr .../(P)/
あのさあ /(int) Excuse me .../You see/
あのね /(int) Excuse me .../You see/(P)/
あのように /(exp) in that way/like that/that way/
あの頃 [あのころ] /(exp) in those days/
あの手この手 [あのてこのて] /(exp) this way and that/(by) various means/(by) every means/
あの人 [あのひと] /(pn,adj-no) he/she/that person/
あの世 [あのよ] /(n,adj-no) the other world/world of the dead/(P)/
あの方 [あのかた] /(pn,adj-no) that gentleman (lady)/he/she/(P)/
あはは /(int) a-ha-ha (laughing loudly)/
あばよ /(conj,int) good-bye/farewell/
あばら屋 [あばらや] /(n) (1) dilapidated house/tumbledown house/hovel/miserable shack/(2) (hum) my house/my home/(3) small resting place comprising four pillars and a roof (with no walls)/
あばら家 [あばらや] /(n) (1) dilapidated house/tumbledown house/hovel/miserable shack/(2) (hum) my house/my home/(3) small resting place comprising four pillars and a roof (with no walls)/
あばら骨 [あばらぼね] /(n) (1) rib/(2) frame (of a ship)/
あば擦れ [あばずれ] /(adj-na,n) a bitch/
あふれ検査 [あふれけんさ] /(n) (comp) overflow check/
あふれ出す [あふれだす] /(v5s) to begin to overflow/to start overflowing/to pour out/
あふれ表示 [あふれひょうじ] /(n) (comp) overflow indication/
あふれ返る [あふれかえる] /(v5r) to be awash with/to teem with/to be full of/
あぶくま型護衛艦 [あぶくまがたごえいかん] /(n) Abukuma class destroyer escort/
あぶく銭 [あぶくぜに] /(n) easy money/
あぶない橋を渡る [あぶないはしをわたる] /(exp,v5r) to tread on thin ice (lit: to cross a dangerous bridge)/to go out on a limb/to walk a tightrope/to take risks/
あぶな絵 [あぶなえ] /(n) suggestive or indecent picture/
あぶみ骨 [あぶみこつ] /(n,adj-no) stapes/stirrup (bone of the ear)/
あぶらそこむつ /(n) (uk) escolar (Lepidocybium flavobrunneum)/snake mackerel/
あぶらとり紙 [あぶらとりがみ] /(n) oil-absorbent paper used cosmetically to absorb oil from (facial) skin/
あぶら身 [あぶらみ] /(n) fat meat/
あぶら虫 [あぶらむし] /(n) (1) (uk) aphid/plant louse/(2) (obsc) cockroach/(3) (obsc) Japanese house bat (Pipistrellus abramus)/(4) hanger-on/parasite/(5) (arch) visitor to a red-light district who's only there to look/
あぶり出し [あぶりだし] /(n,adj-no) invisible writing revealed by applying heat/writing done in invisible ink/
あぶり出す [あぶりだす] /(v5s,vt) to bring into the open/to reveal/to uncover (e.g. evidence)/to bring to light/
あべこべ /(adj-na,n) (on-mim) contrary/opposite/inverse/(P)/
あほんだら /(n) (ksb:) fool/oaf/airhead/
あまえん坊 [あまえんぼう] /(adj-na,n) pampered or spoiled child (spoilt)/
あましいら /(n) luvar (Luvarus imperialis, species of perciform fish closely related to the surgeonfish)/
あまに油 [あまにゆ] /(n) linseed oil/
あま噛み [あまかみ] /(n,vs) play-biting/
あま噛み [あまがみ] /(n,vs) play-biting/
あま味 [あまみ] /(n) sweetness/sugary taste/
あみ出す [あみだす] /(v5s,vt) to work out/to think out/
あめ玉 [あめだま] /(n) candy/
あめ色 [あめいろ] /(n) amber/yellowish-brown/
あや /(int) (arch) wow/whoa/
あやかし /(n) (1) ghost that appears at sea during a shipwreck/(2) something strange or suspicious/(3) idiot/fool/(4) Noh mask for roles involving dead or ghost characters/
あやかり者 [あやかりもの] /(n) lucky person/
あやす /(v5s,vt) to cuddle/to comfort/to rock/to soothe/to dandle/
あやふや /(adj-na,n) (on-mim) uncertain/vague/ambiguous/(P)/
あや取り [あやとり] /(n) (uk) cat's cradle/
あや織り [あやおり] /(n) twill (fabric)/
あら /(int) (fem) oh/ah/(P)/
あらいやだ /(exp) Oh no/Oh dear/
あらかじめ計画 [あらかじめけいかく] /(exp) advance plans/forward plans/
あらせいとう /(n) stock (botanical)/
あらぬ事 [あらぬこと] /(exp) the unthinkable/
あらまあ /(int) wow!/gee!/oh dear!/
あらまし /(adv,n) (1) outline/gist/abstract/(2) roughly/about/
あらやだ /(exp) Oh no/Oh dear/
あられ /(n) roasted mochi pieces (usu. flavoured with soy sauce, or sweetened with sugar, etc.)/
あられもない /(adj-i) (1) unladylike/unbecoming/immodest/(2) unthinkable/impossible/ridiculous/
あらん限り [あらんかぎり] /(exp,adv,adj-no) all/as much as possible/
あら塩 [あらしお] /(n) sea salt/bay salt/coarse salt/
あら塩 [あらじお] /(n) sea salt/bay salt/coarse salt/
あら捜し [あらさがし] /(n,vs) finding fault/being picky/
あら探し [あらさがし] /(n,vs) finding fault/being picky/
あら熱 [あらねつ] /(n) the heat of food just after cooking/
あら挽き [あらびき] /(adj-no) coarsely ground (e.g. coffee, grain)/minced (e.g. meat)/
あら皮 [あらかわ] /(n) bark/husk/untanned pelt/
ありあり /(adj-f,adv-to) (on-mim) distinct/clear/vivid/
ありがた味 [ありがたみ] /(n) value/worth/virtue/blessing/
ありがた迷惑 [ありがためいわく] /(adj-na,n) unwelcome favor/unwelcome favour/mixed blessing/white elephant/
ありがと /(ik) (conj,exp) Thank you/
ありき /(suf,adj-no) based on/originating from/
ありし日 [ありしひ] /(n-t) (1) days of yore/the olden days/(2) during one's lifetime/
ありなさい /(exp) please be ..../
ありはしない /(exp) doesn't even exist/
ありゃしない /(exp) doesn't even exist/
ありんす /(exp) variation of "arimasu" used by the prostitutes of the Yoshiwara red light district in the Edo period/
ありんすことば /(n) language used by the harlots of the Yoshiwara red light district during the Edo period/
あり金 [ありがね] /(n) money on hand/
あり触れた [ありふれた] /(adj-f) (uk) unsurprising/trite/commonplace/mundane/hackneyed/garden variety (of)/
あり地獄 [ありじごく] /(n) (1) ant lion larva/doodlebug/(2) ant lion larva's pit/
あり得 [ありう] /(v2a-s,vi) to be possible/to be likely/to be probable/
あり得ない [ありえない] /(adj-i) (uk) impossible/(P)/
あり得ないほど [ありえないほど] /(n) (uk) unbelievable (extent)/
あり得ない程 [ありえないほど] /(n) (uk) unbelievable (extent)/
あり得べき [ありうべき] /(adj-f) (uk) possible/probable/likely/
あり得る [ありうる] /(adj-f,exp) possible/likely/probable/
あり得る [ありえる] /(adj-f,exp) possible/likely/probable/
あり方 [ありかた] /(n) (1) the way something ought to be/(2) the (current) state of things/how things are/
あるある /(exp) Oh yeah/Of course it is so/Cheer up, that's average/It happens/It's possible/Don't worry, it happens/
あること無いこと [あることないこと] /(exp) mixture of fact and fiction/half-truths/
あるらしい /(exp) seems to be/appears to have/supposed to be/
ある意味で [あるいみで] /(exp) in a sense/in some way/to an extent/(P)/
ある意味では [あるいみでは] /(exp) in a sense/in some way/to an extent/(P)/
ある限り [あるかぎり] /(n) (1) all (there is)/(exp,n-adv) (2) as long as there is/
ある事ない事 [あることないこと] /(exp) mixture of fact and fiction/half-truths/
ある時 [あるとき] /(n) once (i.e. "once, when I was studying ..")/
ある種 [あるしゅ] /(adj-no) certain/some kind of/some sort of/of sorts/
ある人 [あるひと] /(n) someone (unspecified, but someone in particular)/a certain person/
ある程度 [あるていど] /(exp,adj-no) to some extent/to a certain extent/
ある動詞 [あるどうし] /(n) irregularly conjugating honorific verb (gozaru, etc.)/
ある日 [あるひ] /(n) one day (e.g. "one day while studying, ..")/
あれあれ /(int) whoa (used to express surprise or stupefaction)/
あれから /(conj) since then/after that/
あれだけ /(exp) to that extent/to that degree/(P)/
あれっきり /(exp) since then/
あれまあ /(exp) Good heavens!/Oh my god!/gee whiz/
あれよあれよ /(int) expression of surprise/dumbfounded/
あれ以来 [あれいらい] /(exp) since then/
あれ性 [あれしょう] /(n) dry or chapped skin/
あれ程 [あれほど] /(adv,adj-no) (uk) to that extent/(P)/
あれ肌 [あれはだ] /(n) rough skin/
あろうとなかろう /(exp) whether or not/presence or absence/
あわせ鏡 [あわせかがみ] /(n) opposite mirrors/
あわてん坊 [あわてんぼう] /(n) flustered person/hasty person/
あわや /(exp) in no time/in an instant/in the nick of time/in the twinkling of an eye/
あわよくば /(exp) if there is a chance/if possible/if circumstances permit/if things go well/if luck is on my side/
あんぐり /(adv,adj-f) open-mouthed/
あんこ /(n) daughter (in Izu Oshima dialect)/young lady/
あんこ型 [あんこがた] /(n) sumo wrestler with a big belly/
あんさん /(n) (ksb:) you/
あんじょう /(adv) (ksb:) well/
あんす /(aux-v) to be/
あんだ /(n) (rkb:) oil/
あんだーぎー /(adj-f) (1) (rkb:) deep-fried/(2) Okinawan doughnut/
あんだぎー /(adj-f) (1) (rkb:) deep-fried/(2) Okinawan doughnut/
あんだけ /(exp) to that extent/to that degree/(P)/
あんだんすー /(n) fried mixture of minced pork, miso, mirin, etc. (Okinawan dish)/
あんちょこ /(n) crib notes/key (to a diagram)/
あんな /(adj-pn) such (about something or someone distant from both speaker and listener, or about a situation unfamiliar to both speaker and listener)/so/that/sort of/(P)/
あんなに /(exp) to that extent/to that degree/
あんな風に [あんなふうに] /(exp) (uk) in that way/like that/that way/
あんね /(int) Excuse me .../You see/
あんぽ柿 [あんぽがき] /(n) partially-dried Japanese persimmon/
あんま /(adv) (ksb:) not very (with negative sentence)/not much (with negative sentence)/
あんよ /(n,vs) (1) foot (children's language)/tootsy/(2) toddle/walk/
あん肝 [あんきも] /(n) monkfish liver/goosefish liver/
あん馬 [あんば] /(n) (1) side horse/pommel horse/(2) saddled horse/
あん分 [あんぶん] /(n,vs) proportional division or distribution/
あん摩 [あんま] /(n,vs) (1) massage, esp. the Anma Japanese type of massage/(n) (2) (sens) masseur/masseuse/(P)/
あ然 [あぜん] /(adj-t,adv-to) dumbfounded/in mute amazement/
あ段 [あだん] /(n) (ling) 'a' row/
い /(prt) (fam) strengthens a question, assertion, etc./
いいか /(int) (col) Listen! (used to get someone's attention)/
いいかい /(int) (col) Listen! (used to get someone's attention)/
いいから /(exp) (col) listen up (used at start of command sentences for emphasis)/
いいぞ /(int) way to go!/attaboy!/hear, hear!/
いいとこ /(n) (1) good thing/strong point/(2) good family/prestigious school/(3) the right moment/(adj-f) (4) utter/extreme/(n-adv) (5) at (the) best/at most/
いいところ /(n) (1) good thing/strong point/(2) good family/prestigious school/(3) the right moment/(adj-f) (4) utter/extreme/(n-adv) (5) at (the) best/at most/
いいとこ取り [いいとこどり] /(n,vs) focusing on only the good points or strong points/incorporating the benefits (while ignoring the drawbacks)/picking the best of both (everything)/cherrypicking (e.g. information)/
いいとも /(exp) damn straight/no problem/sounds good/sure thing/
いいカモ /(exp) (uk) desirable prey/easy game/easy mark/easy prey/easy target/
いい加減 [いいかげん] /(adj-na) (1) (uk) irresponsible/perfunctory/careless/(2) lukewarm/half-baked/halfhearted/vague/(3) reasonable/moderate (usu. in suggestions or orders)/(adv) (4) considerably/quite/rather/pretty/(P)/
いい加減にしなさい [いいかげんにしなさい] /(exp) shape up!/act properly!/
いい加減にしろ [いいかげんにしろ] /(exp) that's enough!/cut it out!/get a life!/(P)/
いい加減にする [いいかげんにする] /(exp,vs-i) to put an end to something/to get something over with/to quit something one has been engaged in too long or to an excessive degree/
いい鴨 [いいかも] /(exp) (uk) desirable prey/easy game/easy mark/easy prey/easy target/
いい感じ [いいかんじ] /(n) pleasant feeling/good vibes/
いい顔 [いいかお] /(n) (1) big-shot/influential person/(2) happy face/smiling face/(3) sympathetic attitude/
いい気 [いいき] /(adj-na,n) easygoing/optimistic/conceited/
いい気になる [いいきになる] /(exp,v5r) to be self-complacent/to be conceited/to flatter oneself/to be full of oneself/
いい気持 [いいきもち] /(n,adj-no) good feeling/
いい気持ち [いいきもち] /(n,adj-no) good feeling/
いい気味 [いいきび] /(n,adj-na) it serves you (him) right/it's what you (he) deserves/
いい気味 [いいきみ] /(n,adj-na) it serves you (him) right/it's what you (he) deserves/
いい頃 [いいころ] /(exp) high time/about time/
いい子 [いいこ] /(n) good child/
いい子いい子 [いいこいいこ] /(n,vs) patting or stroking (pet, child, etc.)/
いい子になる [いいこになる] /(exp,v5r) to make oneself popular without any regard to others/to take all the credit to oneself/
いい子ぶる [いいこぶる] /(v5r) to act the goody-goody/to pretend to be nice/
いい事 [いいこと] /(exp,n) (1) good thing/nice thing/(2) good excuse/good grounds/good opportunity/(int) (3) (fem) interjection used to impress an idea or to urge a response/
いい人 [いいひと] /(exp) (1) good-natured person/(n) (2) lover/
いい線 [いいせん] /(exp) more or less right/you are on the right track/getting warm/
いい線いってる [いいせんいってる] /(exp,v1) (col) to be on the right track/to be close enough/
いい線を行く [いいせんをいく] /(exp,v5k-s) to be on the right track/to go well/
いい線行く [いいせんいく] /(exp,v5k-s) to be on the right track/to go well/
いい線行ってる [いいせんいってる] /(exp,v1) (col) to be on the right track/to be close enough/
いい天気 [いいてんき] /(n) fine weather/fair weather/
いい度胸 [いいどきょう] /(n,vs) some nerve (as in 'you must have some nerve to ...')/
いい年して [いいとしして] /(exp) (in spite of) being old enough to know better/
いい年をして [いいとしをして] /(exp) (in spite of) being old enough to know better/
いい薬になる [いいくすりになる] /(exp,v5r) to learn a lesson (usu. from an unpleasant experience)/to be good for someone/
いぇい /(int) yay/
いかがお過ごしですか [いかがおすごしですか] /(exp) How are things with you?/How are you doing?/
いかさま裁判 [いかさまさいばん] /(n) fake trial/kangaroo court/
いかさま師 [いかさまし] /(n) cheat/swindler/
いかす /(v5s,vi) to be smart/to be cool/to be sharp/to be stylish/
いかなる場合でも [いかなるばあいでも] /(exp) in any case/whatever the case may be/
いかり肩 [いかりがた] /(n) square shoulders/
いかれぽんち /(n) airhead (of a male)/ditz/
いかれる /(v1,vi) (1) to be beaten/to break down/(2) to be crazy/to be touched/(3) to be infatuated with/(4) to be outdone (by someone)/to be beaten (in a contest)/
いかんともし難い [いかんともしがたい] /(n) impenetrably difficult/
いがいが /(n) (1) crying of a baby/(2) tickle in the throat/
いがみ合い [いがみあい] /(n) (1) snarl/snarling/(2) quarrel/wrangling/feud/
いがみ合う [いがみあう] /(v5u,vi) to snarl/to quarrel/
いきり立つ [いきりたつ] /(v5t,vi) to get angry/to lose one's temper/
いき値 [いきち] /(n) threshold (amount, dose, etc.)/
いく /(v5k-s,vi) (X) (col) to have an orgasm/to come/to cum/
いくつかの理由から [いくつかのりゆうから] /(exp) for whatever reason/
いくない /(exp,adj-i) not good/
いく重 [いくえ] /(n) multiple layers/many piles/
いく日 [いくにち] /(n) how many days?/what day (of month)?/
いく日か [いくにちか] /(exp) some days/several days/
いく日もいく日も [いくにちもいくにちも] /(adv) day after day/for many days/
いけ /(pref) prefix used to strengthen a derogatory adjective/
いけいけ /(n) bitch/
いけしゃあしゃ /(adv) shamelessly/brazenly/
いけしゃあしゃあ /(adv,adv-to) brazenly/
いけず /(adj-na) (1) (ksb:) unkind/mean/(2) wicked/
いけぞんざい /(n,adj-na) rude/careless/slovenly/
いけ好かない [いけすかない] /(adj-i) nasty/disgusting/disagreeable/creepy/
いけ図図しい [いけずうずうしい] /(adj-i) (uk) impudent/shameless/
いけ年 [いけどし] /(n) (arch) old enough (to know better, etc.)/
いごっそう /(n) (tsb:) stubborn Kochi man/
いささ小笹 [いささおざさ] /(n) (arch) (obsc) short bamboo/small bamboo/
いささ小川 [いささおがわ] /(n) (arch) (obsc) trickling brook/
いささ川 [いささがわ] /(n) (arch) trickling brook/
いさら井 [いさらい] /(n) (arch) small water spring/
いさら小川 [いさらおがわ] /(n) (arch) (obsc) trickling brook/
いさら川 [いさらがわ] /(n) (arch) trickling brook/
いざ /(adv,int) now/come (now)/well/
いざこざ /(n) trouble/quarrel/difficulties/complication/tangle/(P)/
いざさらば /(exp) (1) (arch) well then, (shall we)/well then, (I'll)/(2) goodbye/
いざという時 [いざというとき] /(exp) when it's important/when it comes to the crunch/
いざと言う時 [いざというとき] /(exp) when it's important/when it comes to the crunch/
いざなぎ景気 [いざなぎけいき] /(n) Izanagi economic boom (1965-70) of Japan/
いざなみ景気 [いざなみけいき] /(n) period of Japanese economic expansion from February 2002 to October 2007/
いざ鎌倉 [いざかまくら] /(n) case that something major happens/event of an emergency/when it comes to the crunch/
いざ知らず [いざしらず] /(exp) I don't know about ... but/it may be possible for ... but/
いしかり型護衛艦 [いしかりがたごえいかん] /(n) Ishikari class destroyer escort/
いし海豚 [いしいるか] /(n) (uk) Dall's porpoise (Phocoenoides dalli)/
いじいじ /(adv,adv-to,vs) (1) (on-mim) reserved/timid/servile/(2) unable to be honest/perverse/
いじくり回す [いじくりまわす] /(v5s) (uk) to fiddle with/to monkey around with/
いじける /(v1,vi) (1) to grow timid (e.g. from an inferiority complex)/to lose one's nerve/(2) to become perverse/to become contrary/
いじましい /(adj-i) piddling/paltry/
いじめっ子 [いじめっこ] /(n) bully/
いじめられっ子 [いじめられっこ] /(n) bullied child/
いじらしい /(adj-i) innocent/lovable/sweet/pitiful/pathetic/
いじり回す [いじりまわす] /(v5s) to tinker with/to fumble with/to twist up/
いす取りゲーム [いすとりゲーム] /(n) musical chairs/
いずれ菖蒲か杜若 [いずれあやめかかきつばた] /(exp) equally beautiful/
いそいそ /(adv,n,vs,adv-to) (on-mim) cheerfully/excitedly/(P)/
いたし方 [いたしかた] /(n) way/method/
いたずらっ子 [いたずらっこ] /(n) (1) mischievous child/scamp/rascal/(2) elf/imp/
いたずら好き [いたずらずき] /(adj-na,adj-no) mischievous/
いたずら盛り [いたずらざかり] /(n) mischievous age/
いたずら電話 [いたずらでんわ] /(n) crank call/prank phone call/
いたずら坊主 [いたずらぼうず] /(n) mischievous boy/troublemaker/pesky kids/
いたせんぱら /(n) deepbody bitterling (species of cyprinid, Acheilognathus longipinnis)/
いたちの道 [いたちのみち] /(exp) not to write to or visit someone/road of the weasel (it is believed that if someone blocks the path a weasel, he will never take that path again)/
いたちの道切り [いたちのみちきり] /(exp) not to write to or visit someone/road of the weasel (it is believed that if someone blocks the path a weasel, he will never take that path again)/
いたみ悲しむ [いたみかなしむ] /(v5m) (obsc) to mourn/to grieve/
いちい樫 [いちいがし] /(n) (uk) Quercus gilva (species of oak)/
いちさかき /(ok) (n) (uk) Eurya japonica (species of evergreen related to sakaki)/
いちびり /(n) (osb:) prankster/joker/taking a joke to the extreme/
いちびる /(v5r,vi) (ksb:) to mess around/to get carried away/to press one's luck/
いちゃいちゃ /(adv,n,vs) flirt/make out/
いちゃつく /(v5k,vi) to flirt with/to dally/
いちゃもん /(n) quibble/false charge/
いちゃもんを付ける [いちゃもんをつける] /(exp,v1) to pick a fight/to find fault/
いち押し [いちおし] /(n) (1) recommendation/(something) highly recommended/(vs) (2) to recommend/
いち推し [いちおし] /(n) (1) recommendation/(something) highly recommended/(vs) (2) to recommend/
いち早く [いちはやく] /(adv) promptly/quickly/without delay/
いっかくじゅう座 [いっかくじゅうざ] /(n) (constellation) Monoceros/
いっけ /(pref) prefix used to strengthen a derogatory adjective/
いっそ /(adv) rather/sooner/preferably/(P)/
いっその事 [いっそのこと] /(adv) rather/sooner/preferably/(P)/
いったい何なんですか [いったいなんなんですか] /(exp) what is it exactly?/what is it precisely/
いったい全体 [いったいぜんたい] /(adv) ... the heck (e.g. "what the heck?")/... in the world (e.g. "why in the world?")/... on earth (e.g. "who on earth?")/
いって参ります [いってまいります] /(exp) So long (lit:"(I'm) going and coming back")/I'm off/see you later/
いって来ます [いってきます] /(exp) (uk) I'm off/see you later/
いって来る [いってくる] /(vk) (1) I'm off/see you later/(2) to go (and then come back)/
いっらしゃいませ /(ik) (exp) welcome (in shops, etc.)/
いつかそのうち /(exp) one of these days/before very long/in the near future/
いつの間にか [いつのまにか] /(adv) before one knows/before one becomes aware of/unnoticed/unawares/
いつの間にやら [いつのまにやら] /(n) unawares/unnoticed/before you know it/
いつの時代にも [いつのじだいにも] /(adv) in all ages/over the ages/forever and ever/
いつの時代も [いつのじだいも] /(adv) in all ages/over the ages/forever and ever/
いつの日にか [いつのひにか] /(exp) one of these days/
いつまで経っても [いつまでたっても] /(exp) no matter how much time passes/
いつもいつも /(exp) year in, year out/24-7/
いつもの通りに [いつものとおりに] /(adv) as always/
いつも通り [いつもとおり] /(ik) (adv) as always/as usual/
いつも通り [いつもどおり] /(adv) as always/as usual/
いつ何どき [いつなんどき] /(adv) (uk) at any time/every moment/
いつ何時 [いつなんどき] /(adv) (uk) at any time/every moment/
いて座 [いてざ] /(n) Sagittarius/the Archer (constellation)/
いと /(adv) greatly/really/
いとこ婚 [いとここん] /(n) marriage between cousins/
いとし子 [いとしご] /(n) beloved dear child/
いとど /(n) (1) old name for a cave cricket/(2) even though/despite/even more/still/
いとはん /(n) (ksb:) daughter (of a good family)/
いとも /(adv) extremely/
いとも簡単に [いともかんたんに] /(adv) very easily/
いないいないばあ /(n) peekaboo (baby game)/peepbo/
いなか者 [いなかもの] /(n,adj-no) countryman/provincial/person from the country/provincial person/bumpkin/hick/hillbilly/
いなくなった /(exp) gone/left/
いなくなる /(exp) to disappear/to stop being/to leave/
いなだ /(n) young Japanese amberjack/
いのころ草 [いのころぐさ] /(n) spike-eared grass/
いのちの電話 [いのちのでんわ] /(n) telephone counselling service/
いのちを捨てる [いのちをすてる] /(exp,v1) to give one's life/to lay down one's life/
いの一番 [いのいちばん] /(exp) first of all/first thing/
いばらの道 [いばらのみち] /(n) thorny path/
いばら姫 [いばらひめ] /(n) Sleeping Beauty/Thorn Princess/Briar Rose/
いばりんぼ /(n) (col) boaster/
いびり出す [いびりだす] /(v5s) to drive someone out/to force someone to leave/
いびる /(v5r,vt) to pick on/to tease/
いぶし銀 [いぶしぎん] /(n) (1) oxidized silver/oxidised silver/(2) refined (aesthetic) taste/
いぶり出す [いぶりだす] /(v5s,vt) to smoke animal out of its den/
いぼた /(n) (uk) Ligustrum japonicum/
いま一つ [いまひとつ] /(adj-na,adv) (1) (uk) (col) one more/another/the other/(2) not quite/not very good/lacking/
いま一歩 [いまいっぽ] /(n,adv) (1) one more/another/the other/not quite/(2) close run/just falling short of success/
いみじくも /(adv) admirably/exquisitely/aptly/
いめいめしい /(adj-i) (obsc) annoying/
いもち病 [いもちびょう] /(n) rice blight/rice blast/
いもづる式 [いもづるしき] /(adv) one after another/in succession/
いもづる接続 [いもづるせつぞく] /(n) (comp) daisy chain connection/
いも虫 [いもむし] /(n) hornworm (caterpillar of a hawk moth)/(hairless) caterpillar/
いやが上に [いやがうえに] /(exp,adv) even more/all the more/
いやが上にも [いやがうえにも] /(adv) all the more/
いやだ /(int) not a chance/not likely/no way/(P)/
いやはや /(int) (Oh) dear!/(Oh) dear me!/Good gracious/
いや増す [いやます] /(v5s,vi) to increase (all the more)/
いよいよという時 [いよいよというとき] /(exp) (at the) last moment/(in the) nick of time/
いよいよと言う時 [いよいよというとき] /(exp) (at the) last moment/(in the) nick of time/
いようが /(exp) (following te-form verb) regardless of/whether (or not)/
いよやか /(adj-na) tall/stout/clear/well defined/
いらか段 [いらかだん] /(n) corbie-step/corbel gable/crowsteps/
いらしてください /(exp) please come (and visit us)/please come (to our shop)/
いらしゃい /(ik) (int,n) (1) (hon) (used as a polite imperative) come/go/stay/(2) welcome!/
いらしゃいませ /(ik) (exp) welcome (in shops, etc.)/
いらっしゃい /(int,n) (1) (hon) (used as a polite imperative) come/go/stay/(2) welcome!/(P)/
いらっしゃいませ /(exp) welcome (in shops, etc.)/(P)/
いらっしゃってください /(exp) (pol) please come (and visit us)/please come (to our shop)/
いらっしゃる /(v5aru,vi) (1) (hon) to come/to go/to be (somewhere)/(aux-v) (2) (after a -te form, or the particle "de") is (doing)/are (doing)/(P)/
いられないくらい /(exp) almost not able (to do something)/
いら立たしい [いらだたしい] /(adj-i) irritating/frustrating/
いら立ち [いらだち] /(n) irritation/
いら立つ [いらだつ] /(v5t) to be irritated/
いりがしら /(n) kanji "enter" radical at top (radical 11)/
いりやね /(n) kanji "enter" radical at top (radical 11)/
いるか座 [いるかざ] /(n) Delphinus/the Dolphin (constellation)/
いろは歌 [いろはうた] /(n) iroha poem/
いろは順 [いろはじゅん] /(n) Traditional ordering of Japanese syllabary based on a Buddhist poem/
いわし雲 [いわしぐも] /(n) cirro-cumulus/mackerel sky/
いを汲む [いをくむ] /(exp,v5m) to enter into a person's feelings/to guess what somebody feels (using one's intuition)/
いを用いる [いをもちいる] /(exp,v1) to pay attention to/
いんげん豆 [いんげんまめ] /(n) kidney bean/wax bean/
いんちき /(adj-na,n,vs) (1) cheating/fake/bogus/(2) travelling seller of trinkets, magic tricks, etc. (traveling)/
いん石 [いんせき] /(n) meteorite/
い辛っぽい [いがらっぽい] /(adj-i) (uk) acrid/pungent/irritating/
い段 [いだん] /(n) (ling) 'i' row/
うーん /(int) hmm/well/
ういっす /(int) (col) Hi/
ううむ /(int) erm/hurm/
ううん /(int) (1) no/(2) er, well, .../(3) groan/(P)/
うお座 [うおざ] /(n,adj-no) (1) (constellation) Pisces/the Fish/the Fishes/(2) (arch) fishmongers' guild/
うお氷に上る [うおこおりにのぼる] /(exp) third climate of spring (when the ice breaks and fish start appearing near the surface)/
うお氷に上る [うおひにのぼる] /(exp) third climate of spring (when the ice breaks and fish start appearing near the surface)/
うかうか /(adv,adv-to) (on-mim) carelessly/inattentively/
うかび出る [うかびでる] /(v1,vi) to surface/
うかれ歩く [うかれあるく] /(v5k,vi) to gad around/
うがい薬 [うがいぐすり] /(n) mouthwash/
うがん /(n) (Okinawa) sacred place/sacred grove/
うぐいす色 [うぐいすいろ] /(n) greenish brown/
うぐいす張り [うぐいすばり] /(n) nightingale (flooring)/method of laying floors to deliberately make a noise (like a nightingale's call) when walked across (security feature)/
うぐいす餅 [うぐいすもち] /(n) mochi filled with red bean paste and topped with green soy flour/
うけ取る [うけとる] /(v5r,vt) (1) to receive/to get/to accept/(2) to take/to interpret/to understand/
うさぎ座 [うさぎざ] /(n) Lepus/the Hare (constellation)/
うざい /(adj-i) (1) (col) annoying/noisy/(2) strict/
うざがる /(exp,v5r) to behave annoyed/to feel annoyed/
うざっこい /(adj-i) jumbled up/confused/frustrating/
うざったい /(adj-i) (1) (col) annoying/noisy/(2) strict/
うしかい座 [うしかいざ] /(n) Bootes/the Herdsman (constellation)/
うしろ手 [うしろで] /(n) (1) hands behind one's back/hands tied behind one's back/(2) behind (e.g. someone)/rear/back/(3) appearance from behind/
うじうじ /(adv,n,vs) (on-mim) irresolute/hesitant/
うじゃうじゃ /(adv,n,vs) in swarms/
うす口 [うすくち] /(n) light (flavor, flavour)/
うず /(aux-v) (1) (arch) will probably be/(2) intending to/will/(3) should/
うずうず /(n,adv,vs) (on-mim) sorely tempted/itching to do something/(P)/
うずまき線 [うずまきせん] /(n) spiral/
うずら豆 [うずらまめ] /(n) pinto bean/mottled kidney bean/
うず巻く [うずまく] /(v5k,vi) to whirl/to eddy/to swirl/to curl (smoke)/
うず形式 [うずけいしき] /(n) vortex design/
うそも方便 [うそもほうべん] /(exp) the end justifies the means/circumstances may justify a lie/
うそやん /(exp) (osb:) You're kidding!/
うそ寒い [うそさむい] /(adj-i) somewhat cold/a bit chilly/
うそ泣き [うそなき] /(n,vs) faking crying/crocodile tears/
うぞうぞ /(adv) (on-mim) fearfully/gingerly/
うたた寝 [うたたね] /(n,vs) dozing/napping (e.g. on the floor in one's clothes, in the train)/
うた沢 [うたざわ] /(n) slow-paced style of shamisen music with vocal accompaniment (popular during the late Edo period)/
うた沢節 [うたざわぶし] /(n) slow-paced style of shamisen music with vocal accompaniment (popular during the late Edo period)/
うだうだ /(adv) (on-mim) idle/long-winded and meaningless/
うだつが上がらない [うだつがあがらない] /(exp) no hope of getting ahead/
うだつの上がらない [うだつのあがらない] /(exp,adj-i) lacking potential for advancement/no-hoper/
うちの者 [うちのもの] /(n) a member of one's "in group" (e.g. one's family, employees, etc.)/
うちの人 [うちのひと] /(n) my husband/one's family/
うちの奴 [うちのやつ] /(n) my wife/"the wife"/
うちわやんま /(n) (uk) Sinictinogomphus clavatus (species of clubtail dragonfly)/
うち捨てる [うちすてる] /(v1,vt) to throw away/to abandon/
うち続く [うちつづく] /(v5k,vi) to continue for a long time/to undergo a repeated series/
うち破る [うちやぶる] /(v5r,vt) to break/to smash/to defeat/to destroy/to eliminate/
うち連れる [うちつれる] /(v1,vi) to go along with/
うっかり /(adv,n,vs) carelessly/thoughtlessly/inadvertently/(P)/
うっかりミス /(n) honest mistake/
うって変わる [うってかわる] /(v5r) to change suddenly/
うっとり /(adv,adv-to) (1) ecstatically/spellbound/with rapt attention/(2) abstractedly/absentmindedly/absorbedly/vacantly/
うっとりさせる /(v1) to enchant/to enrapture/to enthrall (enthral)/to charm/
うっとりする /(exp,vs-i) (1) to be entranced/to be enraptured/to be transported/to be fascinated/(2) to be absentminded/to be miles away/to be in a world of one's own/
うっとりとする /(exp,vs-i) (1) to be entranced/to be enraptured/to be transported/to be fascinated/(2) to be absentminded/to be miles away/to be in a world of one's own/
うっぷ /(n) (on-mim) burp/belch/
うっ血 [うっけつ] /(n,vs) (1) blood congestion/(suf) (2) -stasis/
うっ血性心不全 [うっけつせいしんふぜん] /(n) congestive heart failure/CHF/
うっ滞 [うったい] /(n,adj-no,vs) (uk) congestion/pent-up feelings/
うつつを抜かす [うつつをぬかす] /(exp,v5s) to be infatuated/to be hooked on/
うつぼ /(n) (uk) moray (eel) (Gymnothorax kidako)/muraenid/
うつらうつら /(adv) drowsily/nodding off/
うつ向く [うつむく] /(v5k) to hang one's head in shame/to look downward/to cast one's eyes down/
うつ状態 [うつじょうたい] /(n,adj-no) depression/manic depression/
うつ病 [うつびょう] /(n) melancholia/depression/
うつ伏す [うつぶす] /(v5s) (1) to lie with one's face on the ground/(2) (arch) to lower (one's head, gaze, etc.)/
うつ伏せる [うつぶせる] /(v1,vt) to lie face-down/
うとうと /(adv,n,vs,adv-to) (on-mim) falling in a doze/dozing/(P)/
うとっと /(adv,n,vs,adv-to) (on-mim) falling in a doze/dozing/
うどの大木 [うどのたいぼく] /(exp) good for nothing (of people)/derived from a large 'udo' plant being of no use (only the young, tender, plant can be eaten)/
うどんこ病 [うどんこびょう] /(n) powdery mildew/
うどん粉 [うどんこ] /(n) udon flour (wheat flour)/
うながっぱ /(n) type of maki sushi typically made from eel and cucumber/
うなぎ屋 [うなぎや] /(n) eel restaurant/
うなぎ昇り [うなぎのぼり] /(n,adj-no) rapid promotion/soaring/going through the roof/
うなぎ上り [うなぎのぼり] /(n,adj-no) rapid promotion/soaring/going through the roof/
うなぎ登り [うなぎのぼり] /(n,adj-no) rapid promotion/soaring/going through the roof/
うなぎ丼 [うなぎどんぶり] /(n) bowl of eel and rice (donburi)/
うなり出す [うなりだす] /(v5s) to let out a roar (hum, groan, moan)/to produce a loud noise/
うなり声 [うなりごえ] /(n) (1) roar/growl/(2) groan/moan/
うな重 [うなじゅう] /(n) broiled eel served over rice a lacquered box/
うな丼 [うなどん] /(n) bowl of eel and rice (donburi)/
うねうね /(adv,n,vs) (on-mim) winding/meandering/zigzag/sinuous/tortuous/
うはうは /(exp) exhilarated/all smiles/
うば車 [うばぐるま] /(n) baby carriage/perambulator/
うふふ /(adv) chuckling/giggling/
うぶ毛 [うぶげ] /(n) (1) soft, downy hair (i.e. such as on one's cheek)/peach fuzz/fluff/pappus/(2) lanugo/(adj-no) (3) lanuginous/pappose/pappous/
うまい菜 [うまいな] /(n) (osb:) Swiss chard/
うまい汁を吸う [うまいしるをすう] /(exp,v5u) to be onto a good thing/to make money without working/to line one's pockets/
うまい棒 [うまいぼう] /(n) Umaibo/small, puffed, cylindrical corn snack (trademarked)/
うまい話 [うまいはなし] /(n) too good to be true stories (offers) (e.g. scams and frauds)/
うまくやって行く [うまくやっていく] /(exp,v5k-s) to get along well with/to make a go of it/
うまく行かない [うまくいかない] /(exp,adj-i) unsuccessful/going badly/
うまく行く [うまくいく] /(v5k-s) to go smoothly/to turn out well/to do the trick/to have peaceful relations/(P)/
うま味 [うまみ] /(n) (1) good flavor (flavour)/good taste/deliciousness/(2) umami (fifth category of taste, corresponding to the flavour of glutamates)/(3) skill/(4) profit/
うま味調味料 [うまみちょうみりょう] /(n) flavour enhancer (e.g. MSG)/flavor enhancer/
うみたなご /(n) (uk) sea chub (Ditrema temminckii temminckii)/
うみへび座 [うみへびざ] /(n) Hydra (constellation)/
うみ葡萄 [うみぶどう] /(n) sea grapes (Caulerpa lentillifera)/
うむ /(int) (arch) yea/uh huh/
うめき声 [うめきごえ] /(n) groan/moan/moaning/
うようよ /(adv,vs) (on-mim) in swarms/crawling with/
うらうら /(adv-to) (on-mim) gently and clearly shining (like the sun in springtime)/
うらぶれる /(v1,vi) to get shabby/to go downhill/to go to seed/to go to the dogs/
うら枯れる [うらがれる] /(v1,vi) to die (esp. foliage as winter approaches)/
うら若い [うらわかい] /(adj-i) young/youthful/
うら寂しい [うらさびしい] /(adj-i) lonesome/lonely/forlorn/
うら恥ずかしい [うらはずかしい] /(adj-i) slightly ashamed/rather shy/
うら悲しい [うらがなしい] /(adj-i) sad/mournful/melancholy/sorrowful/
うりずん /(n) climate of the third month of the lunar calendar in Okinawa (end of the dry season)/early summer/
うり二つ [うりふたつ] /(adj-na) as alike as two melons (two peas in a pod)/
うるう年 [うるうどし] /(n,adj-no) (uk) leap year/
うるき星 [うるきぼし] /(n) Chinese "Girl" constellation (one of the 28 mansions)/
うるさ型 [うるさがた] /(n) fastidiousness/faultfinding/nit-picking/
うるさ方 [うるさがた] /(iK) (n) fastidiousness/faultfinding/nit-picking/
うるめぶし /(n) finely chopped round herring/
うれしい悲鳴 [うれしいひめい] /(exp,n) shriek of delight/cry of joy/
うれし泣き [うれしなき] /(n,vs) weeping for joy/crying with happiness/
うろうろ /(adv,n,vs) (on-mim) loiteringly/aimless wandering/(P)/
うろこ引き [うろこひき] /(n) fish scaler/
うろちょろ /(n,vs) loitering/hanging around/wandering around/
うろつき回る [うろつきまわる] /(v5r) to rove/to prowl/to go cruising/
うろ覚え [うろおぼえ] /(n) (1) vague recollection/faint memory/
うろ抜く [うろぬく] /(v5k,vt) to thin out (e.g. seedlings)/
うわ /(int) Wow!/Holy smokes!/Aaargh!/O my God!/
うわー /(int) Wow!/Holy smokes!/Aaargh!/O my God!/
うわあ /(int) Wow!/Holy smokes!/Aaargh!/O my God!/
うわさを聞く [うわさをきく] /(exp,v5k) to hear a rumor/to get wind of/
うわさ話 [うわさばなし] /(n,vs) gossip/
うわの空 [うわのそら] /(adj-na,n) inattention/absent-mindedness/
うわ気 [うわき] /(n,adj-na,vs) (1) (sens) extramarital sex/affair/fooling around/(2) infidelity/wantonness/unfaithfulness/inconstancy/fickleness/caprice/
うわ言 [うわごと] /(n) (uk) talking in delirium/incoherent muttering/
うん /(int) (1) yeah/uh huh/(n-pref) (2) some (at the start of a number in place of a digit)/(P)/
うんうん /(int) uh-huh/sound indicating agreement/grunting or groaning sound/
うんこ /(n,vs) (col) shit/faeces/feces/(P)/
うんざり /(adv,n,vs) tedious/boring/being fed up with/(P)/
うんしょっと /(int) omigosh/crikey/
うんたら /(n) mumble (used in place of meaningful words in a sentence)/
うんたらかんたら /(n) something-something (phrase used in place of meaningful words in a sentence)/
うんち /(n,vs) (col) shit/faeces/feces/(P)/
うんちゃらかんちゃら /(exp) something-something ('fill in the blank' type phrase)/
うんと /(adv) (1) (on-mim) a great deal/very much/a lot/(2) with a great amount of effort/
うんとこさ /(n) (1) grunt of effort/oof/(2) a lot/plenty/
うんとこしょ /(n) yell made when starting to move something/grunt/
うんともすんとも /(exp,adv) (followed by a negative verb form) not uttering a single word/not giving even the slightest response/
うんともすんとも言わない [うんともすんともいわない] /(exp,adj-i) keeping silent/saying nothing at all/
うん蓄 [うんちく] /(n,vs) one's vast stock of knowledge/
うん蓄を傾ける [うんちくをかたむける] /(exp,v1) (obs) to draw upon one's profound knowledge/
うん薹 [うんたい] /(n) rape (seed oil plant, Brassica campestris)/Chinese colza/yuntai/
うん薹 [うんだい] /(n) rape (seed oil plant, Brassica campestris)/Chinese colza/yuntai/
う蝕 [うしょく] /(n) tooth decay/dental caries/
う段 [うだん] /(n) (ling) 'u' row/
え /(int) (1) eh? (surprise)/(2) eh (agreement)/(prt) (3) (arch) strengthens a question, assertion, etc./(4) (after a noun) used when calling out to someone/
えいえいおう /(int) hurray/hurrah/
えいや /(int) go for it/heave/ugh/
えいやっ /(int) go for it/heave/ugh/
えい航 [えいこう] /(n,vs) towing (a ship)/
ええ /(int) (1) yes/that is correct/right/(2) um/errr/(3) huh?/(4) grrr/gah/Must I?/(adj-f) (5) (ksb:) good/(P)/
ええじゃないか /(exp) (1) isn't it great?/(n) (2) carnival-like religious celebrations (e.g. dancing festivals) that occurred across Japan from June 1867 to May 1868/
ええと /(int) let me see/well/errr .../(P)/
ええ加減にしいや [ええかげんにしいや] /(exp) (uk) (ksb:) I've had enough of your messing around (orig. a phrase signaling the end of a manzai performance)/
えげつない /(adj-i) dirty/vulgar/nasty/
えこ贔屓 [えこひいき] /(adj-na,n,vs) favoritism/favouritism/partiality/prejudice/bias/
えさ場 [えさば] /(n) feeding grounds/
えずい /(adj-i) (1) unpleasant/uncomfortable/(2) frightening/(3) cruel/rude/violent/wild/
えせ学者 [えせがくしゃ] /(n,adj-no) pseudo-scholar/fake scholar/would-be expert/
えぞももんが /(n) (uk) Pteromys volans orii (subspecies of the Siberian flying squirrel, endemic to Hokkaido)/
えっ /(int) Huh?/What's up?/
えっさっさ /(int) heave-ho (chant when doing heavy work)/
えっちらおっちら /(adv) with a great deal of effort/laboriously/
えっと /(int) let me see/well/errr .../
えっへん /(int) ahem/
えのき茸 [えのきたけ] /(n) (uk) enoki mushroom (long, thin and white)/Flammulina velutipes/winter mushroom/
えのき茸 [えのきだけ] /(n) (uk) enoki mushroom (long, thin and white)/Flammulina velutipes/winter mushroom/
えばりんぼ /(n) (col) boaster/
えびっさん /(n) (col) Ebisu (local dialect forms)/
えへへ /(exp) tee-hee/giggle/
えへらえへら /(adv) meaninglessly (laugh)/(laugh) hollowly/
えへん /(int) ahem/
えべっさん /(n) (col) Ebisu (local dialect forms)/
えも言われず [えもいわれず] /(adj-f) indescribable (in praise of something)/exquisite/inexpressible/indefinable/
えも言われぬ [えもいわれぬ] /(adj-f) indescribable (in praise of something)/exquisite/inexpressible/indefinable/
えらい目 [えらいめ] /(exp) terrible time/hard time/bad day/
えら呼吸 [えらこきゅう] /(n) branchial respiration (breathing using gills)/
えら物 [えらぶつ] /(n) talented person/great man/great woman/
えら物 [えらもの] /(n) talented person/great man/great woman/
えり好み [えりごのみ] /(n,vs) being particular about/fastidious/
えり蚕 [えりさん] /(n) (uk) eri silkmoth (Samia cynthia ricini)/eri silkworm/
えり抜き [えりぬき] /(adj-no,n) the very best/elite/
えり抜く [えりぬく] /(v5k,vt) to select/to choose/
えり分ける [えりわける] /(v1,vt) to classify/to sort out/to sift through/
えんがちょ /(n) (1) (chn) crossed fingers and word said to call someone to be avoided as 'dirty'/(vs) (2) to cross one's fingers (to ward off 'dirt')/
えんがちょ切った [えんがちょきった] /(exp) (chn) phrase used (usu. with accompanying crossed fingers gesture) to ward off catching 'dirtiness' from another child/
えんこ /(n,vs) (1) squatting/sitting/(2) breaking down/stopping (e.g. of car engine)/
えんさかほい /(n) heave! (sound made while pulling a heavy vehicle)/
えんすう /(n) (obsc) mythical Chinese bird/
えんぺら /(n) squid fin/
えんま帳 [えんまちょう] /(n) teacher's mark or grade book/
えん官 [えんかん] /(n) eunuch/
えん罪 [えんざい] /(n) false charge/false accusation/misrepresentation/
えん堤 [えんてい] /(n) dike/weir/
えゾオオカミ /(n) (uk) Hokkaido wolf (Canis lupus hattai, extinct)/
え辛っぽい [えがらっぽい] /(adj-i) (uk) acrid/pungent/irritating/
え段 [えだん] /(n) (ling) 'e' row/
お /(int) oh! (expression of slight surprise)/
おーい /(int) ahoy/hullo/hello/
おｋ [オーケー] /(n) (col) OK/
おｋ [オッケー] /(n) (col) OK/
おあつらえ向き [おあつらえむき] /(adj-no) perfect/just right/ideal/
おい /(int) (1) hey!/oi!/(2) (ksb:) me/
おいおい /(int) (1) Hey!/Wait a minute!/Whoa!/(adv,adv-to) (2) boohoo/waaaa/
おいそれと /(adv) at a moment's notice/readily/
おいた /(n) childish prank/mischief/
おいでやす /(exp) (kyb:) welcome (in shops, etc.)/
おいどん /(n) (Kagoshima dialect) I/me/
おいべっさん /(n) (col) Ebisu (local dialect forms)/
おい付く [おいつく] /(v5k,vi) to overtake/to catch up (with)/
おうし座 [おうしざ] /(n) Taurus/the Bull (constellation)/
おうむ返し [おうむがえし] /(n) parroting another's words/
おう吐 [おうと] /(n,vs,adj-no) vomiting/
おえら方 [おえらがた] /(n) superiors/very important persons/VIPs/dignitaries/big shots/
おおい /(int) (1) hey!/oi!/
おおいぬ座 [おおいぬざ] /(n) Canis Major (constellation)/
おおかみ座 [おおかみざ] /(n) Lupus (constellation)/
おおぐま座 [おおぐまざ] /(n) Ursa Major (constellation)/
おおすみ型輸送艦 [おおすみがたゆそうかん] /(n) Osumi class vehicle transport ship/
おおたなご /(n) (uk) Acheilognathus macropterus (species of cyprinid)/
おおひるめのむち /(n) Sun Goddess/Amaterasu Oomikami/
おおみず /(n) white angel/malus tschonoskii/
おおアメリカももんが /(n) (uk) northern flying squirrel (Glaucomys sabrinus)/
おかか /(n) finely chopped katsuobushi, sometimes with soy sauce/
おかけ下さい [おかけください] /(exp) (uk) please sit down/please have a seat/
おかしみ /(n) humor/humour/wit/
おかちん /(n) (fem) (arch) mochi/
おが屑 [おがくず] /(n) sawdust/
おきえそ /(n) (uk) bluntnose lizardfish (Trachinocephalus myops)/snakefish/
おぎゃあ /(n) cry (of baby)/mewl (of kitten)/
おくびにも出さない [おくびにもださない] /(exp) not revealing (thoughts, feelings)/not breathing a word/
おくれ毛 [おくれげ] /(n) straggling hair/
おく病 [おくびょう] /(adj-na,n) cowardice/timidity/
おけさ /(n) type of traditional vocal music/
おけさ節 [おけさぶし] /(n) okesa song/
おこしやす /(exp) (kyb:) welcome (in shops, etc.)/
おこし種 [おこしだね] /(n) roasted millet or rice cake used to make okoshi/
おこじょ /(n) stoat/ermine/short-tailed weasel (Mustela erminea)/
おさげ髪 [おさげがみ] /(n) pigtails/two plaits hanging about one's shoulders/two plaits hanging down one's back/queue/
おさらば /(n,vs) good-bye/farewell/
おさ打ち [おさうち] /(n) beating/beating up/
おさ通し [おさとおし] /(n) reed drawing-in (manuf.)/denting/
おざなりになって /(exp) to say commonplace things/
おしっこ /(n) (1) (col) wee-wee/pee-pee/number one/(vs) (2) to urinate/(P)/
おしどり夫婦 [おしどりふうふ] /(exp) loving couple/couple of lovebirds/happily married couple (who are always together)/
おしゃぶり /(n) teething ring/pacifier/dummy/
おしゃま /(n,adj-na) precocity/
おしろい焼 [おしろいやけ] /(n) damage to skin by ceruse/
おしろい焼け [おしろいやけ] /(n) damage to skin by ceruse/
おし黙る [おしだまる] /(v5r,vi) to keep silent/
おじゃる /(v4r) (1) (arch) (hon) to come/to go/to be/(aux-v) (2) (usu. after the particle 'de') forms a polite copula/
おじゃん /(n) coming to nothing/
おじゃんになる /(exp) to fall through/to come to nothing/to be ruined/
おじや /(n) rice gruel containing vegetables, fish, etc., and seasoned with miso or soy sauce/
おじん /(n) old man/old-timer/old fogey/
おせち料理 [おせちりょうり] /(n) food served during the New Year's Holidays/
おせんち /(n,adj-na) (uk) (col) (abbr) sentimental/sentimentality/
おそれ多い [おそれおおい] /(adj-i) awesome/awe-inspiring/august/
おそろ /(n,adj-no) (abbr) (sl) same/matching/going together/
おぞい /(adj-i) (1) (col) crude/inferior grade/worn/ragged/shameful/(2) sly/clever/(3) disgusting/repulsive/absurd/
おぞけを振るう [おぞけをふるう] /(exp,v5u) to be horrified/to be filled with trepidation/
おぞけ立つ [おぞけだつ] /(v5t,vi) to be horrified/to be filled with trepidation/to shake with fright/to yield to terror/
おたおた /(adv,n,vs) (on-mim) shocked speechless/
おたふく風邪 [おたふくかぜ] /(n) mumps/
おたんこなす /(n) fool/twit/idiot/bird-brain/
おちゃっぴい /(n) chatterbox/talkative girl/precocious girl/
おちょくる /(v5r,vt) to tease/to banter/to make fun of somebody/
おちょける /(v5r,vt) to tease/to banter/to make fun of somebody/
おちょぼ口 [おちょぼぐち] /(n) puckered-up mouth/button of a mouth/
おっかけ /(n) person who chases after idol, showbiz star/
おっかない /(adj-i) (1) frightening/scary/(2) extreme/exaggerated/huge/
おっかなびっくり /(adv) fearfully/nervously/timidly/gingerly/
おっさん /(n) (1) (abbr) rude term for middle-aged man/(2) Buddhist priest/(P)/
おっちょこちょい /(adj-na,n) careless person/scatterbrain/birdbrain/
おっつかっつ /(adj-no) much the same/nearly equal/
おっと /(int) uh-oh/oops/sorry/
おっとり /(adv-to,adv,vs) gently/quietly/calmly/
おっぱい /(n) (1) (chn) breasts/boobies/tits/(2) (chn) breast milk/(P)/
おっぱいアイス /(n) soft icecream sold in a balloon/
おっぽり出す [おっぽりだす] /(v5s,vt) to throw out/to fire/to expel/to give up/to abandon/to neglect/
おっ開く [おっぴらく] /(v5k) (1) to do something in public/(2) to open/
おっ魂消る [おったまげる] /(v1,vi) (uk) to be very surprised/to be flabbergasted/
おっ放り出す [おっぽりだす] /(v5s,vt) to throw out/to fire/to expel/to give up/to abandon/to neglect/
おつむ /(n) (1) (abbr) face (used mostly with children)/head/(2) brains/intelligence/
おつむてんてん /(exp,n) motion of a baby gently hitting his own face with both of his hands/
おでん屋 [おでんや] /(n) oden vendor/
おとぎの国 [おとぎのくに] /(n) a fairyland or never-never land/
おとぎ話 [おとぎばなし] /(n) fairy-tale/nursery-tale/
おとし入れる [おとしいれる] /(v1,vt) (1) to trick someone into (committing a crime, etc.)/to hatch a plan and deceive someone/(2) to assault (a castle, etc.)/(3) to drop something and have it fall into something/
おととい来やがれ [おとといきやがれ] /(exp) (sl) Don't you ever come here again!/
おとめ座 [おとめざ] /(n) Virgo (constellation)/the Virgin/
おとり捜査 [おとりそうさ] /(n) sting operation/undercover investigation/
おと年 [おととし] /(n-adv,n-t) year before last/
おどおど /(adv,n,vs) (on-mim) coweringly/hesitantly/(P)/
おどり出る [おどりでる] /(v1,vi) to jump (e.g. to first place)/to spring out/
おどり上がる [おどりあがる] /(v5r,vi) to spring up/to leap to one's feet/to jump up and down/
おどろおどろしい /(adj-i) (1) (arch) eerie/hair-raising/(2) exaggerated/ostentatious/
おなかの子 [おなかのこ] /(exp) child one is expecting/
おにい系 [おにいけい] /(n) men's fashion style characterized by brown hair and deep-tanned skin, expensive brand-name clothes and accessories/
おにかます /(n) (uk) great barracuda (Sphyraena barracuda)/
おねんね /(n,vs) bed-time (for a baby)/going bye-byes/
おのずから明らか [おのずからあきらか] /(adj-na) self-evident/
おは /(int) (abbr) Good morning!/Hi!/
おはか参り [おはかまいり] /(n) ritual visit to the tomb of one's ancestors (bringing flowers, burning incense, cleansing the tombstone)/
おはよっす /(exp) G'morning/Hi!/
おばこ /(n) (col) virgin/
おばたりあん /(n) (col) generally obnoxious middle-aged woman (from aunt and battalion)/
おばはん /(n,adj-na) (1) (ksb:) aunt/(2) middle-aged lady/
おひつじ座 [おひつじざ] /(n) Aries (constellation)/the Ram/
おびき寄せる [おびきよせる] /(v1,vt) to lure someone/to entice someone/
おびき出す [おびきだす] /(v5s,vt) (1) to lure out of/to decoy out of/(2) to drive to (tears, sleep, etc.)/to evoke (sympathy, etc.)/(3) (arch) to abduct/to entice out of/
おべっか /(n) flattery/
おべっかを使う [おべっかをつかう] /(exp,v5u) to suck up to/to curry up to someone/
おべっさん /(n) (col) Ebisu (local dialect forms)/
おべんちゃら /(n) flattery/
おほんおっほん /(int) ahem/harrumph/
おぼれる者はわらをもつかむ [おぼれるものはわらをもつかむ] /(exp) (proverb) A drowning man will catch at a straw/
おぼれる者は藁をもつかむ [おぼれるものはわらをもつかむ] /(exp) (proverb) A drowning man will catch at a straw/
おぼろ雲 [おぼろぐも] /(n) altostratus cloud/
おぼろ月夜 [おぼろづきよ] /(n) misty, moonlit night/
おぼろ夜 [おぼろよ] /(n) misty, moonlit night/
おまんこ /(n) (1) (X) (col) vagina/(vs) (2) to have sexual intercourse/to screw/
おまんまの食い上げ [おまんまのくいあげ] /(exp) losing the means of livelihood/
おみ /(n) (1) (abbr) (col) miso (usu. said by housewives)/(2) miso soup/
おみ足 [おみあし] /(n) (hon) another's foot or leg/
おみ籤 [おみくじ] /(n) (uk) written oracle/fortune slip/
おめおめ /(adv-to) (1) (on-mim) shamelessly/acting brazenly unaffected/(2) being resigned to (disgrace)/
おめかし /(n,vs) dressing up/
おめこ /(n) (1) (X) (col) vagina/(vs) (2) to have sexual intercourse/to screw/
おめでた /(n) matter for congratulation (wedding, pregnancy, birth, etc.)/happy event/
おめでた婚 [おめでたこん] /(n) (euph. for) shotgun wedding (seeking to avoid a negative connotation)/
おもしい /(adj-i) interesting (Kanazawa dialect)/amusing/
おもちゃ屋 [おもちゃや] /(n) toy shop/
おもり /(n) clog/
おもろい /(adj-i) (ksb:) interesting/amusing/
おや /(conj,int,n) oh!/oh?/my!/(P)/
おやおや /(int) my goodness!/oh my!/oh dear!/
おやしお型潜水艦 [おやしおがたせんすいかん] /(n) Oyashio class submarine/
おやじぎゃる /(n) (sl) young woman who acts like an old man/
おやじギャル /(n) (sl) young woman who acts like an old man/
おやじ狩り [おやじがり] /(n) street violence against middle-aged men/
おやまあ /(exp) Good heavens!/Oh my god!/gee whiz/
およしなさい /(exp) please stop/
およべっさん /(n) (col) Ebisu (local dialect forms)/
おりたたみ印刷物 [おりたたみいんさつぶつ] /(n) leaflet/folded printed matter/
おり立つ [おりたつ] /(v5t,vi) (1) to go down and stand/(2) to alight/to get down/
おれおれ詐欺 [おれおれさぎ] /(n) type of fraud involving phone calls pretending distress/
おれんち /(n) (male) my house/
おれ合う [おれあう] /(v5u,vi) to get along with/to compromise/to make concessions/to come to an agreement/
おれ込む [おれこむ] /(v5m,vi) to be folded under or inside/
おろおろ /(adv,n,vs) (on-mim) nervous/flustered/in a dither/all shook up/(P)/
おろおろ声 [おろおろごえ] /(n) broken voice/emotional voice/
おろか者 [おろかもの] /(n) fool/
おろしポン酢 [おろしポンず] /(n) ponzu mixed with grated daikon/
おろちょろ /(n,vs) lounging about/
おわら風の盆 [おわらかぜのぼん] /(n) Owara-Kaze-no-Bon Festival (Toyama)/
おん /(n) (Okinawa) sacred site/sacred grove/
おんおん /(adv-to,adv) (obsc) bawling/crying/
おんにゃのこ /(n) girl/
おんぼろ /(adj-na,adj-no) worn-out/shabby/tattered/dilapidated/
おんり /(vs) (chn) to get down (from being carried)/to get off (a vehicle)/
おセンチ /(n,adj-na) (uk) (col) (abbr) sentimental/sentimentality/
おデブさん /(n) chubby person/
お愛でたい [おめでたい] /(n) (1) (uk) (pol) special/auspicious/happy/(2) naive/inncocent/good-natured/
お愛想 [おあいそ] /(n) (1) (pol) compliment/flattery/(2) service/hospitality/(3) bill (at a restaurant; formerly, not used by customers)/check/
お愛想 [おあいそう] /(n) (1) (pol) compliment/flattery/(2) service/hospitality/(3) bill (at a restaurant; formerly, not used by customers)/check/
お握り [おにぎり] /(n) (uk) rice ball (often triangular, sometimes with a filling and wrapped in nori)/(P)/
お安い [おやすい] /(adj-i) easy/simple/
お安いご用 [おやすいごよう] /(n) easy task/no problem/
お安い御用 [おやすいごよう] /(n) easy task/no problem/
お安くない [おやすくない] /(exp) on very good terms with each other/romantically attached/
お偉いさん [おえらいさん] /(n) (col) big shot/higher-ups/
お偉方 [おえらがた] /(n) superiors/very important persons/VIPs/dignitaries/big shots/
お為ごかし [おためごかし] /(n) self-aggrandizement under pretense of aiding another (aggrandisement, pretence)/
お医者さん [おいしゃさん] /(n) (pol) doctor/(P)/
お医者様 [おいしゃさま] /(n) (hon) doctor/
お一人様 [おひとりさま] /(n) one person or customer/(may indicate a restaurant hospitable for lone women)/
お稲荷さん [おいなりさん] /(n) (1) (hon) Inari (god of harvests, wealth, fertility, etc.)/(2) (hon) Inari shrine/(3) (pol) Inari-zushi (sushi wrapped in fried tofu)/
お印 [おしるし] /(n) (1) (uk) a show/blood-stained mucus discharge that happens during pregnancy up to two weeks before delivery/(2) signature mark (crest) used by members of the Imperial family to mark their belongings/(3) a sign (with honorific 'o')/
お引き受け [おひきうけ] /(n) undertaking/underwriting/acceptance/
お引き摺り [おひきずり] /(n) (1) train of dress/trailing skirt/(2) woman who doesn't work and only thinks about fashion/
お引摺り [おひきずり] /(n) (1) train of dress/trailing skirt/(2) woman who doesn't work and only thinks about fashion/
お蔭 [おかげ] /(n) (your) backing/assistance/thanks or owing to/
お蔭で [おかげで] /(exp) thanks to you/owing to you/because of you/
お蔭参り [おかげまいり] /(n) pilgrimage to Ise/
お蔭様 [おかげさま] /(n) (your) backing/assistance/
お蔭様で [おかげさまで] /(exp) (pol) (I'm fine) thank you/under the gods' shadow/(P)/
お陰 [おかげ] /(n) (your) backing/assistance/thanks or owing to/
お陰で [おかげで] /(exp) (uk) thanks to ... (can be used for non-people causes)/owing to ..../
お陰様で [おかげさまで] /(exp) (pol) (I'm fine) thank you/under the gods' shadow/
お羽車 [おはぐるま] /(n) portable shrine used to transport a sacred object/
お越し [おこし] /(exp) (hon) coming or leaving/
お下がり [おさがり] /(n,adj-no) (1) food offering to the gods/(2) leftovers/hand-me-downs/
お下げ [おさげ] /(n) wearing one's hair in braids/
お下げ髪 [おさげがみ] /(n) pigtails/two plaits hanging about one's shoulders/two plaits hanging down one's back/queue/
お化け [おばけ] /(n) goblin/apparition/monster/ghost/(P)/
お化けの話 [おばけのはなし] /(n) spooky tale/ghost story/
お化け屋敷 [おばけやしき] /(n) haunted house/
お化け暦 [おばけごよみ] /(n) (arch) private koyomi published illegally (Edo period)/
お化け話 [おばけばなし] /(n) ghost story/spooky story/
お伽 [おとぎ] /(n) attending (upon)/keeping another company/
お伽の国 [おとぎのくに] /(n) a fairyland or never-never land/
お伽草子 [おとぎぞうし] /(n) fairy-tale book/
お伽話 [おとぎばなし] /(n) fairy-tale/nursery-tale/
お嫁さん [およめさん] /(n) bride/
お家 [おうち] /(n) (pol) your home/your group/their home/
お家芸 [おいえげい] /(n) (1) one's specialty/one's forte/(2) specialty of a kabuki school/
お家騒動 [おいえそうどう] /(n) family trouble (quarrel)/domestic squabble/internal squabble (over headship rights) in a daimyo family in the Edo period/
お暇 [おいとま] /(n,vs) (1) (uk) leaving/going home/(2) quitting one's job/(3) free time/leisure/spare time/
お河童 [おかっぱ] /(n) (uk) bobbed hair (from resemblance to the mythical Kappa's hair style)/
お火焚 [おひたき] /(n) Kyoto area festival held on the 11th lunar month (wherein bonfires are burned at shrines)/
お火焚 [おほたき] /(n) Kyoto area festival held on the 11th lunar month (wherein bonfires are burned at shrines)/
お花見 [おはなみ] /(n,vs) cherry blossom viewing/flower viewing/
お花畑 [おはなばたけ] /(n) field of alpine flowers/
お荷物 [おにもつ] /(n) (1) (pol) baggage/luggage/(2) burden/albatross around someone's neck/excess baggage/
お菓子 [おかし] /(n) confections/sweets/candy/(P)/
お過ごし [おすごし] /(exp) (hon) getting along/
お芽出度い [おめでたい] /(ateji) (n) (1) (uk) (pol) special/auspicious/happy/(2) naive/inncocent/good-natured/
お芽出度う [おめでとう] /(ateji) (int) (uk) congratulations!/an auspicious occasion!/
お会計 [おかいけい] /(n) (restaurant) bill/
お悔やみ申し上げます [おくやみもうしあげます] /(exp) my condolences/my deepest sympathy/
お開き [おひらき] /(n) breakup (of a ceremony, wedding, party, meeting, etc.)/closure/
お開きにする [おひらきにする] /(vs-i) to break up (e.g. a meeting)/to call it a night/
お楽しみ [おたのしみ] /(n) (pol) enjoyment/pleasure/diversion/amusement/hobby/
お掛け下さい [おかけください] /(exp) (uk) please sit down/please have a seat/
お株 [おかぶ] /(n) one's forte/
お株を奪う [おかぶをうばう] /(exp,v5u) to beat someone at his own game/
お釜 [おかま] /(n) (1) (pol) pot/(2) volcanic crater/(3) (one's) buttocks/(4) (uk) (col) male homosexual/effeminate man/male transvestite/
お釜を掘る [おかまをほる] /(exp,v5r) (1) to perform anal sex/to bugger/to sodomize/to sodomise/(2) to crash a car into the back of another (usu. used in the passive voice)/to rear-end/
お粥 [おかゆ] /(n) thin rice porridge/watery cooked rice/rice gruel/
お冠 [おかんむり] /(n) (uk) bad temper/bad mood/
お寒い [おさむい] /(adj-i) (1) poor/unsatisfactory/inadequate/(2) (pol) cold/chilly/
お勧め [おすすめ] /(n,vs) recommendation/advice/suggestion/encouragement/
お丸 [おまる] /(n) (uk) bedpan/chamber pot/potty/
お眼鏡 [おめがね] /(n) (your) judgment/discernment/
お顔 [おかお] /(n) your (honorable) face (honourable)/
お願い [おねがい] /(n,vs) (1) (hon) request/wish/(int) (2) (abbr) please/
お願いいたします [おねがいいたします] /(exp) (hon) please/
お願いごと [おねがいごと] /(n) request/
お願いします [おねがいします] /(exp) (hum) please/(P)/
お願いできますか [おねがいできますか] /(exp) (hon) may I ask (for)/might I ask (that)/
お願いを聞く [おねがいをきく] /(exp,v5k) to grant someone's request/
お願い事 [おねがいごと] /(n) request/
お願い出来ますか [おねがいできますか] /(exp) (hon) may I ask (for)/might I ask (that)/
お願い申し上げる [おねがいもうしあげる] /(exp,v1) (pol) please/
お願い致します [おねがいいたします] /(exp) (hon) please/
お帰り [おかえり] /(n) (1) (hon) return/(int) (2) (abbr) welcome home/(P)/
お帰りなさい [おかえりなさい] /(int) welcome home/(P)/
お気に召す [おきにめす] /(exp,v5s) (hon) to like/to prefer/to be pleased by/
お気に入り [おきにいり] /(exp) (1) favorite/favourite/pet (e.g. teacher's pet)/(2) bookmark (in web browser)/(P)/
お気の毒 [おきのどく] /(adj-na) pitiful/pity/
お気の毒に [おきのどくに] /(exp) my sympathies/that's too bad/my condolences/
お気を確かに [おきをたしかに] /(exp) Don't do anything rash!/Keep composed!/
お祈り [おいのり] /(n,vs) prayer/supplication/
お亀 [おかめ] /(n) plain-looking woman/
お詰 [おつめ] /(n) (1) lowest-ranking guest at tea ceremony/(2) tea master/
お詰め [おつめ] /(n) (1) lowest-ranking guest at tea ceremony/(2) tea master/
お客さま [おきゃくさま] /(n) (hon) guest/visitor/customer/
お客さん [おきゃくさん] /(n) guest/visitor/customer/
お客好き [おきゃくずき] /(adj-na) enjoys company/enjoys having guests/
お客様 [おきゃくさま] /(n) (hon) guest/visitor/customer/
お久 [おひさ] /(exp) (abbr) (sl) long time no see/
お久しぶり [おひさしぶり] /(exp) (abbr) (sl) it's been a long time/long time no see/
お休み [おやすみ] /(n) (1) (pol) holiday/day off/absence/(2) (hon) sleep/rest/(exp) (3) (abbr) Good night/(P)/
お休みなさい [おやすみなさい] /(exp) good night/(P)/
お宮 [おみや] /(n) Shinto shrine/
お宮参り [おみやまいり] /(n) shrine visit/
お供 [おとも] /(n,vs) attendant/companion/
お供え [おそなえ] /(n) an offering/
お侠 [おきゃん] /(n) pert girl/girl with "attitude"/lively minx/tomboy/
お強請り [おねだり] /(n) (uk) (pol) begging/pestering/pleading/coaxing/
お玉 [おたま] /(n) egg/ladle/
お玉杓子 [おたまじゃくし] /(n) (1) tadpole/(2) ladle/(3) musical note/
お勤め [おつとめ] /(n) (1) (arch) (pol) one's business/(2) reading of scriptures before a (statue of) Buddha/(3) bargain/discount/(4) money paid to a prostitute or geisha/
お近付き [おちかづき] /(n) making someone's acquaintance/
お金 [おかね] /(n) (pol) money/(P)/
お金持ち [おかねもち] /(n) rich person/
お金本位 [おかねほんい] /(n,adj-no) money-centered way (of thinking)/
お兄さん [おにいさん] /(n) (1) (hon) older brother/elder brother/(2) (vocative) young man/buddy/fella/laddie/(P)/
お兄ちゃん [おにいちゃん] /(n) (1) (fam) familiar form of "older brother"/(2) (fam) form of address for young adult male/mister/
お兄系 [おにいけい] /(n) men's fashion style characterized by brown hair and deep-tanned skin, expensive brand-name clothes and accessories/
お経 [おきょう] /(n) (Buddh) Buddhist sutra/
お迎え [おむかえ] /(vt) receiving/welcoming/
お決まり [おきまり] /(n,adj-no) standard/set/routine/regular/usual/conventional/stereotyped/same old/
お決り [おきまり] /(n,adj-no) standard/set/routine/regular/usual/conventional/stereotyped/same old/
お結び [おむすび] /(n) rice ball/
お月様 [おつきさま] /(n) (hon) the moon/
お見えになる [おみえになる] /(exp) (hon) to arrive/
お見合い [おみあい] /(n,vs) formal marriage interview/
お見合いデート [おみあいデート] /(n) blind date/
お見事 [おみごと] /(int) well done!/bravo/
お見知りおき [おみしりおき] /(exp) pleased to make your acquaintance (formal phrase used on first meeting someone to encourage them to remember you)/
お見知り置き [おみしりおき] /(exp) pleased to make your acquaintance (formal phrase used on first meeting someone to encourage them to remember you)/
お見通し [おみとおし] /(n) seeing through (e.g. a trick, someone's mind)/
お見逃しなく [おみのがしなく] /(exp) Don't miss it/
お見舞 [おみまい] /(n) calling on someone who is ill/enquiry/inquiry/
お見舞い [おみまい] /(n) calling on someone who is ill/enquiry/inquiry/
お見舞い申し上げる [おみまいもうしあげる] /(exp,v1) (hum) you have my deepest sympathy/
お遣い [おつかい] /(n) (1) (pol) errand/mission/going as envoy/(2) (pol) messenger/bearer/errand boy/errand girl/(3) (pol) (hon) familiar spirit/
お元気ですか [おげんきですか] /(exp) how are you?/
お言葉 [おことば] /(exp) (1) availing myself of your kind offer/taking you at your word/
お古 [おふる] /(n) used article (esp. clothes)/
お呼ばれ [およばれ] /(n) being invited/
お呼び [および] /(n,vs) (hon) call/invitation/
お虎子 [おまる] /(n) (uk) bedpan/chamber pot/potty/
お雇い外国人 [おやといがいこくじん] /(n) hired foreigners/foreign advisors hired by the Japanese government for their specialized knowledge to assist in the modernization of Japan at the end of the Bakufu and during the Meiji Era/
お互い [おたがい] /(n) mutual/reciprocal/each other/
お互いさま [おたがいさま] /(adj-na,n) we are of equal status in this regard/
お互いに [おたがいに] /(adv) (pol) mutually/with each other/reciprocally/together/both/
お互い様 [おたがいさま] /(adj-na,n) we are of equal status in this regard/
お後がよろしいようで [おあとがよろしいようで] /(exp) (from rakugo) that's all from me, and now the next speaker .../expression used to hand over to the next speaker/
お御輿 [おみこし] /(n) (1) (pol) portable shrine (carried in festivals)/(2) (uk) buttocks/lower back/waist/hips/
お御籤 [おみくじ] /(n) (uk) written oracle/fortune slip/
お好み [おこのみ] /(n,adj-no) choice/preference/
お好み焼き [おこのみやき] /(n) savoury pancake with various ingredients/
お好み焼き屋 [おこのみやきや] /(n) okonomiyaki shop (savoury pancake shop)/
お広め [おひろめ] /(n,vs) debut/
お構い [おかまい] /(n) (1) (pol) entertainment/hospitality/(2) banishment (Edo period)/
お構いなく [おかまいなく] /(exp) (pol) please don't fuss over me/
お構いなし [おかまいなし] /(adj-na,n) being unmindful/
お絞り [おしぼり] /(n) wet towel (supplied at table)/hot, moistened hand towel/(P)/
お高い [おたかい] /(adj-i) haughty/
お高く止まる [おたかくとまる] /(v5r) to assume an air of importance/to be self-important/to put on airs/
お高く留まる [おたかくとまる] /(v5r) to assume an air of importance/to be self-important/to put on airs/
お高祖頭巾 [おこそずきん] /(n) kerchief worn by women in former times in Japan in cold weather, covering the whole head (except eyes)/
お告 [おつげ] /(n) oracle/divine message/
お告げ [おつげ] /(n) oracle/revelation/divine message/
お告げの祝日 [おつげのしゅくじつ] /(n) Annunciation Day/Lady Day/
お国言葉 [おくにことば] /(n) (pol) national language/local dialect/
お国自慢 [おくにじまん] /(n) boasting of one's hometown/
お腰 [おこし] /(n) (1) (hon) buttocks/lower back/waist/hips/(2) (fem) kimono underskirt/
お惚け [おとぼけ] /(n) feigned ignorance/
お座なり [おざなり] /(adj-na) perfunctory/apathetic/careless/slapdash/commonplace/
お座り [おすわり] /(n,vs) (1) (chn) sit down/sit up/(2) Sit! (to a dog)/
お座成り [おざなり] /(adj-na) perfunctory/apathetic/careless/slapdash/commonplace/
お座敷 [おざしき] /(n) (1) (pol) tatami room/(2) gathering (to which one has been invited to perform as a geisha, etc.)/
お座敷がかかる [おざしきがかかる] /(exp,v5r) to be invited (often to perform for an audience)/to be called/
お座敷が掛かる [おざしきがかかる] /(exp,v5r) to be invited (often to perform for an audience)/to be called/
お歳暮 [おせいぼ] /(n) end of the year/year-end gift/(P)/
お祭 [おまつり] /(n) (pol) festival/feast/carnival/
お祭り [おまつり] /(n) (pol) festival/feast/carnival/
お祭り騒ぎ [おまつりさわぎ] /(n) festival merrymaking/revelry/
お菜 [おかず] /(n) (1) (uk) accompaniment for rice dishes/side dish/(2) food for thought (esp. in the context of conversation, or material for assisting arousal during masturbation)/
お菜 [おさい] /(n) (1) (uk) accompaniment for rice dishes/side dish/
お作り [おつくり] /(n) (1) make-up/(2) (ksb:) sashimi/
お札 [おさつ] /(n) bill/note (currency)/
お札 [おふだ] /(n) a charm/
お雑煮 [おぞうに] /(n) New Year dish/
お皿 [おさら] /(n) plate/dish/
お三時 [おさんじ] /(n) three-o'clock snack/
お参り [おまいり] /(n,vs) worship/shrine visit/(P)/
お山 [おやま] /(n) (hon) (pol) (fam) mountain/
お山の大将 [おやまのたいしょう] /(n) king of the castle/king of the mountain/
お産 [おさん] /(n) (pol) (giving) birth/childbirth/delivery/confinement/(P)/
お仕置き [おしおき] /(n,vs) punishment/spanking/smacking/chastisement/scolding/
お仕着せ [おしきせ] /(n) uniforms supplied to employees/an allotment/
お仕舞 [おしまい] /(n) (uk) (pol) the end/closing/being done for/
お仕舞い [おしまい] /(n) (uk) (pol) the end/closing/being done for/(P)/
お使 [おつかい] /(io) (n) (1) (pol) errand/mission/going as envoy/(2) (pol) messenger/bearer/errand boy/errand girl/(3) (pol) (hon) familiar spirit/
お使い [おつかい] /(n) (1) (pol) errand/mission/going as envoy/(2) (pol) messenger/bearer/errand boy/errand girl/(3) (pol) (hon) familiar spirit/
お姉さん [おねえさん] /(n) (1) (hon) elder sister/(2) (vocative) young lady/(3) miss (referring to a waitress, etc.)/(4) ma'am (used by geisha to refer to their superiors)/(P)/
お姉ちゃん [おねえちゃん] /(n) (1) (fam) familiar form of "older sister"/(2) (fam) form of address for young adult female/
お姉ギャル [おねえギャル] /(n) (abbr) fashion style characterized by brown hair and deep-tanned skin, expensive brand-name clothes and accessories/
お姉系 [おねえけい] /(n) (abbr) fashion style characterized by brown hair and deep-tanned skin, expensive brand-name clothes and accessories/
お姉系ギャル [おねえけいギャル] /(n) fashion style characterized by brown hair and deep-tanned skin, expensive brand-name clothes and accessories/
お子 [おこ] /(n) (pol) (someone else's) child/
お子さん [おこさん] /(n) (someone else's) child/
お子ちゃま [おこちゃま] /(n) (1) child/(2) childish person/immature person/
お子様 [おこさま] /(n) (pol) child (someone else's)/
お子様セット [おこさまセット] /(n) kid's meal/special meal prepared for children at a restaurant/
お子様ランチ [おこさまランチ] /(n) kid's lunch/special lunch (meal) prepared for children at a restaurant/
お歯黒 [おはぐろ] /(n) tooth blackening/
お寺 [おてら] /(n) (1) (hon) (pol) temple/(2) (abbr) monk/
お寺さま [おてらさま] /(n) (hon) monk/
お寺様 [おてらさま] /(n) (hon) monk/
お持て成し [おもてなし] /(n) (uk) hospitality/entertainment/service/(P)/
お辞儀 [おじぎ] /(n,vs) (pol) bow/bowing/(P)/
お七夜 [おしちや] /(n) name-giving ceremony/
お叱り [おしかり] /(n) (hon) scolding/
お邪魔 [おじゃま] /(n,vs) (pol) hindrance/intrusion (suru and itasu verb forms are used as set phrases said prior to entering or leaving someone's home)/
お邪魔します [おじゃまします] /(exp) (1) excuse me for disturbing (interrupting) you/(2) greeting used on going to someone's home/
お邪魔虫 [おじゃまむし] /(n) someone who gets in the way without serving any useful purpose/fly in the ointment/buttinsky/third wheel/
お酌 [おしゃく] /(n,vs) (1) pouring alcohol/(2) person pouring alcohol for guests or customers (typically a woman)/(3) (apprentice) geisha/dancing girl/
お釈迦 [おしゃか] /(n) (1) poorly made or ruined articles/(2) the Buddha/
お釈迦さん [おしゃかさん] /(n) Buddha/Shakyamuni/
お釈迦様 [おしゃかさま] /(n) Buddha/Shakyamuni/
お釈迦様 [おしゃかさん] /(n) Buddha/Shakyamuni/
お釈迦様の誕生日 [おしゃかさまのたんじょうび] /(exp) Buddha's birthday/
お主 [おぬし] /(pn,adj-no) (arch) you (when referring to one's equals or inferiors)/
お取り置き [おとりおき] /(n) layaway/lay-bye/layaway plan/
お守 [おまもり] /(io) (n) charm/amulet/
お守 [おもり] /(n,vs) (1) babysitting/babysitter/(2) taking care of/assisting/assistant/helper/
お守り [おまもり] /(n) charm/amulet/(P)/
お守り [おもり] /(n,vs) (1) babysitting/babysitter/(2) taking care of/assisting/assistant/helper/
お手 [おて] /(n) (1) (pol) hand/arm/(2) (hon) handwriting/penmanship/(int) (3) 'shake' (command to have a dog place its paw in your hand)/
お手々 [おてて] /(n) hand(s) (kid talk)/
お手つき [おてつき] /(n) (1) touching a wrong card/(2) making a mistress of a servant/mistress (who is one's servant)/
お手て [おてて] /(n) hand(s) (kid talk)/
お手の物 [おてのもの] /(n) one's speciality/one's forte/one's own thing/
お手塩 [おてしょ] /(n) (fem) (obsc) small, shallow dish/
お手塩 [おてしょう] /(n) (fem) (obsc) small, shallow dish/
お手許 [おてもと] /(n) (uk) chopsticks (often written on the paper wrapper)/
お手玉 [おてだま] /(n) (1) beanbag/beanbag juggling game/(2) bobbling the ball (baseball)/
お手元 [おてもと] /(n) (uk) chopsticks (often written on the paper wrapper)/
お手元金 [おてもときん] /(n) the privy purse/the money used for private purposes by the members of the Imperial family/
お手手 [おてて] /(n) hand(s) (kid talk)/
お手柔らか [おてやわらか] /(adv) gently/mildly/
お手上げ [おてあげ] /(n) all over/given in/given up hope/bring to knees/(P)/
お手数 [おてかず] /(n) (hon) trouble/bother/
お手数 [おてすう] /(n) (hon) trouble/bother/
お手数をおかけいたします [おてすうをおかけいたします] /(exp) (hum) to be a burden/to make trouble for someone/
お手数をおかけ致します [おてすうをおかけいたします] /(exp) (hum) to be a burden/to make trouble for someone/
お手盛り [おてもり] /(n) making arbitrary decisions which benefit oneself/self-approved plan/
お手洗い [おてあらい] /(n) toilet/restroom/lavatory/bathroom/(P)/
お手前 [おてまえ] /(n) (1) skill/dexterity/artistry/ingenuity/(2) etiquette of tea-ceremony/
お手伝い [おてつだい] /(n,vs) (1) maid/(2) help/(P)/
お手伝いさん [おてつだいさん] /(n) maid/(P)/
お手付き [おてつき] /(n) (1) touching a wrong card/(2) making a mistress of a servant/mistress (who is one's servant)/
お手並み拝見 [おてなみはいけん] /(exp) let's see what you've got/show me what you've got/
お手並拝見 [おてなみはいけん] /(exp) let's see what you've got/show me what you've got/
お手本 [おてほん] /(n) example/role model/
お酒 [おさけ] /(n) (pol) alcohol/sake/
お呪い [おまじない] /(n) (1) (uk) good luck charm/(exp) (2) uttered when using magic/abracadabra/presto/
お終い [おしまい] /(n) (uk) (pol) the end/closing/being done for/
お汁粉 [おしるこ] /(n) sweet red-bean soup/
お重 [おじゅう] /(n) multi-tiered food box/
お祝 [おいわい] /(n,vs) (hon) congratulation/congratulations/celebration/festival/congratulatory gift/
お祝い [おいわい] /(n,vs) (hon) congratulation/congratulations/celebration/festival/congratulatory gift/(P)/
お出かけ [おでかけ] /(n) about to start out/just about to leave or go out/
お出で [おいで] /(n) (1) (uk) coming/going/being (somewhere)/(exp) (2) (col) (abbr) come (used as an imperative, usu. to children and one's inferiors)/go/stay/
お出でなさい [おいでなさい] /(exp) (1) (uk) (hon) (used as a polite imperative) come/go/stay/(2) welcome!/
お出でなさる [おいでなさる] /(v5aru) (1) (uk) (hon) to come/to go/to be (somewhere)/(2) (after the -te form of a verb) -ing/
お出でになる [おいでになる] /(v5r) (1) (uk) (hon) to be/(2) to come/(3) to go/
お出まし [おでまし] /(n) appearance/presence/
お出掛け [おでかけ] /(n) about to start out/just about to leave or go out/
お出来 [おでき] /(n) (uk) boil/blister/pimple/
お巡り [おまわり] /(n) policeman/
お巡りさん [おまわりさん] /(n) (fam) policeman/(P)/
お暑うございます [おあつうございます] /(exp) it is warm (very polite)/
お暑うご座います [おあつうございます] /(exp) it is warm (very polite)/
お召し [おめし] /(n) (1) (hon) summoning/calling/riding/wearing/dressing/clothing/(2) (abbr) (high-quality) silk crepe (fabric)/
お召し替え [おめしかえ] /(n) (hon) changing one's clothes/a change of clothes/
お召し物 [おめしもの] /(n) (pol) clothing/
お召し列車 [おめしれっしゃ] /(n) Imperial train/royal train/
お奨め [おすすめ] /(n,vs) recommendation/advice/suggestion/encouragement/
お小遣い [おこづかい] /(n) personal expenses/pocket money/spending money/incidental expenses/allowance/
お焦げ [おこげ] /(n) burnt rice/scorched rice/
お笑い [おわらい] /(n) comical (story, song)/comic/
お笑いコンビ [おわらいコンビ] /(n) comic duo/
お笑い芸人 [おわらいげいにん] /(n) comedian (esp. of traditional Japanese comedy)/
お上 [おかみ] /(n) (1) (hon) Emperor/(2) (hon) authorities/government/(3) term used to refer to a woman running a restaurant, inn, etc./landlady/(4) (hon) your wife/his wife/madam/
お上さん [おかみさん] /(n) (uk) missus (orig. honorific, now familiar)/missis/
お上りさん [おのぼりさん] /(n) countryside people (in town)/visitor from the country/out-of-towner/country bumpkin (visiting the big city)/yokel/
お上手 [おじょうず] /(n,adj-na) (1) skill/skillful/dexterity/(2) flattery/
お上手を言う [おじょうずをいう] /(exp,v5u) to flatter/to boot-lick/to curry favour (favor)/
お嬢 [おじょう] /(n) (hon) (someone else's) daughter/
お嬢さま [おじょうさま] /(n) (term of respect for) another's daughter/daughter of a high-class family/
お嬢さん [おじょうさん] /(n) (1) (hon) daughter/(2) young lady/(P)/
お嬢様 [おじょうさま] /(n) (term of respect for) another's daughter/daughter of a high-class family/
お情け [おなさけ] /(n) (1) pity/(2) affection/
お飾り [おかざり] /(n) decorations/offerings/mere window dressing/
お色直し [おいろなおし] /(n,vs) changing one's dress (e.g. at the wedding reception)/
お食い初め [おくいぞめ] /(n) weaning ceremony/
お食事処 [おしょくじどころ] /(n) (Japanese) restaurant/
お尻 [おしり] /(n) arse/ass/bottom/buttocks/
お尻ぺんぺん [おしりぺんぺん] /(n,vs) spanking (a child)/
お寝小 [おねしょ] /(n,vs) (uk) (fem) (chn) bed-wetting/
お新香 [おしんこ] /(n) pickled vegetables/pickles/
お浸し [おひたし] /(n) vegetable side dish/
お神興 [おみこし] /(iK) (n) (1) (pol) portable shrine (carried in festivals)/(2) (uk) buttocks/lower back/waist/hips/
お神酒 [おみき] /(n) sacred wine or sake/sake offered to the gods/
お神渡り [おみわたり] /(n) cracks that form in the ice on Lake Suwa/
お神輿 [おみこし] /(n) (1) (pol) portable shrine (carried in festivals)/(2) (uk) buttocks/lower back/waist/hips/(P)/
お神籤 [おみくじ] /(n) (uk) written oracle/fortune slip/
お針 [おはり] /(n) (1) needlework/sewing/(2) seamstress/
お針子 [おはりこ] /(n) seamstress/
お人よし [おひとよし] /(adj-na,adj-no,n) softhearted (good-natured, credulous) person/easy mark/soft touch/simple soul/
お人好し [おひとよし] /(adj-na,adj-no,n) softhearted (good-natured, credulous) person/easy mark/soft touch/simple soul/
お尋ね者 [おたずねもの] /(n) wanted man/person sought by the police/
お水 [おみず] /(n) (1) (a cup of) water/(adj-na) (2) racy/titillating/sexy/suggestive/
お水取り [おみずとり] /(n) water-drawing ceremony (Toudaiji)/rite of drawing sacred water/
お数 [おかず] /(n) (1) (uk) accompaniment for rice dishes/side dish/(2) food for thought (esp. in the context of conversation, or material for assisting arousal during masturbation)/
お雛様 [おひなさま] /(n) set of dolls on display/
お裾分け [おすそわけ] /(n,vs) sharing with others what has been given to you/sharing a portion of the profit with others/
お澄まし [おすまし] /(adj-na,n) prim and proper girl/
お世辞 [おせじ] /(n) flattery/compliment/(P)/
お世話 [おせわ] /(n) help/aid/assistance/
お世話さま [おせわさま] /(exp) thanks for taking care of me/thanks for taking care of my loved one/
お世話になる [おせわになる] /(exp,v5r) to receive favor (favour)/to be much obliged to someone/to be indebted/to be grateful/
お世話をする [おせわをする] /(exp,vs-i) to take care of/
お成り [おなり] /(n) going out (of a nobleman, etc.)/visiting/
お正月太り [おしょうがつぶとり] /(n) putting on weight over the New Year's holidays/
お生 [おなま] /(n,adj-na) (fem) impudence/sauciness/
お生憎さま [おあいにくさま] /(adj-na,int,n) that's too bad (ironical)/unfortunate person (often a gleeful "too bad for you!")/
お生憎様 [おあいにくさま] /(adj-na,int,n) that's too bad (ironical)/unfortunate person (often a gleeful "too bad for you!")/
お声掛かり [おこえがかり] /(n) a recommendation/an order/
お節 [おせち] /(n) food served during the New Year's Holidays/
お節介 [おせっかい] /(adj-na,n) meddling/meddlesomeness/nosiness/interference/officiousness/(P)/
お節料理 [おせちりょうり] /(n) food served during the New Year's Holidays/(P)/
お先 [おさき] /(n) going before/the future/
お先に [おさきに] /(adv) (1) before/previously/(2) ahead/(exp) (3) (abbr) (hon) Pardon me for leaving (before you)/
お先に失礼します [おさきにしつれいします] /(exp) pardon me for leaving (first) (used when leaving a workplace while others remain)/
お先真っ暗 [おさきまっくら] /(adj-na) (of the future) very bleak/dim/
お先棒 [おさきぼう] /(n) a person whose services are at the disposal of another/
お先棒を担ぐ [おさきぼうをかつぐ] /(exp,v5g) to be a willing cats-paw or tool for a person/
お薦 [おこも] /(n) (arch) beggar/
お薦め [おすすめ] /(n,vs) recommendation/advice/suggestion/encouragement/
お前 [おまい] /(pn,adj-no) (1) (fam) (male) you (formerly honorific, now sometimes derog. term referring to an equal or inferior)/
お前 [おまえ] /(pn,adj-no) (1) (fam) (male) you (formerly honorific, now sometimes derog. term referring to an equal or inferior)/(2) presence (of a god, nobleman, etc.)/(P)/
お前 [おめえ] /(pn,adj-no) (1) (fam) (male) you (formerly honorific, now sometimes derog. term referring to an equal or inferior)/
お前さま [おまえさま] /(n) (hon) (arch) you/
お前さん [おまえさん] /(n) (1) you/(2) my dear/(3) hey/
お膳 [おぜん] /(n) (uk) four-legged tray for festive food/
お膳立て [おぜんだて] /(n,vs) setting the table/preparation/
お祖父さん [おじいさん] /(n) (1) grandfather/(2) male senior-citizen/(P)/
お祖父ちゃん [おじいちゃん] /(n) (col) grandpa/grandad/
お祖母さん [おばあさん] /(n) (1) grandmother/(2) female senior-citizen/(P)/
お祖母ちゃん [おばあちゃん] /(n) (uk) (fam) granny/grandma/gran/female senior-citizen/
お粗末 [おそまつ] /(adj-na) poor/lame/ill-prepared/
お粗末さまでした [おそまつさまでした] /(exp) (hum) expression of humility said by the person who provided a meal after it is eaten/
お粗末様でした [おそまつさまでした] /(exp) (hum) expression of humility said by the person who provided a meal after it is eaten/
お倉 [おくら] /(n) (1) shelving (a play, movie, etc.)/closing down/cancelling/canceling/the shelf/(2) rice storehouse of the Edo shogunate/
お早う [おはよう] /(int) (uk) (abbr) Good morning/(P)/
お早うございます [おはようございます] /(int) (uk) (pol) good morning/(P)/
お相伴 [おしょうばん] /(n,vs) sharing a meal/
お草々 [おそうそう] /(adj-na) neglectful (i.e. in the treatment of one's guests)/
お草々様 [おそうそうさま] /(adj-na) (pol) neglectful (i.e. in the treatment of one's guests)/
お草草 [おそうそう] /(adj-na) neglectful (i.e. in the treatment of one's guests)/
お草草様 [おそうそうさま] /(adj-na) (pol) neglectful (i.e. in the treatment of one's guests)/
お蔵 [おくら] /(n) (1) shelving (a play, movie, etc.)/closing down/cancelling/canceling/the shelf/(2) rice storehouse of the Edo shogunate/
お造り [おつくり] /(n) (1) make-up/(2) (ksb:) sashimi/
お揃い [おそろい] /(adj-no) same/matching/going together/
お孫さん [おまごさん] /(n) (hon) grandchild/
お多福 [おたふく] /(n) moon-faced woman/homely woman/
お多福豆 [おたふくまめ] /(n) (1) large broad bean/(2) (boiled and sweetened) broad bean/
お多福風邪 [おたふくかぜ] /(n) mumps/
お太鼓 [おたいこ] /(n) (abbr) very common way of tying a woman's kimono sash/
お太鼓結び [おたいこむすび] /(n) very common way of tying a woman's kimono sash/
お陀仏 [おだぶつ] /(n) dying/ruining oneself/
お待たせしました [おまたせしました] /(exp) Thank you for waiting/Have I kept you waiting?/
お待ち [おまち] /(n,n-suf) waiting/waiting time/
お待ち遠さま [おまちどおさま] /(exp) I'm sorry to have kept you waiting/
お待ち遠様 [おまちどおさま] /(exp) I'm sorry to have kept you waiting/
お待ち兼ね [おまちかね] /(n,adj-no) long-waited-for/
お替り [おかわり] /(n,vs) (1) second helping/another cup/seconds/(int) (2) command to have dog place its second paw in one's hand/
お替わり [おかわり] /(n,vs) (1) second helping/another cup/seconds/(int) (2) command to have dog place its second paw in one's hand/
お袋 [おふくろ] /(n) (col) one's mother/(P)/
お代り [おかわり] /(n,vs) (1) second helping/another cup/seconds/(int) (2) command to have dog place its second paw in one's hand/
お代わり [おかわり] /(n,vs) (1) second helping/another cup/seconds/(int) (2) command to have dog place its second paw in one's hand/(P)/
お大事に [おだいじに] /(exp) take care of yourself/
お題目 [おだいもく] /(n) (1) (pol) Nichiren chant/(2) (an empty) slogan/
お宅 [おたく] /(n) (1) (hon) your house/your home/your family/(2) (hon) your husband/(3) (hon) your organization/(pn,adj-no) (4) (hon) you (referring to someone of equal status with whom one is not especially close)/(P)/
お達し [おたっし] /(n) notice or order handed down from above/announcement/notification/
お誕生おめでとうございます [おたんじょうおめでとうございます] /(exp) congratulations on the birth of your baby/
お誕生会 [おたんじょうかい] /(n) birthday party/
お誕生日おめでとう [おたんじょうびおめでとう] /(exp) Happy Birthday/
お誕生日おめでとうございます [おたんじょうびおめでとうございます] /(exp) Happy Birthday/
お弾き [おはじき] /(n) (1) children's game similar to marbles, played with coin-shaped coloured glass/(2) tiddlywink/counter/
お断り [おことわり] /(n) (pol) declining/nonacceptance/declination/refusal/rejection/turndown/
お断わり [おことわり] /(n) (pol) declining/nonacceptance/declination/refusal/rejection/turndown/
お段 [おだん] /(n) (ling) 'o' row/
お談義 [おだんぎ] /(n) lecture (i.e. an admonishment)/sermon/
お知らせ [おしらせ] /(n,vs) notice/notification/
お茶 [おちゃ] /(n) (1) (pol) tea (usu. green)/(2) tea break (at work)/(3) tea ceremony/(P)/
お茶する [おちゃする] /(exp,vs-i) (col) to go out for tea (or coffee, etc.)/
お茶っ葉 [おちゃっぱ] /(n) tea leaves/
お茶の子 [おちゃのこ] /(n) a cinch/
お茶を濁す [おちゃをにごす] /(exp,v5s) (1) to make do with/(2) to cook up a specious story to get out of an uncomfortable situation/(3) to speak ambiguously/to prevaricate/(4) to be evasive/to give an evasive answer/
お茶請け [おちゃうけ] /(n) tea-cake/
お茶目 [おちゃめ] /(adj-na,n) playfulness/mischief/urchin/wag/
お中 [おなか] /(n) stomach/
お中元 [おちゅうげん] /(n) Bon Festival gifts/(P)/
お昼 [おひる] /(n-adv,n) (pol) lunch/noon/
お猪口 [おちょこ] /(n) (1) (uk) small cup/sake cup/(2) cup-shaped/
お喋り [おしゃべり] /(adj-na,n,adj-no,vs) (uk) chattering/talk/idle talk/chat/chitchat/gossip/chatty/talkative/chatterbox/blabbermouth/(P)/
お調子者 [おちょうしもの] /(n,adj-no) flip/luck-pusher/frivolous person/person who readily chimes in with others/person who gets carried away easily/
お通し [おとおし] /(n) appetizer/appetiser/
お通じ [おつうじ] /(n) (pol) bowel movement/evacuation/
お通夜 [おつや] /(n) (pol) all-night vigil over a body/wake/
お釣り [おつり] /(n) (pol) change (i.e. money)/balance/(P)/
お定まり [おさだまり] /(n) usual/normal/stereotyped/
お摘まみ [おつまみ] /(n) snacks to go with alcohol/
お摘み [おつまみ] /(n) snacks to go with alcohol/
お天気 [おてんき] /(n) (1) (pol) weather/(2) temper/mood/
お天気屋 [おてんきや] /(n) moody person/temperamental person/fickle person/
お天道様 [おてんとさま] /(n) the sun/
お店 [おたな] /(n) (1) merchant's home (esp. used by apprentices, etc.)/(2) (your) rental home/
お転婆 [おてんば] /(adj-na,n) tomboy (dut: ontembaar)/
お点前 [おてまえ] /(n) (1) skill/dexterity/artistry/ingenuity/(2) etiquette of tea-ceremony/
お田植え祭 [おたうえまつり] /(n) (1) shrine ritual held with the first two months of the year to forecast (or pray for) a succesful harvest/(2) seasonal planting of rice on a field affiliated with a shrine/
お田植え祭り [おたうえまつり] /(n) (1) shrine ritual held with the first two months of the year to forecast (or pray for) a succesful harvest/(2) seasonal planting of rice on a field affiliated with a shrine/
お屠蘇 [おとそ] /(n) New Year's sake/spiced sake/
お土産 [おみやげ] /(n) (pol) present/souvenir/(P)/
お土産話 [おみやげばなし] /(n) trip story/vacation story/
お湯 [おゆ] /(n) (1) (pol) hot water/(2) (pol) hot bath/
お得意さん [おとくいさん] /(n) regular customer/valued client/
お徳 [おとく] /(n) economical/
お凸 [おでこ] /(n) (sens) brow/forehead/(P)/
お内 [おうち] /(n) (pol) your home/your group/their home/
お内儀さん [おかみさん] /(n) (uk) missus (orig. honorific, now familiar)/missis/
お鍋 [おなべ] /(n) (1) (pol) pot/(2) (arch) typical name for a female servant in the Edo-period/(3) working at night/(4) (uk) (sl) female with symptoms of gender identity disorder (i.e. a transvestite)/
お馴み [おなじみ] /(iK) (adj-no,n) (pol) familiar/well-known/regular (e.g. customer)/old stand-by/
お馴染み [おなじみ] /(adj-no,n) (pol) familiar/well-known/regular (e.g. customer)/old stand-by/(P)/
お日様 [おひさま] /(n) the sun/
お任せ [おまかせ] /(exp) I'll leave it to you/meal selected by the chef/
お忍び [おしのび] /(n) (1) (abbr) travelling incognito (traveling)/(2) special palanquin for carrying a daimyo or his wife incognito/
お熱 [おねつ] /(n) (1) having a crush on someone/(2) flushing/
お年玉 [おとしだま] /(n) New Year's gift (usu. money given to a child by relatives and visitors)/(P)/
お捻り [おひねり] /(n) wrapped offering (of money)/
お婆さん [おばあさん] /(n) (1) grandmother/(2) female senior-citizen/
お婆ちゃん [おばあちゃん] /(n) (uk) (fam) granny/grandma/gran/female senior-citizen/(P)/
お婆はる [おばはる] /(v5r) (sl) to shamelessly demand one's rights/
お婆ん [おばん] /(n) old maid/frump/hag/old woman/
お馬鹿さん [おばかさん] /(n) silly person/dumb-bunny/dope/
お買い上げ [おかいあげ] /(n) (hon) buying/purchasing/
お買い得 [おかいどく] /(n,adj-no) bargain/good buy/budget/(P)/
お買い徳 [おかいどく] /(iK) (n,adj-no) bargain/good buy/budget/
お買得 [おかいどく] /(n,adj-no) bargain/good buy/budget/(P)/
お買徳 [おかいどく] /(iK) (n,adj-no) bargain/good buy/budget/
お萩 [おはぎ] /(n) rice ball coated with sweetened red beans, soybean flour or sesame/
お白州 [おしらす] /(n) (arch) court of law in the Edo period, in which the parties sat on white sand/
お薄 [おうす] /(n) weak matcha/
お八 [おやつ] /(n) (1) (uk) between meal snack/(2) mid-afternoon (around 3 o'clock) snack/afternoon refreshment/afternoon tea/
お八つ [おやつ] /(n) (1) (uk) between meal snack/(2) mid-afternoon (around 3 o'clock) snack/afternoon refreshment/afternoon tea/(P)/
お鉢 [おはち] /(n) container for boiled rice/
お鉢が回ってくる [おはちがまわってくる] /(exp,vk) one's turn finally comes round/
お髪 [おぐし] /(n) (hon) hair/
お晩彩 [おばんさい] /(iK) (n) (uk) light Kyoto-style home cooking with boiled vegetables and marinated food, also now served in restaurants/
お晩彩 [おばんざい] /(iK) (n) (uk) light Kyoto-style home cooking with boiled vegetables and marinated food, also now served in restaurants/
お晩菜 [おばんさい] /(n) (uk) light Kyoto-style home cooking with boiled vegetables and marinated food, also now served in restaurants/
お晩菜 [おばんざい] /(n) (uk) light Kyoto-style home cooking with boiled vegetables and marinated food, also now served in restaurants/
お番菜 [おばんさい] /(n) (uk) light Kyoto-style home cooking with boiled vegetables and marinated food, also now served in restaurants/
お番菜 [おばんざい] /(n) (uk) light Kyoto-style home cooking with boiled vegetables and marinated food, also now served in restaurants/
お披露目 [おひろめ] /(n,vs) debut/
お疲れさま [おつかれさま] /(exp) (1) thank you/many thanks/much appreciated/(2) that's enough for today/(P)/
お疲れ様 [おつかれさま] /(exp) (1) thank you/many thanks/much appreciated/(2) that's enough for today/(P)/
お美事 [おみごと] /(int) well done!/bravo/
お膝下 [おひざもと] /(n) home territory of a powerful figure/Imperial Court/businessman's turf/Shogun's headquarters/
お膝許 [おひざもと] /(n) home territory of a powerful figure/Imperial Court/businessman's turf/Shogun's headquarters/
お膝元 [おひざもと] /(n) home territory of a powerful figure/Imperial Court/businessman's turf/Shogun's headquarters/
お姫様 [おひめさま] /(n) spoiled girl/hothouse flower/princess/
お姫様だっこ [おひめさまだっこ] /(n,vs) (col) carrying a person in one's arms/
お姫様抱っこ [おひめさまだっこ] /(n,vs) (col) carrying a person in one's arms/
お百姓さん [おひゃくしょうさん] /(n) farmer/
お百度 [おひゃくど] /(n) hundred times worship (e.g. walking back and forth a hundred times before a shrine offering a prayer each time)/
お百度を踏む [おひゃくどをふむ] /(exp,v5m) (obs) to visit repeatedly (to request)/
お付き [おつき] /(n) retainer/attendant/escort/
お付き合い [おつきあい] /(n) association/socializing/socialising/fellowship/
お父さま [おとうさま] /(n) (hon) father/
お父さん [おとうさん] /(n) (hon) father/dad/papa/pa/pop/daddy/dada/(P)/
お父様 [おとうさま] /(n) (hon) father/
お負け [おまけ] /(n,vs) (1) freebie (e.g. with a purchase)/something additional/bonus/an extra/(2) (on the spot) price reduction/(3) exaggeration/(P)/
お負けに [おまけに] /(conj,exp) to make matters worse/besides/what's more/in addition/on top of that/
お部屋 [おへや] /(n) (hon) (pol) room/
お風呂 [おふろ] /(n) bath/
お風呂に入る [おふろにはいる] /(exp,v5r) to take a bath/
お腹 [おなか] /(n) stomach/(P)/
お腹いっぱい [おなかいっぱい] /(exp) (1) (col) full up/(2) to have had enough of something (both good and bad nuance)/
お腹がすく [おなかがすく] /(exp,v5k) to become hungry/to get an empty stomach/
お腹がへる [おなかがへる] /(exp,v5r) to become hungry/
お腹が空く [おなかがすく] /(exp,v5k) to become hungry/to get an empty stomach/
お腹が減る [おなかがへる] /(exp,v5r) to become hungry/
お腹の子 [おなかのこ] /(exp) child one is expecting/(P)/
お腹をすかす [おなかをすかす] /(exp,v5s) to feel hungry/to get hungry/
お腹を空かす [おなかをすかす] /(exp,v5s) to feel hungry/to get hungry/
お腹を空かせる [おなかをすかせる] /(exp,v1) to feel hungry/to get hungry/
お払い箱 [おはらいばこ] /(n) discarding/firing (an employee)/
お払い物 [おはらいもの] /(n) goods to offer the junk dealer/
お聞きいただく [おききいただく] /(v5k) to ask (politely)/
お聞き頂く [おききいただく] /(v5k) to ask (politely)/
お平に [おたいらに] /(exp) please make yourself comfortable/please relax your sitting position/
お平らに [おたいらに] /(exp) please make yourself comfortable/please relax your sitting position/
お米 [おこめ] /(n) (husked grains of) rice/
お別れ [おわかれ] /(n) farewell/
お変わりありませんか [おかわりありませんか] /(exp) (pol) how have (you) been? (gen. used after some time apart)/lit: nothing (untoward) has happened, has it?/
お返し [おかえし] /(n,vs) (1) return gift/return favour (favor)/(2) revenge/(3) change (in a cash transaction)/(P)/
お勉め品 [おつとめひん] /(n) article offered at a bargain price/real bargain/
お弁当 [おべんとう] /(n) bento (Japanese box lunch)/
お母 [おふくろ] /(iK) (n) (col) one's mother/
お母さま [おかあさま] /(n) (hon) mother/
お母さん [おかあさん] /(n) (hon) mother/(P)/
お母ちゃん [おかあちゃん] /(n) (fam) mum/mom/
お母様 [おかあさま] /(n) (hon) mother/
お報せ [おしらせ] /(n,vs) notice/notification/
お宝 [おたから] /(n,adj-no) (1) (pol) treasure/(2) picture of a treasure ship/(3) money/cash/
お方 [おかた] /(n) this lady or gentleman/
お坊さん [おぼうさん] /(n) Buddhist priest/monk/(P)/
お坊ちゃん [おぼっちゃん] /(n) (1) (hon) son (of others)/(2) young master/(3) green young man from a well-to-do family/
お坊っちゃん [おぼっちゃん] /(n) (1) (hon) son (of others)/(2) young master/(3) green young man from a well-to-do family/
お墨付き [おすみつき] /(n) (1) handwriting/autograph/authorization/authorisation/(2) certificate/certified document/paper with signature of the shogun or lord/
お盆 [おぼん] /(n) O-Bon/Bon Festival/Lantern Festival/Festival of the Dead/
お毛々 [おけけ] /(n) (sl) (vulg) pubic hair/
お毛毛 [おけけ] /(n) (sl) (vulg) pubic hair/
お目 [おめ] /(n) (1) (hon) eye/eyes/(2) sight/vision/looking/
お目々 [おめめ] /(n) (sl) eyes (kid talk)/
お目にかかる [おめにかかる] /(exp,v5r) (1) (hum) to meet (someone of higher status)/(2) (arch) to be recognized (esp. by someone of higher status)/to be visible/to be seen/to be noticed/
お目にかける [おめにかける] /(exp,v1) (hum) to show/
お目にとまる [おめにとまる] /(exp,v5r) to be recognized (by someone of higher status)/to be noticed/to get attention/
お目に掛かる [おめにかかる] /(exp,v5r) (1) (hum) to meet (someone of higher status)/(2) (arch) to be recognized (esp. by someone of higher status)/to be visible/to be seen/to be noticed/
お目に掛ける [おめにかける] /(exp,v1) (hum) to show/
お目に留まる [おめにとまる] /(exp,v5r) to be recognized (by someone of higher status)/to be noticed/to get attention/
お目もじ [おめもじ] /(n,vs) personal meeting (esp. used by females)/
お目覚 [おめざ] /(n) type of candy given to a child after it wakes up from a nap/wake-up sweets/
お目覚まし [おめざまし] /(n) type of candy given to a child after it wakes up from a nap/wake-up sweets/
お目玉 [おめだま] /(n) a scolding/
お目玉を食らう [おめだまをくらう] /(exp,v5u) to get a good scolding/
お目見え [おめみえ] /(n,vs) (1) (the privilege to have) an audience (with one's lord, a dignitary, etc.)/interview (with one's superior)/(2) one's debut (first) appearance/debut (of a new product, work of art, actor, etc.)/(3) trial service (of a servant)/
お目見得 [おめみえ] /(n,vs) (1) (the privilege to have) an audience (with one's lord, a dignitary, etc.)/interview (with one's superior)/(2) one's debut (first) appearance/debut (of a new product, work of art, actor, etc.)/(3) trial service (of a servant)/
お目出度い [おめでたい] /(ateji) (n) (1) (uk) (pol) special/auspicious/happy/(2) naive/inncocent/good-natured/
お目出度う [おめでとう] /(ateji) (int) (uk) congratulations!/an auspicious occasion!/(P)/
お目出度うご座います [おめでとうございます] /(exp) (uk) congratulations/
お目文字 [おめもじ] /(n,vs) personal meeting (esp. used by females)/
お目目 [おめめ] /(n) (sl) eyes (kid talk)/
お餅 [おもち] /(n) (uk) rice cakes/pounded mochi rice/
お問い合わせ [おといあわせ] /(n) enquiry/inquiry/
お門違い [おかどちがい] /(exp) barking up the wrong tree/calling at the wrong house/
お爺さん [おじいさん] /(n) (1) grandfather/(2) male senior-citizen/
お役御免 [おやくごめん] /(n) dismissal/firing/retirement/being relieved from one's post/being relieved of a burden/
お役所仕事 [おやくしょしごと] /(n) bureaucratic routine/red tape/
お役目 [おやくめ] /(n) (public) duty/
お預け [おあずけ] /(n) postponement/wait (until one is given permission)/
お預けを食う [おあずけをくう] /(exp,v5u) to have to wait (for the realization of something hoped for)/to be forced to postpone/
お預けを食らう [おあずけをくらう] /(exp,v5u) to have to wait (for the realization of something hoped for)/to be forced to postpone/
お里 [おさと] /(n) (1) (hon) (pol) one's parents' home/(2) one's origins/one's upbringing/one's past/
お里が知れる [おさとがしれる] /(exp,v1) to reveal one's upbringing (through one's words, actions, etc.)/to betray one's origin/to give oneself away/
お立ち [おたち] /(n) polite term for calling, departing and staying where one is/
お立ち台 [おたちだい] /(n) Balcony of Appearances (where the royal family appear)/
お流れ [おながれ] /(n) cancellation/abandonment/
お留守になる [おるすになる] /(exp,v5r) to fail to be attentive to/
お旅所 [おたびしょ] /(n) place where the sacred palanquin is lodged during a festival/
お隣さん [おとなりさん] /(n) (hon) the next-door neighbour (neighbor)/
お涙頂戴 [おなみだちょうだい] /(n,adj-no) tearjerker/sob story/maudlin tale/
お冷 [おひや] /(n) cold (drinking) water/cold boiled rice/
お冷や [おひや] /(n) cold (drinking) water/cold boiled rice/
お礼 [おれい] /(n) thanking/expression of gratitude/(P)/
お礼の申しよう [おれいのもうしよう] /(n) expression of gratitude/
お礼の申し様 [おれいのもうしよう] /(n) expression of gratitude/
お礼参り [おれいまいり] /(n) (1) visiting a shrine or temple to give thanks/(2) settling scores/
お礼奉公 [おれいぼうこう] /(n) free service after one has finished one's apprenticeship/
お零れ [おこぼれ] /(n) leavings/leftovers/
お歴々 [おれきれき] /(n) dignitaries/very important persons/VIPs/
お歴歴 [おれきれき] /(n) dignitaries/very important persons/VIPs/
お漏らし [おもらし] /(n,vs) (col) peeing/
お話 [おはなし] /(n) story/tale/
お話し [おはなし] /(n) story/tale/
お話し中 [おはなしちゅう] /(n) busy (phone)/(P)/
お話中 [おはなしちゅう] /(n) busy (phone)/
お詫び [おわび] /(n,vs) apology/
お碗 [おわん] /(n) bowl/
お恍け [おとぼけ] /(n) feigned ignorance/
お櫃 [おひつ] /(n) (uk) round, wooden container for cooked rice/
お洒落 [おしゃれ] /(adj-na,adj-no) (1) (uk) smartly dressed/stylish/fashion-conscious/(n) (2) someone smartly dressed/(vs) (3) to dress up/to be fashionable/
お浚い [おさらい] /(n) review/rehearsal/
お祓い [おはらい] /(n) exorcism (Shinti rite)/purification/
お臍 [おへそ] /(n) navel/belly button/
お襁褓 [おむつ] /(n) (uk) diaper/nappy/
お襁褓気触れ [おむつかぶれ] /(n) (uk) diaper rash/nappy rash/
お誂え向き [おあつらえむき] /(adj-no) perfect/just right/ideal/
か /(prt) (1) indicates question (sentence end)/(2) indicates choice, doubt, etc./(P)/
かあ /(n) cawing (of a crow)/
かあかあ /(adv) (1) (on-mim) caw-caw (the sound of a crow cawing)/(n) (2) (sl) crow (childish term)/
かい /(prt) (fam) marks yes-no question/(P)/
かいつぶり /(n) (1) (uk) little grebe (Tachybaptus ruficollis)/(2) grebe (any waterbird of family Podicipedidae)/
かいま見る [かいまみる] /(v1,vt) to take a peep at/to catch a glimpse of/
かいま聞く [かいまきく] /(v5k,vt) (col) (obsc) to get wind of/
かい込む [かいこむ] /(v5m,vt) to carry under the arm/to rake in/to scoop up/
かい出す [かいだす] /(v5s,vt) to bail out/
かい摘む [かいつまむ] /(v5m,vt) (uk) to sum up/to summarize/to summarise/
かえ /(prt) (fam) marks yes-no question/
かえるの目借時 [かえるのめかりどき] /(exp) springtime mating of frogs (haiku term)/
かえるの目借時 [かえるのめかるどき] /(exp) springtime mating of frogs (haiku term)/
かかえ込む [かかえこむ] /(v5m,vt) to hold (carry) a thing in one's arm/to embrace (a baby)/to take upon oneself/
かかり合う [かかりあう] /(v5u) to have dealings with/to be involved in/
かかわり合う [かかわりあう] /(v5u) to get involved or entangled in/to get mixed up in/to have something to do with/to have dealings with/
かがい /(n) (arch) ritual singing and dancing gathering of young men and women/
かがみ込む [かがみこむ] /(v5m,vi) to lean over/to lean in/
かがり火 [かがりび] /(n) bonfire/watch fire/fishing fire/cresset/brazier/
かきこ /(n) (abbr) (sl) post (to a BBS)/comment (on a blog)/
かき回す [かきまわす] /(v5s,vt) to stir up/to churn/to ransack/to disturb/
かき寄せる [かきよせる] /(v1,vt) to sweep/to rake up/
かき交ぜる [かきまぜる] /(v1) to mix/to stir/to scramble/to churn/
かき口説く [かきくどく] /(v5k,vi) to complain/to pester/to plead/to beg/
かき合せる [かきあわせる] /(v1,vt) to adjust/to arrange/
かき混ぜる [かきまぜる] /(v1) to mix/to stir/to scramble/to churn/
かき混ぜ規則 [かきまぜきそく] /(n) scrambling/
かき菜 [かきな] /(n) (uk) kakina (green leafy vegetable of the genus Brassica)/
かき集める [かきあつめる] /(v1,vt) to gather up/to scrape up together/
かき傷 [かききず] /(n) scratch/scrape/abrasion/
かき消える [かききえる] /(v1,vi) to disappear/
かき消す [かきけす] /(v5s,vt) to erase/
かき切る [かききる] /(v5r,vt) to cut/to slit/
かき氷 [かきごおり] /(n) shaved ice (usually served with flavored simple syrup)/Italian ice/Sno-cone/snow cone/(P)/
かき分ける [かきわける] /(v1,vt) to push one's way through/
かき鳴らす [かきならす] /(v5s,vt) to thrum/to strum/
かき揚げ [かきあげ] /(n) shrimp and vegetable fritters/
かき乱す [かきみだす] /(v5s,vt) to stir up/to disturb/
かき立てる [かきたてる] /(v1,vt) to stir up/to arouse/
かぎ回る [かぎまわる] /(v5r) to sniff around (looking for)/
かぎ取る [かぎとる] /(v5r,vt) (1) to smell/(2) to sense/
かぎ出す [かぎだす] /(v5s,vt) to scent out/to detect/
かぎ針 [かぎばり] /(n) hook/crochet needle/
かぎ針編み [かぎばりあみ] /(n) crochet/
かぎ爪 [かぎづめ] /(n) claw/talon/
かぎ縄 [かぎなわ] /(n) ninja rope with grappling hook/
かくかくしかじか /(exp) blah-blah yadda-yadda/expression used to replace part of conversation/
かくはん機 [かくはんき] /(n) mixer/agitator/
かくれ家 [かくれが] /(n) hiding place/refuge/
かく乱 [かくらん] /(n,vs) disturbance/perturbation/derangement/
かけたかの鳥 [かけたかのとり] /(n) (obsc) lesser cuckoo (Cuculus poliocephalus)/
かけ寄る [かけよる] /(v5r,vi) to rush over/to run up to/
かけ橋 [かけはし] /(n) (1) suspension bridge/viaduct/temporary bridge/(2) mediation/go-between/
かけ合い [かけあい] /(n) (1) negotiations/bargaining/(2) dialogue/duet/
かけ合う [かけあう] /(v5u,vi) to negotiate with/to talk over with/
かけ算 [かけざん] /(n) multiplication/
かけ持ち [かけもち] /(n,vs) holding two or more positions concurrently/
かけ声 [かけごえ] /(n,vs) yell used to time or encourage activity (e.g. "Heave ho!", "On three ... One, two, three!" in English)/enthusiastic shout from the audience (e.g. in kabuki)/shouting (in concerts)/
かけ直す [かけなおす] /(v5s) to call again/to call someone back/
かけ離む [かけこむ] /(v5m,vi) to rush in (at the last minute)/to stampede/
かけ離れる [かけはなれる] /(v1,vi) to be very far apart from/to be remote/to be quite different from/
かこう岩 [かこうがん] /(n,adj-no) granite/
かごの鳥 [かごのとり] /(exp) (1) caged bird/(2) person whose freedom has been restricted (esp. a prostitute, mistress, concubine, etc.)/
かご漁 [かごりょう] /(n) fishing baskets (esp. for crabs, lobsters, etc.)/lobster pots/
かさかさ /(adj-na,vs,adv,adv-to) (1) (on-mim) dry/bone dry/(2) rustle/
かさかさ鳴る [かさかさなる] /(v5r) to rustle/to make a rustling sound/to crinkle/
かさこそ /(adv,adv-to) rustlingly/
かさに着る [かさにきる] /(exp,v1) to wear the mantle of (borrowed) authority and misuse it/
かさねの色目 [かさねのいろめ] /(n) combination of colors created by layering of garments (colours)/
かさ高 [かさだか] /(adj-na) (1) bulky/unwieldy/(2) haughty/high-handed/
かさ高い [かさだかい] /(adj-i) (1) bulky/unwieldy/(2) haughty/high-handed/
かさ上げ [かさあげ] /(n,vs) increase/raising (e.g. embankment, levee)/padding or inflation (e.g. of a bill)/
かざみ /(n) (uk) swimming crab (Portunus trituberculatus)/
かざり職 [かざりしょく] /(n) maker of metallic ornaments/
かしめる /(v1) to caulk/
かしゃかしゃ /(adv-to) (on-mim) click-clack/clickety-click/clicking sound/clattering sound/
かしゃっ /(adv-to) with a click/
かしら /(prt) I wonder/(P)/
かし携帯 [かしけいたい] /(n) rental mobile phone/rental cell phone/cell phone that is rented/
かじき座 [かじきざ] /(n) (constellation) Dorado/Goldfish/Swordfish/
かじ取り [かじとり] /(n,vs) helmsman/coxwain/steering/guidance/
かじ付き [かじつき] /(adj-f) coxed (rowing)/having a coxswain/
かじ付きフォア [かじつきフォア] /(n) coxed-four (rowing)/
かじ無し [かじなし] /(adj-f) coxless (rowing)/
かすかす /(adj-na,adj-no,adv,vs) (1) dry (and tasteless)/(adv,vs) (2) barely/just/
かすり傷 [かすりきず] /(n,vs) scratch/graze/abrasion/
かすれ声 [かすれごえ] /(n) hoarse voice/husky voice/
かすんだ /(adj-f) (comp) grayed/
かす汁 [かすじる] /(n) soup made with sake lees/
かずの子 [かずのこ] /(n) herring roe/
かせぎ高 [かせぎだか] /(n) earnings/
かせ糸 [かせいと] /(n) reeled thread/
かせ蚯蚓 [かせみみず] /(n) Epimenia verrucosa (mollusc)/
かぜ薬 [かぜぐすり] /(n) remedy for a cold/cold medicine/
かそこら /(exp) around .../or so/
かたいことは言いっこなし [かたいことはいいっこなし] /(exp) let's put formalities aside/let's not speak so stiffly/
かたかた /(adv,n,vs) (on-mim) clattering/
かたきを討つ [かたきをうつ] /(exp,v5t) to take revenge/
かたき討 [かたきうち] /(n) vengeance/revenge/retaliation/
かたき討ち [かたきうち] /(n) vengeance/revenge/retaliation/
かたくり粉 [かたくりこ] /(n) (1) potato starch/(2) starch of dogtooth violet/
かたり /(adv-to) (on-mim) with a clatter/clatteringly/
かちかち /(adj-na,adv,n) (on-mim) tick-tock/knocking (stones together)/frozen solid/set rock hard/obstinate/scared stiff/(P)/
かちっと /(adv,vs) (1) (on-mim) with a click (door sound)/(2) with tenseness or firmness/
かちゃかちゃ /(n,adv-to) clink/clatter/clang/
かちゃり /(adv-to) (on-mim) with a clang or a clink/tinkle/
かちり /(adv-to) (on-mim) with a clink (click, clack)/
かちん /(adv-to,n) (on-mim) clink/clack/
かちんこ /(n) clapperboard/
かち合う [かちあう] /(v5u,vi) to clash/to be in conflict with/
かっか /(adv,adv-to,vs) (on-mim) burning hotly/burning redly/
かっかと /(adv,adv-to,vs) (on-mim) burning hotly/burning redly/
かっきり /(adv) (1) (on-mim) exactly/just/precisely/(2) punctually/(adv-to) (3) clearly delineated (of boundaries, etc.)/
かっきりに /(adv) (1) (on-mim) exactly/just/precisely/(2) punctually/
かっけー /(adj-na,adj-no) (col) attractive/good-looking/stylish/"cool"/
かっこかわいい /(exp) (col) cool and cute/
かっこ悪い [かっこわるい] /(adj-i) unattractive/ugly/unstylish/uncool/
かっこ好い [かっこいい] /(adj-i) attractive/good-looking/stylish/"cool"/
かっちり /(adv,n,vs) tightly/exactly/
かっと /(adv,n,vs) (on-mim) flare up/flying into a rage/
かっとなる /(exp,v5r) (col) to flare up/to fly into a rage/
かっぺ /(n) (abbr) (vulg) hick/country bumpkin/yokel/
かっぽれ /(n) kappore (traditional Japanese comic dance)/
かっ血 [かっけつ] /(n,vs) lung hemorrhage/lung haemorrhage/
かっ飛ばす [かっとばす] /(v5s,vt) to knock out (a homer)/to slam/
かつお節 [かつおぶし] /(n) katsuobushi (small pieces of sliced dried bonito)/
かつかつ /(adj-na,adv) (on-mim) barely/scraping by/
かて /(prt) (1) (ksb:) even if/if/(2) (ksb:) though/despite/(3) (ksb:) even/
かてきょ /(n) (abbr) (sl) home tutor/private tutor/coach/
かてて加えて [かててくわえて] /(exp) moreover/besides/in addition/on top of/to make matters worse/
かと言って [かといって] /(exp) (uk) having said that/on the other hand/
かどうか /(exp) whether or not (in phrases like "I don't know whether or not I can come")/(P)/
かな /(prt) (1) I wonder (sentence ending prt)/(2) should I? (question prt when thinking out loud)/is it?/(3) I wish that (with a negative)/I hope that/(P)/
かなあ /(prt) (1) I wonder (sentence ending prt)/(2) should I? (question prt when thinking out loud)/is it?/(3) I wish that (with a negative)/I hope that/
かなきり声 [かなきりごえ] /(n,adj-no) shrill voice/piercing cry/shriek/scream/
かなぐり捨てる [かなぐりすてる] /(v1) to fling off/to throw off/to throw to the winds/
かなとこ雲 [かなとこぐも] /(n) anvil cloud/
かなにか /(exp,suf) or something/
かな漢字変換 [かなかんじへんかん] /(n) (comp) kana-kanji conversion (on a computer, etc.)/
かな遣い [かなづかい] /(n) kana orthography/syllabary spelling/
かな使い [かなづかい] /(n) kana orthography/syllabary spelling/
かな入力 [かなにゅうりょく] /(n) (comp) kana input/
かね /(prt) interrogative sentence-ending particle expressing doubt/(P)/
かねてから /(exp) for some time/
かばち /(n) (col) quibble (in Hiroshima dialect)/
かばと /(adv) (on-mim) emphatically/energetically/
かばん語 [かばんご] /(n) (obs) portmanteau/combination of two words (often first half of one, second half of another)/
かばん持ち [かばんもち] /(n) (1) private secretary/(2) (derog) flunky/someone who is always following around someone of high rank/(3) someone who carries a bag for someone/luggage carrier/carrying a bag/
かば焼き [かばやき] /(n) loach or eel dipped and broiled in soy-based sauce/
かび止め [かびどめ] /(n) fungicide/preservative against mold/antimold agent/
かび臭い [かびくさい] /(adj-i) musty/putrid/
かぴかぴ /(adj-na,adv,adj-no) (on-mim) (col) crusty/flaky/dried out/
かぶき者 [かぶきもの] /(n) dandy/peacock/early-17th-century equivalent of present-day yakuza/Edo-period eccentric who attracted public attention with their eye-catching clothes, peculiar hairstyle, and weird behavior/
かぶり笠 [かぶりがさ] /(n) (obsc) conical hat (East-Asian style)/coolie hat/
かぶり物 [かぶりもの] /(n) headdress/headgear/
かぼちゃ野郎 [かぼちゃやろう] /(n) (derog) man with an unattractive, unusually shaped face/
かまくら /(n) mid-January festival in northern Japan, with snow huts in which children play house/(P)/
かませ犬 [かませいぬ] /(n) foil/someone to look as if he's putting up a fight but actually have no chance of winning/
かみのけ座 [かみのけざ] /(n) (constellation) Coma Berenices/
かみ合う [かみあう] /(v5u,vi) (1) to gear (engage) with/to be in gear (mesh)/(2) to bite each other/
かみ合せ [かみあわせ] /(n) (1) engaging or meshing (of gears)/(2) occlusion (of teeth)/
かみ合わせ [かみあわせ] /(n) (1) engaging or meshing (of gears)/(2) occlusion (of teeth)/
かみ殺す [かみこなす] /(v5s,vt) to chew/to digest/
かみ殺す [かみころす] /(v5s,vt) (1) to stifle a smile, yawn, etc./(2) to bite to death/
かみ切る [かみきる] /(v5r,vt) to bite off/to gnaw through/
かみ締める [かみしめる] /(v1,vt) (1) to chew thoroughly/(2) to reflect upon/to digest/
かみ付く [かみつく] /(v5k,vt) to bite (at)/to snap at/to snarl at/
かむ /(v5m) (uk) to blow (one's nose)/(P)/
かも /(prt) (abbr) may/might/perhaps/may be/possibly/
かもしれん /(exp) may/might/perhaps/may be/possibly/(P)/
かもめーる /(n) summer greeting cards containing a lottery ticket, sold every year starting in June/
かも知れない [かもしれない] /(exp) (uk) may/might/perhaps/may be/possibly/(P)/
かも知れません [かもしれません] /(exp) (uk) (pol) may/might/perhaps/may be/possibly/(P)/
かや葺 [かやぶき] /(n) thatching a roof with grass/
かゆいところに手が届く [かゆいところにてがとどく] /(exp,v5k) to be extremely thorough, focusing on even the finest of details/
かゆい所に手が届く [かゆいところにてがとどく] /(exp,v5k) to be extremely thorough, focusing on even the finest of details/
かゆみ止め [かゆみどめ] /(n) anti-itch medication/antipruritic drug/
かよ /(prt) sentence-ending particle expressing doubt/
から /(prt) (1) from (e.g. time, place, numerical quantity)/since/(2) from (originator)/(3) because/(4) out of (constituent, part)/(5) through (e.g. window, vestibule)/(6) after/since (following te-form verb)/(P)/
からから /(adj-na,adv,vs,adj-no) (1) (on-mim) parched/dried-up/(adv-to) (2) (on-mim) rattle/(3) (on-mim) loud laughter/
からきし /(adv) quite/utterly/(not) at all/completely/
からくり時計 [からくりとけい] /(n) automaton clock/marionette clock/
からくり時計 [からくりどけい] /(n) automaton clock/marionette clock/
からくり人形 [からくりにんぎょう] /(n) mechanical doll/automaton/string puppet/marionette/person who follows orders blindly/
からころ /(n) clip-clop/
からして /(exp) (1) even/for starters/(2) so/therefore/(3) judging from/based on/(4) since/from/
からすの濡れ羽色 [からすのぬればいろ] /(n) glossy black (hair) (lit: color of a crow with wet feathers)/
からすると /(n) judging from/on the basis of/from the point of view of/
からす麦 [からすむぎ] /(n) (1) (uk) wild oat (Avena fatua)/wild oats/(2) oat (Avena sativa)/oats/
からっきし /(adv) quite/utterly/(not) at all/completely/
からっと /(adv,vs) (1) (on-mim) changing suddenly and completely/(2) crisp and dry (e.g. skies, weather, tempura, laundry, etc.)/
からっ風 [からっかぜ] /(n) a cold, strong, dry wind/
からと言って [からといって] /(exp) while it may be true that/just because/nevertheless/not necessarily/
からなる /(exp) Y adding up to Z/Y making up Z/Y constituting Z/Z consisting of Y/Z composed of Y/Z containing Y/
からには /(exp) now that/since/so long as/because/
からみ /(n) (uk) slag/
からみ合う [からみあう] /(v5u,vi) to be(come) intertwined/to be entangled/
からりと /(adv) (on-mim) changing suddenly and completely/(P)/
からんからん /(adv-to) (on-mim) clank clank/
からんころん /(n) (on-mim) sound made by geta/clip-clop/
から騒ぎ [からさわぎ] /(n,vs) much ado about nothing/
から風 [からかぜ] /(n) dry wind/
かりかり /(adj-f) (1) crisp/crunchy/(vs) (2) to be crisp/to eat a crisp/(3) to have a chip on one's shoulder/to be grumpy/to be irritated/to be annoyed/(adv,adv-to) (4) with crunching sound or effect/
かりん糖 [かりんとう] /(n) (uk) fried dough cake/
かり子 [かりこ] /(n) (arch) maid in an Osaka brothel/
かれ草 [かれくさ] /(n) dry grass/dead grass/hay/withered grass/
かわ /(n) (uk) matte (metallurgical)/
かわい子ちゃん [かわいこちゃん] /(n) (sl) popsy/cutie/sweetie/
かわゆす /(int) (abbr) cute!/adorable!/
かわら状 [かわらがさね] /(adj-no) imbricate/
かわり得る [かわりうる] /(exp,adj-f) able to change/
かわり得る [かわりえる] /(ik) (exp,adj-f) able to change/
かん /(adv,adv-to) (on-mim) ding/chime (sound of a bell or a small gong)/
かんかん /(n,adj-no) (1) anger/flare-up/(2) intense heat/(3) clanging noise/
かんかん怒る [かんかんおこる] /(v5r) to get very mad/
かんかん帽 [かんかんぼう] /(n) boater (flat straw hat)/
かんこ鳥 [かんこどり] /(n) cuckoo/
かんしゃく玉 [かんしゃくだま] /(n) (1) fit of anger/temper/rage/(2) firecracker/
かんじき兎 [かんじきうさぎ] /(n) (uk) snowshoe hare/snowshoe rabbit (Lepus americanus)/
かんで含めるように [かんでふくめるように] /(exp) in an easy-to-understand manner/in a very kind and detailed way/
かんで吐き出すように [かんではきだすように] /(exp) curtly, in a displeased manner/
かんばん方式 [かんばんほうしき] /(n) just-in-time inventory management/JIT/
かんむり座 [かんむりざ] /(n) Corona Borealis (constellation)/
かんらん岩 [かんらんがん] /(n) peridotite/
かん口令 [かんこうれい] /(n) gag order/gag rule/
かん高い [かんたかい] /(adj-i) shrill/
かん子 [かんし] /(n) forceps/
かん状 [かんじょう] /(adj-no) rod-shaped/bacillary/bacilliform/baculiform/
かん状体 [かんじょうたい] /(n) rod (shape of cell)/
かん体 [かんたい] /(n) rod (shape of cell)/
かん体細胞 [かんたいさいぼう] /(n) rod cell/
かん木 [かんぼく] /(n) bush/shrub/
かクルマサカオウム /(n) (uk) Major Mitchell's cockatoo (Cacatua leadbeateri)/Leadbeater's cockatoo/
か月 [かげつ] /(ctr) (number of) months/
か国 [かこく] /(ctr) counter for countries/
か国語 [かこくご] /(ctr) counter for languages/
か黒い [かぐろい] /(adj-i) deep black/
か細い [かぼそい] /(adj-i) (1) thin/skinny/(2) delicate/fragile/feeble/
か弱い [かよわい] /(adj-i) frail/feeble/(P)/
か所 [かしょ] /(n) passage/place/point/part/
か否か [かいなか] /(exp) whether or not/
か文字 [かもじ] /(n) (arch) mother/wife/
か流ファン [かりゅうファン] /(n) regenerative fan/vortex flow fan/
か流ブロワ [かりゅうブロワ] /(n) regenerative blower/vortex flow blower/
か流形センサ [かりゅうがたセンサ] /(n) vortex sensor/
か流形素子 [かりゅうけいそし] /(n) vortex device/
が /(prt) (1) indicates sentence subject (occasionally object)/(2) indicates possessive (esp. in literary expressions)/(prt,conj) (3) but/however/still/and/(P)/
がーっ /(n) with a grinding noise/
がい骨 [がいこつ] /(n,adj-no) skeleton/
がかる /(suf) (after a noun, used as a godan verb) inclining to/leaning to/
がが芋 [ががいも] /(n) (uk) rough potato (Metaplexis japonica)/
がが藷 [ががいも] /(n) (uk) rough potato (Metaplexis japonica)/
がくがく /(adj-na,adv,n,vs) (on-mim) body trembling/teeth clattering/something coming loose/
がくんと /(adv) (on-mim) suddenly/with a jerk/
がさがさ /(adj-na,adv,n,vs,adj-no) (on-mim) rustling/dry or rough feeling/(P)/
がさごそ /(n,adj-f) rustling sound/
がさっ /(adv-to) (on-mim) with a swoosh/at one fell swoop/
がさつ /(adj-na) (1) crude/unrefinded/coarse/rough/(2) ill-mannered/rude/insensitive/tactless/boorish/
がさみ /(n) (uk) swimming crab (Portunus trituberculatus)/
がさ入れ [がさいれ] /(n,vs) (sl) premises search/household search/
がざみ /(n) (uk) swimming crab (Portunus trituberculatus)/
がざめ /(n) (uk) swimming crab (Portunus trituberculatus)/
がしがし /(adv,adv-to) (on-mim) boisterously/roughly/briskly/
がしゃっ /(adv-to) (on-mim) (with a) crack/
がしんたれ /(n) (ksb:) good-for-nothing/bum/loser/coward/
がじゃがじゃ /(adj-na,adv) rummage (in a drawer)/
がじゃまめ /(n) peanut brittle/
がす [はがす] /(v5s,vt) to tear off/to peel off/to rip off/to strip off/to skin/to flay/to disrobe/to deprive of/to detach/to disconnect/
がす [へがす] /(v5s,vt) to tear off/to peel off/to rip off/to strip off/to skin/to flay/to disrobe/to deprive of/to detach/to disconnect/
がせ /(n,pref) fake/lie/nonsense/
がせねた /(n) faked information/bogus intelligence/disinformation/
がせネタ /(n) faked information/bogus intelligence/disinformation/
がたい /(n) (sl) body build/
がたがくる /(exp,vk) to show one's age (e.g. to start creaking at the joints)/to wear out (e.g. machinery)/
がたがた /(adj-na,adv,adv-to,vs,adj-no) (on-mim) rattle/clatter/(P)/
がたごと /(adv,adv-to) (on-mim) rattling/clattering/
がたっと /(adv) (1) (on-mim) with a clunk/with a clank/(2) the sound of a sudden decrease (in profits, vigor, etc.)/
がたつく /(v5k,vi) to rattle/to be bumpy/to be shaky/to be unsteady/
がたぴし /(n,vs) rattle/rattling sound/
がたり /(adv) (on-mim) with a bang (clash, bump)/
がたん /(adv-to,adv) (on-mim) (with a) bump/(with a) bang/(with a) crash/sharply/
がた落ち [がたおち] /(n,vs) (value or amount) plummeting/
がちがち /(adj-na,adv,n) (on-mim) chattering (teeth)/frozen solid/overly serious/
がちっと /(adv) (on-mim) with a clashing or clanging sound/
がちゃがちゃ /(adj-na,n,vs,adv,adv-to) (on-mim) clatter/
がちゃつく /(v5k,vi) (1) to clatter/to rattle/(2) to turn into a ruckus/
がちゃりと /(adv) (on-mim) with a clank/
がちゃ目 [がちゃめ] /(n) (sl) strabismus/squint/
がちんがちん /(n) tick-tock/chipping (sound)/
がちんこ /(n) (sl) competing in earnest (esp. in sumo)/
がっかり /(adv,n,vs,adv-to) (on-mim) feel disappointed/dejected/lose heart/feel emotionally drained/feel let down/(P)/
がっかりするな /(exp) cheer up!/
がっくり /(adv,n,vs,adv-to) (on-mim) heartbroken/crestfallen/(P)/
がっこ /(n) water (dialect from the Tsugaru region of Aomori)/
がっしり /(adv,n,vs) firmly/solidly/tough/(P)/
がったんごっとん /(n) clickety-clack (e.g. train sound)/
がっちり /(adv,n,vs) solidly built/tightly/shrewd/calculating/(P)/
がっちり屋 [がっちりや] /(n) tightwad/
がっつく /(v5k,vi) to be greedy/to devour greedily/
がっつり /(adv) (sl) firmly/plentifully/with all one's might/
がっぷり /(adv) firmly (grasped)/latched onto/locked onto/
がっぽがっぽ /(adv-to) (on-mim) in large quantities/
がっぽり /(adv-to,adv) (on-mim) in large quantities/
がつがつ /(adv,n,vs) (on-mim) greedily/burning with desire for something/
がつんと言う [がつんという] /(exp,v5u) to tell a person (something) emphatically/to let a person have it/
がてら /(prt) on the same occasion/at the same time/coincidentally/along with/partly (to do, for)/
がなり立てる [がなりたてる] /(v1) to yell/to shout/
がなる /(v5r) to yell/to shout/
がに股 [がにまた] /(adj-no) bowlegged/bandy-legged/
がね /(prt) (positive sentence end) I dare say/(negative sentence end) though, honestly/
がはと /(adv) (on-mim) emphatically/energetically/
がばがば /(adj-no) (1) (on-mim) over-sized/(adv) (2) in large quantities/
がばっと /(adv) (on-mim) emphatically/energetically/
がばと /(adv) (on-mim) emphatically/energetically/
がぶがぶ /(adj-na,adv,n) (on-mim) gulping down/guzzling/(P)/
がぶりと /(adv) (on-mim) emphatically (bite, gulp, chew, etc.)/
がぶり寄り [がぶりより] /(n) pushing the opponent with the torso (sumo)/
がぶる /(v5r) (1) to pitch (e.g. a boat)/(2) to force out an opponent (Sumo)/
がぶ飲み [がぶのみ] /(n,vs) swig/gulp/
がぼがぼ /(adj-f) squelching/
がましい /(suf) look like/sound like/savor of/smack of/
がまん強い [がまんづよい] /(adj-i) (very) patient/persevering/
がま口 [がまぐち] /(n) pouch/purse/handbag/
がみがみ /(adv) (on-mim) nagging/griping/
がめつい /(adj-i) greedy/grasping/predatory/calculating/avaricious/
がめる /(v1,vt) (1) to greedily try to win big (e.g. in mahjong)/(2) to swipe/to nick/to pilfer/
がめ子 [がめこ] /(n) chintzy, money-grubbing girl/
がやがや /(adv,n,vs) (on-mim) crowd of people talking/(P)/
がらがら /(adv,adv-to,vs) (1) (on-mim) clattering/rattling/gargling/(adj-na,adj-no) (2) empty/bare/uninhabited/vacant/unoccupied/(3) raspy (voice)/gravelly/(n) (4) rattle (e.g. baby's toy)/
がらがら蛇 [がらがらへび] /(n) (uk) rattlesnake/
がらがら声 [がらがらごえ] /(n) rough voice (e.g. when one has a cold or sore throat)/
がらくた食糧 [がらくたしょくりょう] /(n) (obsc) junk food/
がらっと /(adv) (1) (on-mim) to burst open/to open suddenly (of a door)/(2) to change completely/to do a 180/
がらっぱち /(n,adj-na) (col) rudeness/rude person/
がらり /(adv,adv-to) (1) (on-mim) entirely/suddenly/completely/rudely/(n) (2) window louvre/
がらんがらん /(adv-to) (on-mim) clanging/
がらんと /(adv,vs) (on-mim) empty/deserted/(P)/
がらんどう /(adj-na,n) hollowness/emptiness/void/
がら空き [がらあき] /(adj-no) virtually empty/quite empty/
がら明き [がらあき] /(adj-no) virtually empty/quite empty/
がり /(n) (col) (abbr) mimeograph/
がり /(n) sliced ginger prepared in vinegar (served with sushi)/pickled ginger/
がりせん /(n) person physically attracted to thin people/
がり版 [がりばん] /(n) mimeograph/
がり勉 [がりべん] /(n,vs) drudge/grind/someone who studies too much/cram-study (for exam, etc.)/
がる /(suf,v5r) (1) to feel (on adj-stem to represent a third party's apparent emotion)/(2) to behave as if one were/
がれ /(n) scree/
がれ場 [がれば] /(n) scree slope/
がん /(adv-to) (1) (on-mim) thump/thud (dull sound representing something being hit)/(2) severe/difficult/hard/
がんがん /(adv,vs) (col) (on-mim) sound of large bell/sound of scolding voice/(pounding of) headache/intense/
がんがん食べる [がんがんたべる] /(exp,v1) (sl) to pig out/to chow down/
がんと一発くらわす [がんといっぱつくらわす] /(exp,v5s) to punch someone/to give someone a belt/
がんば /(int) (col) Go for it (kiddy talk)/Keep at it/
がんばり屋 [がんばりや] /(n) someone who battles on in difficult circumstances/
がんも /(n) (abbr) deep-fried tofu mixed with thinly sliced vegetables/
がん首 [がんくび] /(n) (1) head of a pipe, incl. the bowl and stem attachment/(2) (col) neck/head/
がん首そろえる [がんくびそろえる] /(exp,v1) to sit silently at a meeting/
がん首をそろえる [がんくびをそろえる] /(exp,v1) to sit silently at a meeting/
がん診断 [がんしんだん] /(n) cancer diagnosis/
がん抑制遺伝子 [がんよくせいいでんし] /(n) tumour suppressor gene/tumor suppressor gene/
が早いか [がはやいか] /(exp) no sooner ... than .../hardly ... when .../
が聞いてあきれる [がきいてあきれる] /(exp,v1) who do you think you're kidding by saying (used to indicate incredulous dismissal of some claim)/What a laugh!/
が聞いて呆れる [がきいてあきれる] /(exp,v1) who do you think you're kidding by saying (used to indicate incredulous dismissal of some claim)/What a laugh!/
きかっけ /(n) chance/start/cue/excuse/motive/impetus/occasion/
きかん気 [きかんき] /(adj-na,n,adj-no) daring/unyielding/
きしきし /(adv) (on-mim) squeak/creak/
きしみ合う [きしみあう] /(v5u) to engage in (mutual) competition/
きしょー /(int) gross/nasty/yuck/
きしょい /(adj-f) (sl) feel sick/(something is) weird/
きしり /(adv-to,adv) creak/squeak/
きず音 [きずおん] /(n) flaw noise/
きせ分 [きせぶん] /(n) excess of fold beyond the stitching seam/
きぜん /(adv-to,adj-t) (arch) soaring highly/towering greatly/
きちきち /(adj-na,adv-to,n) (1) (on-mim) jam-packed (physically or of schedule, etc.)/(2) (used to denote a) grinding noise/(3) precisely/correctly (e.g. when working, etc.)/(n) (4) acrida cinerea/oriental longheaded locust/
きちきち蝗虫 [きちきちばった] /(n) (1) (uk) (col) male Oriental longheaded locust (Acrida cinerea)/(2) (obs) Gonista bicolor (species of grasshopper resembling the Oriental longheaded locust)/
きちっと /(adv,vs) (on-mim) exactly/perfectly/(P)/
きちんきちん /(adv-to,adv) correctly/properly/accurately/
きちんと /(adv,vs) (on-mim) precisely/accurately/neatly/(P)/
きっかり /(adv) exactly/precisely/
きっきゅう如 [きっきゅうじょ] /(adj-t,adv-to) deferential/humble/reverent/respectful/
きっしょー /(int) gross/nasty/yuck/
きっちり /(adv,vs) (1) punctually/on the dot/precisely/(2) closely/tightly/(fits) like a glove/(3) without fail/(P)/
きっぱり /(adv,adv-to,vs) (on-mim) clearly/plainly/decisively/distinctly/flatly/(P)/
きっぱりと /(adv,adv-to,vs) (on-mim) clearly/plainly/decisively/distinctly/flatly/
きつい /(adj-i) (1) intense/severe/hard/(2) determined/forceful/formidable/(3) strong/(4) tight/close/(P)/
きつねの嫁入り [きつねのよめいり] /(n) rain shower while the sun shines/sun shower/
きつね色 [きつねいろ] /(n) light brown/
きつぷ /(ik) (n) ticket/
きつめ /(adj-no,adj-na,n) a little too tight/
きなこ餅 [きなこもち] /(n) (uk) mochi sprinkled with soy flour/
きな臭い [きなくさい] /(adj-i) (1) burning or scorched smell/(2) imminent military action/(3) suspicious/
きな粉 [きなこ] /(n) (uk) soy flour/soybean flour/
きな粉餅 [きなこもち] /(n) (uk) mochi sprinkled with soy flour/
きぬごし豆腐 [きぬごしどうふ] /(n) silken tofu/soft tofu/
きぬた骨 [きぬたこつ] /(n,adj-no) incus (bone of the ear)/
きびきび /(adv,n,vs) (on-mim) brisk/lively/energetic/
きびすを返す [きびすをかえす] /(exp,v5s) to turn back/to return/
きび砂糖 [きびざとう] /(n) light brown sugar/
きまりが悪い [きまりがわるい] /(exp,adj-i) embarrassed/ashamed/
きまり悪い [きまりわるい] /(adj-i) feeling awkward/being ashamed/being bashful/
きまり文句 [きまりもんく] /(n) cliche/platitude/formula/set phrase/
きめえ /(exp) (sl) disgusting/gross/bad feeling/weird/
きめ細やか [きめこまやか] /(adj-na) smooth/polite and attentive to detail/
きもい /(adj-i) (sl) (abbr) gross/disgusting/
きもを冷やす [きもをひやす] /(exp,v5s) to be struck with terror/to be terrified/to be scared to death/
きも可愛い [きもかわいい] /(adj-f) (sl) (col) being both repellant and attractive at the same time/being both cute and disgusting/
きゃあ /(int) Eek!/Yipe!/
きゃっ /(int) shriek/scream/
きゃぴきゃぴ /(n,vs) (col) acting all cute and charged up/brimming with youthful enthusiasm/in high spirits/raring to go/overflowing with youthful energy (used mainly of girls)/
きゃんきゃん /(int) yelp/yap/
きゅうきゅう /(adj-na,adv,n) squeak/
きゅうよ /(n) (obsc) armadillo/
きゅう舎 [きゅうしゃ] /(n) barn/stable/
きゅう首 [きゅうしゅ] /(n,vs) going into a huddle/
きゅう鏘 [きゅうそう] /(adj-t,adv-to) (arch) echoing beautifully (of the sound produced by striking together jewels or metals)/beautiful (of a melody, etc.)/
きゅっと /(adv) (on-mim) tightly/squeaking/
きゅん /(adv,adv-to) (on-mim) momentary tightening of one's chest caused by powerful feelings/
きょう正 [きょうせい] /(n,vs,adj-no) correction/remedy/
きょう体 [きょうたい] /(n) (comp) cabinet/case/housing/component/unit/chassis/main frame/
きょしちょう座 [きょしちょうざ] /(n) Tucana (constellation)/the Toucan/
きょときょと /(adv,n,vs) (on-mim) look around restlessly/
きょとんと /(adv) (on-mim) (looking) blankly/(staring) in puzzlement/
きょろきょろ /(adv,n,vs) (on-mim) look around restlessly/(P)/
きょん /(n) Chinese muntjac (species of barking deer, Muntiacus reevesi)/
きらきら /(adv,adv-to,vs) (on-mim) glitter/sparkle/glisten/twinkle/(P)/
きらっ /(adv-to) (on-mim) glittering/glitteringly/sparkling/twinkling/brightly/
きらり /(adv,adv-to) (on-mim) with a momentary flash of light/
きりきり /(adv) (on-mim) at once/right away/quickly/
きりきり舞い [きりきりまい] /(n,vs) a whirl/going round and round/rushing a person off his feet/
きりっと /(adv,vs) (on-mim) stiff and slackless/tense without any looseness/
きりっとした /(adj-f) smart/spruce/neat/
きりり /(adv,adv-to) (1) (on-mim) stiff and slackless/tense without any looseness/(2) cling tightly/pulled or stretched as far as possible/(3) creaking of a door or oar/
きれい事 [きれいごと] /(n) (1) (uk) whitewashing/glossing over/lip service/(2) deftly finishing up/putting on the final touches/
きんき /(n) broadbanded thornyhead/broadfin thornyhead/kichiji rockfish (Sebastolobus macrochir)/
きんきらきん /(adj-no) gaudy/flashy/showy/
きんきん /(adv,n,vs) (on-mim) shrill/strident/piercing/
きんちゃく袋 [きんちゃくぶくろ] /(n) pouch/purse/
き印 [きじるし] /(n) (sl) (sens) madness/madman/
き損 [きそん] /(n,vs) damage/injury/defamation/waste/
き鳳鏡 [きほうきょう] /(n) (obsc) intricately inscribed ancient bronze or iron mirror featuring a pair of firebirds/
き鳳文 [きほうもん] /(n) (obsc) inscription of a fantastic birdlike creature found on Yin and Zhou dynasty bronze ware etc./
き裂 [きれつ] /(n) crack/crevice/fissure/chap/
ぎーぎー /(n) creak/squeak/rasping sound/
ぎいぎい /(n) creak/squeak/rasping sound/
ぎいとん /(adv,adv-to) (on-mim) squeaking or creaking (followed by a thump)/
ぎくぎく /(adv,adv-to,vs) jerkily/
ぎくしゃく /(adv,n,vs) (1) jerkiness/awkwardness/stiltedness/(2) souring (of a relationship)/strain (e.g. in relations)/
ぎくっと /(adv-to) (1) (with a) start/(vs) (2) to feel shocked/
ぎくり /(adv,adv-to) (1) (on-mim) (with a) start/(vs) (2) to be startled/
ぎこぎこ /(adv,adv-to) (on-mim) squeak squeak/squeaking/
ぎこちない /(adj-i) awkward/clumsy/stiff/crude/unrefined/constrained/(P)/
ぎごちない /(adj-i) awkward/clumsy/stiff/crude/unrefined/constrained/
ぎざぎざ /(adj-na,adj-no,n,adv) (on-mim) jagged/notched/corrugated/milled/serrated/(P)/
ぎしぎし /(n) creak/squeak/creaking sound/
ぎすぎす /(adv,n,vs) (on-mim) strained atmosphere/thin and bony/
ぎちぎち /(adv,adv-to,vs) (1) creakily/(adj-na) (2) close (i.e. with no room to spare)/
ぎっくり腰 [ぎっくりごし] /(n) strained back/slipped disk/lumbosacral strain/
ぎっしり /(adv) tightly/fully/(P)/
ぎっちょ /(n) (sl) (sens) left-handed/
ぎっちり /(adv) tightly/fully/
ぎとぎと /(vs,adj-no) (on-mim) oily/sticky/greasy/
ぎゃあぎゃあ /(adv,n) scream/squawk/squeal/
ぎゃふん /(n) speechlessness/state of being unable to argue/
ぎゃふんと言う [ぎゃふんという] /(exp,v5u) to be beaten hollow/to be argued into silence/
ぎゅう /(adv,adv-to) (1) (on-mim) squeezing something tightly/sound made by someone (or something) being squeezed/(2) criticizing someone severely/sound made by someone being criticized/(n) (3) (col) hug/
ぎゅうぎゅう /(adj-na,adv) (on-mim) packing in tightly/creaking leather, door, etc./(P)/
ぎゅうぎゅう詰め [ぎゅうぎゅうづめ] /(exp) jam packed/
ぎゅう詰め [ぎゅうづめ] /(adj-na,n) packed like sardines/jammed/
ぎゅぎゅ /(adv) (on-mim) snoringly/
ぎゅっと /(adv) (on-mim) hard/tight(ly)/(P)/
ぎょうかく /(n,adj-na,adj-t,adv-to) (uk) stony, fallow land/
ぎょっと /(adv,n,vs) (on-mim) being startled/(P)/
ぎょりゅう /(n) (uk) Tamarix chinensis/Chinese tamarisk/
ぎょろぎょろ /(adv,adv-to,vs) (on-mim) goggling/rolling (one's eyes)/
ぎょろり /(adv,adv-to) staring (e.g. eyes)/goggling/
ぎらぎら /(adv,n,vs,adv-to) (1) (on-mim) glare/dazzle/(2) glitter/(P)/
ぎらっ /(adv-to) (on-mim) dazzlingly/
ぎらつく /(v5k,vi) (1) to glare/to dazzle/(2) to glitter/
ぎりぎり /(adj-na,adv) (1) (on-mim) at the last moment/just barely/(2) grinding sound/(P)/
ぎりぎりまで /(exp) until something reaches the very limit/until the very last minute/up to the breaking point/
ぎりぎりセーフ /(exp) just safe (e.g. just avoiding being late, failing an exam, etc.)/just (barely) OK/
ぎろぎろ /(adv,adv-to,vs) glaringly (staring)/
ぎんた /(exp) (id) (kyu:) in case of/
ぎんやんま /(n) (uk) lesser emperor (species of dragonfly, Anax parthenope)/
くい違い [くいちがい] /(n) discrepancy/different or conflicting opinions/
くい違う [くいちがう] /(v5u,vi) to cross each other/to run counter to/to differ/to clash/to go awry/
くい止める [くいとめる] /(v1,vt) to check/to hold back/
くぐもった声 [くぐもったこえ] /(n) muffled voice/
くぐり戸 [くぐりど] /(n) side door/side gate/
くぐり抜ける [くぐりぬける] /(v1,vi) to go through/to pass through/to escape (through the cordon)/to evade (the law)/
くさくさ /(adv,n,vs) (on-mim) feeling depressed/
くさび形 [くさびがた] /(adj-na,n) (uk) wedge-shape/
くさび石 [くさびいし] /(n) (1) keystone/(2) sphene/
くさや /(n) horse mackerel dipped in salt water and dried in the sun/
くしゃくしゃ /(adj-na,adv,n,vs) (on-mim) crumpled/disheveled/dishevelled/feel gloomy/(P)/
くし形 [くしがた] /(adj-no) comb-shaped/
くじで選ぶ [くじでえらぶ] /(exp,v5b) to choose by lot/
くじら座 [くじらざ] /(n) (constellation) Cetus/Whale/
くじを引く [くじをひく] /(exp,v5k) to draw lots/
くじ引き [くじびき] /(n,vs) (uk) lottery/drawn lot/
くじ運 [くじうん] /(n) luck in a lottery/luck in a raffle/
くすくす /(n,adv,vs) (on-mim) chuckle/giggle/
くすくす笑う [くすくすわらう] /(exp,v5u) to giggle/
くすねる /(v1,vt) to pilfer/to filch/to swipe/
くすみ /(n,adj-no) dullness (esp. of the skin)/lack of luster/dirt/soil/contamination/
くすむ /(v5m,vi) to be quiet/to be dull/to darken/
くすり指 [くすりゆび] /(n) ring finger/third finger/
くすん /(n,adv-to) (on-mim) sniff/sniffle/snuffle/
くず屋 [くずや] /(n) (sens) ragman/junkman/garbage man/
くず屋さん [くずやさん] /(n) ragman/junkman/garbage man/
くず肉 [くずにく] /(n) waste meat/meat scraps/offal/
くず物 [くずもの] /(n) (1) trash/junk/garbage/(2) worthless product/
くず粉 [くずこ] /(n) kudzu starch/
くせっ毛 [くせっけ] /(n) kinky hair/frizzy hair/unruly hair/curly hair/
くせ者 [くせもの] /(n) ruffian/villain/knave/thief/suspicious fellow/
くせ毛 [くせげ] /(n) kinky hair/frizzy hair/unruly hair/curly hair/
くそ食らえ [くそくらえ] /(exp) (uk) fuck off! (lit: eat shit)/up yours!/up your arse (ass)/
くそ度胸 [くそどきょう] /(n) foolhardiness/daredevil courage/
くそ勉強 [くそべんきょう] /(n,vs) (sl) cram for an exam/concentrated study/
くたくた /(adj-na,adj-no) (1) (on-mim) exhausted/tired/(2) withered/worn out/(n) (3) boiling until shapeless or mushy/(4) tediously/repetitively/wordily/(P)/
くたばっちまえ /(exp) (X) (vulg) (ktb:) Drop dead, you bastard!/fuck you!/
くたばりぞこない /(exp) (vulg) worthless (of a person)/somebody who wouldn't be missed if they died/
くたばる /(v5r,vi) (1) (col) to kick the bucket/to drop dead/to die/(2) to be pooped/to be exhausted/(P)/
くたばれ /(exp) (X) (vulg) (ktb:) fuck you!/shove it!/go to hell!/drop dead!/
くたびれ儲け [くたびれもうけ] /(n,adj-no) waste of effort/thankless task/
くだくだ /(adv-to) (on-mim) tediously/lengthily/wordily/
くだくだしい /(adj-i) tedious/lengthy/wordy/long-winded/
くちゃくちゃ /(adv,adv-to,adj-na) (on-mim) crunching/crumpling/messy/
くっきり /(adv,n,vs,adv-to) (on-mim) distinctly/clearly/boldly/(P)/
くっくっくっ /(int) evil laughter/
くっすん /(n) sobbing noise/
くっちゃべる /(v5r) to talk/to chatter/to tell (e.g. secrets)/
くっつき虫 [くっつきむし] /(n) burr (prickly seeds or seedheads that stick to fur and clothes)/
くっ付き虫 [くっつきむし] /(n) burr (prickly seeds or seedheads that stick to fur and clothes)/
くっ付く [くっつく] /(v5k) (uk) to adhere to/to keep close to/(P)/
くっ付ける [くっつける] /(v1) to attach/(P)/
くつくつ /(adv) (on-mim) simmering/
くつくつ法師 [くつくつぼうし] /(ateji) (n) (obsc) Meimuna opalifera (species of cicada)/
くつわを並べて [くつわをならべて] /(exp) together/abreast/side-by-side/
くつ一足 [くついっそく] /(n) pair of shoes/
くつ屋 [くつや] /(n) shoemaker/shoe store/
くどくど /(adv,adv-to) (on-mim) tediously/repetitively/(P)/
くにゃくにゃ /(n,vs,adv-to) (on-mim) (the impression of being) soft and flexible/
くねくね /(adv,n,vs) (on-mim) bending loosely back and forth/making something/meandering/wriggling body/
くねる /(v5r,vi) to bend loosely back and forth/
くの一 [くのいち] /(ik) (n) (1) female ninja/(2) (col) woman/
くの字に曲げる [くのじにまげる] /(exp,v1) to bend over in the shape of the the character ku/to bend forward from the waist to form a chevron shape/
くの字点 [くのじてん] /(n) iteration mark shaped like the hiragana "ku" (used in vertical writing to represent repetition of two or more characters)/
くびすを返す [くびすをかえす] /(exp,v5s) to turn back/to return/
くびれフェチ /(n) (sl) small waist fetish (from kubire fetish)/wasp waist fetish/
くぼ地 [くぼち] /(n) pit/hollow/basin/depression/
くみ取り便所 [くみとりべんじょ] /(n) outhouse (from which night-soil may be collected)/privy/
くみ取る [くみとる] /(v5r,vt) (1) to scoop out/to pump out/(2) to understand/to surmise/
くもの巣理論 [くものすりろん] /(n) cobweb theorem/
くも膜 [くもまく] /(n) the arachnoid (membrane)/
くも膜下出血 [くもまくかしゅっけつ] /(n) subarachnoid hemorrhage/subarachnoid haemorrhage/
くよくよ /(adv,n,vs,adv-to) (on-mim) worry about/mope/brood over/(P)/
くらい /(suf,prt) (1) approximately/about/around/or so/(2) to (about) the extent that/(almost) enough that/so ... that .../at least/(3) as ... as .../like/(P)/
くらくら /(adv,n,vs) (on-mim) dizziness/giddiness/
くらっと /(adv) (1) (on-mim) dizzyingly/(vs) (2) to feel dizzy/
くりかえし /(n) repetition mark in hiragana/
くりかえし /(n) repetition mark in katakana/
くりかえし /(n) voiced repetition mark in hiragana/
くりかえし /(n) voiced repetition mark in katakana/
くりくり /(adj-f) big and round (e.g. eyes, shaven head, etc.)/
くり色 [くりいろ] /(n,adj-no) chestnut-color/chestnut-colour/
くり抜く [くりぬく] /(v5k,vt) to gouge out/to excavate/to bore/to drill/
くり返し [くりかえし] /(n,vs,adj-no,adj-na) (1) repetition/reiteration/iteration/cycle/(adv) (2) repeatedly/
くり返す [くりかえす] /(v5s,vt,vi) to repeat/to do something over again/
くるくる /(adv,n) (on-mim) like a small spinning object/winding up a long string, etc./(P)/
くるっ /(adv-to) turn around/rapid turn/round and charming (e.g. eyes)/
くるみ割り [くるみわり] /(n) nutcracker/nutcrackers/
くるり棒 [くるりぼう] /(n) (obsc) flail (for threshing grain)/
くる病 [くるびょう] /(n) rickets/
くろくろ /(adv) (on-mim) going round and round/
くわえ込む [くわえこむ] /(v5m) (1) to hold fast deep in (one's mouth or other orifice, often used in a sexual context)/(2) to bring in a man for sex/
くわん /(adv,adv-to) (on-mim) ding/chime (sound of a bell or a small gong)/
くわ入れ式 [くわいれしき] /(n) ground-breaking ceremony/
くんくん鳴く [くんくんなく] /(exp,v5k) to whine (of a dog)/
くんろ /(aux) (ksb:) to give/to let one have/to do for one/to be given/
くん蒸 [くんじょう] /(n,vs,adj-no) fumigation/smoking (out)/
くん製 [くんせい] /(adj-no) smoking (of fish, meat, etc.)/
くノ一 [くのいち] /(n) (1) female ninja/(2) (col) woman/
ぐーぐー /(adv,adv-to,vs) (1) snoring/(2) growling (low rumbling sound)/
ぐい /(adv-to) (on-mim) with a jerk/
ぐいぐい /(adv) (on-mim) doing something forcefully and continuously (pulling hard, gulping drink)/
ぐいっ /(adv-to) (on-mim) with a jerk/
ぐい飲み [ぐいのみ] /(n) (1) large sake cup/(n,vs) (2) gulping down a drink/taking a swig at something/
ぐい呑 [ぐいのみ] /(n) (1) large sake cup/(n,vs) (2) gulping down a drink/taking a swig at something/
ぐう /(n) (1) rock (in rock, paper, scissors)/(adv,n) (2) sound made through constricted throat/(3) sound made in suffering or under adversity/
ぐうぐう /(adv) (on-mim) fast (asleep)/snoring or grumbling sound/
ぐうぐう寝ちゃう [ぐうぐうねちゃう] /(v5u) (ktb:) to fall sound asleep/
ぐうたら /(n,adj-na,adj-no) lazybones/good-for-nothing/idler/
ぐうっと /(adv,adv-to) (on-mim) heartily (drinking)/
ぐうの音も出ない [ぐうのねもでない] /(exp,adj-i) lost for words/not knowing what to say by way of excuse (refutation)/
ぐきぐき /(adv,n,vs) (1) throbbing pain/(2) jerkily/awkwardly/
ぐさりと /(adv) (on-mim) deeply (e.g. dagger thrust)/
ぐしゃぐしゃ /(adv-to,adv,adj-na,vs) (on-mim) soggy/mushy/crumpled/
ぐしゃっ /(adv-to) (on-mim) crushed flat/squashed to a pulp/squished/crumpled/
ぐしょぐしょ /(n,adj-no) sopping/soaking/
ぐしょ濡れ [ぐしょぬれ] /(n,adj-no) sopping wet/sodden/wet to the skin/
ぐし縫 [ぐしぬい] /(n) running stitch/
ぐじぐじ /(adv,adv-to,vs) (1) (on-mim) mumblingly/grumblingly/(2) tardily/slowly/
ぐじゃぐじゃ /(adj-no,adj-na,adv,adv-to) (1) soggy/soaking/drenched/(adv,adv-to) (2) incessantly (complaining)/
ぐすく /(n) Okinawan fortress/
ぐすん /(n,adv-to) (on-mim) sniff/sniffle/snuffle/
ぐたぐた /(adj-na,adj-no) (1) (on-mim) exhausted/tired/(2) withered/worn out/(n) (3) boiling until shapeless or mushy/(4) tediously/repetitively/wordily/
ぐたり /(adv,adv-to,vs) (on-mim) completely exhausted/dead tired/limp/senseless/
ぐだぐだ /(adj-na,adj-no) (1) (on-mim) exhausted/tired/(2) withered/worn out/(n) (3) boiling until shapeless or mushy/(4) tediously/repetitively/wordily/
ぐちぐち /(n,vs) (1) to mumble/to mutter/(2) to complain (continuously) about something/
ぐちゃ /(n) splat!/
ぐちゃぐちゃ /(adj-na,adv,n,vs) (on-mim) pulpy/soppy/sloppy/
ぐちょぐちょ /(n,adj-no) sopping/soaking/
ぐっしょり /(adv) soaking (wet)/wringing/
ぐっすり /(adv,adv-to) (on-mim) sound asleep/fast asleep/(P)/
ぐったり /(adv,adv-to,vs) (on-mim) completely exhausted/dead tired/limp/senseless/(P)/
ぐっと /(adv) (on-mim) firmly/fast/much/more/
ぐつぐつ /(n,adv) (on-mim) simmering/boiling gently/
ぐでぐで /(adj-na) dead drunk/
ぐでんぐでん /(adj-na) dead drunk/
ぐにゃぐにゃ /(adj-na,adj-no,adv,n,vs) (on-mim) flabby/limp/soft/flexible/
ぐにゃっと /(vs) to become limp/
ぐにゃり /(adv-to) flabbily/softly/limply/effortlessly/flexibly/mushy/
ぐびぐび /(n) (on-mim) gulping/guzzling/
ぐぶぐぶ /(n) sound of rinsing one's mouth/
ぐむ /(suf,v5m) to appear/to start to appear/to show signs of appearing/
ぐらい /(suf,prt) (1) approximately/about/around/or so/(2) to (about) the extent that/(almost) enough that/so ... that .../at least/(3) as ... as .../like/(P)/
ぐらぐら /(adj-na,adv,n,vs) (on-mim) loose, irregular movement/lolling/indecisiveness/(P)/
ぐらっと /(adv) (on-mim) shaking violently/
ぐらつく /(v5k,vi) to be unsteady/to reel/to shake/
ぐらり /(adv-to,adv) shaking violently/
ぐる /(n) accomplice/cohort/
ぐるぐる /(adv,vs,adv-to) (1) (on-mim) turning round and round/going around in circles/(2) wrapped around/(P)/
ぐるっと /(adv) (on-mim) turning in a circle/going around/turning about/surrounding/encircling/(P)/
ぐるみ /(suf) (together) with/-wide/including/
ぐるり /(n) surroundings/circumference/(P)/
ぐるりと /(adv) (on-mim) turning in a circle/going around/turning about/surrounding/encircling/
ぐれる /(v1,vi) to stray from the right path/
ぐろい /(adj-i) (sl) grotesque/disgusting/gross/
ぐんぐん /(adv) (on-mim) steadily/
ぐんと /(adv) (on-mim) remarkably/noticeably/
ぐんにゃり /(adv) limp/enervated/
け /(prt) particle indicating that the speaker is trying to recall some information/
けい秀画家 [けいしゅうがか] /(n) (accomplished) woman painter/
けい線 [けいせん] /(n) ruled line/rule/
けい線を引く [けいせんをひく] /(exp,v5k) to rule (line)/
けい線表 [けいせんひょう] /(n) chart/
けい頭 [けいがしら] /(n) kanji "pig's head" radical/
けい動脈 [けいどうみゃく] /(n) carotid artery/
けが人 [けがにん] /(n) wounded or injured person/(P)/
けし粒 [けしつぶ] /(n) (1) poppy seed/(adj-f) (2) pinhead-like/small as ants/
けじめ /(n) distinction (between right and wrong)/(P)/
けじめを付ける [けじめをつける] /(exp,v1) (1) to draw the line (between two situations)/to make a clear distinction/(2) to take clear responsibility for (mistakes, etc.)/
けたけた /(adv) laughing foolishly/cackling/
けたたましい /(adj-i) piercing/shrill/noisy/loud/clamorous/wild/
けた位置 [けたいち] /(n) (comp) digit position/
けた移動 [けたいどう] /(n) (comp) shift/
けた区切り機能 [けたくぎりきのう] /(n) (comp) punctuation capability/
けた上げ [けたあげ] /(n) (comp) carry (of digit, bit, etc.)/
けた上げなし加算 [けたあげなしかさん] /(n) (comp) addition without carry/
けた上げる [けたあげる] /(v1) (comp) to carry (of digit, bit, etc.)/
けた上げ数 [けたあげすう] /(n) (comp) carry digit/
けた上げ保留加算機 [けたあげほりゅうかさんき] /(n) (comp) carry-save adder/
けた上り [けたあがり] /(n) (comp) carry (of digit, bit, etc.)/
けた送り [けたおくり] /(n) (comp) shift/
けち /(n,adj-na) (1) stinginess/miserliness/penny-pinching/cheesparing/miser/pinchpenny/skinflint/cheapskate/tightwad/niggard/(2) shabby/cheap/mangy/poor/(3) petty/narrow-minded/quibbling/mean-spirited/(4) bad luck/ill omen/glitch/
けちけち /(adv,vs) stingy/tightfisted/miserly/
けちつける /(v1) to find fault with/to rain on one's parade/to nitpick/to quibble/
けちのつき始め [けちのつきはじめ] /(exp) the first sign of bad luck/the first bad omen/
けちを付ける [けちをつける] /(exp,v1) (uk) to find fault with/to rain on one's parade/to nitpick/to quibble/
けちん坊 [けちんぼ] /(n,adj-na) miser/cheapskate/skinflint/
けちん坊 [けちんぼう] /(n,adj-na) miser/cheapskate/skinflint/
けち臭い [けちくさい] /(adj-i) mean/stingy/
けったい /(adj-na) (ksb:) queer/weird/bizarre/
けったくそ悪い [けったくそわるい] /(adj-i) (vulg) extremely vexing/
けってい /(n) (uk) hinny/
けつの穴 [けつのあな] /(n) (X) (col) anus/asshole/arsehole/
けど /(conj,prt) but/however/although/(P)/
けども /(conj,prt) but/however/although/
けばい /(adj-i) gawdy/glitzy/loud (e.g. of makeup)/
けばけば /(adv,n,vs) (on-mim) gaudy/garish/
けむりフード /(n) anti-smoke hood/
けらけら /(adv) (on-mim) cackling (sound of shrill laughter)/
けらけら笑う [けらけらわらう] /(v5u) to cackle/
けられ /(n) vignetting (darkening of the perimeter of a photographic image)/
けり /(aux-v) (1) indicates recollection or realization (i.e. of hearsay or the past)/can form a poetic past tense/(2) indicates continuation from the past to the present/(3) end/conclusion/
けりが付く [けりがつく] /(exp,v5k) (uk) to be settled/to be brought to an end/
けりを付ける [けりをつける] /(exp,v1) (uk) to settle/to finish/to bring to an end/
けり込む [けりこむ] /(v5m) to kick in/
けり殺す [けりころす] /(v5s) to kick to death/
けれど /(conj,prt) but/however/although/(P)/
けれども /(conj,prt) but/however/although/(P)/
けろっと /(adv,vs) as if nothing happened/nonchalantly/
けろり /(adv,adv-to) (1) (on-mim) completely/entirely/(2) nonchalantly/as if nothing happened/
けん /(n) (arch) (obsc) xun (ancient Chinese musical instrument resembling a clay ocarina)/
けんかを売る [けんかをうる] /(exp,v5r) to pick a fight/
けんか腰 [けんかごし] /(n,adj-no) belligerent/
けんか両成敗 [けんかりょうせいばい] /(exp) in a quarrel, both parties are to blame/
けんけん /(n,vs) hopping on one foot/
けんせい球 [けんせいきゅう] /(n) throw to check a runner/
けんちん汁 [けんちんじる] /(n) Japanese tofu and vegetable chowder/
けんつくを食わす [けんつくをくわす] /(exp,v5s) (obsc) to burst out in anger/
けんつくを食わせる [けんつくをくわせる] /(exp,v1) to angrily reject/to snub/to give a person a good scolding/to give a person a rap on the knuckles/
けんもほろほろ /(ik) (adj-na,adj-no) curt/blunt/brusque/
けんもほろろ /(adj-na,adj-no) curt/blunt/brusque/
けん引 [けんいん] /(n,vs) hauling/tow/pull/drag/
けん玉 [けんだま] /(n) Japanese bilboquet (cup-and-ball game)/
けん制 [けんせい] /(n,vs) check/restraint/constraint/diversion/feint/screen/
けん怠感 [けんたいかん] /(n) physical weariness/sense of fatigue/washed-out feeling/
けん土重来 [けんどじゅうらい] /(n) recouping one's strength for a renewed attack (on)/making another attempt with redoubled efforts/
けん土重来 [けんどちょうらい] /(n) recouping one's strength for a renewed attack (on)/making another attempt with redoubled efforts/
けん盤 [けんばん] /(n) keyboard (e.g. piano, computer)/
げ /(int) exclamation of surprised disappointment, disgust, or worry (yuck, ick, ack, eeew, crap!, blech, gross)/
げきを飛ばす [げきをとばす] /(exp,v5s) to issue a manifesto/to appeal/
げそげそ /(n) (the appearance of having) lost weight/
げた箱 [げたばこ] /(n) shoe rack (in genkan)/cupboard (for shoes and clogs)/
げっ /(int) exclamation of surprised disappointment, disgust, or worry (yuck, ick, ack, eeew, crap!, blech, gross)/
げっそり /(adv,n,vs) being disheartened/losing weight/
げっぷ /(n) (on-mim) belch/burp/eructation/
げっ歯動物 [げっしどうぶつ] /(n) (1) gnawing animal/(2) rodent/
げっ歯目 [げっしもく] /(n) (1) Rodentia/(adj-no) (2) rat-like/rodential/
げっ歯類 [げっしるい] /(n,adj-no) rodent/
げつ /(n) (arch) (obsc) cutting off the leg at the knee (form of punishment in ancient China)/
げらげら /(adv,adv-to) (on-mim) guffaw/
げらげら笑う [げらげらわらう] /(exp,v5u) to guffaw/
げろ /(n) (col) spew/
げろげろ /(exp) (sl) gross me out!/disgusting!/
げろげろ吐く [げろげろはく] /(exp,v5k) to vomit/to throw up/
げんぜん /(adv-to,adj-t) (1) (arch) alone/(2) spilling tears in large drops/crying out in anguish/crying out in sorrow/
げんなり /(adv,vs) wearily/dejectedly/
げんを担ぐ [げんをかつぐ] /(exp,v5g) to be superstitious/
げん灯 [げんとう] /(n) running lights/sidelight/side light/
こ /(suf) (1) (abbr) doing/in such a state/(2) doing together/contest/match/(3) (fam) familiarizing suffix (sometimes meaning "small")/
こいさん /(n) (hon) (ksb:) youngest daughter (of a good family)/
こういった /(exp) this sort of/
こうかく /(n,adj-na,adj-t,adv-to) (uk) stony, fallow land/
こうする /(exp,vs-i) to (do) like this/
こうすると /(exp) having done this/if this is done/if it is done in this way/(P)/
こうすれば /(exp) if you do this/if this is the case/(P)/
こうなると /(exp) given the situation/now that it has come to this/
こうべを垂れる [こうべをたれる] /(exp,v1) (1) to hang one's head/(2) to bow down/
こうもり傘 [こうもりがさ] /(n) (Western-style) umbrella/
こうやって /(conj) thus/in this way/
こう化 [こうか] /(n,vs) gelatinization/gelatinisation/
こう言う [こういう] /(adj-pn) such/like this/
こう言う [こうゆう] /(adj-pn) such/like this/
こう頭 [こうとう] /(adj-na,n,adj-no) larynx/
こき下ろす [こきおろす] /(v5s,vt) to denounce/to disparage/to lambast/to abuse/
こき使う [こきつかう] /(v5u,vt) to work someone hard/
こくり /(n,vs,adv-to) (1) nodding/dozing off/(adv,adv-to) (2) suddenly/
こくん /(adv-to) (1) (on-mim) nod deeply/(2) glugging/drinking deeply/
こくんこくん /(adv-to) (1) (on-mim) glugging/drinking deeply/(2) nodding deeply/
こけこっこ /(adv) (1) cock-a-doodle-doo (sound made by cockerels, roosters)/(n) (2) (sl) cockerel/rooster (childish term)/
こけこっこう /(adv) (1) cock-a-doodle-doo (sound made by cockerels, roosters)/(n) (2) (sl) cockerel/rooster (childish term)/
こけっこう /(adv) (1) cock-a-doodle-doo (sound made by cockerels, roosters)/(n) (2) (sl) cockerel/rooster (childish term)/
こけら板 [こけらいた] /(n) thin shingles/
こけら葺き [こけらぶき] /(n) shingling/shingled roof/
こけら落し [こけらおとし] /(n) opening of a new theater (theatre)/
こけら落とし [こけらおとし] /(n) opening of a new theater (theatre)/
こげ茶色 [こげちゃいろ] /(n) dark brown/olive brown/
ここで逢ったが百年目 [ここであったがひゃくねんめ] /(exp) (id) At last your time has come/
ここで会ったが百年目 [ここであったがひゃくねんめ] /(exp) (id) At last your time has come/
ここにきて /(exp) (1) (id) came here/coming here/(2) recently/
こころを用いる [こころをもちいる] /(exp,v1) to be attentive to/to pay attention to/
ここん所 [ここんとこ] /(n) this place/here/
ここ一番 [ここいちばん] /(n) the crucial moment/the moment of truth/a do-or-die situation/a crucial juncture/a crucial stage/
こざっぱり /(adv,vs) neat (neatly)/tidy/trim/
こしょばい /(adj-i) ticklish/
こし器 [こしき] /(n) filter/strainer/colander/
こし紙 [こしがみ] /(n) filter paper/
こし布 [こしぬの] /(n) cloth strainer/filter cloth/
こし餡 [こしあん] /(n) strained bean paste/
こじつけ /(n,adj-no) distortion/stretch/strained interpretation/technicality/casuistry/sophistry/
こじつける /(v1,vt) to distort/to strain (interpretation)/to force (meaning)/
こじ開ける [こじあける] /(v1,vt) to wrench open/to prize open/to pick (lock)/
こすり合わせる [こすりあわせる] /(v1) to rub together (e.g. one's hands)/
こせこせ /(adv,n,vs) (on-mim) fussy/make a big deal out of nothing/
こそ /(prt) for sure (emphasize preceding word)/(P)/
こそあど /(n) (ling) Japanese ko-so-a-do demonstratives (e.g. pronouns: kore, sore, are, dore)/
こそげ取る [こそげとる] /(v5r,vt) to scape off/
こそこそ /(adv,adv-to,n,vs) (on-mim) sneakily/move stealthily/(P)/
こそばい /(adj-i) ticklish/
こそばゆい /(adj-i) ticklish/
こそ泥 [こそどろ] /(n) sneak-thief/
こだま /(n) regular (stops at every station) Toukai-line Shinkansen/
こだわり /(n) (1) obsession/fixation/hangup/(2) determination/fastidiousness/pickiness about (trait, style, etc.)/
こちこち /(adj-na,adv,n,adj-no) (on-mim) dry/hard/puritanical/frightened/(P)/
こちらこそ /(exp) it is I who should say so/
こちらの話 [こちらのはなし] /(exp) talking to oneself/
こちんこちん /(adj-no,adj-na) (1) hard (due to freezing, drying, etc.)/(2) wound up/tense/
こっきり /(suf) just (applies to set number of items, instances, etc.)/
こっくり /(n,vs,adv-to) (1) nodding/dozing off/(adv,adv-to) (2) suddenly/
こっくりうなずく /(v5k) to nod in agreement/to nod in assent/
こっくりこっくり /(n,vs) niddle-noddle/nid-nod/
こっくりさん /(n) table turning (tipping, tilting)/divination by planchette/
こっくりとうなずく /(v5k) to nod in agreement/to nod in assent/
こっそり /(adv-to) (on-mim) stealthily/secretly/(P)/
こった /(exp) (col) slang form of "koto da"/
こっちの話 [こっちのはなし] /(exp) (col) talking to oneself/
こっちゃ /(exp) (1) (as for (that)) thing/(given (that)) thing/matter/fact/(2) (ksb:) (it is a ~) thing/matter/fact/
こってり /(adv,adv-to,vs) (1) thickly/heavily/richly/(2) severely/strongly/
こっぱ微塵 [こっぱみじん] /(n,vs) (uk) broken into small fragments/smashed to atoms/fragments and splinters/smithereens/
こっ酷い [こっぴどい] /(adj-i) (uk) bad/harsh/severe/
こつこつ /(adv,adv-to) (1) (on-mim) unflaggingly/steadily/untiringly/laboriously/(2) clicking/drumming/(P)/
こつこつ働く [こつこつはたらく] /(exp,v5k) to work hard/to moil/to keep one's nose to the grindstone/to slug away/
こつんと /(adv) with a bump/with a clunk/
こてこて /(adj-na,vs,adv) (1) (on-mim) over the top/(2) thickly/heavily/richly/
こてんこてん /(n,adv) black and blue (e.g. beaten ...)/
こてんぱ /(n,adv) black and blue (e.g. beaten ...)/
こてんぱん /(n,adv) black and blue (e.g. beaten ...)/
こと /(prt) (1) particle indicating a command/(2) (fem) particle indicating mild enthusiasm/(3) particle indicating a gentle interrogative/(4) particle used to soften a judgment or conclusion/
ことあるごとに /(exp,adv) with every little thing/at every opportunity/for each and every thing that crops up/
ことから /(exp) from the fact that .../
ことができる /(exp,v1) can (do)/to be able to (do)/(P)/
ことこと /(adv,adv-to) (1) (on-mim) simmering noise/light bubbling/gentle clinking/sound of rapping/sound of rattling/(2) cooking something on a low flame/chopping something lightly/
こととて /(conj) because/
ことなかれ主義 [ことなかれしゅぎ] /(n) (uk) principle of peace-at-any-price/
ことになっている /(exp,v1) to be scheduled to (do)/to be expected to (do)/
ことので /(exp) from the fact that .../
ことばに甘える [ことばにあまえる] /(exp,v1) to accept an offer/to be charmed by someone's kind words and do as he wishes/
ことば典 [ことばてん] /(n) dictionary/
こともあろうに /(exp) of all things/
ことゆえ無し [ことゆえなし] /(exp) (arch) without incident/
ことよろ /(n) (col) (abbr) abbreviation of "kotoshi mo yoroshiku onegai shimasu" (please be kind to me again this year)/
ことん /(adv-to) (on-mim) clunk/thump/
こと座 [ことざ] /(n) (constellation) Lyra/
こと自体 [ことじたい] /(exp) (the thing) itself/
こどもの日 [こどものひ] /(n) Children's Day (national holiday; May 5th)/
こにちは /(ik) (int) (col) hello/good day (daytime greeting)/
こにちわ /(ik) (int) (col) hello/good day (daytime greeting)/
こぬか雨 [こぬかあめ] /(n) light or fine rain/drizzle/
こねくり回す [こねくりまわす] /(v5s) to knead/to turn/
こねくり返す [こねくりかえす] /(v5s) (1) to tamper/to mess with/(2) to go on endlessly/
こね回す [こねまわす] /(v5s,vt) to knead/to mix/to complicate/to turn into a mess/
こね上げる [こねあげる] /(v1,vt) (1) to knead thoroughly/to work up/(2) to concoct/to make up/
こね返す [こねかえす] /(v5s,vt) to knead/to mix/to complicate/to turn into a mess/
このおかげで /(exp) because of this/thanks to this/due to this/
このぐらい /(exp) to this extent/(P)/
このたびは大変お世話になりありがとうございました [このたびはたいへんおせわになりありがとうございました] /(exp) thank you for all your hard work/
このため /(exp) because of this/(P)/
このような場合に [このようなばあいに] /(exp,adv) in this kind of situation/
この位 [このくらい] /(n,adv) (uk) this much/this amount/
この位 [このぐらい] /(n,adv) (uk) this much/this amount/
この外 [このほか] /(conj) (uk) besides/moreover/in addition/
この間 [このあいだ] /(n-t,n-adv) (1) the other day/lately/recently/during this period/(P)/
この間 [このかん] /(n-t,n-adv) (1) the other day/lately/recently/during this period/(2) meanwhile/in the meantime/
この期 [このご] /(n-t) now (with the nuance of 'the last moment')/this late in the game/
この結果 [このけっか] /(exp) consequently/as a result/
この後 [このあと] /(exp) after this/henceforth/henceforward/from now on/
この後 [こののち] /(exp) after this/henceforth/henceforward/from now on/
この頃 [このころ] /(n-adv,n-t) recently/nowadays/these days/now/at present/
この頃 [このごろ] /(n-adv,n-t) recently/nowadays/these days/now/at present/(P)/
この際 [このさい] /(n-adv) on this occasion/now/
この次 [このつぎ] /(adj-no) next/
この次から [このつぎから] /(exp) from now on/
この手 [このて] /(exp) this way (of doing)/this sort (of thing)/
この種 [このしゅ] /(adj-no) this kind of/
この所 [このところ] /(n) (uk) lately/recently/
この上 [このうえ] /(exp) besides/moreover/in addition/further/
この上ない [このうえない] /(exp) the most/the best/peerless/the greatest/first-rate/
この上なく [このうえなく] /(exp) most of all/extremely/
この上もなく [このうえもなく] /(exp) most of all/extremely/
この場合 [このばあい] /(exp) in this case/
この世 [このよ] /(n,adj-no) this world/the present life/
この世を去る [このよをさる] /(exp,v5r) to leave this world/to die/
この節 [このせつ] /(n-adv) these days/now/recently/
この先 [このさき] /(n-adv) beyond this point/from now on/after this/
この先の心持ち [このさきのこころもち] /(exp) feelings from this point on/
この前 [このまえ] /(n,adj-no) (1) some time ago/recently/lately/(2) last (Sunday, etc.)/previous/(P)/
この中 [このうち] /(exp) (1) (uk) among these/between these/of these/
この中 [このなか] /(exp) (1) (uk) among these/between these/of these/(2) in here/in this/
この通り [このとおり] /(exp) like this/in this way/as you see/
この度 [このたび] /(n-adv,n-t) this occasion/at this time/now/
この度は大変お世話になりありがとうございました [このたびはたいへんおせわになりありがとうございました] /(exp) thank you for all your hard work/
この内 [このうち] /(exp) (1) (uk) among these/between these/of these/(P)/
この分 [このぶん] /(exp) at this rate/
この分では [このぶんでは] /(exp) as affairs stand/judging from the present situation/as things are now/
この辺 [このへん] /(pn,adj-no) this area/around here/
この方 [このかた] /(n-adv) (1) since/(pn,adj-no) (2) this person/
この方 [このほう] /(n-adv) this one/this way/this method/
この様 [このよう] /(adj-na) like this/this sort/this way/
この様に [このように] /(adv) (uk) in this manner/in this way/like this/
この類 [このるい] /(adj-no) this kind/
この儘 [このまま] /(exp) (uk) as (it) is/
こびり付く [こびりつく] /(v5k) (uk) to stick to/to cling to/
こぴぺ /(n,vs) (abbr) copy-and-paste/
こぶみかんの葉 [こぶみかんのは] /(n) Kaffir lime (leaves used in Thai, etc. cuisine) (Citrus hystrix DC., Rutaceae)/
こぼし屋 [こぼしや] /(n) grump/heat merchant/
こぼし合い [こぼしあい] /(n) gripe session/grievance session/
こぼし話 [こぼしばなし] /(n) complaining/
こぼれ落ちる [こぼれおちる] /(v1,vi) to spill over and fall/to scatter (petals, leaves, etc.)/
こましゃくれる /(v1) to be saucy (of children)/to be impudent/to be cheeky/to be sassy/to be precocious/
こます /(v5s,vi) (1) to do/to have sexual intercourse/(2) to give/to present/to award/
こまちゃくれる /(v1) to be saucy (of children)/to be impudent/to be cheeky/to be sassy/to be precocious/
こまっしゃくれる /(v1) to be saucy (of children)/to be impudent/to be cheeky/to be sassy/to be precocious/
こまっちゃくれる /(v1) to be saucy (of children)/to be impudent/to be cheeky/to be sassy/to be precocious/
こまを回す [こまをまわす] /(exp,v5s) to spin a top/
こま板 [こまいた] /(n) cutting guide board for noodles/
こま飛び [こまとび] /(n) (obsc) frame skipping (e.g. during video playback)/
こみ合う [こみあう] /(v5u,vi) to be crowded/to be packed/to be jammed/
こみ上げる [こみあげる] /(v1,vi) (1) to fill (one's heart)/to experience a welling up of feelings or sensations/(2) to feel nauseated/
こむら返り [こむらがえり] /(n) cramp in the leg/
こよない /(adj-i) best/perfect/superb/
こよなく /(adv) exceedlingly/
こよなく愛する [こよなくあいする] /(exp,vs-s) to love greatly/to love beyond all else/
こら /(conj,int) (1) interjection meant to scold or reprove someone/hey!/(2) interjection to call out to someone/hey!/
こりこり /(adv) crunchy/crisp/
こりゃ /(exp) hey there/I say/see here/
これ /(int) (used to get the attention of one's equals or inferiors) hey/oi/yo/
これっ切り [これっきり] /(n,n-adv) (1) (uk) last time (as of now)/never again/(2) only this/
これで /(exp) here/with this/(P)/
これでも /(exp) even though things may appear this way/
これでもかこれでもか /(exp,adv-to) as if it weren't already enough/
これでもかと言うほど [これでもかというほど] /(exp) as if it weren't already enough/
これと言った [これといった] /(exp) (uk) nothing special (with neg. verb)/
これと言って [これといって] /(exp) nothing special (with neg. verb)/
これと同じ [これとおなじ] /(exp) the same as this/
これにより /(exp) herewith/from this/
これより /(exp) from (this, here, etc.)/since (this)/
これより三役 [これよりさんやく] /(n) final three bouts on the last day of a sumo tournament/
これより先 [これよりさき] /(exp) ahead/further on/beyond (this place)/
これを書いている時点で [これをかいているじてんで] /(exp) at the time of writing/
これを要するに [これをようするに] /(exp,adv) to sum things up/in short/in other words/
これ位 [これくらい] /(n,adv) this much/this amount/
これ位 [これぐらい] /(n,adv) this much/this amount/
これ見よがし [これみよがし] /(adj-no,adj-na) for show/ostentatious/flaunting/showing off/
これ切り [これきり] /(n,n-adv) (1) (uk) last time (as of now)/never again/(2) only this/
これ切り [これぎり] /(n,n-adv) (1) (uk) last time (as of now)/never again/(2) only this/
これ等 [これら] /(pn,adj-no) (uk) these/
ころ /(n) (obsc) roller/runner/dried whale blubber/
ころく /(n) quiver (worn on the right hip; post-Nara period)/
ころころ /(adv,n,vs) (1) (on-mim) small and round thing rolling/(2) pleasant, high-pitched sound/(3) something that changes frequently/something fickle/(P)/
ころっと /(adv) (1) (on-mim) sound of something small rolling once (often into a hole)/(2) disappointing/(3) complete reversal of a situation/(4) curling up into the fetal position/going to sleep suddenly/
ころり /(adv-to) (1) (on-mim) easily/effortlessly/suddenly/utterly/(2) changing completely/(n) (3) plink (sound of something light falling or rolling)/
ころコンベア /(n) roller conveyor/roller way/roller path/
ころコンベヤ /(n) roller conveyor/roller way/roller path/
ころ柿 [ころがき] /(n) dried persimmon/
ころ軸受け [ころじくうけ] /(n) roller bearing/
こん /(adv-to) (1) the sound that something makes when it is hit/with a bump/(2) yelp (e.g. of a fox)/bark/howl/
こんがらかる /(v5r) to become entangled/to become complicated/to get mixed up/to screw up/to get caught up in/
こんがらがる /(v5r) to become entangled/to become complicated/to get mixed up/to screw up/to get caught up in/
こんがり /(adv,adv-to) (on-mim) well-cooked/well-done/browned/
こんこん /(adv,adv-to) (1) (on-mim) tap-tap/knock-knock/bang-bang/(2) (on-mim) cough-cough/(3) (on-mim) bark (of a fox)/yelp/cry/(4) (on-mim) heavily (e.g. of snow falling)/(n) (5) (chn) fox/
こんごう型護衛艦 [こんごうがたごえいかん] /(n) Kongo class destroyer/
こんち /(n-t) (sl) today/this day/
こんちゃ /(int) (abbr) hi!/good day (daytime greeting)/
こんとん /(n) steamed manju/steamed mochi/
こんどん /(n) steamed manju/steamed mochi/
こんな /(adj-pn) such (about something/someone close to the speaker (including the speaker), or about ideas expressed by the speaker)/like this/(P)/
こんなに /(adv) so/like this/in this way/(P)/
こんな風に [こんなふうに] /(adv) (uk) in this way/like this/
こんにちわ /(ik) (int) (col) hello/good day (daytime greeting)/
こんばんわ /(ik) (int) good evening/
こんもり /(adv,vs) (on-mim) thickly/densely/luxuriantly/
こんもりと /(adv,vs) (on-mim) thickly/densely/luxuriantly/
こん睡状態 [こんすいじょうたい] /(n,adj-no) lethargic state/comatose state/
こん包 [こんぽう] /(n,vs) packing/crating/packaging/
こん包材 [こんぽうざい] /(n) packing material (boxes, insulation, shock resistance, etc.)/
こん包費 [こんぽうひ] /(n) packaging cost/
こん棒 [こんぼう] /(n) stick/club/cudgel/bludgeon/
ごう慢 [ごうまん] /(adj-na,n) pride/haughtiness/arrogance/insolence/hubris/
ごくごく /(adv,adv-to) (on-mim) gulping repetitively/
ごくり /(adv,adv-to) (on-mim) gulpingly/
ごくわずか /(exp,adj-na) derisory/negligible/minimal/nominal/imperceptible/
ごく一部 [ごくいちぶ] /(exp) small fraction/small proportion/
ごく最近 [ごくさいきん] /(adj-no,n-adv,n-t) very recently/in the very recent past/
ごく潰し [ごくつぶし] /(n) good-for-nothing/parasite/deadbeat/loafer/drone/idler/
ごしごし /(n,vs,adv) (on-mim) scrubbing/rubbing briskly/rasping/
ごしゃごしゃ /(adj-no,adj-na,adv,adv-to,vs) jumbled/disarrayed/messy/
ごそごそ /(adv,n,vs) (on-mim) rummaging sound/jarring sound/
ごたごた /(adj-na,adv,n,vs) (on-mim) trouble/confusion/
ごたつく /(v5k,vi) to be confused/to be in disorder/
ごた混ぜ [ごたまぜ] /(n,adj-na) jumble/hodgepodge/
ごち /(n) (sl) treat/banquet/feast/entertainment/goodies/
ごちゃごちゃ /(adj-na,adv,n,vs) (1) (on-mim) jumble/mix up/(2) complaining about various things/
ごちゃ混ぜ [ごちゃまぜ] /(n,adj-na) mess/jumble/muddle/chaos/
ごっくり /(adv,adv-to) (on-mim) gulpingly/
ごっくん /(n) (1) (on-mim) gulp/(2) (vulg) semen-swallowing/
ごっこ /(n-suf) something done together/game of make-believe/
ごっそり /(adv) completely/entirely/wholly/
ごった /(adj-na) confusion/mess/mix/huddle/
ごった煮 [ごったに] /(n) various foods cooked together/hodgepodge/hotchpotch/mulligan stew/
ごった返す [ごったがえす] /(v5s,vi) to be in confusion or commotion/to be in a turmoil/to be crowded or jammed with people/
ごっちゃ /(adj-na,adv,n,vs) (1) (on-mim) jumble/mix up/(2) complaining about various things/
ごっつあん /(exp) (sl) thank you (sumo slang)/
ごっつい /(adj-i) (1) rough/tough/hard/(2) unrefined/rustic/(3) exceeding/extreme/too much/
ごっつい手 [ごっついて] /(n) big hands/massive hands/
ごっつん盗 [ごっつんとう] /(n) (sl) stealing a car by rear-ending it lightly and having a friend jump in and drive off after the driver gets out/
ごってり /(adv,adv-to,vs) (1) thickly/heavily/richly/(2) severely/strongly/
ごつい /(adj-i) (1) rough/tough/hard/(2) unrefined/rustic/(3) exceeding/extreme/too much/
ごつい手 [ごついて] /(exp) big hands/massive hands/
ごつごつ /(adv,n,vs) (on-mim) rugged/scraggy/angular/
ごつん /(adv) thud/thump/bang/
ごとごと /(adv,adv-to) (1) clop clop/rumble rumble/(2) sound of something being boiled/
ごとり /(adv-to,adv) thump/clang/clank/
ごにょごにょ /(adv) (speak) mumblingly/unintelligibly/
ごねる /(v1,vi) to grumble/to make difficulties/
ごね得 [ごねどく] /(n) (col) getting what one wants by complaining or grumbling/profiting by holding out or taking a hard line/getting more by raising a ruckus/
ごほん /(int) cough/ahem/
ごぼごぼ /(adv) (on-mim) sound of gushing water/
ごぼっ /(adv-to) gurgling down/being sucked into/caving in suddenly/
ごまんと /(adv) in a great quantity/
ごま豆腐 [ごまどうふ] /(n) crushed sesame seeds boiled in water and chilled like tofu/
ごま油 [ごまあぶら] /(n) sesame oil/
ごみごみ /(adv,adv-to,vs) (on-mim) squalid/messy/
ごみ屋 [ごみや] /(n) (sens) ragman/garbage man/garbage collector/
ごみ音 [ごみおん] /(n) contamination noise/noise from contamination/
ごみ焼き炉 [ごみやきろ] /(n) incinerator/refuse furnace/
ごみ袋 [ごみぶくろ] /(n) garbage bag/
ごみ入 [ごみいれ] /(n) trashcan/rubbish bin/dustbin/ashcan/
ごみ入れごみ出し [ごみいれごみだし] /(exp) (comp) garbage in, garbage out/
ごみ箱 [ごみばこ] /(n) garbage can/garbage box/rubbish bin/trash can/dust bin/dustbin/
ごりごり /(adv,adv-to,vs) (1) scraping/scratching/(adj-no,adj-na) (2) hard (to the bite, to the touch)/
ごり押し [ごりおし] /(n,vs) pushing though/bulldozing/doing something by force/arm twisting/
ごろごろ /(adv,n,vs,adv-to) (1) (on-mim) thunder/purring/grumbling (e.g. stomach)/(2) something large and heavy starting to roll/(3) scattered about/(4) idleness/idle about/(5) having a foreign substance in (e.g. one's eye or stomach)/(P)/
ごろっと /(adv) (1) (on-mim) slumping/flopping down/(2) heavily rotating/
ごろつく /(v5k,vi) (1) to rumble/to thunder/to roll about (people, large objects)/(2) to wander about without a fixed workplace, home, etc./to hang around/to loiter/
ごろりと /(adv) (1) (on-mim) slumping/flopping down/(2) heavily rotating/
ごろりと横になる [ごろりとよこになる] /(exp,v5r) to throw oneself down/to lie down/
ごろ合せ [ごろあわせ] /(n) rhyming game/play on words/pun/
ごろ寝 [ごろね] /(n,vs) dozing/napping (e.g. on the floor in one's clothes, in the train)/
ごわごわ /(adj-na,adv,vs) (on-mim) stiff/starchy/
ごわす /(aux-v) (Satsuma) to be/
ごわつく /(v5k,vi) to be stiff/to be starchy/
ごわんす /(aux-v) (Satsuma) to be/
ごんごん /(adv) (on-mim) bang/clang/
ごんす /(exp) (abbr) (arch) (pol) to be/to exist/
ご挨拶 [ごあいさつ] /(n) (1) (pol) greeting/(2) a fine thing to say (used as part of a sarcastic response to a rude remark)/
ご意見を伺う [ごいけんをうかがう] /(exp,v5u) to ask the opinion of (a superior)/
ご意見箱 [ごいけんばこ] /(n) (1) suggestion box/opinion box/(2) advisor/sounding board/
ご一緒 [ごいっしょ] /(n,vs) (hon) going together/
ご一新 [ごいっしん] /(n) the (Meiji) restoration/
ご影 [ごえい] /(n) (hon) image (esp. of a deity, buddha, royal, noble, etc.)/
ご詠歌 [ごえいか] /(n) song in praise of the Buddha/
ご遠慮ください [ごえんりょください] /(exp) please refrain from ~ (e.g. smoking, etc.)/(P)/
ご遠慮下さい [ごえんりょください] /(exp) please refrain from ~ (e.g. smoking, etc.)/(P)/
ご恩 [ごおん] /(n) (hon) (received) favor, kindness or blessing (favour)/
ご下問 [ごかもん] /(n) a question from the emperor/
ご家人 [ごけにん] /(n) lower-ranking vassal in the Kamakura and Edo periods/
ご希望の向きは [ごきぼうのむきは] /(exp) those who want it/
ご機嫌 [ごきげん] /(adj-na,n,adj-no) pleasant/in a good mood/in high spirits/
ご機嫌いかがですか [ごきげんいかがですか] /(exp) (uk) How are you?/
ご機嫌よう [ごきげんよう] /(int) (1) (uk) how do you do?/nice to meet you/(2) adieu/farewell/bon voyage/
ご機嫌斜め [ごきげんななめ] /(exp) in a bad temper/
ご機嫌麗しい [ごきげんうるわしい] /(adj-i) in good humor (humour)/
ご協力 [ごきょうりょく] /(n,vs) cooperation/collaboration/
ご苦労 [ごくろう] /(adj-na,int,n) (hon) trouble (I have put you through)/
ご苦労さま [ごくろうさま] /(exp,adj-na) thank you very much for your .../I appreciate your efforts/(P)/
ご苦労さん [ごくろうさん] /(exp) I appreciate your efforts/
ご苦労様 [ごくろうさま] /(exp,adj-na) thank you very much for your .../I appreciate your efforts/
ご兄弟 [ごきょうだい] /(n) (hon) siblings/brothers and sisters/
ご降誕 [ごこうたん] /(n,vs) birth (regal)/nativity/
ご沙汰 [ごさた] /(n) (imperial) words/
ご座います [ございます] /(exp) (pol) to be/to exist/
ご座る [ござる] /(v4r,vi) (pol) (arch) (abbr) to be/
ご座居る [ございる] /(v1) (uk) (arch) to be (very pol.)/
ご座所 [ござしょ] /(n) a throne/
ご三家 [ごさんけ] /(n) (1) three branch Tokugawa families (Owari, Kii, and Mito)/(2) big three/top three/
ご三卿 [ごさんきょう] /(n) three secondary Tokugawa branch families (Tayasu, Shimizu, and Hitotsubashi)/
ご参考まで [ごさんこうまで] /(exp) for your reference/FYR/for your information/FYI/
ご自身 [ごじしん] /(n) himself/yourself/herself/
ご主人 [ごしゅじん] /(n) (hon) your husband/her husband/(P)/
ご朱印 [ごしゅいん] /(n) letter bearing the shogun's scarlet seal/
ご朱印船 [ごしゅいんせん] /(n) shogun-authorized trading vessel (authorised)/
ご愁傷さま [ごしゅうしょうさま] /(exp) my condolences/
ご愁傷様 [ごしゅうしょうさま] /(exp) my condolences/
ご愁傷様でございます [ごしゅうしょうさまでございます] /(exp) my condolences/
ご所 [ごしょ] /(n) old imperial palace/
ご所車 [ごしょぐるま] /(n) an ox-drawn coach/
ご笑納 [ごしょうのう] /(n,vs) (hum) please accept (this)/used to refer to another's acceptance of one's present/
ご心配なく [ごしんぱいなく] /(exp) don't worry/never mind/
ご新造 [ごしんぞ] /(n) wife (esp. of a prominent, recently married man)/
ご新造 [ごしんぞう] /(n) wife (esp. of a prominent, recently married man)/
ご真影 [ごしんえい] /(n) an imperial portrait/
ご神火 [ごじんか] /(n) deified volcano or volcanic eruption/
ご神体 [ごしんたい] /(n) shintai/object of worship housed in a Shinto shrine and believed to contain the spirit of a deity/
ご神灯 [ごしんとう] /(n) (1) light used as a religious offering/(2) paper lantern (hung up near the door of performers and geishas)/
ご親拝 [ごしんぱい] /(n) (hon) worship by the emperor at a shrine/
ご仁 [ごじん] /(n) (hon) personage/
ご成功 [ごせいこう] /(n) your success/
ご前を退く [ごぜんをのく] /(exp,v5k) to withdraw from the presence (of the Emperor)/
ご前会議 [ごぜんかいぎ] /(n) Imperial Council/
ご膳 [ごぜん] /(n) (hon) meal/emperor's meal/
ご存じ [ごぞんじ] /(n) (1) (hon) knowing/(2) (an) acquaintance/(P)/
ご存じの方 [ごぞんじのかた] /(n) (1) (hon) your acquaintance/(2) (hon) people who know/
ご存知 [ごぞんじ] /(ateji) (n) (1) (hon) knowing/(2) (an) acquaintance/
ご存知なのか [ごぞんじなのか] /(exp) do you know/perhaps you know/I wonder if you know/
ご多分 [ごたぶん] /(n) common/in the usual course/
ご多分にもれず [ごたぶんにもれず] /(exp) as is usual with/in common with/
ご多分に洩れず [ごたぶんにもれず] /(exp) as is usual with/in common with/
ご多分に漏れず [ごたぶんにもれず] /(exp) as is usual with/in common with/
ご多忙中 [ごたぼうちゅう] /(exp) in the midst of your work (often used as a formal phrase in business letters, etc.)/
ご大層 [ごたいそう] /(adj-na,n) exaggerated story/
ご託 [ごたく] /(n) tedious talk/impertinent talk/repetitious talk/saucy speech/pretentious statement/
ご馳走 [ごちそう] /(n) (1) feast/treating (someone)/(vs) (2) to treat (someone, e.g. to a meal)/(P)/
ご馳走さま [ごちそうさま] /(int) (1) word used after one has been treated (esp. used after a meal)/(2) used after hearing something lovey-dovey/(P)/
ご馳走様でした [ごちそうさまでした] /(exp) said after meals/
ご注意 [ごちゅうい] /(n) caution/being careful/attention (heed)/warning/advice/
ご注文 [ごちゅうもん] /(n,vs) order/request/
ご殿 [ごてん] /(n) palace/court/
ご殿女中 [ごてんじょちゅう] /(n) waiting woman in a shogun or daimyo's palace/
ご都合主義 [ごつごうしゅぎ] /(n) opportunism/double standards/timeserving/expediency/
ご都合主義者 [ごつごうしゅぎしゃ] /(n) opportunist/
ご難 [ごなん] /(adj-na,n) misfortune/calamity/
ご念 [ごねん] /(n) worry/care/consideration/
ご破算 [ごはさん] /(n) starting afresh/
ご飯 [ごはん] /(n) (1) cooked rice/(2) meal/(P)/
ご飯時 [ごはんどき] /(n) mealtime/
ご飯蒸し [ごはんむし] /(n) a rice steamer/
ご不浄 [ごふじょう] /(n) (pol) bathroom/
ご府内 [ごふない] /(n) within the town limits of Edo/
ご幣 [ごへい] /(n) (hon) staff with plaited paper streamers used in Shinto/
ご幣担ぎ [ごへいかつぎ] /(n) superstition/superstitious person/
ご鞭撻 [ごべんたつ] /(n,vs) encouragement/enthusiasm/urging/
ご方便 [ごほうべん] /(n) (1) (Buddh) (hon) upaya (skillful means, methods of teaching)/(2) convenience/suitability/availability/
ご褒美 [ごほうび] /(n) reward/prize/
ご本 [ごほん] /(n) (hon) (pol) book/
ご本尊 [ごほんぞん] /(n) (1) principal object of worship at a temple (usu. a buddha or bodhisattva)/principal image/idol/(2) the man himself/the person at the heart of the matter/
ご満悦の体 [ごまんえつのてい] /(exp) looking satisified/looking very pleased/
ご満悦の態 [ごまんえつのてい] /(exp) looking satisified/looking very pleased/
ご無沙汰 [ごぶさた] /(n,vs) not writing or contacting for a while/neglecting (failing) to write (call, visit, etc.)/long silence/
ご無理ご尤も [ごむりごもっとも] /(exp) you are unquestionably right/
ご迷惑 [ごめいわく] /(n,adj-na) trouble/bother/annoyance/
ご免 [ごめん] /(int,n) (uk) your pardon/declining (something)/dismissal/permission/(P)/
ご免あそばせ [ごめんあそばせ] /(exp) (uk) (pol) (fem) I beg your pardon/
ご免ください [ごめんください] /(exp) (1) may I come in?/(2) (pol) please forgive me/I'm sorry/(P)/
ご免こうむる [ごめんこうむる] /(exp,v5r) (1) to receive permission/(2) to leave (with someone's permission)/to retire/(3) to refuse/to beg off doing/
ご免なさい [ごめんなさい] /(exp) I beg your pardon/excuse me/
ご免下さい [ごめんください] /(exp) (1) may I come in?/(2) (pol) please forgive me/I'm sorry/
ご免被る [ごめんこうむる] /(exp,v5r) (1) to receive permission/(2) to leave (with someone's permission)/to retire/(3) to refuse/to beg off doing/
ご免遊ばせ [ごめんあそばせ] /(iK) (exp) (uk) (pol) (fem) I beg your pardon/
ご面相 [ごめんそう] /(n) frightful face/
ご尤も [ごもっとも] /(exp) (1) You are quite right/(adj-na,adv) (2) (pol) plausible/natural/
ご用 [ごよう] /(n) your order/your business/official business/
ご用の方 [ごようのかた] /(n) customer/guest/
ご用学者 [ごようがくしゃ] /(n) a scholar beholden to the government/
ご用始め [ごようはじめ] /(n) re-opening of offices in New Year (usu. Jan. 4)/
ご用商人 [ごようしょうにん] /(n) a purveyor to the government/
ご用新聞 [ごようしんぶん] /(n) a government newspaper or organ/
ご用組合 [ごようくみあい] /(n) a company union/
ご用達 [ごようたし] /(n) purveyor to the government/purveyor to the Imperial Household/
ご用達 [ごようたつ] /(n) purveyor to the government/purveyor to the Imperial Household/
ご用達 [ごようだち] /(n) purveyor to the government/purveyor to the Imperial Household/
ご用達 [ごようだつ] /(n) purveyor to the government/purveyor to the Imperial Household/
ご用納め [ごようおさめ] /(n) year-end office closing (usu. Dec. 28)/
ご用聞き [ごようきき] /(n) (1) the rounds of tradesmen going door to door/(2) route man/door-to-door tradesman/order taker/order-taking/(3) thief taker/secret policeman/
ご来光 [ごらいこう] /(n) sunrise viewed from the top of a high mountain/the rising sun/
ご来店 [ごらいてん] /(n,vs) (hon) coming to the store/
ご覧 [ごらん] /(int) (1) (abbr) (after the -te form of a verb) (please) try to/(2) (abbr) (please) look/(n) (3) (hon) seeing/looking/watching/
ご覧ください [ごらんください] /(exp) (uk) (hon) please look at it/
ご覧なさい [ごらんなさい] /(exp) (1) (hon) (pol) (please) look/(2) see (used to emphasize that an earlier prediction was correct)/(aux-v) (3) (hon) (pol) (after the -te form of a verb) (please) try to do/
ご覧なさる [ごらんなさる] /(v5aru) (hon) to see/to look/to watch/
ご覧になる [ごらんになる] /(exp,v5r) (1) (hon) to see/to look/to watch/(2) (after the -te form of a verb) try to/(P)/
ご覧に成る [ごらんになる] /(exp,v5r) (1) (hon) to see/to look/to watch/(2) (after the -te form of a verb) try to/
ご覧に入れる [ごらんにいれる] /(exp,v1) (hum) to show/to display/
ご覧の通り [ごらんのとおり] /(exp) (hon) as you see/
ご覧下さい [ごらんください] /(exp) (uk) (hon) please look at it/
ご利益 [ごりやく] /(n) (1) grace (of God)/divine favour/blessing/miracle/(2) benefit/(3) efficacy/
ご立派 [ごりっぱ] /(adj-na) (pol) splendid/fine/handsome/elegant/imposing/prominent/legal/legitimate/
ご了承 [ごりょうしょう] /(n,vs) acknowledgement/acknowledgment/understanding (e.g. "please be understanding of the mess during our renovation")/noting/
ご両親 [ごりょうしん] /(n) your (honorable, honourable) parents/
ご寮人 [ごりょうにん] /(n) mistress/madam/
ご陵 [ごりょう] /(n) imperial tomb/
ご令嬢 [ごれいじょう] /(n) (hon) (your) daughter/young woman/
ご令息 [ごれいそく] /(n) (hon) son/
ご霊前 [ごれいぜん] /(n) "before the spirit of the deceased" (written on the condolence-money envelope)/
ご連絡 [ごれんらく] /(vs) (1) (hon) to contact/to get in touch/(n) (2) contacting/getting in touch/communication/(your) call/(your) message/
ご連絡申し上げます [ごれんらくもうしあげます] /(exp) I am writing ..../we are contacting .../
さ /(suf) (1) -ness (nominalizing suffix indicating degree or condition)/(prt) (2) (sentence end, mainly masc.) indicates assertion/(int) (3) come/come now/(P)/
さーたーあんだぎー /(n) type of Okinawan doughnut (donut)/
さあ /(conj,int) come/come now/(P)/
さあさあ /(int) come/come now/
さあっと /(n) (1) relatively quickly (esp. actions)/(2) quite suddenly (esp. wind, rain, etc.)/
さいの目 [さいのめ] /(n) (1) pip (spot on a die)/(2) small cube (esp. of food)/die/dice/
さい銭 [さいせん] /(n) monetary offering/offertory/
さい帯血 [さいたいけつ] /(n) umbilical cord blood/
さえ /(prt) even/if only/if just/as long as/the only thing needed/(P)/
さえあれば /(exp) if only (you) have/(P)/
さえに /(exp) furthermore/and another thing/even as/
さえも /(exp) even/if only/if just/as long as/the only thing needed/
さお竹 [さおだけ] /(n) bamboo pole/
さかい /(prt) (ksb:) because/since/
さがし出す [さがしだす] /(v5s,vt) to locate/to discover/
さく /(n) (1) (uk) capsule (moss sporangium)/(2) capsule (type of dehiscent fruit)/
さくい /(adj-i) (1) friendly/sociable/(2) brittle/fragile/light/
さくさく /(adv,vs) (on-mim) crunchy/crisp (not moist or juicy)/flaky (as in pastry)/
さくっ /(adv-to) (1) (on-mim) with a crunching or grinding sound/(2) quickly/promptly/abruptly/simply/efficiently/(3) crispily/crunchily/
さくらの木 [さくらのき] /(n) cherry tree/
さくらめーる /(n) congratulatory postcards with a spring pattern sold every year in February/
さくらメール /(n) congratulatory postcards with a spring pattern sold every year in February/
さく果 [さくか] /(n) capsule (type of dehiscent fruit)/
さく乳器 [さくにゅうき] /(n) (1) breast pump/(2) milking device/milking machine/
さく薬 [さくやく] /(n) explosives/
さく裂 [さくれつ] /(n,vs) explosion/
ささくれ /(n) fine split/hangnail/
ささくれる /(v1,vi) (1) to split finely/to splinter/to get frayed/(2) to become irritable/
ささげ持つ [ささげもつ] /(v5t) to hold something reverently with both hands/
ささげ銃 [ささげつつ] /(n) presenting arms/
ささめく /(v5k,vi) to whisper/
ささやき声 [ささやきごえ] /(n) whisper/murmur/
さざめき /(n) hubbub/din/noise/
さざめく /(v5k,vi) to be boisterously noisy/
さざれ石 [さざれいし] /(n) (1) pebbles/gravel/(2) boulder formed from gravel and sediment/
さざれ波 [さざれなみ] /(n) (arch) ripple/
さざ波 [さざなみ] /(n) (uk) ripple (on water)/wavelets/
さし /(n) blowfly maggots used as fishing bait/
さしすせそ /(n) the five fundamental seasonings used in Japanese cooking: (in order) sugar, salt, vinegar, soy sauce, miso/
さしもの /(exp) as though one is/
さし出す [さしだす] /(v5s,vt) to present/to submit/to tender/to hold out/
さし招く [さしまねく] /(v5k,vt) to beckon (to)/
さし錠 [さしじょう] /(n) (obsc) bolt/
さじ加減 [さじかげん] /(n) prescription/consideration/making allowances for/
さすけね /(exp) (thb:) no problem/that's OK/
させて頂く [させていただく] /(exp,v5k) (hum) to have the privilege of doing/
させる /(aux-v,v1) (1) auxiliary verb indicating the causative/(2) (hum) auxiliary verb indicating that one has been granted the permission to do something/(3) auxiliary verb used to make verbs more "active"/(4) (hon) auxiliary verb used as an extreme honorific for others' actions/
させ子 [させこ] /(n) whore/
さっき /(n) some time ago/(P)/
さっくり /(adv) lightly/gently/
さっさと /(adv) (on-mim) quickly/(P)/
さった /(n) (1) (Buddh) (abbr) sattva (being)/(2) bodhisattva/
さっぱり /(adj-na,adv,n,vs,adv-to) (1) (on-mim) feeling refreshed/feeling relieved/(2) neat/trimmed/(3) plain/simple/(4) completely/entirely/(5) not in the least (in sentence with negative verb)/not at all/(n) (6) completely ignorant/not doing at all/(P)/
さっぱり分かりません [さっぱりわかりません] /(exp) having no inkling of/having no idea of/
さっぱり分らない [さっぱりわからない] /(exp,adj-i) having no inkling of/having no idea of/
さっ果 [さっか] /(n) capsule (type of dehiscent fruit)/
さつま芋 [さつまいも] /(n) sweet potato (Ipomoea batatas)/
さてこそ /(adv) (1) just as I thought/as expected/(2) that's why/
さてさて /(int) well/now/then/
さては /(conj) and then/besides/on top of that/
さて置き [さておき] /(conj) setting aside/leaving to one side/
さて置く [さておく] /(v5k) (uk) to set aside/
さばけ口 [さばけぐち] /(n) (1) outlet (e.g. for water or gas)/(2) market (for something)/(3) outlet (e.g. for excess energy)/vent (e.g. for emotions)/
さばさば /(adv,n,vs) (on-mim) relief/candid/
さばを読む [さばをよむ] /(exp,v5m) to manipulate figures to one's advantage/to count wrongly on purpose/to inflate or deflate one's age/
さば雲 [さばぐも] /(n) cirrocumulus cloud/
さば節 [さばぶし] /(n) dried, smoked mackerel/shavings from dried, smoked mackerel/
さび /(n) (1) hook (high point of a song)/(2) (abbr) (at a sushi shop) wasabi/
さび止め [さびどめ] /(n) rust-proofing/anti-corrosive/
さび色 [さびいろ] /(n,adj-no) rust (colour)/
さぶる児 [さぶるこ] /(n) (arch) (uk) prostitute and entertainer/
さぶる少女 [さぶるおとめ] /(n) (arch) prostitute and entertainer/
さまざまな理由から [さまざまなりゆうから] /(exp) for various reasons/
さまよえるユダヤ人 [さまよえるユダヤじん] /(n) Wandering Jew/
さめざめ /(adv) (on-mim) sorrowfully/anguishedly/
さもしい /(adj-i) selfish/self-seeking/self-interested/mean/
さやさや /(adv,adv-to) rustling/
さや取り [さやとり] /(n) brokerage/
さようならホームラン /(n) game-ending home run (baseball)/
さよか /(int) (1) (osb:) really?/(2) no thanks/
さよなら /(int) good-bye/(P)/
さよならホームラン /(n) game-ending home run (baseball)/
さらけ出す [さらけだす] /(v5s,vt) to expose/to disclose/to lay bare/to confess/
さらさら /(adj-na,adv-to,n,vs) (1) (on-mim) rustling/murmuring/(2) fluently/(3) silky (hair)/(P)/
さらし者 [さらしもの] /(n) pilloried criminal exposed to public view/public scorn or humiliation/person shamed in front of others/
さらし粉 [さらしこ] /(n) bleaching powder/
さらに悪いこと [さらにわるいこと] /(exp) and what is worse/to make matters worse/
さらば /(conj,int) farewell/
さらり /(adv,adv-to) (1) (on-mim) sleek/smooth/(2) thin (of a liquid)/(3) without hesitation or delay/
さり気ない [さりげない] /(adj-i) (uk) nonchalant/unconcerned/in a casual manner/
さるおがせ /(n) (uk) old man's beard (any lichen of genus Usnea)/
さる事 [さること] /(n) (1) (uk) something like that/that sort of thing/(2) something natural/something plausible/
さる年 [さるどし] /(n) year of the monkey/
されてしまった /(exp) (suru verb ending, passive) done and finished/done once and for all/
されなければならない /(exp) must have been done/has to have been done/
さん /(suf) (1) Mr, Mrs, Miss or Ms/(2) honorific used with occupational titles/(P)/
さんざ /(adv) (abbr) severely/harshly/utterly/terribly/
さんざめく /(v5k,vi) to be boisterously noisy/
さんや袋 [さんやぶくろ] /(n) pilgrim's carry-all bag/
さん付け [さんづけ] /(n,vs) attaching 'san' to somebody's name/
さ湯 [さゆ] /(n) (plain) hot water/boiled water/
さ迷う [さまよう] /(v5u,vi) to loiter/to putter/to prowl/to wander about/to roam about/to knock around/
さ迷える [さまよえる] /(v1) (uk) to wander/
さ迷えるユダヤ人 [さまよえるユダヤじん] /(n) Wandering Jew/
さ来月 [さらいげつ] /(n-adv,n-t) month after next/
さ来週 [さらいしゅう] /(n-adv,n-t) week after next/
さ来年 [さらいねん] /(n-adv,n-t) year after next/
ざあざあ /(adv) (on-mim) sound of rushing water/sound of pouring rain/white noise sound/(P)/
ざあっ /(adv,n) (on-mim) sound of water/
ざくざく /(adj-na,adv,adv-to) (1) (on-mim) lots of coins or jewels/(2) cutting up roughly/(3) walking on frost/(4) mixing gravel/
ざくろ鼻 [ざくろばな] /(n) rhinophyma/red swollen nose (often associated with alcoholism)/
ざく切り [ざくぎり] /(n,vs) cutting into chunks (esp. vegetables)/
ざけんじゃねーよ /(exp) (X) (vulg) fuck you!/don't fuck with me!/don't fuck around!/don't be a screw off!/
ざけんなよ /(exp) (X) (vulg) fuck you!/don't fuck with me!/don't fuck around!/don't be a screw off!/
ざざめく /(v5k,vi) to be boisterously noisy/
ざざ虫 [ざざむし] /(n) (in Shinshu) dobsonfly or stonefly larva/
ざっくざっく /(adv) crunch crunch/thud thud/tramp tramp/
ざっくばらん /(adj-na,n) frankness/
ざっくり /(adv,vs) (1) roughly/approximately/loosely/(2) cutting or breaking apart with vigour/(3) deeply (cut or split)/(4) rough (woollens, etc., as adjectival phrase with (to)shita)/(5) sound of treading on pebbles/
ざっと /(adv) (on-mim) roughly/in round numbers/(P)/
ざぶざぶ /(adv) (on-mim) gushing (of water, etc.)/
ざぶり /(adv-to,adv) (on-mim) splash/plop/
ざぶりざぶり /(adv-to) (on-mim) sound of living, moving water/
ざぶん /(adv-to,adv) (on-mim) splash/plop/
ざます /(aux-v) (arch) to be/
ざまを見ろ [ざまをみろ] /(exp) serves you right!/see what happens!/
ざら /(adj-na) common/
ざらざら /(adj-na,adv,n,vs,adv-to,adj-no) (on-mim) feeling rough/(P)/
ざらつく /(v5k,vi) to be rough feeling/
ざらにある /(exp) common (of object)/
ざらにいる /(exp,v1) common (of people)/
ざらめ糖 [ざらめとう] /(n) granulated sugar/
ざら紙 [ざらがみ] /(n) pulp paper/rough (printing) paper/
ざら場 [ざらば] /(n) continuous session (e.g. trading in a stock exchange)/zaraba/
ざり /(aux) (1) (arch) (used after a -nai stem) not .../(exp) (2) is/are/
ざりがに /(n) (uk) crayfish (esp. Japanese crayfish, Cambaroides japonicus)/
ざる /(aux) (arch) not/un-/
ざるべからず /(exp,aux) (arch) must (do, be)/
ざるを得ない [ざるをえない] /(exp) cannot help (doing)/have no choice but to/am compelled to/am obliged to/it is incumbent upon (me) to/
ざる得ない [ざるえない] /(exp) cannot help (doing)/have no choice but to/
ざわざわ /(adv,n,vs) (on-mim) noisy/sound of people talking/(P)/
ざわつく /(v5k,vi) to be noisy (e.g. from people talking)/
ざんざめく /(v5k,vi) to be boisterously noisy/
ざんす /(aux-v) (arch) to be/
ざんばら髪 [ざんばらがみ] /(n) loose and disheveled hair/
ざんぶ /(adv-to,adv) (on-mim) splash/plop/
ざんぶり /(adv-to,adv) (on-mim) splash/plop/
ざ瘡 [ざそう] /(n) acne/
し /(n) (obsc) 10**24/septillion (American)/quadrillion (British)/
し /(prt,conj) (at the end of a phrase) notes one (of several) reasons/(P)/
しーっ /(int) Shhh! (sound used when getting someone to shut up)/
しいさあ /(n) Okinawan lion statues, used as talisman against evil/
しいら /(n) (uk) mahimahi (Coryphaena hippurus)/common dolphinfish/dolphin/dorado/
しいんと /(adv,vs) (on-mim) silently (as the grave)/quietly (as in death)/
しおらしい /(adj-i) meek/gentle/modest/sweet/
しか /(prt) only (used with a negative verb)/nothing but/(P)/
しかけ絵本 [しかけえほん] /(n) pop-up book/
しかと /(n,vs) (sl) ostracism/ignoring someone/leaving someone out/
しかない /(exp) have no choice/(P)/
しかめっ面 [しかめっつら] /(n) frown or scowl/grimace/
しかめ面 [しかめつら] /(n) frown or scowl/grimace/
しかるが故に [しかるがゆえに] /(conj) as such/that being so/for that reason/
しかる後 [しかるのち] /(n-adv,n-t) thereafter/after doing that/followed by/
しかる上は [しかるうえは] /(conj) now that it is as such/since it is as such/
しがたい /(exp) (suru verb ending) hard to do/
しがない /(adj-i) (1) poor/humble/(2) (arch) uninteresting/trivial/
しがみ付く [しがみつく] /(v5k) (uk) to cling/
しきい値 [しきいち] /(n) threshold (amount, dose, etc.)/(P)/
しくしく /(adv,adv-to,vs) (1) (on-mim) weeping/sobbing/crying/(2) with a dull pain/prolonged dull pain/
しくしく泣く [しくしくなく] /(v5k) to sob/to weep/
しくじり /(n) failure/
しくじる /(v5r,vi) to fail/to fall through/to blunder/(P)/
しくる /(v5r) (sl) to fail/to stuff up/
しけもく /(n) (sl) smokeable cigarette end (butt)/
しこたま /(adv) a lot/loads/plenty/
しこ名 [しこな] /(n) (uk) sumo wrestler's stage name/
しずしず /(adv) (on-mim) sweaty atmosphere/
したい /(adj-i) want to do/
したい気がする [したいきがする] /(exp,vs-i) to feel like doing/
したがる /(exp,v5r) (1) to wish (to do)/to desire/to want/(2) to be ready/to be eager/
したたか者 [したたかもの] /(n) (1) strong-willed person/old hand/shrewd rascal/wily fox/desperate character/formidable woman/(2) strong man/brave man/
したり /(int) God bless me!/Good heavens!/
したり顔 [したりがお] /(n,adj-no) self-satisfied look/triumphant expression/
した方がいい [したほうがいい] /(exp) had better do so/
しだらない /(adj-i) slovenly/
しだり尾 [しだりお] /(n) drooping tail/
しっくり /(adv-to) (1) (on-mim) exactly/nicely/to a tee/(vs) (2) to be fitting/
しっくり行く [しっくりいく] /(v5k-s) to get on well with (someone)/
しっこ /(n) (1) (col) wee-wee/pee-pee/number one/(vs) (2) to urinate/
しっとり /(adv,vs) (1) calm/graceful/(2) quiet/mellow/(3) damp/moist/
しっとりと /(adv) (on-mim) gently/softly/
しっぺ返し [しっぺがえし] /(n) returning tit for tat/retaliating/
しっぽり /(adv) (1) drenched/soaked/(2) (of love) tender/
しつこい /(adj-i) (1) insistent/obstinate/persistent/tenacious/(2) too rich (taste, etc.)/fatty/heavy/greasy/(P)/
しつっこい /(adj-i) (1) insistent/obstinate/persistent/tenacious/(2) too rich (taste, etc.)/fatty/heavy/greasy/
しつつある /(exp,v5r-i) to be doing/to be in the process of doing/
しつつ行なう [しつつおこなう] /(exp,v5u) (1) to be carrying out/to be in the process of carrying out/(2) to be performing/to be in the process of performing/
して /(prt) (1) by (indicating means of action)/as (a group, etc.)/(2) indicates patient of a causative expression/(3) (after the ren'youkei form of an adjective) acts as a connective/(4) (after an adverb or a particle) adds emphasis/(conj) (5) and then/
してみると /(exp) then/in that case/considering/if that is the case/if so/
してみれば /(exp) then/in that case/considering/if that is the case/if so/
して遣られる [してやられる] /(exp,v1) (uk) to be forestalled/to be taken in/to be cheated/to be outwitted/
して遣る [してやる] /(v5r,vt) (uk) to do for (someone)/
して言えば [していえば] /(n) if I must say (choose)/
しとしと /(adj-na,adv,n) (on-mim) gently/(P)/
しとど /(adv) (arch) dripping wet/
しどけない /(adj-i) slovenly/
しどろもどろ /(adj-no) flustered/confused/disordered/incoherent/
しないのではないか /(exp) I think (something) won't (something)/probably (something) isn't (something)/(P)/
しなを作る [しなをつくる] /(exp,v5r) to put on coquettish airs/to act flirtatiously/to act kittenish/
しのぎを削る [しのぎをけずる] /(exp,v5r) to compete ruthlessly/to sharpen swords/
しばおま /(exp) (abbr) please wait/one moment please/
しばく /(v5k) (ksb:) to strike/to hit/
しばしば /(vs,adv) (on-mim) blinking repeatedly/
しばしば目 [しばしばめ] /(exp) blinking away tears/blinking tear filled eyes/
しばらくの間 [しばらくのあいだ] /(exp,adv) for a short while/for a while/for some time/for the time being/
しびれ感 [しびれかん] /(n) numbness/
しびれ薬 [しびれぐすり] /(n) (obsc) anesthetic/anaesthetic/
しぶとい /(adj-i) tenacious/tough/enduring/dogged/headstrong/stubborn/obstinate/unyielding/
しぼり汁 [しぼりじる] /(n) squeezed juice (e.g. of a lemon)/
しまいに /(adj-f) at the end/finally/
しまい込む [しまいこむ] /(v5m,vt) to put away/to stow away/to tuck away/to hoard/
しまった /(exp) damn it!/damn!/oops!/oh dear!/oh no!/(P)/
しまりが無い [しまりがない] /(exp,adj-i) not at all tense/relaxed/calm/
しまんちゅ /(n) (rkb:) islanders/
しま模様 [しまもよう] /(n,adj-no) striped pattern/
しみったれ /(n,adj-na,adj-no) stinginess/miser/
しみったれる /(v1,vi) to be stingy/to be tightfisted/
しみ込む [しみこむ] /(v5m,vi) to soak into/to permeate/
しみ出し [しみだし] /(n) seepage/
しみ出す [しみだす] /(v5s) to ooze (out)/to seep/
しみ出る [しみでる] /(v1,vi) to ooze/to exude/to percolate/to soak through/
しめやか /(adj-na) quiet and subdued in appearance/solemn/sad and depressed in manner/soft/gentle/
しめる /(v1,aux-v) (arch) to make (old causative verbal ending)/to let/
しめ縄 [しめなわ] /(n) (Shinto) rope used to cordon off consecrated areas or as a talisman against evil/
しもた屋 [しもたや] /(n) store that has been gone out of business/household that lives without carrying on a business/
しもつかれ /(n) dish of simmered salmon head, soybeans, vegetables, and leftovers (popular in Tochigi Prefecture and surrounds)/
しゃあしゃあ /(adv,n,vs) shamelessly/
しゃあない /(exp) (osb:) it can't be helped/so it goes/c'est la vie/
しゃがみ込む [しゃがみこむ] /(v5m,vi) (uk) to squat/to crouch down (completely, generally with face looking through knees)/
しゃがむ /(v5m,vi) to squat/to crouch/(P)/
しゃきしゃき /(adv,n,vs) crisp/precise/clipped/
しゃきっと /(adv) (1) crisp/crunchy/(2) refreshing/straight/firm/sharp/smart and stylish/
しゃぎり /(n) (1) short flute piece (in kyogen; usu. a lively solo)/(2) flute and drum music played after each act but the last (in kabuki)/
しゃくに障る [しゃくにさわる] /(exp,v5r) to irritate/to grate on one's nerves/to aggravate/to be galling/to be invidious/
しゃくの種 [しゃくのたね] /(n) irritant/cause of irritation/cause of annoyance/
しゃくり上げる [しゃくりあげる] /(v1) to sob convulsively/to heave with sobs/
しゃく熱 [しゃくねつ] /(n,adj-no) red hot/scorching heat/incandescence/
しゃこ /(n) (1) (uk) (abbr) giant clam (any clam of subfamily Tridacnidae)/(2) giant clam shell/
しゃこめし /(n) shako meshi/rice cooked with shrimp/
しゃこ貝 [しゃこがい] /(n) (uk) giant clam (any clam of subfamily Tridacnidae)/
しゃしゃり出る [しゃしゃりでる] /(v1) to come uninvited/to crash (a party)/to butt in/
しゃちほこ張る [しゃちほこばる] /(v5r) (1) to stand on ceremony/(2) to stiffen up (the nerves)/to be tense/
しゃっきり /(adv) crisp/straight (back)/unwavering attitude/brisk/
しゃばい /(adj-i) (1) (sl) dangerous/(2) (sl) unsatisfactory/boring/
しゃぶしゃぶ /(adv,n) (1) shabu-shabu (thinly sliced meat boiled quickly with vegetables, and dipped in sauce)/(2) sound of this dish being prepared/(P)/
しゃぶる /(v5r,vt) to suck/to chew/
しゃり /(n) rice prepared for sushi/
しゃりしゃり /(adv,vs) sound of two hard thin objects rubbing together/
しゃんと /(adv,n,vs) (on-mim) being in shape/holding a dignified appearance/
しゃ断機 [しゃだんぺき] /(n) bulkhead/barrier/
しやすい /(n) easy to make/easy to do/
しゅっしゅっ /(adv-to,adv) (1) (on-mim) choo-choo/chug-chug/chuff-chuff/hiss-hiss/(2) (on-mim) brush-brush/scrub-scrub/
しゅんと /(vs) to feel despondent/
しゅん功 [しゅんこう] /(n,vs) completion (e.g. of construction)/
しゅん工 [しゅんこう] /(n,vs) completion (e.g. of construction)/
しょうがないなぁ /(exp) if you insist (on it)/
しょうがないなあ /(exp) if you insist (on it)/
しょうが茶 [しょうがちゃ] /(n) ginger tea/
しょうが無い [しょうがない] /(ik) (exp,adj-i) (uk) it can't be helped/it is inevitable/nothing can be done/
しょうも無い [しょうもない] /(exp,adj-i) (1) (uk) useless/stupid/good-for-nothing/(2) having no way to do .../
しょう液 [しょうえき] /(n) juice/sap/blood serum/
しょっちゅう /(adv) always/constantly/frequently/often/(P)/
しょぼい /(adj-i) (1) shabby/dull/(2) gloomy/
しょぼくれる /(v1,vi) to be dispirited/to be dejected/to be disheartened/to lose heart/
しょぼしょぼ /(adv,vs) drizzling/weakly (blinking)/blearily/
しょぼん /(adv-to) (on-mim) down-hearted/dejected/
しょんべんをたれる /(exp,v1) to pee/to piss/
しょんぼり /(adv,n,vs) being downhearted/(P)/
しょ難しい [しょむずかしい] /(adj-i) (obsc) terribly difficult/
しようかしまいか /(exp) to do or not to do/
しようとしまいと /(exp) whether one does or does not/
しようとする /(exp,vs-i) to try and do something/to attempt to do something/
しようも無い [しようもない] /(exp,adj-i) (1) (uk) useless/stupid/good-for-nothing/(2) having no way to do .../
しらす漁 [しらすりょう] /(n) fishing for young anchovy, sardines, etc./
しらね型護衛艦 [しらねがたごえいかん] /(n) Shirane class destroyer/
しらばくれる /(v1,vi) to play dumb/to feign ignorance/to act as innocent/
しらばっくれる /(v1,vi) to play dumb/to feign ignorance/to act as innocent/
しらを切る [しらをきる] /(exp,v5r) to feign ignorance/to pretend to be ignorant of/to play innocent/to brazen it out/
しるこ屋 [しるこや] /(n) sweet red-bean soup shop/shiruko shop/
しれっと /(adv-to,vs) nonchalantly/as if nothing happened/
しろ /(n) intestine (yakitori)/
しろと言う [しろという] /(exp,v5u) (uk) to advise strongly/to insist (on something)/
しわを寄せる [しわをよせる] /(exp,v1,vt) to wrinkle up (one's eyebrows, one's nose)/to furrow/to crimple/
しわ寄せ [しわよせ] /(n,vs) foisting upon/shifting to/shifting (the loss) to someone else/
しんこもち /(n) rice flour dough/
しんしん /(adv-to,adj-t) (uk) falling heavily (of rain, snow, etc.)/
しんと /(vs,adv) (on-mim) silent (as the grave)/deadly silent/
しんどい /(adj-i) (1) tired/frazzled/(2) tiresome/worrisome/bothersome/(P)/
しんねり /(adv,n,vs) annoying persistence/
しんみり /(adv,n,vs) solemn/serious/sad/heart-to-heart/
しん酌 [しんしゃく] /(n,vs) consideration (for others)/(making) allowance/
し過ぎる [しすぎる] /(v1) (uk) to overdo/to do too much/(P)/
し慣れる [しなれる] /(v1) to be used to doing/to be experienced in/
し兼ねない [しかねない] /(adj-i) (uk) capable of anything/liable to do/
し兼ねる [しかねる] /(v1) (uk) to be reluctant to do/to hesitate to do/to refuse to do/to be unable to do/
し甲斐 [しがい] /(exp) (col) (uk) worthy of/worth doing/worth having/
し合う [しあう] /(v5u,vt) (uk) to do together/
し始める [しはじめる] /(v1,vt) to begin/to start/
し終える [しおえる] /(v1,vt) to finish/
し吹く [しぶく] /(v5k,vi) to splash/to spray/
し続ける [しつづける] /(v1) to continue to do/to persist in doing/(P)/
し損じる [しそんじる] /(v1,vt) to blunder/to fail/to make a mistake/
し損ずる [しそんずる] /(vz,vt) to blunder/to fail/to make a mistake/
し直す [しなおす] /(v5s) to do over/to remake/to resume/
し難い [しにくい] /(adj-i) (uk) hard to do/
じーっと /(adv,n,vs) (1) (on-mim) (uk) motionlessly/(2) (uk) fixedly (e.g. of staring)/(3) (uk) patiently/(4) (uk) firmly (e.g. hold)/restrained/
じーと /(adv,n,vs) (1) (on-mim) (uk) motionlessly/(2) (uk) fixedly (e.g. of staring)/(3) (uk) patiently/(4) (uk) firmly (e.g. hold)/restrained/
じーんと /(adv) (1) (on-mim) extremely cold feeling that makes one feel numb/sharp pain that is almost numbing/(2) heartrending/touching the heart/
じいじい /(adv) (1) (on-mim) sizzle (sound of meat cooking)/(2) shrill droning of a cicada/
じいんと /(adv) (1) (on-mim) extremely cold feeling that makes one feel numb/sharp pain that is almost numbing/(2) heartrending/touching the heart/
じくじく /(adv,n,vs) (on-mim) oozily/
じたばた /(adv,n,vs) (kick and) struggle/wriggle/
じだんだを踏む [じだんだをふむ] /(exp,v5m) to stamp one's feet (in frustration, impatience, etc.)/
じっくり /(adv,adv-to) (on-mim) deliberately/carefully/(P)/
じっとり /(adv,vs) damp/moist (negative nuance)/
じっと見る [じっとみる] /(exp,v1) to watch steadily/to stare/
じっと見返す [じっとみかえす] /(v5s) to gaze back at/
じとじと /(adv-to,adj-na) damp, soaked, moist to the point of being uncomfortable/
じぶ煮 [じぶに] /(n) duck meat stew (dish from Ishikawa prefecture)/
じまう /(v5u) (col) to do something completely/
じめじめ /(adv,n,vs) (on-mim) damp and humid/sodden/wet/clammy/(P)/
じゃ /(conj,int) (1) then/well/so/well then/(2) combination of 'de' and 'wa' particles/(aux) (3) (ksb:) plain copula/(P)/
じゃーね /(exp) See you then/Bye/Ciao/
じゃあ /(conj,int) (1) then/well/so/well then/(2) combination of 'de' and 'wa' particles/(P)/
じゃあじゃあ /(adv) (water spilling) noisily/
じゃあね /(exp) See you then/Bye/Ciao/
じゃう /(aux-v,v5u) to do something completely/
じゃかすか /(adv,adv-to) with gusto/
じゃが芋 [じゃがいも] /(n) (uk) potato (Solanum tuberosum)/(P)/
じゃじゃ馬 [じゃじゃうま] /(n) (1) (col) restive horse/(2) unmanageable person (esp. a woman)/shrew/stubborn tomboy/
じゃないか /(exp) (1) questioning (something)/(2) let's do (something)/(P)/
じゃね /(exp) See you then/Bye/Ciao/
じゃぱゆき /(n) derog. term for Asian women working in Japan/
じゃぶじゃぶ /(adv) splashing water sound/(P)/
じゃまた /(exp) (abbr) see you later (used in casual correspondence and conversation)/goodbye/sincerely/
じゃまたね /(exp) good-bye/see you later/
じゃらじゃら /(adv,adv-to,vs) (1) jingling/jangling/clinking/chinking/(2) lasciviously/coquettishly/
じゃら付く [じゃらつく] /(v5k,vi) (1) (uk) to jingle/to jangle/to clink/to chink/(2) to act lasciviously/to act coquettishly/
じゃりじゃり /(adj-na,adv,n,vs) crunchy/
じゃりっぱげ /(n) (col) (obsc) bald spot (e.g. on a pet due to injury, stress, etc.)/bald patch/
じゃん /(aux-v) (sl) isn't it/
じゃんじゃか /(adv) (1) noisily (playing a musical instrument)/(2) doing something on and on/
じゃんじゃん /(adv) clanging noise of a bell/something happening non-stop/
じゃん拳 [じゃんけん] /(n,vs) (uk) rock, paper, scissors game/
じゃん拳ぽん [じゃんけんぽん] /(n) (uk) rock, paper, scissors game/
じゃ口 [じゃぐち] /(n) faucet/tap/
じゃ無さそう [じゃなさそう] /(exp,aux) does not seem (to be)/
じゅうじゅう /(adv,adv-to) (1) (on-mim) sizzle (as in meat cooking)/sizzling sound/frizzle/
じゅるり /(n) (m-sl) sound effect for slurping back up excess saliva (e.g. as stimulated by desire for food)/
じゅ文 [じゅもん] /(n) spell/charm/incantation/magic word/
じらす女 [じらすおんな] /(n) cock-teaser (woman who pretends to be "easy")/
じりじり /(adv,n,vs) (on-mim) running out of patience/slowly approaching/scorching sun/sound of alarm bell/
じり安 [じりやす] /(n) gradual decline (of stock prices)/
じり高 [じりだか] /(n) gradual rise in prices/
じり貧 [じりひん] /(n) gradually becoming poor/situation getting gradually worse and worse/
じろじろ /(adv,adv-to) (on-mim) staringly/scrutinizing/scrutinising/
じろじろ見る [じろじろみる] /(exp,v1) to stare at/to look hard at/to look up and down/to scrutinize/to scrutinise/
じろっと /(adv) (on-mim) glancing (look)/
じろり /(adv,adv-to) (on-mim) glancing (look)/
じろりと見る [じろりとみる] /(v1) to throw a glance/
じわっと /(adv) (on-mim) slowly but steadily/
じんじん /(adv,adv-to) (1) tingling sensation (e.g. in a leg)/feeling numb/painful tingle/throbbing/(2) noisily/ears ringing/
じんと /(adv) (1) (on-mim) extremely cold feeling that makes one feel numb/sharp pain that is almost numbing/(2) heartrending/touching the heart/
じんわり /(adv) gradually/
じん帯 [じんたい] /(n,adj-no) ligament/
じん肺 [じんはい] /(n) pneumoconiosis (lung disease caused by dust inhalation)/
じん肺 [じんぱい] /(n) pneumoconiosis (lung disease caused by dust inhalation)/
すーすー /(adv,vs) (on-mim) cool sensation from passing air/sound of air leaking/
すぃません /(exp) (col) sorry/excuse me/
すい /(adv-to) lightly/nimbly/
すいすい /(adv,adv-to) (on-mim) (swim, work) smoothly/unhindered/
すいっ /(adv-to) lightly/nimbly/
すいません /(exp) (col) excuse me/
すい炎 [すいえん] /(n) pancreatitis/
すい星 [すいせい] /(n) comet/
すい賓 [すいひん] /(n) (1) (in China) 7th note of the ancient chromatic scale (approx. G sharp)/(2) fifth lunar month/
すうすう /(adv,vs) (on-mim) sound of wind rustling through a crack/wheezing/
すうっと /(vs,adv) (on-mim) refreshed/relieved/
すう勢 [すうせい] /(n) tendency/trend/
すえ臭い [すえくさい] /(adj-i) (obsc) smelling of rotten food and drink/
すか /(n) (1) nonsense/(2) loss (on scratch lottery tickets, etc.)/
すかす /(v5s) to pose/to be affected/to put on an air/
すかすか /(adj-na) (1) hollow/(adv,adv-to) (2) sharply/cleanly (of cutting)/(3) smoothly/
すかっと /(adv) (1) (on-mim) refreshed/clear/(vs) (2) to feel refreshed/
すかり /(n) (1) net for caught fish/(2) net-like tassel of Buddhist prayer beads/(adv,adv-to) (3) easily/
すがり /(n) (1) net for caught fish/(2) net-like tassel of Buddhist prayer beads/(3) (thb:) Vespula flaviceps (species of yellowjacket)/(4) (kyu:) ant/
すがる /(n) (1) (uk) (arch) red-banded sand wasp (Ammophila sabulosa)/(2) deer/
すきま風 [すきまかぜ] /(n) (1) draft/draught/cold air entering through the crack of a door or window/(2) cooling off of a relationship/draft of cold air between two persons/
すき間 [すきま] /(n) crevice/crack/gap/opening/
すき間市場 [すきましじょう] /(n) niche market/
すき焼 [すきやき] /(n) (food) thin slices of beef, cooked with various vegetables in a table-top cast-iron pan/sukiyaki/(P)/
すき焼き [すきやき] /(n) (food) thin slices of beef, cooked with various vegetables in a table-top cast-iron pan/sukiyaki/(P)/
すき腹 [すきはら] /(n) empty stomach/hunger/
すき腹 [すきばら] /(n) empty stomach/hunger/
すくい上げる [すくいあげる] /(v1,vt) to dip or scoop up/
すくい綴じ [すくいとじ] /(n) (uk) mattress stitch/
すくすく /(adv) (on-mim) quickly/fast/rapidly/
すくすくと /(adv) (on-mim) quickly/fast/rapidly/
すくみ /(n) (comp) deadlock/
すくみ上がる [すくみあがる] /(v5r) to cringe with fear/to cower with fright/to be terribly afraid/
すぐ側 [すぐそば] /(n) (uk) near/immediately/(P)/
すぐ様 [すぐさま] /(adv) (uk) immediately/promptly/
すけこまし /(n) lady-killer/philanderer/
すげい /(adj-i) (sl) (ksb:) incredible/terrific/impressive/
すし詰め [すしづめ] /(n) (food) jam-packed/packed in like sushi (like sardines)/
すじ違い [すじちがい] /(n,vs) (1) cramp/sprain/crick/strain (muscle)/(n) (2) unreasonableness/absurdity/(adj-no,adj-na) (3) illogical/unreasonable/(4) misdirected/misplaced/wrong (of estimate, guess)/
すじ雲 [すじぐも] /(n) (col) cirrus cloud/
すじ肉 [すじにく] /(n) sinewy meat/
すすり泣き [すすりなき] /(n) sobbing/sob/weeping/
すすり泣く [すすりなく] /(v5k,vi) to sob/
すす色 [すすいろ] /(n,adj-no) color of soot (colour)/
すす掃き [すすはき] /(n) sweeping the soot from one's house (to welcome the kami of the New Year)/
すずめの涙 [すずめのなみだ] /(n) drop in the bucket/very small quantity/chicken feed/insignificant amount/
すそ分け [すそわけ] /(n) sharing with others what has been given to you/sharing a portion of the profit with others/
すたこら /(adv) helter-skelter/
すたすた /(adv) (on-mim) briskly/
すっからかん /(adj-na,n) (1) flat out (of)/completely empty/(2) out of money/penniless/broke/
すっかり /(adv,adv-to) all/completely/thoroughly/(P)/
すっきり /(adv,adv-to,vs) (1) (on-mim) clearly/refreshed/(2) shapely/neatly/refinedly/(3) cleanly/without trouble/(4) clearly/plainly/distinctly/(5) completely/thoroughly/(6) not at all (with negative sentence)/not even slightly/(P)/
すっくと /(adv) straight/upright/erect/
すっこむ /(v5m) to draw back/to leave (the area)/
すっすっ /(adv-to,adv) smoothly/frictionlessly/easily/
すってんてん /(adj-na) flat broke/cleaned out/penniless/
すっと /(adv,n,vs) (on-mim) straight/quickly/directly/all of a sudden/quietly/gently/softly/(P)/
すっとこどっこい /(n,adj-na) idiot/fool/idiocy/stupidity/
すっぱ /(adv,adv-to) do something completely/cut cleanly/
すっぱり /(adv,adv-to) do something completely/
すっぱ抜く [すっぱぬく] /(v5k,vt) to expose/to disclose/to unmask/
すっぽかす /(v5s,vt) to stand (someone) up/to leave (something) undone/to neglect (a duty)/
すっぽり /(adv,adv-to) (1) (on-mim) entirely/completely/(2) cleanly/snugly/(P)/
すっぽんぽん /(adj-na,n) utterly stark naked/wearing only one's birthday suit/
すっぽ抜ける [すっぽぬける] /(v1) (1) to slip out (e.g. from one's fingers)/(2) to cleanly forget/
すっ転ぶ [すっころぶ] /(v5b,vi) to (dramatically) fall over/to fall flat/
すっ飛ぶ [すっとぶ] /(v5b,vi) to rush off/to rush away/to vanish/
すててこ /(n) men's underwear/
すとん /(adv-to,adv) (1) (on-mim) (with a) thump/(2) (on-mim) (hanging) straight down/
すね毛 [すねげ] /(n) leg hair/
すばしこい /(adj-i) nimble/smart/quick/
すばしっこい /(adj-i) nimble/smart/quick/
すべからず /(exp) must not do/should not do/do not do/
すべく /(aux-v,conj) doing in order to/doing for the purpose of/
すべし /(exp) should do/ought to do/
すべすべ /(adj-f) smooth/silky/
すべすべした /(adj-f) smooth to the touch/
すべた /(n) (col) bitch/
すべらか /(adj-na) slippery/smooth/
すべりひゆ /(n) (uk) common purslane (Portulaca oleracea)/
すべり出し [すべりだし] /(n) start/beginning/
すべり台 [すべりだい] /(n) (1) (playground) slide/(2) (ship) launching platform/sliding bed/
すまし込む [すましこむ] /(v5m) to put on airs/to affect (importance, etc.)/to look wise/
すまじき /(adj-f) should not be done/must not be done/
すまじきものは宮仕え [すまじきものはみやづかえ] /(exp) phrase indicating that it is better to work for oneself than to work for someone else/
すまらん /(exp) (col) Excuse me (coll. form of sumaranai)/
すまん /(exp) sorry/excuse me/
すみれ色 [すみれいろ] /(n,adj-no) violet (colour)/
すやすや /(adv) (on-mim) sleeping soundly/(P)/
すら /(prt) even/if only/if just/as long as/the only thing needed/
すらすら /(adv,adv-to) (on-mim) smoothly/(P)/
すらっと /(adv,vs) (on-mim) slender/slim/
すらも /(exp) even/if only/if just/as long as/the only thing needed/
すらり /(adv,adv-to) (1) (on-mim) long, slender and well-proportioned/(2) smooth, continuous (movement)/
すり衣 [すりぎぬ] /(n) (arch) plain white clothing patterned using dyes/
すり衣 [すりごろも] /(n) (arch) plain white clothing patterned using dyes/
すり寄る [すりよる] /(v5r,vi) to draw close to/to edge up to/to snuggle up to/to nestle close to/to cuddle with/to draw closer to/
すり減らす [すりへらす] /(v5s,vt) to wear away/to rub down/to abrade/
すり減る [すりへる] /(v5r,vi) to be worn down/to be reduced/
すり合わせ [すりあわせ] /(n) (1) precision surface finishing/lapping/(2) bouncing of ideas (opinions, etc.) off each other to obtain a fine-tuned integrated whole/
すり合わせる [すりあわせる] /(v1) to rub together/
すり込む [すりこむ] /(v5m) to rub in/to grind and mix/
すり込む [すりこむ] /(v5m,vt) to insert (an illustration)/to stencil (a pattern)/to print on/
すり傷 [すりきず] /(n,vs) scratch/graze/abrasion/
すり身 [すりみ] /(n) surimi/minced fish (or meat) mashed into a paste/
すり足 [すりあし] /(n) sliding feet/shuffling (one's feet)/moving legs forward with feet never leaving the ground (sumo exercise)/
すり替える [すりかえる] /(v1,vt) to switch (secretly)/to substitute/to sidestep (an issue)/
すり潰す [すりつぶす] /(v5s,vt) to pulverize/to pulverise/to mash/to deface/to lose a fortune/
すり鉢 [すりばち] /(n) (earthenware) mortar (for grinding)/
すり抜ける [すりぬける] /(v1,vi) to slip through/to make one's way through quickly/
すり付ける [すりつける] /(v1,vt) (1) to rub against/to nuzzle against (e.g. dog nosing a person)/(2) to strike (a match)/
するが良い [するがいい] /(exp) had better .../may as well .../
するが良い [するがよい] /(exp) had better .../may as well .../
するする /(adv) smoothly/swiftly/
するすると /(adv) smoothly/swiftly/
すると /(conj) thereupon/hereupon/(P)/
するべき /(exp) should do/ought to do/
するよろし /(n) had better .../may as well .../
するり /(adv,adv-to) (on-mim) with a smooth, unhindered motion/speedily and without delay/
する事なす事 [することなすこと] /(exp) (uk) everything one does/
すれてない /(adj-i) naive/
すれば /(exp) if so/in that case/in that situation/
すればするほど /(exp) the more you do (it), the... (i.e. "the more you drink, the better it tastes")/
すれ違い [すれちがい] /(n) passing each other/crossing paths without meeting/being at cross purposes/
すれ違う [すれちがう] /(v5u,vi) to pass by one another/to disagree/to miss each other/
すんごい /(adj-i) (col) terrible/dreadful/terrific/amazing/great/wonderful/to a great extent/
すんづくり /(n) kanji sun ("inch") radical at right (radical 41)/
すんでの所で [すんでのところで] /(exp) (uk) almost/very nearly/
すんなり /(adv,n,vs) pass with no objection/slim/slender/
すんません /(exp) (col) excuse me/
すんまへん /(exp) (col) excuse me/
す可き [すべき] /(exp) (uk) should do (abbr. of suru+beki)/ought to do/
す巻 [すまき] /(n) (1) wrapping something in a bamboo mat/(2) wrapping somebody in a bamboo mat and throwing him in a river (Edo period unofficial punishment)/
ずーっと /(adv) (1) continuously in some state (for a long time, distance)/throughout/all along/the whole time/all the way/(2) much (better, etc.)/by far/far and away/(3) far away/long ago/(4) direct/straight/(P)/
ずい /(adv-to) straightforwardly/readily/without hesitation/
ずいっ /(adv-to) straightforwardly/readily/without hesitation/
ずうずう弁 [ずうずうべん] /(n) thick Tohoku accent (wherein some "j" sounds become "z" sounds)/
ずうっと /(adv) (1) continuously in some state (for a long time, distance)/throughout/all along/the whole time/all the way/(2) much (better, etc.)/by far/far and away/(3) far away/long ago/(4) direct/straight/
ずかずか /(adv) (on-mim) making rude entrance/
ずきずき /(adv,n,vs) (on-mim) throbbing pain/heartbreakingly/(P)/
ずきん /(adv-to) (on-mim) throbbing (pain)/pounding/
ずきんずきん /(adv-to) (on-mim) throbbing (pain)/pounding/
ずく /(n) (nab:) putting oneself into something/exerting oneself/
ずくが無い [ずくがない] /(n) (uk) unmotivated/unenthusiastic/
ずく無し [ずくなし] /(n) (uk) bum/slacker/good-for-nothing/loser/
ずけずけ /(adv) (on-mim) bluntly/
ずしずし /(adv,adv-to) (on-mim) thump/thud (sound representing the footfalls of something heavy)/
ずしっ /(adv,adv-to,vs) (on-mim) heavily/profoundly/
ずして /(conj,aux) without doing/not being/
ずしり /(adv,adv-to,vs) (on-mim) heavily/profoundly/
ずっこけ /(n,adj-f) (1) not the norm/(2) foolish/(3) stupid/
ずっこける /(v1) to make a fool of oneself/to whoop it up/to be on the spree/to fall down/
ずっしり /(adv,adv-to,vs) (on-mim) heavily/profoundly/
ずっと /(adv) (1) continuously in some state (for a long time, distance)/throughout/all along/the whole time/all the way/(2) much (better, etc.)/by far/far and away/(3) far away/long ago/(4) direct/straight/(P)/
ずっと前に [ずっとまえに] /(exp) a long time ago/
ずつ /(suf) (1) apiece/each/(2) at a time/piecemeal/(P)/
ずとも /(conj,aux) even without doing/even without being/
ずどん /(n,adv-to) thud/bang/
ずに /(conj,aux) without doing/
ずには居られない [ずにはいられない] /(exp,adj-i) (uk) (after neg. verb stem) feel compelled to/can't help but feel/can't help but do/
ずばずば /(adv) (on-mim) straightforwardly/
ずばずば言う [ずばずばいう] /(exp,v5u) to speak one's mind/to speak very frankly/
ずばっと /(adv) (1) (on-mim) piercing or cutting something/(2) getting to the heart of the matter/
ずばり /(adv) decisively/decidedly/once and for all/unreservedly/frankly/(P)/
ずば抜ける [ずばぬける] /(v1,vi) to tower above the rest/to be by far the best/to be prominent/to be outstanding/to be a cut above/
ずぶ /(adv) (obsc) completely/entirely/totally/
ずぶの /(adj-pn) complete/total/absolute/
ずぶり /(adv,adv-to) (stabbing) through/(plunging) into/
ずぶ焼き入れ [ずぶやきいれ] /(n) immersion quenching (hardening by dropping heated metal into water or oil)/
ずぶ濡れ [ずぶぬれ] /(n) soaked/dripping wet/
ずべら /(adj-na) sloppy/slovenly/slipshod/negligent/loose/unkempt/
ずべら坊 [ずべらぼう] /(n) (1) plain (e.g. face)/smooth/(2) slovenly/
ずぼら /(adj-na) sloppy/slovenly/slipshod/negligent/loose/unkempt/
ずまん /(exp) (col) Excuse me (coll. form of sumimasen)/
ずらかる /(v5r) to leave/to run away/to escape/to avoid detection after having done something/to play truant/to skedaddle/
ずらずら /(adv-to) in succession/in an endless stream/continuing without pause or interruption/
ずらっと /(adv) (on-mim) in a line/in a row/
ずらり /(adv-to) (on-mim) in a row/
ずりせん /(n) (col) (sl) masturbation (male)/
ずり下がる [ずりさがる] /(v5r,vi) to slide down/to slip down/
ずり上がる [ずりあがる] /(v5r,vi) to creep up/to ride up/
ずり落ちる [ずりおちる] /(v1,vi) to slip down/to slide down/to glide down/
ずるずる /(adj-na,adv,n,adv-to) (on-mim) sound or act of dragging/loose/inconclusive but unwanted situation/trailingly/(P)/
ずる休み [ずるやすみ] /(n,vs) playing hookey/being away from work without a good reason/
ずる賢い [ずるがしこい] /(adj-i) sly/
ずれ /(n) gap/slippage/
ずれる /(v1,vi) to slide/to slip off/to get dislocated/to be out of alignment/to get dislodged/to deviate/to shift (position)/to be out of sync./to be slightly off/to be off-point/(P)/
ずれ込む [ずれこむ] /(v5m,vi) to drag on/to be delayed/
ずわい蟹 [ずわいがに] /(n) (uk) snow crab (Chionoecetes opilio)/queen crab/
ずんぐり /(adv,vs) short and stout/small but wide around/
ずんぐりむっくり /(adv,vs) very short and stout/small but quite wide around/
ずんずん /(adv) (on-mim) rapidly/
ずんと /(adv) much/
ずんべら坊 [ずんべらぼう] /(n) (1) plain (e.g. face)/smooth/(2) slovenly/
ずんべら棒 [ずんべらぼう] /(n) (1) plain (e.g. face)/smooth/(2) slovenly/
せいご /(n) (uk) juvenile Japanese sea perch (under two years of age and 25 cm in length)/
せかせか /(adv,n,vs) (on-mim) impetuously/hastily/(P)/
せがむ /(v5m,vt) to badger (pester) (a person to do)/(P)/
せきを切ったよう [せきをきったよう] /(exp,adj-na) gushing forth/bursting out/
せきを切る [せきをきる] /(exp,v5r) to break a dam and gush forth/to burst out/
せき止める [せきとめる] /(v1,vt) (1) to dam up/to hold back/to keep back/to bring to a halt/to intercept/(2) to check/
せき板 [せきいた] /(n) sheeting/sheathing board/cover/
せき立てる [せきたてる] /(v1,vt) to hurry (up)/to press/to urge on/
せこい /(adj-i) petty/small-minded/stingy/cheap (as in cheap shot, cheating, skirting the rules, etc.)/
せざるを得ない [せざるをえない] /(exp,adj-i) cannot avoid doing/cannot help but (do)/is compelled to do/(feel) obliged to (do)/has to do/
せざる得ない [せざるえない] /(exp,adj-i) cannot avoid doing/cannot help but (do)/is compelled to do/(feel) obliged to (do)/has to do/
せしめる /(v1,vt) to cheat someone out of/to wangle/
せず /(prt,suf) without/
せずに /(adv) without (doing)/instead of/(P)/
せせこましい /(adj-i) (1) narrow/limited/(2) fussy/
せせらぎ /(n) (1) small stream/brooklet/(2) murmuring (as of a stream)/
せせらぐ /(v5g) to babble (stream)/
せせら笑い [せせらわらい] /(n) sardonic laugh/scornful smile/
せせら笑う [せせらわらう] /(v5u,vt) (uk) to sneer at/to ridicule/
せせり蝶 [せせりちょう] /(n) (uk) skipper butterfly/
せせり箸 [せせりばし] /(n) poking one's food around using one's chopsticks/playing with one's food with one's chopsticks (a breach of etiquette)/
せせる /(v5r) (uk) to perform a small motion repetitively (i.e. picking or poking something)/
せっかち /(adj-na,n) hasty/impatient/(P)/
せっけん石 [せっけんせき] /(n) soapstone/
せっせと /(adv) (on-mim) diligently/assiduously/(P)/
せっ器 [せっき] /(n) earthenware (baked at high temperature)/stoneware/
せっ生 [せっしょう] /(n,vs) (1) killing/destruction of life/(adj-na) (2) barbarous/callous/brutal/cruel/
せっ生 [せっせい] /(n,vs) hygiene/health maintenance/
せつ /(n) furuncle/
せびる /(v5r,vt) to demand money/to pester/to extort/
せぶる /(v5r) to sleep/to lie down/
せみほうぼう /(n) (uk) Oriental flying gurnard (Dactyloptena orientalis)/
せめぎ合い [せめぎあい] /(n) conflict/fighting each other/
せめて /(adv) at least/at most/(P)/
せめてもの /(adj-pn) minimal/
せよ /(exp) granted that/even if/even though/
せよと言う [せよという] /(exp,v5u) (uk) to advise strongly/to insist (on something)/
せられる /(v1,aux-v) (1) (hon) verb used as an honorific for others' actions/(aux-v,v1) (2) (hon) auxiliary verb used as an extreme honorific for others' actions/
せりばんご /(n) ordinal number/
せり出す [せりだす] /(v5s,vt) (1) to push (a thing) out/to jut out (can have a negative nuance)/to protrude/(2) to rise out the trap door (on stage)/
せる /(aux-v,v1) (1) auxiliary verb indicating the causative/(2) (hum) auxiliary verb indicating that one has been granted the permission to do something/(3) auxiliary verb used to make verbs more "active"/(4) (hon) auxiliary verb used as an extreme honorific for others' actions/
せんさく好き [せんさくずき] /(n) nosy person/busybody/
せんとする /(exp,vs-i) (arch) to attempt to do something/
せん光 [せんこう] /(n) flash/glint/
せん孔機 [せんこうき] /(n) drill/perforator/(hole) puncher/keypunch/
せん孔装置 [せんこうそうち] /(n) (comp) punch/
せん状骨 [せんじょうこつ] /(n) scaphoid bone (in wrist near thumb)/
せん断 [せんだん] /(n,vs) shear/shearing/
せん断強さ [せんだんつよさ] /(n) shear strength/
せん断強度 [せんだんきょうど] /(n) shear strength/
せん断効果 [せんだんこうか] /(n) shear effect/shearing effect/
せん断剛性 [せんだんごうせい] /(n) shear modulus/
せん断弾性係数 [せんだんだんせいけいすう] /(n) elastic shear modulus/
せん断抵抗角 [せんだんていこうかく] /(n) angle of shearing resistance/
せん断破壊 [せんだんはかい] /(n) shear failure/
せん断箱 [せんだんばこ] /(n) shear box/
せん頭 [せんとう] /(n,adj-no) point/pointed end/cusp/
せん馬 [せんば] /(n) gelding/castrated horse/
ぜ /(prt) (male) (sentence end) adds force/indicates command/(P)/
ぜいぜい /(adv,adv-to,vs) (on-mim) gasping for breath/puffing and panting/wheezing/
ぜえ /(prt) (arch) (at sentence-end) indicates mild emphasis/
ぜえぜえ /(adv,adv-to,vs) (on-mim) gasping for breath/puffing and panting/wheezing/
ぜにたなご /(n) (uk) Acheilognathus typus (species of bitterling-like cyprinid)/
ぜんまい仕掛け [ぜんまいじかけ] /(n,adj-no) clockwork (motor, etc.)/spring action/
ぜん音 [ぜんおん] /(n) (1) stridor/(adj-no) (2) stridulous/
そーっと /(adv,vs) (on-mim) softly/gently/quietly/secretly/
そーれっ /(int) oof/umph/whoosh/
そう /(adv) (1) so/really/seeming/(adj-na,suf) (2) (after masu stem and adj-stem) appearing that/seeming that/looking like/having the appearance of/(P)/
そういうことか /(exp) I got it/I see/I now know/So that's the reason/
そううつ病 [そううつびょう] /(n,adj-no) manic depression/manic-depressive psychosis/bipolar disorder/
そううつ病 [そううつやまい] /(n,adj-no) manic depression/manic-depressive psychosis/bipolar disorder/
そうか /(exp) is that so? (generally rhetorical)/(P)/
そうかと言って [そうかといって] /(conj) but still/
そうかもしれない /(exp) you could say that/
そうかもしれません /(exp) you could say that/
そうさ /(int) yes, that's right/yep/sure thing/
そうした中で [そうしたなかで] /(exp) meanwhile/
そうして見ると [そうしてみると] /(exp) when looked at in that way/
そうする /(exp,vs-i) to do so/to do thus/
そうすると /(exp) having done that/if that is done/if it is done in that way/(P)/
そうすれば /(exp) if so/in that case/in that situation/(P)/
そうだ /(int) (1) that is so/that is right/it looks to me/I am of the impression/(2) people say that (after plain verb, adj)/it is said that/I hear that/(P)/
そうっと /(adv,vs) (on-mim) softly/gently/quietly/secretly/
そうです /(int) (1) that is so/that is right/it looks to me/I am of the impression/(2) people say that (after plain verb, adj)/it is said that/I hear that/(P)/
そうですが /(exp) that's so, however ..../(P)/
そうですね /(exp) that's so, isn't it/(P)/
そうでない /(exp) not so/
そうでない場合は [そうでないばあいは] /(exp) if this is not the case/
そうとも言える [そうともいえる] /(exp,v1) you could say that/
そうなると /(exp) if that is the case/if it becomes so/when it becomes so/(P)/
そうなんです /(int) (col) yes/that is so/
そうなんですか /(exp) is that so?/
そうなんですけどねぇ /(exp) that may be so/
そうにない /(exp) (after masu-stem of verb) showing no signs of (verb)/extremely unlikely to (verb)/
そうになった /(exp) almost (did)/nearly (did)/
そうね /(exp) Oh well/
そうは問屋がおろさない [そうはとんやがおろさない] /(exp) things don't work that well in the real world/things seldom go as one wishes/that is expecting too much/
そうは問屋が卸さない [そうはとんやがおろさない] /(exp) things don't work that well in the real world/things seldom go as one wishes/that is expecting too much/
そうみたい /(exp) (col) it seems so/that's what it looks like/
そうもありません /(exp) (after -masu base of verb) very unlikely to (verb)/
そうもない /(exp) (after -masu base of verb) very unlikely to (verb)/
そう言う [そういう] /(adj-pn) such/like that/that sort of/very/
そう言う [そうゆう] /(ok) (adj-pn) such/like that/that sort of/very/
そう言えば [そういえば] /(exp) (uk) which reminds me .../come to think of it .../now that you mention it .../on that subject .../so, if you say .../(P)/
そう言った [そういった] /(exp) (uk) like that/this type/
そう身 [そうしん] /(n) slim figure/weight reduction/
そう身 [そうみ] /(n) one's whole body/
そう氷 [そうひょう] /(n) pack ice/
そう来なくっちゃ [そうこなくっちゃ] /(exp) (col) I thought so/I suspected as much/Just as I thought/Now you are talking/
そう囃 [そうざつ] /(n,vs) (obsc) heartburn/sour stomach/
そう痒 [そうよう] /(n) (1) itch/pruritus/(adj-na) (2) amyctic/pruritic/itchy/irritating/
そおっと /(adv,vs) (on-mim) softly/gently/quietly/secretly/
そぎ切り [そぎぎり] /(n,vs) cutting a thin object (e.g. vegetable stalk) at a 45 degree angle/cutting in a way that blunts or rounds the cut/
そぎ落とす [そぎおとす] /(v5s) to chip off/to scrape off/to prune/
そぐう /(v5u,vi) to be suitable/to be appropriate/to match/
そぐわない /(adj-i) unsuitable/not matching/out of character/
そこから /(adv) from there/thence/
そこそこ /(adv) (1) (on-mim) reasonably/fairly well/(suf) (2) or so/about/
そこそこに /(adv) hurriedly/in a hurry/
そこはかとない /(adj-i) faint/slight/vague/nebulous/indeterminate/tinge of .../touch of .../
そこはかとなく /(adv) somehow/for some reason/
そこへ持ってきて [そこへもってきて] /(exp) what is worse/to make matters worse/
そこまで /(exp) go that far/to that extent/
そこら中 [そこらじゅう] /(n) everywhere/all over the place/
そこら辺 [そこらへん] /(n-adv) (uk) (col) hereabouts/around there/that area/(P)/
そこんち /(exp) (col) that house/
そしたら /(exp) then/(P)/
そそくさ /(adv-to) (on-mim) hurriedly/in haste/
そそける /(v1) to be nappy/to get fluffy/
そそけ立つ [そそけだつ] /(v5t,vi) (1) to be nappy/to be disheveled (hair)/(2) to shudder/
そそっかしい /(adj-i) careless/thoughtless/(P)/
そそられる /(v1,vt) to be interesting/to be fascinating/to be tantalizing/to be intriguing/(P)/
そぞろ歩き [そぞろあるき] /(n,vs) slow, relaxed walk/stroll/
そちら様 [そちらさま] /(pn,adj-no) (hon) you/
そち退け [そちのけ] /(n) (uk) ignoring (one thing) for (another)/
そっか /(exp) is that so? (generally rhetorical)/
そっから /(adv) from there/thence/
そっくり /(adj-na,adv,n) (on-mim) all/altogether/entirely/just like/the spitting image of/(P)/
そっくり返る [そっくりかえる] /(v5r,vi) to throw one's chest out/to hold one's head high/
そっち退け [そっちのけ] /(n) (uk) ignoring (one thing) for (another)/
そっと /(adv,vs) (on-mim) softly/gently/quietly/secretly/(P)/
そっぽを向く [そっぽをむく] /(v5k,exp) to turn away/to face away/
そつ /(n) (1) slip-up/miss/(2) waste/wasteful or pointless action/
そない /(adv) (ksb:) so/to such an extent/such/
そに鳥 [そにどり] /(n) (arch) kingfisher/
そのこと自体は [そのことじたいは] /(exp) as such ..../
そのよう /(adj-na) that kind of/of the sort/of the kind/such/
そのケ /(exp) (col) euph. for (male or female) homosexuality/interest in same gender/
その為 [そのため] /(exp) hence/for that reason/
その下で [そのしたで] /(adv) thereunder/whereunder/
その下に [そのしたに] /(adv) whereunder/thereunder/
その外 [そのた] /(n-adv,conj) etc./otherwise/besides/in addition/the rest/the others/and so forth/
その外 [そのほか] /(n-adv,conj) etc./otherwise/besides/in addition/the rest/the others/and so forth/(P)/
その割には [そのわりには] /(exp) unexpectedly/unusually/considering all that/
その割りには [そのわりには] /(exp) unexpectedly/unusually/considering all that/
その気 [そのき] /(n) what one has a mind to do/what one feels like (doing)/being so minded/(with) that in mind/
その気 [そのけ] /(exp) (col) euph. for (male or female) homosexuality/interest in same gender/
その気になる [そのきになる] /(exp,v5r) to feel like it/to get to think that way/to become so minded/
その儀 [そのぎ] /(exp) that matter/those matters/
その筋 [そのすじ] /(n) (1) that field/(2) the authorities (esp. the police)/
その後 [そのあと] /(n-adv,n-t) after that/afterwards/thereafter/
その後 [そのご] /(n-adv,n-t) after that/afterwards/thereafter/
その後 [そののち] /(n-adv,n-t) after that/afterwards/thereafter/
その頃 [そのころ] /(n,adj-no) (uk) at that time/in those days/at that moment/then/
その時 [そのとき] /(exp) at that time/at that moment/then/on that occasion/
その時以来 [そのときいらい] /(adv) since that time/since then/from that point (on)/
その実 [そのじつ] /(adv) in fact/
その手は食わない [そのてはくわない] /(exp) I am not going to fall for that trick/
その上 [そのうえ] /(conj) (1) in addition/furthermore/(2) above (which)/on top of (which)/(P)/
その上で [そのうえで] /(exp) moreover/in addition/
その場 [そのば] /(n) (1) there/that situation/that occasion/(2) the spot (i.e. "on the spot")/immediately/then and there/
その場しのぎ [そのばしのぎ] /(n,adj-no) stopgap/makeshift/temporary measure/
その場限り [そのばかぎり] /(n) temporary/ad hoc/
その場合には [そのばあいには] /(n) in that case/
その場逃れ [そのばのがれ] /(n) makeshift/stopgap/
その場凌ぎ [そのばしのぎ] /(n,adj-no) stopgap/makeshift/temporary measure/
その昔 [そのむかし] /(exp) a long time ago/in those days/
その折り [そのおり] /(n-t,n-adv) on that occasion/at that time/
その節 [そのせつ] /(n-adv) at that time/that time/
その先 [そのさき] /(exp) beyond that point/after that/
その他 [そのた] /(n-adv,conj) etc./otherwise/besides/in addition/the rest/the others/and so forth/
その他 [そのほか] /(n-adv,conj) etc./otherwise/besides/in addition/the rest/the others/and so forth/(P)/
その他にも [そのほかにも] /(exp) in addition/furthermore/also/
その代り [そのかわり] /(conj) instead/but (on the other hand)/
その代わり [そのかわり] /(conj) instead/but (on the other hand)/
その通り [そのとおり] /(exp) just like that/quite so/I agree/
その都度 [そのつど] /(n) each time it happens/at all such times/
その道 [そのみち] /(exp) line (of business)/profession/trade/
その内 [そのうち] /(adv) (uk) eventually/sooner or later/of the previously mentioned/(P)/
その内に [そのうちに] /(exp,adv) (uk) one of these days/sooner or later/eventually/(P)/
その日 [そのひ] /(exp) that day/the very same day/
その日その日 [そのひそのひ] /(exp) each day/from day to day/day-to-day/
その日暮し [そのひぐらし] /(n) (1) financially scraping by/meagre existence (meager)/hand to mouth existence/(2) living one's life without plan/living life day-by-day/taking life one day at a time/
その日暮らし [そのひぐらし] /(n) (1) financially scraping by/meagre existence (meager)/hand to mouth existence/(2) living one's life without plan/living life day-by-day/taking life one day at a time/
その反面 [そのはんめん] /(n) on the other hand/
その物 [そのもの] /(n) the very thing/itself/(P)/
その分 [そのぶん] /(exp) (1) to that extent/(2) that state/that look/
その癖 [そのくせ] /(conj) (uk) and yet/even so/nonetheless/for all that/
その辺 [そのへん] /(n,adj-no) (1) around there/near there/(2) or thereabouts/or so/(3) such a matter/such a thing/
その辺り [そのあたり] /(exp) thereabouts/vicinity/that area/
その方 [そのかた] /(pn,adj-no) (hon) that person/
その方 [そのほう] /(pn,adj-no) (arch) you (referring to one's inferior)/
そば殻 [そばがら] /(n) buckwheat chaff/
そば杖 [そばづえ] /(n) blow received by a bystander/getting dragged in to somebody else's fight/
そば切 [そばきり] /(n) soba/Japanese buckwheat noodles/
そば切り [そばきり] /(n) soba/Japanese buckwheat noodles/
そば湯 [そばゆ] /(n) water left in the pot after one has boiled soba/
そば粉 [そばこ] /(n) buckwheat flour/
そびえ立つ [そびえたつ] /(v5t) to stand towering over the surrounds/
そびれる /(v1,vi) to miss a chance/to fail to do/
そぼそぼ /(adv) drizzling (rain)/
そぼろ /(n) minced meat or fish with soy sauce, etc. (served on rice)/
そぼ降る [そぼふる] /(v5r) to drizzle (rain)/
そやす /(v5s,vt) (arch) to praise/to extol/
そよ /(adv-to) with a slight (breeze)/
そよそよ /(adv) (on-mim) breeze (sound representing a soft wind)/
そよ風 [そよかぜ] /(n) gentle breeze/soft wind/breath of air/zephyr/(P)/
そら /(conj,exp) look!/look out!/look at me!/
そらそら /(int) sparklingly/
そらで歌う [そらでうたう] /(exp,v5u) to sing from memory/
そらで覚える [そらでおぼえる] /(exp,v1) to learn by heart (rote)/to memorize/to memorise/
そらで言う [そらでいう] /(exp,v5u) to speak from memory/
そらで読む [そらでよむ] /(exp,v5m) recite from memory/
そら耳 [そらみみ] /(n) (1) mishearing/(2) (feigned) deafness/
そら豆 [そらまめ] /(n) broad bean/horse bean/fava bean/
そりが合わない [そりがあわない] /(exp,adj-i) unable to cooperate/unable to hit it off/
そりゃ /(adv) (1) very/extremely/(exp) (2) that is/
そり上げる [そりあげる] /(v1) to shave off/
そり跡 [そりあと] /(n) stubble (after shaving)/
それ /(int) there! (used to call someone's attention to something)/
それからというもの /(exp) after that (a substantive change occurred)/
それこそ /(exp) degree or extent (of effect or result)/
それご覧 [それごらん] /(exp) (obsc) Well, look at that... (used when someone ignores your advice and ultimately fails at something)/
それすら /(n) even that/
それだから /(exp) therefore/and so/for that reason/accordingly/consequently/hence/
それっぽい /(exp) like that/looks real/seems authentic/(P)/
それっ切り [それっきり] /(n,adv) (1) (uk) no more than that/with that/on that note/altogether/(2) since then/ending there/
それでいて /(conj) and yet/despite (all) that/(P)/
それとて /(conj) even so/even that/
それと無く [それとなく] /(adv) (uk) indirectly/obliquely/
それなのに /(conj) and yet/despite this/but even so/but even then/however/nevertheless/for all that/notwithstanding that/
それならそうと /(exp) even so (expressing frustration, etc.)/still/
それならそれで /(exp) even so (expressing frustration, etc.)/still/
それにしても /(exp) nevertheless/at any rate/even so/(P)/
それにも拘わらず [それにもかかわらず] /(conj) (uk) nonetheless/nevertheless/
それに加えて [それにくわえて] /(exp) in addition to this/
それは /(adv) (1) very/extremely/(exp) (2) that is/
それはさておき /(exp) apart from that/to return to the topic/enough of that/(P)/
それはそうかもしれない /(exp) that may be true/that might be the case/
それはそうかもしれません /(exp) (pol) that may be true/that might be the case/
それはそれで /(exp) in that case/(might not be what was expected or hoped for but) if that's the case/
それはそれは /(exp,int) (1) My goodness (expresses surprise, wonder, etc.)/(adv) (2) very/extremely/
それはどうかな /(exp) I wonder about that/don't bet on it/famous last words/
それはどうも /(exp) why yes, thank you/
それも /(conj) and in addition to that/
それもこれも /(n) all/everything/
それより /(conj) apart from that/other than that/leaving that aside/more ... than that/but/however/(P)/
それ以外のものは [それいがいのものは] /(exp) aside from this/aside from these/
それ以上 [それいじょう] /(exp) further/above/anymore/
それ以来 [それいらい] /(n) since then/from that time/ever since/
それ計り [そればかり] /(n-t) (uk) that much/as much/to that extent/only that/that alone/no more than that/
それ見たことか [それみたことか] /(exp) You see that? (used when someone ignores your advice and ultimately fails at something)/
それ見た事か [それみたことか] /(exp) (id) I told you so/
それ見ろ [それみろ] /(exp) Well, look at that... (used when someone ignores your advice and ultimately fails at something)/
それ故 [それゆえ] /(conj) therefore/for that reason/so/
それ故に [それゆえに] /(adv) and so .../
それ御覧 [それごらん] /(exp) (obsc) Well, look at that... (used when someone ignores your advice and ultimately fails at something)/
それ自身 [それじしん] /(pn) itself/himself/herself/
それ自体 [それじたい] /(n) in itself/the thing itself/this itself/for its own sake/per se/
それ処か [それどころか] /(exp) (uk) on the contrary/
それ切り [それきり] /(n,adv) (uk) with that/on that note/altogether/ending at that point/cut off there/
それ切り [それぎり] /(n,adv) (uk) with that/on that note/altogether/ending at that point/cut off there/
それ相応 [それそうおう] /(adj-no,adj-na,n) appropriate/suitable/proper/fitting/
それ程 [それほど] /(adv) (uk) to that degree/extent/
それ迄 [それまで] /(exp,n-t) (uk) That's the end of the matter/That's it/Until then/
それ来た [それきた] /(exp) there it is/there it comes/got it/expression one says when what is expected comes/
そろそろ /(adv,adv-to) (1) slowly/quietly/steadily/gradually/gingerly/(adv) (2) soon/momentarily/before long/any time now/(P)/
そろっと /(adv) (1) soon/momentarily/before long/any time now/
そろり /(adv-to,adv) (1) slowly and quietly/(2) smoothly/
そわそわ /(adv,n,vs) (on-mim) fidgety/restless/nervous/uneasy/(P)/
そんじょそこら /(exp) anywhere/here and there/
そんだけ /(n,adv) only that/that's all (used in casual speech)/(P)/
そんで /(conj) (col) and/thereupon/because of that/
そんでもって /(conj) (col) and (so)/because of which/(P)/
そんな /(adj-pn) such (about the actions of the listener, or about ideas expressed or understood by the listener)/like that/that sort of/(P)/
そんなこんな /(exp) this and that/various things/(P)/
そんなに /(exp) so much/so/like that/(P)/
そんな具合に [そんなぐあいに] /(exp) in that manner/
そんな風に [そんなふうに] /(exp) (uk) in that manner/like that/
そ求 [そきゅう] /(n) redemption/recourse/
そ求権 [そきゅうけん] /(n) right of recourse/right for redemption/
そ知らぬ顔 [そしらぬかお] /(n) pretending not to recognize (recognise)/feigned ignorance/
そ嚢 [そのう] /(n) bird's crop/bird's craw/
ぞ /(prt) (male) (sentence end) adds force/indicates command/(P)/
ぞい /(prt) (arch) (at sentence-end) indicates mild emphasis/
ぞえ /(prt) (arch) (at sentence-end) indicates mild emphasis/
ぞくぞく /(adv,n,vs) (on-mim) shiver/feel chilly/shudder/thrill/(P)/
ぞくっと /(adv) tremblingly/having the chills (through fear, cold, anticipation, etc.)/
ぞっこん /(adv) (1) from the bottom of one's heart/with all one's heart/(2) completely/entirely/
ぞっと /(adv,n,vs) (on-mim) shiver/shudder/
ぞっとしない /(exp) not very appealing/pretty disgusting/
ぞろぞろ /(adv,n) (on-mim) in groups/in succession/(P)/
ぞろっぺい /(adj-na) slovenly/
ぞろり /(adv,adv-to) (1) (arch) (on-mim) all together in a line/all together in a lump/(2) dressed sloppily/overdressed for the occasion/
ぞろ目 [ぞろめ] /(n) (1) matching dice/doublets/(2) bet on two horses in the same bracket/
ぞろ薬 [ぞろやく] /(n) (col) generic drug/
ぞんざい /(adj-na,n) rude/careless/slovenly/(P)/
たい /(aux-adj) (1) (after the -masu stem of a verb) want to ... do something/would like to .../(prt) (2) (kyu:) (at sentence-end) indicates emphasis/(suf,adj-i) (3) (after a noun or the -masu stem of a verb) very .../(P)/
たいらぎ /(n) fan mussel (species of pen shell, Atrina pectinata)/
たいりくももんが /(n) (uk) Siberian flying squirrel (Pteromys volans)/
たい肥 [たいひ] /(n) compost/
たかなみ型護衛艦 [たかなみがたごえいかん] /(n) Takanami class destroyer/
たかべ /(n) (uk) Labracoglossa argentiventris (species of knifefish)/
たかり /(n) extortion/sponging/
たがる /(aux-v,v5r) wanting to (verb) (not used in the first person, combination of ~tai and ~garu)/
たき火 [たきび] /(n,vs) (1) open-air fire (e.g. for garden refuse)/bonfire/(2) open fire (e.g. in a kitchen)/
たき木 [たきぎ] /(n) (1) firewood/kindling/fuel/(2) piece(s) of firewood/
たくし上げる [たくしあげる] /(v1) to roll up or pull up (sleeves, skirt, etc.)/
たくる /(v5r) to pull in/to take for oneself/to tuck up (one's sleeves)/
たけり /(n) ox or whale penis, used as a tonic or aphrodisiac/
たけり狂う [たけりくるう] /(v5u) to rage/to rampage/
たけり立つ [たけりたつ] /(v5t,vi) (1) to rage/(2) to howl/
たこつぼ型心筋症 [たこつぼがたしんきんしょう] /(n) takotsubo cardiomyopathy/
たこつぼ心筋症 [たこつぼしんきんしょう] /(n) takotsubo cardiomyopathy/
たこ焼き [たこやき] /(n) octopus dumplings/
たこ焼き器 [たこやきき] /(n) tako-yaki pan (cast iron with semi-spherical molds)/
たこ焼き鍋 [たこやきなべ] /(n) (obsc) tako-yaki pan (cast iron with semi-spherical molds)/
たこ足 [たこあし] /(adj-f,n) many-legged/octopus-like/
たじたじ /(adv,n) (on-mim) overwhelmed/recoiling/cringing/
たじろぐ /(v5g,vi) to falter/to wince/
たすき掛け [たすきがけ] /(n,vs) tucking up the sleeves of a kimono with a tasuki/
たたき壊す [たたきこわす] /(v5s) to tear down/to shatter/
たたき起こす [たたきおこす] /(v5s,vt) to wake up/to rouse out of bed/
たたき込む [たたきこむ] /(v5m,vt) to drive into/to throw into/to hit into/
たたき出す [たたきだす] /(v5s,vt) to begin to strike/to kick out/
たたき上げ [たたきあげ] /(n) (1) working one's way up/(n,adj-no) (2) self-made person/veteran/
たたき切る [たたききる] /(v5r) to mangle/to hack down/to chop down/
たたき台 [たたきだい] /(n,adj-no) chopping block/springboard for discussion/
たたらを踏む [たたらをふむ] /(exp,v5m) to stumble a step or two forward (when trying to stop)/to pass one's destination and stumble a step or two forward/to totter/
たたら星 [たたらぼし] /(n) Chinese "Bond" constellation (one of the 28 mansions)/
ただいま帰りました [ただいまかえりました] /(exp,int) Here I am/I'm home!/
ただごと歌 [ただごとうた] /(n) plain form (of waka)/
ただし書 [ただしがき] /(n) proviso/
ただし書き [ただしがき] /(n) proviso/
ただじゃおかないぞ /(exp) You'll pay for this!/You'd better keep your mouth shut!/
ただでは /(exp) This isn't over/I will get my revenge/
ただではおかないぞ /(exp) You'll pay for this!/You'd better keep your mouth shut!/
ただより高いものはない [ただよりたかいものはない] /(exp) (id) Nothing costs as much as what is given to us/
ただ今 [ただいま] /(int,exp) (1) (uk) (abbr) Here I am/I'm home!/(n-t,adv) (2) presently/right away/right now/just now/(P)/
ただ今帰りました [ただいまかえりました] /(exp,int) Here I am/I'm home!/
ただ事 [ただごと] /(n) trivial matter/
ただ者 [ただもの] /(n) ordinary person (usu. in neg. sentences)/
ただ中 [ただなか] /(n) middle/
たちかぜ型護衛艦 [たちかぜがたごえいかん] /(n) Tachikaze class destroyer/
たちが悪い [たちがわるい] /(exp,adj-i) nasty/vicious/wicked/poor (quality)/
たちが良い [たちがいい] /(exp,adj-i) (uk) good (quality)/
たちが良い [たちがよい] /(exp,adj-i) (uk) good (quality)/
たちの悪い [たちのわるい] /(adj-i) nasty/poor (quality)/
たちの良い [たちのいい] /(exp) good (quality)/
たちの良い [たちのよい] /(exp) good (quality)/
たった /(adj-f,adv) only/merely/but/no more than/(P)/
たった１人 [たったひとり] /(n) just one person/only one/
たった一人 [たったひとり] /(n) just one person/only one/
たった今 [たったいま] /(adv) just now/a moment ago/this very minute/
たって /(conj,prt) (1) but/however/still/yet/although/even though/(suf) (2) even/even if/(3) or something/
たっぷり /(adj-na,adv,n) (on-mim) full/in plenty/ample/(P)/
たっ観 [たっかん] /(n,vs) farsightedness/taking a philosophic view (ripeness)/
たっ成 [たっせい] /(n,vs) achievement/
たてうね織 [たてうねおり] /(n) warp rib weave (cloth)/
たてびき鋸 [たてびきのこ] /(n) ripsaw/
たて琴 [たてごと] /(n) harp/lyre/
たて穴 [たてあな] /(n) pit/shaft/
たて糸 [たていと] /(n) (weaving) warp/
たて続け [たてつづけ] /(n) succession/
たとえ歌 [たとえうた] /(n) (1) metaphorical poem (of the Man'yoshu)/(2) metaphorical form (of waka)/
たとえ話 [たとえばなし] /(n) allegory/fable/parable/
たどり着く [たどりつく] /(v5k,vi) to struggle on to/to arrive somewhere after a struggle/to grope along to/to barely manage to reach/to finally arrive at/to finally hit on (e.g. an idea)/(P)/
たなご /(n) (uk) bitterling (any fish of subfamily Acheilognathinae, esp. species Acheilognathus melanogaster)/
たな引く [たなびく] /(v5k) (uk) to linger/to hover above/to trail/to hang over/to lie over/
たぬき寝入り [たぬきねいり] /(n,vs) feigning sleep/
たね違い [たねちがい] /(n) half-brother/half-sister/
たの /(exp) (usu. sentence end) indicates emotion, admiration, emphasis, etc./
たのもし講 [たのもしこう] /(n) mutual financing association/
たばこ税 [たばこぜい] /(n) tobacco tax/cigarette tax/
たび心 [たびごころ] /(n) desire to travel/
たび人 [たびびと] /(n) traveller/traveler/wayfarer/tourist/
たぶたぶ /(adv-to) (1) (on-mim) brimming/full to the point of overflowing/(2) loose/baggy/
たぷたぷ /(adj-no) (on-mim) flabby/
たほいや /(n) Fictionary game/dictionary game/
たまご酒 [たまござけ] /(n) eggnog/
たまご焼き [たまごやき] /(n) fried eggs/omelet/omelette/
たまご色 [たまごいろ] /(n) yellowish colour (color)/
たまさか鳥 [たまさかどり] /(n) (obsc) lesser cuckoo (Cuculus poliocephalus)/
たまて箱 [たまてばこ] /(n) (1) treasure chest (in the story of Urashima Taro)/Urashima's casket/Pandora's box/(2) important secret that is not easily revealed to others/
たまり醤油 [たまりじょうゆ] /(n) tamari soy sauce/variety of rich soy sauce (used for sashimi, etc.)/
たまり場 [たまりば] /(n) gathering spot/haunt/rendezvous/meeting place/hang-out/
たまり水 [たまりみず] /(n) stagnant water/
たま蝿 [たまばえ] /(n) (uk) gall midge (any insect of family Cecidomyiidae)/
たま蜂 [たまばち] /(n) (uk) gall wasp (any insect of family Cynipidae)/
たま蠅 [たまばえ] /(n) (uk) gall midge (any insect of family Cecidomyiidae)/
ため /(n) (col) the same/
ため桶 [ためおけ] /(n) (1) bucket (for carrying sake, soy sauce, etc.)/(2) manure bucket/(3) rainwater bucket (for dousing fires)/
ため口 [ためぐち] /(n) casual talk/frank, unreserved speech/peer language/
ため込む [ためこむ] /(v5m,vt) to save up/to stockpile/to stash away/to hoard/to amass/to salt away/
ため息 [ためいき] /(n) sigh/(P)/
ため息をつく [ためいきをつく] /(exp,v5k) to sigh/to breathe a sigh/
ため息を吐く [ためいきをつく] /(exp,v5k) to sigh/to breathe a sigh/
ため池 [ためいけ] /(n) reservoir/pond/
ため年 [ためどし] /(n) (sl) same age/
たも /(n) (abbr) fishing net (hand held, hoop with net on a bamboo stick)/
たも /(n) Japanese ash (Fraxinus mandshurica var. japonica)/
たも網 [たもあみ] /(n) fishing net (hand held, hoop with net on a bamboo stick)/
たゆまず努力 [たゆまずどりょく] /(n,vs) untiring labor (labour)/
たゆまぬ努力 [たゆまぬどりょく] /(exp) diligence/unceasing efforts/
たら /(conj,prt) (1) indicates supposition/if ... then/when/after/(prt) (2) (typically after someone's name) indicates exasperation/(P)/
たらい回し [たらいまわし] /(n,vs) (1) acrobatic barrel-rolling (performed using the feet while lying on the back)/(2) handing something around (within a fixed group of people in a pre-arranged order)/(3) handing off a problem to someone else (in order to evade responsibility)/
たらしい /(suf,adj-i) (after a noun or the stem of an adjective) seeming very... (usu. with a negative connotation)/
たらしめる /(v1) (arch) to make/to make something what it should be/to cause to be/
たらし込む [たらしこむ] /(v5m,vt) to cajole/to deceive/to seduce/
たらたら /(adv) (1) (on-mim) drop-by-drop/dribbling/in a trickle/(2) incessantly/in great profusion/(P)/
たらの木 [たらのき] /(n) (uk) devil's walking stick (tree) (Aralia elata)/Japanese angelica tree/
たらば蟹 [たらばがに] /(n) (uk) red king crab (Paralithodes camtschaticus)/
たらんと /(n,vs) tending to be/wanting to be/
たら子 [たらこ] /(n) cod roe (roe of any fish from family Gadidae, esp. salted walleye pollack roe)/
たり /(prt) (1) -ing and -ing (e.g. "coming and going")/(2) (used adverbially) doing such things as.../(3) expresses a command/(aux-v) (4) (arch) (after a noun) to be/(5) (arch) indicates completion or continuation of an action/(P)/
たりけり /(exp,aux-v) (arch) auxiliary verb indicating past condition or occurrence (e.g. "was", "had been", etc.)/
たりとも /(exp) (not) even/(not) any/
たる /(aux-v) (those) who are/(that) which is/often used in relation to qualifications and requirements for a position/in the capacity of/
たるたる /(adj-no) (col) droopy (e.g. of skin)/drooping/
たるや /(exp,adv) (after a noun) speaking of... (used to introduce a topic emphatically)/
たる木 [たるき] /(n) rafter/
たれ込む [たれこむ] /(v5m) to inform on someone/to squeal (to the police)/
たれ込める [たれこめる] /(v1,vi) (1) (uk) to hang low over (e.g. clouds)/(2) (arch) to seclude oneself (behind screens, curtain, etc.)/
たれ壁 [たれかべ] /(n) hanging partition wall (e.g. against smoke)/
たろう /(aux) (1) ought to have been/was ... right?/(2) (ksb:) to do for (inferiors)/
たわい無い [たわいない] /(adj-i) (uk) silly/foolish/absurd/childish/easy/trifling/guileless/
たわけ者 [たわけもの] /(n) idiot/dummy/joker/fool/trickster/
たわみ計 [たわみけい] /(n) deflectometer/
たわ言 [たわこと] /(ok) (n) nonsense/bullshit/silly things/joke/
たわ言 [たわごと] /(n) nonsense/bullshit/silly things/joke/
たん /(suf) (m-sl) (fam) (fem) (cute) suffix for familiar person/
たんこぶ /(n) bump/lump/protuberance/swelling/
たんと /(adv) (1) (on-mim) (poss. Kansai dialect) many/much/a great amount/(2) excessive amount/
たんぱく質 [たんぱくしつ] /(n) protein/
たんび /(n,n-suf,ctr) time (three times, each time, etc.)/times/
たんぽ /(n) pad/wad/wadding/
たんぽ槍 [たんぽやり] /(n) padded spear (for practice)/
たんま /(n) (children's language) to interrupt a game/time out/
たんまり /(adv) quite a lot/
だ /(aux) plain copula/(P)/
だい /(prt) (1) (fam) marks wh-question (what, where, who)/(2) (chn) strengthens one's judgment or conclusion/(P)/
だいだい色 [だいだいいろ] /(n) orange-colored/orange-coloured/
だから /(conj,n) so/therefore/(P)/
だからこそ /(exp) for this reason/
だからって /(exp) even so/all the same/nevertheless/yes, but .../
だからと言って [だからといって] /(conj) while it may be true that/just because/nevertheless/not necessarily/
だから何だ [だからなんだ] /(exp) so what!/who gives a damn?/
だが /(conj) but/however/(and) yet/nevertheless/still/for all that/(P)/
だく /(n) (abbr) trot (as in horse riding)/
だく足 [だくあし] /(n) (obsc) trot (as in horse riding)/
だけあって /(suf) .. being the case/(precisely) because .../as might be expected (from ..)/
だけでなく /(exp) not just ... (but also ..)/(P)/
だけど /(conj) however/(P)/
だけども /(exp) though/much as/(P)/
だけは /(exp) (id) at least .../at least not (when followed by a negative)/
だけれども /(exp) though/much as/(P)/
ださい /(adj-i) primitive/unsophisticated/out of fashion/
ださ男 [ださお] /(n) (sl) an uncool man/dork/geek/dweeb/nerd/
だし巻き卵 [だしまきたまご] /(n) Japanese omelette/
だだっ広い [だだっぴろい] /(adj-i) very (excessively) spacious/unduly wide/sprawling/
だだっ子 [だだっこ] /(n) unmanageable child/spoiled child (spoilt)/spoiled brat/
だだっ児 [だだっこ] /(n) unmanageable child/spoiled child (spoilt)/spoiled brat/
だち /(n) (col) (abbr) friend/
だっけ /(exp) expression used when the speaker is trying to recall some information/(P)/
だったら /(conj) if it's the case/(P)/
だって /(conj,prt) (1) but/however/still/yet/although/even though/(suf) (2) even/even if/(3) or something/(P)/
だてらに /(suf,prt) a mere (status or characteristic)/implies activity unsuited to (status or characteristic)/(P)/
だと /(exp) if it's the case/(P)/
だに /(prt) even/
だの /(suf,prt) and/or/and the like/and so forth/and what not/(P)/
だぶだぶ /(adj-na,adv,n,vs,adj-no) (1) (on-mim) loose/baggy/(2) overflowing/brimming/(P)/
だぶつく /(v5k,vi) (1) to be too large/to be baggy/to be flabby/(2) to have a glut/
だぼ /(n) dowel/joggle/
だぼ鯊 [だぼはぜ] /(n) goby (fish)/
だまし絵 [だましえ] /(n) trompe l'oeil/
だまし取る [だましとる] /(v5r) to take something away by deception/
だみ声 [だみごえ] /(n) (1) thick voice/hoarse voice/(2) voice with a thick accent/
だめる /(int) "Shut up!"/"Be quiet!"/
だめ押し [だめおし] /(exp) (1) making doubly sure/(2) insurance runs (baseball)/
だもの /(n,vs) indicate reason/infers some protest/
だもので /(exp) thereupon/therefore/because of that/
だもんで /(exp) thereupon/therefore/because of that/
だらけ /(n-suf) (1) implying (negatively) that something is full of (e.g. mistakes)/(2) covered all over (e.g. with blood)/(P)/
だらける /(v1,vi) to be lazy/to be slack/to feel dull/to feel languid/to feel listless/
だらしが無い [だらしがない] /(exp,adj-i) (uk) slovenly/loose/sluttish/slatternly/untidy/undisciplined/careless/
だらしの無い [だらしのない] /(exp,adj-i) (uk) slovenly/loose/sluttish/slatternly/untidy/undisciplined/careless/
だらし無い [だらしない] /(adj-i) (uk) slovenly/loose/sluttish/slatternly/untidy/undisciplined/careless/
だらだら /(adv,n,vs,adv-to) (1) (on-mim) pouring liquid/(2) prevaricating/(3) long, gentle slope/(4) sluggishly/endlessly/(P)/
だらだらかげろう景気 [だらだらかげろうけいき] /(n) period of Japanese economic expansion from February 2002 to October 2007/
だらだら陽炎景気 [だらだらかげろうけいき] /(n) period of Japanese economic expansion from February 2002 to October 2007/
だらり /(adv-to) (on-mim) languidly/loosely/
だらん /(adv-to) (on-mim) languidly/loosely/
だり /(prt) (1) -ing and -ing (e.g. "coming and going")/(2) (used adverbially) doing such things as.../(3) expresses a command/
だれる /(v1,vi) (1) to lose interest/to weaken/to slacken/(2) to lose value after a peak (e.g. stock)/
だろ /(exp) (1) seems/I think/I guess/I wonder/I hope/(2) don't you agree?/I thought you'd say that!/
だろう /(exp) (1) seems/I think/I guess/I wonder/I hope/(2) don't you agree?/I thought you'd say that!/(P)/
だんだん /(exp) thank you (dialect from the Izumo region of Shimane Prefecture)/
だんな取り [だんなどり] /(vs) (1) to become a mistress/to serve as a concubine/(2) to serve one's master/
だ円 [だえん] /(n,adj-no) ellipse/
だ円関数 [だえんかんすう] /(n) (math) elliptic function/
だ体 [だたい] /(n) literary form imparting the nuance of speech (with sentences ending in "da")/
だ捕 [だほ] /(n,vs) capture/seizure/
ちぇ /(int) shoot/shit/dang/crap/rats/dammit/
ちぇっ /(int) shoot/shit/dang/crap/rats/dammit/
ちぎりぎ /(n) (MA) weight-chain-pole weapon/
ちぎり絵 [ちぎりえ] /(n) collage of pieces of colored paper/
ちくちく /(n,vs) (on-mim) type of prickling pain/prick/prickle/
ちくちく痛む [ちくちくいたむ] /(exp,v5m) to prickle/to tingle/
ちくる /(v5r) (sl) to tattle/to inform a superior of someone's actions/
ちぐはぐ /(adj-na,n) (on-mim) mismatched/(P)/
ちちり星 [ちちりぼし] /(n) Chinese "Well" constellation (one of the 28 mansions)/
ちぢれ毛 [ちぢれげ] /(n) curly hair/kinky hair/frizzy hair/
ちっちゃい人間 [ちっちゃいにんげん] /(exp) person of poor character/narrow-minded/unpleasant person/gossip-monger/person of low self-esteem/
ちっとも気にならない [ちっともきにならない] /(exp,adj-i) not be concerned about at all/not mind about at all/not care a bit/
ちっとやそっと /(exp) small amount/bit/smidgen/
ちっぽけ /(adj-na,n) very small/tiny/
ちはや /(n) (obsc) (uk) thin, white ceremonial haori worn by miko/
ちびくろサンボ /(n) Little Black Sambo (book title)/
ちびちび /(adv,adv-to) (on-mim) making something last/
ちびっ子 [ちびっこ] /(n) (col) small child/rug rat/ankle-biter/
ちびりちびり /(adv,adv-to) (on-mim) making something last/
ちびる /(v5r,vt) (1) (col) to wet oneself/to shit oneself/(2) to be miserly/
ちまう /(v5u) (col) to do something completely/
ちまちま /(adv-to,adv) (on-mim) small/compact/
ちゃいかん /(exp) must not do/
ちゃう /(aux-v,v5u) to do something completely/
ちゃう /(exp) (1) (osb:) No!/(2) isn't it?/wasn't it?/
ちゃうちゃう /(exp) (1) (osb:) That's not true!/
ちゃきちゃき /(n) efficient/
ちゃち /(adj-na) cheap/rubbishy/shoddy/roughly made/
ちゃっかり /(adv,n,vs) shrewd/calculating/nervy/cheeky/
ちゃった /(exp) finished doing/did completely/
ちゃぶ台 [ちゃぶだい] /(n) low dining table/tea table/
ちゃぶ台返し [ちゃぶだいがえし] /(n) flipping a table over in anger/overturning a table in anger/
ちゃぷちゃぷ /(adj-na,adj-no,adv-to,n) splish-splash/glug-glug/
ちゃほや /(ik) (adv,n,vs,adv-to) (on-mim) pamper/make a fuss of/spoil/
ちゃぽちゃぽ /(adv,n,vs) (1) splash water/dabble in water/splashing sound/
ちゃら /(n) (col) forgiving a debt/getting even/
ちゃらい /(adj-i) flashy/gaudy/wrapped in cheap flattery/
ちゃらっぽこ /(int) no way/that can't be true/nonsense!/
ちゃらんぽらん /(n,adj-no) devil-may-care/speaking off-hand/slaphappy/
ちゃり /(n) (abbr) (col) bicycle/
ちゃりんこ /(n) (1) (sl) child pickpocket/(2) (col) bicycle/
ちゃん /(n-suf) (1) suffix for familiar person/(n) (2) (arch) (abbr) (sl) (chn) daddy/pa/(P)/
ちゃんこ /(n) traditional sumo stew/
ちゃんこ屋 [ちゃんこや] /(n) chanko restaurant, often owned by former sumo wrestler/
ちゃんこ長 [ちゃんこちょう] /(n) most experienced chanko cook in the sumo stable/
ちゃんこ鍋 [ちゃんこなべ] /(n) weight-gaining stew for sumo/
ちゃんこ番 [ちゃんこばん] /(n) (sumo) person in charge of preparing food for rikishi (usually performed by low-ranking rikishi)/
ちゃんこ料理 [ちゃんこりょうり] /(n) sumo food/
ちゃんたま /(n) (col) testicles/
ちゃんちゃん /(adv,n) regularly/promptly/
ちゃんちゃんこ /(n) padded sleeveless kimono jacket/Japanese vest/
ちゃんと /(adv,n,vs) perfectly/properly/exactly/(P)/
ちゃんばら /(n) sword fight/
ちゃんばら映画 [ちゃんばらえいが] /(n) samurai movie/
ちゃんぽん /(n,adj-na) (1) practice of mixing things normally kept separate (practise)/mixture/(2) dish of noodles, seafood, vegetables (from Nagasaki)/
ちゃんぽんに /(adv) (1) alternately/by turns/(2) all together/
ちゃんぽん語 [ちゃんぽんご] /(n) words from another language/
ちゃん付け [ちゃんづけ] /(n,vs) attaching 'chan' to somebody's name/
ちゃ色 [ちゃいろ] /(n,adj-no) light brown/tawny/
ちやほや /(adv,n,vs,adv-to) (on-mim) pamper/make a fuss of/spoil/
ちゅう /(n,vs) (1) (col) kiss/(n,adv-to) (2) squeak (as in the sound made by mice)/(3) sound of liquid being sucked up/
ちゅうちゅう吸う [ちゅうちゅうすう] /(exp,v5u) to suck/
ちゅうちゅう鳴く [ちゅうちゅうなく] /(exp,v5k) to squeak/to chirp/to twitter/
ちゅうひ /(n) (uk) Eastern marsh harrier (Circus spilonotus)/
ちゅっと /(adv,vs) (col) kissing/
ちゅらさん /(n) (rkb:) beauty/prettiness/
ちゅん /(adv,adv-to) (on-mim) chirp/cheep/
ちゅんちゅん /(adv,adv-to) (on-mim) chirp/cheep/
ちょい /(adv,adv-to) (1) just a minute/short time/just a little/(2) somewhat/easily/readily/rather/
ちょいちょい /(adv,int,n) often/frequently/now and then/occasionally/
ちょいと /(adv) (1) (uk) just a minute/short time/just a little/(2) somewhat/easily/readily/rather/(3) (before a verb in negative form) (will not) easily/(int) (4) hey!/
ちょいむず /(n,adj-na) (abbr) (sl) slightly difficult/
ちょいムズ /(n,adj-na) (abbr) (sl) slightly difficult/
ちょい悪おやじ [ちょいわるおやじ] /(n) (col) older and fashionable man (wild-looking, burly, etc.)/
ちょい悪オヤジ [ちょいわるオヤジ] /(n) (col) older and fashionable man (wild-looking, burly, etc.)/
ちょい役 [ちょいやく] /(n) bit part (e.g. in a film)/extra/
ちょうど今 [ちょうどいま] /(exp,n-t) right now/just now/
ちょう形骨 [ちょうけいこつ] /(n) sphenoid bone (of the skull)/
ちょう待って [ちょうまって] /(exp) (ksb:) Wait a minute/
ちょう度 [ちょうど] /(n) consistency/
ちょくちょく /(adv) often/frequently/now and then/occasionally/(P)/
ちょくる /(v5r,vt) to tease/to banter/to make fun of somebody/
ちょける /(v5r,vt) to tease/to banter/to make fun of somebody/
ちょこちょこ /(adv,n,vs) toddling/hobbling/restless/easily accomplished/
ちょこっと /(adv,adj-f) (on-mim) rather/a little/small/
ちょこなん /(adv-to) (on-mim) slightly (of an action)/(looking) small and quiet/
ちょこまか /(vs,adv-to) restlessly/in continuous motion/
ちょこん /(adv-to) (on-mim) slightly (of an action)/(looking) small and quiet/
ちょちょいのちょい /(exp) piece of cake/a walk in the park/
ちょっかい /(n) meddle/dabble/make a pass at/
ちょっきり /(adv,adv-to) (1) (on-mim) exactly/just/(2) snip/
ちょっくら /(adv,n) (a) little/
ちょっとそこまで /(exp) nowhere in particular/just out for a bit/(euph. for) toilet break/
ちょっと一杯 [ちょっといっぱい] /(exp) let's have a quick drink/
ちょっと見 [ちょっとみ] /(n) a look or glance/
ちょっぴり /(adv) very little bit/just a smidgin/wee bit/(P)/
ちょびっと /(adv) a little/(P)/
ちょびと /(adv) a little/(P)/
ちょび髭 [ちょびひげ] /(n) small mustache/short mustache/
ちょぼちょぼ /(adj-na,adv,n) (on-mim) sparsely/drop-by-drop/
ちょろい /(adj-i) easy/simple/
ちょろちょろ /(adv,n,vs) (1) in trickles (e.g. water flowing)/(2) darting about (e.g. a small animal)/moving rapidly/
ちょろまかす /(v5s,vt) to pilfer/to filch/to snaffle/to pocket/
ちょん /(adv-to,n) (1) (on-mim) clap clap (sound)/(2) chop vigorously/(3) slight movement/(4) the end/
ちょんちょん /(n,adv,adv-to) (1) (on-mim) sound of wooden clappers clapping/(n) (2) punctuation marks such as the dakuten/
ちょんになる /(exp,v5r) to come to an end/to finish/to get fired/
ちょんぼ /(n,vs) apparent and grievous error/mistake/blunder/bungle/goof/
ちょんまげ /(aux) (sl) please do (for me)/
ちょん掛 [ちょんがけ] /(n) pulling heel hook (sumo)/
ちょん掛け [ちょんがけ] /(n) pulling heel hook (sumo)/
ちょん切る [ちょんぎる] /(v5r,vt) to chop something off (e.g. head)/to snip off/to fire/
ちらし寿司 [ちらしずし] /(n) (food) sushi rice in a box or bowl with a variety of ingredients sprinkled on top/
ちらちら /(adv,adv-to,vs) (on-mim) fluttering/flickering/intermittently/(P)/
ちらっと /(adv) (on-mim) at a glance/by accident/(P)/
ちらっと見る [ちらっとみる] /(exp,v1) to glance at/to glimpse/
ちらつき /(n) flickering (e.g. on a video display)/
ちらつき防止フィルタ [ちらつきぼうしフィルタ] /(n) (comp) glare filter/
ちらつく /(v5k,vi) to flicker/to flit/to litter/to be dazzled/
ちらと /(adv) (on-mim) at a glance/by accident/
ちらほら /(adv) (on-mim) here and there/now and then/in twos and threes/
ちらり /(adv-to,adv) (on-mim) fleeting (glimpse, glance, etc.)/(P)/
ちらりほらり /(adv,adv-to) here and there/now and then/twos and threes/sparsely/
ちらりズム /(n) the art of giving a brief glimpse of something (e.g. one's underwear)/
ちら見 [ちらみ] /(n,vs) (sl) glancing look/
ちり /(n) dish of fish (meat, etc.), tofu, vegetables boiled together and served with ponzu dipping sauce/
ちりこ星 [ちりこぼし] /(n) Chinese "Extended Net" constellation (one of the 28 mansions)/
ちりちり /(adv,n,adj-na,vs) (on-mim) bits and pieces/frizzily (as in perm)/
ちりんちりん /(adv) jingle/ding (sound representing the ringing of small bells)/
ちり紙 [ちりがみ] /(n) (1) (a) tissue/(2) toilet paper/(P)/
ちり取 [ちりとり] /(n) dustpan/(P)/
ちり取り [ちりとり] /(n) dustpan/(P)/
ちり鍋 [ちりなべ] /(n) dish of fish (meat, etc.), tofu, vegetables boiled together and served with ponzu dipping sauce/pot used to cook such a dish/
ちろちろ /(adv-to) (1) flicker (light)/waver/(2) trickle (water)/(3) glance at/
ちわっす /(int) (col) Hi/Yo/
ちん /(n-suf) intimate (or disdainful) suffix used after a person's name (or the base of an adjective describing that person)/
ちんけ /(adj-na) worst/poor and boring/uncool/
ちんこ /(n) (col) (vulg) penis/
ちんすこう /(n) Okinawan sweet/
ちんたら /(adv,adv-to) (on-mim) dilatorily/sluggishly/
ちんちくりん /(n,adj-na) short (person)/shorty/stumpy/
ちんちん /(adv,adv-to) (1) (on-mim) chink/jingle/tinkle/whistle (kettle)/(n,vs) (2) begging (animal)/(n) (3) (chn) penis/
ちんちん電車 [ちんちんでんしゃ] /(n) (sl) streetcar, trolley/
ちんちん鳴る [ちんちんなる] /(v5r) to jingle/to tinkle/to whistle (kettle)/
ちんどん屋 [ちんどんや] /(n) traditional Japanese band of sandwich board advertisers/
ちんぴら /(n,adj-no) (young) hoodlum/small-time yakuza/delinquent boy/delinquent girl/hooligan/punk/
ちんぽ /(n) (col) penis/
ちんまり /(adv-to,vs) (on-mim) snugly/cosily/compactly/
ちん入 [ちんにゅう] /(n,vs) intrusion/forced entry/
ちん毛 [ちんげ] /(n) (sens) (sl) (uk) pubic hair/penis hair/
っけ /(prt) particle indicating that the speaker is trying to recall some information/
っこ /(suf) (1) (abbr) doing/in such a state/(2) doing together/contest/match/(3) (fam) familiarizing suffix (sometimes meaning "small")/
っこない /(exp) (after a verb's -masu base) no chance of (verb)/
っしょ /(aux) (col) col. form of deshou/
っす /(aux) col. form of desu/
ったく /(int) (col) (abbr) good grief (expression of exasperation)/
ったら /(conj,prt) (1) indicates supposition/if ... then/when/after/(prt) (2) (typically after someone's name) indicates exasperation/(P)/
ったらありゃしない /(exp) (col) (used after adj.) nothing more ... than this/as .... as it could possibly be/
ったらしい /(suf,adj-i) (after a noun or the stem of an adjective) seeming very... (usu. with a negative connotation)/
ったらない /(exp) (col) (used after adj.) nothing more ... than this/as .... as it could possibly be/
っつーか /(conj) (col) or rather (say)/or better (say)/or perhaps I should say/or, how should I put it,.../I mean/
っつうか /(conj) (col) or rather (say)/or better (say)/or perhaps I should say/or, how should I put it,.../I mean/
って /(prt) casual quoting particle/(P)/
っていうか /(conj) (col) or rather (say)/or better (say)/or perhaps I should say/or, how should I put it,.../I mean/
ってか /(conj) (col) or rather (say)/or better (say)/or perhaps I should say/or, how should I put it,.../I mean/
ってば /(prt) (1) indicates emotional closeness or annoyance with someone/(2) indicates an indirect command by expressing annoyance (in sentence-final position)/
ってゆうか /(conj) (col) or rather (say)/or better (say)/or perhaps I should say/or, how should I put it,.../I mean/
っぷり /(suf) (col) manner/style/
っぽい /(suf,adj-i) (1) (col) -ish/-like/(P)/
っ限り [っきり] /(prt) (1) (uk) only/just/(2) (uk) since/(3) (uk) remaining (in a particular state)/
っ子 [っこ] /(suf) (col) someone with a liking or characteristic/a true representative of (place)/
っ切り [っきり] /(prt) (1) (uk) only/just/(2) (uk) since/(3) (uk) remaining (in a particular state)/
っ放し [っはなし] /(n-suf) (uk) keep ...-ing (negative nuance, with the state being improper, unpleasant, etc.)/have been ...-ing/leaving (something) on/leaving (something) still in use/
っ放し [っぱなし] /(n-suf) (uk) keep ...-ing (negative nuance, with the state being improper, unpleasant, etc.)/have been ...-ing/leaving (something) on/leaving (something) still in use/
つ /(conj) (1) indicates two contrasting actions/(prt) (2) (arch) indicates possessive (often found in place names and compound words)/
つーか /(conj) (col) or rather (say)/or better (say)/or perhaps I should say/or, how should I put it,.../I mean/
つーんと /(adv) pungently (of a smell)/
つい /(adv) (1) just (now)/(2) quite (near)/(3) unintentionally/unconsciously/by mistake/against one's better judgement (judgment)/(P)/
ついさっき /(n) just now/a little while back/a short time ago/
ついつい /(adv) (on-mim) unintentionally/unconsciously/by mistake/against one's better judgement/against one's better judgment/
ついて回る [ついてまわる] /(v5r,vi) to follow around/
ついて行く [ついていく] /(v5k-s) to accompany/to follow/
ついて行く [ついてゆく] /(v5k-s) to accompany/to follow/
つうっと /(adv) (on-mim) quickly/smoothly/
つうと /(adv) (on-mim) quickly/smoothly/
つかず離れず [つかずはなれず] /(exp,adv) maintaining a reasonable distance/neutral position/indecision/
つかず離れずの態度 [つかずはなれずのたいど] /(n) neutral attitude/
つかつか /(adv,adv-to) (on-mim) walking briskly/determinedly/
つかの間 [つかのま] /(n,adj-no) moment/brief time/brief/transient/(P)/
つかみ取る [つかみとる] /(v5r) to grasp/to get/
つかみ所 [つかみどころ] /(n) (1) (uk) point (of a conversation, etc.)/sense/(2) hold/grip/
つきが回る [つきがまわる] /(exp,v5r) to have fortune come your way/to become lucky/
つき合い [つきあい] /(n) association/socializing/socialising/fellowship/
つき合う [つきあう] /(v5u,vi) (1) to associate with/to keep company with/to go out with/to go steady with/to get on with/(2) to go along with/to follow someone's lead/to accompany someone/to compromise/
つき刺す [つきさす] /(v5s,vt) to stab/to pierce/to thrust/
つき手 [つきて] /(n) hand touch down (sumo)/
つき従う [つきしたがう] /(v5u,vi) to follow/to accompany/to cleave to/to join up with/to obey implicitly/to flatter/
つき出し [つきだし] /(n) (1) protrusion/(2) (Japanese) hors d'oeuvre/snacks/(3) (sumo winning technique of) pushing out of the ring/
つき出す [つきだす] /(v5s,vt) to push out/to project/
つき物 [つきもの] /(n) accessory/accompaniment/indispensable part/appendage/
つぎ込む [つぎこむ] /(v5m,vt) to invest in/to sink money into/to put into/to lay out (funds)/to inject/to impregnate/to infuse/to instill/to implant/to imbue/to focus (attention, efforts)/
つくつく法師 [つくつくぼうし] /(ateji) (n) (uk) Meimuna opalifera (species of cicada)/
つくねんと /(adv) (1) absentmindedly/vacantly/blankly/(2) by oneself/all alone/
つくり直す [つくりなおす] /(v5s,vt) to remake/to rebuild/
つけ加える [つけくわえる] /(v1,vt) to add one thing to another/
つけ込む [つけこむ] /(v5m,vi) to take advantage of/to impose on/to make an entry/
つけ根 [つけね] /(n) root/joint/base/crotch/
つけ入る [つけいる] /(v5r) to take advantage of/to impose on/
つけ麺 [つけめん] /(n) cold Chinese noodles accompanied by soup for dipping/
つじ風 [つじかぜ] /(n) (1) whirlwind/
つっと /(adv) (on-mim) quickly/smoothly/
つつ /(prt) while/though/(P)/
つつある /(suf) (with masu stem) to be doing/to be in the process of doing/
つつき回す [つつきまわす] /(v5s) (uk) to poke something around/
つづら折 [つづらおり] /(adj-no,n) winding/meandering/sinuous/zigzag/
つづら折り [つづらおり] /(adj-no,n) winding/meandering/sinuous/zigzag/
つづり方 [つづりかた] /(n) (1) (way of) literary composition/(2) (way of) spelling/(3) school composition/
つづれ錦 [つづれにしき] /(n) (hand-woven) brocade/
つづれ織り [つづれおり] /(n) (hand-woven) tapestry/
つと /(adv) (1) quickly/(2) calmly/(3) intently/
つなぎ合わせる [つなぎあわせる] /(v1) to connect/to join/to join or tie or knot together/
つなぎ止める [つなぎとめる] /(v1,vt) to tie/to fasten/to hitch/to secure (e.g. load, patronage of customers, etc.)/to hold on to/
つなぎ売り [つなぎうり] /(n,vs) hedging/hedge selling/
つなぎ服 [つなぎふく] /(n) overalls/boiler suit/
つなぎ目 [つなぎめ] /(n) joint/link/tie-together point/
つばさ /(n) extra-high-speed Touhoku-line Shinkansen/
つばす /(n) (ksb:) young Japanese amberjack/
つぶしが利く [つぶしがきく] /(exp,v5k) to be valuable as scrap/to be able to do other work/to have marketable skills/
つぶし島田 [つぶししまだ] /(n) type of woman's hairdo (Edo period)/
つぶし餡 [つぶしあん] /(n) slightly crushed sweetened red-bean paste/
つべこべ /(adv,adv-to) (on-mim) complaining/nitpicking/
つまみ上げる [つまみあげる] /(v1) to take a pinch of something (e.g. salt)/to pick up in one's fingers/
つまみ食い [つまみぐい] /(n,vs) (1) eating with one's fingers/(2) snitching food/snatched food/secret eating/food snatched and eaten without the meal starting/(3) embezzlement/misappropriation/exploiting something/(4) flirting/
つまらない物ですが [つまらないものですが] /(exp) (uk) "It's not much, but..." (phrase often used when giving gifts)/
つまる処 [つまるところ] /(adv) in sum/in short/in the end/
つまる所 [つまるところ] /(adv) in sum/in short/in the end/
つまんない /(adj-i) (sl) dull/boring/(P)/
つま先 [つまさき] /(n) tiptoe/(P)/
つま先下がり [つまさきさがり] /(n) downhill path/
つま先上がり [つまさきあがり] /(n) uphill path/
つま先立ち [つまさきだち] /(n) standing on tiptoes/
つま先立つ [つまさきだつ] /(v5t,vi) to stand on tiptoes/
つみ重ねる [つみかさねる] /(v1,vt) to pile up/to accumulate/
つむじ曲がり [つむじまがり] /(adj-na,n) perversity/cantankerous/eccentric/
つむじ風 [つむじかぜ] /(n) (1) whirlwind/
つめ見出し [つめみだし] /(n) thumb index (e.g. in a dictionary)/
つめ込む [つめこむ] /(v5m,vt) to cram/to stuff/to jam/to squeeze/to compress/to pack/to crowd/
つめ車 [つめぐるま] /(n) ratchet/toothed wheel/
つもりである /(exp,v5r-i) to intend/
つや出し [つやだし] /(n,vs) burnishing/glazing/polishing/
つや消し [つやけし] /(adj-na,adj-no) (1) frosted (glass)/matted/(n,adj-na) (2) disillusionment/letdown/
つや消しガラス [つやけしガラス] /(n) frosted glass/
つゆだく /(n) soupy/containing more broth or sauce than usual (of gyudon, etc.)/
つらい目にあう [つらいめにあう] /(exp,v5u) to have a hard time of it/
つり下げる [つりさげる] /(v1,vt) to suspend from/to be suspended (from)/
つり革 [つりかわ] /(n) strap (to hang onto)/
つり索 [つりさく] /(n) shroud line/
つり上げる [つりあげる] /(v1,vt) (1) to raise/to lift/to hang up/to suspend/(2) to (artificially, deliberately) raise prices/
つり針 [つりばり] /(n) fish hook/
つり銭 [つりせん] /(n) change (e.g. for dollar)/
つり銭口 [つりせんぐち] /(n) coin return slot/change slot/
つり足場 [つりあしば] /(n) suspended scaffolding/
つり輪 [つりわ] /(n) (gymnastic) rings/
つるし雲 [つるしぐも] /(n) roll cloud/rotor cloud/
つるし上げ [つるしあげ] /(n) (1) hung up/hoist/(2) denounced/severely criticised/kangaroo court/
つるし上げる [つるしあげる] /(v1,vt) (1) to hang up/to hoist/(2) to denounce/to subject someone to a kangaroo court/
つるつる /(adj-na,adv,n,vs,adj-no) (on-mim) slippery/smooth/(P)/
つるり /(adv-to) (on-mim) smoothly/with a slipping or sliding motion/
つるん /(adv-to) (on-mim) smoothly/with a slipping or sliding motion/
つる鋸 [つるのこ] /(n) traditional Japanese woodworking saw/bow saw/
つる植物 [つるしょくぶつ] /(n,adj-no) creeper (creeping plant)/trailer (trailing plant)/climber (climbing plant)/vine/
つる性植物 [つるせいしょくぶつ] /(n) creeper (plant that grows along the ground, etc. similar to a vine)/
つる草 [つるくさ] /(n) vine/creeper/
つる鍋 [つるなべ] /(n) pot with a bail for a handle/
つる返し [つるがえし] /(n) (uk) digging up, removing sprouts from, and replanting tubers (esp. of the sweet potato) to make for a bigger end product/
つれない /(adj-i) cold/indifferent/unfriendly/unsympathetic/unkind/
つれ帰る [つれかえる] /(v5r) to bring (someone) back home/to take (someone) back home/
つれ添う [つれそう] /(v5u,vi) to become a couple/to be man and wife/to be married to/
つわ者 [つわもの] /(n) (1) soldier/warrior/(2) strong man/exceptional person/man of courage/
つんけん /(adv,vs) crabbily/unsociably/
つんつん /(adv,n,vs) (on-mim) aloof/morose/pointed/
つんでれ /(adj-f,n) (1) being on the surface sharp and sarcastic (tsuntsun) but underneath lovestruck and fawning (deredere)/characteristic of a gap between acted out actions and feelings in mind/(2) normally being sharp but at some prompt suddenly becoming lovestruck/hot-cold personality type/
つんと /(adv) (1) prickly (attitude)/aloof/(vs) (2) to look standoffish/(3) acrid/sharp (smell)/(4) popping (e.g. of ears, sinuses, etc.)/
つんのめる /(v5r,vi) to pitch (fall) forward/
つんぼ桟敷 [つんぼさじき] /(n) (1) (sens) being kept uninformed/being cut off/out of the loop/(2) (arch) upper gallery (where one can't hear)/blind seat/
づつ /(ok) (suf) (1) apiece/each/(2) at a time/piecemeal/(P)/
づんと /(ok) (adv) much/
て /(prt) casual quoting particle/(P)/
てい /(n) (1) Di (ancient Chinese ethnic group)/(2) Chinese "root" constellation (one of the 28 mansions)/
ていい /(exp,adj-i) (1) (after the ren'youkei form of a verb) indicates concession or compromise/(2) indicates permission/
ていうか /(exp) I mean (used at the beginning of a sentence)/
てかてか /(adj-na,adv,n,vs) (on-mim) gleaming/
てきばき /(adv,adv-to,vs) (on-mim) briskly/quickly/promptly/
てきぱき /(adv,adv-to,vs) (on-mim) briskly/quickly/promptly/
てき儻 [てきとう] /(n) exceedingly wiser than the common man/
てくてく /(adv) (on-mim) trudgingly/going long way at steady pace/(P)/
てくシー /(n) (sl) going on foot/
てこてこ /(n) sound of walking/
てこの原理 [てこのげんり] /(n) principle of leverage/
てっきり /(adv) surely/certainly/beyond doubt/(P)/
てっさ /(n) (ksb:) fugu sashimi/
てっぺんかけたか /(adv) (1) (obsc) calling sound of the lesser cuckoo/(n) (2) lesser cuckoo (Cuculus poliocephalus)/
てつまん /(n) all-night Mah Jongg/
てな /(prt) a sort of thing like/used after a phrase to modify the following noun/
てば /(prt) (1) indicates emotional closeness or annoyance with someone/(2) indicates an indirect command by expressing annoyance (in sentence-final position)/
ても /(conj,prt) (1) but/however/still/yet/although/even though/(suf) (2) even/even if/(3) or something/
ても /(prt) (1) (abbr) even if/even though/(int) (2) wow/
てもいい /(exp,adj-i) (1) (after the ren'youkei form of a verb) indicates concession or compromise/(2) indicates permission/
てゆーか /(conj) (col) or rather (say)/or better (say)/or perhaps I should say/or, how should I put it,.../I mean/
てらてら /(adv,adv-to,vs) (on-mim) gleamingly/shinily/
てれながら /(n) feeling awkward/
てれ隠し [てれかくし] /(n) hiding one's embarrassment/
てんてこ舞 [てんてこまい] /(n,vs) whirl of busyness/humming with activity/bustling activity/
てんてこ舞い [てんてこまい] /(n,vs) whirl of busyness/humming with activity/bustling activity/
てんで /(adv) (not) at all/altogether/entirely/
てんびん座 [てんびんざ] /(n) (constellation) Libra/the Scales/
てんやわんや /(adj-no) hectic/topsy-turvy/chaotic/
てん補 [てんぽ] /(n,vs) (1) supplementation/replenishment/(2) compensation/indemnification/
て拳道 [てこんどー] /(n) (uk) Tae Kwon Do (kor:)/
て成らない [てならない] /(exp,adj-i) (uk) unable to resist/unable to supress/
で /(prt) (1) indicates location of action/at/in/(2) indicates time of action/(3) indicates means of action/cause of effect/by/(conj) (4) and then/so/(P)/
であ /(aux) (abbr) (arch) to be/
であります /(exp) (pol) to be (copula)/
である /(v5r-i) to be (formal, literary)/
であるから /(exp) therefore/and so/for that reason/accordingly/consequently/hence/
であるからして /(exp) therefore/and so/for that reason/accordingly/consequently/hence/
である体 [であるたい] /(n) literary form imparting a formal written nuance (with sentences ending in "de aru")/
であれ /(conj) (1) even if/(2) (it doesn't matter) whether (A or B or ...)/whatever/(3) should/
であろう /(aux) will/probably/may/I think/surely/I hope/I fear/it seems/
でい岩 [でいがん] /(n) mudstone/
でか /(n) (sl) detective/
でかい /(adj-i) huge/gargantuan/(P)/
でかい顔する [でかいかおする] /(exp,vs-i) (col) to act self-importantly/to be arrogant/to be high-handed/to puff up/
でかい顔をする [でかいかおをする] /(exp,vs-i) (col) to act self-importantly/to be arrogant/to be high-handed/to puff up/
でかちん /(n,adj-no) (sl) (vulg) large penis/huge dick/
でかでか /(adv) (on-mim) in a big way/
でかぱい /(n) (X) (vulg) huge breasts/
できこと /(n) event/
できちゃった結婚 [できちゃったけっこん] /(n) marriage due to unintended pregnancy/shotgun wedding/
できちゃった婚 [できちゃったこん] /(n) marriage due to unintended pregnancy/shotgun wedding/
できない相談 [できないそうだん] /(n) impossible proposition/unreasonable proposal/tall order/
できるだけ早く [できるだけはやく] /(exp) as soon as possible/(P)/
できる限り [できるかぎり] /(n) as ... as one can/
できる限り早い [できるかぎりはやい] /(adj-i) as soon as possible/at the earliest time/
できる限り早期 [できるかぎりそうき] /(n) as soon as possible/ASAP/
でき婚 [できこん] /(n,vs) (abbr) shotgun marriage/
でき次第 [できしだい] /(n-t) as soon as completed/
でき上がる [できあがる] /(v5r,vi) (1) to be completed/to be finished/to be ready (e.g. to serve or eat)/(2) to be very drunk/
でき損い [できそこない] /(n) failure/dead loss/washout/badly done/good-for-nothing/
でくでく /(adv) (on-mim) plump/fat/
でくの坊 [でくのぼう] /(n) (1) wooden doll/(2) blockhead/good-for-nothing/
でこぴん /(n) poke in the forehead/
でこピン /(n) poke in the forehead/
でごんす /(exp) (arch) (pol) to be (copula)/
でご座る [でござる] /(v5aru) (uk) (pol) to be/
でさえ /(prt) even/but/however/(P)/
でしょ /(ik) (exp) (1) (pol) seems/I think/I guess/I wonder/I hope/(2) don't you agree?/I thought you'd say that!/
でしょう /(exp) (1) (pol) seems/I think/I guess/I wonder/I hope/(2) don't you agree?/I thought you'd say that!/(P)/
です /(aux) (pol) polite copula in Japanese/(P)/
ですか /(exp) (pol) indicates question (sentence end)/
ですから /(conj) so/therefore/(P)/
ですが /(conj) but/however/(and) yet/nevertheless/still/for all that/(P)/
ですが何か [ですがなにか] /(exp) what if I am ..?/
ですます体 [ですますたい] /(n) literary form imparting the nuance of polite speech (with sentences ending in "desu" and verbs ending in "masu")/
です体 [ですたい] /(n) literary form imparting the nuance of polite speech (with sentences ending in "desu" and verbs ending in "masu")/
でっかい /(adj-i) huge/gargantuan/(P)/
でっち上げ [でっちあげ] /(n) (uk) fabrication/put-up job/trumped-up story/frame-up/hoax/
でっち上げる [でっちあげる] /(v1,vt) (1) (uk) to fabricate/to invent/to make up (a story)/to hoax/to pull a hoax/(2) to frame someone/
でっぷり /(n,vs,adj-f) stoutness/corpulence/
でっぷりした /(adj-f) stout/fat/corpulent/portly/
ででむし /(n) (arch) snail/
でないと /(exp) without/but if/(P)/
でなくて何だろう [でなくてなんだろう] /(exp) (uk) if not ... then what is it?/(this) is nothing other than .../
でなければ /(exp) without/but if/(P)/
でなければいけない /(exp) having to be/must be/should be/ought to be/
でなければならない /(exp) having to be/must be/should be/ought to be/(P)/
でなければならぬ /(exp) having to be/must be/should be/ought to be/
では /(conj,int) then/well/so/well then/(P)/
ではありますまいか /(exp) I wonder if it is not (something, a thing)/
ではある /(exp,v5r-i) to be (in contrast to something that is not the case)/
ではないか /(exp) (1) questioning (something)/(2) let's do (something)/(P)/
ではまた /(exp) (abbr) see you later (used in casual correspondence and conversation)/goodbye/sincerely/
では無さそう [ではなさそう] /(exp,aux) does not seem (to be)/
でぶっちょ /(n,adj-na,adj-no) (derog) fatty/butterball/
でぶでぶ /(adj-no,adj-na,adv,adv-to,vs) fat/
でぶ専 [でぶせん] /(n) (sl) chubby-chasing (fat fetishism)/chubby-chaser/
でも /(conj,prt) (1) but/however/still/yet/although/even though/(suf) (2) even/even if/(3) or something/(P)/
でもある /(v5r-i) (1) to also be (formal, literary)/implies that as well as the earlier stated this is also the case/(2) to be ... or something/(P)/
でもって /(prt) (uk) indicates means of action/cause of effect/by/
でもない /(exp) (1) neither... nor... (with the implication that there are other "nor..." items)/(2) denying explicitly one thing and also denying implicitly other things as well/(3) not like (you)/not (your) usual self/(P)/
でも医者 [でもいしゃ] /(n) quack (doctor)/
でれっと /(adv,n,vs) (col) (on-mim) exhausted/lovestruck/logy/
でれでれ /(adv,n,vs) (on-mim) exhausted/lovestruck/logy/fawning/mooning/
でんぐり返る [でんぐりがえる] /(v5r,vi) to turn a somersault/to turn over (topsy-turvy)/to turn head over heels/
でんと /(adv) imposingly/heavily/conspicuously/in a dignified manner/
でん粉 [でんぷん] /(n) starch/
で御座います [でございます] /(exp) (uk) (pol) to be (copula)/
で御座ります [でござります] /(exp) (arch) (pol) to be (copula)/
で御座る [でござる] /(v5aru) (uk) (pol) to be/
で候 [でそう] /(aux) (pol) (arch) to be/
で成らない [でならない] /(exp,adj-i) (uk) unable to resist/unable to supress/
と /(prt,conj) (1) if/when/(2) and/(3) with/(4) particle used for quoting (with speech, thoughts, etc.)/(n) (5) (abbr) promoted pawn (shogi)/(P)/
とあって /(conj) due to the fact that/because of/
とあらば /(conj) if it is the case that/if/
とあれば /(conj) if it is the case that/if/
といったらない /(exp) (col) (used after adj.) nothing more ... than this/as .... as it could possibly be/
といっても過言ではない [といってもかごんではない] /(exp,adj-i) it is no exaggeration to say/it is not too much to say/
とうの昔 [とうのむかし] /(exp,n-t) a long time ago/
とう嚢炎 [とうのうえん] /(n) navicular disease/navicular syndrome/
とう鞳 [とうとう] /(adj-t,adv-to) (1) (uk) sound of bells or drums reverberating/(2) (uk) sound of water or waves resounding/
とか /(prt,conj) among other things/such things as/or something like that/(P)/
とき /(n) regular (stops at every station) Jouetsu-line Shinkansen/
ときの声 [ときのこえ] /(n) war cry/battle cry/
ときめき /(n) palpitation/throbbing/
ときめく /(v5k,vi) to throb/to flutter/to palpitate/
とき卵 [ときたまご] /(n) beaten egg/eggwash/
とぎまぎ /(n,vs) confusion/bewilderment/embarrassment/
とぎ汁 [とぎしる] /(n) water that has been used to wash rice/
とぎ汁 [とぎじる] /(n) water that has been used to wash rice/
とく /(v5k) to do something in readiness for/to get something (needful) done/
とくだま /(n) Tokudama plantation lily/Hosta tokudama/
とくとく /(adv-to,adv) (on-mim) glug-glug/
とくの昔 [とくのむかし] /(exp,n-t) (obsc) a long time ago/
とぐろを巻く [とぐろをまく] /(exp,v5k) (1) to coil itself (e.g. a snake)/(2) to loaf around/
とけ込む [とけこむ] /(v5m,vi) (1) to melt into/to merge into/(2) to fit in/to adapt/to blend/
とことこ /(adv,adv-to) (on-mim) briskly with small steps/trotting/
とことん /(adv,n) (to) the end/thoroughly/
ところがどっこい /(exp) funny you should mention that/
ところてん式に [ところてんしきに] /(adv) systematically/in turn/
ところを /(prt,conj) although (it is a certain time or something is in a certain condition)/(P)/
ところ狭し [ところせし] /(adv-to) crowded/overflowing/cramped/
ところ狭し [ところせまし] /(adv-to) crowded/overflowing/cramped/
とこを /(prt,conj) although (it is a certain time or something is in a certain condition)/
とさかに来る [とさかにくる] /(exp,v5r) to get mad/
とされる /(exp) ... is considered to .../
としたら /(conj) if it happens that/if we make .../if we take .../if we assume .../
としちゃ /(exp) as (for)/for/in the capacity of/
としちゃあ /(exp) as (for)/for/in the capacity of/
として /(exp) (1) as (i.e. in the role of)/for (i.e. from the viewpoint of)/(2) apart from... (used to change the topic)/(3) (before a negative form) even (e.g. "not even a single person")/(4) (after a volitional form) thinking that.../trying to.../(P)/
としては /(exp) as (for)/for/in the capacity of/
としても /(prt) assuming .../even if .../(P)/
とじ針 [とじばり] /(n) large sewing needle/wool needle/
とする /(exp,vs-i) (1) to try to .../to be about to do .../(2) to decide to .../(3) to take as/to treat as/(4) to use for/(5) to suppose that (such) is the case/to assume/(6) to decide that/to think that/(7) to make into/to change into/(8) to feel (e.g. after sound symbolism or psychological experience word)/to look/to feel like/(9) to intend/to have the intention/
とすると /(conj) if we make .../if we take .../if we assume .../(P)/
とすれば /(conj) if it happens that/if we make .../if we take .../if we assume .../(P)/
とちる /(v5r,vt) (1) to flub (one's lines)/(v5r,vi) (2) to be flustered/to be confused/
とち狂う [とちくるう] /(v5u,vi) to be playful/to gambol/to be amused (with something)/to play/to sport/to frolic/to joke/
とち狂う [とちぐるう] /(v5u,vi) to be playful/to gambol/to be amused (with something)/to play/to sport/to frolic/to joke/
とっくの昔 [とっくのむかし] /(exp,n-t) a long time ago/
とったり /(n) arm bar throw (sumo)/
とっちる /(v1,vi) to be flustered/to be confused/
とっと /(n) (chn) fish/bird/
とっとと /(adv) quickly/hurriedly/
とっぷり /(adv,adv-to) (on-mim) completely/fully/entirely/
とっぽい /(adj-i) (col) pompous/affected/fresh/
とて /(prt) (1) even/(2) even if/even though/(3) because of/on the grounds that/
とと /(n) (chn) fish/bird/
とどの詰まり [とどのつまり] /(exp,adv) final outcome/final result/consequence/upshot/in the end/after all is said and done/
とどまるところを知らない [とどまるところをしらない] /(exp) knowing no bounds/showing no signs of stopping or slowing down/
とどめを刺す [とどめをさす] /(exp,v5s) (1) to finish off/to ensure (something) is dead/to deliver the coup de grace/(2) to put an end to/to deliver the final blow/(3) to be the best for A/
となく /(suf,exp) adds vagueness and indirectness to the word or phrase it is used with/
となったら /(exp) where ... is concerned/when it becomes/if it becomes/(P)/
となりのサインフェルド /(n) Seinfeld (TV Show)/
となりの芝生は青い [となりのしばふはあおい] /(exp) the grass is always greener on the other side/
となる /(exp) to become/to amount to/
となるために /(exp) (1) in order to be(come).../(2) since it amounts to.../(3) since it is advantageous to.../
となると /(exp) where ... is concerned/when it comes to .../if it comes to .../as far as ... is concerned/(P)/
となれば /(exp) where ... is concerned/when it becomes/if it becomes/(P)/
とは /(prt) indicates word or phrase being defined/(P)/
とは言うものの [とはいうものの] /(exp) (uk) having said that/be that as it may/(P)/
とは言え [とはいえ] /(conj) (uk) though/although/be that as it may/nonetheless/
とは限らない [とはかぎらない] /(exp) not necessarily so/is not always true/
とは別に [とはべつに] /(adv) in addition to/apart from/
とば口 [とばくち] /(n) (1) entrance/threshold/(2) beginning/first step/start/
とびえい /(n) (uk) Japanese eagle ray (Myliobatis tobijei)/
とびっきり /(adj-no,adv) extraordinary/superior/choice/
とびっこ /(n) flying fish roe/
とび出る [とびでる] /(v1,vi) (1) to project/to protrude/to pop out (e.g. eyes)/(2) to jump out/to rush out/
とび職 [とびしょく] /(n) scaffolding or construction worker/steeplejack/
とび職人 [とびしょくにん] /(n) scaffold constructor/steeplejack/
とび色 [とびいろ] /(n) reddish brown/
とべ /(n) (sl) last (in a contest)/
とぼとぼ /(adv) (on-mim) totteringly/trudgingly/
とまれ /(adv) anyway/in any case/
とみて星 [とみてぼし] /(n) Chinese "Emptiness" constellation (one of the 28 mansions)/
とも /(suf,prt) (1) certainly/of course/to be sure/rather/(2) even if/no matter (who, what, when, where, why, how)/(3) at the (least, earliest, etc.)/(P)/
ともあろうもの /(exp) of all people (expression showing surprise at a high standing person's misbehavior)/
ともし火 [ともしび] /(n) light/lamp/torch/
ともすると /(exp,adv) (on-mim) apt to (do)/liable to/prone to/
ともすれば /(adv) apt to (do)/liable to/prone to/
ともろく /(n) (abbr) (sl) Internet friend or buddy list/
とも言う [ともいう] /(exp) also called/
とも星 [ともぼし] /(n) Chinese "root" constellation (one of the 28 mansions)/
とも無く [ともなく] /(exp) (uk) phrase used to express the uncertainty or lack of intent in what precedes it/
とも無しに [ともなしに] /(exp) (uk) to do something without any particular intention or mind to do so/
とやかく言う [とやかくいう] /(exp,v5u) to say all kinds of things/to complain/to find fault (with)/
とやら /(prt) indicates uncertainty or second hand nature of information quoted/
とらの子 [とらのこ] /(n) (1) tiger cub/(2) treasure (as it is said that tigers treasure their young)/
とりの日 [とりのひ] /(n) Bird Day/Day of the Bird/
とりむね肉 [とりむねにく] /(n) chicken breast meat/
とり囲む [とりかこむ] /(v5m,vt) to surround/to crowd around/
とり貝 [とりがい] /(n) Japanese egg cockle (Fulvia mutica)/
とり結ぶ [とりむすぶ] /(v5b,vt) (1) to make (a promise)/to conclude (a contract)/(2) to act as a go-between/to act as mediator/(3) to curry favour with/
とり出す [とりだす] /(v5s,vt) (1) to take out/to produce/to pick out/(2) to fetch/to retrieve/
とり払う [とりはらう] /(v5u,vt) to clear away/to remove/to demolish/
とり戻す [とりもどす] /(v5s,vt) to take back/to regain/to get back/to recover/
とる /(v5r) is being/
とるに足りない [とるにたりない] /(exp,adj-i) of little importance/trivial/worthless/valueless/
とろ /(n) fatty, more expensive tuna meat/(P)/
とろい /(adj-i) slow (slightly pejorative)/dull/stupid/
とろき星 [とろきぼし] /(n) Chinese "Turtle Beak" constellation (one of the 28 mansions)/
とろくさい /(adj-i) (derog) dull/slow/stupid/
とろっと /(vs) (1) to become syrupy/to become thick (e.g. when cooking)/(adv) (2) stickily/
とろとろ /(adj-na,adv,n,vs) (1) (on-mim) dozing/drowsily/(2) simmering/(3) sticky/syrupy/(4) oily/brimming with melted fat/
とろり /(adv-to,adv) (1) (on-mim) thick/viscous/(2) (on-mim) sleepy/
とろろ芋 [とろろいも] /(n) yam/
とろろ昆布 [とろろこぶ] /(n) (1) (uk) shredded kombu/(2) Kjellmaniella gyrata (species of kelp)/
とろろ昆布 [とろろこんぶ] /(n) (1) (uk) shredded kombu/(2) Kjellmaniella gyrata (species of kelp)/
とろん /(adv-to) (on-mim) appearing drowsy or intoxicated (of eyes, actions, etc.)/
とろ火 [とろび] /(n) low flame (heat, gas)/
とん /(adv-to,adv) (on-mim) tap/knock/bonk/
とんかち /(n) (col) hammer/
とんがり帽子 [とんがりぼうし] /(n) pointy hat/
とんずら /(n,vs) (sl) fleeing/escape/
とんだ /(adj-pn) (1) unthinkable/unimaginable/inconceivable/unexpected/(2) terrible/awful/serious/(adv) (3) (arch) very/(P)/
とんでもありません /(adj-f) (1) unthinkable/unexpected/outrageous/offensive/(exp) (2) (col) absolutely not!/not at all!/far from it!/impossible!/preposterous!/what a thing to say!/no way!/bullshit/(3) don't mention it/you're welcome/
とんでもございません /(adj-f) (1) unthinkable/unexpected/outrageous/offensive/(exp) (2) (col) absolutely not!/not at all!/far from it!/impossible!/preposterous!/what a thing to say!/no way!/bullshit/(3) don't mention it/you're welcome/
とんでも無い [とんでもない] /(adj-f) (1) (uk) unthinkable/unexpected/outrageous/offensive/(exp) (2) (col) (uk) absolutely not!/not at all!/far from it!/impossible!/preposterous!/what a thing to say!/no way!/bullshit/(3) (uk) don't mention it/you're welcome/
とんとん /(adj-na,adv,n,adv-to) (on-mim) tap/rap-tap/tapping/(P)/
とんとん拍子 [とんとんびょうし] /(adv) without a hitch/swimmingly/with rapid strides/
とんど /(n) burning of New Year's gate decorations (usu. on the 15th day of the new year)/
とんぶり /(n) belvedere fruit/field caviar/land caviar/mountain caviar/kochia seed/
とんぼ返り [とんぼがえり] /(n,vs) (1) somersault/(2) returning from a destination right after arriving there/non-stop round trip/round trip without an overnight stop/(3) abrupt change of direction/
と或る [とある] /(adj-pn) (uk) a certain .../
と仮定して [とかていして] /(exp) assuming that .../supposing that .../
と仮定しても [とかていしても] /(exp) even assuming that .../even granted that .../
と覚しい [とおぼしい] /(exp,adj-i) (uk) thought to be/seen as/
と共に [とともに] /(exp) together with/
と金 [ときん] /(n) promoted pawn (shogi)/
と見られる [とみられる] /(exp,v1) (followed by verb) believed to/expected to/feared to/poised to/considered to/likely to/
と言う [という] /(exp) (uk) said/called thus/
と言うか [というか] /(exp,adv) or perhaps I should say/or, how should I put it,..../
と言うことだ [ということだ] /(exp) (1) I've heard that .../rumour has it that .../(2) it appears as if .../
と言うことは [ということは] /(exp,adv) (uk) that is to say/so that means/
と言うことはない [ということはない] /(exp) (uk) it is not possible (to, that)/there is no such thing as/(P)/
と言うと [というと] /(conj) (1) (uk) if one were to speak of ..., then certainly/if it were the case that ..., then certainly/if it were a ..., then certainly/phrase used to indicate the inevitability of what follows it (based on what precedes it)/(2) so that means (when used in sentence-initial position)/
と言うところ [というところ] /(exp) (1) (uk) a state called/a position described as/can sum up as/approximates to/(2) places known as/that called/(3) the place named/
と言うところ [とゆうところ] /(exp) (1) (uk) a state called/a position described as/can sum up as/approximates to/(2) places known as/that called/(3) the place named/
と言うのに [というのに] /(exp) even though/despite/when/
と言うのは [というのは] /(exp) (1) (uk) means/is/(2) because (often with kara)/that is to say/
と言うのも [というのも] /(exp) because/
と言うもの [というもの] /(exp) (uk) something like .../something called .../(P)/
と言うより [というより] /(exp) rather than/
と言う所 [というところ] /(exp) (1) (uk) a state called/a position described as/can sum up as/approximates to/(2) places known as/that called/(3) the place named/
と言う所 [とゆうところ] /(exp) (1) (uk) a state called/a position described as/can sum up as/approximates to/(2) places known as/that called/(3) the place named/
と言う物 [というもの] /(exp) (uk) something like .../something called .../
と言う訳だ [というわけだ] /(exp) this is why/this means/
と言えど [といえど] /(exp) be (that) as it may/having said that/
と言えなくもない [といえなくもない] /(exp) (one) could even say that/
と言えなくも無い [といえなくもない] /(exp) (one) could even say that/
と言えば [といえば] /(exp) speaking of/
と言った [といった] /(conj) (uk) such ... as/or some such/
と言ったら嘘になる [といったらうそになる] /(exp,v5r) I'd be lying if I said .../
と言って [といって] /(exp) however/because/as/
と言ってきかない [といってきかない] /(exp) insisting/
と言ってしまえばそれまで [といってしまえばそれまで] /(exp) it is certain true that ... (but)/you can't argue that it's not ... (but)/
と言っても [といっても] /(conj) (uk) although I say/although one might say/although called/(P)/
と言ってもいい [といってもいい] /(exp) you could say/you might say/verging on the/
と言ってもよい [といってもよい] /(exp) you could say/you might say/verging on the/
と言っても過言ではない [といってもかごんではない] /(exp,adj-i) it is no exaggeration to say/it is not too much to say/
と言っても良い [といってもいい] /(exp) you could say/you might say/verging on the/
と言っても良い [といってもよい] /(exp) you could say/you might say/verging on the/
と言って聞かない [といってきかない] /(exp) insisting/
と言われる [といわれる] /(exp,v1) to be called .../to be referred to as .../
と公言してはばからない [とこうげんしてはばからない] /(exp,adj-i) have no hesitation in stating (declaring)/
と考えられる [とかんがえられる] /(exp,v1) one can think that .../it is conceivable that .../
と思しい [とおぼしい] /(exp,adj-i) (uk) thought to be/seen as/
と思われる [とおもわれる] /(exp,v1) be considered/be deemed/thought to be/
と畜場 [とちくじょう] /(n) abattoir/slaughterhouse/
と同じように [とおなじように] /(exp) in the same way as/just like/
と同じ様に [とおなじように] /(exp) in the same way as/just like/
と比べて [とくらべて] /(exp) compared with/
と来たら [ときたら] /(exp) (uk) when it comes to .../concerning/where ... are concerned/
ど /(pref) (1) (ksb:) precisely/exactly/plumb/totally/very/(2) derogatory prefix used before nouns & adjectives/
どう /(int) whoa (command used to stop a horse, etc.)/
どう /(ok) (pref) (1) (ksb:) precisely/exactly/plumb/totally/very/(2) derogatory prefix used before nouns & adjectives/
どういう風に [どういうふうに] /(exp) in what way (do you mean)/
どういう風の吹き回しか [どういうかぜのふきまわしか] /(exp) whatever brought that on?/
どうか /(adv,n) please/somehow or other/
どうかした /(exp) by mere chance/by some chance/somehow or other/in some way/
どうかしたのか /(exp) is something up?/is something wrong?/
どうかしたのですか /(exp) is something up?/is something wrong?/
どうかしたんですか /(exp) is something up?/is something wrong?/
どうかして /(exp) by mere chance/by some chance/somehow or other/in some way/
どうかすると /(exp) there is a tendency/there is a possibility/
どうかと言うと [どうかというと] /(exp) if you ask me .../as for .../
どうかと思う [どうかとおもう] /(exp,v5u) to doubt/to have a problem with/to think badly of/
どうかな /(exp) (1) how about ...?/(2) I wonder/I don't know/
どうしたって /(adv) (col) by all means/no matter what/at any rate/
どうしたの /(adj-f) what's the matter?/what's wrong?/
どうしたもの /(exp) (col) what's up with/what's the deal with/what's to be done with/
どうしたもん /(exp) (col) what's up with/what's the deal with/what's to be done with/
どうしたら /(exp) how can (we, I, et al. do something)/
どうしたら良い [どうしたらいい] /(exp,adj-i) (uk) what's the best thing to do?/
どうしたら良い [どうしたらよい] /(exp,adj-i) (uk) what's the best thing to do?/
どうしたん /(adj-f) what's the matter?/what's wrong?/
どうした風の吹き回しか [どうしたかぜのふきまわしか] /(exp) whatever brought that on?/
どうしてる /(exp) How did you like ...?/How about ...?/What's going on?/How's it going?/
どうしますか /(exp) what would (you) do?/what to do about it/
どうしょう /(ik) (exp) what to do/
どうしよう /(exp) what to do/
どうするか /(exp) what would (you) do?/what to do about it/
どうせ /(adv) anyhow/in any case/at any rate/after all/at best/at most/at all/(P)/
どうせなら /(conj) (if you want to do something) you might as well/
どうぞ /(adv) (1) please/kindly/(2) by all means/(P)/
どうぞ宜しく [どうぞよろしく] /(exp) (uk) pleased to meet you/
どうだい /(exp) How did you like ...?/How about ...?/What's going on?/How's it going?/
どうだっていい /(exp) inconsequential/indifferent/not worth worrying about/whatever you do is OK/trivial/
どうってことはない /(exp) nothing special/no big deal/doesn't matter/
どうであれ /(conj) however/whatever/
どうであろうと /(exp) whatever (the case may be)/
どうでもいい /(exp) inconsequential/indifferent/not worth worrying about/whatever you do is OK/trivial/(P)/
どうと /(adv) (on-mim) crash/smash/bang/sound of a large, heavy object falling/
どうということはない /(exp) nothing special/no big deal/doesn't matter/
どうということもない /(exp) nothing special/no big deal/doesn't matter/
どうど /(ok) (adv) (on-mim) crash/smash/bang/sound of a large, heavy object falling/
どうどう /(int) whoa, whoa (command used to stop or quiet down a horse, etc.)/
どうどうと /(adv) (on-mim) with roaring sound/
どうにか /(adv,vs) in some way or other/one way or another/(P)/
どうにかこうにか /(exp) somehow or other/
どうにかして /(exp) by any means (possible)/somehow/
どうにもならない /(exp) helpless/futile/situation about which nothing can be done/(P)/
どうも /(int) (1) (abbr) thanks/(adv) (2) much (thanks)/very (sorry)/quite (regret)/(3) quite/really/(4) somehow/(5) no matter how hard one may try/(int) (6) greetings/hello/goodbye/(P)/
どうも有難う [どうもありがとう] /(exp) Thank you/(P)/
どうも有難うございます [どうもありがとうございます] /(exp) thank you very much/
どうやったら /(exp) how (can)/by what means/
どうやったらいい /(exp) what one should do (usu. in questions)/
どうやって /(exp) how/in what way/by what means/
どうやら /(adv) it seems like/it appears that/somehow or other/(P)/
どうやらこうやら /(exp) somehow or other/
どうゆう風に [どうゆうふうに] /(exp) in what way (do you mean)/
どう言う [どういう] /(adj-pn) (uk) somehow/how/in what way/why/what kind of/
どう言う風に [どういうふうに] /(exp) in what way (do you mean)/
どう言う風に [どうゆうふうに] /(exp) in what way (do you mean)/
どう仕様もない [どうしようもない] /(exp,adj-i) (uk) it cannot be helped/there is no other way/
どう仕様も無い [どうしようもない] /(exp,adj-i) (uk) it cannot be helped/there is no other way/
どう致しまして [どういたしまして] /(int) (uk) you are welcome/don't mention it/not at all/my pleasure/(P)/
どう猛 [どうもう] /(adj-na,n) ferocity/truculence/
どかっと /(adv) (on-mim) thuddingly/plumping down (like a heavy weight)/
どかと /(adv) (on-mim) thuddingly/plumping down (like a heavy weight)/
どかどか /(adv,adv-to) (1) (on-mim) noisily/with loud footsteps/(2) in a crowd/incessantly/all together/
どかり /(adv-to,adv) (on-mim) falling heavily/
どかん /(adv,adv-to) (on-mim) with a bang/
どか食い [どかぐい] /(n,vs) eating a lot/excessive eating/
どきっと /(adv,n,vs) (on-mim) feeling a shock/startling/(P)/
どきつく /(v5k,vi) to palpitate (with anxiety, etc.)/
どきどき /(adv,n,vs) (on-mim) throb/beat (fast)/(P)/
どきり /(adv,adv-to,vs) (on-mim) feeling shocked or startled/
どきんと /(adv,n,vs) (on-mim) feeling a shock/startling/
どぎつい /(adj-i) gaudy/loud/garish/violent/harsh/
どぎまぎ /(n,vs,adv) flurried/in a flutter/upset/nervous/
どく /(v5k) to do something in readiness for/to get something (needful) done/
どくどく /(adv,adv-to) (on-mim) gushingly/copiously/profusely/in a steady stream/
どくろマーク /(n) skull and crossbones/
どけち /(n,adj-na) (uk) cheapskate/very miserly/
どこからともなく /(exp) suddenly (appears) out of nowhere/
どこであれ /(conj) whereever/
どこのどいつ /(exp) Who on earth?/
どこへともなく /(exp) suddenly disappears somewhere/
どころ /(prt) particle used to indicate that what precedes it is an extreme example and strongly negates it/
どこ吹く風 [どこふくかぜ] /(exp) something that doesn't concern one at all/
どさくさ /(n,adv) confusion/turmoil/
どさくさ紛れに [どさくさまぎれに] /(exp,adv) in the confusion of the moment/taking advantage of the confused state of affairs/
どさっと /(adv) (on-mim) with a thud/
どさどさ /(adv,adv-to,vs) (1) (on-mim) throwing down multiple objects in succession/(2) at once in great numbers/
どさり /(adv-to) with a thud/
どさ回り [どさまわり] /(n) touring/on the road/
どさ回りをやる [どさまわりをやる] /(exp,v5r) to go on tour/to be on the road (e.g. theatre troupe) (theater)/
どしどし /(adv) (on-mim) rapidly/constantly/one after the other/without hesitation/sound of tramping/(P)/
どしゃ降り [どしゃぶり] /(n) downpour/pouring rain/cloudburst/pelting rain/heavy rain/
どしり /(adv-to,adv) sound of an heavy object falling/
どしん /(adv-to,adv) (on-mim) plump/with a thud/heavily/
どしんどしん /(adv-to) (on-mim) walking (with heavy steps)/tramping/lumbering/clumping/
どじ /(adj-na,n) blunder/bungle/clumsiness/
どじる /(v5r) to fail/to mess up/to bungle/to screw the pooch/
どじを踏む [どじをふむ] /(exp,v5m) to bungle/to make a blunder/
どすこい /(n) sumo exclamation/
どすっ /(adv-to) kerplunk/smack/bang/
どすん /(int,adv-to) (on-mim) bam/whomp/thump/
どす黒い [どすぐろい] /(adj-i) darkish/dusky/
どたどた /(adv,adv-to,vs) (on-mim) noisily (esp. the noise of heavy feet)/
どたばた /(adv,adv-to,vs) (1) (on-mim) noisily (esp. the noise of heavy feet)/(n) (2) (abbr) slapstick/(P)/
どたばた喜劇 [どたばたきげき] /(n) slapstick comedy/
どたりと /(adv) (on-mim) with a flop/flump/plump/
どたん /(adv-to,adv) (on-mim) thud/
どたキャン /(n,vs) (abbr) last-minute cancellation/
どちみち /(n) whichever/whatever/
どちらか /(n) either/one (of the two)/
どちらかと言うと [どちらかというと] /(exp) (uk) if pushed I'd say/if I had to say then/
どちらかと言えば [どちらかといえば] /(exp) if pushed I'd say/if I had to say then/
どちらにしても /(exp) either way/in any case/one way or another/
どちらにしろ /(exp) whichever one one chooses/either way/
どちらにせよ /(exp) in either case (used specifically in the instance of two possible outcomes or situations)/either way/one way or another/(P)/
どちら共 [どちらとも] /(n) (uk) both/
どちら様 [どちらさま] /(exp) (1) (hon) (id) who are you?/(n) (2) (hon) who/
どち狂う [どちぐるう] /(v5u,vi) to be playful/to gambol/to be amused (with something)/to play/to sport/to frolic/to joke/
どっかと /(adv) (on-mim) with a thump/floppingly/
どっかり /(adv-to) (on-mim) plunk (down something heavy)/flump (into a chair)/
どっきり /(adv,adv-to,vs) (on-mim) feeling shocked or startled/
どっきりカメラ /(n) candid-camera/candid-camera footage/
どっこい /(exp) heigh-hoh/heave-ho/hold on!/just a minute/
どっこいどっこい /(adj-na) about the same/about equal to/close match/
どっさり /(adv,adv-to) (on-mim) lot of/heaps/
どっしり /(adv,n,vs,adv-to) (on-mim) bulky and heavy/massive/massy/substantial/
どっちか /(n) either/one (of the two)/
どっと /(adv) (on-mim) suddenly/
どっぴゅ /(adv,adv-to) (on-mim) sound of something being powerfully ejected/
どっぷり /(adj-na,adv,adv-to) (on-mim) totally (immersed in something, e.g. liquid, work)/addicted/
どっぷりと漬かる [どっぷりとつかる] /(exp,v5r) to be deeply submerged/
どつぼ /(adj-na) state of profound sadness/
どでかい /(adj-i) huge/gargantuan/
どないしたん /(exp) (osb:) what's the matter?/
どなたか /(n) (hon) someone/
どなり立てる [どなりたてる] /(v1) to stand and shout/
どの位 [どのくらい] /(exp,n,n-adv) (uk) how long/how far/how much/(P)/
どの位 [どのぐらい] /(exp,n,n-adv) (uk) how long/how far/how much/(P)/
どの場合にも [どのばあいにも] /(exp) in any case/in either case/whichever the case may be/
どの道 [どのみち] /(adv) anyway/anyhow/at any rate/in any case/
どの辺 [どのへん] /(n) whereabouts/(P)/
どの面さげて [どのつらさげて] /(exp) How could I (you, etc.) ...?/How dare you (they, etc.) (have the nerve to) ...?/
どの面下げて [どのつらさげて] /(exp) How could I (you, etc.) ...?/How dare you (they, etc.) (have the nerve to) ...?/
どの様 [どのよう] /(exp,adj-na) how/
どの様なこと [どのようなこと] /(n) what kind (of thing)/
どぶ /(n) (abbr) unrefined sake/
どぶに捨てる [どぶにすてる] /(exp,v1) to throw down the drain/to waste/
どぶん /(adv,adv-to) (on-mim) plop/splash/
どぶ鼠 [どぶねずみ] /(n) (1) (uk) brown rat (Rattus norvegicus)/common rat/Norway rat/(2) dark grey (colour, color)/dark gray/(3) secret evil-doer/
どぶ漬 [どぶづけ] /(n) drenching/soaking/marinating/
どぶ板 [どぶいた] /(n) boards covering a ditch (drainage, sewage, etc.)/
どぼん /(adv,adv-to) (on-mim) plop/splash/
どや /(n) cheap lodging or flophouse, especially in a skid row area or slum/
どやし付ける [どやしつける] /(v1,vt) (1) (uk) to strike/to hit/(2) to give hell to/
どやす /(v5s) (1) to shout at/(2) (arch) to hit/to beat/
どやどや /(adv,adv-to) (on-mim) sound of many footsteps/
どや街 [どやがい] /(n) flophouse area/flophouse district/flophouse quarter/
どや顔 [どやがお] /(n) self-satisfied look/triumphant look/
どら /(n-pref,n) (1) loafing/indolent/lazy/debauched/profligate/(int) (2) hey/
どら焼き [どらやき] /(n) Japanese dessert consisting of two slices of kasutera (sponge cake) with red bean jam in between/
どら声 [どらごえ] /(n) gruff voice/
どら猫 [どらねこ] /(n) stray cat/
どれか /(n) (1) which one/(2) one of/any of/
どれだけ /(exp) how long/how much/to what extent/(P)/
どれでも /(n) any one/(P)/
どれにも /(exp) none (in sentence with negative verb)/
どれ位 [どれくらい] /(exp,n) (uk) how long/how far/how much/
どれ位 [どれぐらい] /(exp,n) (uk) how long/how far/how much/
どれ一つ [どれひとつ] /(exp) not one (in sentence with negative verb)/
どれ程 [どれほど] /(adv,n) (uk) how much (long, far)/
どろどろ /(adj-na,adv,n,adj-no) (on-mim) syrupy/muddled/(P)/
どろり /(adv,adv-to) (on-mim) thick (of a liquid)/muddy/gooey/
どろん /(n,vs) absconding/taking oneself off/slipping out (home) unnoticed early (e.g. from work, out of parties, etc.)/
どん /(pref) (1) very/totally/(2) polite suffix used after a person's name (often of an apprentice; used much more broadly in southern Kyushu)/(n,adv-to) (3) bang (e.g. of large drum, signal pistol, etc.)/with a thud/sound when slamming something down/
どんぐりの背比べ [どんぐりのせいくらべ] /(exp) having no outstanding characteristics (lit: height comparison among acorns)/to all seem about the same/bragging competition ("pissing contest") concerning matters of little importance/
どんけつ /(n) (uk) tail end/very bottom/the lowest rank/
どんだけ /(exp) what a ..... (word used to show strong emotion, emphasis, punchlines, etc.)/
どんちゃん騒ぎ [どんちゃんさわぎ] /(n) merrymaking/high jinks/spree/
どんつく /(v5k) to make a drumming noise/
どんでん返し [どんでんがえし] /(n) (sudden) complete reversal (of plot)/unexpected twist (at end of story)/
どんど /(n) burning of New Year's gate decorations (usu. on the 15th day of the new year)/
どんどん /(adv-to,adv) (1) (on-mim) drumming (noise)/(2) rapidly/steadily/(P)/
どんど焼 [どんどやき] /(n) burning of New Year's gate decorations (usu. on the 15th day of the new year)/
どんど焼き [どんどやき] /(n) burning of New Year's gate decorations (usu. on the 15th day of the new year)/
どんな /(adj-pn) (1) what/what kind of/(2) (with -temo, demo, etc.) any(body, thing, means, etc.)/(P)/
どんなに /(adv) how/how much/(P)/
どんぴしゃり /(int) exactly right!/dead on/
どんぶらこ /(adv,adv-to) (1) (on-mim) tumbling/
どんぶり /(adv,adv-to) (on-mim) plop/splash/
どんぶりこ /(adv,adv-to) (1) (on-mim) plop/splash/(2) (on-mim) tumbling/
どんより /(n,vs,adv) (1) heavy/leaden/dull/(2) glazed (eyes)/
どん詰まり [どんづまり] /(n) (uk) (dead) end/end of the line/
どん詰り [どんづまり] /(n) (uk) (dead) end/end of the line/
どん尻 [どんじり] /(n) tail end/tailender/
どん底 [どんぞこ] /(n) very bottom/
どアホ /(n) (uk) (ksb:) total idiot/fuck-wit/
ど阿呆 [どあほ] /(n) (uk) (ksb:) total idiot/fuck-wit/
ど阿呆 [どあほう] /(n) (uk) (ksb:) total idiot/fuck-wit/
ど偉い [どえらい] /(adj-i) immense/awesome/enormous/terrific/
ど演歌 [どえんか] /(n) quintessential enka/enka with age-old lyrical themes set to a haunting traditional-style melody/
ど下手 [どべた] /(n,adj-na) very unskillful/extremely awkward/
ど根性 [どこんじょう] /(n) utter gutsiness/
ど真ん中 [どまんなか] /(n,adj-no) (col) right in the center (centre)/
ど真中 [どまんなか] /(n,adj-no) (col) right in the center (centre)/
ど田舎 [どいなか] /(n) remote countryside/boondocks/the sticks/
ど頭 [どたま] /(n) (uk) (derog) head/dome/bean/nob/noggin/
ど突く [どつく] /(v5k) to jab/to hit/to punch/to stand out/
ど突く [どづく] /(ok) (v5k) to jab/to hit/to punch/to stand out/
ど忘れ [どわすれ] /(n,vs) lapse of memory/forgetting for a moment something one knows well/(something) slipping one's mind/
な /(prt) (1) (sentence end, mainly masc.) indicates emotion or emphasis/(2) (abbr) (used with masu stem verb) command/(3) (used with dictionary form verb) prohibition/(P)/
なあ /(int) (fam) hey/say/look/used to get someone's attention or press one's point/
なあなあ /(n) complicit/colluding/
ない /(aux-adj) (1) not (verb-negating suffix; may indicate question or invitation with rising intonation)/(suf,adj-i) (2) emphatic suffix (used after the root of an adjective)/(P)/
ないか /(exp) (1) (used to ask a question in the negative) won't (hasn't, isn't, doesn't, etc.)/(2) (used to make invitations, express desires or give indirect commands) won't you/
ないことには /(exp) (with verb stem) unless you do something/
ないちゃー /(n) (rkb:) person from any part of Japan that is not also part of Okinawa/
ないで /(conj,aux) (1) without doing .../(aux) (2) used in sentence-final position as an indirect prohibition/
ないでは居られない [ないではいられない] /(exp,adj-i) (uk) feel compelled to/can't help but feel/can't help but do/
ないと行けない [ないといけない] /(exp,adj-i) (1) (uk) (after negative base of verb) have to (verb)/must (verb)/(2) is indispensable/absolutely necessary/(P)/
ないと行けません [ないといけません] /(exp) (1) (uk) (after negative base of verb) have to (verb)/must (verb)/(2) is indispensable/absolutely necessary/
ないのではないか /(exp) I think (something) won't (something)/probably (something) isn't (something)/
ないよりはまし /(exp) better than a poke in the eye/better than none at all/
ないよりまし /(exp) better than a poke in the eye/better than none at all/
ない交ぜにする [ないまぜにする] /(exp,vs-i) to blend (e.g. truth and lies)/to mix together (e.g. kanji and kana)/
ない内に [ないうちに] /(exp) (after neg. stem of verb) before it becomes (verb)/before (an undesirable thing occurs)/
ない乳 [ないちち] /(n) (uk) (col) very small breasts/
なう /(suf,v5u) (after a noun, etc.) to do .../
なえ /(adv) (arch) accompanying/at the same time as/together with/
なえに /(adv) (arch) accompanying/at the same time as/together with/
なおこ /(n) long thin brown "naoko" mushroom/
なお更 [なおさら] /(adv) all the more/still less/
なお書 [なおがき] /(n) proviso/
なかば眠っている [なかばねむっている] /(exp,v1) to be half asleep/
なかろう /(exp) probably not so/
ながし眼 [ながしめ] /(n) (1) sidelong glance/(2) flirtatious glance/
ながし目 [ながしめ] /(n) (1) sidelong glance/(2) flirtatious glance/
ながら族 [ながらぞく] /(n) people who study or work while listening to the radio (or watching television, etc.)/
なぎ倒す [なぎたおす] /(v5s,vt) to mow down/to beat/to cut a swath/to sweep off one's feet/
なくても良い [なくてもいい] /(exp) (1) (after neg. stem of verb) need not (verb)/(not) have to/expressing absence of obligation or necessity/(2) need not have/need not exist/
なくても良い [なくてもよい] /(exp) (1) (after neg. stem of verb) need not (verb)/(not) have to/expressing absence of obligation or necessity/(2) need not have/need not exist/
なぐり倒す [なぐりたおす] /(v5s) to knock down/to knock out/
なけばならない /(exp) have to do/must/should/ought to/
なければいけない /(exp) have to do/must/should/ought to/(P)/
なければならない /(exp) have to do/must/should/ought to/(P)/
なければならぬ /(exp) have to do/must/should/ought to/
なければなりません /(exp) have to do/must/should/ought to/(P)/
なければなるまい /(exp) (after neg. verb stem) ought to (verb)/should (verb)/
なごりの雪 [なごりのゆき] /(n) (1) lingering snow/(2) snowfall at the end of the winter or the beginning of spring/
なごり雪 [なごりゆき] /(n) (1) lingering snow/(2) snowfall at the end of the winter or the beginning of spring/
なさい /(aux) do (imperative form often used after ~masu base of verbs)/
なしで済ます [なしですます] /(exp,v5s) to do without/
なし崩し [なしくずし] /(n) (1) paying back in installments (instalments)/amortization plan/(adv) (2) gradual reduction/little by little/
なじみ深い [なじみぶかい] /(adj-i) extremely intimate/very well-acquainted/
なすがまま /(exp) at someone's (something's) mercy/
なすり合い [なすりあい] /(n) recrimination/
なずらえ歌 [なずらえうた] /(n) allusive form (of waka)/
なせば成る [なせばなる] /(exp) (id) if you have a mind to do something, you can do it/if you do, it will become .../where there is a will.../
なぞ /(prt,n-suf) (col) et cetera/etc./and the like/and so forth/
なだれ込む [なだれこむ] /(v5m,vi) to rush or crowd into/to surge into/
なってない /(exp) to be unacceptable/
なつあし /(n) kanji radical 35 when at the bottom (as in the character for summer)/
なつい /(adj-i) (abbr) (sl) dear/desired/missed/
なつメロ /(n) (abbr) nostalgic melody/
なで回す [なでまわす] /(v5s) to pat (e.g. dog)/to rub/to stroke/to fondle/
なにかいい手はないか [なにかいいてはないか] /(exp) what would be a good way to do it?/
なに食わぬ顔 [なにくわぬかお] /(exp) innocent look/nonchalant look/air of innocence/
なの /(aux) (fem) (col) feminine copula/
なのだ /(aux) it is assuredly that .../can say with confidence that .../
なのである /(aux) it is assuredly (that).../can say with confidence that it is.../
なのです /(aux) it is assuredly that .../can say with confidence that .../
なのに /(conj) and yet/despite this/but even so/but even then/however/nevertheless/for all that/notwithstanding that/
なはる /(v4r,aux-v) (hon) (arch) to do/
なぶり殺し [なぶりごろし] /(n) torture to death/torment to death/
なへに /(adv) (arch) accompanying/at the same time as/together with/
なべに /(adv) (arch) accompanying/at the same time as/together with/
なべ物 [なべもの] /(n) stew/food cooked in a pot/
なまこ板 [なまこいた] /(n) corrugated iron sheet/
なまこ板 [なまこばん] /(n) corrugated iron sheet/
なまめ星 [なまめぼし] /(n) Chinese "Wall" constellation (one of the 28 mansions)/
なまり節 [なまりぶし] /(n) boiled and half-dried bonito/
なま足 [なまあし] /(n) (sl) bare legs/bare feet/
なみなみ /(adv,adv-to) to the brim/
なめし革 [なめしがわ] /(n,adj-no) (1) leather/tanned animal hide/suede/(2) kanji "tanned leather" radical (radical 178)/
なよなよ /(adv-to,adv,vs) delicately/weakly/gently/supplely/
なら /(aux) (1) if/in case/if it is the case that/if it is true that/(2) as for/on the topic of/(conj) (3) (col) (abbr) if that's the case/if so/that being the case/(P)/
ならず者 [ならずもの] /(n,adj-no) ruffian/scamp/hooligan/
ならず者国家 [ならずものこっか] /(n) rogue nation/rogue state/
ならでは /(n-suf) but/except/without/but for/
ならではの /(exp,aux) distinctive of/characteristic of/uniquely applying to/special to/
ならともかく /(exp) it's different when ... but/it's not so bad when ... but/
ならない /(exp) (1) cannot help (doing, etc.)/irresistibly/unbearably/(2) must not do/bad/wrong/not good/(P)/
ならぬ /(exp) (1) cannot help (doing, etc.)/irresistibly/unbearably/(2) must not do/bad/wrong/not good/
ならば /(aux) (1) if/in case/if it is the case that/if it is true that/(conj) (2) (col) (abbr) if that's the case/if so/that being the case/(3) if possible/if circumstances allow/(P)/
なり /(prt) (1) or/whether or not/(2) (after dictionary form verb) as soon as/right after/(3) (after past tense verb) while still/with previous state still in effect/(P)/
なりけり /(exp,aux-v) (arch) auxiliary verb indicating the speaker's personal recollection or something they've heard (e.g. "was", "wasn't it?", "is said to have ...", etc.)/
なりに /(prt) in one's own way or style/(P)/
なる /(suf,adj-f) (1) (arch) that is in/(2) who is called/that is called/(3) that is/
なれど /(conj) but/however/
なれども /(conj) (arch) but/however/
なれの果て [なれのはて] /(exp) the mere shadow of one's former self/the ruin of what one once was/
なれ合い [なれあい] /(n) collusion/conspiracy/illicit intercourse/liaison/
なれ鮨 [なれずし] /(n) (uk) old-style fermented sushi (pickled in brine rather than vinegar)/
なわ編み [なわあみ] /(n) cable stitch/
なわ編み針 [なわあみばり] /(n) cable needle (knitting)/
なをん /(n) (col) woman/
なんか /(exp,suf) things like .../or something like that ... (often derogatory)/(P)/
なんくるない /(exp) (rkb:) don't worry - be happy/
なんじゃそりゃ /(exp) (col) what's that?/
なんじゃらほい /(int) What!/
なんぞ /(prt,n-suf) (col) et cetera/etc./and the like/and so forth/
なんたらかんたら /(exp) something or other (often used in place of a word or phrase that has been forgotten)/
なんだ /(aux) it is assuredly that .../can say with confidence that .../
なんだよおい /(int) What!/
なんちゃって /(int) (1) (col) just kidding!/(pref) (2) fake/
なんて /(suf) (1) such as/(things) like/(2) exclamation/(P)/
なんてこった /(exp) (col) Oh no!/Holy cow!/Damn!/
なんて目じゃない [なんてめじゃない] /(exp) it's not a problem/it's not a big deal/(person or thing) can be easily beaten or bettered (by one)/
なんです /(aux) it is assuredly that .../can say with confidence that .../
なんでも屋 [なんでもや] /(n) (1) Jack of all trades/(2) general merchant/
なんでよっ /(adv) Why?/Why not?/What for?/What's wrong?/
なんでよつ /(adv) Why?/Why not?/What for?/What's wrong?/
なんど /(prt,n-suf) (col) et cetera/etc./and the like/and so forth/
なんにしても /(exp) even so/
なんやかんや /(n) one thing or another/this and that/something or another/
に /(prt) indicates such things as location of person or thing, location of short-term action, etc./(P)/
にあっては /(conj) in/on/at/during/in the condition of/(P)/
にいにい蝉 [にいにいぜみ] /(n) (uk) Kaempfer cicada (Platypleura kaempferi)/
にかけて /(exp) (1) till/to/over (a period)/through (e.g. Monday through Thursday)/about (approx. time or place)/on/(2) concerning (an area of expertise)/(3) to swear by (one's sword, God, etc.)/(P)/
にかけては /(exp) when it comes to/at home with/being a master of/being clever at/
にかたくない /(exp) not hard to... (in certain circumstances, it would be possible)/
にかわって /(exp) (1) instead of/replacing/(2) on behalf of/
にかわり /(exp) (1) instead of/replacing/(2) on behalf of/
にきび面 [にきびづら] /(n) face covered with pimples/
にこっと /(adv) pleasantly smiling/
にこっと笑う [にこっとわらう] /(exp,v5u) to smile pleasantly/
にこぽん /(n) (1) backslapping/a smile and a tap on the shoulder/(2) backslapper/someone who smiles and gives you a slap on the shoulder/someone who wins people over/
にこやか /(adj-na,n) smiling/(P)/
にこよん /(n) day laborer (slang term)/
にこり /(adv,adv-to) (on-mim) smile (sweetly)/grin/
にしおおのすり /(n) (uk) long-legged buzzard (Buteo rufinus)/
にして /(exp) (1) only/just because/(2) although/even/(3) at (place, time)/in (time span)/
にしては /(exp) for (e.g. "she dances well for an eight-year old")/considering it's (something or someone)/
にしても /(exp) even if/(P)/
にして置く [にしておく] /(exp,v5k) (uk) to leave as/to view as/to maintain the status quo/
にしろ /(exp) though/even if/whether ... or .../
にじみ出る [にじみでる] /(v1,vi) to exude/to ooze/to seep out/
にじり寄る [にじりよる] /(v5r,vi) to sidle up to/
にじり口 [にじりぐち] /(n) small door which leads into a tea ceremony hut/
にする /(exp,vs-i,vt) (1) to place, or raise, person A to a post or status B/(2) to transform A to B/to make A into B/to exchange A for B/(3) to make use of A for B/to view A as B/to handle A as if it were B/(4) to feel A about B/(5) to decide (on something)/
にせよ /(exp) granted that/even if/even though/
にせ医者 [にせいしゃ] /(n) quack/quack doctor/fake doctor/
にたつく /(v5k,vi) to have (break out into) a broad (suggestive) grin/
にたにた /(adv,n,vs) (on-mim) broad grin/
にたり /(adv-to) smirkingly/smugly/broadly/
にちゃにちゃ /(adv,n,vs) slimy/
にっこり /(adv,n,vs,adv-to) (on-mim) smile sweetly/smile/grin/(P)/
にっこり笑う [にっこりわらう] /(exp,v5u) to smile cheerfully/to crack a smile/
にて /(prt) indicates location of action (formal literary form of "de")/at/in/(P)/
になって初めて [になってはじめて] /(exp) (it was) not until/(it was) only when/
になる /(suf) (1) becomes/will become/turns out/(2) (with "o" and masu-stem of verb) grammatical form creating an honorific verbal expression/(P)/
になると /(exp) when it becomes/when it comes to/(P)/
には /(prt) for (in regard to)/in order to/
には及ばない [にはおよばない] /(exp) (1) (uk) (after a verb) there is no need to/it is fine if you don't/unnecessary/(2) (after a noun) does not match/out of reach of/
にべ /(n) (1) (uk) drum/croaker (any fish of the family Sciaenidae)/(2) (uk) Nibe croaker (Nibea mitsukurii)/
にも /(exp) also/too/not ... either/as well/even/
にも関らず [にもかかわらず] /(conj,exp) in spite of/nevertheless/
にも関わらず [にもかかわらず] /(conj,exp) in spite of/nevertheless/(P)/
にも拘らず [にもかかわらず] /(conj,exp) in spite of/nevertheless/(P)/
にも拘わらず [にもかかわらず] /(conj,exp) in spite of/nevertheless/
にゃ /(exp) (1) if not ... (negative conditional)/(2) for (in regard to)/in order to/
にゃあ /(n) mewing (cat)/meow/miaow/
にゃあにゃあ /(n) (1) (baby talk for) cat/(2) mewing (of a cat)/meow/miaow/
にゃお /(n) mewing (cat)/meow/miaow/
にゃにゃ /(n,vs) (1) cat meow/miaow/(n) (2) cat/(n,vs) (3) sexual intercourse/making out/
にゃんこ /(n) (chn) kitty cat/
にゃんにゃん /(n,vs) (1) cat meow/miaow/(n) (2) cat/(n,vs) (3) sexual intercourse/making out/
にやつく /(v5k) to smirk/to grin broadly/
にやにや /(adv,n,vs) (on-mim) grinning/broad grin/smirk/(P)/
にやり /(adv,adv-to) (on-mim) broadly grinning/
にょきにょき /(adv) shooting up one after another/
にょきりにょきり /(adv-to) (on-mim) feelings/memories/imagined items or dreams that sprout up one after the other/
にょっきり /(adv) sticking out prominently (usu. something long and thin)/rising up/
にょろにょろ /(adv,vs) slitheringly/wriggling, slipping and sliding/
によって異なる [によってことなる] /(exp,v5r) to differ depending on .../(P)/
にらいかない /(n) paradise across the ocean (folk belief of Okinawa & Amami)/
にらみ付ける [にらみつける] /(v1,vt) to glare at/to scowl at/
にわか雨 [にわかあめ] /(n,adj-no) rain shower/
にわたって /(exp) throughout/over a period of .../over a span of .../
にんまり /(n,vs,adv) complacent smile/
にんまり笑う [にんまりわらう] /(exp,v5u) to smile complacently/to smile a smile of satisfaction/
にん傷に及ぶ [にんじょうにおよぶ] /(exp,v5b) to come to bloodshed/
に依って [によって] /(exp) (uk) according to/by (means of)/due to/because of/
に依り [により] /(exp) (uk) according to/by (means of)/due to/because of/
に依る [による] /(exp,v5r) (uk) by means of/due to/because of/according to/
に依ると [によると] /(exp) (uk) according to (someone)/
に依れば [によれば] /(exp) (uk) according to (quotation)/
に違いない [にちがいない] /(exp) I am sure/no doubt that/must/must have (done)/
に因って [によって] /(exp) (uk) according to/by (means of)/due to/because of/
に因り [により] /(exp) (uk) according to/by (means of)/due to/because of/
に因る [による] /(exp,v5r) (uk) by means of/due to/because of/according to/
に因れば [によれば] /(exp) (uk) according to (quotation)/
に因んで [にちなんで] /(exp) (uk) named after/associated with/connected with/
に影響されて [にえいきょうされて] /(exp) influenced by/in response to/in the wake of/triggered by/following/
に越したことはない [にこしたことはない] /(exp) it is better to/it is best to/
に沿って [にそって] /(exp,adv) along/parallel to/in accordance with/
に於いて [において] /(exp) (uk) in/on/at (place)/as for/regarding/
に於ける [における] /(exp) (uk) in/at/on/as for/regarding/with regards to/
に応じて [におうじて] /(exp) depending on/dependent on/
に加え [にくわえ] /(exp) in addition/
に加えて [にくわえて] /(exp) in addition/(P)/
に過ぎない [にすぎない] /(exp) no more than/just/only/
に関し [にかんし] /(exp) related to/in relation to/
に関して [にかんして] /(exp) related to/in relation to/
に関する [にかんする] /(exp) related to/in relation to/
に基づいて [にもとづいて] /(exp) based on/on the basis of/
に基づき [にもとづき] /(exp) based on/
に拠る [による] /(exp,v5r) (uk) by means of/due to/because of/according to/
に拠れば [によれば] /(exp) (uk) according to (quotation)/
に限って [にかぎって] /(exp) (particularly) when ... (often in phrases like "the bus just has to be on-time when we are late")/(only) for .../if we are restricting the discussion to.../in the particular case of/(P)/
に限らず [にかぎらず] /(conj) not limited to/not just .../
に限る [にかぎる] /(exp,v5r) nothing better than/
に際して [にさいして] /(exp) on the occasion of/at the time of/(P)/
に似て [ににて] /(exp) similar to/like/
に取って [にとって] /(exp) (uk) to/for/concerning/as far as ... is concerned/regarding/
に就いて [について] /(exp) (uk) concerning/along/under/per/
に就て [について] /(exp) (uk) concerning/along/under/per/
に従い [にしたがい] /(exp) in accordance with/according to/
に従って [にしたがって] /(exp) in accordance with/according to/(P)/
に准じて [にじゅんじて] /(exp) in proportion (to)/
に準じて [にじゅんじて] /(exp) in proportion (to)/
に照らして [にてらして] /(exp) in comparison with/when compared with/according to/in light of/in view of/
に乗っとり [にのっとり] /(exp) (uk) in compliance with/in accordance with/
に続いて [につづいて] /(exp) (temporal or logical sense) following .../in the wake of .../
に続く [につづく] /(exp,v5k) (temporal or logical sense) follow .../come after .../
に他ならない [にほかならない] /(exp) it is nothing else but/it is nothing short of/it is simply that/
に対し [にたいし] /(exp) towards/against/regarding/in contrast with/
に対して [にたいして] /(exp) towards/against/regarding/in contrast with/
に対する [にたいする] /(exp) regarding/in/to/towards/with regards to/
に置いて [において] /(iK) (exp) (uk) in/on/at (place)/as for/regarding/
に超したことはない [にこしたことはない] /(exp) it is better to/it is best to/
に当たって [にあたって] /(exp) (uk) at the time of (ind. opportunity or situation where something should be done)/
に伴い [にともない] /(exp) as/because/with/due to/
に反して [にはんして] /(exp) against/contrary to/
に比べ [にくらべ] /(exp) compared to/
に付いて [について] /(exp) (uk) concerning/along/under/per/
に付き [につき] /(exp) per/apiece/because of/regarding/(printing) impression/sociability/appearance/
に劣らず [におとらず] /(adv) (uk) just like/the same as/no different than/
に連れ [につれ] /(conj) (uk) as X, then Y (e.g. as we age we gain wisdom, as wine matures it becomes more valuable, etc.)/
に連れて [につれて] /(conj) (uk) as X, then Y (e.g. as we age we gain wisdom, as wine matures it becomes more valuable, etc.)/
ぬ /(aux-v,suf) (1) (after the -nai stem of a verb) not (verb-negating suffix)/(2) (arch) indicates completion/
ぬうっと /(adv) (on-mim) suddenly/abruptly/
ぬえ的 [ぬえてき] /(adj-na) mysterious/strange/sphinx-like/enigmatic/noncommital/
ぬき足 [ぬきあし] /(n) stealthy footsteps/
ぬぐい去る [ぬぐいさる] /(v5r) to rub out/to clean off/to clear away/to efface/to erase/
ぬぐい取る [ぬぐいとる] /(v5r,vt) to wipe off/to wipe out/to expunge/
ぬこ /(n) (col) cat (net slang)/
ぬすみ食い [ぬすみぐい] /(n) sneaking a bite/snitching food/
ぬたうつ /(v5t,vi) to roll around in the grass or mud/
ぬたくる /(v5r,vi) to scrawl/to daub/
ぬっと /(adv) (on-mim) suddenly/abruptly/
ぬまむし /(n) (uk) Nipponocypris sieboldii (species of cyprinid)/
ぬめっと /(adv) (on-mim) glistening/shiny/sleek/slippery/
ぬめ革 [ぬめかわ] /(n) cow hide tanned using tannin/
ぬらぬら /(adv,n,vs) (on-mim) slimy/slippery/
ぬらりくらり /(adv,vs,adv-to) (on-mim) lazy/evasive/non-commital/slippery as an eel/
ぬりこ星 [ぬりこぼし] /(n) Chinese "Willow" constellation (one of the 28 mansions)/
ぬるぬる /(adj-na,adv,n,vs) (on-mim) slimy/slippery/(P)/
ぬるま湯 [ぬるまゆ] /(n) tepid water/lukewarm water/
ね /(prt) (1) (sentence end) indicates emphasis, agreement, request for confirmation, etc./is it so/(int) (2) hey/come on/(P)/
ねえ /(prt) (1) (sentence end) indicates emphasis, agreement, request for confirmation, etc./is it so/(int) (2) hey/come on/
ねぎだく /(n) containing more onions or leeks than usual (of gyudon, etc.)/
ねじりゴム編み [ねじりゴムあみ] /(n) twisted rib stitch (knitting)/
ねじり秤 [ねじりばかり] /(n) torsion balance/
ねじり鉢巻きで [ねじりはちまきで] /(exp,adv) as hard as one can/with one's whole heart/
ねじれ国会 [ねじれこっかい] /(n) the two houses of the Diet being controlled by different parties (lit: twisted parliament)/
ねじれ秤 [ねじればかり] /(n) torsion balance/
ねじ花 [ねじばな] /(n) screw flower/
ねじ回し [ねじまわし] /(n) screwdriver/
ねじ曲がる [ねじまがる] /(v5r) to be twisted/to be wrapped/to be distorted/
ねじ曲げる [ねじまげる] /(v1,vt) to twist/to distort/
ねじ込む [ねじこむ] /(v5m,vt) to screw in/to thrust into a container/to protest against (and demand compensation)/
ねじ式 [ねじしき] /(adj-no,n) screw type/screw-on/threaded/
ねじ釘 [ねじくぎ] /(n) screw/screw spike/
ねじ伏せる [ねじふせる] /(v1,vt) to hold down/to twist one's arm/
ねずみ講 [ねずみこう] /(n) pyramid scheme/
ねずみ算 [ねずみさん] /(n) (1) geometric progression/(2) proliferation/multiplying like rats/
ねずみ算 [ねずみざん] /(n) (1) geometric progression/(2) proliferation/multiplying like rats/
ねずみ取り [ねずみとり] /(n) (1) mousetrap/rattrap/(2) speed trap/(3) rat poison/
ねた /(n) (1) material/joke material/contents/proof/(2) topping of nigiri sushi/(P)/
ねちこい /(adj-i) persistent/obstinate/stubborn/pigheaded/
ねちっこい /(adj-i) persistent/obstinate/stubborn/pigheaded/
ねちねち /(adv-to,n,vs) (on-mim) sticky/persistent/
ねっとり /(adv,adv-to,vs) viscously/stickily/
ねつ造 [ねつぞう] /(n,vs) fabrication/forgery/falsehood/hoax/
ねとねと /(adv,vs) sticky/gooey/sirupey/
ねば /(exp) if not ... (negative conditional)/
ねばならない /(exp) have to do/must/should/ought to/
ねばならぬ /(exp) have to do/must/should/ought to/
ねばなりません /(exp) have to do/must/should/ought to/
ねばなるまい /(exp) (after neg. verb stem) ought to (verb)/should (verb)/
ねばり強い [ねばりづよい] /(adj-i) tenacious/persevering/persistent/stubborn/steadfast/
ねぶた /(n) (1) nighttime festival in Aomori/(adj-na) (2) drowsy (Aomori dial.)/
ねぶた祭り [ねぶたまつり] /(n) nighttime festival in Aomori/
ねぶり箸 [ねぶりばし] /(n) licking one's chopsticks (a breach of etiquette)/
ねんね /(n,vs) bed-time (for a baby)/going bye-byes/
の /(prt) indicates possessive among other uses (for full details and examples see the main entry (linked))/
のうのう /(adv-to) (id) (on-mim) careless/carefree/
のか /(prt) endorsing and questioning the preceding statement (sentence ending particle)/lamenting reflections on the preceding statement (sentence ending particle)/
のぎ /(n) (arch) small fish bone stuck in one's throat/
のけ者 [のけもの] /(n) outcast/odd man out/pariah/
のけ者にする [のけものにする] /(exp,vs-i) to shun somebody/to send a person to Coventry/to ignore someone/
のこぎりえい /(n) (uk) sawfish (Pristidae spp.)/
のこのこ /(adv) (on-mim) unconcernedly/nonchalantly/
のさばる /(v5r) to act as one pleases/to throw one's weight around/to have everything one's own way/
のしのし /(adv-to) (on-mim) walking heavily/lumbering/
のしのしと歩く [のしのしとあるく] /(exp,v5k,vi) to walk heavily and clumsily/to lumber/
のしを付ける [のしをつける] /(exp,v1) (uk) to make a gift of/
のし歩く [のしあるく] /(v5k,vi) to swagger/
のすり /(n) (uk) common buzzard (Buteo buteo)/
のそのそ /(adv,n,vs) (on-mim) slowly/
のそり /(adv,adv-to) (on-mim) moving slowly (and dull-wittedly)/
のぞき込む [のぞきこむ] /(v5m,vt) to look into/to peer in/
のぞのぞ /(exp) slowly/sluggishly/
のぞみ /(n) extra-high-speed Toukai-line Shinkansen/(P)/
のたうち回る [のたうちまわる] /(v5r,vi) to writhe/
のたくる /(v5r,vi) to wriggle/to writhe/to squirm/
のたりのたり /(exp) undulating/rolling slowly/gently swelling/
のたれ死に [のたれじに] /(n,vs) (sens) dying by the roadside/dying a dog's death/
のた打つ [のたうつ] /(v5t) (uk) to writhe/to squirm/to wriggle/
のだ /(exp) the expectation is that .../the reason is that .../the fact is that .../it is that .../(P)/
のっけ /(n) the very beginning/
のっしのっし /(adv-to) (on-mim) walking heavily/lumbering/
のっそり /(adv,adv-to,vs) (on-mim) sluggishly/
のっと /(adv) (on-mim) suddenly/abruptly/
のっぺらぼう /(adj-na) (1) smooth/flat/lacking bumps and dents/(2) featureless/uneventful/(n) (3) mythical being with flat featureless face/
のっぺり /(adv) flat/smooth/expressionless/blank/
のっぽ /(n) tall lanky person/bean pole/daddy-longlegs/
ので /(prt) that being the case/because of .../the reason is ..../given that.../(P)/
のです /(exp) the expectation is that .../the reason is that .../the fact is that .../it is that .../(P)/
のどから手が出る [のどからてがでる] /(exp,v1) to want something desperately/to want something (so badly one can taste it)/
のどが渇く [のどがかわく] /(exp,v5k) to be thirsty/
のどが乾く [のどがかわく] /(exp,v5k) to be thirsty/
のどに詰まる [のどにつまる] /(exp,v5r) to stick in one's throat/to choke on something/
のど飴 [のどあめ] /(n) throat lozenge/cough drop/
のど自慢 [のどじまん] /(n) (1) singing contest/(2) person proud of their voice/
のど袋 [のどぶくろ] /(n) dewlap/gular pouch/
のに /(prt) (1) although/when/and yet/despite this/in spite of/even though/but even so/but even then/however/nevertheless/for all that/notwithstanding that/(2) while/(3) if only/I wish/(4) I tell you/you should do/(5) in order to/(P)/
のべつ /(adv) ceaselessly/continually/all the time/incessantly/
のべつ幕なし [のべつまくなし] /(adv) without a break/without stopping/incessantly/ceaselessly/
のべつ幕無し [のべつまくなし] /(adv) without a break/without stopping/incessantly/ceaselessly/
のほほんと /(adv) (on-mim) nonchalantly/without a care/
のぼせ上がる [のぼせあがる] /(v5r,vi) to be beside oneself/to lose one's head/to go mad with something/
のぼり詰める [のぼりつめる] /(v1,vi) (1) to go to the top/to climb to the top/to ascend to the top/to reach the summit (e.g. of a mountain)/(2) to be engrossed in/to be very enthusiastic about/to be infatuated with/
のみ /(suf,prt) only/nothing but/(P)/
のみならず /(conj) besides/as well as/
のみの市 [のみのいち] /(n) flea market/
のみ込む [のみこむ] /(v5m,vt) (1) to gulp down/to swallow deeply/(2) to understand/to take in/to catch on to/to learn/to digest/
のみ取り首輪 [のみとりくびわ] /(n) flea collar/
のめのめ /(adv,adv-to,vs) (on-mim) shamelessly/
のめり込む [のめりこむ] /(v5m,vi) to be completely absorbed in/to fall for (something)/
のめる /(v5r,vi) to fall forward/
のらくら /(adv,adv-to) (on-mim) vaguely/idly/lazily/aimlessly/
のらりくらり /(adv,vs,adv-to) (on-mim) lazy/evasive/non-commital/slippery as an eel/
のりのり /(adj-f) in high spirits/
のり巻き [のりまき] /(n) (food) vinegared rice rolled in nori (laver)/
のり面 [のりめん] /(n) slope (e.g. of embankment)/
のろけ話 [のろけばなし] /(n) (uk) speaking fondly of/
のろのろ /(adv,n,vs,adv-to) (on-mim) slowly/sluggishly/(P)/
のんけ /(n) (male) (sl) heterosexual male (as viewed by homosexual males)/
のんどり /(n,adv,vs) tranquility/tranquillity/leisure/
のんびり /(adv,n,vs) carefree/at leisure/(P)/
のんびり屋 [のんびりや] /(n) easygoing person/
のんべんだらり /(adv-to) idly/sluggishly/doing nothing/
の為に [のために] /(aux) (uk) for the sake of/because/(P)/
の下に [のもとに] /(exp) (1) (uk) under the supervision of/(2) underneath/(3) on the basis of/
の許に [のもとに] /(exp) (1) (uk) under the supervision of/(2) underneath/(3) on the basis of/
の向かいに [のむかいに] /(adv) opposite of/across from/
の度に [のたびに] /(exp,aux) (uk) on the occasion of/(P)/
の度に [のたんびに] /(exp,aux) (uk) on the occasion of/
の辺に [のあたりに] /(exp) (1) (uk) on the shores of/by the side of (e.g. rivers, ponds)/(2) in the neighborhood of/in the neighbourhood of/in the vicinity of/close by/near/by/
の辺に [のほとりに] /(exp) (1) (uk) on the shores of/by the side of (e.g. rivers, ponds)/(2) in the neighborhood of/in the neighbourhood of/in the vicinity of/close by/near/by/
の辺りに [のあたりに] /(exp) (1) (uk) on the shores of/by the side of (e.g. rivers, ponds)/(2) in the neighborhood of/in the neighbourhood of/in the vicinity of/close by/near/by/
の辺りに [のほとりに] /(exp) (1) (uk) on the shores of/by the side of (e.g. rivers, ponds)/(2) in the neighborhood of/in the neighbourhood of/in the vicinity of/close by/near/by/
の余り [のあまり] /(exp) so much (something) as to (e.g. so moved as to cry)/overwhelmed/carried away/because of too much/
の様に [のように] /(adv) (1) (uk) like/similar to/(2) as with/in the same way/
は /(int) (1) yes/indeed/well/(2) ha!/(3) what?/huh?/(4) sigh/
は /(prt) (1) topic marker particle/(2) indicates contrast with another option (stated or unstated)/(3) adds emphasis/(P)/
はあ /(int) (1) yes/indeed/well/(2) ha!/(3) what?/huh?/(4) sigh/
はあとめーる /(n) postcards associated with Respect-for-the-Aged Day, and sold every year starting in September (wasei: heart mail)/
はあはあ /(n) (on-mim) gasp/pant/
はい /(int) (1) (pol) yes/(2) OK (used to get attention prior to an utterance)/okay/(3) giddy-up/giddap/(P)/
はい /(n) (arch) lotus root/
はいはい /(int) (col) yeah, yeah (used for half-hearted or insincere agreement)/
はい芽 [はいが] /(n) embryo bud/germ/
はい回る [はいまわる] /(v5r,vi) to creep about/
はい作業主任者 [はいさぎょうしゅにんしゃ] /(n) bulk loading safety officer/
はえぬき /(n) Haenuki (variety of rice)/
はがき大 [はがきだい] /(n) postcard size/
はきはき /(adv,n,vs) (on-mim) briskly/smartly/promptly/clearly/lucidly/
はぎ取り [はぎとり] /(n) stripping/skinning/tearing/removing/
はぎ取る [はぎとる] /(v5r,vt) to tear off/to strip/to rob/
はくしょん /(int,vs) achoo!/atishoo!/sneeze/
はくれん /(n) (uk) silver carp (Hypophthalmichthys molitrix)/
はく製 [はくせい] /(n,vs,adj-no) (1) stuffing/mounting/(n) (2) stuffed animal/
はぐる /(v5r,vt) to roll up (e.g. sleeves)/to turn over/
はけ口 [はけぐち] /(n) (1) outlet (e.g. for water or gas)/(2) market (for something)/(3) outlet (e.g. for excess energy)/vent (e.g. for emotions)/
はげ上がる [はげあがる] /(v5r) to become bald from the forehead/to recede/
はげ頭 [はげあたま] /(n,adj-no) (1) bald head/(2) baldness/
はこべ塩 [はこべじお] /(n) (obsc) chickweed (stitchwort) roasted and mixed with salt, then ground into a powder for use as toothpaste/
はしごを掛ける [はしごをかける] /(exp,v1) to set a ladder up against/
はしご車 [はしごしゃ] /(n) hook-and-ladder truck/
はしご酒 [はしござけ] /(n) barhopping/
はしご段 [はしごだん] /(n) step/stair/staircase/
はした金 [はしたがね] /(n) odd money/loose change/small (paltry) sum (of money)/chicken feed/(mere) pittance/
はしどい /(n) Japanese tree lilac (Syringa reticulata)/
はじき飛ばす [はじきとばす] /(v5s,vt) to flick off/to give ... the flick/to send something flying/to hit (a person)/to knock down/
はじけ飛ぶ [はじけとぶ] /(v1,vi) to pop off/to pop out/to fly off/to shoot off/to burst open/
はす /(n) (uk) three-lips (freshwater fish of the minnow family, Opsariichthys uncirostris)/
はずがない /(exp) cannot (do)/it is impossible that.../
はずだ /(exp) be supposed or expected to (do)/be sure to (do)/ought to (do)/
はずです /(exp) be supposed or expected to (do)/be sure to (do)/ought to (do)/
はず押し [はずおし] /(n) pushing up with hands under opponent's armpits (sumo)/armpit push/
はたかぜ型護衛艦 [はたかぜがたごえいかん] /(n) Hatakaze class destroyer/
はたたく /(v5k,vi) (arch) to resound loudly (of thunder, etc.)/
はたと /(adv) suddenly/sharply (to cast a glance, to make a sound)/
はたはた /(n) flutter/flap (sound representing something light such as cloth or feathers moving in the wind)/
はためく /(v5k,vi) to flutter (e.g. a flag)/
はた迷惑 [はためいわく] /(adj-na,n) nuisance to other people/inconvenience to others/
はだ脱ぐ [はだぬぐ] /(v5g,vi) (1) to remove one's shirt thus revealing the skin/to remove the upper part of one's garments/(2) to work with great effort/
はちきん /(n) (tsb:) strong independent Japanese woman from the Kochi area/
はちの子 [はちのこ] /(n) (food) hornet larva (esp. of yellowjacket species Vespula flaviceps)/bee larva/
はちぶんぎ座 [はちぶんぎざ] /(n) Octans (constellation)/the Octant/
はちみつ酒 [はちみつしゅ] /(n) mead/honey wine/ambrosia/nectar of the gods/
はち切れる [はちきれる] /(v1,vi) to be filled to bursting/to burst/
はっきり /(adv,adv-to,vs) (on-mim) clearly/plainly/distinctly/(P)/
はっくしょん /(int,vs) achoo!/atishoo!/sneeze/
はっけよい /(int) phrase shouted by a sumo referee when both rikishi have stopped moving/
はったい /(n) (uk) parched flour, esp. barley (can be drunk in hot water with sugar)/
はったり /(n) bluff/
はっちゃける /(v1) to make merry and forgot one's troubles/to do as one pleases/
はって行く [はっていく] /(v5k-s) to creep/to crawl/
はっと /(adv,n,vs) (on-mim) taken aback/
はっと息を呑む [はっといきをのむ] /(exp,v5m) to gasp in or with surprise/
はっ着 [はっちゃく] /(n,vs) arrival and departure/
はつい星 [はついぼし] /(n) Chinese "Encampment" constellation (one of the 28 mansions)/
はつゆき型護衛艦 [はつゆきがたごえいかん] /(n) Hatsuyuki class destroyer/
はつ恋 [はつこい] /(n) first love/puppy love/
はて /(int) (1) Dear me!/Good gracious!/(2) well ... (used before sentences expressing a doubt)/let me see/now .../
はてさて /(exp) (id) Let me see/
はてな /(int) (1) Dear me!/Good gracious!/(2) well ... (used before sentences expressing a doubt)/let me see/now .../
はてなマーク /(n) question mark/
はと座 [はとざ] /(n) (constellation) Columba/
はと目 [はとめ] /(n) eyelet/
はなきり /(n) (arch) cutting off the nose (form of punishment in ancient China)/
はにかみ屋 [はにかみや] /(n) shy/very shy person/
はね上がる [はねあがる] /(v5r,vi) to jump up/to spring up/
はね飛ばす [はねとばす] /(v5s,vt) (1) to send (something) flying/to splatter/(2) to drive (something) off/
はね返る [はねかえる] /(v5r) to rebound/to recoil/to spring back up/
ははあ /(int) Aha!/
はばき /(n) metal collar mounted between a sword blade and the hand guard/
はまち /(n) (uk) (ksb:) young Japanese amberjack/young yellowtail/
はまり込む [はまりこむ] /(v5m) (1) to get stuck in/to be mired in/(2) to be addicted to/
はまり道 [はまりみち] /(n) road to (figurative) addiction/
はまり役 [はまりやく] /(n) well-suited role/
はみパン /(n) (abbr) (sl) having part of one's underwear exposed from their shorts/
はみ出し [はみだし] /(n) jutting out (of bounds)/being crowded out/
はみ出す [はみだす] /(v5s,vi) (1) to be forced out/to be crowded out/(2) to jut out (of bounds)/
はみ出る [はみでる] /(v1,vi) (1) to jut out (of bounds)/(2) to be crowded out/to be forced out/
はみ乳 [はみちち] /(n) (sl) exposed breasts/
はめ込み [はめこみ] /(n) (1) insertion/inlaying/(2) (math) immersion/
はめ込む [はめこむ] /(v5m,vt) (1) to inlay/to insert/to set/(2) (math) to plug in (to a formula)/to immerse/(3) to trick/to deceive/
はめ殺し [はめごろし] /(n) fixed fitting/
はめ倒す [はめたおす] /(v5s) (col) to make love/
はやり病 [はやりやまい] /(n) epidemic/
はやり目 [はやりめ] /(n) conjunctivitis/pink eye/epidemic keratoconjunctivitis/
はらはら /(adv,vs,adv-to) (1) (on-mim) heart going pit-a-pat/falling rapidly in big drops/fluttering down/(2) keeping on tenterhooks/suspense/(3) exciting/thrilling/
はらみ /(n) skirt steak/tender beef around the diaphragm/
はららご /(n) (uk) hard roe (esp. salmon)/
はらり /(adv-to,adv) gently (falling)/
はりはり /(n) thin, dried strips of daikon soaked in vinegar and other flavorings/
はりはり漬け [はりはりつけ] /(n) thin, dried strips of daikon soaked in vinegar and other flavorings/
はり合わせる [はりあわせる] /(v1) to paste together/
はり札 [はりふだ] /(n,vs) poster/notice/
はり師 [はりし] /(n) acupuncturist/
はり紙 [はりがみ] /(n) paper patch/paper backing/poster/sticker/label/
はり付け [はりつけ] /(n) (comp) paste/
はる /(v5r,aux-v,suf) (hon) (ksb:) to do/
はるしお型潜水艦 [はるしおがたせんすいかん] /(n) Harushio class submarine/
はるじおん /(n) common fleabane/Philadelphia fleabane (Erigeron philadelphicus)/
はるじょおん /(n) common fleabane/Philadelphia fleabane (Erigeron philadelphicus)/
はるな型護衛艦 [はるながたごえいかん] /(n) Haruna class destroyer/
はるの雲 [はるのくも] /(exp,n) cloud floating in a spring sky/
はん /(suf) (ksb:) Mr/Mrs/Ms/-san/
はんなり /(adv-to,adv,vs) (ksb:) elegant/lively but restrained/quietly beautiful/
はん用レジスタ [はんようレジスタ] /(n) (comp) general purpose register/
はん用階層ファイルモデル [はんようかいそうファイルモデル] /(n) (comp) general hierarchical model/
はん用体 [はんようたい] /(n) (comp) generic unit/
はん用定義 [はんようていぎ] /(n) (comp) generic definitions/
はん用的試験項目 [はんようてきしけんこうもく] /(n) (comp) generic test case/
はん用的試験項目群 [はんようてきしけんこうもくぐん] /(n) (comp) generic test suite/
は種 [はしゅ] /(n,vs) sowing/seeding/planting/
は虫類 [はちゅうるい] /(n) reptiles/
ば /(prt) indicates supposition/if ... then/(P)/
ばあちゃん /(n) (fam) granny/grandma/gran/female senior-citizen/(P)/
ばい煙 [ばいえん] /(n) dirty smoke/soot and smoke/
ばい貝 [ばいがい] /(n) whelk/small water snails/
ばい菌 [ばいきん] /(n) (1) (col) germ/germs/bacteria/mold (mould)/(2) something harmful (used figuratively)/vermin/(P)/
ばかっぽい /(adj-i) geeky/geekish/
ばかを見る [ばかをみる] /(exp,v1) to feel like an idiot/to make a fool of yourself/
ばか者 [ばかもの] /(n) (derog) moron/idiot/stupid person/
ばか笑い [ばかわらい] /(n,vs) horse laugh/guffaw/wild laughter/
ばか騒ぎ [ばかさわぎ] /(n,vs) horseplay/fooling around/
ばきっ /(adv-to) snapping (i.e. branch)/
ばくち打ち [ばくちうち] /(n) (1) professional gambler/(2) gambling/
ばくんちょ /(n) (1) (sl) eating in one bite/(2) sexual intercourse/
ばく大 [ばくだい] /(adj-na,n) enormous/vast/
ばさばさ /(adj-na,adv,n,vs) (on-mim) rustle/loose/
ばさりと /(adv) (on-mim) with a thud/
ばしゃっ /(adv-to) (on-mim) splash/sploosh/
ばたつく /(v5k,vi) to clatter/to flap (noisily)/to rattle/to walk around being unable to settle down/
ばたばた /(n,vs,adv,adv-to) (1) (on-mim) flapping/rattling (sound)/noisily/clattering noise/(n) (2) commotion/kerfuffle/(P)/
ばたり /(adv) with a flop/
ばた脚 [ばたあし] /(n) flutter kick (swimming)/the thrash/
ばた足 [ばたあし] /(n) flutter kick (swimming)/the thrash/
ばちゃん /(adv,adv-to) (on-mim) with a splash/
ばちん /(adv-to) (on-mim) (with a) slap/smack/
ばっくれ /(n) (1) (sl) feigning ignorance/(2) evading one's responsibilities/
ばっくれる /(v1) (1) (sl) to feign ignorance/(2) to evade one's responsibilities/
ばっくんちょ /(n) (1) (sl) eating in one bite/(2) sexual intercourse/
ばっさばっさ /(adv-to,adv) rapidly/flapping wings/
ばっさり /(adv) with a single stroke/resolutely/drastically/completely/
ばったり /(adv) with a clash (thud)/with a bang/plump/flop/suddenly/abruptly/unexpectedly/
ばっちい /(adj-i) (sl) dirty (word used by kids)/unclean/
ばっちり /(adv) perfectly/properly/right on the mark/sure thing/
ばってん /(conj) (kyu:) but/however/although/
ばっと /(adv) (on-mim) suddenly/in a flash/rapidly/nimbly/alertly/
ばっ気 [ばっき] /(n,vs) aeration/
ばつ /(n,adj-no) (1) one's circumstances or condition, esp. compared to that of another/(2) coherence (e.g. of a conversation)/
ばついち /(n) divorced (once) (lit: strike one, i.e. one name struck from the koseki)/
ばつが悪い [ばつがわるい] /(exp,adj-i) awkward/uncomfortable/embarrassing/
ばつの悪い [ばつのわるい] /(adj-i) awkward/uncomfortable/embarrassing/
ばつを合わせる [ばつをあわせる] /(exp,v1) to make one's story to seem coherent/to adjust one's story to fit the situation/
ばてる /(v1,vi) to be exhausted/to be worn out/(P)/
ばね仕掛け [ばねじかけ] /(n,adj-no) clockwork (motor, etc.)/spring action/
ばね指 [ばねゆび] /(n) trigger finger/flexor tendinitis/
ばね秤 [ばねばかり] /(n) spring balance/spring scale/pull tension gauge/
ばば /(n) shit/bullshit/
ばば抜き [ばばぬき] /(n) old maid/living without one's mother-in-law/
ばむ /(suf,v5m) to be ...y (suffix indicating that something is in the state of the preceding noun, etc.)/
ばやい /(n-adv,n) case/situation/(slangy version of baai)/
ばらす /(v5s,vt) (1) to expose/to lay open (e.g. secret)/(2) to take to pieces/(3) to kill/to murder/(P)/
ばらたなご /(n) (uk) rosy bitterling (Rhodeus ocellatus)/
ばらつき /(n) scattering (e.g. in statistics)/a scatter/dispersion/
ばらつく /(v5k,vi) to rain (drops on the large side)/to go to pieces/to be taken apart/
ばらばら /(adj-na,adj-no,adv,vs) (on-mim) scattered/disperse/loose/disconnected/in pieces/in drops/rustling/
ばらばら事件 [ばらばらじけん] /(n) murder case in which the victim is chopped into pieces/mutilation murder case/
ばらまき政治 [ばらまきせいじ] /(n) money politics/pork-barrel politics/
ばらむつ /(n) (uk) oilfish (Ruvettus pretiosus)/
ばら荷 [ばらに] /(n) bulk goods/
ばら撒き [ばらまき] /(n) (1) (uk) broadcasting (e.g. seed)/disseminating/(2) distributing (e.g. favours)/pork barrelling/
ばら蒔く [ばらまく] /(v5k,vt) (uk) to disseminate/to scatter/to give money freely/
ばら寿司 [ばらずし] /(n) (ksb:) type of sushi with a variety ingredients sprinkled on the rice/
ばら色 [ばらいろ] /(n) rose-colour/rose-color/
ばら肉 [ばらにく] /(n) boned rib (esp. of pork)/
ばら鮨 [ばらずし] /(n) (ksb:) type of sushi with a variety ingredients sprinkled on the rice/
ばりばり /(adj-na,adv,n) (on-mim) tearing/crunching (sound)/work hard/actively/(P)/
ばりッと /(adv) (1) (on-mim) sound of an object breaking loudly/ripping sound/tearing sound/(2) being stylish/
ばれる /(v1,vi) to leak out (a secret)/to be exposed (a lie, improper behaviour, etc.) (behavior)/(P)/
ばわい /(n-adv,n) case/situation/(slangy version of baai)/
ばんばん /(adv) (1) (on-mim) bang bang (sound of a hammer or gunfire)/(2) doing something at a mad pace (spend money, work)/
ぱ /(suf) apiece/each/
ぱあ /(n,adj-na) (1) paper (in rock, paper, scissors)/(2) disappearing completely/(3) foolishness/stupidity/
ぱあっと /(adv) with energy (of parties and such)/enthusiastically/going all out/
ぱいおつ /(n) (X) (col) tits (trendy inverse of oppai)/
ぱいぱい /(n) (chn) (sl) boobs/female breasts/hooters/
ぱかぱか /(adv-to,adv) (on-mim) clip-clop/clippety-clop/
ぱかん /(adv-to) (1) (on-mim) vacantly/blankly/absentmindedly/(2) (on-mim) openmouthed/with one's mouth wide-open/gaping/flabbergasted/(3) (on-mim) with a whack/with a thump/
ぱくつく /(v5k,vt) to open your mouth wide and eat heartily/to gulp down food/
ぱくぱく /(adv,n,vs) (on-mim) flapping open and closed (e.g. mouth)/
ぱくり /(adv,adv-to,n) (1) (on-mim) gaping (esp. mouth)/(2) snapping into/biting into/(n,vs) (3) cribbing/lifting/plagiarism/rip-off/
ぱくり屋 [ぱくりや] /(n) confidence man/con man/company (or person) carrying out credit fraud/
ぱさつく /(v5k,vi) to be dried out/to be parched/
ぱしゃっ /(adv-to) (on-mim) splash/sploosh/
ぱしり /(n) (abbr) person who is made to do things or go get things for someone else/gofer/
ぱしる /(v5r) (sl) to make do errands/to set to scutwork/
ぱたぱた /(adv,vs) (1) (on-mim) flap (sound of something light and thin such as a fan moving through the air)/(2) pitter-patter (sound of light footsteps)/(3) dealing with a situation quickly/
ぱたり /(adv) clink/sudden stop/
ぱたんと /(adv,vs) with a snap/with a bang/with a plonk/with a click/sudden stopping/
ぱちくり /(adv,n,vs) blinking with surprise/
ぱちっ /(n,adv-to) snapping (e.g. fingers) sound/with a pop/
ぱちつかせる /(v1) to blink repeatedly/to wave repeatedly (e.g. a paper fan)/
ぱちり /(adv-to) (on-mim) quickly/suddenly/
ぱちんこ /(n,vs) (1) pachinko (Japanese pinball)/(2) slingshot/catapult/
ぱちんこ屋 [ぱちんこや] /(n) pinball parlor/pinball hall/
ぱっくり /(adv,adv-to,n) (1) (on-mim) gaping (esp. mouth)/(2) snapping into/biting into/(n,vs) (3) cribbing/lifting/plagiarism/rip-off/
ぱったり /(adv,adv-to) unexpectedly/suddenly/abruptly/
ぱっちり /(adv,n,vs) (of eyes) big and beautiful, or open wide/
ぱっと /(adv,vs) (on-mim) suddenly/in a flash/rapidly/nimbly/alertly/(P)/
ぱっとしない /(exp) expression of vague dissatisfaction with a thing, person, or situation/
ぱっぱっと /(adv) (1) in puffs/in whiffs/(2) in flashes/
ぱっぱと /(adv) quickly/
ぱねぇ /(adv,pref) (sl) a lot/to a very great extent/absolutely/
ぱらつく /(v5k,vi) to sprinkle (e.g. with rain)/
ぱらり /(adv-to,adv) sprinkling/dropping in small light bits/
ぱりっと /(adv,vs) (1) (col) dashing/classy/posh/new/modern/(2) crisp/crisply/crunchy/
ぱりぱり /(adj-na,adv,n) (on-mim) crispy/first-class/
ぱるる /(n) Postal Savings system/
ぱんぱん /(n,adj-na,adv) (1) (on-mim) kapow/bang/slap/(n) (2) prostitute (esp. just after WWII)/
ひいて板 [ひいてばん] /(n) boards/cut timber/
ひいひい /(adv) (on-mim) sound of a baby crying/
ひかり /(n) skips-most-stations Toukai-line Shinkansen/
ひがみっぽい /(adj-i) cynical/warped/
ひき殺す [ひきころす] /(v5s,vt) to kill by running over/
ひき逃げ [ひきにげ] /(n,vs) (uk) hit-and-run accident causing personal injury/
ひき肉 [ひきにく] /(n) minced meat/ground meat/
ひくつく /(v5k,vi) to twitch/
ひくひく /(adv,n,vs) (on-mim) twitching/
ひけらかす /(v5s,vt) to show off/to make a display (e.g. of wealth)/
ひけ目 [ひけめ] /(n) weakness/drawing back/
ひげを生やす [ひげをはやす] /(exp,v5s) to grow a beard/
ひげ面 [ひげづら] /(n) bearded face/unshaven face/hairy face/
ひさかき /(n) (uk) Eurya japonica (species of evergreen related to sakaki)/
ひさぎ /(n) (uk) Eurya japonica (species of evergreen related to sakaki)/
ひさし髪 [ひさしがみ] /(n) (obsc) classic Japanese women's low pompadour hairstyle/
ひざ元 [ひざもと] /(n) (1) near one's knee/below one's knee/(2) under the protection of (e.g. one's parents)/under the care of/(3) territory of a powerful person/
ひしめき合う [ひしめきあう] /(v5u) to crowd together in a confined space/to gather and make a commotion/
ひじ掛け [ひじかけ] /(n) armrest (of a chair)/elbow rest/
ひじ掛けいす [ひじかけいす] /(n) (1) armchair/chair with arm rests/(2) senior staff/
ひじ掛け椅子 [ひじかけいす] /(n) (1) armchair/chair with arm rests/(2) senior staff/
ひじ当て [ひじあて] /(n) (1) (detachable) elbow rest/arm rest/elbow pad/(2) (MA) elbow strike (karate)/
ひそひそ /(adv,adv-to) (on-mim) whisperingly/(P)/
ひそひそ話 [ひそひそばなし] /(n,vs) whispering/
ひたひた /(adv) (1) (on-mim) gradually/steadily/(2) lapping (against, on, toward)/(3) lightly submerging something (in water)/
ひたむきに聞く [ひたむきにきく] /(exp,v5k) to listen intently/
ひた隠し [ひたかくし] /(n) cover-up/hiding at all costs/
ひた謝り [ひたあやまり] /(n) earnest apology/profuse apology/
ひっきり無し [ひっきりなし] /(adj-na) (uk) continually/continuously/incessantly/
ひっくり返す [ひっくりかえす] /(v5s,vt) to turn over/to overturn/to knock over/to upset/to turn inside out/
ひっくり返る [ひっくりかえる] /(v5r,vi) to be overturned/to be upset/to topple over/to be reversed/
ひっしゅ /(n) (Buddh) (obsc) bhikkhu (fully ordained Buddhist monk)/
ひっすう /(n) (Buddh) (obsc) bhikkhu (fully ordained Buddhist monk)/
ひっそり /(adv,n,vs,adv-to) (on-mim) quiet/still/silent/deserted/(P)/
ひっそり閑 [ひっそりかん] /(adv,adv-to) (uk) quietly/
ひっつき虫 [ひっつきむし] /(n) burr (prickly seeds or seedheads that stick to fur and clothes)/
ひっ提げる [ひっさげる] /(v1) (uk) (col) to carry in one's own hands/to carry in a manner that is obvious to others/
ひつじ雲 [ひつじぐも] /(n) altocumulus cloud/
ひとっ走り [ひとっぱしり] /(n,vs) spin (as in 'take a car for a spin')/run/
ひとつとっても /(exp) one example of (when there are more examples)/
ひとめぼれ /(n) Hitomebore (variety of rice)/
ひとり言 [ひとりごと] /(n) soliloquy/monologue/speaking to oneself/
ひとり子 [ひとりご] /(n) child/only child/
ひとり歩き [ひとりあるき] /(n,vs) walking alone/walking unaided/going alone/standing on one's own/
ひとり暮し [ひとりぐらし] /(n) a single life/a solitary life/living alone/
ひとり立ち [ひとりだち] /(n,vs) being independent/standing on one's own/becoming independent/
ひと雨 [ひとあめ] /(n) shower/rainfall/
ひと泳ぎ [ひとおよぎ] /(n,vs) a swim/
ひと押し [ひとおし] /(n,vs) push/another try/
ひと回り [ひとまわり] /(n-adv) (1) one turn/one round/(2) (a) size/(vs) (3) to go around/to make a circuit/to take a turn/
ひと塊 [ひとかたまり] /(n) one lump/one group/
ひと塊り [ひとかたまり] /(n) one lump/one group/
ひと休み [ひとやすみ] /(n,vs) rest/
ひと欠けら [ひとかけら] /(n) fragment/piece/
ひと欠片 [ひとかけら] /(n) fragment/piece/
ひと結び [ひとむすび] /(n,vs) knotting/
ひと月 [ひとつき] /(n) one month/
ひと言 [ひとこと] /(n,vs) single word/
ひと口 [ひとくち] /(n) (1) mouthful/bite/sip/draft/draught/(2) one word/
ひと財産 [ひとざいさん] /(n) a fortune/
ひと時 [ひととき] /(n-t,n-adv) (1) moment/a (short) time/a while/(2) former times/(3) (arch) two-hour period/
ひと升 [ひとます] /(n) one square on a grid/one cell of a grid/
ひと吹き [ひとふき] /(n) blast/puff/whiff/gust/
ひと切り [ひときり] /(n) pause/period/step/once/some years ago/
ひと先ず [ひとまず] /(adv) (uk) for the present/once/in outline/
ひと騒動 [ひとそうどう] /(n) disturbance/kerfuffle/
ひと続き [ひとつづき] /(n,adj-no) a chain (of)/a series (of)/
ひと度 [ひとたび] /(n-adv) (1) once/one time/on one occasion/(2) temporarily/for a moment/
ひと肌 [ひとはだ] /(n,adj-no) the skin/body warmth/
ひと晩 [ひとばん] /(n-adv,n-t) one evening/all night/overnight/
ひと味違う [ひとあじちがう] /(exp,v5u) (col) to be somewhat different (from before, from others, etc.)/
ひと眠り [ひとねむり] /(n,vs) (1) (usu. in positive sentences) (a) sleep/(a) nap/(2) first sleep of silkworms/
ひと目 [ひとめ] /(n-adv,n-t) (1) (a) glance/(a) look/(a) glimpse/(2) complete view/bird's-eye view/
ひと舐め [ひとなめ] /(n,vs) a lick/one lick/
ひどい仕打ち [ひどいしうち] /(exp) cruel treatment/raw deal/kick in the pants/
ひどい目にあう [ひどいめにあう] /(exp,v5u) to have a bad time/to go through a bitter experience/to get into trouble/to get hurt/to suffer/
ひどい目にあわせる [ひどいめにあわせる] /(exp,v1) to bring someone to grief/to give someone hell/
ひどい目に遭わせる [ひどいめにあわせる] /(exp,v1) to bring someone to grief/to give someone hell/
ひど過ぎる [ひどすぎる] /(v1) too much/too cruel/
ひな菊 [ひなぎく] /(n) daisy/
ひな型 [ひながた] /(n) (1) model/miniature/pattern/(2) sample/specimen/(3) prescribed form/
ひな形 [ひながた] /(n) (1) model/miniature/pattern/(2) sample/specimen/(3) prescribed form/
ひな祭り [ひなまつり] /(n) Girls' Festival (March 3rd)/Dolls' Festival/
ひな壇 [ひなだん] /(n) tiered doll stand/tiered platform or gallery/
ひな段 [ひなだん] /(n) tiered doll stand/tiered platform or gallery/
ひな鳥 [ひなどり] /(n) chick/baby bird/
ひねり出す [ひねりだす] /(v5s,vt) to work out/to think up/to devise/to manage (somehow)/to summon up (e.g. courage)/
ひび /(n) brushwood, etc. used as cultch for seaweed or oyster farming (culch)/
ひびが入る [ひびがはいる] /(exp,v5r) to get cracked/to develop a crack/to be fissured/
ひびの切れた [ひびのきれた] /(adj-f) chapped (hands)/
ひび割れ [ひびわれ] /(n,vs) crack/crevice/fissure/
ひび割れる [ひびわれる] /(v1,vi) to crack/to develop a crack/
ひび焼き [ひびやき] /(n) crackleware/
ひま人 [ひまじん] /(n) man of leisure/woman of leisure/
ひめじおん /(n) daisy/Erigeron annuus/
ひめじょおん /(n) daisy/Erigeron annuus/
ひもじい /(adj-i) hungry/
ひもじい思い [ひもじいおもい] /(n) state of feeling hungry/
ひゃっくり /(n) (obsc) hiccup/hiccough/
ひやりはっと /(n) close call/near miss/
ひゅー /(adv-to) (on-mim) (with a) whizzing sound/sound of something whizzing by/
ひゅーっ /(adv-to) (on-mim) (with a) whizzing sound/sound of something whizzing by/
ひゅうひゅう /(n) whistling sound/sound of the wind/
ひゆ /(n) (uk) Joseph's-coat (Amaranthus tricolor)/tampala/
ひょいと /(adv) (on-mim) by chance/suddenly/accidentally/with agility/
ひょいひょい /(adv,adv-to) (1) with agility/(2) casually/
ひょう /(n) (uk) Joseph's-coat (Amaranthus tricolor)/tampala/
ひょう窃 [ひょうせつ] /(n,vs,adj-no) plagiarism/piracy/
ひょう柄 [ひょうがら] /(n) leopard print (design)/
ひょう疽 [ひょうそ] /(n) whitlow/
ひょこひょこ /(adv,n) unsteady steps/
ひょっくり /(adv) all of a sudden/suddenly/by chance/unexpectedly/
ひょっこり /(adv) all of a sudden/suddenly/by chance/unexpectedly/
ひょっと /(adv,vs) (1) (on-mim) possibly/perhaps/perchance/(2) (on-mim) unintentionally/accidentally/
ひょっとしたら /(exp) possibly/by some possibility/perhaps/(P)/
ひょっとして /(exp) by any chance/(should) it happen (that)/(P)/
ひょっとすると /(adv) (on-mim) perhaps/maybe/possibly/(P)/
ひょろひょろ /(adj-na,adv,n,vs) (on-mim) frail/lanky/swaying/
ひょろりと /(adv) (on-mim) long and thin/tall and thin/
ひょろ長い [ひょろながい] /(adj-i) long and narrow/lanky/gangling/spindly/
ひょんな /(adj-pn) strange/unexpected/(by) chance/unusual/curious/
ひよこ豆 [ひよこまめ] /(n) chickpea (Cicer arietinum)/garbanzo bean/
ひよひよ /(adv,adv-to) (1) (on-mim) cheep cheep/tweet tweet/(2) gently (moving)/
ひらひら /(adv,adv-to,n,vs) (on-mim) flutter/(P)/
ひらり /(adv-to) (on-mim) nimbly/lightly/
ひら社員 [ひらしゃいん] /(n) rank and file member of staff/ordinary employee/low-grade employee/
ひら茸 [ひらたけ] /(n) (uk) oyster mushroom (Pleurotus ostreatus)/
ひりつく /(v5k,vi) to hurt/to smart/to sting/
ひりひり /(adv,n,vs) (on-mim) prickling pain/smarting/stinging/
ひれ伏す [ひれふす] /(v5s,vi) to prostrate oneself before/
ひんやり /(adv,n,vs) to feel (pleasantly) cool/
ひん曲げる [ひんまげる] /(v1,vt) (1) to bend (with great force)/to twist/to wrench/(2) to distort (the truth)/
ひん死 [ひんし] /(n,adj-no) dying/(on the) verge of death/
ひん斥 [ひんせき] /(n,vs) rejection/ostracism/
ひん剥く [ひんむく] /(v5k) to strip/to peel/to tear off/
ひん抜く [ひんぬく] /(v5k) to uproot/to pull out/
ひ弱 [ひよわ] /(adj-na,n) weak/delicate/sickly/
ひ弱い [ひよわい] /(adj-i) weak/sickly/
ひ孫 [ひいまご] /(n) great-grandchild/
ひ孫 [ひこ] /(ok) (n) great-grandchild/
ひ孫 [ひこまご] /(ok) (n) great-grandchild/
ひ孫 [ひひこ] /(ok) (n) great-grandchild/
ひ孫 [ひまご] /(n) great-grandchild/
びくっと /(adv) with a start/
びくつく /(v5k,vi) to be scared/
びくともしない /(adj-i) (1) unperturbed/undaunted/retaining composure/(2) unyielding/not giving an inch/
びくびく /(adv,n,vs,adj-no) (on-mim) being afraid of/being fearful/being timid/being nervous/(P)/
びくりと /(adv) with a start/
びけ /(n) last on the list/at the bottom/
びしっと /(adv) (1) (on-mim) with a snap/(break) cleanly/(2) (reject) sternly/flatly/(3) smartly (e.g. of dressing up well)/
びしびし /(adv) (on-mim) stickily/relentlessly/
びしゃびしゃ /(adv) soaked/slushy/wet/
びしゃん /(n) bush hammer/
びしょびしょ /(adj-na,adv,n) (on-mim) saturated/wet through/(P)/
びしょ濡れ [びしょぬれ] /(n,adj-no) sopping wet/sodden/wet to the skin/(P)/
びしり /(adv-to) (1) (on-mim) with a snap/(break) cleanly/(2) (reject) sternly/flatly/(3) smartly (e.g. of dressing up well)./
びたびた /(adj-no,adj-na,adv,vs) (1) drenched/soaked/(adv,vs) (2) romantically/
びた一文 [びたいちもん] /(exp) being penniless/not having a cent/
びちゃびちゃ /(adj-na,adv,n,vs) splashing/dabbling/
びちょびちょ /(adj-na,adv,n) (on-mim) saturated/wet through/
びっくりカメラ /(n) candid-camera/candid-camera footage/
びっくり仰天 [びっくりぎょうてん] /(n,vs) astonished/stunned/startled out of one's wits/thunderstruck/open-eyed astonishment/
びっくり箱 [びっくりばこ] /(n) jack-in-the-box/jack-in-a-box/
びっこを引く [びっこをひく] /(exp,v5k) to limp/
びっしょり /(adj-na,adv) (on-mim) wet through/drenched/(P)/
びっしり /(adv) closely packed/crowded close/(P)/
びにる /(v5r) (sl) to go to a convenience store/
びびり /(n) chatter mark (machine tools)/
びびる /(v5r,vi) (1) to feel nervous/to feel self-conscious/to feel surprise/(2) (col) to get cold feet/to get the jitters/to feel frightened/
びらびら /(adv,n,vs) (on-mim) flutter/flutteringly/
びり /(n) last on the list/at the bottom/
びりびり /(adj-na,adv,n) (on-mim) like an electric shock/ripping/rattling/(P)/
びる /(suf,v1) seeming to be .../becoming like .../behaving as .../
びわ酒 [びわしゅ] /(n) loquat wine/
びんた /(n) slap in the face/
びんびん /(adj-no) hard (e.g. penis)/strong (e.g. beat of music)/
ぴいかん /(n) state of fine weather where one is subject to direct sunlight/
ぴいぴい /(n,adj-f,adv) (1) (on-mim) whistling or chirping/(2) flute/(3) beginner/(4) poor/
ぴかっと /(adv,vs) brightly/dazzlingly/sparklingly/brilliantly (shining)/
ぴかぴか /(adj-na,adv-to,n,adj-no) (on-mim) glitter/sparkle/(P)/
ぴかぴか光る [ぴかぴかひかる] /(exp,v5r) to sparkle/to glitter/to twinkle/
ぴか一 [ぴかいち] /(n) (1) scoring hand with one 20 point flower card and six 1 point flower cards/(2) something (or someone) that stands out above the rest/
ぴくっと /(adv) with a twitch (e.g. an eyebrow)/with a dip/with a bob/with a flutter/
ぴくぴく /(vs) (1) to twitch/(adv-to) (2) twitchingly/
ぴくぴく動く [ぴくぴくうごく] /(exp,v5k) to jerk/to wiggle/to twitch/
ぴくり /(adv-to,adv) (on-mim) with a twitch (e.g. an eyebrow)/with a dip/with a bob/with a flutter/
ぴくんぴくん /(vs) to twitch/
ぴしっ /(adv-to) (on-mim) with a crack/with a snap/slam (a door)/stretch (one's spine)/
ぴしゃっと /(adv) (on-mim) slapping/splatting/
ぴしゃっぴしゃっ /(adv) (1) slap (sound of a flat object continuously striking something)/(2) splash/
ぴしゃぴしゃ /(adv) (1) slap (sound of a flat object continuously striking something)/(2) splash/
ぴしゃり /(adv,adv-to) slapping/splashing/splatting/banging shut/flat (refusal, denial, etc.)/
ぴしり /(adv-to) with a click/with a snap/
ぴたっと /(adv) (on-mim) closely/exactly/suddenly/tightly/
ぴたりと /(adv) (on-mim) closely/exactly/suddenly/tightly/
ぴちっと /(adv,vs) tightly/snugly/
ぴちぴち /(adv,adj-na) (on-mim) lively/spunky/energetic/
ぴちゃぴちゃ /(adv,n,vs) (1) splash water/dabble in water/splashing sound/
ぴちゃん /(adv-to,adv) (1) (on-mim) splash/(2) (on-mim) slam/slap/
ぴったり /(adj-na,adv,n,vs,adv-to) (on-mim) exactly/neatly/sharp/(P)/
ぴっちり /(adv,adv-to,vs) (on-mim) tightly/snugly/
ぴゅう /(adv-to) (1) swoosh/whoosh/(2) sound of a whistle/
ぴゅうぴゅう /(adv) sound of whistling or wheezing/
ぴゅぴゅ /(n) whistling of wind/
ぴょこぴょこ /(adv-to) (1) (on-mim) up and down/lightly/nimbly/moving in small leaps as a frog or rabbit/(2) (on-mim) casually/(strolling about) without a care/
ぴょこん /(adv) quickly, in a bouncing way (e.g. for a bow)/action of quickly bowing or lowering one's head/
ぴょこんと /(adv) quickly, in a bouncing way (e.g. for a bow)/action of quickly bowing or lowering one's head/
ぴょんぴょん /(adv) hopping/skipping/(P)/
ぴよぴよ /(adv,adv-to) (1) (on-mim) cheep cheep/tweet tweet/
ぴよぴよ鳴く [ぴよぴよなく] /(exp,v5k) to peep/to cheep/
ぴりっと /(adv,vs) (on-mim) tingling/stinging/pungently/
ぴりっとくる /(exp,vk) pungent/biting/racy/hot/
ぴりぴり /(adv,n,vs) (on-mim) tingle/sting/smart/hot/burning the tongue/becoming tense/(P)/
ぴんと張る [ぴんとはる] /(exp,v5r) to pull tight/
ぴんと来る [ぴんとくる] /(vk) to get (a joke or explanation)/to strike home/to know intuitively/
ぴんぴん /(adv,n,vs,adj-no) (on-mim) lively/(P)/
ぴん札 [ぴんさつ] /(n) (col) crisp, unwrinkled banknote/
ふーふー /(adv) (1) (on-mim) sound of heavy breathing/(n,vs) (2) blowing on something (e.g. to cool it down)/
ふーん /(int) (1) hmm/well .../humph/huh/pshaw/pish/
ふい /(n) coming to nothing/ending without result/total waste/
ふいご祭 [ふいごまつり] /(n) Bellows Festival (festival for blacksmiths and foundries on the eighth day of the eleventh month of the lunar calendar, on which they would clean their bellows and pray)/
ふいご祭り [ふいごまつり] /(n) Bellows Festival (festival for blacksmiths and foundries on the eighth day of the eleventh month of the lunar calendar, on which they would clean their bellows and pray)/
ふいと /(adv) abruptly/suddenly/unexpectedly/
ふいにする /(exp,vs-i) to lose completely/to waste all/to let something slip away/
ふいになる /(exp) to come to nothing/to fall through/to end without result/
ふうふう /(adv) (1) (on-mim) sound of heavy breathing/(n,vs) (2) blowing on something (e.g. to cool it down)/
ふうん /(int) (1) hmm/well .../humph/huh/pshaw/pish/
ふかふか /(adv) soft (and fluffy)/
ふき /(n) (obsc) turned-back hem of a kimono/
ふき取る [ふきとる] /(v5r,vt) to wipe off/to wipe up/
ふくれっ面 [ふくれっつら] /(n,adj-no) sulky look/sullen look/
ふくろももんが /(n) (uk) sugar glider (species of flying phalanger, Petaurus breviceps)/
ふける /(v1,vi) (sl) to run away (e.g. from work)/
ふさ /(adv,adj-na) (arch) plenty/
ふさぎ込む [ふさぎこむ] /(v5m,vi) to mope/to brood/to be in low spirits/to have the blues/
ふざく /(v5k) to frolic/to romp/to fool/to be flip/
ふざけんなよ /(exp) (vulg) stop bullshitting me/you're fucking kidding me/you're full of shit/
ふしだら /(adj-na,n) slovenly/untidy/messy/fast/loose/
ふし穴 [ふしあな] /(n) (1) knothole/peep-hole/(2) bad eyes/
ふたご座 [ふたござ] /(n) Gemini (constellation)/the Twins/
ふためく /(v5k) to make a commotion/
ふたを開ける [ふたをあける] /(exp,v1) to open the lid/
ふたを閉める [ふたをしめる] /(exp,v1) to shut the lid/
ふた時 [ふたとき] /(n-t) (1) fairly long period of time/(2) (arch) four-hour period/
ふだん草 [ふだんそう] /(n) Swiss chard (Beta vulgaris var. cicla)/silverbeet/
ふっくら /(adv-to) (on-mim) fully/luxuriantly/fluffy/plump/soft and full/
ふっくり /(adv-to) fully/luxuriantly/fluffy/plump/soft and full/corpulent/
ふっこ /(n) juvenile Japanese sea perch (usu. 2-3 years in age and 40-60 cm in length)/
ふっつり /(adv,adv-to) break/snapping off/suddenly stopping/
ふっと /(adv) (1) (on-mim) with a whiff/with a puff/(2) suddenly/abruptly/without warning/
ふっ飛ばす [ふっとばす] /(v5s) (1) to blow off something (strongly)/(2) to blow off one's worries/to brush away one's worries/(3) to accomplish a task very rapidly/(4) to drive (a car) at full speed/
ふつおた /(n) listeners' corner (portion of radio programming for correspondence from listeners)/
ふつり /(adv-to,adv) breaking/snapping off/suddenly stopping/
ふて寝 [ふてね] /(n,vs) staying in bed out of spite/
ふて腐れる [ふてくされる] /(v1,vi) (uk) to become sulky/to become irresponsible/
ふところ手 [ふところで] /(n,vs) with hands in pockets/idleness/
ふところ都合 [ふところつごう] /(n) financial situation/financial standing/
ふとした /(adj-pn) impulsive/unexpected/accidental/casual/inadvertent/on a whim/
ふにゃふにゃ /(n,vs) (1) limpness/(adj-na,adj-no) (2) soft/limp/flabby/(3) mumbling/talking with food in one's mouth/
ふふ /(n) giggling sound/laugh/ha ha/
ふふん /(int) pooh!/
ふむ /(int) hmm/I see/hrm/
ふらっと /(adv) (on-mim) aimlessly/by chance/accidentally/casually/suddenly/unexpectantly/
ふらつき /(n,adj-no,adv) lightheadedness/disorientation/wobbliness/staggering/
ふらつき感 [ふらつきかん] /(n) lightheadedness/disorientation/wobbliness/
ふらつく /(v5k,vi) to feel giddy/to totter/to stagger/
ふらふら /(adj-na,adv-to,vs,adj-no) (on-mim) unsteady on one's feet/stagger/reel/totter/dizzy/(P)/
ふらり /(adv) aimlessly/
ふるいに掛ける [ふるいにかける] /(v1) (uk) to sieve/to sift/
ふるい落す [ふるいおとす] /(v5s) to shake off/
ふるい落す [ふるいおとす] /(v5s) to sift out/to screen or eliminate (candidates)/
ふるい落とす [ふるいおとす] /(v5s) to shake off/
ふるい落とす [ふるいおとす] /(v5s) to sift out/to screen or eliminate (candidates)/
ふるえ音 [ふるえおん] /(n) (ling) trill/
ふるまい酒 [ふるまいざけ] /(n) treat of sake/
ふれあい動物園 [ふれあいどうぶつえん] /(n) petting zoo/
ふわっと /(adv,vs) (1) (on-mim) floating/drifting/weightlessness/(2) (on-mim) softly/gently/lightly/
ふわり /(adv-to) (on-mim) softly/gently/lightly/(P)/
ふん /(int) (1) hmm/well .../humph/huh/pshaw/pish/(pref) (2) roughly/harshly/violently/
ふんぞり返る [ふんぞりかえる] /(v5r,vi) (1) to lie on one's back with legs outstretched/to recline/(2) to get cocky/to be arrogant/
ふんだくる /(v5r,vt) (1) to snatch/to grab/to steal/(2) to charge (an exorbitant price) for/
ふんだん /(adj-na,n) plentiful/abundant/lavish/
ふんどし担ぎ [ふんどしかつぎ] /(n) (1) (uk) (col) rikishi of the lowest rank/(2) underling/
ふんなんに /(adv) in plenty/fully/
ふんわり /(adv-to,adv) (on-mim) gently/airily/fluffily/(P)/
ふん縛る [ふんじばる] /(v5r,vt) to tie fast/
ふ化 [ふか] /(n,vs) incubation/hatching/
ふ頭 [ふとう] /(n) pier/wharf/quay/
ふ卵 [ふらん] /(n,vs) incubation/hatching/
ぶーん /(adv-to,adv) (1) whirr/hum/buzz/(2) whoosh/woosh/whiz/
ぶうぶう /(adv) (1) (on-mim) bugling sound/honking/oinking/(2) (on-mim) grumbling/complaining/(n) (3) (chn) car/automobile/
ぶうん /(adv-to,adv) (1) whirr/hum/buzz/(2) whoosh/woosh/whiz/
ぶかぶか /(adj-na,adv,n,vs,adj-no) (on-mim) too big/baggy/(P)/
ぶきっちょ /(adj-na,n) awkward/
ぶくぶく /(adj-na,adv,n,vs) (1) (on-mim) bulging/swelling (e.g. with water)/loose-fitting or baggy (clothing)/(2) bubbling/foaming/
ぶくり /(adv) sound of something floating or sinking in water/
ぶすっと /(adv,vs) (1) (on-mim) sound of something thick and soft being pierced by something sharp and hard/(2) containing sullen anger or discontempt/
ぶすぶす /(adv-to,vs) (on-mim) sputtering/smoldering/
ぶち壊す [ぶちこわす] /(v5s,vt) to destroy/to spoil/to crush/to break by striking/to wreck/
ぶち開ける [ぶちあける] /(v1,vt) (1) to forcefully open up a hole (in a wall, etc.)/(2) to speak frankly, holding nothing back/(3) to throw out everything inside/
ぶち込む [ぶちこむ] /(v5m) to drive in (e.g. nail, stake)/to devote oneself to/to shoot into/to smash/to throw into/to cast into/
ぶち切れ [ぶちきれ] /(adj-f) livid/
ぶち切れ [ぶちぎれ] /(adj-f) livid/
ぶち切れる [ぶちきれる] /(v1) (col) to be enraged/to flip out/
ぶち切れる [ぶちぎれる] /(v1) (col) to be enraged/to flip out/
ぶち当たる [ぶちあたる] /(v5r) (1) to slam into (e.g. a wall, a limit) (figuratively)/to hit/(2) to face (e.g. trouble, a problem)/to confront/
ぶち破る [ぶちやぶる] /(v5r) (col) to smash down/to beat in/
ぶち抜き [ぶちぬき] /(n) (1) removing a partition/(adv) (2) (col) straight through without interruption/
ぶち明ける [ぶちあける] /(v1,vt) (1) to forcefully open up a hole (in a wall, etc.)/(2) to speak frankly, holding nothing back/(3) to throw out everything inside/
ぶっきら棒 [ぶっきらぼう] /(adj-na,n) curt/blunt/brusque/(P)/
ぶった切る [ぶったぎる] /(v5r,vt) to chop (a branch, etc.)/
ぶっちゃけ /(n) speaking one's mind and holding nothing back/
ぶっちゃける /(v1,vt) to be frank .../to put things bluntly .../
ぶっつけ /(n,adj-na) without preparation/off the cuff/abrupt/outspoken/(at) first/
ぶっつけ本番 [ぶっつけほんばん] /(n,adj-no) performing without rehearsal/
ぶっとい /(adj-i) fat/thick/
ぶっとび /(adj-f) (sl) surprise/surprising/
ぶっ違い [ぶっちがい] /(n) diagonal cross/x-shaped cross/
ぶっ壊す [ぶっこわす] /(v5s,vt) (col) to destroy/to crush/to wreck/
ぶっ掛ける [ぶっかける] /(v1,vt) to dash (slosh) water (or other liquid) on a person or in a person's face/
ぶっ殺す [ぶっころす] /(v5s,vt) to beat to death/to kill/
ぶっ続け [ぶっつづけ] /(adv) (1) (uk) continuously/throughout/(2) in succession/
ぶっ叩く [ぶったたく] /(v5k) to beat vigorously/to rain stikes upon someone/to tan someone's hide/to mericlessly pummel/to beat the daylights out of/
ぶっ通し [ぶっとおし] /(adj-no,n-t) continuous/
ぶっ倒す [ぶったおす] /(v5s) to knock down/
ぶっ倒れる [ぶったおれる] /(v1,vi) to fall flat/to collapse in a heap/
ぶっ飛ばす [ぶっとばす] /(v5s,vt) (1) to strike (as to send flying)/to beat/to knock/(2) to jump with force/to leap/(3) to accomplish a task very rapidly/(4) to drive at full speed (e.g. a car)/
ぶっ放す [ぶっぱなす] /(v5s) to fire a gun/to let off a gun/to loose off a shell/
ぶつかり合い [ぶつかりあい] /(n) collision/clashing/
ぶつかり合う [ぶつかりあう] /(v5u,vt) to collide/to clash/
ぶつくさ /(adv) moaning/muttering/complaining/
ぶつぶつ /(n,adv,adv-to) (1) (on-mim) grunt/grumble/complaint/mutter/(2) pimples/spots/eruption/rash/(3) cutting into small pieces/(4) simmering/(P)/
ぶつ切り [ぶつぎり] /(n,vs) chunk (cooking)/lump/thick slice/
ぶどう酒 [ぶどうしゅ] /(n,adj-no) (grape) wine/
ぶなの木 [ぶなのき] /(n) Japanese beech tree/
ぶほっっ /(int) boohoo (crying)/
ぶよぶよ /(adj-na,adv,n,vs) (on-mim) soft and flabby/
ぶらっと /(adv) (1) limply/(2) idly/(3) aimlessly/
ぶらつく /(v5k,vi) to dangle/to swing/to stroll about/to hang around/to linger/
ぶらぶら /(adj-na,adv,adv-to,vs) (1) (on-mim) dangling heavily/swaying to and fro/swinging/(adv,adv-to,vs) (2) (on-mim) strolling/rambling/roaming/wandering/(3) (on-mim) idly/lazily/leisurely/aimlessly/(4) (on-mim) persisting (of an illness)/(P)/
ぶらり /(adv-to,adv) (1) (on-mim) dangling/(2) (on-mim) aimlessly/casually/idly/(3) (on-mim) unexpectedly/
ぶらりぶらり /(adv-to,adv) (on-mim) dangling heavily/swaying to and fro/swinging/
ぶら下がり [ぶらさがり] /(n) (1) (id) cornering someone by lying in wait, e.g. for an unexpected interview or photograph/doorstepping/(adj-f) (2) hanging/dangling/
ぶら下がりインデント [ぶらさがりインデント] /(n) (comp) hanging indent/
ぶら下がり取材 [ぶらさがりしゅざい] /(n) doorstop interview/doorstep interview/on-the-move interview/informal interview in which reporters surround a public figure and prod him for an off-the-cuff response/
ぶら下がる [ぶらさがる] /(v5r,vi) to hang from/to dangle/to swing/(P)/
ぶら下げる [ぶらさげる] /(v1,vt) to hang/to suspend/to dangle/to swing/to carry/(P)/
ぶりこ /(n) sailfin sandfish eggs/
ぶりっ子 [ぶりっこ] /(n,vs,adj-no) cutesy girl/child-like woman/
ぶりぶり /(adv,n,vs) (1) (on-mim) angrily/in a huff/in anger/(2) high on marijuana/
ぶり返す [ぶりかえす] /(v5s,vi) to come back/to return/to recur/
ぶるぶる /(adv,n,vs) (on-mim) shivering with cold or fear/shaking/trembling/(P)/
ぶるり /(adv-to,adv) (on-mim) with a vroom/with a sudden shaking/
ぶるん /(adv-to,adv) (on-mim) with a vroom/with a sudden shaking/
ぶれ /(n) camera shake/picture blur/
ぶれる /(v1,vi) to be blurred (photo, video, etc.)/for a camera to be shaken/
ぶんぶん /(n,adv) (on-mim) buzz/hum/
ぶん殴る [ぶんなぐる] /(v5r,vt) to knock/
ぶん屋 [ぶんや] /(n) (abbr) newspaper reporter/
ぶん投げる [ぶんなげる] /(v1,vt) to throw (strongly, violently, etc.)/
ぶ厚い [ぶあつい] /(adj-i) bulky/massive/thick/heavy/
ぷいと /(adv) (on-mim) acting rudely and suddenly/
ぷちぷち /(adv-to,adv,vs) (1) (on-mim) sound of bubbles (or other small objects) being popped/(2) (on-mim) lumpy sensation (e.g. of food)/(n) (3) little bits/small grains/
ぷっつん /(n,vs) (1) (sl) weird/crazy/losing common sense/snapping/(2) sound of a stretched string snapping/
ぷっと /(adv) (1) puffing motion (when blowing, spitting, etc.)/(2) pouting (with displeasure)/
ぷつん /(n,adv-to) snap (sound of something being suddenly and irreversibly broken)/
ぷにぷに /(adj-f) squishy/
ぷよぷよ /(n) jelly-like/
ぷりぷり /(adv,n,vs) (1) (on-mim) angrily/in a huff/in anger/(2) high on marijuana/(3) tender (to chew)/
ぷりぷりして /(adv) in an angry mood/in anger/angrily/in a huff/
ぷりぷり怒る [ぷりぷりおこる] /(exp,v5r) to be in a huff/
ぷるぷる /(adv-to) (1) yielding, soft, elastic/(n,vs) (2) jiggle, bounce, slightly trembling/
ぷんと /(adv,vs) (on-mim) crossly/angrily/
ぷんぷん /(adv,vs,adv-to) (1) (on-mim) intense smell (hanging around)/(2) state of being furious or angry/
ぷんぷんして /(adv) in an angry mood/in anger/angrily/in a huff/
へ /(prt) indicates direction or goal (e.g. "to")/(P)/
へいへい /(int) (col) yeah, yeah (used for half-hearted or insincere agreement)/
へえ /(int) oh, yes?/really?/
へきへき /(n,vs) being gobsmacked/being struck dumb/being fed up with something/
へき地 [へきち] /(n) (sens) remote place/backcountry/the sticks/
へぎ板 [へぎいた] /(n) splint/shingle/
へこき虫 [へこきむし] /(n) fart bug/
へこき蟲 [へこきむし] /(n) fart bug/
へこたれる /(v1,vi) to lose heart/
へこへこ /(adv,adv-to,vs) (1) pliantly/pliably/(2) ingratiatingly/
へご /(n) (uk) Cyathea spinulosa (species of tree fern)/
へしむくれ /(exp) term of abuse about someone's looks, etc./
へし折る [へしおる] /(v5r,vt) to smash/to break/
へそくり金 [へそくりがね] /(n) secret savings/
へその緒 [へそのお] /(n) umbilical cord/
へそを曲げる [へそをまげる] /(exp,v1) to get angry/to become perverse/
へそ曲がり [へそまがり] /(n,adj-na,adj-no) perverseness/devil's advocate/
へそ曲り [へそまがり] /(n,adj-na,adj-no) perverseness/devil's advocate/
へたこいた /(exp) (sl) failed/
へたの横好き [へたのよこずき] /(n) being crazy about something but being very bad at it/
へたばる /(v5r,vi) to be exhausted/to be worn out/
へたり込む [へたりこむ] /(v5m) to sit down hard/to sink down to the floor/
へたる /(v5r) to fall on one's backside/to be exhausted/to lose strength/to lose one's abilities/
へたれ /(n,adj-na) (col) (ksb:) good-for-nothing/incompetent/lazy/
へちむくれ /(exp) term of abuse about someone's looks, etc./
へちゃむくれ /(exp) term of abuse about someone's looks, etc./
へちゃもくれ /(exp) term of abuse about someone's looks, etc./
へったくれ /(exp) to hell with/be damned/
へっぴり腰 [へっぴりごし] /(n) (1) bent back/prone posture/(2) weak-kneed/timidity/lack of nerve/
へっぽこ /(n,adj-na) hack/untrained/quack (doctor)/
へとへと /(adj-na,n,adj-no) completely exhausted/(P)/
へどもど /(vs,adv) flustered/flurried/stuttering (e.g. an apology)/
へどろ /(n) sludge/slime/chemical ooze/
へなへな /(adj-na,adv,n,vs) (on-mim) bending/loss of strength/
への字 [へのじ] /(n) mouth shaped like a kana "he" character/mouth turned down at the corners/
への字に結んだ口 [へのじにむすんだくち] /(n) mouth shaped like a kana "he" character/mouth turned down at the corners/
へばり付く [へばりつく] /(v5k) to cling to/
へばる /(v5r,vi) to be exhausted/to be worn out/
へべれけ /(adj-na) (col) drunk/blotto/
へぼ /(adj-na,n) bungler/greenhorn/clumsy/poor hand/
へぼい /(adj-i) clumsy/unskillful/bungling/poor/bad/
へぼ医者 [へぼいしゃ] /(n) quack doctor/
へま /(adj-na,n) blunder/bungle/gaffe/
へまをやる /(exp,v5r) to commit a blunder/
へらへら /(adj-na,adv,n,vs) (on-mim) frivolous/
へりくだった /(exp) condescending/modest/
へりくだって /(exp) cap in hand/
へろへろ /(adj-na,adv-to,vs) completely exhausted/dog-tired/dreadfully weary/terribly frustrated/limp/weak/flimsy/
へん /(exp) (ksb:) suffix used to negate a verb in the non-past tense/
へんとう炎 [へんとうえん] /(n) tonsillitis/
べ /(aux) (1) (ktb:) (thb:) word used at sentence-end (like a particle) to indicate speculation, volition or invitation/
べーだ /(int) (abbr) sound often made when performing the akanbe- (childish and insulting) gesture/
べーっだ /(int) (abbr) sound often made when performing the akanbe- (childish and insulting) gesture/
べえ /(aux) (1) (ktb:) (thb:) word used at sentence-end (like a particle) to indicate speculation, volition or invitation/
べからざる /(exp) cannot/must not/
べか船 [べかぶね] /(n) small sailing boat used for collecting nori, etc./
べきではない /(exp) should not/must not/
べき乗打切り待機法 [べきのりうちきりたいきほう] /(n) (comp) truncated binary exponential back-off/
べく /(aux-v,conj) (1) in order to/for the purpose of/(aux,suf) (2) must/should/
べくもない /(exp) cannot possibly be/
べこべこ /(n) empty/hungry/
べし見 [べしみ] /(n) beshimi/type of Noh mask with a slanted mouth, bulging eyes and large nostrils/
べそ /(n) child's tear-stained face/
べそをかく /(exp,v5k) to be ready to cry/to be on the point of tears/
べそを作る [べそをつくる] /(exp,v5r) (uk) to be ready to cry/to be on the point of tears/
べた /(adj-na) (1) things without gaps or spaces between them/something painted or printed solid/(2) (comp) plain (e.g. plain text)/(3) (sl) cliched/hackneyed/
べたべた /(adj-na,adv,n,vs) (1) (on-mim) sticky/(2) all over/(3) clinging (e.g. of a person)/following around/(adj-na) (4) cliched/hackneyed/(P)/
べたんこ /(adj-no) squished flat/
べた惚れ [べたぼれ] /(n,vs) (falling) deeply in love/
べた焼き [べたやき] /(n) contact print/
べた組み [べたぐみ] /(n) solid printing/solid typesetting/
べた塗り内部様式 [べたぬりないぶようしき] /(n) (comp) solid interior style/
べた付く [べたつく] /(v5k,vi) (1) (uk) to be sticky/(2) to be close together/
べた褒め [べたほめ] /(n,vs) high praise/eulogy/rave review/
べた褒め [べたぼめ] /(n,vs) high praise/eulogy/rave review/
べちゃべちゃ /(adj-na,adv,vs) (on-mim) chattering/prattling/gooey/messy (from mud, ink, etc.)/
べちゃんこ /(adj-no) squished flat/
べったり /(adv,n) closely/thickly/hard/
べっとり /(adv) (1) sticky/thick (e.g. thickly plastered)/ikky/gummy/(2) to stick closely/
べっ甲 [べっこう] /(n) (1) tortoiseshell (of the hawksbill turtle)/bekko/(2) (in Chinese medicine) tortoiseshell (esp. of the Chinese soft-shelled turtle)/
べとつく /(v5k,vi) to be sticky/
べとべと /(adj-na,adv,n,vs) (on-mim) being sticky/
べと病 [べとびょう] /(n) downy mildew (disease)/
べらべら /(adj-na,adv,n,vs) (1) (on-mim) non-stop talking/speaking indiscreetly/chattering/(2) thin/flimsy/
べらぼう奴 [べらぼうめ] /(n) (derog) (uk) moron/idiot/
べらんめえ /(exp) bloody fool!/
べろっと /(adv) licking/sticking out one's tongue/
べろべろ /(adv,adv-to) (1) (on-mim) licking/(adj-na) (2) drunken/
べろべろ嘗める [べろべろなめる] /(exp,v1) (uk) to lick something up/to lap something up/
べろべろ舐める [べろべろなめる] /(exp,v1) (uk) to lick something up/to lap something up/
べろんべろん /(adj-na) (1) drunken/
べんべら /(n) worn-out silk clothes/cheap items/
ぺ /(aux) (1) (ktb:) (thb:) word used at sentence-end (like a particle) to indicate speculation, volition or invitation/(suf) (2) familiar suffix used after a personal name/
ぺこぺこ /(adj-na,adv,n,vs) (1) (on-mim) fawning/being obsequious/cringing/(2) being very hungry/(3) giving in/being dented/(P)/
ぺこり /(adv,adv-to) (1) sound of thin metal or plastic surface caving in and springing back/(2) action of quickly bowing or lowering one's head/
ぺこりと /(adv,adv-to) (1) sound of thin metal or plastic surface caving in and springing back/(2) action of quickly bowing or lowering one's head/
ぺこん /(adv,adv-to) (1) sound of thin metal or plastic surface caving in and springing back/(2) action of quickly bowing or lowering one's head/
ぺこんと /(adv,adv-to) (1) sound of thin metal or plastic surface caving in and springing back/(2) action of quickly bowing or lowering one's head/
ぺしゃんこ /(adj-na,adj-no) (1) crushed flat/flattened/squashed/flat-topped/(n) (2) (col) (m-sl) flat-chested girl/(3) (on-mim) sound of a sticky rice cake sticking to something/
ぺたぺた /(adv) (on-mim) sound of a flat surface repeatedly making contact with something/
ぺたり /(adv-to) slapping on/flopping down/
ぺたん /(adv) (on-mim) sound of something making firm contact with a flat surface/
ぺたんこ /(adj-na,adj-no) (1) crushed flat/flattened/squashed/flat-topped/(n) (2) (col) (m-sl) flat-chested girl/(3) (on-mim) sound of a sticky rice cake sticking to something/
ぺちゃくちゃ /(adv,vs) (on-mim) chattering/chit-chat/(ladies) prattle/
ぺちゃぱい /(n) small breasts/flat-chested/
ぺちゃぺちゃ /(adv) (1) chatter/prattle/(2) sound of juicy food being bitten into/
ぺちゃんこ /(adj-na,adj-no) (1) crushed flat/flattened/squashed/flat-topped/(n) (2) (col) (m-sl) flat-chested girl/(3) (on-mim) sound of a sticky rice cake sticking to something/
ぺったり /(adv) closely/fast/
ぺったん /(adv-to) flattening/
ぺったんこ /(adj-na,adj-no) (1) crushed flat/flattened/squashed/flat-topped/(n) (2) (col) (m-sl) flat-chested girl/(3) (on-mim) sound of a sticky rice cake sticking to something/
ぺっちゃんこ /(adj-na,adj-no) (1) crushed flat/flattened/squashed/flat-topped/(n) (2) (col) (m-sl) flat-chested girl/(3) (on-mim) sound of a sticky rice cake sticking to something/
ぺてん /(n) fraud/swindle/
ぺてん師 [ぺてんし] /(n) swindler/imposter/crook/
ぺらっ /(adv-to) (1) flipping (e.g. a page), peel off/(2) fluently/
ぺらぺら /(adj-na,adv,n,vs) (1) (on-mim) fluent/fluency/(2) flipping (pages)/(3) thin or weak (paper, cloth)/(P)/
ぺろりと /(adv) (on-mim) while sticking out one's tongue/
ぺろりと平らげる [ぺろりとたいらげる] /(exp,v1) to make short work of/to eat up quickly/
ぺんぺん /(n,vs) smack/spanking/
ぺチャパイ /(n) small breasts/flat-chested/
ほいほい /(adv) (1) Shoo! (used to drive away people or animals)/without considering the pros and (particularly) the cons/thoughtlessly/readily/blithely/willingly/(vs) (2) to pamper/to spoil/
ほうき星 [ほうきぼし] /(n) comet/
ほうじ茶 [ほうじちゃ] /(n) roasted green tea/
ほうっと /(adv) deeply/
ほうの木 [ほうのき] /(ik) (ik) (n) (uk) magnolia (Magnolia obovata)/Japanese big leaf magnolia/
ほうほうの体 [ほうほうのてい] /(exp) scuttling (to escape in a panic, in shame, etc.)/scurrying/scrambling/
ほうらいえそ /(n) (uk) Sloane's viperfish (Chauliodus sloani)/
ほうり込む [ほうりこむ] /(v5m,vt) to throw into/to toss into/
ほうり出す [ほうりだす] /(v5s,vt) to throw out/to fire/to expel/to give up/to abandon/to neglect/
ほうり投げる [ほうりなげる] /(v1,vt) to throw/to fling/to heave/to toss/
ほうれん草 [ほうれんそう] /(n) spinach/
ほお紅 [ほおべに] /(n) rouge/blusher/
ほかす /(v5s,vt) (ksb:) to throw away/to dispose/
ほかっておく /(v5k) (col) to leave alone/to leave as is/to ignore/to neglect/
ほかない /(exp) can do nothing but (do)/cannot help (doing) something/
ほかほか /(adj-na,adv,n,vs,adj-no) (on-mim) steamy hot food/warm(ly)/
ほかほか弁当 [ほかほかべんとう] /(n) hot bento/
ほか弁 [ほかべん] /(n) hot bento/
ほくそ笑む [ほくそえむ] /(v5m,vi) to chuckle/to snicker/
ほくほく /(adv,n,vs) (1) (on-mim) not soggy/(2) pleased with oneself/chuckling to oneself/
ほざく /(v5k,vt) (vulg) to say/to spatter/to prate/to prattle/to babble/to grumble/to murmur/to brawl/
ほじそ /(n) flowers heads of beefsteak plant (food)/
ほそぼそ話す [ほそぼそはなす] /(v5s) to speak slowly and quietly/
ほそ道 [ほそみち] /(n) narrow path/narrow lane/
ほぞ /(n) (uk) tenon/cog/dovetail/pivot/
ほぞを噛む [ほぞをかむ] /(exp,v5m) to regret bitterly/to be very sorry (for)/
ほぞを固める [ほぞをかためる] /(exp,v1) to make up one's mind (to do something)/to resolve firmly (to do something)/
ほぞんかけたか /(n) calling sound of the lesser cuckoo/
ほぞ穴 [ほぞあな] /(n) mortice/mortise/
ほたえる /(v1,vi) (1) (arch) to mess around/to clown around/(2) (arch) to take advantage of/to be spoiled/to be spoilt/
ほだえる /(v1,vi) (1) (arch) to mess around/to clown around/(2) (arch) to take advantage of/to be spoiled/to be spoilt/
ほっかいろ /(n) (chemical) body warmer/
ほっけ /(n) Arabesque greenling (Pleurogrammus azonus)/Okhostk Atka mackerel/
ほっこり /(adv-to,vs) (1) (on-mim) warm and fluffy/soft/(2) steamy hot (food)/hot and flaky/(exp) (3) (ksb:) feeling mentally tired/feeling of tired relief or accomplishment after effort or perseverance/
ほっそり /(n,vs,adv,adv-to) (on-mim) being slim/slender/
ほっつき歩く [ほっつきあるく] /(v5k) (col) to loiter around/to wander about/
ほっつく /(v5k,vi) (1) to loiter/(2) to waste money/
ほっと /(adv,n,vs) (on-mim) feeling relieved/(sigh of) relief/(P)/
ほっといて /(exp) back off!/leave me alone!/(P)/
ほっといてくれ /(exp) back off!/leave me alone!/(P)/
ほっほっほっ /(exp) Hohoho, as for Santa Clause/
ほっぽかす /(v5s) (obsc) (col) to leave/to skip out/
ほっぽらかす /(v5s,vt) to neglect/to abandon/
ほっぽり出す [ほっぽりだす] /(v5s,vt) to throw out/to fire/to expel/to give up/to abandon/to neglect/
ほつく /(v5k,vi) (1) to loiter/(2) to waste money/
ほつれ髪 [ほつれがみ] /(n) unkempt hair/
ほとおり星 [ほとおりぼし] /(n) (1) constellation/(2) (arch) mansion (any of the Chinese constellations used to divide the ecliptic into 28 positions)/(3) Chinese "star" constellation (one of the 28 mansions)/
ほとばしり出る [ほとばしりでる] /(v1) to gush out/to gush forth/to effuse/
ほとんどの人 [ほとんどのひと] /(exp) most people/
ほどき物 [ほどきもの] /(n) unsewing/clothes to be unsewn/
ほどのことは無い [ほどのことはない] /(exp) (uk) not worth (getting angry about, etc.)/
ほどの事はない [ほどのことはない] /(exp) (uk) not worth (getting angry about, etc.)/
ほど遠い [ほどとおい] /(adj-i) far off or away/
ほど近い [ほどちかい] /(adj-i) near/nearby/not far off/
ほな /(int) (osb:) well then/
ほにゃらら /(exp) something something (used to indicate a blank to be filled in)/
ほの暗い [ほのぐらい] /(adj-i) gloomy/obscure/
ほの字 [ほのじ] /(n) the L-word (i.e. love)/
ほの明かり [ほのあかり] /(n) faint light/dim light/
ほふく前進 [ほふくぜんしん] /(n,vs) crawling along/
ほほえみ返す [ほほえみかえす] /(v5s) to smile back (at a person)/to answer someone's smile/
ほほ笑み [ほほえみ] /(n) smile/
ほほ笑む [ほほえむ] /(v5m,vi) to smile/
ほめぱげ /(n) (sl) homepage/home page/
ほめ言葉 [ほめことば] /(n) words of praise/eulogy/compliment/
ほやほや /(adj-na,adj-no,adv) (on-mim) fresh/new/
ほら /(conj,exp) look!/look out!/look at me!/(P)/
ほらね /(int) see/you see/ha/
ほらを吹く [ほらをふく] /(exp,v5k) to boast/to brag/
ほら貝 [ほらがい] /(n) (uk) conch (Charonia tritonis)/trumpet shell/
ほら穴 [ほらあな] /(n) cave/den/grotto/
ほら吹き [ほらふき] /(n) braggart/boaster/
ほら話 [ほらばなし] /(n) tall story/cock-and-bull story/
ほれ込む [ほれこむ] /(v5m,vi) to be charmed by/
ほろほろ /(adv) (1) (on-mim) by ones and twos/(2) tears or flower petals falling quietly/(3) gurgling bird sound/
ほろほろ鳥 [ほろほろちょう] /(n) guinea fowl/
ほろり /(adv-to) (on-mim) being moved (to tears)/being touched by/becoming sentimental/
ほろ苦い [ほろにがい] /(adv,adj-i) bittersweet/slightly bitter/something that has a strong taste that adults favor/
ほろ子 [ほろし] /(n) (arch) rash/skin eruption/
ほろ子 [ほろせ] /(n) (arch) rash/skin eruption/
ほろ酔い [ほろよい] /(n) slight intoxication/
ほんで /(conj) (ksb:) and/thereupon/because of that/
ほんのり /(adv,n) slightly/faintly/
ほんわか /(adv,adv-to) (on-mim) warm/snug/
ほんわかした /(adj-f) (uk) warm and snug/soft and comfortable/
ほんわかとした /(adj-f) (uk) warm and snug/soft and comfortable/
ほ場 [ほじょう] /(n) cultivated land (field, garden, orchard, etc.)/
ほ乳動物 [ほにゅうどうぶつ] /(n) mammal/
ほ乳瓶 [ほにゅうびん] /(n) baby bottle/
ほ乳類 [ほにゅうるい] /(n) mammal/mammalian/
ぼーっと /(adv,n,vs) (on-mim) doing nothing/being stupefied/faintly/vaguely/in flames/flushingly/abstractedly/dazedly/blankly/dimly/hazily/dreamily/indistinctly/
ぼいん /(n) big breasts/
ぼうぜん自失 [ぼうぜんじしつ] /(n,vs,adj-no) stupor/stupefaction/trance/(being) dumbfounded/
ぼうっと /(adv,n,vs) (on-mim) doing nothing/being stupefied/faintly/vaguely/in flames/flushingly/abstractedly/dazedly/blankly/dimly/hazily/dreamily/indistinctly/
ぼうぼう /(adv-to,adv) (on-mim) burning vigorously/burning furiously/
ぼう張 [ぼうちょう] /(n,vs,adj-no) expansion/swelling/increase/growth/
ぼおっと /(adv,n,vs) (on-mim) doing nothing/being stupefied/faintly/vaguely/in flames/flushingly/abstractedly/dazedly/blankly/dimly/hazily/dreamily/indistinctly/
ぼくぼく /(adv,adv-to,vs) (1) (arch) (of soil, etc.) soft, dry and crumbly/(2) sound of quiet walking/
ぼけっと /(adv,vs) being stupified/doing nothing/
ぼこぼこ /(n-adv) (1) (on-mim) burbling/(2) hollow (sounding)/(3) holey/full of holes/
ぼこる /(v5r) (sl) to beat the hell out of/
ぼさっと /(adv,vs) (1) absent-mindedly/vacantly/idly/lazily/
ぼさぼさ /(adj-na,adv,n,vs,adj-no) (on-mim) unkempt, ruffled hair or brush bristles/idling away time/
ぼそっと /(adv,vs) (1) absent-mindedly/vacantly/idly/lazily/(2) in a whisper/
ぼそぼそ /(adj-na,adv,n,vs,adv-to) (1) (on-mim) dry and crumbling/(2) whispering/subdued/(3) tasteless/flavorless/flavourless/
ぼそり /(adv) whispering/murmuring/subdued/
ぼたぼた /(adv,adv-to,n) (on-mim) drip drip/
ぼたり /(adv,adv-to) falling with a splat/oozing/dripping/
ぼだいさった /(n) (Buddh) bodhisattva/
ぼちぼち /(adv,adv-to) (1) (on-mim) little-by-little/gradually/slowly/soon/(adj-na) (2) (ksb:) not bad/passable/so-so/
ぼちゃぼちゃ /(adv,n,vs) (1) splash water/dabble in water/splashing sound/
ぼちゃんと /(adv) (on-mim) with a splash/
ぼったくり /(n) (ksb:) rip-off/unfair overcharging/clip joint/
ぼったくる /(v5r) to rip someone off/
ぼったり /(adv,adv-to) falling with a splat/oozing/dripping/
ぼっちゃま /(n) (hon) son/boy/
ぼってり /(adj-f) (1) fleshy/plump/chubby/corpulent/(vs) (2) to apply thickly/to slap on/to coat with something thick/
ぼつぼつ /(adv,n) (on-mim) gradually/here and there/spots/pimples/
ぼとぼと /(adv) dripping/in drops/
ぼぼ /(n) baby/doll/pussy(cat)/slang for cunt/
ぼやかす /(v5s,vt) to make ambiguous/
ぼやく /(v5k,vi) to grumble/to complain/
ぼやける /(v1,vi) to become dim/to become blurred/(P)/
ぼやっと /(adv,vs) (on-mim) absentmindedly/dazedly/vaguely/
ぼらぼら /(exp) one after another/
ぼりぼり /(adv) (on-mim) munch/crunch/
ぼりぼり食べる [ぼりぼりたべる] /(exp,v1) to eat with a munching or crunching sound/
ぼる /(v5r) to ask a high price/to overcharge/
ぼろい /(adj-i) (1) profitable/(2) worn-out/crumbling/
ぼろくそに言う [ぼろくそにいう] /(exp,v5u) to speak ill of/to speak very disparagingly about/to speak very harshly about/
ぼろっちい /(adj-i) (sl) worn-out/crumbling/
ぼろぼろ /(adj-na,adv,n,vs,adj-no) (1) (on-mim) worn-out/torn/crumbling/tattered/(2) tears or grain of rice falling/(P)/
ぼろを出す [ぼろをだす] /(exp,v5s) to reveal the faults/
ぼろ屋 [ぼろや] /(n) (1) run-down shabby house/(2) (arch) rag and scrap merchant/
ぼろ家 [ぼろや] /(n) (1) run-down shabby house/(2) (arch) rag and scrap merchant/
ぼろ切れ [ぼろきれ] /(n) old rag/
ぼろ布 [ぼろきれ] /(n) old rag/
ぼろ儲け [ぼろもうけ] /(n,vs) easy money/easy gain/
ぼんたん飴 [ぼんたんあめ] /(n) Botan Rice Candy (lemon orange flavored soft, chewy candy with an edible wrapper and includes a small Botan Ame)/Botan Ame/Bontan Ame/
ぼんぼん /(adv,adv-to) (1) fiercely (e.g. of a fire burning)/(2) bong-bong (of clock ringing)/(3) with repeated bangs (e.g. of fire cracker)/(n) (4) (abbr) striking clock/(5) (ksb:) green young man from a well-to-do family/
ぼんぼん時計 [ぼんぼんどけい] /(n) striking clock/wall clock/pendulum clock/
ぼんやり /(adv,adv-to,vs) (1) (on-mim) dimly/faintly/indistinctly/vaguely/(2) (on-mim) absentmindedly/vacantly/carelessly/(3) (on-mim) idly/aimlessly/(n) (4) absence of mind/fool/blockhead/dunce/(P)/
ぽい /(suf,adj-i) (1) (col) -ish/-like/(n) (2) (on-mim) tossing something out/throwing something away/
ぽいする /(vs-s,vt) (chn) to toss away/to throw out/
ぽいと /(adv) (on-mim) carelessly (throwing, tossing, etc.)/nonchalantly/
ぽい捨て [ぽいすて] /(n) littering, esp. such things as empty cans, cigarette butts, dog faeces, etc. along roads, in parks, etc./careless tossing away/
ぽうっと /(adv,vs) (1) (on-mim) shrill whistling sound/(2) reddening or brightening slightly/(3) rush of blood to the head/
ぽか /(n,vs) (col) blunder/(careless) mistake/error/
ぽかぽか /(adv,n,vs,adv-to) (1) (on-mim) warmth throughout your body/(2) sound of beating someone/(P)/
ぽかよけ /(n) fool-proofing/mistake-proofing/error-proofing/fail-safe/
ぽかん /(adv-to) (1) (on-mim) vacantly/blankly/absentmindedly/(2) (on-mim) openmouthed/with one's mouth wide-open/gaping/flabbergasted/(3) (on-mim) with a whack/with a thump/(P)/
ぽきっと /(adv) (on-mim) snappingly/with a snap/
ぽこちん /(n) (col) penis/
ぽたぽた /(adv) (on-mim) dripping water/(P)/
ぽたぽた焼 [ぽたぽたやき] /(n) pota pota yaki (var. of senbei (rice cracker) coated with a sweet soy-sauce glaze on top)/
ぽたぽた落ちる [ぽたぽたおちる] /(exp,v1) to fall in drops/to drip down/to trickle down/
ぽたり /(adv-to) (1) (on-mim) drip/fall drop-by-drop/(2) suddenly (of drops of water)/
ぽちぽち /(adv,adv-to) (1) spattering/splotching/(2) step-by-step/little-by-little/(3) soon/(n) (4) dots/(5) ditto mark/
ぽちゃぽちゃ /(adv,n,vs) (1) splash water/dabble in water/splashing sound/(adj-f) (2) plump/chubby/
ぽちゃり /(adv-to,adv) (on-mim) splash/splosh/
ぽっ /(adv-to) (on-mim) with a blush/slightly flushed/fresh-faced/
ぽっかり /(adv,adv-to) (1) (on-mim) lightly/(2) gaping wide/
ぽっきり /(adv) merely/having just .../
ぽっくり /(adv) suddenly (e.g. sudden death)/
ぽっちゃり /(adv,adv-to) plump/chubbily/
ぽっちり /(adv,adv-to) very slightly/a little/
ぽっつり /(adv-to,adv) (1) (on-mim) isolated/standing alone/(2) falling in drops (e.g. rain)/(3) sighing (when saying something)/
ぽってり /(adv,vs) plump/fat/
ぽっと /(adv,vs) (1) (on-mim) slightly (blushing)/(2) (on-mim) suddenly (getting bright, flaring up, flashing on, etc.)/(3) (on-mim) distractedly/
ぽつぽつ /(adv,n) (on-mim) bit by bit/piece by piece/spots/pimples/
ぽつり /(adv-to,adv) (1) (on-mim) isolated/standing alone/(2) falling in drops (e.g. rain)/(3) sighing (when saying something)/
ぽつん /(adv-to,adv) (1) (on-mim) isolated/standing alone/(2) falling in drops (e.g. rain)/(3) sighing (when saying something)/
ぽとぽと /(adv) (on-mim) trickle down in thick drops/
ぽとり /(adv-to) with a "plop" (of tears, drop of water, etc.)/
ぽとりと落ちる [ぽとりとおちる] /(exp,v1) to fall down with a "plop"/
ぽにょぽにょ /(exp) to be fat/
ぽりぽり /(adv) (on-mim) crunching sound/
ぽろぽろ /(adj-na,adv,n,vs) (on-mim) in large drops/
ぽろり /(adv) (1) crying/(2) falling off/falling down/(3) inadvertently coming to the surface/
ぽん /(adv) (on-mim) pop/plop/cloop/
ぽんと /(adv) (on-mim) with a pop/
ぽん引き [ぽんびき] /(n) (1) tout/swindler/con-man/(2) pimp/
ぽん引き [ぽんぴき] /(n) (1) tout/swindler/con-man/(2) pimp/
まあ /(adv,conj,int) (fem) you might say/Oh!/Wow!/Well!/(P)/
まあね /(exp) well, I must admit .../
まあまあ /(adj-na,adv,int) (1) (on-mim) so-so/(int) (2) now, now (used in calming people down)/(3) (fem) my, my (expression of wonder, surprise, etc.)/(P)/
まい /(aux) (1) probably isn't (doesn't, won't, etc.)/(2) don't (doesn't) intend to/intend not to/(3) must not/(when used in an imperative sentence) don't/
まいう /(n,adj-f) (sl) delicious (slang reversal of "umai")/
まいうー /(n,adj-f) (sl) delicious (slang reversal of "umai")/
まいか /(exp) (used to make a request, etc.) won't you/
まいとーく /(n) (comp) Mytalk/
まいに /(conj) even though it is not/despite not/
まいゆ /(adj-f) (1) delicious/appetizing/appetising/(2) skillful/clever/expert/wise/successful/(3) fortunate/splendid/promising/
まいゆう /(adj-f) (1) delicious/appetizing/appetising/(2) skillful/clever/expert/wise/successful/(3) fortunate/splendid/promising/
まか不思議 [まかふしぎ] /(adj-na,n) mysterious/profound mystery/
まがい物 [まがいもの] /(n) imitation/fake/sham/
まがりかわ /(n) kanji "curving river" radical (variant of radical 47)/
まき込む [まきこむ] /(v5m,vt) to roll up/to involve/to enfold/to swallow up/to drag into/
まき散らす [まきちらす] /(v5s,vt) to scatter/to spread/
まくし立てる [まくしたてる] /(v1,vt) to talk on and on/
まくり上げる [まくりあげる] /(v1) to tuck (e.g. sleeves)/to roll up/
まぐわう /(v5u,vi) to have sexual intercourse/
まげわりふ /(n) kanji "crooked seal" radical at right (variant of radical 26)/
まごまご /(adv,n,vs) (on-mim) confused/(P)/
まさかの時 [まさかのとき] /(exp) in time of need/for a rainy day/in case of emergency/
まざまざ /(adv-to) (on-mim) plainly/clearly/vividly/
まし /(aux) (1) (pol) (used to make a polite request or demand) please/(2) used to increase the politeness of a greeting, apology, etc./
ましなんだ /(exp) (pol) (arch) suffix used to negate a verb in the past tense/
ましょ /(ik) (exp) (1) (pol) (used to express the speaker's volition) I'll/(2) (used to make an invitation, request, etc.) let's/(3) (used to express a conjecture) probably/
ましょう /(exp) (1) (pol) (used to express the speaker's volition) I'll/(2) (used to make an invitation, request, etc.) let's/(3) (used to express a conjecture) probably/
ましょうか /(exp) (1) shall I?/(2) shall we?/
まじ /(adj-na,n) (1) (sl) serious (not capricious or flirtatious)/(aux-v) (2) cannot/should not/will not/must not/
まじき /(aux-adj,adj-f) should not be/must not be/
まじまじと /(adv) staringly/fixedly/
まじまじと見る [まじまじとみる] /(exp,v1) to take a long hard look at something/
ます /(aux-v) (1) (pol) used to indicate respect for the listener (or reader)/(2) (arch) (hum) used to indicate respect for those affected by the action/
ますです体 [ますですたい] /(n) literary form imparting the nuance of polite speech (with sentences ending in "desu" and verbs ending in "masu")/
ます目 [ますめ] /(n) (1) measure/(2) square (e.g. of graph paper or Japanese manuscript paper)/(3) box (e.g. on a form)/
まずる /(v5r) to bungle/to make things awkward/
まず隗より始めよ [まずかいよりはじめよ] /(exp) he who first suggests it should be the first to do it/
ませ /(aux) (1) (pol) (used to make a polite request or demand) please/(2) used to increase the politeness of a greeting, apology, etc./
ませなんだ /(exp) (pol) (arch) suffix used to negate a verb in the past tense/
ませる /(v1) to seem grown-up/to seem mature/to be precocious/to be advanced for one's age/
ません /(exp) (pol) suffix used to negate a verb in the non-past tense/
ませんか /(exp) (1) (pol) (used to ask a question in the negative) won't (hasn't, isn't, doesn't, etc.)/(2) (used to make invitations, express desires or give indirect commands) won't you/(P)/
ませんかった /(exp) (pol) (arch) suffix used to negate a verb in the past tense/
ませんだった /(exp) (pol) (arch) suffix used to negate a verb in the past tense/
ませんでした /(exp) (pol) suffix used to negate a verb in the past tense/
またぎ /(n) ancient hunting communities in Touhoku/
またたく間に [またたくまに] /(adv) in the twinkling of an eye/in a flash/
またね /(exp) good-bye/see you later/(P)/
またの名 [またのな] /(n) alias/another name/
また逢う日まで [またあうひまで] /(exp) till we meet again/
また会う日まで [またあうひまで] /(exp) till we meet again/
また明日 [またあした] /(exp) (uk) see you tomorrow/
また来週 [またらいしゅう] /(exp) See you next week/
まだまだこれから /(exp) it's not over yet/you haven't seen anything yet/it's not over until the fat lady sings/it's too soon to tell/we're not out of the woods/(P)/
まったく気にかけない [まったくきにかけない] /(exp,adj-i) not be concerned about at all/not be troubled by/to not care about/
まったく気にならない [まったくきにならない] /(exp,adj-i) not be concerned about at all/not mind about at all/not care a bit/
まったり /(adj-f) (1) rich (taste)/full-bodied (flavour, flavor)/mellow(ness)/(2) laid-back (lifestyle)/
まっ四角 [まっしかく] /(n) square/
まっ正直 [まっしょうじき] /(adj-na,n) perfectly honest/
まっ昼間 [まっぴるま] /(n-adv,n-t) broad daylight/
まっ白 [まっしろ] /(adj-na,adj-no,n) pure white/
まつ毛 [まつげ] /(n,adj-no) (uk) eyelashes/
までなら /(exp) up to ... (e.g. items) (nuance of comparison)/until ... (times)/as far as/(P)/
までもない /(exp) (after verb phrase) doesn't amount to doing (something)/not significant enough to require (something)/(P)/
まとめ買い [まとめがい] /(n,vs) collecting together and buying/doing a big shop/
まとめ役 [まとめやく] /(n) mediator/peacemaker/troubleshooter/manager/
まどろこい /(adj-i) dull (e.g. of movement or reaction)/sluggish/
まどろこしい /(adj-i) dull (e.g. of movement or reaction)/sluggish/
まどろっこい /(adj-i) dull (e.g. of movement or reaction)/sluggish/
まどろっこしい /(adj-i) dull (e.g. of movement or reaction)/sluggish/
まなじりを決して [まなじりをけっして] /(exp) with one's eyes flashing/
まな板 [まないた] /(n) chopping board/
まの当り [まのあたり] /(adv,n) in one's presence/face to face/on the spot/before one's eyes/
まひょ /(ik) (exp) (1) (pol) (used to express the speaker's volition) I'll/(2) (used to make an invitation, request, etc.) let's/(3) (used to express a conjecture) probably/
まぶ達 [まぶだち] /(n) (col) true friend/close friend/
まへん /(exp) (pol) (ksb:) suffix used to negate a verb in the non-past tense/
まべ貝 [まべがい] /(n) (uk) penguin wing oyster (Pteria penguin)/
まま息子 [ままむすこ] /(n) stepson/
まま娘 [ままむすめ] /(n) stepdaughter/
まむし /(n) (food) (ksb:) broiled eel (usu. mixed into rice)/
まむし丼 [まむしどん] /(n) (ksb:) bowl of eel and rice (donburi)/
まむし丼 [まむしどんぶり] /(n) (ksb:) bowl of eel and rice (donburi)/
まやかし /(n,adj-no) deception/make-believe/fake/counterfeit/phony/
まやかす /(v5s,vt) to cheat/to swindle/to deceive/
まるあおめえそ /(n) (uk) Chlorophthalmus borealis (species of greeneye)/
まる覚え [まるおぼえ] /(n,vs) full memorization/full memorisation/
まわり灯篭 [まわりどうろう] /(n) revolving lantern/
まんざら夢ではない [まんざらゆめではない] /(exp,adj-i) not altogether a dream/
まんじり /(n) (1) (usu. with negative verb) nap/doze/short sleep/(adv-to) (2) staringly/fixedly/
まんじりともしない /(exp) not sleeping a wink/wide awake all night/
まんじりともせず /(exp) not sleeping a wink/wide awake all night/
まんまと /(adv) (on-mim) successfully/fairly/artfully/nicely/thoroughly/
まん丸 [まんまる] /(adj-na,n) perfect circle/
まん前 [まんまえ] /(adj-no,adv) right in front/just opposite/under the nose/
まん中 [まんなか] /(n) middle/centre/center/mid-way/
み /(suf) (1) -ness (nominalizing suffix, esp. of sensory or subjective adjectives)/(2) nominalizing suffix indicating location/(3) (as ...mi ...mi) alternating between ... and .../
みいちゃんはあちゃん /(exp) the follower of each new fad/
みいはあ /(adj-na,n) (1) (abbr) follower of each new fad/(2) (sl) poser/
みかじめ料 [みかじめりょう] /(n) protection money/
みかん箱 [みかんばこ] /(n) cardboard box for mandarin oranges/
みかん畑 [みかんばたけ] /(n) mandarin plantation/
みこしを据える [みこしをすえる] /(exp,v1) to ensconce oneself (e.g. in a chair)/to settle oneself down/to plant oneself/
みこしを担ぐ [みこしをかつぐ] /(exp,v5g) (1) to wheedle a person into doing something/(2) to carry a portable shrine/
みしみし /(adv,adv-to,vs) creaking/groaning (e.g. of something under physical stress)/
みじん切り [みじんぎり] /(n) finely chopped (cooking)/(P)/
みずほ銀行 [みずほぎんこう] /(n) Mizuho Bank/
みそ汁 [みそしる] /(n) miso soup/
みたい /(suf,adj-na) (col) -like/sort of/similar to/resembling/(P)/
みっちり /(adv) (1) severely/strictly/fully/(2) earnestly/diligently/
みつかけ星 [みつかけぼし] /(n) Chinese "Chariot" constellation (one of the 28 mansions)/
みどりの日 [みどりのひ] /(n) Greenery Day (national holiday; May 4)/
みなし子 [みなしご] /(n,adj-no) orphan/
みなし配当 [みなしはいとう] /(n) consent dividend/constructive dividend/deemed dividend/
みなし有価証券 [みなしゆうかしょうけん] /(n) deemed securities/
みなみじゅうじ座 [みなみじゅうじざ] /(n) Southern Cross/
みみっちい /(adj-i) tightfisted/stingy/miserly/small-minded/
みやげもの屋 [みやげものや] /(n) souvenir store/gift shop/
みやこたなご /(n) (uk) Tokyo bitterling (species of cyprinid fish, Tanakia tanago)/
みる貝 [みるがい] /(n) (uk) Tresus keenae (species of trough shell)/
みんなの党 [みんなのとう] /(n) Your Party (a Japanese political party)/
みんみん /(adv,n) (on-mim) seeing through another person's scheme (e.g. lies and flattery)/
みんみん蝉 [みんみんぜみ] /(n) (uk) Oncotympana maculaticollis (large black and green species of Oriental cicada)/
み国 [みくに] /(n) (1) (hon) country/(2) (hon) Japan/
み使い [みつかい] /(n) angel/
む /(int) (1) (arch) unh (sound of physical exertion)/oof/(2) wow/whoa/(3) yes/yeah/uh-huh/(aux-v) (4) (after a -nai stem) probably/(5) will/intend to/(6) would like to have done (for me)/
むうっと /(adv,vs) (1) (on-mim) sullenly/angrily/testily/huffily/petulantly/indignantly/(2) (on-mim) stuffily/stiflingly/(adv) (3) (on-mim) slowly (exhaling smoke)/
むかっと /(adv,vs) feeling angry (or nauseated, etc.) suddenly/
むかっ腹 [むかっぱら] /(n) anger/passion/
むかつく /(v5k,vi) to feel sick/to feel irritated/to feel offended/to feel angry/
むかむか /(adv,n,vs) (on-mim) nausea/queasy/surge of anger/(P)/
むき出し [むきだし] /(adj-na,n) nakedness/frankness/
むき出す [むきだす] /(v5s,vt) to show/to bare (the teeth)/
むき身 [むきみ] /(n) shellfish removed from the shell/
むくつけき /(adj-pn) coarse/uncultured/
むくむく /(adv,adv-to,vs) (1) (on-mim) rising up/towering/billowing (e.g. clouds of smoke)/(2) (on-mim) plump/chubby/fat/(3) (on-mim) shaggy/hairy/
むくり /(adv,adv-to,vs) (1) (rising) abruptly/
むさい /(adj-i) filthy/squalid/dirty/foul/sordid/
むささび /(n) (uk) giant flying squirrel (Petaurista leucogenys)/
むさ苦しい [むさくるしい] /(adj-i) (uk) filthy/squalid/dirty/foul/sordid/
むざむざ /(adv) helplessly/easily/without resistance/without regret/
むしゃくしゃ /(adv,vs) (1) vexed/irritated/fretful/in ill humour/in ill humor/in a temper/(2) shaggy/bushy/ragged/rugged/
むしゃむしゃ /(adv) munch/crunch/
むしょ送り [むしょおくり] /(n) being sent to prison/
むしり取る [むしりとる] /(v5r,vt) to tear off/to pluck off/
むず /(aux-v) (1) (arch) will probably be/(2) intending to/will/(3) should/
むずい /(adj-i) (abbr) difficult/
むずつく /(v5k,vi) to itch/
むずむず /(vs) (1) (on-mim) to feel itchy/to itch/to feel creepy/(2) to be impatient/to itch (to do something)/to be eager/
むずむず脚症候群 [むずむずあししょうこうぐん] /(n) Restless Leg Syndrome/RLS/
むずむず足症候群 [むずむずあししょうこうぐん] /(n) Restless Leg Syndrome/RLS/
むず痒い [むずがゆい] /(adj-i) (1) itchy/(2) creepy/feeling uneasy/
むせび泣き [むせびなき] /(vs) (1) to sob/to be choked with tears/(n) (2) sobbing/
むせび泣く [むせびなく] /(v5k,vi) to sob/to be choked with tears/
むせ返る [むせかえる] /(v5r,vi) to choke/to sob convulsively/to cough/
むだ骨 [むだぼね] /(n) useless/waste of time and effort/pointless/vain efforts/
むだ足 [むだあし] /(n,vs) visit for no reason/go on fool's errand/
むちむち /(adv-to,adv,vs) (on-mim) plump/chubby/voluptuous/
むち打ち [むちうち] /(n) (1) (abbr) whipping/beating with a whip/(2) (abbr) whiplash/
むち打ち症 [むちうちしょう] /(n) whiplash/
むち打つ [むちうつ] /(v5t,vt) to whip/to lash/to give the rod/to spur on/to encourage/
むっくり /(adv,adv-to,vs) (1) (rising) abruptly/(2) plump/rotund/
むっちり /(adv-to,adv,vs) (on-mim) plump/chubby/voluptuous/
むっちりと /(adv) (on-mim) plumply/
むっつり /(adv-to,adv,vs) (1) (on-mim) sullenly/taciturnly/morosely/gloomily/silently/(n) (2) taciturn person/uncommunicative person/(P)/
むっと /(adv,vs) (1) (on-mim) sullenly/angrily/testily/huffily/petulantly/indignantly/(2) (on-mim) stuffily/stiflingly/(P)/
むつ /(n) (uk) gnomefish (Scombrops boops)/
むつ五郎 [むつごろう] /(n) (uk) mudskipper (Boleophthalmus pectinirostris)/goggle-eyed goby/
むとす /(exp,vs-i) (1) (after a -nai stem) to be trying to/(2) to be just about to/
むにゃむにゃ /(adv) mumbling/incomprehensible muttering/talking with food in one's mouth/talking in sleep/
むねを冷やす [むねをひやす] /(exp,v5s) to be frightened/
むらさめ型護衛艦 [むらさめがたごえいかん] /(n) Murasame class destroyer/
むんず /(adv-to) strongly/violently/with all one's strength/
むんむん /(adv,n,vs) (1) (on-mim) stuffy/(2) woman's desire/
めい想 [めいそう] /(n,vs) meditation/contemplation/
めかけ奉公 [めかけぼうこう] /(n,vs) serving as a concubine/
めがねっ娘 [めがねっこ] /(n) (m-sl) girl (usu. attractive) with glasses/glasses-wearing girl/
めきめき /(adv) (on-mim) conspicuously/(P)/
めく /(suf,v5k) (1) to show signs of .../to have the appearance of .../(2) (X) (col) to jerk off/to masturbate/(P)/
めくら印 [めくらいん] /(n) (col) (obsc) (sens) rubber stamp/
めくら判 [めくらばん] /(n) (sens) approving a document without adequately reading it/rubber-stamping/
めくり上げる [めくりあげる] /(v1) to lift/to turn over/to fold over/
めぐり会う [めぐりあう] /(v5u) to meet fortuitously (e.g. running into an old friend)/to meet by chance/to happen across/
めぐり合う [めぐりあう] /(v5u) to meet fortuitously (e.g. running into an old friend)/to meet by chance/to happen across/
めぐり合わせ [めぐりあわせ] /(n) fate/chance/
めげる /(v1,vi) to be discouraged/to shrink from/
めじ /(n) young tuna (esp. northern bluefin tuna under 1 meter)/
めじろ押し [めじろおし] /(n) jostling/milling about/
めそめそ /(adv,n,vs) (on-mim) uncontrolled weeping/sobbing/
めためた /(adj-na,adv,adv-to) beyond repair/
めちゃぱい /(n) big breasts/
めっ /(int) used to scold small children and pets/
めっきり /(adv) remarkably/(P)/
めっさ /(adj-na) (sl) extremely/very/
めっちゃ /(adv) (sl) (ksb:) very/extremely/excessively/
めばち /(n) sty (on the eyelid)/stye/
めばちこ /(n) sty (on the eyelid)/stye/
めらめら /(adv,adv-to) (on-mim) flaring up/bursting into flames/
めりはりの利いた [めりはりのきいた] /(exp) explicit/clear/unambiguous/meaningful/lively/
めりはりを利かせた [めりはりをきかせた] /(exp) explicit/clear/unambiguous/meaningful/lively/
めりめり /(adv-to) (on-mim) splintering or cracking (e.g. in a strong wind)/
めり込む [めりこむ] /(v5m,vi) to sink into/to cave in/
めんこい /(adj-i) (thb:) lovely/sweet/cute/
めんご /(n) (sl) sorry (not very sincere)/
めんそーれ /(n) (rkb:) welcome/
めんそおれ /(n) (rkb:) welcome/
めん棒 [めんぼう] /(n) cotton swab/
めん棒 [めんぼう] /(n) rolling pin/
め組 [めぐみ] /(n) (arch) fire brigade (in Edo)/
め組の頭 [めぐみのかしら] /(n) (arch) fire brigade chief (in Edo)/chief fireman/
も /(prt) (1) also/too/words of similar weight/(2) about (emphasizing an upper limit)/as much as/even/(adv) (3) more/further/other/again/(P)/
もう /(adv,int) (1) already/anymore/(2) soon/shortly/(3) more/further/other/again/(int,adv) (4) interjection used to strengthen expression of an emotion (often exasperation)/(P)/
もういっちょ /(exp) (col) once more/again/
もうけ物 [もうけもの] /(n) good bargain/a find/godsend/a steal/
もうすっかり /(exp) already completed (arrived, happened, etc.)/(P)/
もうちょっとしたら /(exp) in a little while (referring to the very near future on the order of minutes)/in a bit/
もうひと頑張り [もうひとがんばり] /(n,vs) one more effort/
もうひと踏ん張り [もうひとふんばり] /(exp) holding out a little longer/
もうもう /(adv,adv-to) (1) (on-mim) mooing/(n) (2) (chn) moo-moo (i.e. kid's talk for "cow")/
もう一つ [もうひとつ] /(n,adv) (uk) another/one more/
もう一回 [もういっかい] /(exp) once more/once again/
もう一頑張り [もうひとがんばり] /(n,vs) one more effort/
もう一人 [もうひとり] /(n,adv) another (person)/the other person/one more (person)/
もう一度 [もういちど] /(exp) once more/again/
もう一踏ん張り [もうひとふんばり] /(exp) holding out a little longer/
もう一遍 [もういっぺん] /(exp) (uk) (ksb:) once more/again/
もう少し [もうすこし] /(exp) a bit more/a bit longer/
もう少しで [もうすこしで] /(exp) almost/nearly/close to/
もう少しのところで [もうすこしのところで] /(exp) almost/nearly/close to/
もう少しの所で [もうすこしのところで] /(exp) almost/nearly/close to/
もう直 [もうじき] /(exp,adv) (uk) soon/
もう直ぐ [もうすぐ] /(exp) (uk) very soon/
もがな /(prt) particle used to indicate the speaker's hope, desire, wish, etc. (e.g. "it would be nice if ...", "I wish there were ...", etc.)/
もぎたて /(adj-no) fresh-picked/
もぎり /(n) ticket-collector/
もぎる /(v5r,vt) (uk) to pluck/to pick/to tear off/
もぎ取る [もぎとる] /(v5r) (uk) to pluck off/to pick/to break or tear off/to wrest (away from)/to wrench free/to snatch (away)/
もくもく /(adv,adv-to) (on-mim) with clouds of smoke/
もくる /(v5r) (sl) to smoke/
もぐ /(v5g) (uk) to pluck (usually from a tree)/to pick (e.g. apples)/(P)/
もぐもぐ /(adv,vs,adv-to) (on-mim) mumbling/chewing one's words/
もぐら打ち [もぐらうち] /(n) driving away moles by hitting the ground with straw bundles prepared by children (esp. as an annual event on January 15th)/
もぐり込む [もぐりこむ] /(v5m,vi) to slip into/to crawl into (under)/to conceal oneself (under)/
もげる /(v1,vi) (uk) to be torn off/to come off/
もこもこ /(adj-f) lumpy/fluffy/
もごもご /(adv,vs,adv-to) (on-mim) mumbling/chewing one's words/
もさっと /(adv,vs) absentmindedly/
もさもさ /(vs) (1) hairy (person)/thickly bearded person/(2) slow person/dull person/
もさることながら /(exp) one may well say so, but .../even more than/
もし /(int) excuse me! (when calling out to someone)/
もしあれば /(exp) if any/if it exists/
もしかし /(exp,adv) (abbr) perhaps/maybe/by some chance/
もしかしなくても /(exp,adv) (col) no need to guess/certainly/
もしそうなら /(exp) if so/in that case/
もしそれが興奮させなかったら [もしそれがこうふんさせなかったら] /(exp) If it was not exciting/
もしもし /(int) (1) hello (e.g. on phone)/(2) excuse me! (when calling out to someone)/(P)/
もしもの事 [もしものこと] /(exp) emergency/accident/rare possibility/unexpected occurrence/
もしゃもしゃ /(adj-na,adv,vs) shaggy/scraggly/bushy/disheveled/dishevelled/unkempt/tousled/raggedy/
もし可能ならば [もしかのうならば] /(exp) if possible/
もじもじ /(adv,vs) (on-mim) bashfully/hesitantly/fidgety/restlessly/squirming/wriggling/haltingly/
もじゃもじゃ /(adj-na) tousled/shaggy (hair)/dishevelled/disheveled/unkempt/
もじら組 [もじらぐみ] /(n) Mozilla community/
もそっと /(adv) a little more/
もそもそ /(vs,adv,adv-to) (on-mim) creeping about/stirring restlessly/squirming/
もぞもぞ /(vs,adv,adv-to) (on-mim) creeping about/stirring restlessly/squirming/
もたつく /(v5k,vi) to be slow/to not make progress/to be inefficient/
もたもた /(adv,n,vs) (on-mim) inefficient/slow/
もたれ掛る [もたれかかる] /(v5r,vi) (1) to lean on/to recline on/(2) to rely on/to depend on/
もち /(adv) (abbr) (col) of course/for sure/definitely/
もちのろん /(adv) (sl) of course/certainly/naturally/
もちの木 [もちのき] /(n) (uk) Nepal holly (Ilex integra)/
もちはもち屋 [もちはもちや] /(exp) (id) every man knows his own business best/one should go to specialists for the best results/
もちもち /(adj-no,vs) springy (texture)/
もち肌 [もちはだ] /(n) soft skin/smooth skin/
もち米 [もちごめ] /(n) glutinous rice/
もっかい /(n) (col) once more/once again/
もっけの幸い [もっけのさいわい] /(exp) windfall/piece of good luck/
もっこり /(vs,adv-to,adv) (1) (on-mim) bulge in a pocket or clothing/(2) "tent" an erection makes against pants or bedsheets/
もっさい /(adj-i) (sl) unfashionable/
もっさり /(adv,vs) (1) unfashionable/lacking style/(2) dim-witted/slow/
もっそり /(adv-to,adv,vs) (1) slowly/(2) unrefined/
もっての外 [もってのほか] /(adj-na,n) absurd/unreasonable/
もって瞑すべし [もってめいすべし] /(exp) one can now rest in peace/one ought to be contented with what has been accomplished/
もっと /(adv) (on-mim) (some) more/even more/longer/further/(P)/
もっともらしい顔 [もっともらしいかお] /(exp) dignified expression/solemn expression/serious expression/
もっぺん /(exp) (col) (abbr) once more/again (abbr. of mou ippen)/
もつ /(n) (food) (abbr) entrails/giblets/guts/internal organs (as food)/
もつれ合う [もつれあう] /(v5u) to entangle themselves together (e.g. of butterflies)/to be intertwined/
もつ焼 [もつやき] /(n) roast giblets/
もつ焼き [もつやき] /(n) roast giblets/
もつ鍋 [もつなべ] /(n) miso nabe made with offal and vegetables/(P)/
もて /(pref) emphatic prefix/
もてあそび物 [もてあそびもの] /(n) plaything/toy/
もて扱う [もてあつかう] /(v5u,vt) (1) (arch) to take care of/(2) (arch) to be too much for one/to find unmanageable/to be beyond one's control/to not know what to do with/
もて映やす [もてはやす] /(v5s,vt) (uk) to praise extravagantly/to lionize/to lionise/to make much of/
もて栄やす [もてはやす] /(v5s,vt) (uk) to praise extravagantly/to lionize/to lionise/to make much of/
もて遊ぶ [もてあそぶ] /(v5b,vt) (1) (uk) to play with (a toy, one's hair, etc.)/to fiddle with/(2) to toy with (one's emotions, etc.)/to trifle with/(3) to do with something as one pleases/(4) to appreciate/
もて囃す [もてはやす] /(v5s,vt) (uk) to praise extravagantly/to lionize/to lionise/to make much of/
もと /(n) yeast mash/
もどかしい /(adj-i) irritating/not quick enough/tantalizing/tantalising/feel impatient/tardy/
もどかしげに /(adv) fretfully/impatiently/
もにゃもにゃ /(adv) mumbling/incomprehensible muttering/talking with food in one's mouth/talking in sleep/
もぬけの殻 [もぬけのから] /(exp) (uk) completely empty/
ものか /(prt) (male) used to create a form of question indicating that the speaker actually believes the opposite is true/emphasizes a determination not to do something, e.g. "Like hell I will!"/
ものが言えない [ものがいえない] /(exp) speechless (with amazement)/struck dumb/
ものだから /(conj) the reason for something/
もので /(prt,conj) conjunctive particle indicating a cause or reason/
ものである /(exp) is something that/is that which/
ものですか /(exp) (fem) used to create a rhetorical question indicating that the speaker actually believes the opposite is true/emphasizes a determination not to do something by means of a rhetorical question/
ものですから /(exp) reason or excuse (nuance of seeking understanding)/
ものの /(prt) but/although/(P)/
ものの数ではない [もののかずではない] /(exp) nothing special/nothing significant/
ものの道理 [もののどうり] /(n) the principle of the thing/
ものも言いよう [ものもいいよう] /(exp) (id) To make or mar depends on the telling/
ものを /(conj,prt) although (with nuance of strong discontent)/but/even though/I wish ..../
ものを言う [ものをいう] /(exp,v5u) (1) to speak (of something)/(2) to be effective/to be powerful/to mean everything/
もの言う [ものいう] /(v5u,vt) to talk/to carry meaning/
もの寂しい [ものさびしい] /(adj-i) lonely/
もの臭い [ものぐさい] /(adj-i) troublesome/bothersome/burdensome/
もの柔らか [ものやわらか] /(adj-na,n) mild/mild-mannered/gentle/
もの静か [ものしずか] /(adj-na,n) quiet/still/calm/
もの悲しい [ものがなしい] /(adj-i) sad/melancholy/
もの憂い [ものうい] /(adj-i) languid/weary/listless/melancholy/
もの淋しい [ものさびしい] /(adj-i) lonely/
もみじ袋 [もみじぶくろ] /(n) rice-bran bag (used for scrubbing the skin when bathing)/
もみの木 [もみのき] /(n) fir tree/
もみもみ /(n,vs) massage/
もみ殻 [もみがら] /(n) rice husks/
もみ合い [もみあい] /(n) jostle/struggle/scuffle/
もみ合う [もみあう] /(v5u,vt) to jostle/to shove and push/to struggle with one another/
もみ手 [もみで] /(n,vs) rubbing one's hands together/
もみ手で頼む [もみででたのむ] /(exp,v5m) to supplicate/to implore humbly/
もみ消す [もみけす] /(v5s,vt) to crush/to hush up/to blanket/
もみ療治 [もみりょうじ] /(n,vs) (therapeutic) massage/
もめ事 [もめごと] /(n) quarrel/trouble/dispute/friction (between people)/
ももんが /(n) (uk) small Eurasian flying squirrel (Pteromys momonga)/
ももんがあ /(n) (uk) small Eurasian flying squirrel (Pteromys momonga)/
ももんじい屋 [ももんじいや] /(n) (arch) meat vendor/butcher/
ももんじ屋 [ももんじや] /(n) (arch) meat vendor/butcher/
もも引き [ももひき] /(n) close fitting trousers/working trousers/long johns/long underpants/
もも上げ [ももあげ] /(n) high knee (exercise drill where one brings one's knees up high while walking or running)/
もも肉 [ももにく] /(n) leg (meat)/round/ham/
もやい結び [もやいむすび] /(n) bowline (knot)/
もやしっ子 [もやしっこ] /(n) weak, frail or gangly child/
もやもや /(adv,n,vs) (on-mim) hazy/misty/feeling sad/feeling fuzzy/feeling depressed/gloomy/
もやもや病 [もやもやびょう] /(n) moyamoya disease (rare, progressive cerebrovascular disorder caused by blocked arteries in the basal ganglia)/
もようびゆ /(n) (uk) calico plant (Alternanthera ficoidea)/
もらい受ける [もらいうける] /(v1,vt) to get/to be given/
もりもり /(adv,n) (on-mim) swelling/someone full of zest/gusto/
もろ刃 [もろは] /(adj-no) (1) double-edged/
もろ肌 [もろはだ] /(n) both bare shoulders/stripped to the waist/
もろ肌を脱ぐ [もろはだをぬぐ] /(exp,v5g) (1) to strip to one's waist/(2) to go at with might and main/
もろ肌脱ぎ [もろはだぬぎ] /(n) stripping to one's waist/being bare from the waist up/
もんか /(prt) (male) used to create a form of question indicating that the speaker actually believes the opposite is true/emphasizes a determination not to do something, e.g. "Like hell I will!"/
もんじゃ焼き [もんじゃやき] /(n) savoury pancake with various fillings, thinner than okonomiyaki/
もんだから /(conj) the reason for something/
もんで /(prt,conj) conjunctive particle indicating a cause or reason/
もんですか /(exp) (fem) used to create a rhetorical question indicating that the speaker actually believes the opposite is true/emphasizes a determination not to do something by means of a rhetorical question/
もんどり打つ [もんどりうつ] /(v5t) to turn a somersault/
もんぺ /(n) women's work pants/
も一つ [もひとつ] /(exp) furthermore/adding to the above-mentioned/
や /(prt) (1) such things as (non-exhaustive list related to a specific time and place)/and ... and/(2) (after the dictionary form of a verb) the minute (that) .../no sooner than .../(int) (3) punctuational exclamation in haiku, renga, etc./(aux) (4) (ksb:) plain copula/(P)/
やあ /(int) (1) Yo! (greeting)/(2) Wow! (expression of surprise)/
やいやい /(adv,adv-to) (1) pressingly/demandingly/(int) (2) hey! hey!/oi!/
やえやま型掃海艦 [やえやまがたそうかいかん] /(n) Yaeyama class minesweeper/
やおい /(n) manga on the theme of male homosexual love/
やおら /(adv) slowly/leisurely/deliberately/
やか /(suf,adj-na) (after a noun, adjective stem, onomatopoeic-mimetic word, etc.) seeming very .../
やがる /(aux,v5r) verb suffix (te form or masu stem) to indicate hatred and contempt, or disdain for another's action (vulg)/
やきもき /(adv,n,vs) impatient/worry about/
やきもちを焼く [やきもちをやく] /(exp,v5k) to be jealous/
やきもちを妬く [やきもちをやく] /(exp,v5k) to be jealous/
やきもち焼き [やきもちやき] /(n) jealous person/
やくざ /(n) (1) professional gambler or ruffian (esp. a member of the Japanese mafia)/yakuza (member)/(adj-na,n) (2) uselessness/purposelessness/(P)/
やくざ者 [やくざもの] /(n) (1) professional gambler/(2) good-for-nothing/ne'er-do-well/hoodlum/ruffian/
やけっ腹 [やけっぱら] /(n,vs) desperation/despair/
やけに /(adv) (sl) awfully/frightfully/desperately/violently/
やけを起こす [やけをおこす] /(exp,v5s) to become desperate/to give way to despair/
やけ酒 [やけざけ] /(n) drowning one's cares in drink/drinking in desperation/
やけ食い [やけぐい] /(n,vs) binge eating/stress eating/
やご /(n) (uk) dragonfly naiad (nymph)/
やさぐれ /(n) (1) (sl) running away from home/(2) runaway (child)/
やさぐれる /(v1) (sl) to sulk/to be peevish/
やしない /(aux) (col) (usu. used after -masu stem of verb) emphatic negative (verb)/
やせても枯れても [やせてもかれても] /(exp) even though one has fallen on hard times/however down on one's luck one may be/
やせ過ぎ [やせすぎ] /(n) being too thin/being underweight/
やせ我慢 [やせがまん] /(n,vs) (uk) fake stoicism/pretended endurance (for sake of pride)/false courage/
やせ型 [やせがた] /(n) (1) slender build/slender figure/leptosome/leptosomatic habit/(adj-no) (2) waifish/leptosomaic/leptosomatic/ectomorphic/
やせ形 [やせがた] /(n) (1) slender build/slender figure/leptosome/leptosomatic habit/(adj-no) (2) waifish/leptosomaic/leptosomatic/ectomorphic/
やせ細る [やせほそる] /(v5r,vi) to lose weight/to become thin/to wither away/
やっかむ /(v5m,vi) (col) (ktb:) to be jealous/to be envious/
やっさもっさ /(n,vs,adv-to) (on-mim) hurly-burly/helter-skelter/hustle and bustle/turmoil/
やった /(int) hooray (lit: I or we did it)/whee/hot dog!/you beaut/whacko/yowzer!/whoopee!/yes!/(P)/
やったー /(int) hooray (lit: I or we did it)/whee/hot dog!/you beaut/whacko/yowzer!/whoopee!/yes!/
やっちまう /(exp,v5u) to do something one regrets/
やっつけ仕事 [やっつけしごと] /(n) rush job/quick-and-dirty work/
やって見る [やってみる] /(exp,v1) to have a go/to try and do (something)/to take a chance with something/
やって行く [やっていく] /(v5k-s) to live/to make a living/to get on with/
やって来る [やってくる] /(exp,vk) to come along/to come around/to turn up/(P)/
やっと /(adv) (on-mim) at last/at length/(P)/
やっとこ /(adv) barely/
やっとこまかせ /(n) yell made when starting to move something/grunt/
やっとの思いで [やっとのおもいで] /(exp,adv) finally/after great pains/
やっとの事で [やっとのことで] /(exp) just managing/with great difficulty/
やっとまかせ /(n) yell made when starting to move something/grunt/
やっ付ける [やっつける] /(v1,vt) to beat/to attack (an enemy)/to do away with/to finish off/(P)/
やとらに /(adv) indiscriminately/
やなぐい /(n) quiver (worn on the right hip; post-Nara period)/
やねん /(aux) (ksb:) it is assuredly that .../can say with confidence that .../
やばい /(adj-i) (1) (sl) dangerous/risky/(2) (sl) awful/terrible/crap/(3) (sl) terrific/amazing/cool/(P)/
やぶ蛇 [やぶへび] /(n,vs) unnecessary trouble brought upon oneself/stirring up a hornet's nest/
やほー /(int) (col) hi/howdy/
やまびこ /(n) skips-most-stations Touhoku-line Shinkansen/
やまめ /(n) (uk) dragonfly naiad (nymph)/
やみ屋 [やみや] /(n) black marketeer/black market trader/
やむを得ず [やむをえず] /(adv) unavoidably/inevitably/necessarily/reluctantly/against one's will/
やむを得ない [やむをえない] /(exp) cannot be helped/unavoidable/(P)/
やむ終えない [やむおえない] /(exp,adj-i) cannot be helped/unavoidable/
やむ得ず [やむえず] /(adv) (uk) unavoidably/inevitably/necessarily/reluctantly/against one's will/
やめ検 [やめけん] /(n) (abbr) (col) former public prosecutor who now works as a lawyer/retired public prosecutor/
やめ検弁護士 [やめけんべんごし] /(n) (col) former public prosecutor who now works as a lawyer/prosecutor-turned-lawyer/
やもう得ない [やもうえない] /(exp,adj-i) cannot be helped/unavoidable/
やもめ暮らし [やもめぐらし] /(n) widowhood/widowerhood/viduity/
やも知れぬ [やもしれぬ] /(suf) (arch) may/might/perhaps/may be/possibly/
ややあって /(exp) after a little while/presently/
ややこしい /(adj-i) puzzling/tangled/complicated/complex/(P)/
やや小さい [ややちいさい] /(exp,adj-i) smallish/on the small side/
やや大きい [ややおおきい] /(exp,adj-i) biggish/largish/
やら /(prt) (1) indicates a non-exhaustive list of items/(2) denotes uncertainty/
やらざるを得ない [やらざるをえない] /(exp) cannot avoid doing/cannot help but (do)/is compelled to do/(feel) obliged to (do)/has to do/
やらしい /(adj-i) (uk) unpleasant/disgusting/repulsive/detestable/disagreeable/indecent/lewd/dirty/lascivious/
やらせ /(n) (1) faked situation/(2) prearranged performances/
やらはた /(n) (abbr) (col) 20+ years old virgin/
やらやら /(int) expression of strong emotion or surprise/
やりこい /(adj-i) (tsb:) soft/tender/limp/
やりたなご /(n) (uk) Tanakia lanceolata (species of cyprinid)/
やりっぱ /(n) (abbr) (sl) leave unfinished or incomplete/
やりっ放し [やりっぱなし] /(adj-no,adj-na) unfinished/incomplete/
やりとも /(n) someone with whom one is not romantically involved but frequently has sexual relations with anyway/
やりまん /(n) (col) slut/bimbo/
やりよう /(n) way of doing something/
やりコン /(n) blind date party, with the object of sex (slang)/
やり過ぎ [やりすぎ] /(n,adj-no) overkill/(something) overdone/
やり過ぎる [やりすぎる] /(v1) to overdo/to go too far/to go to excess/
やり過ごす [やりすごす] /(v5s,vt) (1) to let something (or somebody) go past/(2) to do too much/(P)/
やり玉 [やりだま] /(n) make an example of/singled out/
やり繰り [やりくり] /(n,vs) (uk) making do/getting by (somehow)/managing/(P)/
やり甲斐 [やりがい] /(n) (uk) being worth doing/(P)/
やり合う [やりあう] /(v5u,vt) to compete with/to argue with/to quarrel/
やり込める [やりこめる] /(v1,vt) to talk down/to corner someone in an argument/
やり残し [やりのこし] /(n) things left undone/
やり残す [やりのこす] /(v5s) to leave undone/
やり取り [やりとり] /(n,vs) giving and taking/exchange (of letters)/arguing back and forth/(conversational) exchange/(P)/
やり手 [やりて] /(n) (1) doer/(2) giver/(3) skilled person/capable person/shrewd person/go-getter/hotshot/(4) brothel madam/
やり場 [やりば] /(n) place of refuge (figurative)/outlet (for an emotion, anger, etc.)/
やり遂げる [やりとげる] /(v1,vt) to accomplish/
やり切る [やりきる] /(v5r) (uk) complete decisively/to do to completion/
やり切れない [やりきれない] /(adj-i) unbearable/intolerable/too much/(P)/
やり損なう [やりそこなう] /(v5u) to fail/
やり直し [やりなおし] /(n,vs) redoing/(P)/
やり直す [やりなおす] /(v5s,vt) to do over again/to redo/to start over/to remake/to resume/to recommence/(P)/
やり通す [やりとおす] /(v5s) to carry through/to achieve/to complete/
やり投げ [やりなげ] /(n) javelin (throw)/
やり逃げ [やりにげ] /(n) (sl) (vulg) having sex with a woman and then breaking off contact with her (esp. after telling her that you love her)/wham-bam-thank-you-ma'am/hit it and quit it/fuck and chuck/
やり抜く [やりぬく] /(v5k,vt) to carry out to completion/to accomplish/
やり返す [やりかえす] /(v5s,vt) to do over/to answer or fire back/to retort/
やり方 [やりかた] /(n) manner of doing/way/method/means/(P)/
やる気 [やるき] /(n) willingness (e.g. to do something)/eagerness/motivation/inspiration/determination/high aspirations/
やる気をそがれる [やるきをそがれる] /(exp,v1) to be discouraged/
やる気を削がれる [やるきをそがれる] /(exp,v1) to be discouraged/
やる気を殺がれる [やるきをそがれる] /(exp,v1) to be discouraged/
やる気充分 [やるきじゅうぶん] /(exp) sufficiently motivated (to do something)/
やる気十分 [やるきじゅうぶん] /(exp) sufficiently motivated (to do something)/
やる気満々 [やるきまんまん] /(adj-no) totally willing/fully motivated/
やる瀬ない [やるせない] /(adj-i) helpless/cheerless/miserable/disconsolate/dreary/downhearted/
やれ /(int) oh!/ah!/oh dear!/dear me!/thank God!/
やれやれ /(int) exclamation of relief or disappointment/(P)/
やろう /(exp) (ksb:) seems/I guess/
やん /(n-suf) suffix for familiar person/
やんか /(exp) (ksb:) questioning (something)/
やんけ /(suf) (ksb:) questioning (something)/
やんす /(aux-v) to be/
やんちゃ /(adj-na,n) naughty/mischievous/
やんでれ /(n,adj-f) (m-sl) person (usu. female) with an unhealthy romantic obsession (has a connotation of mental instability)/
やんま /(n) (1) (uk) darner (any dragonfly of family Aeshnidae)/devil's darning needle/(2) dragonfly (esp. a large one)/
やんややんや /(exp) hear! hear!/hooray/
やんわり /(adv,vs) softly/mildly/gently/
やんわりと /(adv,vs) softly/mildly/gently/
や否や [やいなや] /(exp) (1) the minute (that) .../no sooner than .../(2) whether or not/
ゆうちょ銀行 [ゆうちょぎんこう] /(n) JP Bank (former Postal Savings Bank, created when the Postal Services were privatized)/(P)/
ゆうちょ銀行を除く [ゆうちょぎんこうをのぞく] /(exp,v5k) excluding the Post Office bank/excluding Japan Post Bank/
ゆうばり型護衛艦 [ゆうばりがたごえいかん] /(n) Yubari class destroyer escort/
ゆうパック /(n) You Pack (Japan Post's parcel delivery service)/(P)/
ゆかた地 [ゆかたじ] /(n) yukata cloth material/special light woven material 36-40cm wide for making yukata/
ゆくりなく /(adv) unexpectedly/
ゆさゆさ /(adv,n,vs) (on-mim) large thing swaying/
ゆすり取る [ゆすりとる] /(v5r) to extort/to shake down (for money)/
ゆず胡椒 [ゆずこしょう] /(n) condiment paste made from yuzu zest and chile peppers/
ゆず胡椒 [ゆずごしょう] /(n) condiment paste made from yuzu zest and chile peppers/
ゆっくり /(adv,n,vs,adv-to) (on-mim) slowly/at ease/restful/(P)/
ゆっくり地震 [ゆっくりじしん] /(n) slow earthquake/
ゆったり /(adv,vs,adv-to) (1) (on-mim) comfortable/easy/calm/(2) loose/spacious/
ゆで麺 [ゆでめん] /(n) boiled noodles/
ゆで卵 [ゆでたまご] /(n) boiled egg/
ゆとり /(n,adj-f) elbowroom/leeway/room/reserve/margin/allowance/latitude/time/(P)/
ゆとり教育 [ゆとりきょういく] /(exp) "education with breathing space" system/pressure-free education/
ゆむし /(n) (uk) spoonworm (esp. species Urechis unicinctus)/
ゆらり /(adv,adv-to) (1) swaying (only once, in a large, slow motion)/(2) relaxedly/
ゆらりゆらり /(adv,adv-to) swaying (repeatedly, in a large, slow motion)/
ゆり落とす [ゆりおとす] /(v5s) to shake down (e.g. nuts from a tree)/
ゆるキャラ /(n) (weak) mascot character (e.g. devised for PR purposes by local government, government departments, etc.)/
よ /(prt) (1) (at sentence end) indicates certainty, emphasis, contempt, request, etc./(2) (after a noun) used when calling out to someone/(3) (in mid-sentence) used to catch one's breath or get someone's attention/(int) (4) yo!/(P)/
よーし /(int) alright/all right/right on/looking good/OK/okay/
よいしょ /(int) (1) (expression of) effort or strain/Yo-heave-ho!/(vs) (2) to butter up/to suck up to/
よいっしょ /(int) (1) (expression of) effort or strain/Yo-heave-ho!/(vs) (2) to butter up/to suck up to/
よいやよいや /(exp) hear! hear!/hooray/
よいよい /(n) (col) (sens) locomotor ataxia/difficulty walking or speaking (due to alcoholism, a stroke, etc.)/someone with this problem/
よい天気 [よいてんき] /(n) fine weather/fair weather/
よい旅を [よいたびを] /(exp) bon voyage!/have a nice trip!/
よい旅行を [よいりょこうを] /(exp) "Bon voyage!"/"Have a nice trip!"/
ようが /(exp) (volitional form of verb + ga) regardless of/whether (or not)/
ようこそ /(int) welcome!/nice to see you!/(P)/
ようこそ画面 [ようこそがめん] /(n) (comp) welcome screen/
ようさん /(adv,adj-no) (ksb:) many/a lot/much/
ようし /(int) alright/all right/right on/looking good/OK/okay/
ようつべ /(n) (sl) YouTube (Internet video-sharing web site)/
ような /(adj-pn) like/similar to/
ように /(exp) (1) in order to (e.g. meet goal)/so that/take care (so as)/(2) hoping or wishing for something/(P)/
ようにする /(exp,vs-i) (following a verb) to be sure to/to do (something) so that .../to make sure to/to try to/(P)/
ようになる /(exp) to reach the point that/to come to be that/(P)/
ように言う [ようにいう] /(exp,v5u) to tell (somebody) to (do something)/
よき人 [よきひと] /(n) (arch) person of high rank/
よくあるご質問 [よくあるごしつもん] /(n) frequently asked questions/FAQ/(P)/
よくある御質問 [よくあるごしつもん] /(n) frequently asked questions/FAQ/
よくある事だが [よくあることだが] /(exp) (uk) as often is the case/
よくある質問 [よくあるしつもん] /(n) frequently asked questions/FAQ/
よく学びよく遊べ [よくまなびよくあそべ] /(exp) study hard and play hard/
よく言うよ [よくいうよ] /(exp) Look who's talking./Oh, look who's talking!/Give me a break!/Blow it out/Get out of here!/
よく出来た [よくできた] /(adj-f) well-balanced/considerate/of fine character/
よこ糸 [よこいと] /(n) weft/woof (crosswise threads on a loom)/
よさこい /(n) dance originating in Kochi Prefecture using "naruko"/
よし /(int) alright/all right/right on/looking good/OK/okay/(P)/
よしなに /(adv) at your own discretion/as you see fit/
よしよし /(exp) there, there/
よじ上る [よじのぼる] /(v5r,vi) to climb/to clamber (over, up)/to scramble (up)/to scale/to claw one's way up/
よじ登る [よじのぼる] /(v5r,vi) to climb/to clamber (over, up)/to scramble (up)/to scale/to claw one's way up/
よそ見 [よそみ] /(n,vs) looking away/looking aside/(P)/
よそ行き [よそいき] /(adj-no) (1) going out/(2) one's best (clothes, looks, manners, behaviour, etc.)/(3) formal behaviour (manners, speech, etc.)/
よそ行き [よそゆき] /(adj-no) (1) going out/(2) one's best (clothes, looks, manners, behaviour, etc.)/(3) formal behaviour (manners, speech, etc.)/(P)/
よそ者 [よそもの] /(n) stranger/outsider/
よたよた /(adv,vs) unsteadily/waddling/staggeringly/totteringly/
よだれを垂らす [よだれをたらす] /(exp,v5s) to drool/to dribble/to slobber/
よちよち /(adv,int,n,vs) (on-mim) totteringly/with tottering steps/(P)/
よちよち歩き [よちよちあるき] /(n,adj-no) toddling/taking tottering steps/
よっこいしょ /(int) (expression of) effort or strain/heave-ho/
よって来たる [よってきたる] /(exp,adj-f) (uk) originating/causing/beginning/
よって来る [よってきたる] /(exp,adj-f) (uk) originating/causing/beginning/
よぼよぼ /(adj-na,adv,n,vs) (1) (on-mim) unsteady/tottering/(2) weak from old age/infirm/
よもや /(adv) surely/certainly/
より /(adv,prt) (1) from/out of/since/at/(2) than/(3) other than/except/but/(4) more/(P)/
よりによって今日 [よりによってきょう] /(exp) today of all days/
よりを戻す [よりをもどす] /(exp,v5s) to get back together again/to be reconciled/
より糸 [よりいと] /(n) twisting (thread, etc.)/twisted yarn/twisted thread/twine/
より小さい [よりちいさい] /(n) (1) less than .../(2) smaller .../
より対線 [よりついせん] /(n) (comp) twisted pair cable/
より大きい [よりおおきい] /(adj-i) (1) greater than .../(2) bigger .../
より抜き [よりぬき] /(adj-no,n) the very best/elite/
より分ける [よりわける] /(v1,vt) to classify/to sort out/to sift through/
より良い [よりよい] /(adj-i) superior/better/
よれば /(exp) according to/(P)/
よれよれ /(adj-na,n) worn-out/shabby/seedy/wrinkled-up/
よろしくお願いいたします [よろしくおねがいいたします] /(exp) (hon) please remember me/please help me/please treat me well/
よろしくお願いします [よろしくおねがいします] /(exp) please remember me/please help me/please treat me well/I look forward to working with you/
よろぴく /(adv) (1) well/properly/suitably/(exp) (2) best regards/please remember me/
よろよろ /(adv,n,vs,adv-to,adj-no) (on-mim) unsteady on its feet/tottering/(P)/
よんやよんや /(exp) hear! hear!/hooray/
らい病 [らいびょう] /(n) (sens) Hansen's disease/leprosy/
らか /(suf,adj-na) (after an adjective stem, onomatopoeic-mimetic word, etc.) being .../
らくだ色 [らくだいろ] /(n) (uk) camel color/
らしい /(aux-adj) (1) seeming ... (expresses judgment based on evidence, reason or trustworthy hearsay)/appearing .../(suf,adj-i) (2) (after a noun, adverb or adjective stem) -ish/like a .../typical of .../appropriate for .../becoming of .../worthy of the name .../(P)/
らしくない /(adj-i) unusual/different/
らせん状 [らせんじょう] /(n,adj-no) helical/spiral-shaped/
らっしゃる /(v5aru,vi) (abbr) (hon) to be/to come/to go/
らっぱ飲み [らっぱのみ] /(n,vs) drinking straight from a bottle/
らっぱ吹き [らっぱふき] /(n) (1) bugler/trumpeter/(2) blowing one's own horn/
らりる /(v5r) (sl) to become intoxicated (e.g. with drugs)/
られる /(aux-v,v1) (1) auxiliary verb indicating passive voice (inc. the "suffering passive")/(2) auxiliary verb indicating the potential form/(3) auxiliary verb indicating spontaneous occurrence/(4) (hon) auxiliary verb used as an honorific for others' actions/
ら抜き [らぬき] /(n) (abbr) 'ra'-removed/the practice of skipping the 'ra' from the 'rareru' verb conjugation/
ら抜き言葉 [らぬきことば] /(n) 'ra'-removed word (i.e. lacking the 'ra' in the 'rareru' verb conjunction)/
りどめ /(n) (comp) (sl) readme/
りゅう天に登る [りゅうてんにのぼる] /(exp) rise of the dragon (bringing rain around the time of the spring equinox)/
りんごアメ /(n) candied apple/toffee apple/
りんご飴 [りんごあめ] /(n) candied apple/toffee apple/
りんご園 [りんごえん] /(n) apple orchard/
りんご狩り [りんごがり] /(n) apple picking/
りんご摘み [りんごつみ] /(n) (obsc) picking apples/harvesting apples/
りんりん /(adv) (on-mim) bell ringing (chiming)/
りん気 [りんき] /(n,vs) jealousy/
るっさい /(adj-f) (1) noisy/loud/(2) fussy/(3) annoying/troublesome/tiresome/importunate/(4) bossy/
るんるん気分 [るんるんきぶん] /(n) euphoric mood/exuberant mood/
れどめ /(n) (comp) (sl) readme/
れる /(aux-v,v1) (1) auxiliary verb indicating passive voice (inc. the "suffering passive")/(2) auxiliary verb indicating the potential form/(3) auxiliary verb indicating spontaneous occurrence/(4) (hon) auxiliary verb used as an honorific for others' actions/
れんが塀 [れんがべい] /(n) brick wall/
ろうけつ染め [ろうけつぞめ] /(n) batik (handbag, purse)/
ろう引き [ろうびき] /(n,adj-no) waxing/
ろう者 [ろうしゃ] /(n) deaf person/
ろう付け [ろうづけ] /(n) soldering/brazing/
ろくぶんぎ座 [ろくぶんぎざ] /(n) Sextant (constellation)/
ろくろっ首 [ろくろっくび] /(n) rokurokubi/long-neck woman/monstrous person (often a woman) with a neck that can expand and contract (in Japanese folklore)/
ろくろ首 [ろくろくび] /(n) rokurokubi/long-neck woman/monstrous person (often a woman) with a neck that can expand and contract (in Japanese folklore)/
ろにん /(ik) (n) (1) ronin/wandering samurai without a master to serve/(2) out of work/(3) waiting for another chance to enter a university/
ろは /(n) (col) free/
ろは台 [ロハだい] /(n) (col) free seat (i.e. a park bench)/
ろれつが回らない [ろれつがまわらない] /(exp,adj-i) speaking inarticulately (slurring, lisping, etc.)/
ろ液 [ろえき] /(n) filtrate/
ろ過 [ろか] /(n,vs) filtration/filtering/percolation/
ろ過器 [ろかき] /(n) strainer/colander/filter/
ろ砂 [ろしゃ] /(n) ammonium chloride/
ろ紙 [ろし] /(n) filter paper/
ろ紙クロマトグラフィー [ろしクロマトグラフィー] /(n) paper chromatography/
ろ紙ディスク [ろしディスク] /(n) filter paper disk/
ろ紙電気泳動 [ろしでんきえいどう] /(n) paper electrophoresis/
ろ水 [ろすい] /(n) (1) filtered water/(2) drainage/
ろ水タンク [ろすいタンク] /(n) filter bed/
ろ水器 [ろすいき] /(n) water filter/
ろ波器 [ろぱき] /(n) filter/wave filter/
わ /(prt) (fem) (sentence end) indicates emotion or admiration/(P)/
わあ /(int) (1) wow! (surprise)/(2) yeah!/alright! (joy)/(3) waah! (crying)/
わあわあ /(n) waah waah! (crying)/
わい /(prt) (sentence end, mainly male) indicates emotion/
わいせつ罪 [わいせつざい] /(n) criminal indecency/
わいわい /(adv) (on-mim) noisily/clamorously/many people making a din/(P)/
わい曲 [わいきょく] /(n,vs) distortion/falsification/perversion/
わい小 [わいしょう] /(adj-na,n) diminutive/pygmy/pigmy/stunted/
わい小不規則銀河 [わいしょうふきそくぎんが] /(n) dwarf irregular galaxy/
わい星 [わいせい] /(n) dwarf star/
わい談 [わいだん] /(n,vs) indecent talk/
わえ /(prt) (sentence end, mainly male) indicates emotion/
わかし /(n) (ktb:) young Japanese amberjack/
わかし湯 [わかしゆ] /(n) hot water (esp. cold mineral spring water heated up at the right temperature for bathing)/
わからず屋 [わからずや] /(n) obstinate person/blockhead/
わかれ道 [わかれみち] /(n) branch/forked road/crossroads/branch road/parting of the ways/turning point/
わが意を得たり [わがいをえたり] /(exp) that's just what I thought/that's exactly like I feel/that's exactly what I think, too/
わが校 [わがこう] /(exp,n) our school/my school/
わが国 [わがくに] /(n) our country/our land/one's own country/
わが子 [わがこ] /(n) one's own child/one's own children/
わが社 [わがしゃ] /(n) our company/my company/
わが身 [わがみ] /(n) (1) myself/oneself/(pn) (2) (arch) I/me/(3) (arch) (fam) you (referring to one's inferior)/
わが闘争 [わがとうそう] /(n) Mein Kampf (by Adolf Hitler, 1925-1926)/
わが輩 [わがはい] /(pn,adj-no) (1) (arch) (male) I (nuance of arrogance)/me/myself/(2) we/us/ourselves/
わきが甘い [わきがあまい] /(exp,adj-i) (1) preventing one's opponent from getting an underarm grip (in sumo)/(2) having weak defenses/
わきの下 [わきのした] /(n) armpit/axilla/
わき上がる [わきあがる] /(v5r,vi) (1) to boil up/to come to the boil/to seethe/(2) to arise/to break out/(3) to get excited/to be in uproar/
わき道 [わきみち] /(n,adj-no) side road/byroad/digression/
わき目 [わきめ] /(n) looking aside/(from the) eyes of an onlooker/
わき目も振らずに [わきめもふらずに] /(exp) without looking aside/looking neither right nor left/wholeheartedly/
わくわく /(adv,n,vs) (on-mim) tremble/get nervous/excitedly/thrilled/(P)/
わけが無い [わけがない] /(exp) (uk) there is no way that ... (expresses speaker's belief that something is impossible)/
わけでは無い [わけではない] /(exp) (uk) it does not mean that .../I don't mean that .../
わけには行かない [わけにはいかない] /(exp) (uk) impossible to do (although wants to)/
わけ知り顔 [わけしりがお] /(n) know-it-all airs/I-know-how-it-is look/
わさび醤油 [わさびじょうゆ] /(n) soy sauce flavoured with grated wasabi (used for sashimi, etc.)/
わさび大根 [わさびだいこん] /(n) horseradish/
わたし的 [わたしてき] /(adj-na) personal/my style/my way/
わっと /(adv) (on-mim) suddenly and in a loud voice (e.g. sobbing)/
わなわな /(adv-to,vs) (on-mim) trembling from fear/trembling all over/
わにえそ /(n) (uk) wanieso lizardfish (Saurida wanieso)/
わね /(exp) (fem) expresses depth of feeling or emphasis (sentence end)/
わはは /(int,adv-to) Wa-haha!/vigorous laughter/
わめき声 [わめきごえ] /(n) yell/shout/outcry/
わや /(exp) fiasco/debacle/disaster/train wreck/
わやく /(n) (1) (arch) trickery/(2) fiasco/(3) disobedience/
わらじを脱ぐ [わらじをぬぐ] /(exp,v5g) to complete one's journey/
わらび糊 [わらびのり] /(n) (uk) type of glue produced from bracken starch/
わらび粉 [わらびこ] /(n) bracken starch (starch produced from the rhizomes of bracken)/
わらび餅 [わらびもち] /(n) bracken-starch dumpling (type of dumpling traditionally made using bracken starch)/
わらわら /(adv) (on-mim) bustling/shuffling/squirming/creepy crawly/
わら屋根 [わらやね] /(n) straw-thatched roof/
わら人形 [わらにんぎょう] /(n) straw doll or figure/straw effigy/
わり込む [わりこむ] /(v5m,vt) to cut in/to thrust oneself into/to wedge oneself in/to muscle in on/to interrupt/to disturb/
わり箸 [わりばし] /(n) splittable (wood) chopsticks/
われめちゃん /(n) (X) vulva/slit/cunt/vagina/twat/
われを忘れる [われをわすれる] /(exp,v1) to forget oneself/to lose control of oneself/
われ鐘のような声 [われがねのようなこえ] /(n) resounding voice/thunderous voice/
われ知らず [われしらず] /(adv) involuntarily/instinctively/without realizing/
わん /(n) (1) (on-mim) woof/bark/
わんさ /(adv-to) in swarms/in great crowds/
わんさか /(n,adj-na) a lot/
わんさガール /(n) small-part actress/female extras/
わんぱく盛り [わんぱくざかり] /(n) (at the) peak of mischievousness/little demon (of children)/
わんわん /(adv-to,adv) (1) (on-mim) bow-wow (barking sound)/arf arf/woof/bark/(2) (on-mim) waah-waah (crying sound)/(3) (on-mim) clamouring/clamoring/echoing/(n) (4) (chn) a bow-wow (i.e. a dog)/doggy/
わん曲 [わんきょく] /(n,vs,adj-no) curve/bend/crook/
わん公 [わんこう] /(n) (col) dog/
ゐ /(n) (obs) hiragana for "wi"/
ゑ /(n) (obs) hiragana for "we"/
を /(prt) (1) indicates direct object of action/(2) indicates subject of causative expression/(3) indicates an area traversed/(4) indicates time (period) over which action takes place/(5) indicates point of departure or separation of action/(6) indicates object of desire, like, hate, etc./(P)/
をば /(prt) (arch) marks object of action, etc. (also adds emphasis)/
を以って [をもって] /(adv) (uk) by (means of)/with/
を以て [をもって] /(adv) (uk) by (means of)/with/
を介して [をかいして] /(exp) using as an intermediary/through/
を回って [をめぐって] /(exp) in regard to/concerning (usu. of disputes)/
を廻って [をめぐって] /(exp) in regard to/concerning (usu. of disputes)/
を基として [をもととして] /(exp) based on/built on/made from/
を基にして [をもとにして] /(exp) based on/built on/made from/
を経て [をへて] /(exp) via/passing through/
を元として [をもととして] /(exp) based on/built on/made from/
を元にして [をもとにして] /(exp) based on/built on/made from/
を限りに [をかぎりに] /(exp) as of the end of (today, this month, etc.)/to make (today, etc.) the last (day)/
を巡って [をめぐって] /(exp) in regard to/concerning (usu. of disputes)/
を措いて [をおいて] /(exp) (uk) other than/excluding/without/
を単位として [をたんいとして] /(exp) (comp) in increments of/
を通して [をとおして] /(exp) through/throughout/through (the good offices of)/by way of/
ん /(int) (1) (abbr) used to express approval, especially in slurred or unclear speech (abbr. of interjection "un")/(2) negative verb ending used in informal speech (abbr. of negative verb ending "nu")/(3) abbr. of particle "no"/(4) abbr. of particle "ni" (used especially when it precedes the verb "naru")/
んがため /(exp) in order to/
んず /(aux-v) (1) (arch) will probably be/(2) intending to/will/(3) should/
んだ /(exp) the expectation is that .../the reason is that .../the fact is that .../it is that .../
んで /(prt) that being the case/because of .../the reason is ..../given that.../
んです /(exp) the expectation is that .../the reason is that .../the fact is that .../it is that .../
んとす /(exp,vs-i) (1) (after a -nai stem) to be trying to/(2) to be just about to/
んとする /(exp,vs-i) (1) (after a -nai stem) to be trying to/(2) to be just about to/
んと欲す [んとっほす] /(conj) (arch) to endeavor to (connects to -nai stem)/
んまい /(adj-i) (col) delicious/appetizing/appetising/
アー /(int) (1) (uk) Ah!/Oh!/Alas!/(2) Yes/Indeed/That is correct/(3) Hey!/Yo!/(4) Uh huh/Yeah yeah/Right/Gotcha/
アーアー /(int) uh oh/
アーウィン /(n) (comp) ERwin/
アーカイバ /(n) (comp) archiver/
アーカイバー /(n) (comp) archiver/
アーカイバルファイル /(n) (comp) archival file/
アーカイバルメモリ /(n) (comp) archival memory/
アーカイビング /(n) (comp) archiving/
アーカイブ /(n) archive/
アーカイブサーバ /(n) (comp) archive server/
アーカイブサーバー /(n) (comp) archive server/
アーカイブス /(n) archives/
アーカイブズ /(n) archives/
アーカイブデータセット /(n) (comp) archive data set/
アーカイブビット /(n) (comp) archive bit/
アーカイブファイル /(n) (comp) archive file/
アーカイブライブラリ /(n) (comp) archive library/
アーカイブ先 [アーカイブさき] /(n) (comp) archiving destination/
アーカイブ属性 [アーカイブぞくせい] /(n) (comp) archive attribute/
アーカイブ対象ファイル [アーカイブたいしょうファイル] /(n) (comp) archived file/
アーガイル /(n) argyle/
アーガイルチェック /(n) argyle check/
アーガット /(n) ergot/
アーガルチェック /(n) argyle check/
アーキー /(n) (comp) ARCHIE/
アーキオロジー /(n) archaeology/
アーキタイプ /(n) archetype/
アーキテクチャ /(n) architecture/(P)/
アーキテクチャー /(n) architecture/
アーキテクチャラル /(n) architectural/
アーキテクチュア /(n) architecture/
アーキテクチュラル /(n) architectural/
アーキテクト /(n) architect/
アーキテクトニック /(n) aechitectonic/
アーキトレーブ /(n) architrave/
アーキペラゴ /(n) archipelago/
アーギュー /(n,vs) argue/
アーギュメント /(n) argument/
アーク /(n) (1) arc/(2) arch-/(P)/
アークエネルギー /(n) arc energy/
アークエンジェル /(n) archangels/
アークガイド /(n) arc guide/
アークガウジング /(n) arc gouging/
アークコサイン /(n) arccosine/arc-cosine/
アークコセカント /(n) arccosecant/arc-cosecant/
アークコタンジェント /(n) arccotangent/arc-cotangent/
アークサイン /(n) arcsine/
アークスペクトル /(n) arc spectrum/
アークセカント /(n) arcsecant/
アークタンジェント /(n) arctangent/
アークティック /(n) Arctic/
アークティックグレイリング /(n) Arctic grayling (Thymallus arcticus arcticus)/
アークティックシスコ /(n) Arctic cisco (Coregonus autumnalis)/
アークティックスタッグホーンスカルピン /(n) Arctic staghorn sculpin (Gymnocanthus tricuspis)/
アークティックチャー /(n) Arctic char (Salvelinus alpinus alpinus)/
アークティックフラウンダー /(n) Arctic flounder (Liopsetta glacialis, was Pleuronectes glacialis)/
アークライト /(n) arc light/
アークランプ /(n) arc lamp/arc light/
アーク切断 [アークせつだん] /(n) arc cutting/
アーク灯 [アークとう] /(n) arc light/
アーク燈 [アークとう] /(n) arc light/
アーク放電 [アークほうでん] /(n) arc discharge/
アーク溶接 [アークようせつ] /(n) arc welding/
アーク炉 [アークろ] /(n) arc furnace/
アーケード /(n) arcade/(P)/
アーケードゲーム /(n) (comp) arcade game/
アーケード街 [アーケードがい] /(n) shopping arcade/
アーケイイック /(adj-na,n) archaic/
アーケイイック /(adj-no) archaic/
アーケイック /(adj-na,n) archaic/
アーケイック /(adj-no) archaic/
アーケイックスマイル /(n) archaic smile/
アーケイド /(n) arcade/
アーケオロジー /(n) archaeology/
アーケステティズム /(n) archaesthetism/
アーケゾア /(n) Archezoa/
アーゴノミックス /(n) ergonomics/
アーゴン /(n) argon/
アーサー王物語 [アーサーおうものがたり] /(n) Arthurian romances/
アーサナル /(n) arsenal/
アーシン /(n) arsine/
アージ /(n,vs) urge/
アージェンシー /(n) urgency/
アージェント /(n) urgent/
アージャンシー /(n) urgency/
アージャント /(n) urgent/
アージュアス /(adj-no) arduous/
アース /(n) earth/(electrical) ground/(P)/
アースウオッチ /(n) Earthwatch/
アースカラー /(n) earth color/earth colour/
アースク /(n,vs) ask/
アースクウェイク /(n) earthquake/
アースクェイク /(n) earthquake/
アースクエイク /(n) earthquake/
アースダム /(n) earth dam/
アースデー /(n) Earth Day (April 22nd)/
アースデイ /(n) Earth Day (April 22nd)/
アースナル /(n) arsenal/
アースバンド /(n) (comp) earth band/earth strap/strap snug/
アースマウンド /(n) earth mound/
アースムーバ /(n) earth mover/
アースライン /(n) (comp) ground line/earth line/
アースリ /(adj-no) earthly/
アースワーム /(n) earthworm/
アースン /(adj-no) earthen/
アース線 [アースせん] /(n) ground (earth) wire/earthed line/
アース端子付きのＡＣコンセント [アースたんしづきのエーシーコンセント] /(n) (comp) grounded (or earthed) outlet/
アース端子付きプラグ [アースたんしづきプラグ] /(n) (comp) grounding (or grounded) type plug/
アース用ストラップ [アースようストラップ] /(n) (comp) ground strap/
アーズラナイト /(n) arzrunite/
アーセナル /(n) arsenal/
アーセニック /(n) arsenic/
アーセニッククロライド /(n) arsenic chloride/
アーセン /(n) arsenic/
アーゼノクラサイト /(n) arsenoclasite/arsenoklasite/
アーソノライト /(n) arsenolite/
アーダー /(n) ardor/ardour/
アーダント /(adj-no) ardent/
アーチ /(n) (1) arch/(2) homerun (baseball)/(P)/
アーチー /(n) (comp) ARCHIE/
アーチェリ /(n) archery/
アーチェリー /(n) archery/(P)/
アーチザン /(n) artisan/
アーチステック /(adj-no) artistic/
アーチスト /(n) artist/musician/(P)/
アーチダム /(n) arch dam/
アーチビショップ /(n) archbishop/
アーチファクト /(adj-na) artifact/
アーチャ /(n) archer/
アーチャー /(n) archer/
アーチャン /(n) urchin/
アーチリュート /(n) archlute/
アーチン /(n) urchin/
アーチ橋 [アーチきょう] /(n) arch bridge/
アーチ型 [アーチがた] /(n,adj-no) arch shaped/arched/
アーチ作用 [アーチさよう] /(n,vs) arching/
アーッ /(int) aah/
アーツアンドクラフツ運動 [アーツアンドクラフツうんどう] /(n) Arts and Crafts Movement/
アーティキュレーション /(n) articulation/
アーティキュレーテッドアクスル /(n) articulated axle/
アーティキュレーテッドコンロッド /(n) articulated con-rod/
アーティキュレーテッドシャフト /(n) articulated shaft/
アーティキュレイション /(n) articulation/
アーティキュレット /(adj-no) articulate/
アーティクル /(n) article/
アーティザン /(n) artisan/
アーティスティック /(adj-f) artistic/
アーティスティックインプレッション /(n) artistic impression/
アーティスト /(n) artist/musician/(P)/
アーティチョーク /(n) artichoke/
アーティチョウク /(n) artichoke/
アーティファクト /(adj-na) artifact/
アーティフィシャル /(adj-na) artificial/
アーティフィシャルインテリジェンス /(n) artificial intelligence/
アーティフィス /(n) artifice/
アーティレリ /(n) artillery/
アーテキュレイション /(n) articulation/
アーテキュレイト /(n) articulate/
アーテキュレット /(n) articulate/
アーテクル /(n) article/
アーテフィシャル /(adj-na) artificial/
アーテフィス /(n) artifice/
アーテラリ /(n) artillery/
アーテリ /(n) artery/
アーデント /(n) ardent/
アート /(n) art/(P)/
アートガラス /(n) art glass/
アートギャラリー /(n) art gallery/
アートシアター /(n) art theater/art theatre/
アートスーパバイザ /(n) art supervisor/
アートスタジオ /(n) art studio/
アートタイトル /(n) art title/
アートタイプ /(n) artotype/
アートディレクター /(n) art director/
アートフェア /(n) art fair/
アートフォトグラフィー /(n) art photography/
アートワーク /(n) artwork/
アート紙 [アートし] /(n) coated paper/art paper/
アードバーク /(n) aardvark/
アーニス /(n) arnis (Filipino marshal art)/
アーネット /(n) (comp) AARnet/
アーバニズム /(n) urbanism/
アーバニティ /(n) urbanity/
アーバニティー /(n) urbanity/
アーバン /(n) urban/(P)/
アーバンエクソダス /(n) urban exodus/
アーバンコンプレックス /(n) urban complex/
アーバンスプロール /(n) urban sprawl/
アーバンツイル /(n) urban twill (fabric)/
アーバンデクライン /(n) urban decline/
アーバンデザイナー /(n) urban designer/
アーバンデザイン /(n) urban design/
アーバンビレッジ /(n) urban village/
アーバンファーニチャー /(n) urban furniture/
アーバンファミリー /(n) urban family/
アーバンブルース /(n) urban blues/
アーバンプランナー /(n) urban planner/
アーバンライフ /(n) urban life/
アーバンリゾート /(n) urban resort/
アーバンリニューアル /(n) urban renewal/
アーバンリニュアル /(n) urban renewal/
アーパ /(n) (comp) ARPA/
アーパー /(n) (sl) stupid person/dummy/dolt/
アーパネット /(n) (comp) Advanced Research Projects Agency Network/ARPANET/
アービタ /(n) arbiter/
アービトラージ /(n) arbitrage/
アービトラージ取引 [アービトラージとりひき] /(n) arbitrage/arbitrage position/arbitrage transaction/
アービトラリ /(n) arbitrary/
アービトレーション /(n) arbitration/
アービトレーショングループ /(n) (comp) arbitration group/
アービトレーションレベル /(n) (comp) arbitration level/
アービトレィジャー /(n) arbitrager/arbitrageur/
アービトレリ /(n) arbitrary/
アービュタス /(n) arbutus/
アーフタ /(n) after/
アーフタヌーン /(n) afternoon/
アーフタワーズ /(n) afterwards/
アープ /(n) (comp) ARP/
アーベイン /(adj-no) urbane/
アーベル /(adj-na) (math) Abelian/
アーベント /(n) evening (ger: Abend)/
アーマー /(n) armor/armour/
アーマードプレコ /(n) Pseudorinelepis genibarbis (species of armored catfish from the Amazon River)/
アーマープレート /(n) armor plate/
アーマジロ /(n) armadillo/
アーマチャ /(n) armature/
アーマチャー /(n) armature/
アーマチュア /(n) armature/
アーマチュアコア /(n) armature core/
アーマチュアコイル /(n) armature coil/
アーマチュアシート /(n) armature sheet/
アーマチュアブレーキ /(n) armature brake/
アーマメント /(n) armament/
アーマライト /(n) Armalite/
アーマリー /(n) armory/
アーミー /(n) army/(P)/
アーミーブルー /(n) army blue/
アーミールック /(n) army look/
アーミィ /(n) army/
アーミスティス /(n) armistice/
アーミッシュ /(n) Amish/
アーミン /(n) ermine/
アーミング /(n) arming/
アーム /(n) (1) arm/(2) automated retroactive minimal moderation/ARMM/(P)/
アームウォマー /(n) arm warmer/knitted sleeve, analogous to a leg warmer/
アームカバー /(n) arm cover (e.g. chair)/
アームチェア /(n) armchair/
アームチェアー /(n) armchair/
アームバンド /(n) arm band/
アームホール /(n) armhole/sleeve-hole/
アームライト /(n) adjustable lamp (wasei: arm light)/
アームリフター /(n) armlifter (e.g. on a gramophone turntable)/
アームレスト /(n) armrest/
アームレスリング /(n) (1) arm wrestling/(vs) (2) to arm wrestle/
アームレット /(n) armlet/
アームロック /(n) arm lock/armlock/
アーメン /(n) amen/
アーモンド /(n) almond/(P)/
アーモンドスネークヘッド /(n) Channa lucius (species of snakehead fish)/
アーモンドパウダー /(n) almond powder/
アーモンドミール /(n) almond meal/
アーヤトッラー /(n) Ayatollah/
アーユルヴェーダ /(n) Ayurveda (traditional system of medicine practiced in India)/
アーラン /(n) erlang/
アーリーアメリカン /(n) early American/
アーリーミュージック /(n) early music/
アーリア人 [アーリアじん] /(n) Aryan/
アール /(n) (1) are (fre:)/measure of area (100 sq.m.)/(2) art (fre:)/
アールをとる /(exp,v5r) to take the radius/
アールエイチ /(n) Rh/Rhesus factor/
アールエスニーサンニーシー /(n) (comp) RS-232C/
アールエスニーサンニーディー /(n) (comp) RS-232D/
アールエスヨンニーニ /(n) (comp) RS-422/
アールエフシー /(n) (comp) RFC/
アールエムアイ /(n) (comp) RMI/
アールオーラップ /(n) (comp) ROLAP/
アールグレイ /(n) Earl Grey (tea)/
アールジービー /(n) (comp) RGB/
アールダム /(n) earldom/
アールティーエフ /(n) (comp) RTF/
アールティーエフジェイ /(n) (comp) RTFJ/
アールデービー /(n) (comp) RDB/
アールデービーエムエス /(n) (comp) RDBMS/
アールディーオー /(n) (comp) RDO/
アールデコ /(n) art deco (fre:)/
アールドム /(n) earldom/
アールヌーボー /(n) art nouveau (fre:)/
アールヌーヴォー /(n) art nouveau (fre:)/
アールブイ車 [アールブイしゃ] /(n) sports utility vehicle/SUV/four wheel drive (car or minivan)/lit: recreational vehicle (RV) (usu. not camper or motor home)/
アーレ /(n) measure of area (ger: Ar)/
アーレフ /(n) Aleph (new name of religious group Aum Shinrikyo)/
アーン /(n) (comp) EARN/
アーンして /(exp) open wide/say 'aah'/
アーント /(n) aunt/
アーンドラン /(n) earned run/
アィディア /(n) idea/
アイ /(n) eye/
アイアールキュー /(n) (comp) IRQ/
アイアールシー /(n) (comp) IRC/
アイアールディーエー /(n) (comp) IrDA/
アイアイ /(n) aye-aye (primate, Daubentonia madagascariensis)/
アイアイエス /(n) (comp) IIS/
アイアイオーピー /(n) (comp) IIOP/
アイアイジェイ /(n) (comp) IIJ/
アイアイジェイフォーユー /(n) (comp) IIJ4U/
アイアニング /(n) ironing/
アイアランド /(n) (uk) Ireland/Eire/
アイアロニ /(n) irony (fre: ironie, ger: Ironie)/
アイアン /(n) iron/
アイアンクラブ /(n) iron club/
アイアンストン /(n) ironstone/
アイアンメイデン /(n) iron maiden/
アイイー /(n) (comp) IE/
アイイーティーエフ /(n) (comp) IETF/
アイウェア /(n) eyewear/
アイエーイーエー /(n) International Atomic Energy Agency/IAEA/
アイエーシーエー /(n) International Atomic Energy Agency/IACA/IAEA/
アイエービー /(n) (comp) IAB/
アイエスエーピーアイ /(n) (comp) ISAPI/
アイエスオー /(n) (comp) ISO/
アイエスオーシー /(n) (comp) ISOC/
アイエスオーディーイー /(n) (comp) ISODE/
アイエスディーエヌ /(n) (comp) ISDN/
アイエニウェア /(n) (comp) iAnywhere/
アイエムイー /(n) (comp) IME/
アイエムエフ /(n) International Monetary Fund/IMF/
アイエルオー /(n) International Labour Organization (Labor, Organisation)/ILO/
アイオー /(n) (comp) I-O/
アイオーコントロール /(n) (comp) IO control/input-output control/
アイオーデータ /(n) (comp) I-O DATA/
アイオダイン /(n) iodine/
アイオライト /(n) iolite (blue gemstone)/
アイオリ /(n) aioli (fre:)/
アイオリソース /(n) aioli sauce/
アイカメラ /(n) eye camera/
アイキャッチ /(n) short clip used to begin and end commercial breaks on Japanese TV (wasei: eyecatch)/
アイキャッチャ /(n) eye-catcher/
アイキャッチャー /(n) eye-catcher/
アイキャン /(n) (comp) Internet Corporation for Assigned Names and Numbers/ICANN/
アイキュー /(n) IQ/intelligence quotient/
アイケア /(n) eye care/
アイコ /(n) (abbr) iced coffee/
アイコニックインタフェース /(n) (comp) iconic interface/
アイコニックサイン /(n) iconic signs/
アイコニックメモリ /(n) iconic memory/
アイコニファイ /(n) iconify/
アイコノクラズム /(n) iconoclasm/
アイコノスコープ /(n) iconoscope/
アイコラ /(n) (abbr) altered photograph, usu. with sexual connotations, such as putting someone's face on top of a picture of a nude idol, etc./
アイコン /(n) (comp) icon/(P)/
アイコンエディタ /(n) (comp) icon editor/
アイコンキャラクタ /(n) (comp) icon character/
アイコンタクト /(n) eye contact/
アイコンプ /(n) (comp) iCOMP/
アイコンボタン /(n) (comp) icon button/
アイコン化 [アイコンか] /(n,vs) (comp) iconization/minimization/
アイゴ /(n) (uk) mottled spinefoot (Siganus fuscescens, species of Western Pacific rabbitfish)/dusky rabbitfish/sandy spinefoot/
アイゴー /(int) argh (kor: aigo)/sigh/
アイゴ科 [アイゴか] /(n) Siganidae (family of fishes known as rabbitfishes, spinefoots and foxfaces)/
アイゴ属 [アイゴぞく] /(n) Siganus (genus of perciform fishes in the family Siganidae)/rabbitfish/spinefoot/foxface/
アイサ /(n) (uk) merganser (any duck of genus Mergus)/
アイサイト /(n) eyesight/
アイサピ /(n) (comp) ISAPI/
アイサム /(n) (comp) ISAM/
アイザメ /(n) (uk) any shark of genus Centrophorus (esp. the dwarf gulper shark, Centrophorus atromarginatus)/
アイザメ科 [アイザメか] /(n) Centrophoridae (family of generally deepwater gulper sharks)/
アイシー /(n) (comp) IC/
アイシーエムピー /(n) (comp) ICMP/
アイシーキュー /(n) (comp) ICQ/
アイシェード /(n) eyeshade/
アイシクル /(n) icicle/
アイシャドー /(n) eyeshadow/
アイシャドウ /(n) eyeshadow/(P)/
アイシュ /(n) (comp) ish/
アイシング /(n) icing/
アイシングザパック /(n) icing the puck/
アイシングラス /(n) fish gelatin/isinglass/
アイジングラス /(n) isinglass/
アイス /(n) (1) ice (eng: ice, ger: Eis)/(2) (abbr) ice cream/icecream/(P)/
アイス・ホッケー /(n) ice hockey/
アイスアリーナ /(n) ice arena/
アイスィ /(adj-f) icy/
アイスキャンデー /(n) ice pop (wasei: ice candy)/icy pole/popsicle/
アイスキャンディー /(n) ice pop (wasei: ice candy)/icy pole/popsicle/
アイスキューブ /(n) ice cube/
アイスクライミング /(n) ice climbing/
アイスクリーム /(n) ice cream/icecream/(P)/
アイスクリームコーン /(n) ice cream cone/
アイスクリームサンデー /(n) ice cream sundae/icecream sundae/
アイスクリームソーダ /(n) ice cream soda/icecream soda/
アイスクリン /(n) old fashioned-style ice cream (icecream)/
アイスコーヒー /(n) iced coffee/(P)/
アイスコンデンサ /(n) ice condenser/
アイスショー /(n) ice show/
アイススケート /(n) ice skating/
アイススプリンタ /(n) ice splinters/
アイススマック /(n) ice smack (ice cream, icecream)/
アイスズメダイ /(n) Australian gregory (Stegastes apicalis)/
アイスダイビング /(n) ice diving/
アイスダンス /(n) ice dancing/
アイスティ /(n) iced tea/ice tea/
アイスティー /(n) iced tea/ice tea/
アイステズボド /(n) eisteddfod/
アイストング /(n) ice tongs/
アイスハーケン /(n) ice piton (ger: Eishaken)/ice screw/
アイスバーグ /(n) iceberg/
アイスバーン /(n) ice skating place (ger: Eisbahn)/
アイスバケット /(n) ice bucket/
アイスバックス /(n) icebox/
アイスパック /(n) ice bag/ice pack/pack ice/
アイスピック /(n) ice pick/
アイスフォール /(n) icefall/
アイスブリッジ /(n) ice bridge/
アイスブレイカー /(n) icebreaker/
アイスプディング /(n) ice pudding/
アイスプラント /(n) ice plant (Mesembryanthemum crystallinum)/
アイスペール /(n) ice pail/
アイスホッケー /(n) ice hockey/(P)/
アイスボックス /(n) icebox/
アイスポッテッドパファー /(n) Tetraodon leiurus (species of pufferfish)/
アイスポットクテノポマ /(n) eyespot ctenopoma (species of freshwater fish, Ctenopoma ocellatum)/
アイスポットシクリッド /(n) eye-spot cichlid (Cichla spp.)/peacock bass/
アイスミルク /(n) ice milk/iced milk/
アイスヨット /(n) ice yacht/
アイスランド /(n) (uk) Iceland/
アイスランドキャットシャーク /(n) Iceland catshark (Apristurus laurussonii, an Atlantic species)/
アイスランドポピー /(n) Iceland poppy (Papaver nudicaule)/Icelandic poppy/
アイスランド語 [アイスランドご] /(n) Icelandic (language)/
アイスランド苔 [アイスランドごけ] /(n) (obsc) Iceland moss (Cetraria islandica)/Iceland lichen/
アイスリンク /(n) ice rink/skating rink/
アイズ /(n) eyes/
アイセック /(n) L'Association Internationale des Etudiants en Sciences Economiques et Commercial/AIESEC/
アイゼン /(n) metal pins of climbing shoes (ger: Eisen)/crampons/climbing irons/
アイゼンメンゲル症候群 [アイゼンメンゲルしょうこうぐん] /(n) Eisenmenger syndrome/
アイソキネティックス /(n) isokinetics/
アイソクロナルテスト /(n) isochronal test/
アイソザイム /(n) isozyme/isoenzyme/
アイソスタシー /(n) isostasy/
アイソスピン /(n) isospin/
アイソセンタ /(n) isocentre/
アイソタイプ /(n) isotype/
アイソタクチックポリオレフィン /(n) isotactic polyolefin/
アイソタクチックポリプロピレン /(n) isotactic polypropylene/
アイソトープ /(n) isotope/
アイソトープ検査 [アイソトープけんさ] /(n) isotope examination/
アイソトープ治療 [アイソトープちりょう] /(n) isotope therapy/
アイソトニック /(adj-f) isotonic/
アイソトニックス /(n) isotonics/
アイソトロン /(n) isotron/
アイソバリックスピン /(n) isobaric spin/
アイソパイア /(n) isopyre/
アイソパラメトリック /(adj-f) isoparametric/
アイソパルスシステム /(n) isopulse system/
アイソメトリック /(adj-f) isometric/
アイソメトリックエクササイズ /(n) isometric exercise/
アイソメトリックス /(n) isometrics/
アイソレーション /(n) isolation/
アイソレーションシンドローム /(n) isolation syndrome/
アイソレータ /(n) isolator/
アイソレーター /(n) isolator/
アイソレイト /(n) isolate/
アイタム /(ik) (n) (1) item/(2) something that one "just has to have"/
アイダイアグラム /(n) (comp) eye diagram/
アイティーエフ /(n) (comp) ITF/
アイティーユー /(n) (comp) ITU/
アイティーユーティー /(n) (comp) ITU-T/
アイティーユーティーエス /(n) (comp) ITU-TS/
アイテニアム /(n) (comp) Itanium/
アイテム /(n) (1) item/(2) something that one "just has to have"/(P)/
アイデア /(n) idea/(P)/
アイデアプロセッサ /(n) (comp) idea processor/
アイデアマン /(n) idea man/ideas man/person of ideas/
アイデアライズ /(vs) idealize/
アイデアラッシュ /(n,vs) brainstorming (wasei: idea rush)/
アイデアル /(adj-na) ideal/
アイディーイー /(n) (comp) IDE/
アイディーイーエー /(n) (comp) IDEA/
アイディーエル /(n) (comp) IDL/
アイディーシー /(n) (comp) IDC/
アイディア /(n) idea/(P)/
アイディアマン /(n) idea man/ideas man/person of ideas/
アイディアリスト /(n) idealist/
アイディアリズム /(n) idealism/
アイディアル /(adj-na) ideal/
アイディア商品 [アイディアしょうひん] /(n) novelty (wasei: idea product)/
アイディリスト /(ik) (n) idealist/
アイディル /(n) idyll/
アイデンティカル /(adj-f) identical/
アイデンティティ /(n) identity/(P)/
アイデンティティー /(n) identity/(P)/
アイデンティティーカード /(n) identity card/
アイデンティティークライシス /(n) identity crisis/
アイデンティティクライシス /(n) identity crisis/
アイデンティファイ /(n,vs) identify/
アイデンティフィケーション /(n) identification/
アイデンティフィケーションカード /(n) identification card/
アイデンティフケイション /(n) identification/
アイデンテティ /(n) identity/
アイデンテファイ /(n,vs) identify/
アイデンテフィケイション /(n) identification/
アイトリプルイー /(n) (comp) IEEE/
アイドゥリ /(adv) idly/
アイドゥル /(n) (1) idol/(2) idle/
アイドゥルネス /(n) idleness/
アイドリ /(adv) idly/
アイドリング /(n) idling/
アイドリングストップ /(n) turning off a vehicle engine when stopped (wasei: idling stop)/
アイドル /(n) (1) idol/(2) idle/(P)/
アイドルインタラプト /(n) (comp) idle interrupt/
アイドルキャピタル /(n) idle capital/
アイドルギア /(n) idle gear/intermediate gear/
アイドルギヤ /(n) idle gear/intermediate gear/
アイドルコスト /(n) idle cost/
アイドルコラージュ /(n) altered photograph, usu. with sexual connotations, such as putting someone's face on top of a picture of a nude idol, etc. (wasei: idol collage)/
アイドルシステム /(n) idle system/
アイドルタイム /(n) idle time/
アイドルネス /(n) idleness/
アイドルビット /(n) idle bit/
アイドルフラグ /(n) (comp) idle flag/
アイドルマネー /(n) idle money/
アイドル歌手 [アイドルかしゅ] /(n) pop idol/idol singer/
アイドル時間 [アイドルじかん] /(n) (comp) idle time/
アイドル状態 [アイドルじょうたい] /(n) (comp) idle state/idle conditions/
アイナメ /(n) (uk) fat greenling (Hexagrammos otakii)/
アイナメ科 [アイナメか] /(n) Hexagrammidae (family of marine fishes incorporating the greenlings)/
アイヌ /(n,adj-no) Ainu/(P)/
アイヌ犬 [アイヌけん] /(n) Hokkaido dog/dog breed native to Hokkaido/
アイヌ語 [アイヌご] /(n) Ainu (language)/
アイヌ新法 [アイヌしんぽう] /(n) New Ainu Law (passed in 1997, aiming at promoting and protecting Ainu culture)/
アイヌ族 [アイヌぞく] /(n) the Ainu race/
アイネク /(n) (abbr) Eine Kleine Nachtmusik (work by Mozart)/
アイネット /(n) (comp) INET/
アイバンク /(n) eye bank/
アイパック /(n) (comp) iPaq/
アイパッチドバタフライフィッシュ /(n) Philippine butterflyfish (Chaetodon adiergastos)/panda butterflyfish/
アイビ /(n) (1) ivy/(2) Ivy League (style)/
アイビー /(n) (1) ivy/(2) Ivy League (style)/
アイビーエム /(n) (comp) IBM/
アイビーシャツ /(n) ivy shirt/
アイビースタイル /(n) ivy style/
アイビーム /(n) (comp) i-beam/
アイビームポインタ /(n) (comp) I-beam pointer/
アイビーリーグ /(n) Ivy League/
アイビールック /(n) ivy look/
アイビス /(n) ibis/
アイピーエックスエスピーエックス /(n) (comp) IPX-SPX/
アイピーブイシックス /(n) (comp) IPv6/
アイフ /(n) (comp) AIFF/
アイフック /(n) eye hook/eyehook/
アイブック /(n) (comp) iBook/
アイブラウ /(n) eyebrow/
アイブリ /(n) blackbanded trevally (Seriolina nigrofasciata)/blackbanded amberjack/
アイブリ属 [アイブリぞく] /(n) Seriolina (genus of jacks in the family Carangidae)/
アイブロー /(n) eyebrow/
アイブローシェープ /(n) eyebrow shape/
アイブローペンシル /(n) eyebrow pencil/
アイブロウ /(n) eyebrow/
アイベックス /(n) ibex/
アイボリ /(n) ivory/
アイボリー /(n) ivory/(P)/
アイボリーブラック /(n) ivory black/
アイボリーホワイト /(n) ivory-white/
アイボリー板紙 [アイボリーいたがみ] /(n) ivory paper/
アイボルト /(n) eye bolt/eyebolt/
アイマスク /(n) eye mask/
アイマック /(n) (comp) iMac/
アイマックス /(n) (comp) IMAX/
アイマップ /(n) (comp) IMAP/
アイメート /(n) seeing-eye dog (wasei: eye mate)/guide dog/
アイメイク /(n) eye makeup (wasei: eye make)/
アイメイト /(n) seeing-eye dog (wasei: eye mate)/guide dog/
アイモードサービス /(n) i-mode service/
アイヨンハチロク /(n) (comp) i486/
アイライナー /(n) eye liner/eyeliner/
アイライン /(n) eyeline/
アイラッシュ /(n) eyelash/
アイラッシュカーラー /(n) eyelash curler/
アイラブユー /(exp) (sl) I love you/
アイランド /(n) island/
アイランドキッチン /(n) island kitchen/
アイランドグレゴリー /(n) island gregory (Stegastes insularis)/
アイランドホッグフィッシュ /(n) island hogfish (Bodianus insularis)/
アイリス /(n) iris/(P)/
アイリスアウト /(n) iris-out/
アイリスイン /(n) iris-in/
アイリックス /(n) (comp) IRIX/
アイリッシュ /(n,adj-no) Irish/
アイリッシュウルフハウンド /(n) Irish wolfhound/
アイリッシュコーヒー /(n) Irish coffee/
アイリッシュハープ /(n) Irish harp/
アイリフト /(n) eyelift/
アイリンク /(n) (comp) i.LINK/
アイル /(n) aisle/
アイルランド /(n) (uk) Ireland/Eire/
アイルランド語 [アイルランドご] /(n) Irish (language)/Erse/
アイルランド人 [アイルランドじん] /(n) Irish (person)/
アイレット /(n) eyelet/
アイレットワーク /(n) eyelet work/
アイロニー /(n) irony (fre: ironie, ger: Ironie)/
アイロニカル /(adj-na) ironical/
アイロニック /(adj-na) ironic/
アイロン /(n) (electric) iron/(P)/
アイロンを掛ける [アイロンをかける] /(exp,v1) (uk) to iron/to do the ironing/
アイロン掛け [アイロンかけ] /(n,vs) (doing the) ironing/
アイロン掛け [アイロンがけ] /(n,vs) (doing the) ironing/
アイロン台 [アイロンだい] /(n) ironing board/
アインシュタイン宇宙 [アインシュタインうちゅう] /(n) Einsteinian universe/
アインスタイニウム /(n) einsteinium (Es)/
アウア /(n) hour/
アウアズ /(n) ours/
アウアセルブズ /(n) ourselves/
アウェーゲーム /(n) away game/
アウェーゴール /(n) away goals (rule in soccer)/
アウェア /(n) aware/
アウェイ /(n) away/
アウェイク /(n) awake/
アウェイクン /(vs) awaken/
アウェイト /(n) await/
アウエア /(n) aware/
アウエイ /(n) away/
アウエイク /(n) awake/
アウエイクン /(vs) awaken/
アウエイト /(n) await/
アウォード /(n) award/
アウケニプテルス科 [アウケニプテルスか] /(n) Ageneiosidae (family of driftwood catfishes)/
アウケニプテルス属 [アウケニプテルスぞく] /(n) Auchenipterus (genus of catfishes in the family Auchenipteridae)/
アウケノグラニスオッキデンタリス /(n) bubu (Auchenoglanis occidentalis)/giraffe catfish/
アウスト /(vs) oust/
アウストラロピテクス /(n) Australopithecus (lat:)/
アウストロアジア語族 [アウストロアジアごぞく] /(n) Austro-Asiatic languages/
アウストロネシア語族 [アウストロネシアごぞく] /(n) Austronesian languages/
アウストロレビアスアドルフィー /(n) killifish (Austrolebias adloffi)/
アウタ /(n) outer/
アウター /(n) outer/
アウターウエア /(n) outerwear/
アウタースペース /(n) outer space/
アウタルキー /(n) autarchy (ger: Autarkie)/
アウチ /(n) ouch/
アウティング /(n) outing/
アウテリア /(n) exterior (wasei: outerior)/
アウテング /(n) outing/
アウト /(n) out/(P)/
アウトゥサイド /(n) outside/
アウトゥドア /(n,adj-no) outdoor/al fresco/
アウトゥドアズ /(n) outdoors/
アウトゥブレイク /(n) outbreak (of war or disease)/
アウトゥプット /(n) output/
アウトゥライン /(n) outline/
アウトゥルック /(n) outlook/
アウトゥレット /(n) outlet (store that sells seconds, discontinued lines, etc.)/
アウトゥワァド /(n) outward/
アウトゥワッズ /(n) outwards/
アウトウエア /(n) out wear/
アウトオブオーダー実行 [アウトオブオーダーじっこう] /(n) (comp) out of order execution/
アウトオブデート /(adj-na) out-of-date/
アウトオブバウンズ /(n) out of bounds/
アウトオブファッション /(n) out of fashion/
アウトオブ眼中 [アウトオブがんちゅう] /(n) (col) being out of consideration/effectively not existing as an option/
アウトカウント /(n) out count/
アウトカム /(n) outcome/
アウトコース /(n) (1) outside track (wasei: out course)/(2) outside pitch (baseball)/
アウトコーナー /(n) outside corner (baseball, racetrack, etc.) (wasei: out corner)/
アウトサイダー /(n) outsider/
アウトサイド /(n) outside/
アウトサイドグリップ /(n) outside grip/
アウトスウィング /(n) outswing/
アウトスタンディング /(n) outstanding/
アウトストラーダ /(n) autostrada (ita:)/
アウトソーシング /(n,vs) out-sourcing/outsourcing/
アウトソース /(n,vs) outsourcing/
アウトダイヤル /(n) (comp) outdialing/
アウトテイク /(n) outtake (of a film, television program, etc.)/
アウトドア /(n,adj-no) outdoor/al fresco/
アウトドアゲーム /(n) outdoor game/
アウトドアショップ /(n) outdoor shop/
アウトドアスポーツ /(n) outdoor sports/
アウトドアズ /(n) outdoors/
アウトドアライフ /(n) outdoor life/
アウトドアリビング /(n) out-door living/
アウトドアレジャー /(n) outdoor leisure/
アウトドライブ /(n) outdrive/
アウトバーン /(n) autobahn (only used for German, etc. highways) (ger: Autobahn)/
アウトバウンド /(n) (comp) outbound/
アウトバスト /(n) outburst/
アウトバック /(n) outback/
アウトフィールダー /(n) (obsc) outfielder/
アウトフィールド /(n) outfield/
アウトフィット /(n) outfit/
アウトフォーカス /(n) soft focus (photography, film) (wasei: out focus)/out-of-focus technique/
アウトフロー /(n) outflow/
アウトブリード /(n) outbreed/
アウトブレイク /(n) outbreak (of war or disease)/
アウトプット /(n) output/
アウトプットポート /(n) (comp) output port/
アウトプレースメント /(n) outplacement/
アウトボクシング /(n) out boxing/
アウトボックス /(n) (comp) out-box/
アウトポケット /(n) outpocket/
アウトライト取引 [アウトライトとりひき] /(n) outright transaction/
アウトライン /(n) outline/
アウトラインステッチ /(n) outline stitch/
アウトラインフォント /(n) (comp) outline font/
アウトラインプロセッサ /(n) (comp) outline processor/
アウトラインプロセッサー /(n) outline processor/
アウトラインユーティリティ /(n) (comp) outline utility/
アウトラインレベル /(n) (comp) outline level/
アウトリガ /(n) outrigger/
アウトリガー /(n) outrigger/
アウトルック /(n) outlook/
アウトレイジ /(n) outrage/
アウトレット /(n) outlet (store that sells seconds, discontinued lines, etc.)/(P)/
アウトレットストア /(n) outlet store/
アウトレットボックス /(n) outlet box/
アウトロ /(n) outro/conclusion (music)/
アウトロー /(n) outlaw/
アウトワァド /(n) outward/
アウトワッズ /(n) outwards/
アウフタクト /(n) upbeat (ger: Auftakt)/anacrusis/
アウフヘーベン /(n) lift (ger: aufheben)/pick up/
アウム真理教 [アウムしんりきょう] /(ik) (n) Aum Shinrikyou religious group/
アウラ /(n) aura/
アウル /(n) owl/
アウロノカラエテルヴァイナエ /(n) Chitande aulonocara (species of peacock cichlid, Aulonocara ethelwynnae)/Northern Aulonocara/
アウロノカラスチュアートグランティ /(n) flavescent peacock (species of peacock cichlid, Aulonocara stuartgranti)/
アウロノカラハンスバエンシィ /(n) Aulonocara Fort Maguire (species of peacock cichlid, Aulonocara hansbaenschi)/firebird cichlid/
アウロノカラバエンシ /(n) Nkhomo-benga peacock (species of peacock cichlid, Aulonocara baenschi)/new yellow regal/yellow peacock/
アウロノカラフエセリ /(n) night aulonocara (species of peacock cichlid, Aulonocara hueseri)/Aulonocara white top/
アウロノカラメイランディ /(n) sulfurhead Aulonocara (species of peacock cichlid, Aulonocara maylandi maylandi)/
アウロノカラヤコブフライベルギ /(n) fairy cichlid (species of peacock cichlid, Aulonocara jacobfreibergi)/Malawi butterfly/
アウロノカラロストラートゥム /(n) Aulonocara rostratum (species of peacock cichlid from Lake Malawi)/
アウロノカラ属 [アウロノカラぞく] /(n) Aulonocara (genus of cichlids endemic to Lake Malawi in East Africa in the family Cichlidae)/peacock cichlids/
アウロノクラヌスデウィンドティ /(n) Aulonocranus dewindti (cichlid fish endemic to Lake Tanganyika in E. Africa)/
アウン /(n) (1) (uk) Om (san:)/Aun/syllable representing the primordial trinity of Vishnu, Shiva and Brahma/(2) inspiration and expiration/respiration/alpha and omega/
アウンス /(n) ounce/28.35g/
アエクィデンスサパイェンシス /(n) Sapayo cichlid (Aequidens sapayensis)/
アエクィデンステトラメルス /(n) saddle cichlid (Aequidens tetramerus)/
アエクィデンスディアデマ /(n) Aequidens diadema (species of South American freshwater cichlid)/
アエクィデンスパリドゥス /(n) doublespot acara (species of S. American cichlids, Aequidens pallidus)/
アエクィデンスメタエ /(n) yellow acara (species of cichlid in Colombia, Aequidens metae)/
アエクィデンス属 [アエクィデンスぞく] /(n) Aequidens (genus of fish in the family Cichlidae)/
アオアシシギ /(n) (uk) greenshank (species of sandpiper, Tringa nebularia)/
アオイ /(n) (1) (uk) mallow (any plant of family Malvaceae)/(2) Asarum caulescens (species of wild ginger)/(3) hollyhock/
アオイガイ /(n) (1) (uk) eggcase (shell) of the greater argonaut/(2) (col) greater argonaut (species of paper nautilus, Argonauta argo)/
アオイソハゼ /(n) prasites pygmy goby (Eviota prasites)/hairfin pygmy goby/
アオイ目 [アオイもく] /(n) Malvales (order of plants)/
アオウオ /(n) (uk) black carp (Mylopharyngodon piceus)/
アオウミガメ /(n) (uk) green turtle (Chelonia mydas)/
アオカケス /(n) (uk) blue jay (Cyanocitta cristata)/
アオカワラヒワ /(n) (uk) European greenfinch (Carduelis chloris)/
アオガラ /(n) blue tit (Parus caeruleus)/
アオキ /(n) (1) Japanese laurel/spotted laurel/Aucuba japonica/(2) live tree/
アオギハゼ /(n) blue-striped cave goby (Trimma tevegae, was Trimma caudomaculata)/blue-striped dwarfgoby/cave pygmy-goby/
アオギリ /(n) (uk) Chinese parasol-tree (Firmiana simplex)/Chinese-bottletree/Japanese varnishtree/phoenix-tree/
アオゲラ /(n) (uk) Japanese green woodpecker (Picus awokera)/Japanese woodpecker/wavy-bellied woodpecker/
アオコ毒 [アオコどく] /(n) poisonous algae bloom (often green in color) (colour)/
アオサ /(n) (uk) sea lettuce (Ulva spp.)/
アオザイ /(n) ao dai (traditional Vietnamese dress) (vie:)/
アオザメ /(n) (uk) shortfin mako shark (Isurus oxyrinchus)/
アオザメ属 [アオザメぞく] /(n) Isurus (genus of mackerel sharks in the family Lamnidae commonly known as the mako sharks)/
アオシタトカゲ /(n) bluetongued lizard/sleepy lizard/
アオジ /(n) (uk) black-faced bunting (Emberiza spodocephala)/
アオジタトカゲ /(n) bluetongued lizard/sleepy lizard/
アオタ /(n) blue shark (Prionace glauca, species of circumglobal requiem shark)/
アオタテジマチョウチョウウオ /(n) bluestriped butterflyfish (Chaetodon frembii)/
アオダイショウ /(n) (uk) Japanese rat snake (Elaphe climacophora)/
アオダモ /(n) chinese flowering ash/fraxinus lanuginosa form. serrata/
アオチビキ /(n) (uk) blue-gray snapper (Aprion virescens)/green jobfish/
アオナギ /(n) shark (esp. the blue shark, Prionace glauca)/
アオノメハタ /(n) peacock grouper (Cephalopholis argus)/
アオハダ /(n) macropoda holly/variety of holly common in Japan/ilex macropoda/
アオハナホソオオトカゲ /(n) canopy goanna (Varanus keithhornei, species of carnivorous monitor lizard native to Northeast Australia)/blue-nosed goanna/Nesbit River monitor/
アオバスズメダイ /(n) black-axil chromis (Chromis atripectoralis)/blackfin chromis/
アオバズク /(n) (uk) brown hawk owl (Ninox scutulata)/
アオバセセリ /(n) (uk) blue-winged skipper butterfly/
アオバト /(n) (uk) white-bellied green pigeon (Treron sieboldii)/
アオブダイ /(n) (uk) Scarus ovifrons (species of parrotfish)/
アオブダイ属 [アオブダイぞく] /(n) Scarus (genus of parrotfish in the family Scaridae)/
アオホソオオトカゲ /(n) blue-spotted tree monitor (Varanus macraei, species of carnivorous monitor lizard from the island of Batanta, Indonesia)/
アオミドロ /(n) spirogyra/algae forming pond scum/
アオメエソ /(n) (uk) Chlorophthalmus albatrossis (species of greeneye)/
アオモリトドマツ /(n) (uk) Maries' fir (Abies mariesii)/
アオヤガラ /(n) (uk) bluespotted cornetfish (Fistularia commersonii)/
アオヤサイ /(n) green crop/green vegetable/
アオリイカ /(n) bigfin reef squid/oval squid (Sepioteuthis lessoniana)/
アオリスト /(n) aorist/
アカアシイワシャコ /(n) (uk) red-legged partridge (Alectoris rufa)/
アカアシシギ /(n) (uk) common redshank (Tringa totanus)/
アカイエカ /(n) common house mosquito (Culex pipiens pallens)/
アカイソハゼ /(n) Eviota masudai (species of pygmy goby found in Japanese waters)/
アカウオ /(n) (1) Matsubara's red rockfish (Sebastes matsubarae)/(2) Pacific ocean perch (Sebastes alutus)/(3) comb goby (Ctenotrypauchen microcephalus)/(4) Japanese dace (Tribolodon hakonensis)/(5) any edible red saltwater fish/
アカウシアブ /(n) (uk) Tabanus chrysurus (species of horsefly)/
アカウソ /(n) (uk) bullfinch (Pyrrhula pyrrhula rosacea)/
アカウミガメ /(n) (uk) loggerhead turtle (Caretta caretta)/
アカウンタビリティ /(n) accountability/
アカウンタビリティー /(n) accountability/
アカウンティング /(n) accounting/
アカウンティングファイル /(n) (comp) accounting file/
アカウンティングマシン /(n) accounting machine/
アカウント /(n) account/
アカウントエイリアス /(n) (comp) account alias/
アカウントエグゼクティブ /(n) account executive/
アカウントドメイン /(n) (comp) account domain/
アカウントプランナー /(n) account planner/
アカウントポリシー /(n) (comp) account policy/
アカウントマネージャ /(n) account manager/
アカウントロックアウト /(n) (comp) account lockout/
アカウント管理 [アカウントかんり] /(n) account management/
アカエリヒレアシシギ /(n) (uk) red-necked phalarope (Phalaropus lobatus)/
アカオノスリ /(n) (uk) red-tailed hawk (Buteo jamaicensis)/
アカカマス /(n) red barracuda (Sphyraena pinguis)/
アカガイ /(n) (uk) blood clam (Scapharca broughtonii)/
アカガエル /(n) (1) (uk) any brown or reddish-brown frog (esp. of family Ranidae)/(2) Japanese brown frog (Rana japonica)/brown frog/
アカガレイ /(n) (uk) flathead flounder (Hippoglossoides dubius)/
アカギツネ /(n) (uk) (obsc) red fox (Vulpes vulpes)/
アカギンザメ /(n) spookfish (Hydrolagus mitsukurii, species of cartilaginous fish from the Northwest Pacific)/
アカギンザメ属 [アカギンザメぞく] /(n) Hydrolagus (genus of cartilaginous fish in the family Chimaeridae)/
アカククリ /(n) dusky batfish (Platax pinnatus, species of Western Pacific spadefish found from the Ryukyu Islands to Australia)/
アカグツ /(n) (uk) starry handfish (Halieutaea stellata)/
アカグマ /(n) (uk) brown bear (esp. the Ussuri brown bear, Ursus arctos lasiotus)/
アカコッコ /(n) Izu thrush (Turdus celaenops)/
アカサンゴ /(n) (uk) red coral (Corallium japonicum)/
アカザ /(n) (uk) white gooseweed (Chenopodium album)/fat hen/lamb's-quarters/pigweed/
アカザエビ /(n) (uk) Japanese lobster (Metanephrops japonicus)/
アカザ科 [アカザか] /(n) Chenopodiaceae (plant family)/
アカシア /(n) acacia/
アカシカ /(n) (uk) red deer (Cervus elaphus)/
アカシガタ /(n) (uk) Camellia sasanqua 'Akasigata' (cultivar of Christmas camellia)/
アカシタビラメ /(n) (uk) Cynoglossus joyneri (species of cyprinid)/
アカシデ /(n) (uk) loose-flowered hornbeam (Carpinus laxiflora)/akashide/
アカシュモクザメ /(n) (uk) scalloped hammerhead (Sphyrna lewini)/bronze hammerhead shark/
アカショウビン /(n) (uk) ruddy kingfisher (Halcyon coromanda)/
アカスグリ /(n) red-currant (Ribes rubrum)/
アカダニ /(n) (col) spider mite (any mite of family Tetranychidae)/
アカツキハギ /(n) Achilles tang (Acanthurus achilles, species of surgeonfish found from the Western Pacific to the East Central Pacific)/
アカテガニ /(n) (uk) red-clawed crab (Chiromantes haematocheir)/
アカデミー /(n) academia (fre: academie)/academy/(P)/
アカデミー賞 [アカデミーしょう] /(n) Academy Award/(P)/
アカデミシズム /(n) academicism/
アカデミシャン /(n) academician/
アカデミズム /(n) academism/
アカデミック /(adj-na,n) academic/(P)/
アカデミックガウン /(n) academic gown/
アカデミックディスカウント /(n) academic discount/
アカデミックパッケージ /(n) (comp) academic package/
アカナマダ /(n) (uk) crestfish (Lophotus capellei)/unicornfish/
アカニシ /(n) (uk) veined rapa whelk (Rapana venosa)/
アカネ /(n) (1) (uk) madder (esp. Japanese madder, Rubia argyi)/(2) madder (red color)/
アカネキンチャクダイ /(n) orangeface angelfish (Chaetodontoplus chrysocephalus)/
アカネズミ /(n) (uk) large Japanese field mouse (Apodemus speciosus)/
アカハタ /(n) (uk) blacktip grouper (species of fish, Epinephelus fasciatus)/
アカバナ /(n) (uk) willowherb (Epilobium pyrricholophum)/
アカヒメジ /(n) yellowfin goatfish (Mulloidichthys vanciolensis)/
アカヒレ /(n) (uk) white cloud mountain minnow (Tanichthys albonubes)/Canton danio/
アカプリッチオ /(n) a capriccio (ita:)/
アカプルコグレゴリー /(n) Acapulco major (Stegastes acapulcoensis)/Acapulco gregory/Acapulco damselfish/
アカペラ /(n) a capella (unaccompanied choir or choral work) (ita: a cappella)/
アカホシイソハゼ /(n) melasma pygmy goby (Eviota melasma)/black-spotted pygmy-goby/
アカホシキツネベラ /(n) lined hogfish (Bodianus leucosticticus)/Bodianus rubrisos (declared separate species from B. leucosticticus in 2006)/
アカボウ /(n) Bodianus cylindriatus (species of hogfish)/
アカボウクジラ /(n) (1) (uk) beaked whale/(2) Cuvier's beaked whale (Ziphius cavirostris)/
アカボウフラ /(n) (uk) (obsc) bloodworm (nonbiting midge larva)/
アカマタ /(n) Ryukyu odd-tooth snake (Dinodon semicarinatum)/
アカマタクロマタ /(n) (uk) red-masked and black-masked gods (folk belief of the Yaeyama Islands)/harvest festival celebrating these gods (held in the 6th lunar month)/
アカマツカサ /(n) bigscale soldierfish (Myripristis berndti)/
アカマンボウ /(n) (uk) opah (Lampris guttatus)/moonfish/
アカミミダレミツスイ /(n) (uk) red wattlebird (Anthochaera carunculata)/
アカムツ /(n) (1) Doederleinia berycoides (species of temperate ocean bass)/(2) male dark chub (Zacco temmincki) in mating season/
アカムパニ /(vs) accompany/
アカムパニメント /(n) accompaniment/
アカムプリッシュ /(vs) accomplish/
アカメイモ /(n) (uk) type of taro originally from Sulawesi, has large tubers with red eyes/
アカメガシワ /(n) (1) Mallotus japonicus/(2) mallotus bark (herbal medicine)/
アカメフグ /(n) red-eyed puffer (Takifugu chrysops)/
アカモミタケ /(n) Lactarius laeticolorus (edible species of lactarius mushroom)/
アカヤガラ /(n) (uk) red cornetfish (Fistularia petimba)/
アカヤマアリ /(n) (uk) Formica sanguinea (species of red wood ant)/
アカラシア /(n) achalasia/
アカル・テケ /(n) Akhal-Teke, a breed of horses originating in Turkmenistan/
アカルテケ /(n) Akhal-Teke, a breed of horses originating in Turkmenistan/
アカントアメーバ /(n) Acanthamoeba/
アカンパニ /(vs) accompany/
アカンパニメント /(n) accompaniment/
アカンプリッシュ /(vs) accomplish/
アカンベー /(int,n) facial gesture of pulling one's eyelid down and sticking out one's tongue/
アガナイズ /(vs) agonize/
アガパンサス /(n) agapanthus (esp. the African lily, Agapanthus africanus) (lat:)/lily-of-the-nile/
アガペー /(n) (1) agape (Christian love)/(2) agape (love feast)/
アガリクス /(n) Agaricus subrufescens (species of mushroom with purported medicinal properties)/
アガロース /(n) agarose/
アキー /(n) akee (Blighia sapida)/ackee/
アキアカネ /(n) (uk) var. of red dragonfly (Sympetrum frequens)/
アキカラマツ /(n) (uk) Thalictrum minus var. hypoleucum (variety of lesser meadow rue)/
アキシアルジェット /(n) axial jet/
アキシアルピストンポンプ /(n) axial piston pump/
アキシャルオフセット /(n) axial offset/
アキダクト /(n) aqueduct/
アキテクチャ /(n) architecture/
アキニレ /(n) (uk) Chinese elm (Ulmus parvifolia)/
アキバ系 [アキバけい] /(n,adj-no) (sl) Akihabara style/nerdy/
アキヘラザメ /(n) deep-water catshark (Apristurus profundorum, species found in the Atlantic)/
アキメネス /(n) achimenes (lat:)/
アキャデミィ /(n) academia (fre: academie)/academy/
アキュームレータ /(n) (comp) accumulator/
アキュセイション /(n) accusation/
アキュゼイション /(n) accusation/
アキュテイン /(n) Accutane/
アキュパイ /(vs) occupy/
アキュペイション /(n) occupation/
アキュミュレイト /(n,vs) accumulate/
アキュムレータ /(n) (comp) accumulator/
アキュムレーター /(n) (comp) accumulator/
アキュムレイト /(n,vs) accumulate/
アキュラシ /(n) accuracy/
アキュラスィ /(n) accuracy/
アキュレイト /(n) accurate/
アキュレット /(n) accurate/
アキレア /(n) achillea (lat:)/
アキレス /(n,adj-no) Achilles/
アキレスの論証 [アキレスのろんしょう] /(n) Achilles argument (i.e. Achilles and the tortoise; one of Zeno's paradoxes)/
アキレスタン /(n) Achilles tang (Acanthurus achilles, species of surgeonfish found from the Western Pacific to the East Central Pacific)/
アキレス腱 [アキレスけん] /(n) (1) Achilles tendon/calcaneal tendon/(2) Achilles' heel/vulnerable point/
アキレス腱炎 [アキレスけんえん] /(n) achilles tendonitis/achilles tendinitis/
アキレス腱滑液嚢炎 [アキレスけんかつえきのうえん] /(n) achillobursitis/
アキレス腱反射 [アキレスけんはんしゃ] /(n) Achilles tendon reflex/
アギ /(n) (uk) asafetida (Ferula assafoetida)/
アクースティック /(n,adj-na) acoustic/
アクア /(n) aqua/
アクアチント /(n) aquatint/
アクアティック /(adj-na) aquatic/
アクアティント /(n) aquatint/
アクアテック /(adj-na) aquatic/
アクアトロン /(n) aquatron/
アクアノート /(n) aquanaut/
アクアビット /(n) aquavit/akvavit/
アクアプレーン /(n) aquaplane/
アクアポリス /(n) aqua polis/city on water/
アクアポリン /(n) aquaporin/
アクアマリーン /(n) aquamarine/
アクアマリン /(n) aquamarine/
アクアミネラル /(n) mineral water (wasei: aqua mineral)/
アクアラング /(n) aqualung/Self-Contained Underwater Breathing Apparatus/SCUBA/
アクアリウム /(n) aquarium/
アクアロビクス /(n) aquarobics/
アクイエス /(n) acquiesce/
アクイジション /(n) acquisition/
アクイット /(n) acquit/
アクイロニウム /(n) Aulonocara aquilonium (species of peacock cichlid from Lake Malawi)/
アクウィエス /(n) acquiesce/
アクウィジション /(n) acquisition/
アクウィダクト /(n) aqueduct/
アクウィット /(n) acquit/
アクウェアリアム /(n) aquarium/
アクウェインタンス /(n) acquaintance/
アクウェイント /(n) acquaint/
アクウェリアム /(n) aquarium/
アクウダクト /(n) aqueduct/
アクエインタンス /(n) acquaintance/
アクエイント /(n) acquaint/
アクサン /(n) accent (usu. French accents such as acute and grave) (fre:)/
アクサングラーブ /(n) "grave" accent (fre: accent grave)/
アクサンシルコンフレックス /(n) circumflex accent (fre: accent circonflexe)/
アクサンスィルコンフレックス /(n) circumflex accent (fre: accent circonflexe)/
アクサンツルコンフレックス /(ik) (n) circumflex accent (fre: accent circonflexe)/
アクサンテギュ /(n) "acute" accent (fre: aigu)/
アクシオン /(n) axion/
アクシス /(n) axis/
アクシデンタル /(n) accidental/
アクシデント /(n) accident/(P)/
アクション /(n) action/(P)/
アクションアイテム /(n) action item/
アクションクエリ /(n) (comp) action query/
アクションゲーム /(n) (comp) action game/
アクションスター /(n) action star/
アクションタイプ /(n) (comp) action type/
アクションドラマ /(n) action drama/
アクションバー /(n) action bar/
アクションプラン /(n) action plan/
アクションプログラム /(n) action program/action programme/
アクションペインティング /(n) action painting/
アクションリサーチ /(n) action research/
アクション映画 [アクションえいが] /(n) action movie/
アクスィジェン /(n) oxygen/
アクスィデン /(n) accident/
アクスィデンタル /(n) accidental/
アクスル /(n) axle/
アクスルスタンド /(n) axle stand/
アクスルハウジング /(n) axle housing/
アクセ /(n) (abbr) accessory/
アクセサ /(n) (comp) accessor/
アクセサリ /(n) accessory/
アクセサリー /(n) accessory/(P)/
アクセシビリティ /(n) accessibility/a11y (in IT)/
アクセシビリティー /(n) accessibility/
アクセシブル /(adj-na) accessible/
アクセス /(n,vs) access/(P)/
アクセスを許可する [アクセスをきょかする] /(exp,vs-i) (comp) to permit access/
アクセスアーム /(n) (comp) access arm/
アクセスカウンタ /(n) (comp) access counter/Web counter/
アクセスカウンター /(n) (comp) access counter/Web counter/
アクセスキー /(n) (comp) access key/
アクセスコード /(n) access code/
アクセスコンテキスト /(n) (comp) access context/
アクセスコントロール /(n) (comp) access control/
アクセスコントロールリスト /(n) (comp) access control list/ACL/
アクセススイッチ /(n) (comp) access switch/
アクセススピード /(n) (comp) access speed/
アクセスタイム /(n) (comp) access time/
アクセスチャージ /(n) access charge/
アクセスパネル /(n) access panel/
アクセスブロック /(n) (comp) access block/
アクセスプロバイダ /(n) (comp) access provider/
アクセスポイント /(n) access point/
アクセスマスク /(n) (comp) access mask/
アクセスモード /(n) (comp) access mode/
アクセスレベル /(n) (comp) access level/
アクセスログ /(n) (comp) access log/
アクセス可能 [アクセスかのう] /(adj-na) (comp) accessible/
アクセス回線 [アクセスかいせん] /(n) (comp) access line/
アクセス管理 [アクセスかんり] /(n) (comp) access management/
アクセス機構 [アクセスきこう] /(n) (comp) access mechanism/actuator/
アクセス許可 [アクセスきょか] /(n) (comp) access permission/
アクセス禁止 [アクセスきんし] /(exp) (comp) banned from access (e.g. from a web forum, etc.)/
アクセス系 [アクセスけい] /(n) (comp) access system/
アクセス権 [アクセスけん] /(n) right of access/access permission/access right/
アクセス権限 [アクセスけんげん] /(n) (comp) access authorizations/
アクセス時間 [アクセスじかん] /(n) (comp) access time/
アクセス失敗率 [アクセスしっぱいりつ] /(n) (comp) failure rate/
アクセス情報 [アクセスじょうほう] /(n) (comp) access information/
アクセス制御 [アクセスせいぎょ] /(n) (comp) access control/
アクセス制御フィールド [アクセスせいぎょフィールド] /(n) (comp) access control field/
アクセス制御一覧 [アクセスせいぎょいちらん] /(n) (comp) access control list/
アクセス制御語 [アクセスせいぎょご] /(n) (comp) access control word/
アクセス単位 [アクセスたんい] /(n) (comp) Access Unit/AU/
アクセス点 [アクセスてん] /(n) (comp) access point/
アクセス番号 [アクセスばんごう] /(n) (comp) access number/
アクセス番組 [アクセスばんぐみ] /(n) access program/access programme/
アクセス頻度が低いファイル [アクセスひんどがひくいファイル] /(n) (comp) inactive file/
アクセス頻度の低いファイル [アクセスひんどのひくいファイル] /(n) (comp) infrequently accessed files/
アクセス不能 [アクセスふのう] /(n) (comp) unaccessible/
アクセス保護手続き [アクセスほごてつづき] /(n) (comp) access security procedure/
アクセス方式 [アクセスほうしき] /(n) (comp) access method/
アクセス方式実行プログラム [アクセスほうしきじっこうプログラム] /(n) (comp) access method executor/
アクセス法 [アクセスほう] /(n) (comp) access method/
アクセス網 [アクセスもう] /(n) (comp) access network/
アクセス要求信号 [アクセスようきゅうしんごう] /(n) (comp) access request signal/
アクセス料金 [アクセスりょうきん] /(n) (comp) access charge/access fee/
アクセス例外 [アクセスれいがい] /(n) (comp) access exception/
アクセソワリスト /(n) accessoiriste (fre:)/
アクセッシング /(n) accessing/
アクセプター /(n) acceptor/
アクセプタンス /(n) acceptance/
アクセプト /(n) accept/
アクセラレータ /(n) accelerator/
アクセラレーター /(n) accelerator/
アクセラレータカード /(n) (comp) accelerator card/
アクセル /(n) (1) (abbr) accelerator/(2) (abbr) Axel (figure skating jump)/axel/(P)/
アクセル・ジャンプ /(n) Axel jump (figure skating)/
アクセル・パウルゼン・ジャンプ /(n) (obsc) Axel Paulsen jump (figure skating)/
アクセルジャンプ /(n) Axel jump (figure skating)/
アクセルパウルゼンジャンプ /(n) (obsc) Axel Paulsen jump (figure skating)/
アクセルペダル /(n) accelerator pedal/gas pedal/throttle pedal/
アクセルレータ /(n) accelerator/
アクセレレーター /(n) accelerator/
アクセンチュエイション /(n) accentuation/
アクセント /(n) (1) accent (in language)/(2) stress/highlight/accent/(P)/
アクセント記号 [アクセントきごう] /(n) accent mark/
アクセント照明 [アクセントしょうめい] /(n) accent lighting/
アクセント付き文字 [アクセントつきもじ] /(n) (comp) accented character/
アクタ /(n) actor/
アクター /(n) actor/
アクチナイド /(n,adj-f) actinide (family of elements)/actinides/actinoid/
アクチニウム /(n) actinium (Ac)/
アクチニウム系列 [アクチニウムけいれつ] /(n) actinium series/Actinides/
アクチニド /(n,adj-f) actinide (family of elements)/actinides/actinoid/
アクチノイド /(n,adj-f) actinide (family of elements)/actinides/actinoid/
アクチノマイシン /(n) actinomycin/
アクチビティ /(n) activity/
アクチブ /(adj-na) active/
アクチブディフェンス /(n) active defense/active defence/
アクチャリ /(adv) actually/
アクチャル /(adj-na,n) actual/
アクチュアリ /(adv) actually/
アクチュアリー /(n) actuary/
アクチュアリティー /(n) actuality/
アクチュアル /(adj-na,n) actual/
アクチュアルタイム /(n) actual time/
アクチュアルポジション /(n) actual position/
アクチュエータ /(n) (comp) access mechanism (e.g. disk)/actuator/
アクチュエタ /(n) actuator/
アクチン /(n) actin/
アクティビティ /(n) activity/(P)/
アクティビティー /(n) activity/
アクティビティサンプリング /(n) activity sampling/
アクティビティモデルステップ /(n) (comp) activity model step/
アクティビティ間コンテキスト定義集合 [アクティビティかんコンテキストていぎしゅうごう] /(n) (comp) inter-activity defined context set/
アクティビティ属性 [アクティビティぞくせい] /(n) (comp) activity attributes/
アクティブ /(adj-na) active/(P)/
アクティブなバス /(n) (comp) active bus/
アクティブウィンドウ /(n) (comp) active window/
アクティブエックス /(n) (comp) ActiveX/
アクティブエックスドキュメンツ /(n) (comp) ActiveX Documents/
アクティブオブジェクト /(n) (comp) active object/
アクティブキャッシュ /(n) (comp) active cache/
アクティブコンテンツ /(n) (comp) active content/
アクティブサーバーページ /(n) (comp) Active Server Page/ASP/
アクティブサーバーページズ /(n) (comp) ActiveServerPages/
アクティブシステム /(n) active system/
アクティブスクリプティング /(n) (comp) active scripting/
アクティブスクリプト /(n) (comp) active script/
アクティブスポーツウエア /(n) active sportswear/
アクティブセーフティー /(n) active safety/
アクティブセットアップ /(n) (comp) active setup/
アクティブセル /(n) (comp) active cell/
アクティブソーラー /(n) active solar/
アクティブソーラーハウス /(n) active solar house/
アクティブソナー /(n) active sonar/
アクティブターミネータ /(n) (comp) active-terminator/
アクティブタスク /(n) active task/
アクティブチャネル /(n) (comp) active channel/
アクティブディスプレイ /(n) active display/
アクティブディフェンス /(n) active defense/active defence/
アクティブディレクトリ /(n) (comp) Active Directory/
アクティブデスクトップ /(n) (comp) Active Desktop/
アクティブハブ /(n) (comp) active hub/
アクティブパール /(n) (comp) Active Perl/
アクティブファイル /(n) (comp) active file/
アクティブフィルタ /(n) active filter/
アクティブプログラム /(n) (comp) active program/
アクティブホーミング /(n) active homing/
アクティブマトリクスディスプレイ /(n) (comp) active matrix display/
アクティブマトリクス方式 [アクティブマトリクスほうしき] /(n) (comp) active matrix/
アクティブマトリックス /(n) active matrix/
アクティブリスク /(n) active risk/
アクティブロジック機能 [アクティブロジックきのう] /(n) (comp) active logic function/
アクティブ化 [アクティブか] /(n) (comp) activate/
アクティベーション /(n) activation/
アクティベート /(n) (comp) activation (e.g. of network accounts, etc.)/
アクティング /(n) acting/
アクティングアウト /(n) acting out/
アクティヴ /(adj-na) active/
アクテビティ /(n) activity/
アクト /(n) act/
アクトゥレス /(ik) (n) actress/
アクトパス /(n) octopus/
アクトビット /(n) activation bit/
アクトミオシン /(n) actomyosin/
アクトレス /(n) actress/
アクネ /(n) acne/
アクノリッジ /(n) (comp) acknowledge/
アクムレイト /(n,vs) accumulate/
アクメ /(n) orgasm (fre: acme)/
アクリジン /(n) acridine/
アクリッド /(adj-na) acrid/
アクリノール /(n) acrinol/
アクリフラビン /(n) acriflavine/
アクリリックレジンセメント /(n) acrylic resin cement/
アクリル /(n,adj-no) acrylic (esp. acrylic fibre, fiber)/(P)/
アクリルアミド /(n) acrylamide/
アクリルアルデヒド /(n) acrylic aldehyde/
アクリルゴム /(n) acrylic rubber/
アクリルシロップ /(n) acrylic syrup/
アクリルセメント /(n) acrylic cement/
アクリルプラスチック /(n) acrylic plastic/
アクリルペインティング /(n) acrylic painting/
アクリルレンズ /(n) acrylic lens/
アクリル絵の具 [アクリルえのぐ] /(n) acrylic paint/
アクリル絵具 [アクリルえのぐ] /(n) acrylic paint/
アクリル酸 [アクリルさん] /(n) acrylic acid/
アクリル酸塩 [アクリルさんえん] /(n) acrylate/
アクリル樹脂 [アクリルじゅし] /(n) acrylic resin/
アクリル繊維 [アクリルせんい] /(n) acrylic fiber/acrylic fibre/
アクリル板 [アクリルばん] /(n) acrylic plate/
アクリロイド /(n) acryloid/
アクリロイルモルホリン /(n) acryloyl morpholine/
アクリログアナミン /(n) acryloguanamine/
アクリロニトリル /(n) acrylonitrile/
アクリロニトリルゴム /(n) acrylonitrile rubber/
アクリロニトリルブタジエンゴム /(n) acrylonitrile/butadiene rubber/
アクレイム /(n) acclaim/
アクレジット /(vs) accredit/
アクレディット /(vs) accredit/
アクロシン /(n) acrosin/
アクロス /(adv) across/
アクロスティック /(n) acrostic/
アクロスティックパズル /(n) acrostic puzzle/
アクロステックパズル /(n) acrostic puzzle/
アクロニム /(n) acronym/
アクロバチック /(adj-na) acrobatic/
アクロバット /(n) (1) acrobat/(2) acrobatics/(P)/
アクロバットダンサー /(n) acrobatic dancer/contortionist/
アクロバットダンス /(n) acrobatic dance/
アクロバットチーム /(n) aerobatic team/acrobatic team/
アクロバティック /(adj-na) acrobatic/
アクロポリス /(n) acropolis/
アクロマート /(n) achromat/
アクロマチックレンズ /(n) achromatic lens/
アクロメガリー /(n) acromegaly/
アクロレイン /(n) acrolein/
アクワイア /(vs) acquire/
アクワイヤ /(vs) acquire/
アクワティック /(adj-na) aquatic/
アク禁 [アクきん] /(n) (comp) (col) (abbr) banned from access (e.g. from a web forum, etc.)/
アグーチ /(n) Brazilian agouti (Dasyprocta leporina)/
アグニ /(n) Agni (Vedic god of fire) (san:)/
アグヌスデイ /(n) Agnus Dei (lat:)/
アグラデーション /(n) aggradation/
アグラベイト /(vs) aggravate/
アグリ /(n) (1) agree/(2) ugly/
アグリー /(n) (1) agree/(2) ugly/
アグリーメント /(n) agreement/
アグリカルチャ /(n) agriculture/
アグリカルチャー /(n) agriculture/
アグリカルチュラル /(n) agricultural/
アグリケミカル /(n) agrichemicals/
アグリゲイション /(n,vs) aggregation/
アグリゲイト /(vs) aggregate/
アグリネス /(n) ugliness/
アグリビジネス /(n) agribusiness/
アグリビジネスマン /(n) agribusinessman/
アグリベイト /(vs) aggravate/
アグリメント /(n) agreement/
アグレアブル /(n) agreeable/
アグレガシオン /(n) civil service competitive examination for some positions in the public education system in France (fre: agregation)/
アグレゲイション /(n,vs) aggregation/
アグレゲイト /(vs) aggregate/
アグレシブ /(adj-na) aggressive/
アグレション /(n) aggression/
アグレッシブ /(adj-na) aggressive/(P)/
アグレッション /(n) aggression/
アグレッシン /(n) aggression/
アグレマン /(n) agreement (fre:)/
アグロフォレストリー /(n) agroforestry/
アグロメ /(n) (abbr) agglomeration/
アケイシャ /(n) acacia/
アケオメコトヨロ /(exp) (col) (abbr) abbreviation of "akemashite omedetou, kotoshi mo yoroshiku onegaishimasu"/
アケビ科 [アケビか] /(n) Lardizabalaceae (plant family)/(common name) the lardizabala family/
アケボノソウ /(n) (uk) Swertia bimaculata (species of felwort)/
アケボノチョウチョウウオ /(n) (uk) blackback butterflyfish (Chaetodon melannotus, species found in the Indo-Pacific)/
アケボノヒメオオトカゲ /(n) northern ridge-tailed monitor (Varanus primordius, species of carnivorous monitor lizard native to the Northern Territory of Australia)/blunt-spined goanna/
アゲーン /(n) (1) repeat of a deuce (in tennis, etc.) (eng: again)/(adv) (2) again/
アゲィンスト /(adv) against/
アゲイン /(n) (1) repeat of a deuce (in tennis, etc.) (eng: again)/(adv) (2) again/
アゲハ /(n) (uk) (abbr) swallowtail butterfly (esp. the citrus swallowtail butterfly, Papilio xuthus)/
アゲハチョウ /(n) (uk) swallowtail butterfly (esp. the citrus swallowtail butterfly, Papilio xuthus)/
アゲマキガイ /(n) (uk) constricted tagelus (Sinonovacula constricta)/Chinese razor clam/
アゲラタム /(n) ageratum/
アゲン /(n) (1) repeat of a deuce (in tennis, etc.) (eng: again)/(adv) (2) again/
アゲンスト /(adv) against/
アゲンストウインド /(adv) against wind/
アコースティック /(n,adj-na) acoustic/(P)/
アコースティックエミッション /(n) acoustic emission/
アコースティックギター /(n) acoustic guitar/
アコースティックサウンド /(n) acoustic sound/
アコーディアン /(n) accordion/
アコーディオン /(n) accordion/(P)/
アコーディオンドア /(n) accordion door/
アコーディオンプリーツ /(n) accordion pleats/
アコーデオン /(n) accordion/
アコーデオンドア /(n) accordion door/
アコーデオンプリーツ /(n) accordion pleats/
アコード /(n) accord/(P)/
アコウ /(n) (uk) Japanese sea fig (Ficus superba var. japonica)/
アコギ /(n) (abbr) acoustic guitar/
アコナイト /(n) aconite/
アコニチン /(n) aconitine/
アコニットアルカロイド /(n) aconitum alkaloid/
アコモデーション /(n) accommodation/
アコモデーター /(n) accommodator/
アコモデイション /(n) accommodation/
アコモデイト /(vs) accommodate/
アコヤガイ /(n) (uk) Marten's pearl oyster (Pinctada fucata martensii)/Akoya pearl oyster/
アコライト /(n) acolyte/
アコンドライト /(n) achondrite/
アコンパニ /(vs) accompany/
アコンパニメント /(n) accompaniment/
アコンプリス /(n) accomplice/
アコンプリッシ /(vs) accomplish/
アコンプリッシュ /(vs) accomplish/
アゴハゼ /(n) (uk) forktongue goby (Chaenogobius annularis)/chestnut goby/
アゴヒゲアザラシ /(n) (uk) bearded seal (Erignathus barbatus)/
アゴラ /(n) (comp) Agora/
アゴラフォビア /(n) agoraphobia/
アサーション /(n) assertion/
アサーティブネストレーニング /(n) assertiveness training/
アサート /(n,vs) assert/
アサイド /(n) aside/
アサイラム /(n) asylum/
アサイン /(n) assign/
アサインメント /(n) assignment/
アサガオガイ /(n) (uk) common purple snail (Janthina janthina)/common purple sea snail/violet snail/purple bubble raft snail/janthina/
アサクサノリ /(n) (1) (uk) Porphyra tenera (species of edible seaweed)/(2) dried nori/dried laver/
アサシネイション /(n) assassination/
アサシネイト /(vs) assassinate/
アサシン /(n) assassin/
アサターム /(n) (comp) ASATERM/
アサダ /(n) Japanese hop hornbeam/ostrya japonica/
アサヒる /(v5r) (uk) (sl) to fabricate (stories) (based on alleged behaviour of the Asahi newspaper)/to make up/
アサヒコム /(n) (comp) asahi.com/
アサヒビール /(n) (1) Asahi beer/(2) Asahi Breweries, Ltd./
アサマツゲ /(n) (uk) (obsc) Japanese box tree (Buxus microphylla var. japonica)/
アサリ /(n) Manila clam (Ruditapes philippinarum)/
アサリウスバタフライフィッシュ /(n) West Australian butterflyfish (Chaetodon assarius)/Assarius butterflyfish/Western butterflyfish/
アサルト /(n) assault/
アサルトライフル /(n) assault rifle/
アサンプション /(n) assumption/
アザチオプリン /(n) azathioprine/
アザミ /(n) (uk) thistle (Cirsium spp.)/
アザミウマ /(n) (uk) thrips (any insect of order Thysanoptera)/thrip/
アザミゲシ /(n) (uk) Mexican prickly poppy (Argemone mexicana)/
アザラシ /(n) (uk) true seal (animal)/earless seal/
アザラシ科 [アザラシか] /(n) Phocidae (seals)/
アザレア /(n) azalea/
アザワイズ /(adv) otherwise/
アシ /(n,adj-no) (uk) common reed (Phragmites australis)/
アシ /(n,vs) (abbr) assistant/
アシェイムド /(adj-f) ashamed/
アシカ /(n,adj-no) (uk) eared seal (esp. the California sea lion, Zalophus californianus)/sea lion/
アシクロビル /(n) aciclovir/
アシスタンス /(n) assistance/
アシスタント /(n) assistant/(P)/
アシスタントオブジェクト /(n) (comp) assistant object/
アシスタントディレクター /(n) assistant director/
アシスタントパーサー /(n) assistant purser/
アシスト /(n,vs) assist/assistance/(P)/
アシタバ /(n) (uk) Angelica keiskei (species of angelica, a herb of the parsley family)/
アシダカグモ /(n) (uk) huntsman spider (Heteropoda venatoria)/
アシッド /(n) acid/
アシッドジャズ /(n) acid jazz/
アシドーシス /(n) acidosis/
アシナガグモ /(n) (uk) Tetragnatha praedonia (species of long-jawed orb weaver)/
アシナシイモリ /(n) (uk) caecilian (any burrowing legless amphibian of the order Gymnophiona)/
アシナシトカゲ /(n) (uk) legless lizard (esp. Anguidae spp., inc. glass lizards and slow worms)/
アシボソ /(n) (uk) Japanese stilt grass (Microstegium vimineum)/
アシマネ /(n) (abbr) assistant manager/
アシミレイション /(n) assimilation/
アシミレイト /(vs) assimilate/
アシメ /(n,adj-no) (abbr) (sl) assymetry/
アシメトリ /(n) asymmetry/
アシメトリー /(n) asymmetry/
アシメトリックデザイン /(n) asymmetric design/
アシモ /(n) ASIMO (bipedal robot created by Honda)/
アシュア /(vs) assure/
アシュアランス /(n) assurance/
アシュアリッドリ /(adv) assuredly/
アシュケナジム /(n) Ashkenazim (Jews of Central European descent)/
アシル基 [アシルき] /(n) acyl group/
アシロ /(n) (uk) Ophidion asiro (species of cusk eel)/
アシンメトリー /(n) asymmetry/
アシンメトリックデザイン /(n) asymmetric design/
アシ君 [アシくん] /(n) (sl) man who drives a woman around for free/man used by a woman for his car/
アジ /(n) (abbr) agitation/
アジる /(v5r,vt) to stir up/to instigate (somebody to do something)/to agitate/to foment/
アジア /(n) (1) (uk) Asia (esp. "the Far East")/(adj-no) (2) Asian/Asiatic/(P)/
アジア・太平洋戦争 [アジア・たいへいようせんそう] /(n) Asia-Pacific War (starting with the Manchurian Incident in 1931 and ending with the Japanese surrender in 1945)/
アジアーゴ・チーズ /(n) Asiago cheese/
アジアかぜ /(n) Asia influenza/
アジアアフリカ会議 [アジアアフリカかいぎ] /(n) Asian-African Conference (1955)/Afro-Asian Conference/
アジアインフルエンザ /(n) Asian influenza/
アジアカップ /(n) Asian Cup/
アジアダラー /(n) Asia dollar/
アジアヒキガエル /(n) (uk) Asiatic toad (Bufo gargarizans)/
アジアプレス /(n) Asia Press (company)/
アジアン /(adj-f) Asian (esp. SE Asian)/
アジア開発銀行 [アジアかいはつぎんこう] /(n) Asian Development Bank/
アジア競技大会 [アジアきょうぎたいかい] /(n) Asian Games/
アジア系 [アジアけい] /(n) Asian/(person) of Asian descent/
アジア諸国 [アジアしょこく] /(n) Asian countries/Asian nations/
アジア象 [アジアぞう] /(n) (uk) Asian elephant/Indian elephant/
アジア太平洋 [アジアたいへいよう] /(n) Asia-Pacific (region)/
アジア太平洋機械翻訳協会 [アジアたいへいようきかいほんやくきょうかい] /(n) Asia-Pacific Association for Machine Translation/AAMT/
アジア太平洋経済協力会議 [アジアたいへいようけいざいきょうりょくかいぎ] /(n) Asia-Pacific Economic Cooperation/APEC/
アジア太平洋戦争 [アジアたいへいようせんそう] /(n) Asia-Pacific War (starting with the Manchurian Incident in 1931 and ending with the Japanese surrender in 1945)/
アジア太平洋地域 [アジアたいへいようちいき] /(n) Asia-Pacific region/
アジア大会 [アジアたいかい] /(n) Asian Games/
アジア大陸 [アジアたいりく] /(n) Asian Continent/
アジア的生産様式 [アジアてきせいさんようしき] /(n) Asiatic mode of production (Marx)/
アジア蟇 [アジアひきがえる] /(n) (uk) Asiatic toad (Bufo gargarizans)/
アジェイサント /(adj-f) adjacent/
アジェイスント /(adj-f) adjacent/
アジェクティブ /(n) adjective/
アジェクテブ /(n) adjective/
アジェンダ /(n) agenda/
アジェンダセッティング /(n) agenda setting/
アジクト /(n) addict/
アジサイ /(n) (uk) hydrangea (Hydrangea macrophylla)/
アジサイ科 [アジサイか] /(n) Hydrangeaceae (plant family)/hydrangea/
アジサシ /(n) (uk) tern (esp. the common tern, Sterna hirundo)/
アジソン症候群 [アジソンしょうこうぐん] /(n) Addison's syndrome/
アジソン病 [アジソンびょう] /(n) Addison's disease/
アジタート /(n) agitato (ita:)/
アジテーション /(n) agitation/
アジテーター /(n) agitator/
アジテート /(vs) agitate/
アジテイション /(n) agitation/
アジテイト /(vs) agitate/
アジト /(n) hideout (rus: agitpunkt)/secret base of operations/safe house/(P)/
アジドチミジン /(n) azidothymidine/AZT/
アジビラ /(n) (abbr) propaganda handbill (wasei: agitation bill)/
アジピン酸 [アジピンさん] /(n) adipic acid/
アジマス角 [アジマスかく] /(n) (comp) azimuth angle/
アジメドジョウ /(n) (uk) Niwaella delicata (species of loach)/
アジャスター /(n) adjuster/
アジャスタブルレンチ /(n) adjustable wrench/
アジャスト /(n) adjust/
アジャタ /(n) (abbr) sport similar to ball-toss game played in schools (All Japan Tamaire)/
アジュバント /(n) adjuvant/
アジリティ /(n) (comp) agility/
アジ演説 [アジえんぜつ] /(n) propaganda speech/inflammatory speech/
アジ化鉛 [アジかなまり] /(n) lead azide/
アスィスタント /(n) assistant/
アスキー /(n) (comp) American Standard Code for Information Interchange/ASCII/(P)/
アスキーネット /(n) (comp) ASCII Net/
アスキーファイル /(n) (comp) ASCII file/
アスキーモード /(n) (comp) ASCII mode/
アスキファイル /(ik) (n) (comp) ASCII file/
アスクル /(n) (comp) ASKUL/
アスクレピオスの杖 [アスクレピオスのつえ] /(n) rod of Asclepius/
アスコットタイ /(n) Ascot tie/
アスコルビン酸 [アスコルビンさん] /(n) ascorbic acid/
アスコン /(n) (abbr) asphalt concrete/
アスター /(n) (abbr) asterisk/
アスタチン /(n) astatine (At)/
アスタリスク /(n) asterisk/
アスチルベ /(n) astilbe (flowering plant of the saxifrage family)/
アステカ /(n) Aztec/
アステカ族 [アステカぞく] /(n) Aztec/
アステック /(n) Aztec/
アステリ /(n) (abbr) asterisk/
アステリスク /(n) asterisk/
アステリズム /(n) asterism (pattern of stars which do not form a constellation)/
アステロイド /(n) asteroid/
アストゥラノマ /(n) astronomer/
アストゥラノミィ /(n) astronomy/
アストニッシメント /(n) astonishment/
アストニッシュ /(vs) astonish/
アストニッシュメント /(n) astonishment/
アストラカン /(n) astrakhan/
アストラゼネカ /(n) AstraZeneca (212-atenolol)/
アストラル /(adj-f) astral/
アストリンゼン /(n) (1) astringent/(2) astringent lotion/
アストリンゼント /(n) (1) astringent/(2) astringent lotion/
アストロサイト /(n) astrocyte/
アストロドーム /(n) Astrodome/
アストロノータス /(n) marble cichlid (Astronotus ocellatus) (lat: Astronotus)/
アストロノート /(n) astronaut/
アストロノウト /(n) astronaut/
アストロノマー /(n) astronomer/
アストロノミー /(n) astronomy/
アストロラーベ /(n) astrolabe/
アストロラマ /(n) astro-rama/
アストロロジー /(n) astrology/
アスナロ /(n) (uk) hiba false arborvitae (species of cypress, Thujopsis dolabrata)/
アスパック /(n) ASPAC/
アスパラ /(n) (abbr) asparagus/
アスパラガス /(n) asparagus/(P)/
アスパラギン /(n) asparagine/
アスパラギン酸 [アスパラギンさん] /(n) aspartic acid/
アスパルテーム /(n) aspartame/
アスピー /(n) (comp) ASPI/
アスピーテ /(n) Aspite (ger:)/
アスピック /(n) aspic/
アスピリン /(n) aspirin (ger: Aspirin)/
アスピリンスノー /(n) aspirin snow/
アスファルト /(n,adj-no) asphalt/(P)/
アスファルトコンクリート /(n) asphalt concrete/
アスファルトシングル /(n) asphalt shingle/
アスファルトジャングル /(n) asphalt jungle/
アスファルトフェルト /(n) asphalt felt/
アスファルト道路 [アスファルトどうろ] /(n) asphalt road/blacktop/tarmac road/
アスプ /(n) Egyptian cobra/asp (Naja haje)/
アスプ鎖蛇 [アスプくさりへび] /(n) (uk) asp viper (Vipera aspis)/
アスベスト /(n) asbestos (dut: asbest)/(P)/
アスベストセメント /(n) asbestos cement/
アスペクト /(n) aspect/
アスペクトレーショ /(n) (comp) aspect ratio/
アスペクトレシオ /(n) (comp) aspect ratio/
アスペクト指向 [アスペクトしこう] /(n) aspect-oriented design/
アスペクト比 [アスペクトひ] /(n) (comp) aspect ratio/
アスペルガー症候群 [アスペルガーしょうこうぐん] /(n) Asperger's syndrome/
アスペルギルス症 [アスペルギルスしょう] /(n) aspergillosis/
アスペン /(n) aspen/
アスリート /(n) athlete/(P)/
アスリートトラスト /(n) athlete trust/
アスリートファンド /(n) athlete fund/
アスレチック /(n) (1) athletic/(2) leisure facilities/(P)/
アスレチッククラブ /(n) athletic club/fitness club/gym/sports club/
アスレチックス /(n) athletics/
アスレチックフィールド /(n) athletic field/
アスロック /(n) Anti-Submarine ROCket/ASROC/
アスロン /(n) (comp) Athlon/
アズキゾウムシ /(n) (uk) adzuki bean weevil (Callosobruchus chinensis)/
アズサ /(n) (1) (uk) Japanese cherry birch (Betula grossa)/(2) yellow catalpa (Catalpa ovata)/(3) printing block/
アズファーエンジェル /(n) Arabian angelfish (Pomacanthus asfur)/
アズマギンザメ /(n) Pacific longnose chimaera (Harriotta raleighana, species of deep water cartilaginous fish)/narrownose chimaera/
アズマギンザメ属 [アズマギンザメぞく] /(n) Harriotta (genus with two species of long-nosed chimaeras in the family Rhinochimaeridae)/
アズマシャクナゲ /(n) (uk) Azuma rhododendron/Rhododendron metternichii var./
アズマネザサ /(n) (uk) Pleioblastus chino (species of bamboo grass)/
アズマヒガン /(n) (uk) double weeping rosebud cherry (Prunus pendula)/
アズマヤマアザミ /(n) (uk) Azumayama thistle/Cirsiummicrospicatum/
アセス /(n) (abbr) assessment/
アセスメント /(n) assessment/(P)/
アセタール樹脂 [アセタールじゅし] /(n) acetal resin/
アセチリーン /(n) acetylene/
アセチル /(n) acetyl/
アセチルＣｏＡ [アセチルコエー] /(n) acetyl-CoA/acetyl-coenzyme A/
アセチルコリン /(n) acetylcholine/
アセチルコリンエステラーゼ /(n) acetylcholinestrase/
アセチルサリチル酸 [アセチルサリチルさん] /(n) acetylsalicylic acid (i.e. aspirin)/
アセチルセルロース /(n) (obsc) acetylcellulose/
アセチル化 [アセチルか] /(n,vs) acetylation/
アセチル基 [アセチルき] /(n) acetyl group/
アセチレン /(n) acetylene/
アセチレンランプ /(n) acetylene torch/
アセチレン系炭化水素 [アセチレンけいたんかすいそ] /(n) (obsc) alkyne/
アセット /(n) asset/
アセットマネージメント /(n) asset management/
アセテート /(n) acetate/
アセテートレーヨン /(n) acetate rayon/
アセテート繊維 [アセテートせんい] /(n) acetate fiber/acetate fibre/
アセティシズム /(n) asceticism/
アセトアニリド /(n) acetanilide/
アセトアミノフェン /(n) acetaminophen/paracetamol/
アセトアルデヒド /(n) acetaldehyde/
アセトン /(n,adj-no) acetone/
アセトンブタノール発酵 [アセトンブタノールはっこう] /(n) acetone-butanol fermentation/
アセト酢酸 [アセトさくさん] /(n) acetoacetic acid/
アセノスフェア /(n) asthenosphere/
アセフェート /(n) acephate/
アセローラ /(n) acerola (spa:)/
アセロラ /(n) acerola (Malpighia glabra) (spa:)/Barbados cherry/
アセンダ /(n) (comp) ascender/
アセンブラ /(n) (comp) assembler/
アセンブラー /(n) (comp) assembler/
アセンブラマクロ変換支援プログラム [アセンブラマクロへんかんしえんプログラム] /(n) (comp) assembler macro conversion aid/
アセンブラ言語 [アセンブラげんご] /(n) (comp) assembly language/
アセンブラ制御命令 [アセンブラせいぎょめいれい] /(n) (comp) assembler control instruction/
アセンブリ /(n) (comp) assembly/
アセンブリー /(n) (comp) assembly/
アセンブリー言語 [アセンブリーげんご] /(n) assembly language/
アセンブリー言葉 [アセンブリーことば] /(n) assembly language/
アセンブリー工業 [アセンブリーこうぎょう] /(n) assembly industry/
アセンブリキャッシュ /(n) (comp) assembly cache/
アセンブリマニフェスト /(n) (comp) assembly manifest/
アセンブリライン /(n) assembly line/
アセンブリ言語 [アセンブリげんご] /(n) (comp) assembly language/
アセンブル /(n,vs) assemble/
アセンブル時 [アセンブルじ] /(n) (comp) assembly time/
アセンブル時間 [アセンブルじかん] /(n) (comp) assembly time/
アセンブル編集 [アセンブルへんしゅう] /(n) (comp) assemble edit/
アゼトウナ /(n) (uk) Crepidiastrum keiskeanum (species of plant in the daisy family)/
アゼルバイジャン語 [アゼルバイジャンご] /(n) Azerbaijani (language)/
アソーシエイト /(n) associate/
アソートメント /(n) assortment/
アソシエーション /(n) association/
アソシエーションフットボール /(n) association football/soccer/
アソシエーション応答側 [アソシエーションおうとうがわ] /(n) (comp) association-responder/
アソシエーション応答側応用エンティティ [アソシエーションおうとうがわおうようエンティティ] /(n) (comp) association-responding-application-entity/association-responder/
アソシエーション起動側 [アソシエーションきどうがわ] /(n) (comp) association-initiator/
アソシエーション起動側応用エンティティ [アソシエーションきどうがわおうようエンティティ] /(n) (comp) association-initiating-application-entity/association-initiator/
アソシエーション制御サービス要素 [アソシエーションせいぎょサービスようそ] /(n) (comp) association control service element/ACSE/
アソシエーション制御プロトコル機械 [アソシエーションせいぎょプロトコルきかい] /(n) (comp) Association Control Protocol Machine/
アソシエーツ /(n) associates/
アソシエート /(n,adj-f) associate/
アソシエイト /(n,adj-f) associate/
アゾトバクター /(n) azotobacter/
アゾレスクロミス /(n) Azores chromis (Chromis limbata)/
アゾ化合物 [アゾかごうぶつ] /(n) azo compound/
アゾ基 [アゾき] /(n) azo group/
アゾ染料 [アゾせんりょう] /(n) azo dye/
アタシンチ /(n) (abbr) (col) (fem) my family/
アタッカー /(n) attacker/
アタック /(n,vs) attack/(P)/
アタックパターン /(n) (comp) attack pattern/
アタックライン /(n) attack line/
アタッシェ /(n) attache (fre:)/
アタッシェケース /(n) attache case/
アタッシュケース /(n) attache case/
アタッチ /(n) (comp) attach/
アタッチファイル /(n) (comp) attach file/
アタッチメント /(n) attachment/
アタッチメントユニットインタフェース /(n) (comp) attachment unit interface/AUI/
アタピー /(n) (comp) ATAPI/
アタマジラミ /(n) (uk) head louse (Pediculus humanus capitis)/head lice/
アタラクシア /(n) ataraxia (gre:)/
アタリ /(n) collision/overlapping (e.g. of two objects in a video game)/
アタリメ /(n) (uk) dried squid/dried cuttlefish/
アダージェット /(n) adagietto (ita:)/
アダージョ /(n) adagio (ita:)/
アダジオ /(n) adagio (ita:)/
アダプタ /(n) adapter/
アダプター /(n) adapter/(P)/
アダプタカード /(n) (comp) adaptor card/
アダプテーション /(n) adaptation/
アダプテーションレイヤ /(n) (comp) adaptation layer/
アダプテーション機能 [アダプテーションきのう] /(n) (comp) adaptation function/
アダプテーション層 [アダプテーションそう] /(n) (comp) adaptation layer/
アダプティヴ /(n) adaptive/
アダプト /(vs) to adapt/
アダムスストークス症候群 [アダムスストークスしょうこうぐん] /(n) Adams-Stokes syndrome/
アダルト /(n) adult/(P)/
アダルト・グラフィック /(n) glossy sex magazine (wasei: adult graphic)/
アダルトエデュケーション /(n) adult education/
アダルトグッズ /(n) sex toy (wasei: adult goods)/
アダルトグラフィック /(n) glossy sex magazine (wasei: adult graphic)/
アダルトゲーム /(n) adult game/
アダルトコンテンツ /(n) adult content/pink content/
アダルトサイト /(n) sexually explicit WWW sites (from adult site)/
アダルトショップ /(n) sex shop/adult shop/porn shop/
アダルトチルドレン /(n) (1) (col) people psychologically traumatized from being raised in an abusive or dysfunctional family (e.g. by alcoholic parents) (wasei: adult children)/(2) immature adults/childish adults/
アダン /(n) (uk) screw pine (Pandanus odoratissimus, P. tectorius)/pandanus palm/pandanus fruit/
アチーブ /(n) (1) achieve/(2) (abbr) achievement test/
アチーブメントテスト /(n) achievement test/
アチェレランド /(n) accelerando/
アッ /(int) oh/ah/
アッカド語 [アッカドご] /(n) Akkadian (language)/
アック /(n) (comp) ACK/
アックス /(n) axe/
アッサイ /(n) assai (ita:)/
アッシー /(n) (1) (abbr) (automotive) assembly/(2) (sl) man who drives a woman around for free/man used by a woman for his car/
アッシー君 [アッシーくん] /(n) (sl) man who drives a woman around for free/man used by a woman for his car/
アッシュ /(n) ash/
アッシュメドウズキリフィッシュ /(n) Ash Meadows killifish (Empetrichthys merriami)/
アッセンブリー /(n) assembly/
アッセンブリーライン /(n) assembly line/
アッチェレランド /(n) accelerando/
アッテネータ /(n) attenuator/
アッテネーター /(n) attenuator/
アット /(n) at/(P)/
アットニフティ /(n) (comp) at nifty/
アットバット /(exp) at bat/
アットホーム /(adj-na,n) cosy (wasei: at home)/cozy/
アットランダム /(n) at random/
アッハッハ /(int) guffaw/
アッパー /(n) upper/(P)/
アッパーウィンドウディスプレイカラムアセンブリ /(n) (comp) upper window display column assembly/
アッパーカット /(n) uppercut/
アッパーケース /(n) upper case/
アッパーミドル /(n) upper-middle/
アッパッパ /(n) loose-fitting summer dress/
アッピール /(n) (1) appeal/(vs) (2) to attract/to appeal (to)/
アッピア街道 [アッピアかいどう] /(n) Appian Way/
アップ /(n,n-suf,vs) (1) increasing (eng: up)/(n,vs) (2) (abbr) uploading/(n) (3) (abbr) close-up/(n,vs) (4) (abbr) finishing shooting (of a film, etc.)/(n) (5) up (i.e. of a woman's hair)/(6) being up (i.e. leading in sports)/(7) (abbr) warming up/(n-suf) (8) being over/being finished/(P)/
アップグレード /(n) upgrade/
アップグレードの準備 [アップグレードのじゅんび] /(n) (comp) preparing to upgrade/upgrade preparation/
アップグレード手順 [アップグレードてじゅん] /(n) (comp) upgrade procedures/
アップグレード版 [アップグレードはん] /(n) (comp) upgrade version/
アップサイドダウンケーキ /(n) upside-down cake/
アップサンプル /(n) (comp) upsample/
アップスタイル /(n) up style/up sweep/
アップストリーム /(n) (comp) upstream/
アップタイム /(n) (comp) uptime/
アップタウン /(n) uptown/
アップダウン /(n) up down/
アップツーデート /(adj-na,n) up to date/
アップテンポ /(n) uptempo/
アップデート /(n) update/
アップデイト /(n) update/
アップトーク /(n) style of speaking in which the speaker gives the end of each sentence or phrase a higher intonation (wasei: up talk)/
アップビート /(n) upbeat/
アップライト /(n) upright/
アップライトピアノ /(n) upright piano/
アップリケ /(n) applique (fre:)/
アップリンク /(n,vs) (comp) uplink/
アップリンクＩＤ [アップリンクアイディー] /(n) (comp) uplink ID/
アップリンクライセンス /(n) (comp) uplink license/
アップル /(n) (1) apple/(2) (comp) Apple (computer company)/
アップルキー /(n) (comp) Apple key/
アップルソース /(n) apple sauce/apple-sauce/
アップルデスクトップバス /(n) (comp) Apple Desktop Bus/
アップルトーク /(n) (comp) AppleTalk/
アップルパイ /(n) apple pie/
アップルメニュー /(n) (comp) Apple menu/
アップル拡張キーボード [アップルかくちょうキーボード] /(n) (comp) Apple Extended Keyboard/
アップローダ /(n) (comp) uploader/
アップロード /(n,vs) (comp) upload/
アップワードコンパチブル /(n) (comp) upward compatibility/upward compatibile/
アッペ /(n) (abbr) appendicitis/
アッポジャトゥーラ /(n) appoggiatura/
アツモリソウ /(n) (uk) large-flowered cypripedium (species of lady's slipper, Cypripedium macranthos, esp. Cypripedium macranthos var. speciosum)/
アティック /(n) attic/
アテスト /(n) attest/
アテトーシス /(n) athetosis/
アテトージス /(n) athetosis/
アテナ /(n) Athena (Greek goddess)/Athene/
アテネ /(n) Athens (lat: Athenae)/
アテネータ /(n) attenuator/
アテネーター /(n) attenuator/
アテレクトミー /(n) atherectomy/
アテレコ /(n) (abbr) dubbing/voice over/
アテローム /(n) atheroma (ger: atherom)/
アテローム性動脈硬化症 [アテロームせいどうみゃくこうかしょう] /(n) atherosclerosis/
アテンション /(n) attention/
アテンションバリュー /(n) attention value/
アテンダンス /(n) attendance/
アテンダント /(n) attendant/
アテンド /(n,vs) attendance/attending to someone/taking care of someone/
アテンポ /(exp) a tempo (ita:)/
アディオス /(exp) good-bye (spa: adios)/carton/
アディショナル /(adj-f) additional/
アディダス /(n) Adidas (brand name)/
アディポネクチン /(n) adiponectin/
アデニル酸 [アデニルさん] /(n) adenylic acid/
アデニル酸シクラーゼ [アデニルさんシクラーゼ] /(n) adenylate cyclase/adenyl cyclase/
アデニン /(n) adenine/
アデノイド /(n) adenoid/
アデノウイルス /(n) Adenovirus (ger:)/
アデノシン /(n) adenosine/
アデノシンデアミナーゼ /(n) adenosine deaminase/
アデノシン一リン酸 [アデノシンいちリンさん] /(n) adenosine monophosphate (AMP)/
アデノシン一燐酸 [アデノシンいちりんさん] /(n) adenosine monophosphate (AMP)/
アデノシン三リン酸 [アデノシンさんリンさん] /(n) adenosine triphosphate/ATP/
アデノシン三燐酸 [アデノシンさんりんさん] /(n) adenosine triphosphate/ATP/
アデノシン二リン酸 [アデノシンにリンさん] /(n) adenosine diphosphate/ADP/
アデノシン二燐酸 [アデノシンにりんさん] /(n) adenosine diphosphate/ADP/
アデプト /(n) adept/
アデヤッコ /(n) yellowface angelfish (Pomacanthus xanthometopon)/blueface angelfish/
アデュー /(exp) good-bye (fre: adieu)/
アデリーペンギン /(n) Adelie penguin (Pygoscelis adeliae)/
アト /(n,pref) atto-/10^-18/
アトニー /(n) (physiological) atony (ger: Atonie)/
アトピー /(n,adj-no) atopic/predisposition toward allergies/(P)/
アトピー性皮膚炎 [アトピーせいひふえん] /(n) atopic dermatitis/
アトピン /(n) focal point of a lens behind the subject/
アトミズム /(n) atomism/
アトミック /(n) atomic/
アトム /(n) atom/(P)/
アトモキセチン /(n) atomoxetine (Strattera)/
アトモスフィア /(n) atmosphere/
アトモスフェア /(n) atmosphere/
アトモメーター /(n) (obsc) atmometer/
アトラク /(n) (abbr) attraction/
アトラクション /(n) attraction/(P)/
アトラクター /(n) attractor/
アトラクティブ /(adj-na) attractive/
アトラジン /(n) atrazine/
アトラス /(n) (1) Atlas/(2) atlas/(P)/
アトランダム /(adj-na,n) at random/
アトリ /(n) (uk) brambling (bird) (Fringilla montifringilla)/
アトリウム /(n) atrium/
アトリエ /(n) studio (fre: atelier)/(P)/
アトリエ巡り [アトリエめぐり] /(n) art studio visits/
アトリビューション /(n) (comp) attribution/
アトリビュート /(n) attribute/
アトルバスタチン /(n) atrovastatin/
アトロード /(n) autoload/
アトロピン /(n) atropine/
アド /(n) (1) ad/advertisement/(2) (abbr) address/(P)/
アド /(n) (uk) secondary or supporting actor in a noh or kyogen play/
アドービ /(n) adobe/
アドイン /(n) (comp) add-in/
アドインソフト /(n) (comp) add-in software/
アドインソフトウェア /(n) (comp) add-in software/
アドインパクト /(n) ad impact/
アドゥバタイズメント /(n) advertisement/
アドゥベンチャラス /(adj-f) adventurous/
アドゥレッス /(n) (1) address/(2) (comp) email address/
アドウェア /(n) (comp) adware/
アドオン /(n) add-on/
アドオンセクション /(n) (comp) add-on section/
アドオンデバイス /(n) (comp) add-on device/
アドオンボード /(n) (comp) add-on board/
アドオンモジュール /(n) add-on module/
アドオン電話 [アドオンでんわ] /(n) add-on telephone/
アドオン方式 [アドオンほうしき] /(n) add-on/
アドキャンペーン /(n) ad campaign/
アドストリップ /(n) (comp) Add-Strip/
アドバイザー /(n) adviser/advisor/(P)/
アドバイザリ /(n,adj-no) advisory/
アドバイザリー /(n,adj-no) advisory/
アドバイザリスタッフ /(n) (comp) advisory staff/
アドバイス /(n,vs) advice/(P)/
アドバタイジング /(n) advertising/
アドバタイズメント /(n) advertisement/
アドバルーン /(n) advertising balloon/ad-balloon/
アドバンス /(n) advance(d)/
アドバンスト /(adj-f) advanced/
アドバンストプログラム間通信 [アドバンストプログラムかんつうしん] /(n) (comp) Advanced Program-to-Program Communication/APPC/
アドバンスド /(n) advanced/
アドバンスドオープンウオーターダイバー /(n) advanced open water diver/
アドバンテージ /(n) advantage/(P)/
アドバンテージルール /(n) advantage rule/
アドバンテッジ /(n) advantage/
アドビ /(n) (comp) Adobe/
アドプション /(n) adoption/
アドベ /(n) adobe/
アドベンチャー /(n) adventure/(P)/
アドベンチャーゲーム /(n) (comp) adventure game/
アドベンチャースポーツ /(n) adventure sports/
アドベンチャラス /(adj-f) adventurous/
アドホクラシー /(n) ad-hocracy/
アドホック /(n) ad hoc (lat:)/
アドホックモード /(n) (comp) ad hoc mode/
アドボ /(n) Filipino national dish of braised chicken or pork/
アドマン /(n) ad man/
アドミタンス /(n) admittance/
アドミッション /(n) admission/
アドミッションオフィス /(n) admission office/
アドミッションフリー /(n) free admission (wasei: admission free)/
アドミッションポリシー /(n) admission policy/
アドミッタンス /(n) admittance/
アドミニストレーション /(n) (comp) administration/
アドミニストレータ /(n) administrator/
アドミニストレーター /(n) administrator/
アドミラル /(n) admiral/
アドミン /(n) admin/
アドモード /(n) (comp) add mode/
アドリブ /(n,adj-no) ad lib (lat:)/ad-lib/(P)/
アドレシング /(n) (comp) addressing/
アドレシング可能 [アドレシングかのう] /(adj-na) (comp) addressable/
アドレス /(n) (1) address/(2) (comp) email address/(P)/
アドレスカウンタ /(n) (comp) address counter/
アドレスクラス /(n) (comp) address classes/
アドレスジェネレータ /(n) (comp) address generator/
アドレススクリーニング /(n) (comp) address screening/
アドレスデコーダ /(n) (comp) address decoder/
アドレスバス /(n) (comp) address bus/
アドレスマスク /(n) (comp) address mask/
アドレスレジスタ /(n) (comp) address register/
アドレスレンジ /(n) (comp) address range/
アドレス可能カーソル [アドレスかのうカーソル] /(n) (comp) addressable cursor/
アドレス可能点 [アドレスかのうてん] /(n) (comp) addressable point/
アドレス解決 [アドレスかいけつ] /(n) (comp) address resolution/
アドレス解決プロトコル [アドレスかいけつプロトコル] /(n) (comp) address resolution protocol/
アドレス管理 [アドレスかんり] /(n) (comp) address administration/
アドレス空間 [アドレスくうかん] /(n) (comp) address space/
アドレス形式 [アドレスけいしき] /(n) (comp) address format/
アドレス計算 [アドレスけいさん] /(n) (comp) address computation/
アドレス構成要素 [アドレスこうせいようそ] /(n) (comp) address component/
アドレス指定可能な記憶域をもたない計算器 [アドレスしていかのうなきおくいきをもたないけいさんき] /(exp) (comp) calculator without addressable storage/
アドレス指定能力 [アドレスしていのうりょく] /(n) (comp) addressability/
アドレス指定例外 [アドレスしていれいがい] /(n) (comp) addressing exception/
アドレス修飾 [アドレスしゅうしょく] /(n) (comp) address modification/
アドレス情報 [アドレスじょうほう] /(n) (comp) address information/
アドレス生成 [アドレスせいせい] /(n) (comp) address generation/
アドレス帳 [アドレスちょう] /(n) address book/
アドレス定数 [アドレスていすう] /(n) (comp) address constant/
アドレス定数リテラル [アドレスていすうリテラル] /(n) (comp) address constant literal/
アドレス部 [アドレスぶ] /(n) (comp) address field/address part/
アドレス部拡張 [アドレスぶかくちょう] /(n) (comp) address field extension/
アドレス変換 [アドレスへんかん] /(n) (comp) address translation/address mapping/
アドレス変換バッファ [アドレスへんかんバッファ] /(n) (comp) Translation Look-aside Buffer/TLB/
アドレス変換機構 [アドレスへんかんきこう] /(n) (comp) address translator/
アドレス変換例外 [アドレスへんかんれいがい] /(n) (comp) (address) translation exception/
アドレス変更 [アドレスへんこう] /(n) (comp) address modification/
アドレス変更子 [アドレスへんこうし] /(n) (comp) address modifier/
アドレッシング /(n) addressing/
アドレッシングモード /(n) (comp) addressing mode/
アドレナリン /(n) adrenalin/(P)/
アドヴァイザー /(n) adviser/advisor/
アドヴァイス /(n,vs) advice/
アド帳 [アドちょう] /(n) address book (email)/
アナ /(n) (abbr) announcer/(P)/
アナーキー /(n,adj-na) anarchy/
アナーキスト /(n) anarchist/
アナーキズム /(n) anarchism/
アナウサギ /(n) (uk) European rabbit (Oryctolagus cuniculus)/
アナウンサ /(n) announcer/
アナウンサー /(n) announcer/(P)/
アナウンス /(n) (1) (abbr) announcement/(vs) (2) to announce/(P)/
アナウンスメント /(n) announcement/
アナカン /(n) (abbr) unaccompanied baggage/
アナキスト /(n) anarchist/
アナキズム /(n) anarchism/
アナクロ /(n) (abbr) anachronism/
アナクロニズム /(n) anachronism/
アナグマ /(n) (1) (uk) badger/(2) (uk) Eurasian badger (Meles meles)/(3) (abbr) defensive opening for shogi/
アナグラム /(n) anagram/
アナコン /(n) (comp) (abbr) analog computer/
アナコンダ /(n) anaconda (esp. the green anaconda, Eunectes murinus)/
アナザー /(n) another/
アナスチグマート /(n) anastigmat (compound lens corrected for astigmatism) (ger: Anastigmat)/
アナタース /(n) anatase/
アナターゼ /(n) anatase/
アナツバメ /(n) (uk) swiftlet/
アナテマ /(n) anathema/
アナデジ /(n) (abbr) analog digital/
アナトー /(n) annatto/annato/
アナトー色素 [アナトーしきそ] /(n) annatto colouring/annato coloring/
アナトキシン /(n) (obsc) anatoxin/
アナトミー /(n) anatomy/
アナトリア語派 [アナトリアごは] /(n) Anatolian (branch of languages)/
アナバス亜目 [アナバスあもく] /(n) Anabantoidei (suborder of the order Perciformes known as labyrinth fish that are defined by having an accessory breathing organ for respiration in air)/
アナバチ /(n) (uk) digger wasp/
アナバプティスト /(n) anabaptist/
アナバプテスト /(n) anabaptist/
アナフィラキシー /(n) Anaphylaxie (ger:)/
アナプラズマ病 [アナプラズマびょう] /(n) anaplasmosis/
アナホリフクロウ /(n) (uk) burrowing owl (Athene cunicularia)/
アナボリズム /(n) anabolism/
アナボリックステロイド /(n) anabolic steroids/
アナムネーシス /(n) anamnesis (gre:)/
アナライザ /(n) analyzer/
アナライザー /(n) analyzer/
アナライズ /(n) analysis/
アナリシス /(n) analysis/
アナリスト /(n) analyst/(P)/
アナリストミーティング /(n) analyst meeting/
アナル /(adj-f) (1) anal/(vs) (2) to annul/
アナルコ・サンディカリスム /(n) anarcho-syndicalism/
アナルコサンディカリスム /(n) anarcho-syndicalism/
アナルジージク /(n) analgesic/
アナルセックス /(n,vs) anal intercourse/anal sex/
アナル舐め [アナルなめ] /(n) (col) rimming (i.e. analingus)/rimjob/
アナログ /(adj-na,n,adj-no) analog/analogue/(P)/
アナログＲＧＢ [アナログアージービー] /(n) (comp) analog RGB (red green blue)/
アナログコントローラ /(n) analog controller/
アナログコンピュータ /(n) (comp) analog computer/
アナログコンピューター /(n) (comp) analog computer/
アナログシンセサイザー /(n) analog synthesizer/
アナログジョイスティック /(n) (comp) analog joystick/
アナログスイッチ /(n) (comp) analog switch/
アナログスピードメーター /(n) analog speedometer/
アナログデータ /(n) (comp) analog data/
アナログディジタル変換器 [アナログディジタルへんかんき] /(n) (comp) analog-to-digital converter/AD converter/ADC/
アナログディスプレイ /(n) (comp) analog display/
アナログデジタル変換器 [アナログデジタルへんかんき] /(n) (comp) analog-digital converter/AD converter/ADC/
アナログボード /(n) (comp) analog board/
アナログポート /(n) (comp) analog port/
アナログモデム /(n) (comp) analog modem/
アナログ加算器 [アナログかさんき] /(n) (comp) summer/analog adder/
アナログ回線 [アナログかいせん] /(n) (comp) analog line (circuit)/
アナログ回路 [アナログかいろ] /(n) (comp) analog circuitry/
アナログ掛算器 [アナログかけざんき] /(n) (comp) analog multiplier/
アナログ割算器 [アナログわりざんき] /(n) (comp) analog divider/
アナログ計算機 [アナログけいさんき] /(n) (comp) analog computer/
アナログ時計 [アナログとけい] /(n) analogue watch or clock/
アナログ時計 [アナログどけい] /(n) analogue watch or clock/
アナログ出力 [アナログしゅつりょく] /(n) analog output/AO/
アナログ出力チャネル増幅器 [アナログしゅつりょくチャネルぞうふくき] /(n) (comp) analog output channel amplifier/
アナログ除算器 [アナログじょざんき] /(n) (comp) analog divider/
アナログ乗算器 [アナログじょうざんき] /(n) (comp) analog multiplier/
アナログ信号 [アナログしんごう] /(n) (comp) analog signal/
アナログ信号処理 [アナログしんごうしょり] /(n) analog signal processing/
アナログ信号生成器 [アナログしんごうせいせいき] /(n) (comp) analog signal generator/
アナログ装置 [アナログそうち] /(n) (comp) analog device/
アナログ通信路 [アナログつうしんろ] /(n) (comp) analog channel/
アナログ伝送 [アナログでんそう] /(n) (comp) analog transmission/
アナログ入力 [アナログにゅうりょく] /(n) analog input/AI/
アナログ入力チャネル [アナログにゅうりょくチャネル] /(n) (comp) analog input channel (e.g. in process control)/
アナログ入力チャネル増幅器 [アナログにゅうりょくチャネルぞうふくき] /(n) (comp) analog input channel amplifier/
アナログ表現 [アナログひょうげん] /(n) (comp) analog representation/
アナログ表示 [アナログひょうじ] /(n) (comp) analog representation/
アナログ変数 [アナログへんすう] /(n) (comp) analog variable/
アナログ放送 [アナログほうそう] /(n) analog broadcasting/
アナロジー /(n) analogy/
アナン /(n) Annan, Kofi (former UN Secretary-General)/
アニーリング /(n) annealing/
アニール /(n) annealing/
アニオタ /(n) (col) (abbr) anime otaku/
アニオン /(n) anion/
アニカラ /(n) (abbr) anime karaoke/karaoke accompanied by animation/
アニサキス症 [アニサキスしょう] /(n) anisakiasis/
アニス /(n) anise/
アニゼット /(n) anisette (fre:)/
アニソール /(n) (chem) anisole/
アニソン /(n) (abbr) anime song/
アニバーサリー /(n) anniversary/
アニマ /(n) anima (lat:)/
アニマート /(n) animato (ita:)/
アニマティズム /(n) animatism/
アニマリズム /(n) animalism/
アニマル /(n) animal/(P)/
アニマル・セラピー /(n) animal therapy/
アニマルセラピー /(n) animal therapy/
アニマルトレーナー /(n) animal trainer/
アニマルライツ /(n) animal rights/
アニマルライト /(n) animal rights/
アニミズム /(n) animism/
アニメ /(n,adj-no) (1) animated film/animated cartoon/anime (when referring to Japanese cartoons)/(2) (abbr) animation/(P)/
アニメーション /(n,adj-no) (1) animation/(2) animated film/animated cartoon/(P)/
アニメーションソフト /(n) (comp) animation software/
アニメーター /(n) animator/
アニメーテッドＧＩＦ [アニメーテッドギッフ] /(n) (comp) Animated Graphics Interchange Format/
アニメーテッドＧＩＦ [アニメーテッドジッフ] /(n) (comp) Animated Graphics Interchange Format/
アニメイト /(adj-f) animate/
アニメオタク /(n) anime otaku/
アニメキャラ /(n) (abbr) cartoon characters/anime characters/
アニメキャラクター /(n) cartoon characters/anime characters/
アニメソング /(n) anime song/
アニメ映画 [アニメえいが] /(n) animated cartoon/animated film/
アニュアル /(n,adj-f) annual/
アニュアルレポート /(n) annual report/
アニュスデイ /(n) Agnus Dei (lat:)/
アニョロッティ /(n) agnolotti (ita:)/
アニリン /(n) aniline/
アニリングス /(n) anilingus/
アニリンブラック /(n) aniline black/
アニリン染料 [アニリンせんりょう] /(n) aniline dye/
アニリン点 [アニリンてん] /(n) aniline point/
アヌス /(n) anus (lat:)/
アネアロビクス /(n) anaerobics/
アネクドート /(n) anecdote/
アネクメーネ /(n) Anoekumene (ger:)/
アネスセチック /(n) anesthetic/anaesthetic/
アネスセティック /(n) anesthetic/anaesthetic/
アネックス /(n) annex/annexe/
アネモネ /(n) anemone (lat:)/windflower/
アネモメーター /(n) anemometer/
アネルギー /(n) anergy/
アネロイド /(adj-no,adj-f) aneroid/
アネロイド気圧計 [アネロイドきあつけい] /(n) aneroid barometer/
アノード /(n) anode/
アノードスライム /(n) anode slime/
アノール /(n) anole/American chameleon/
アノールトカゲ /(n) anole/American chameleon/
アノア /(n) anoa (either of two small African water buffalo of genus Bubalus)/
アノイボット /(n) (comp) annoybot/
アノイリン /(n) aneurin/
アノテーション /(n) annotation/
アノニマス /(n) anonymous/
アノニマスＦＴＰ [アノニマスエフティーピー] /(n) (comp) anonymous ftp/
アノニマスエフティーピー /(n) (comp) anonymous FTP/
アノニマスサーバ /(n) (comp) anonymous server/
アノニム /(n) anonym/
アノフェレス /(n) (obsc) Anopheles (genus of mosquitoes that act as malarial vectors)/
アノミー /(n) anomie (fre:)/anomy/
アノラック /(n) anorak/
アノレクシア /(n) anorexia/
アバウト /(adj-na) (1) approximate (number)/rough (calculation)/(2) sloppy (person)/lackadaisical/(P)/
アバカ /(n) abaca (Musa textilis)/
アバクロ /(n) (col) (abbr) Abercrombie & Fitch (clothing retailer)/
アバター /(n) (1) avatar/incarnation of an immortal being (Hindu)/(2) (comp) icon or representation of a user in a shared virtual reality/
アバディーンアンガス種 [アバディーンアンガスしゅ] /(n) Aberdeen Angus (type of cattle)/
アバランシュ /(n) avalanche (fre:)/
アバンギャルド /(n) avant-garde (fre:)/
アバンゲール /(n) pre-war (fre: avant-guerre)/
アバンタイトル /(n) material before the title and credits in anime, etc. (wasei: avant title)/
アバンチュール /(n) adventure (fre: aventure)/
アパーチャ /(n) aperture/
アパーチャグリル /(n) (comp) aperture grille/
アパーチュア /(n) aperture/
アパート /(n) (1) (abbr) apartment building/apartment block/apartment house/(2) (abbr) apartment/(P)/
アパートメント /(n) apartment/
アパートメントハウス /(n) apartment house/
アパート荒らし [アパートあらし] /(n) apartment house robbery (robber)/
アパコン /(n) (abbr) aperture compensation/
アパシー /(n) apathy/
アパタイト /(n) appetite/
アパチャカード /(n) (comp) aperture card/
アパッシュ /(n) apache (fre: apache)/
アパッチ /(n) Apache/
アパテイア /(n) apatheia (gre:)/
アパトサウルス /(n) apatosaurus (lat:)/brontosaurus/
アパラチア山脈 [アパラチアさんみゃく] /(n) Appalachian mountains/Appalachians/
アパルトヘイト /(n) apartheid/
アパルトヘイド /(n) apartheid/
アパルトマン /(n) apartment (fre: appartement)/
アパレイション /(n) (1) appellation/(2) operation/
アパレル /(n) apparel (clothing)/
アパレルメーカー /(n) apparel (clothing) maker/
アパレル産業 [アパレルさんぎょう] /(n) apparel business/
アヒンサー /(n) ahimsa (principle of non-violence in Jainism, Buddhism, Hinduism, etc.)/
アビ /(n) (uk) red-throated loon (Gavia stellata)/
アビーム /(n) abeam (e.g. wind)/
アビエーション /(n) aviation/
アビオニクス /(n) avionics/
アビシニア /(n) (uk) Abyssinia (Empire of Ethiopia, 980 B.C. to 1974)/
アビシニアジャッカル /(n) Abyssinia jackal (carnivore, Canis simensis)/simian jackal/simenian jackal/simenian wolf/Ethiopian wolf/
アビシニアン /(n) Abyssinian (breed of cat)/
アビタ /(n) arbiter/
アビタシオン /(n) habitation (fre:)/
アビュース /(n) abuse/
アビューズ /(n) abuse/
アビリスク /(n) obelisk/
アビリティー /(n) ability/
アビリンピック /(n) ability Olympics (wasei: abi-olympics)/
アピーズメントポリシー /(n) appeasement policy/
アピール /(n) (1) appeal/(vs) (2) to attract/to appeal (to)/(P)/
アピる /(v5r) (sl) to try to make a favourable impression/to appeal/
アピアランスマネー /(n) appearance money/
アピストグラマ /(n) Apistogramma (genus of cichlids)/
アピタイザー /(n) appetizer/
アピックネット /(n) (comp) APICNET/
アファーマティブアクション /(n) affirmative action/
アフィ /(n) (col) (abbr) affiliate program (of Internet advertising)/
アフィニティ /(n) (comp) affinity/
アフィニティークロマトグラフィー /(n) affinity chromatography/
アフィリ /(n) (abbr) affiliate/
アフィリエート /(n) affiliate/affiliation/
アフィリエートサービス /(n) (comp) affiliate service/
アフィリエートプログラム /(n) (comp) affiliate program (of Internet advertising)/
アフィリエートマーケティング /(n) (comp) affiliate marketing/
アフィリエイト /(n) affiliate/affiliation/
アフィリエイトサービス /(n) (comp) affiliate service/
アフィリエイトプログラム /(n) (comp) affiliate program (of Internet advertising)/
アフィリエイトマーケティング /(n) (comp) affiliate marketing/
アフィン変換 [アフィンへんかん] /(n) (comp) affine transformation/
アフェア /(n) affair/
アフェアー /(n) affair/
アフェクション /(n) affection/
アフェリエイト /(ik) (n) affiliate/affiliation/
アフェレーシス /(n) apheresis/
アフォーダンス /(n) affordance/affordability/
アフォリズム /(n) aphorism/
アフォルズム /(n) aphorism/
アフカーナ /(n) Afrikaner/
アフガニスタン /(n,adj-no) Afghanistan/
アフガン /(n) Afghan/
アフガン戦争 [アフガンせんそう] /(n) Afghan Wars/
アフガン編み [アフガンあみ] /(n) Afghan stitch/
アフタ /(n) aphtha/
アフター /(n) after/(P)/
アフター・フォロー /(n) follow-up service (wasei: after follow)/follow-up services/
アフターケア /(n) after-sales service (wasei: after care)/
アフターサービス /(n) after-sales service (wasei: after service)/warranty service/
アフターシェーブローション /(n) after-shave lotion/
アフタースキー /(n) after-ski/
アフターダーク /(n) (comp) After Dark/
アフターヌーン /(n) afternoon/(P)/
アフターヌーンドレス /(n) afternoon dress/
アフターバーナー /(n) afterburner/
アフタービート /(n) afterbeat/
アフターファイブ /(exp) after five/
アフターフォロー /(n) follow-up service (wasei: after follow)/follow-up services/
アフターレコーディング /(n) adding sounds to a soundtrack after a film has been made (wasei: after recording)/postrecording/postsynchronization/postsynchronisation/postlooping/dubbing/
アフタヌーン /(n) afternoon/
アフタヌーンシャドー /(n) afternoon shadow/
アフタヌーンドレス /(n) afternoon dress/
アフタ性口内炎 [アフタせいこうないえん] /(n) stomatitis aphthosa/
アフラトキシン /(n) aflatoxin/
アフリカ /(n,adj-no) (uk) Africa/(P)/
アフリカーンス /(n) Afrikaans/
アフリカーンス語 [アフリカーンスご] /(n) Afrikaans (language)/
アフリカの角 [アフリカのつの] /(n) horn of Africa/
アフリカコシジロアマツバメ /(n) (uk) white-rumped swift (Apus caffer)/
アフリカスイギュウ /(n) (uk) African buffalo/Cape buffalo (Syncerus caffer)/
アフリカスミレ /(n) (uk) African violet/
アフリカンアメリカン /(n) African-American/
アフリカンエンジェル /(n) Guinean angelfish (Holacanthus africanus)/West African angelfish/
アフリカンコリス /(n) false clownwrasse (Coris cuvieri)/African coris/
アフリカンスペードフィッシュ /(n) African spadefish (Tripterodon orbis, species of Western Indian Ocean spadefish)/
アフリカンバタフライフィッシュ /(n) African butterflyfish (Chaetodon dolosus)/
アフリカ系アメリカ人 [あふりかけいあめりかじん] /(n) African American/
アフリカ腰白雨燕 [アフリカこしじろあまつばめ] /(n) (uk) white-rumped swift (Apus caffer)/
アフリカ象 [アフリカぞう] /(n) African elephant/
アフリカ人 [アフリカじん] /(n) African/
アフリカ水牛 [アフリカすいぎゅう] /(n) (uk) African buffalo/Cape buffalo (Syncerus caffer)/
アフリカ大陸 [アフリカたいりく] /(n) African Continent/
アフリカ南部 [アフリカなんぶ] /(adj-no) South African/
アフリカ民族会議 [アフリカみんぞくかいぎ] /(n) African National Congress/ANC/
アフリカ菫 [アフリカすみれ] /(n) (uk) African violet/
アフレコ /(n) (abbr) adding sounds to a soundtrack after a film has been made (wasei: after recording)/postrecording/postsynchronization/postsynchronisation/postlooping/dubbing/
アフロ /(n) Afro/
アフロアジア語族 [アフロアジアごぞく] /(n) Afro-Asiatic (family of languages)/
アフロカリビアン /(n,adj-no) Afro-Caribbean/
アフロキューバンリズム /(n) Afro-Cuban rhythm/
アフロディテ /(n) Aphrodite/
アフロヘア /(n) Afro-hair/
アブ /(n) (uk) horsefly/gadfly/
アブサイジン酸 [アブサイジンさん] /(n) abscisic acid/
アブサン /(n) absinthe (fre:)/
アブサン油 [アブサンゆ] /(n) absinthe oil/wormwood oil/
アブシジン酸 [アブシジンさん] /(n) abscisic acid/
アブストラクション /(n) abstraction/
アブストラクト /(adj-na,n) abstract (of a paper)/
アブストラクトアート /(n) abstract art/
アブストラクトゲーム /(n) abstract strategy game (wasei: abstract game)/
アブセンティズム /(n) absenteeism/
アブソーバー /(n) absorber/
アブソリューティズム /(n) absolutism/
アブソリュート /(n) absolute/
アブソルバン /(adj-no) absorbant (fre:)/
アブダクション /(n,vs) abduction/
アブノーマル /(adj-na,n) abnormal/
アブラカダブラ /(int) abracadabra/
アブラガニ /(n) (1) (uk) blue king crab (Paralithodes platypus)/(2) striped shore crab (Pachygrapsus crassipes)/
アブラギク /(n) (uk) chrysanthemum (Chrysanthemum indicum)/
アブラギリ /(n) (uk) Japanese tungoil tree (Vernicia cordata)/
アブラコウモリ /(n) (uk) Japanese house bat/Japanese pipistrelle (Pipistrellus abramus)/
アブラザメ /(n) (uk) spiny dogfish (Squalus acanthias)/
アブラソコムツ /(n) (uk) escolar (Lepidocybium flavobrunneum)/snake mackerel/
アブラチャン /(n) Parabenzoin praecox/
アブラツノザメ /(n) (uk) spiny dogfish (Squalus acanthias)/
アブラナ /(n) rape (seed oil plant, Brassica campestris)/
アブラナ科 [アブラナか] /(n) Brassicaceae (cabbage family of plants)/
アブラハヤ /(n) (uk) Amur minnow (Phoxinus logowskii steindachneri)/
アブラヒガイ /(n) (uk) Sarcocheilichthys biwaensis (species of cyprinid)/
アブラボウズ /(n) (uk) skilfish (Erilepis zonifer)/skil/
アブラボテ /(n) oily bitterling (Tanakia limbata)/
アブラムシ /(n) (1) (uk) aphid/plant louse/(2) (obsc) cockroach/(3) (obsc) Japanese house bat (Pipistrellus abramus)/(4) hanger-on/parasite/(5) (arch) visitor to a red-light district who's only there to look/
アブラメ /(n) (1) (obsc) greenling/(2) salamander/
アブラヤシ /(n) (uk) oil palm (esp. the African oil palm, Elaeis guineensis)/
アプザイレン /(n,vs) abseiling (ger: Abseilen)/lowering on a rope/
アプス /(n) apse/
アプストレー /(adj-no) abstrait (fre:)/
アプソルバン /(adj-no) absorbant (fre:)/
アプダ /(n) (comp) APDA/
アプライ /(n) apply/
アプライアンス /(n) appliance/
アプライアンスサーバ /(n) (comp) appliance server/
アプリ /(n) (comp) (abbr) (computer) application/(P)/
アプリオリ /(adj-na,n) a priori (lat:)/
アプリオリ法 [アプリオリほう] /(n) (comp) gestalt method/a priori method/
アプリカント /(n) applicant/
アプリケ /(n) applique (fre:)/
アプリケーション /(n) (comp) application/(P)/
アプリケーションを終了する [アプリケーションをしゅうりょうする] /(exp,vs-i) (comp) to exit from the application/
アプリケーションアイコン /(n) (comp) application icon/
アプリケーションインターフェース /(n) (comp) application interface/
アプリケーションエンジニア /(n) (comp) application systems engineer/
アプリケーションキー /(n) (comp) application key/
アプリケーションサーバ /(n) (comp) application server/
アプリケーションサーバー /(n) (comp) application server/
アプリケーションサービス /(n) (comp) application service/
アプリケーションサービスプロバイダ /(n) (comp) Application Service Provider/
アプリケーションシステム /(n) (comp) application system/
アプリケーションジェネレータ /(n) (comp) application generator/
アプリケーションソフト /(n) (comp) application software/
アプリケーションソフトウェア /(n) (comp) application software/
アプリケーションソフトウエア /(n) (comp) application software/
アプリケーションテクノロジ /(n) (comp) application technology/
アプリケーションデータ /(n) (comp) application data/
アプリケーションノート /(n) (comp) application note/
アプリケーションバンドル /(n) (comp) application-bundling/
アプリケーションフォーマット /(n) (comp) disk formatting (wasei: application format)/
アプリケーションフレームワーク /(n) (comp) application framework/
アプリケーションプログラミングインタフェース /(n) (comp) application programming interface/API/
アプリケーションプログラム /(n) (comp) application program/application programme/
アプリケーションプログラムパッケージ /(n) (comp) application program package/
アプリケーションプロセッサ /(n) (comp) application processor/
アプリケーションプロトコル /(n) (comp) application protocol/
アプリケーション開発 [アプリケーションかいはつ] /(n) (comp) application development/
アプリケーション開発システム [アプリケーションかいはつシステム] /(n) (comp) application development system/
アプリケーション開発ツール [アプリケーションかいはつツール] /(n) (comp) application development tool/
アプリケーション開発環境 [アプリケーションかいはつかんきょう] /(n) (comp) Application Development Environment/ADE/
アプリケーション開発言語 [アプリケーションかいはつげんご] /(n) (comp) application development language/
アプリケーション開発者 [アプリケーションかいはつしゃ] /(n) (comp) application developer/applications developer/applications programmer/
アプリケーション設計プロセス [アプリケーションせっけいプロセス] /(n) (comp) application design process/
アプリケーション層 [アプリケーションそう] /(n) (comp) application layer/
アプリケーション部 [アプリケーションぶ] /(n) (comp) application part/
アプリケータ /(n) applicator/
アプリコット /(n) apricot/
アプル /(n) (comp) A Programming Language/APL/
アプルーバル /(n) approval/
アプルーブ /(vs) to approve/
アプレゲール /(n) apres-guerre (fre:)/
アプレット /(n) (comp) applet/
アプレットビューアー /(n) (comp) applet viewer/
アプローズ /(n) applause/
アプローチ /(n,vs) (1) approach/(2) (abbr) approach shot/(P)/
アプローチショット /(n) approach shot/
アプローチライト /(n) approach light/
アプロード /(vs) to applaud/
アプロプリエーションアート /(n) appropriation art/
アヘッド /(n) ahead/
アヘン /(n) (uk) opium/
アヘン常用者 [アヘンじょうようしゃ] /(n) opium smoker/opium eater/
アヘン戦争 [アヘンせんそう] /(n) Opium War (1840-42)/
アヘン中毒 [アヘンちゅうどく] /(n) opium addiction/
アベイラビリティ /(n) availability/
アベイラビリティー /(n) availability/
アベイラビリティ基準 [アベイラビリティきじゅん] /(n) availability criterion/availability criteria/
アベイラビリティ率 [アベイラビリティりつ] /(n) availability ratio/
アベイラブル /(adj-f) available/
アベイラブルビットレイト /(n) (comp) available bit rate/
アベック /(n) a couple (of lovers, etc.) (fre: avec)/(P)/
アベックホームラン /(n) back-to-back homeruns (baseball) (wasei: avec homerun)/
アベニュー /(n) avenue/(P)/
アベハゼ /(n) (uk) Samoan mullet goby (Mugilogobius abei)/
アベマリア /(exp) Ave Maria (prayer) (lat:)/Hail Mary/
アベレージ /(n) average/
アベレージゴルファー /(n) average golfer/
アベンド /(n) (comp) abnormal termination/abnormal end/ABEND/
アペタイザー /(n) appetizer/appetiser/
アペリチフ /(n) aperitif (fre:)/
アペリティフ /(n) aperitif (fre:)/
アペンディクス /(n) appendix (of a book, etc.)/
アペンディサイティス /(n) appendicitis/
アペンディックス /(n) appendix (of a book, etc.)/
アペンド /(n) (comp) append/
アホ /(adj-na,n) (sens) fool/simpleton/idiot/
アホウドリ /(n) (uk) albatross (esp. the short-tailed albatross, Phoebastria albatrus)/
アホロートル /(n) axolotl/Mexican walking fish/edible salamander/neotenous salamander (Ambystoma mexicanum)/
アホロトル /(n) axolotl/Mexican walking fish/edible salamander/neotenous salamander (Ambystoma mexicanum)/
アホ毛 [アホげ] /(n) (1) (m-sl) long spike (or 'antenna') of hair, may do tricks (seen in anime and manga)/(2) frizz/short tufts springing up from hair surface here and there/
アボート /(n,vs) (comp) abort/
アボカド /(n) avocado/
アボガド /(n) avocado/
アボガドロの法則 [アボガドロのほうそく] /(n) Avogadro's law/
アボガドロ数 [アボガドロすう] /(n) (obs) Avogadro's number/Avogadro's constant/
アボガドロ定数 [アボガドロていすう] /(n) Avogadro's constant/Avogadro's number/
アボジ /(n) father (kor:)/
アボスティル /(n) stamp or certificate of public document authentication in accordance with Hague Convention XII/apostille/
アボリジニ /(n) aborigine/
アボリジニー /(n) aborigine/
アボリジニ語 [アボリジニご] /(n) Aboriginal languages (of Australia)/
アボリジン /(n) aborigine/
アポ /(n) (abbr) appointment/
アポート /(ik) (n,vs) (comp) abort/
アポインテシステム /(n) (abbr) appointment system/
アポインテメントシステム /(n) appointment system/
アポイント /(n) (abbr) appointment/
アポイントメント /(n) appointment/
アポカリプス /(n) apocalypse/
アポクリファ /(n) Apocrypha/
アポクリン腺 [アポクリンせん] /(n) apocrine gland/
アポクロマート /(n) Apochromat (ger:)/
アポジモーター /(n) apogee motor/
アポスティーユ /(n) stamp or certificate of public document authentication in accordance with Hague Convention XII/apostille/
アポステリオリ /(n,adj-na) a posteriori (lat:)/
アポストロフィ /(n) apostrophe/
アポストロフィー /(n) apostrophe/
アポトーシス /(n) apoptosis/apoptotic/
アポトリテル /(n) telephone call made to get an appointment/
アポプトーシス /(n) apoptosis/apoptotic/
アポミクシス /(n) apomixis (seed development without fertilization)/
アポミクシス性 [アポミクシスせい] /(n,adj-no) apomictic/of or relating to a plant that reproduces by apomixis/related to reproduction without fertilization, meiosis or production of gametes, with the result that the seeds are genetically identical to the parent plant/
アポミクティック /(n) apomictic/of or relating to a plant that reproduces by apomixis/related to reproduction without fertilization, meiosis or production of gametes, with the result that the seeds are genetically identical to the parent plant/
アポモルヒネ /(n) apomorphine/
アポリア /(n) aporia (grc:)/
アポロ /(n) (1) (abbr) (Project) Apollo (lat:)/(2) Apollo (god of Greek and Roman mythology) (lat:)/
アポロ１１号 [アポロじゅういちごう] /(n) Apollo 11/
アポロン /(n) Apollo (gre: Apollon)/
アポロン的 [アポロンてき] /(adj-na) Apollonian/
アポロ計画 [アポロけいかく] /(n) Apollo Project/
アポロ的 [アポロてき] /(adj-na) Apollonian/
アポロ薄羽白蝶 [アポロうすばしろちょう] /(n) parnassian butterfly/
アポ酵素 [アポこうそ] /(n) apoenzyme/
アマ /(n) (abbr) amateur/(P)/
アマ /(n,adj-no) flax (Linum usitatissimum)/linseed/
アマービレ /(n) amabile (music)/
アマエビ /(n) (uk) northern shrimp (Pandalus borealis)/sweet shrimp/northern pink prawn/red shrimp/Maine shrimp/
アマオブネガイ /(n) (uk) ox-palate nerite (Nerita albicilla)/blotched nerite/
アマガサヘビ /(n) (uk) krait (esp. the Taiwanese banded krait, Bungarus multicinctus)/
アマサギ /(n) (uk) cattle egret (Bubulcus ibis)/
アマシイラ /(n) luvar (Luvarus imperialis, species of perciform fish closely related to the surgeonfish)/
アマシイラ科 [アマシイラか] /(n) Luvaridae (family containing 1 extant species of perciform fish similar to a surgeonfish)/
アマシイラ属 [アマシイラぞく] /(n) Luvarus (sole genus of perciform fish in the family Luvaridae whose only member is the luvar)/
アマゾーン /(n) Amazon/
アマゾニス /(n) Amazons/
アマゾネス /(n) Amazons/
アマゾン /(n,adj-no) (1) the Amazon river/(2) Amazon (woman of Greek mythology)/
アマゾンドットコム /(n) (comp) Amazon.com/
アマゾン川 [アマゾンがわ] /(n) Amazon River/
アマチャヅル /(n) (uk) jiaogulan (species of herbaceous vine; Gynostemma pentaphyllum)/
アマチュア /(n,adj-no) amateur/(P)/
アマチュアカメラマン /(n) amateur photographer/
アマチュアバンド /(n) amateur bands/
アマチュアマラソン /(n) amateur marathon/fun run/
アマチュアリズム /(n) amateurism/
アマチュア無線 [アマチュアむせん] /(n) amateur radio/
アマチュア無線局 [アマチュアむせんきょく] /(n) amateur radio station/
アマツバメ /(n) (1) (uk) swift (any bird of family Apodidae)/(2) fork-tailed swift (Apus pacificus)/
アマナ /(n) (uk) Tulipa edulis (species of tulip with an edible bulb)/
アマビリスモミ /(n) (uk) Pacific silver fir (Abies amabilis)/
アマビリス樅 [アマビリスもみ] /(n) (uk) Pacific silver fir (Abies amabilis)/
アマミスズメダイ /(n) stout chromis (Chromis chrysura)/
アマミノクロウサギ /(n) (uk) Amami rabbit (Pentalagus furnessi)/Ryukyu rabbit/
アマリリス /(n) amaryllis/
アマルガム /(n) amalgam/
アマルナ時代 [アマルナじだい] /(n) Amarna period (of Egyptian history)/
アマルナ文書 [アマルナぶんしょ] /(n) Amarna letters (archive of Egyptian correspondence, recorded on clay tablets)/
アマレット /(n) amaretto (ita:)/
アマン /(n) lover (fre: amant, amante)/
アマ相撲 [アマずもう] /(n) amateur sumo/
アミ /(n) (1) friend (fre: ami, amie)/(2) AMI/
アミーガ /(n) (comp) Amiga/
アミーバ /(n,adj-no) amoeba/
アミール /(n) amir (ara:)/
アミア /(n) bowfin (Amia calva) (lat: Amia)/mudfish/
アミアイゴ /(n) little spinefoot (Siganus spinus, species of Indo-West Pacific rabbitfish)/black spinefoot/black trevally/blue-spotted trevally/spiny rabbitfish/
アミカス・キューリー /(n) amicus curiae/friend of the court/
アミカス・キュリィ /(n) amicus curiae/friend of the court/
アミカス・キュリエ /(n) amicus curiae/friend of the court/
アミグダリン /(n) amygdalin/
アミセチン /(n) amicetin/
アミチョウチョウウオ /(n) latticed butterflyfish (Chaetodon rafflesii, species found in the Indo-Pacific)/
アミティ /(n) amity/
アミド /(n) amide/
アミドール /(n) amidol/
アミノ /(pref) amino/
アミノピリン /(n) aminopyrine/
アミノ安息香酸エチル [アミノあんそくこうさんエチル] /(n) ethyl aminobenzoate/
アミノ基 [アミノき] /(n) amino group/
アミノ酸 [アミノさん] /(n) amino acid/(P)/
アミノ酸発酵 [アミノさんはっこう] /(n) amino-acid fermentation/
アミノ樹脂 [アミノじゅし] /(n) amino resin/
アミノ糖 [アミノとう] /(n) amino-sugar/
アミメウナギ /(n) (uk) reedfish (Erpetoichthys calabaricus)/ropefish/
アミメカゲロウ /(n) (uk) neuropteran (any insect of order Neuroptera)/
アミメカゲロウ目 [アミメカゲロウもく] /(n) Neuroptera (order of insects with four membranous wings)/
アミメチョウチョウウオ /(n) pearlscale butterflyfish (Chaetodon xanthurus, Western Pacific species found from Indonesia and the Philippines north to the Ryukyu Islands)/Philippines chevron butterflyfish/orange butterflyfish/netted butterflyfish/yellow-tailed butterflyfish/
アミメニシキヘビ /(n) (uk) reticulated python (Python reticulatus)/
アミューズ /(vs) to amuse/
アミューズメント /(n) amusement/(P)/
アミューズメント・パーク /(n) amusement park/
アミューズメントセンター /(n) amusement center/amusement centre/
アミューズメントパーク /(n) amusement park/
アミュプラザ /(n) (abbr) amusement plaza/
アミラーゼ /(n) amylase (ger:)/
アミルアルコール /(n) amyl alcohol/
アミロース /(n) amylose/
アミロイド /(n) amyloid/
アミロイドーシス /(n) amyloidosis/
アミロイドニューロパシー /(n) familial amyloidotic polyneuropathy/FAP/
アミロペクチン /(n) amylopectin/
アミロ法 [アミロほう] /(n) amylo process/
アミン /(n,adj-no) amine/
アムール /(n) love (fre: amour)/
アムトラック /(n) Amtrak/
アムネスティ /(n) amnesty/
アムハラ /(n) Amhara (people)/
アムハラ語 [アムハラご] /(n) Amharic (language)/
アムホテリシン /(n) amphotericin/
アムラー /(n) (abbr) young girls who imitate the style of singer Amuro Namie/
アメーバ /(n,adj-no) amoeba/(P)/
アメーバ運動 [アメーバうんどう] /(n) ameboid movement/
アメーバ赤痢 [アメーバせきり] /(n) amoebic dysentery/
アメカジ /(n) (abbr) American casual (fashion style)/
アメコミ /(n) (abbr) American comic book/
アメシスト /(n) amethyst/
アメショー /(n) (abbr) American Shorthair (cat breed)/
アメジスト /(n) amethyst/
アメスク /(n) (abbr) American school/
アメスラン /(n) Ameslan/American sign language/
アメダス /(n) Automated Meteorological Data Acquisition System/AMeDAS/(P)/
アメニティ /(n) amenity/
アメニティー /(n) amenity/
アメノウオ /(n) (uk) biwa trout (Oncorhynchus masou rhodurus)/biwa salmon/
アメバ /(n,adj-no) amoeba/
アメフト /(n) (abbr) American football/(P)/
アメフラシ /(n) (uk) sea hare (esp. species Aplysia kurodai)/
アメラグ /(n) (abbr) American rugby/
アメリカ・ドル /(n) American dollar/United States dollar/US dollar/
アメリカざりがに /(n) (uk) red swamp crayfish (Procambarus clarkii)/
アメリカねずこ /(n) redwood/
アメリカねり /(n) okra/
アメリカももんが /(n) (uk) southern flying squirrel (Graucomys volans)/
アメリカインディアン /(n) American Indian/
アメリカインディアン諸語 [アメリカインディアンしょご] /(n) Amerindian languages/
アメリカオオコノハズク /(n) (uk) screech owl (Otus asio)/
アメリカオシ /(n) (uk) wood duck (Aix sponsa)/Carolina duck/
アメリカオンライン /(n) (comp) America On Line/AOL/
アメリカクロクマ /(n) (uk) American black bear (Ursus americanus)/
アメリカコガラ /(n) (uk) black-capped chickadee (Parus atricapillus)/
アメリカサインランゲージ /(n) American Sign Language/ASL/
アメリカザリガニ /(n) (uk) red swamp crayfish (Procambarus clarkii)/
アメリカシロヅル /(n) (uk) whooping crane (Grus americana)/
アメリカシロヒトリ /(n) (uk) fall webworm (Hyphantria cunea)/
アメリカスズカケノキ /(n) (uk) American sycamore (Platanus occidentalis)/
アメリカスペイン戦争 [アメリカスペインせんそう] /(n) Spanish-American War/
アメリカズカップレース /(n) America's Cup race/
アメリカソウ /(n) (uk) (obsc) moss-rose purslane (Portulaca grandiflora)/
アメリカダイシャクシギ /(n) (uk) long-billed curlew (Numenius americanus)/
アメリカダチョウ /(n) (uk) (obsc) rhea (Pterocnemia pennata)/
アメリカチョウゲンボウ /(n) (uk) American kestrel (Falco sparverius)/
アメリカデイゴ /(n) (uk) cockspur coral tree (Erythrina crista-galli)/
アメリカドクトカゲ /(n) (uk) Gila monster (Heloderma suspectum)/
アメリカドル /(n) American dollar/United States dollar/US dollar/
アメリカナイズ /(n,vs) Americanize/Americanise/
アメリカナヌカザメ /(n) (uk) swellshark (Cephaloscyllium ventriosum, species of catshark in the Eastern Pacific)/
アメリカニズム /(n) Americanism/
アメリカネリ /(n) okra/
アメリカバイソン /(n) American bison (Bison bison)/
アメリカバク /(n) (uk) Brazilian tapir/lowland tapir (Tapir tapirus)/
アメリカヒドリ /(n) (uk) American wigeon (Anas americana)/
アメリカヒレアシシギ /(n) (uk) Wilson's phalarope (Phalaropus tricolor)/
アメリカビーバー /(n) American beaver (Castor canadensis)/
アメリカフウ /(n) American sweetgum (Liquidambar styraciflua)/redgum/
アメリカプロフットボールリーグ /(n) National Football League/NFL/
アメリカボウフウ /(n) (uk) parsnip (plant) (Pastnica sativa)/
アメリカミズバショウ /(n) (uk) yellow skunk cabbage (Lysichiton americanum)/
アメリカミンク /(n) American mink (Mustela vison)/
アメリカムナグロ /(n) (uk) American golden plover (Pluvialis dominica)/
アメリカメキシコ戦争 [アメリカメキシコせんそう] /(n) Mexican-American War (1846-1848)/
アメリカモモンガ /(n) (uk) southern flying squirrel (Graucomys volans)/
アメリカヤツメ属 [アメリカヤツメぞく] /(n) Ichthyomyzon (genus of lamprey in the family Petromyzontidae)/
アメリカヤマボウシ /(n) (uk) flowering dogwood (Cornus florida)/
アメリカヨタカ /(n) (uk) common nighthawk (Chordeiles minor)/
アメリカライオン /(n) (American) puma/
アメリカワシミミズク /(n) (uk) great horned owl (Bubo virginianus)/
アメリカン /(n,adj-f) (1) American/(2) (abbr) American coffee (weaker than regular Japanese coffee)/(P)/
アメリカン・インディアン /(n) (sens) American Indian/
アメリカンインディアン /(n) (sens) American Indian/
アメリカンカジュアル /(n) American casual (fashion style)/
アメリカンコーヒー /(n) American coffee (i.e. weak and tasteless)/
アメリカンスクール /(n) American school/
アメリカンチェリー /(n) (1) Bing cherry (wasei: American cherry)/(2) cherries imported to Japan from America/
アメリカンドッグ /(n) corn dog (frankfurter on a stick dipped in batter and deep-fried) (wasei: American dog)/
アメリカンドリーム /(n) American dream/
アメリカンフットボール /(n) American football/
アメリカンブルックランプリ /(n) American brook lamprey (Lampetra appendix)/
アメリカンプラン /(n) American plan/
アメリカンリーグ /(n) American League/
アメリカ映画 [アメリカえいが] /(n) American film/American movie/
アメリカ英語 [アメリカえいご] /(n) American English/
アメリカ鴛鴦 [アメリカおし] /(n) (uk) wood duck (Aix sponsa)/Carolina duck/
アメリカ規格委員会 [アメリカきかくいいんかい] /(n) (comp) ANSI - American National Standards Institute/
アメリカ胸黒 [アメリカむなぐろ] /(n) (uk) American golden plover (Pluvialis dominica)/
アメリカ熊 [アメリカぐま] /(n) (uk) American black bear (Ursus americanus)/
アメリカ軍 [アメリカぐん] /(n) U.S. forces/American military/
アメリカ穴熊 [アメリカあなぐま] /(n) (uk) American badger (Taxidea taxus)/
アメリカ合衆国 [アメリカがっしゅうこく] /(n) the United States of America/(P)/
アメリカ合衆国連邦緊急事態管理庁 [アメリカがっしゅうこくれんぽうきんきゅうじたいかんりちょう] /(n) Federal Emergency Management Agency of the United States/FEMA/
アメリカ国土安全保障省 [アメリカこくどあんぜんほしょうしょう] /(n) Department of Homeland Security (US)/DHS/
アメリカ国防情報局 [アメリカこくぼうじょうほうきょく] /(n) Defense Intelligence Agency (USA)/
アメリカ黒熊 [アメリカくろくま] /(n) (uk) American black bear (Ursus americanus)/
アメリカ山法師 [アメリカやまぼうし] /(n) (uk) flowering dogwood (Cornus florida)/
アメリカ七日鮫 [アメリカなぬかざめ] /(n) (uk) swellshark (Cephaloscyllium ventriosum, species of catshark in the Eastern Pacific)/
アメリカ篠懸の木 [アメリカすずかけのき] /(n) (uk) American sycamore (Platanus occidentalis)/
アメリカ小雀 [アメリカこがら] /(n) (uk) black-capped chickadee (Parus atricapillus)/
アメリカ松 [アメリカまつ] /(n) (obsc) common Douglas fir (Pseudotsuga menziesii)/
アメリカ人 [アメリカじん] /(n) American person/
アメリカ人参 [アメリカにんじん] /(n) American ginseng (Panax quinquefolius)/
アメリカ水芭蕉 [アメリカみずばしょう] /(n) (uk) yellow skunk cabbage (Lysichiton americanum)/
アメリカ草 [アメリカそう] /(n) (uk) (obsc) moss-rose purslane (Portulaca grandiflora)/
アメリカ大杓鷸 [アメリカだいしゃくしぎ] /(n) (uk) long-billed curlew (Numenius americanus)/
アメリカ大木葉木菟 [アメリカおおこのはずく] /(n) (uk) screech owl (Otus asio)/
アメリカ大陸 [アメリカたいりく] /(n) American continent/the Americas/
アメリカ中央情報局 [アメリカちゅうおうじょうほうきょく] /(n) Central Intelligence Agency/CIA/
アメリカ長元坊 [アメリカちょうげんぼう] /(n) (uk) American kestrel (Falco sparverius)/
アメリカ梯沽 [アメリカでいご] /(n) (uk) cockspur coral tree (Erythrina crista-galli)/
アメリカ毒蜥蜴 [アメリカどくとかげ] /(n) (uk) Gila monster (Heloderma suspectum)/
アメリカ独立記念日 [アメリカどくりつきねんび] /(n) American Independence day/Fourth of July/
アメリカ独立戦争 [アメリカどくりつせんそう] /(n) American War of Independence/American Revolution/
アメリカ白鶴 [アメリカしろづる] /(n) (uk) whooping crane (Grus americana)/
アメリカ白灯蛾 [アメリカしろひとり] /(n) (uk) fall webworm (Hyphantria cunea)/
アメリカ緋鳥 [アメリカひどり] /(n) (uk) American wigeon (Anas americana)/
アメリカ豹 [アメリカひょう] /(n) jaguar/
アメリカ鰭足鷸 [アメリカひれあししぎ] /(n) (uk) Wilson's phalarope (Phalaropus tricolor)/
アメリカ文化 [アメリカぶんか] /(n) American culture/
アメリカ防風 [アメリカぼうふう] /(n) (uk) parsnip (plant) (Pastnica sativa)/
アメリカ夜鷹 [アメリカよたか] /(n) (uk) common nighthawk (Chordeiles minor)/
アメリカ野牛 [アメリカやぎゅう] /(n) buffalo/American bison/
アメリカ輸出入銀行 [アメリカゆしゅつにゅうぎんこう] /(n) Export-Import Bank (US)/
アメリカ領ヴァージン諸島 [アメリカりょうヴァージンしょとう] /(n) (p) United States Virgin Islands/
アメリカ連合国 [アメリカれんごうこく] /(n) The Confederate States of America/The Confederacy/CSA/
アメリカ連邦議会 [アメリカれんぽうぎかい] /(n) US Congress/
アメリカ鷲木菟 [アメリカわしみみずく] /(n) (uk) great horned owl (Bubo virginianus)/
アメリカ鰐 [アメリカわに] /(n) (uk) American crocodile (Crocodylus acutus)/
アメリカ獏 [アメリカばく] /(n) (uk) Brazilian tapir/lowland tapir (Tapir tapirus)/
アメリカ貘 [アメリカばく] /(n) (uk) Brazilian tapir/lowland tapir (Tapir tapirus)/
アメリカ鉤虫 [アメリカこうちゅう] /(n) New World hookworm (Necator americanus)/
アメリカ駝鳥 [アメリカだちょう] /(n) (uk) (obsc) rhea (Pterocnemia pennata)/
アメリケーヌソース /(n) American sauce/
アメリシウム /(n) americium (Am)/
アメンチア /(n) amentia (lat:)/
アメンド /(vs) to amend/
アメンボ /(n) (uk) pond skater (any insect of family Gerridae)/water strider/
アメンボウ /(n) (uk) pond skater (any insect of family Gerridae)/water strider/
アメ公 [アメこう] /(n) (col) American person/Yankee/
アメ車 [アメしゃ] /(n) American car/
アモス書 [アモスしょ] /(n) Amos (book of the Bible)/
アモルファス /(adj-f) amorphous/
アモルファスシリコン /(n) amorphous silicon/
アモルファス金属 [アモルファスきんぞく] /(n) amorphous metal/
アモルファス太陽電池 [アモルファスたいようでんち] /(n) amorphous solar cell/
アモルファス半導体 [アモルファスはんどうたい] /(n) amorphous semiconductor/
アモロソ /(n) amoroso (music)/
アモンド /(n) almond/
アヤトラ /(n) Ayatollah/
アヤメ /(n) (1) iris (flower)/(2) Siberian iris (Iris sanguinea)/(3) (arch) sweet flag (Acorus calamus)/calamus/
アユカケ /(n) (uk) fourspine sculpin (Cottus kazika)/
アユモドキ /(n) (uk) kissing loach (Leptobotia curta)/
アラ /(n) saw-edged perch (Niphon spinosus)/
アラー /(n) Allah/
アラート /(n,adj-no) alert/
アラーム /(n) alarm/
アラームスピーカ /(n) (comp) audible alarm speaker/
アラームプロファイル /(n) (comp) alarm profile/
アラームランプ /(n) (comp) alarm lamp/
アラーム検出 [アラームけんしゅつ] /(n) (comp) alarm detection/
アラーム重要度 [アラームじゅうようど] /(n) (comp) alarm severity/
アラールキル /(n) (chem) aralkyl/
アライアンス /(n) alliance/
アライバル /(n) arrival/
アライブ /(adj-f) (1) alive/(vs) (2) to arrive/
アライメント /(n) alignment/
アラインメント /(n) alignment/
アラインメントテストイメージ /(n) (comp) alignment test image/
アラウアンス /(n) allowance/
アラウンド /(n) around/
アラカシ /(n) (uk) ring-cupped oak (Quercus glauca)/Japanese blue oak/
アラカルト /(n) a la carte (fre:)/(P)/
アラキ /(n) arrack (grain or rice wine) (dut:)/arak/
アラキドン酸 [アラキドンさん] /(n) arachidonic acid/
アラサー /(exp) around 30/
アラザン /(n) silver dragee (fre: argent)/
アラスカヒグマ /(n) (uk) Kodiak bear (Ursus arctos middendorffi)/Alaskan brown bear/
アラスカメヌケ /(n) (uk) Pacific ocean perch (Sebastes alutus)/
アラスカン・マラミュート /(n) Alaskan malamute/
アラスカンマラミュート /(n) Alaskan malamute/
アラスカ目抜 [アラスカめぬけ] /(n) (uk) Pacific ocean perch (Sebastes alutus)/
アラスカ羆 [アラスカひぐま] /(n) (uk) Kodiak bear (Ursus arctos middendorffi)/Alaskan brown bear/
アラタ体 [アラタたい] /(n) corpus allatum/
アラック /(n) arrack (grain or rice wine) (dut:)/arak/
アラニン /(n) alanine/
アラバスター /(n) alabaster/
アラビア /(n,adj-no) (uk) Arabia/
アラビアコーヒーの木 [アラビアコーヒーのき] /(n) coffee tree/
アラビアゴム /(n) gum arabic/
アラビアゴムの木 [アラビアゴムのき] /(n) acacia/
アラビアチョウハン /(n) diagonal butterflyfish (Chaetodon fasciatus)/Red Sea raccoon butterflyfish/
アラビアン・エンジェルフィッシュ /(n) Arabian angelfish (Pomacanthus asfur)/
アラビアンエンジェルフィッシュ /(n) Arabian angelfish (Pomacanthus asfur)/
アラビアンクロミス /(n) Arabian chromis (Chromis flavaxilla)/
アラビアンナイト /(n) Arabian Nights (stories)/
アラビアンバタフライフィッシュ /(n) Arabian butterflyfish (Chaetodon melapterus)/blackfin butterflyfish/
アラビアンライト /(n) Arabian light/
アラビア医学 [アラビアいがく] /(n) Arabian medicine/
アラビア語 [アラビアご] /(n) Arabic (language)/
アラビア人 [アラビアじん] /(n) Arabian (person)/Arab/
アラビア数字 [アラビアすうじ] /(n) Arabic numeral/
アラビア馬 [アラビアうま] /(n) Arab (horse)/
アラビア文字 [アラビアもじ] /(n) Arabic script/
アラビア夜話 [アラビアよばなし] /(n) Arabian Nights/The Thousand and One Nights/The Arabian Nights' Entertainments/
アラフィフ /(exp) around 50 (years of age, esp. women)/
アラフォー /(exp) around 40 (years of age, esp. women) (eng:)/
アラフラオオセ /(n) (uk) tasselled wobbegong (Eucrossorhinus dasypogon, sole species of the carpet shark genus Eucrossorhinus)/
アラフラ大瀬 [アラフラおおせ] /(n) (uk) tasselled wobbegong (Eucrossorhinus dasypogon, sole species of the carpet shark genus Eucrossorhinus)/
アラブ /(n,adj-no) Arab/(P)/
アラブ首長国連邦 [アラブしゅちょうこくれんぽう] /(n) United Arab Emirates/
アラブ諸国 [アラブしょこく] /(n) Arab countries/Arab states/
アラブ人 [アラブじん] /(n) Arab/
アラブ連盟 [アラブれんめい] /(n) Arab League/
アラベスク /(n) arabesque (fre:)/
アラミド繊維 [アラミドせんい] /(n) aramid fibre/aramid fiber/
アラム /(n,adj-no) (1) alum/(2) Aram/
アラム語 [アラムご] /(n) Aramaic/
アラム文字 [アラムもじ] /(n) Aramaic letter/
アラメ /(n) (uk) arame (species of kelp, Eisenia bicyclis)/
アラメヘラザメ /(n) Apristurus fedorovi (Federov's catshark, a species from Japan)/
アラモード /(n) a la mode (fre:)/
アララギ /(n) (1) (uk) Japanese yew (Taxus cuspidata)/(2) (arch) wild rocambole (Allium grayi)/
アラルガンド /(n,adj-no) allargando/
アラレキンチャクフグ /(n) spotted sharpnose (Canthigaster solandri, type of pufferfish)/
アラレ石 [アラレいし] /(n) aragonite/
アラン /(n) Alan (member of an ancient Scythian people)/
アランダム /(n) alundum (material made of fused aluminum usu. used as an abrasive)/
アラントイン /(n) allantoin/
アラン模様 [アランもよう] /(n) Aran (sweater pattern)/
アリーナ /(n) arena/(P)/
アリーヤー /(n) aliyah/immigration to Israel/
アリール基 [アリールき] /(n) aryl group/
アリの塔 [アリのとう] /(n) anthill/
アリア /(n) aria (ita:)/(P)/
アリウス主義 [アリウスしゅぎ] /(n) Arianism/
アリエッタ /(n) arietta (music)/
アリクイ /(n) (uk) anteater/
アリグモ /(n) (uk) Myrmarachne japonica (species of ant-mimicking spider)/
アリゲーター /(n) alligator/
アリザリン /(n) alizarin/
アリスイ /(n) (uk) Eurasian wryneck (species of bird, Jynx torquilla)/
アリストクラシー /(n) aristocracy/
アリストクラット /(n) aristocrat/
アリストクラティック /(adj-no) aristocratic/
アリストテレスの提灯 [アリストテレスのちょうちん] /(n) Aristotle's lantern/
アリスマティック /(n) arithmetic/
アリダード /(n) alidade/
アリッグ /(n) (abbr) American league/
アリッサム /(n) alyssum/
アリドリ科 [アリドリか] /(n) Thamnophilidae (antbird family)/
アリバイ /(n) alibi/(P)/
アリバイ会社 [アリバイがいしゃ] /(n) front company set up to hide someone's true profession by pretending to employ them (often used by call girls)/
アリマキ /(n) (uk) aphid/plant louse/plant lice/
アリモドキゾウムシ /(n) (uk) sweet potato weevil (Cylas formicarius)/
アリヤー /(n) aliyah/immigration to Israel/
アリル /(n,adj-no) allyl/
アリルアルコール /(n) allyl alcohol/
アリ学 [アリがく] /(n) myrmecology (the study of ants)/
アリ塚 [アリづか] /(n) anthill/
アルカーイダ /(n) Al Qaeda/al-Qaeda/Al Qaida/al-Qaida/al-Qa'idah/
アルカイーダ /(n) Al Qaeda/al-Qaeda/Al Qaida/al-Qaida/al-Qa'idah/
アルカイスム /(n) archaism (fre:)/
アルカイズム /(n) archaism (fre:)/
アルカイダ /(n) Al Qaeda/al-Qaeda/Al Qaida/al-Qaida/al-Qa'idah/
アルカイック /(adj-na,n) archaic/
アルカイックスマイル /(n) archaic smile/
アルカディア /(n,adj-no) arcadia/(P)/
アルカプトン尿症 [アルカプトンにょうしょう] /(n) alkaptonuria/alcaptonuria/
アルカリ /(n) alkali/(P)/
アルカリ塩 [アルカリえん] /(n) alkali salt/
アルカリ乾電池 [アルカリかんでんち] /(n) alkaline battery/
アルカリ岩 [アルカリがん] /(n) alkali rock/
アルカリ金属 [アルカリきんぞく] /(n) alkali metal/
アルカリ血症 [アルカリけつしょう] /(n) (obsc) alkalosis/
アルカリ性 [アルカリせい] /(n,adj-no) alkalinity/alkaline/(P)/
アルカリ性食品 [アルカリせいしょくひん] /(n) alkaline food/
アルカリ電池 [アルカリでんち] /(n) alkali battery/
アルカリ土類金属 [アルカリどるいきんぞく] /(n) alkali earth metal/
アルカローシス /(n,adj-no) alkalosis/
アルカロイド /(n,adj-no) alkaloid/
アルカロシス /(n,adj-no) alkalosis/
アルカン /(n) alkane/
アルキド樹脂 [アルキドじゅし] /(n) alkyd resin/
アルキメデスの原理 [アルキメデスのげんり] /(n) Archimedes' principle/
アルキメデスの公理 [アルキメデスのこうり] /(n) axiom of Archimedes/
アルキメデスの螺線 [アルキメデスのらせん] /(n) Archimedean spiral/
アルキル /(n) alkyl/
アルキルアルミニウム /(n) alkylaluminium/
アルキルフェノール /(n) alkyl phenol/
アルキルベンゼン /(n) alkyl benzene/
アルキルベンゼンスルホン酸塩 [アルキルベンゼンスルホンさんえん] /(n) alkyl benzene sulfonate/
アルキル化 [アルキルか] /(n,vs) alkylation/
アルキル化剤 [アルキルかざい] /(n) alkylating agent/
アルキル基 [アルキルき] /(n) alkyl group/
アルキン /(n) alkyne/
アルギナーゼ /(n) arginase/
アルギニン /(n) arginine/
アルギン酸 [アルギンさん] /(n) alginic acid/
アルクトゥールス /(n) Arcturus (star in the constellation Bootes)/
アルクトゥルス /(n) Arcturus (star in the constellation Bootes)/
アルケミー /(n) alchemie (dut:)/
アルケン /(n) alkene/olefin/olefine/
アルコーブ /(n) alcove/
アルコール /(n,adj-no) alcohol/(P)/
アルコールハラスメント /(n) alcohol related harassment (wasei: alcohol harassment)/
アルコールランプ /(n) alcohol lamp/
アルコール依存症 [アルコールいぞんしょう] /(n) alcohol dependency/alcoholism/
アルコール飲料 [アルコールいんりょう] /(n) alcoholic drink/alcoholic beverage/
アルコール温度計 [アルコールおんどけい] /(n) alcohol thermometer/
アルコール検知器 [アルコールけんちき] /(n) breathalyser/alcometer/
アルコール性肝障害 [アルコールせいかんしょうがい] /(n) alcoholic liver disease/
アルコール中毒 [アルコールちゅうどく] /(n) alcoholism/alcohol addiction/
アルコール漬 [アルコールづけ] /(n) (1) preserving in alcohol/(2) pickling one's liver/drinking incessantly/being a souse/
アルコール漬け [アルコールづけ] /(n) (1) preserving in alcohol/(2) pickling one's liver/drinking incessantly/being a souse/
アルコール度 [アルコールど] /(n) alcohol content (usu. expressed per cent)/
アルコール発酵 [アルコールはっこう] /(n) alcohol fermentation/
アルコール分 [アルコールぶん] /(n) alcoholic content/
アルゴリズミック /(adj-na,n) algorithmic/
アルゴリズム /(n,adj-no) (comp) algorithm/(P)/
アルゴル /(n) (1) (comp) Algol (algorithmic language)/(2) Algol (beta perseus)/
アルゴン /(n) argon (Ar) (ger:)/
アルゴンキン族 [アルゴンキンぞく] /(n) Algonquin (nation)/
アルサロ /(n) (abbr) "salon" where the hostesses are supposedly part-timers with other jobs/
アルシオーネ /(n) Alcyone (star in Taurus, brightest of the Pleiades)/
アルシン /(n) arsine/
アルジェリア /(n) Algeria/
アルスアマトリア /(n) ars amatoria/
アルゼンチン /(n,adj-no) (uk) Argentina/
アルゼンチンタンゴ /(n) Argentine tango/
アルゼンチン出血熱 [アルゼンチンしゅっけつねつ] /(n) Argentine hemorrhagic fever/
アルタイル /(n) Altair (star in the constellation Aquila)/
アルタイ語族 [アルタイごぞく] /(n) Altaic (family of languages)/
アルタイ諸語 [アルタイしょご] /(n) Altaic/
アルタビスタ /(n) (comp) ALTA VISTA/
アルチザン /(n) artisan (fre:)/
アルツハイマー /(n) Alzheimer (disease)/(P)/
アルツハイマー病 [アルツハイマーびょう] /(n) Alzheimer's disease/
アルティアハチハチゼロゼロ /(n) (comp) Altair8800/
アルティチュード・ダイブ /(n) altitude dive/
アルティチュードダイブ /(n) altitude dive/
アルティメット /(adj-f) ultimate/
アルテミア /(n) brine shrimp (Artemia salina) (lat: artemia)/
アルテミシア属 [アルテミシアぞく] /(n) Artemisia (genus of a between 200 to 400 species of plants in the daisy family Asteraceae)/
アルテミス /(n) Artemis/
アルデバラン /(n) Aldebaran (star in the constellation Taurus)/
アルデヒド /(n) aldehyde/(P)/
アルデヒド基 [アルデヒドき] /(n) aldehyde group/
アルデンテ /(n,adj-no) al dente (ita:)/
アルト /(n) alto (ita:)/(P)/
アルトサックス /(n) alto saxophone/
アルト歌手 [アルトかしゅ] /(n) alto (voice or singer)/
アルドース /(n) aldose/
アルドステロン /(n) aldosterone/
アルドステロン症 [アルドステロンしょう] /(n) aldosteronism/
アルドリン /(n) aldrin/
アルニカ /(n) arnica (esp. mountain tobacco, Arnica montana) (lat:)/
アルハラ /(n) alcohol-related harassment/
アルバートサウルス /(n) Albertosaurus/
アルバイター /(n) part-time worker (ger: Arbeiter)/part-timer/
アルバイト /(n,vs) (1) part-time job (ger: Arbeit)/side job/(n) (2) albite/(P)/
アルバトロス /(n) albatross/
アルバニア /(n) Albania/
アルバニア語 [アルバニアご] /(n) Albanian (language)/
アルバニア語派 [アルバニアごは] /(n) Albanian (branch of languages)/
アルバム /(n) album/(P)/
アルパイン /(n) alpine/(P)/
アルパカ /(n) alpaca/
アルビーノ /(n) albino/
アルビノ /(n) albino/
アルビレオ /(n) Albireo (aka Beta Cygni)/
アルピニスト /(n) alpinist/
アルピニズム /(n) alpinism/
アルファ・ギーク /(n) (comp) alpha geek (var. of computer nerd)/
アルファとオメガ /(exp) (obsc) alpha and omega/
アルファギーク /(n) (comp) alpha geek (var. of computer nerd)/
アルファチャネル /(n) (comp) alpha channel/
アルファテスト /(n) (comp) alpha test/
アルファデータ /(n) (comp) Alpha Data/
アルファニューメリック /(n) (comp) alphanumeric/
アルファニューメリック表記法 [アルファニューメリックひょうきほう] /(n) (comp) alphanumeric notation/
アルファバージョン /(n) (comp) alpha version/
アルファベット /(n,adj-no) alphabet/(P)/
アルファベットの語 [アルファベットのご] /(n) (comp) alphabetic word/
アルファベット順 [アルファベットじゅん] /(n) alphabetical order/(P)/
アルファベット表記法 [アルファベットひょうきほう] /(n) (comp) alphabetical notation/
アルファルド /(n) Alphard (aka Alpha Hydra)/
アルファルファ /(n) alfalfa/
アルファ線 [アルファせん] /(n) alpha rays/
アルファ波 [アルファは] /(n) alpha wave/
アルファ版 [アルファばん] /(n) (comp) alpha version/
アルファ崩壊 [アルファほうかい] /(n) alpha decay/
アルファ粒子 [アルファりゅうし] /(n) alpha particle/
アルブミン /(n) albumin/
アルプス /(n,adj-no) alps/(P)/
アルプスの険 [アルプスのけん] /(n) steep pass in the Alps/
アルプスの嶮 [アルプスのけん] /(n) steep pass in the Alps/
アルプスイワナ /(n) Arctic char (Salvelinus alpinus alpinus)/
アルベド /(n) albedo/
アルペジオ /(n) arpeggio (ita:)/
アルペジオーネ /(n) arpeggione (ita:)/
アルペッジオ /(n) arpeggio (ita:)/
アルペッジョ /(n) arpeggio (ita:)/
アルペン /(n) Alpen (ger:)/
アルペンスキー /(n) Alpine skiing (ger: Alpenski)/
アルペンホルン /(n) alpenhorn (ger:)/alphorn/
アルペン種目 [アルペンしゅもく] /(n) Alpine events/Alpine sports/
アルホイル /(ik) (n) (abbr) aluminum foil/aluminium foil/tin foil/
アルマイト /(n) anodized aluminum (from Alumite (brand name))/anodised aluminium/
アルマジロ /(n) armadillo/
アルマナック /(n) almanac/
アルマニャック /(n) armagnac (fre:)/
アルマンディン /(n) almandine/
アルマンド /(n) allemande (dance) (fre:)/
アルミ /(n) (abbr) aluminum (Al)/aluminium/(P)/
アルミサッシ /(n) (abbr) aluminium sash (aluminum) (i.e. window frame)/
アルミナ /(n) alumina/
アルミナセメント /(n) alumina cement/
アルミナ磁器 [アルミナじき] /(n) alumina porcelain/
アルミニウム /(n,adj-no) aluminum (Al)/aluminium/(P)/
アルミニウム合金 [アルミニウムごうきん] /(n) aluminum alloy/
アルミニューム /(n,adj-no) aluminum (Al)/aluminium/
アルミホイル /(n) (abbr) aluminum foil/aluminium foil/tin foil/
アルミ缶 [アルミかん] /(n) aluminium can/aluminum can/
アルミ箔 [アルミはく] /(n) aluminum foil/
アルム /(n) arum (any plant of the genus Arum, typically having arrow-shaped leaves)/
アルメール /(n) (comp) AL-Mail/
アルメニア /(n) Armenia (Armyanskaya)/
アルメニア教会 [アルメニアきょうかい] /(n) Armenian Church/Armenian Apostolic Orthodox Church/
アルメニア語 [アルメニアご] /(n) Armenian (language)/
アルメニア語派 [アルメニアごは] /(n) Armenian (branch of languages)/
アルルカン /(n) arlequin (fre:)/
アル中 [アルちゅう] /(n) (abbr) alcoholism/
アレイ /(n) (1) array/(2) alley/
アレイコンピュータ /(n) (comp) array computer/
アレイプロセッサ /(n) (comp) array processor/
アレイプロセッサー /(n) (comp) array processor/
アレインメント /(n) arraignment/
アレイ処理 [アレイしょり] /(n) (comp) array processing/
アレイ処理機構 [アレイしょりきこう] /(n) (comp) array processor/vector processor/
アレイ処理装置 [アレイしょりそうち] /(n) (comp) array processor/vector processor/
アレカ椰子 [アレカやし] /(n) areca palm/
アレキサンドライト /(n) alexandrite/
アレクサンドライト /(n) alexandrite/
アレグレット /(n) allegretto (ita:)/
アレグロ /(n,adj-no) allegro (ita:)/
アレゴリー /(n) allegory/
アレス /(n) Ares (Greek god)/
アレチネズミ /(n) (uk) lesser Egyptian gerbil (Gerbillus gerbillus)/
アレックス /(n) (comp) Alex/
アレフ /(n) aleph/
アレルギー /(n,adj-no) allergy (ger: Allergie)/(P)/
アレルギーテスト /(n,vs) allergy testing/
アレルギー症状 [アレルギーしょうじょう] /(n) allergy symptoms/
アレルギー性 [アレルギーせい] /(adj-no) allergenic/allergic/
アレルギー性炎症 [アレルギーせいえんしょう] /(n) allergic inflammation/
アレルギー性疾患 [アレルギーせいしっかん] /(n) allergic disease/
アレルギー性鼻炎 [アレルギーせいびえん] /(n) allergic rhinitis/
アレルギー体質 [アレルギーたいしつ] /(n) allergic diathesis (predisposition to be allergic)/
アレルギー反応 [アレルギーはんのう] /(n) allergic reaction/
アレルゲン /(n) allergen (ger:)/
アレルゲン皮膚反応 [アレルゲンひふはんのう] /(n) allergen skin test/
アレルヤ /(n) alleluia (lat:)/
アレロタクシス /(n) allelotaxis/allelotaxy/
アレンジ /(vs) (1) to arrange/(n,vs) (2) (abbr) (musical) arrangement/(P)/
アレンジメント /(n) arrangement/
アレンジャー /(n) arranger/
アレンビック /(n) alembic/
アロー /(n) arrow/(P)/
アロー戦争 [アローせんそう] /(n) Arrow War (the second Opium War, 1856-1860)/
アロイ /(n) alloy/
アロエ /(n) aloe (lat:)/
アロカシア /(n) alocasia/
アロケーション /(n) allocation/
アロケート /(n) allocate/
アロサ /(n) shad (Alosa spp.) (lat: Alosa)/river herring/
アロサウルス /(n) allosaurus (lat:)/allosaur/
アロステリズム /(n,adj-no) allosterism/
アロステリック /(adj-no) allosteric/
アロステリック効果 [アロステリックこうか] /(n) allosteric effect/
アロタイプ /(n,adj-no) allotype/
アロック /(n) alloc/
アロハ /(n) (1) aloha/(2) (abbr) aloha shirt/(P)/
アロハシャツ /(n) aloha shirt/
アロフェン /(n) allophane/
アロマ /(adj-na) (1) aroma/(2) class/style/elegance/(3) (abbr) aromatherapy/
アロマを焚く [アロマをたく] /(exp,v5k) to burn aromatherapy oils/to diffuse aromatherapy oils/
アロマオイル /(n) aroma oil/
アロマセラピー /(n) aromatherapy (fre:)/
アロマテラピー /(n) aromatherapy (fre:)/
アロワナ /(n) arowana (any fish of subfamily Osteoglossinae)/bonytongue/
アワー /(n) hour/(P)/
アワード /(n) award/
アワビ /(n) (uk) abalone/ear shell/
アワフキムシ /(n) (uk) froghopper (any insect of family Cercopidea)/spittlebug/
アワブキ /(n) Meliosma myriantha/
アワブネガイ /(n) (uk) Bostrycapulus gravispinosus (species of spiny slipper snail)/
アンアイデンティファイド /(adj-f) unidentified/
アンインストール /(n,vs) (comp) uninstall/
アンカー /(n) (1) anchor/(2) (comp) link to previous post (e.g. in web forums)/(P)/
アンカーボルト /(n) anchor bolt/
アンカーマン /(n) anchorman/
アンカット /(n,adj-no) uncut (esp. of a book, etc.)/
アンカバー /(n) (comp) UnCover/
アンカレジ /(n) Anchorage/
アンカレッジ /(n) Anchorage/
アンガージュマン /(n) moral or political commitment to a cause (fre: engagement)/
アンガージュマンの文学 [アンガージュマンのぶんがく] /(n) literature politically or morally comitted to a cause/
アンキロザウルス /(n) ankylosaurus (lat:)/
アンギオテンシン /(n) angiotensin/
アンギナ /(n,adj-no) angina/
アンギュラー /(adj-no) angular/
アンク /(n) (1) ankh/(2) ANK/
アンクル /(n) (1) uncle/(2) ankle/
アンクルブーツ /(n) ankle boots/
アンクレット /(n) anklet/
アングィラ島 [アングィラとう] /(n) Anguilla (island)/
アングラ /(n) (abbr) underground/(P)/
アングラー /(n) angler/
アングラマネー /(n) (abbr) underground money/
アングラ映画 [アングラえいが] /(n) underground film/
アングラ劇場 [アングラげきじょう] /(n) underground theater/underground theatre/
アングリー /(adj-f) angry/
アングリカン教会 [アングリカンきょうかい] /(n) Anglican Church/
アングル /(n) angle/(P)/
アングルショット /(n) angle shot/
アングルドーザー /(n) angle dozer/
アングルブロック /(n) angle block/angle iron/
アングル括弧 [アングルかっこ] /(n) (comp) less-than mark/left angle bracket/
アングロ・カトリック /(n,adj-no) Anglo-Catholic/
アングロ・サクソン /(n,adj-no) Anglo-Saxon/
アングロアメリカ /(n) (1) Anglo-America/(2) English-speaking part of America/
アングロアラブ /(n) Anglo-Arab/
アングロカトリック /(n,adj-no) Anglo-Catholic/
アングロサクソン /(n,adj-no) Anglo-Saxon/
アングロノルマン /(n) (1) Anglo-Norman (French dialect)/(2) Anglo-Norman (horse breed)/
アンケート /(n) questionnaire (fre: enquete)/survey/(P)/
アンケート調査 [アンケートちょうさ] /(n) questionnaire survey/
アンケート用紙 [アンケートようし] /(n) questionnaire (form)/
アンゲリカ /(n) angelica (any herb of the genus Angelica, esp. garden angelica, Angelica archangelica)/
アンコール /(n,vs) encore/(P)/
アンコールアワー /(n) encore hour/
アンコウ /(n) (1) (uk) goosefish (any anglerfish of family Lophiidae)/monkfish/sea devil/(2) (arch) fool/(3) curved gutter/
アンコウザメ /(n) grey sharpnose shark (Rhizoprionodon oligolinx, species of requiem shark found in the Indo-West Pacific)/
アンコン /(n) (abbr) overcoat with very simple lines and no shoulder pads, etc. (from: unconstructed)/
アンゴラ /(n) (1) Angola/(2) angora/
アンゴラ共和国 [アンゴラきょうわこく] /(n) Republic of Angola/
アンゴラ山羊 [アンゴラやぎ] /(n) Angora goat/
アンゴラ兎 [アンゴラうさぎ] /(n) Angora rabbit/
アンゴラ猫 [アンゴラねこ] /(n) Angora cat/
アンサー /(n) answer/
アンサーファイル /(n) (comp) answer file/
アンサーモード /(n) (comp) answer mode/
アンサブスクライブ /(n) (comp) unsubscribe/
アンサホン /(n) answer phone/
アンサンブル /(n,vs,adj-no) ensemble/all-in/(P)/
アンザイレン /(n,vs) roping oneself up (ger: Anseilen)/
アンザス /(n) Australia, New Zealand and the United States/ANZUS/
アンザス条約 [アンザスじょうやく] /(n) ANZUS Treaty (Australia, New Zealand and the United States)/
アンザック /(n) Anzac (from Australian and New Zealand Army Corps during WWI)/
アンザックデー /(n) Anzac Day/
アンザックビスケット /(n) Anzac biscuit (type of oatmeal biscuit)/
アンシアル /(n) uncial/uncial letter/
アンシャンレジーム /(n) Ancien Regime (in France) (fre:)/
アンシラリー /(adj-f) ancillary/
アンシラリーサービス /(n) Ancillary services/
アンジェラス /(n) angelus/
アンジェリカ /(n) angelica (any herb of the genus Angelica, esp. garden angelica, Angelica archangelica)/
アンジオグラフィー /(n) angiography/
アンジッヒ /(n) thing in itself (philosophy) (ger: Ding an sich)/
アンジュレーション /(n) undulation/
アンスウィズル /(n) (comp) unswizzle/
アンスペシファイドビットレイト /(n) (comp) unspecified bit rate/
アンスリウム /(n) anthurium (type of tropical flowering plant) (lat:)/
アンセム /(n) anthem/
アンゼリカ /(n) angelica (any herb of the genus Angelica, esp. garden angelica, Angelica archangelica)/
アンソロ /(n) (abbr) anthology/
アンソロジー /(n) anthology/(P)/
アンタイドローン /(n) untied loan/
アンタゴニスト /(n,adj-f) antagonist/
アンタゴニズム /(n) antagonism/
アンタッチャブル /(adj-na,n) untouchable/
アンタレス /(n) Antares/
アンタント /(n) entente (fre:)/
アンダー /(n) under/(P)/
アンダー・ザ・テーブル /(n,adj-no) under-the-table/
アンダーウェア /(n) underwear/
アンダーウエア /(n) underwear/
アンダーカット /(n) undercut/
アンダーカバー /(adj-f) undercover/
アンダーグラウンド /(n) underground/
アンダーコート /(n) undercoat/
アンダーザテーブル /(n,adj-no) under-the-table/
アンダーシャツ /(n) undershirt/
アンダースカート /(n) bloomers (wasei: under skirt)/'safe' pants worn over normal underwear in sports/
アンダースキル /(n) underskill/
アンダースコート /(n) bloomers (wasei: under skirt)/'safe' pants worn over normal underwear in sports/
アンダースコア /(n) underscore/
アンダースタンド /(vs) understand/
アンダースロー /(n) (abbr) underhand throw (baseball)/submarine pitch/
アンダートーン /(n) undertone/
アンダーハンド /(adj-no) underhand/
アンダーハンドサーブ /(n) underhand serve/
アンダーハンドスロー /(n) underhand throw/
アンダーバスト /(n) under bust (measurement, corsette, etc.)/
アンダーパー /(n) under par/
アンダーパス /(n) (roadway) underpass/
アンダーピニング /(n) underpinning/
アンダーフロー /(n) (comp) underflow/
アンダープルーフ /(n) underproof/
アンダープロット /(n) underplot/
アンダーヘア /(n) (female) genital hair (wasei: under hair)/
アンダーライター /(n) underwriter/
アンダーライン /(n) underline/(P)/
アンダーリペア /(n) under repair/
アンダカット /(n) undercut/
アンダフロー /(n) (comp) underflow/
アンダフロー表示 [アンダフローひょうじ] /(n) (comp) underflow indication/
アンダンスー /(n) fried mixture of minced pork, miso, mirin, etc. (Okinawan dish)/
アンダンテ /(n) andante (music) (ita:)/
アンダンティーノ /(n) andantino (ita:)/
アンダンテカンタービレ /(n,adj-no) andante cantabile (ita:)/
アンチ /(n) anti-/disliked/(P)/
アンチーク /(n,adj-na) antique (fre:)/
アンチークファッション /(n) antique fashion/
アンチアメリカ /(adj-no) anti-American/
アンチウィルス /(n,adj-no) (comp) anti-virus (e.g. software)/
アンチウィルスソフト /(n) (comp) anti-virus software/
アンチウイルス /(n,adj-no) (comp) anti-virus (e.g. software)/
アンチウイルスソフト /(n) (comp) anti-virus software/
アンチエージング /(n) anti-aging/
アンチエイジング /(n) anti-aging/
アンチエイリアシング /(n) (comp) anti-aliasing/
アンチエイリアス /(n) (comp) anti-aliasing/
アンチエスタブリッシュメント /(n) anti-establishment/
アンチクライマックス /(n) anticlimax/
アンチグラム /(n) antigram/
アンチコドン /(n) anticodon/
アンチコピー技術 [アンチコピーぎじゅつ] /(n) (comp) anti-copying technology (software)/
アンチスキッド /(adj-no) antiskid/
アンチセミティズム /(n) (obsc) anti-Semitism/
アンチダイブ /(adj-no) anti-dive/
アンチック /(n,adj-na) antique (fre:)/
アンチック体 [アンチックたい] /(n) antique/
アンチテーゼ /(n) antithesis (ger: Antithese)/
アンチテアトル /(n) anti-theatre (theater) (fre: anti-theatre)/
アンチドート /(n) antidote/
アンチノック /(n) antiknock/
アンチノック剤 [アンチノックざい] /(n) antiknock agent/
アンチノック性 [アンチノックせい] /(n,adj-no) anti-knocking/
アンチノミー /(n) antinomy (ger: Antinomie)/
アンチハッキング /(n) (comp) anti-hacking/
アンチヒーロー /(n) antihero/
アンチヒューマニズム /(n) anti-humanism/
アンチピリン /(n) antipyrine/
アンチフェブリン /(n) antifebrin/
アンチフェミニズム /(n) antifeminism/
アンチフリーズ /(n) antifreeze/
アンチマグネチック /(n) antimagnetic/
アンチモニー /(n,adj-no) antimony (Sb) (ger: Antimon)/
アンチモン /(n,adj-no) antimony (Sb) (ger: Antimon)/
アンチョビ /(n) anchovy/
アンチョビー /(n) anchovy/
アンチロックブレーキシステム /(n) anti-lock brake system/
アンチロマン /(n) anti-roman (fre:)/
アンツーカ /(n) en-tout-cas (track or tennis court surface made of clay and crushed brick) (fre:)/
アンツーカー /(n) en-tout-cas (track or tennis court surface made of clay and crushed brick) (fre:)/
アンティーク /(n,adj-na) antique (fre:)/(P)/
アンティークファッション /(n) antique fashion/
アンティグア /(n) Antigua/
アンティック /(n,adj-na) antique (fre:)/
アンティパスト /(n) antipasto (ita:)/
アンテドラッグ /(n) antedrug/
アンテナ /(n) (1) antenna/(2) person who collects information or opinions/(P)/
アンテナショップ /(n) (1) shop used for testing sales of new products (wasei: antenna shop)/showroom/(2) shop selling local specialities to Tokyo/
アンテナ利得率 [アンテナりとくりつ] /(n) (comp) antenna gain factor/
アンテロープ /(n) antelope/
アンディーブ /(n) (1) (uk) endive (fre:)/(2) chicory/
アンデッド /(n) undead/
アンデパンダン /(n) independents (in the context of art) (fre:)/
アンデリート /(n) (comp) Undelete/
アントシアニン /(n) anthocyanin/
アントシアン /(n) anthocyan/
アントニム /(n) antonym/
アントラキノン /(n) anthraquinone/
アントラキノン染料 [アントラキノンせんりょう] /(n) anthraquinone dye/
アントラセン /(n) anthracene/
アントルプルヌール /(n) entrepreneur/
アントルメ /(n) entremets (fre:)/
アントレ /(n) (1) entree (fre:)/(2) (abbr) entrepreneurship/
アントレー /(n) (1) entree (fre:)/
アントレプレナー /(n) entrepreneur/
アントロポロギー /(n) (obsc) anthropology (ger: Anthropologie)/
アントン症候群 [アントンしょうこうぐん] /(n) Anton's syndrome/
アンド /(n) ampersand sign/and/(P)/
アンドゥ /(n) undo/
アンドウトラワ /(exp) un, deux, trois (fre:)/
アンドラ /(n) Andorra/
アンドロイド /(n) android/(P)/
アンドロゲン /(n) androgen (ger:)/
アンドロステロン /(n) androsterone/
アンドロメダ /(n) Andromeda/
アンドロメダ銀河 [アンドロメダぎんが] /(n) Andromeda galaxy/
アンドロメダ座 [アンドロメダざ] /(n) (constellation) Andromeda/
アンド回路 [アンドかいろ] /(n) AND circuit/
アンナハチドリ /(n) (uk) Anna's woodpecker (Calypte anna)/
アンナンバード接続 [アンナンバードせつぞく] /(n) (comp) unnumbered connection/
アンナ蜂鳥 [アンナはちどり] /(n) (uk) Anna's woodpecker (Calypte anna)/
アンニュイ /(n,adj-na) boredom (fre: ennui)/listlessness/languor/
アンノーン /(adj-no,adj-na,adj-f,n) unknown/
アンノウン /(adj-no,adj-na,adj-f,n) unknown/
アンハッピー /(n) unhappy/
アンバー /(n,adj-no) amber/umber/
アンバーグリス /(n) ambergris/
アンバサダー /(n) ambassador/
アンバランス /(adj-na) (1) unbalanced/imbalance/(n) (2) ambulance/(P)/
アンバンドリング /(n) unbundling/
アンバンドル /(vs) to unbundle/
アンパーサンド /(n) (comp) ampersand (&)/
アンパーザー /(n) unparser/
アンパイア /(n) umpire/
アンパイヤ /(n) umpire/
アンパサンド /(n) (comp) ampersand/
アンパック /(n,vs) (comp) unpack/
アンパック１０進表記法 [アンパックじっしんひょうきほう] /(n) (comp) unpacked decimal notation/
アンパック十進表記法 [アンパックじっしんひょうきほう] /(n) (comp) unpacked decimal notation/
アンパン /(n) (1) bread roll filled with anko/(2) paint thinner placed inside a bag used as a drug/
アンヒューマ /(n) amphiuma/
アンビアンス /(n) ambiance/ambience/
アンビエント /(n) (comp) ambient/
アンビエント光 [アンビエントこう] /(n) (comp) ambient light/
アンビギュイティ /(n) ambiguity/
アンビシャス /(adj-no,adj-na) ambitious/
アンビション /(n) ambition/
アンビバレンス /(n,adj-no) ambivalence/
アンビリ /(adj-f) (abbr) unbelievable/
アンビリーバボー /(adj-f) unbelievable/
アンビル /(n) anvil/
アンビヴァレンス /(n,adj-no) ambivalence/
アンピシリン /(n) ampicillin/
アンファンテリブル /(n) enfants terribles (fre:)/
アンフィカエトドン属 [アンフィカエトドンぞく] /(n) Amphichaetodon (genus of butterflyfishes in the family Chaetodontidae)/
アンフィプロステュロス /(adj-no) amphiprostyle/
アンフェア /(adj-na) unfair/(P)/
アンフェタミン /(n) amphetamine/
アンフェノール /(n) (comp) Amphenol/
アンフォーマット /(n) (comp) unformat/
アンフォラ /(n) amphora/
アンフォロー /(n,vs) (comp) unfollow/
アンブシュール /(n) embouchure (the position and use of the lips, tongue, and teeth in playing a wind instrument) (fre:)/mouthpiece of a musical instrument/
アンブシュア /(n) embouchure (the position and use of the lips, tongue, and teeth in playing a wind instrument) (fre:)/mouthpiece of a musical instrument/
アンブッシュ /(n) ambush/
アンブレイカブル /(adj-f) unbreakable/
アンブレラ /(n) umbrella/
アンブレラカット /(n) umbrella cut/
アンプ /(n) (1) amp/ampere/(2) (abbr) amplifier/(P)/
アンプス /(n) (comp) AMPS/
アンプラグド /(exp) unplugged/not needing or having electrification (e.g. music)/
アンプリファイア /(n) amplifier/
アンプリファイアー /(n) amplifier/
アンプル /(n) ampoule (fre:)/
アンプレーアブル /(n,adj-no) unplayable/
アンプレアブル /(n,adj-no) unplayable/
アンプレイアブル /(n,adj-no) unplayable/
アンプレショニスム /(n) Impressionism/
アンプレヤブル /(n,adj-no) unplayable/
アンプロンプチュ /(n) impromptu (fre:)/
アンペールの法則 [アンペールのほうそく] /(n) Ampere's law/
アンペア /(n) ampere/
アンペア時 [アンペアじ] /(n) ampere hour/
アンペラ /(n) (1) Machaerina rubiginosa (species of tropical sedge) (may: ampela)/(2) woven mat made of Machaerina rubiginosa root/
アンペライ /(n) (uk) Machaerina rubiginosa (species of tropical sedge)/
アンペラ藺 [アンペラい] /(n) (uk) Machaerina rubiginosa (species of tropical sedge)/
アンホテリシン /(n) amphotericin/
アンボンスズメダイ /(n) Ambon chromis (Chromis amboinensis)/
アンポピュラー /(n) unpopular/
アンマウント /(n) (comp) unmount (e.g. a drive)/
アンマッチ /(n) discrepancy (wasei: unmatch)/
アンマネージコード /(n) (comp) unmanaged code/
アンマネージド /(adj-no) (comp) unmanaged/
アンメーター /(n) ammeter/
アンモナイト /(n) ammonite/
アンモニア /(n,adj-no) ammonia/(P)/
アンモニアソーダ法 [アンモニアソーダほう] /(n) ammonia soda process/
アンモニア水 [アンモニアすい] /(n) ammonia water/aqueous ammonia/
アンモニウム /(n) ammonium/
アンモラル /(adj-na) unmoral/
アンラッキー /(adj-na) unlucky/
アンローダー /(n) unloader/
アンロード /(n) (comp) unload/
アンロック /(n) unlock/
アンヴィル /(n) anvil/
アヴァター /(n) (1) avatar/incarnation of an immortal being (Hindu)/(2) (comp) icon or representation of a user in a shared virtual reality/
アヴァンギャルド /(n) avant-garde (fre:)/
アヴァンチュール /(n) adventure (fre: aventure)/
アヴィーナサティヴァ /(n) avena sativa/
アヴェマリア /(exp) Ave Maria (prayer) (lat:)/Hail Mary/
ア式蹴球 [アしきしゅうきゅう] /(n) association football/soccer/
ィ形容詞 [イけいようし] /(n) adjective ending in "i"/i-adjective/
イ /(n) (uk) soft rush (Juncus effusus var. decipiens)/
イ /(n) 1st in a sequence denoted by the iroha system/1st note in the diatonic scale (used in key names, etc.)/
イーアールピー /(n) (comp) ERP/
イーアイエー /(n) (comp) EIA/
イーアイサ /(n) (comp) EISA/
イーアイディーイー /(n) (comp) EIDE/
イーイーカメラ /(n) electric-eye camera/
イーイーピーロム /(n) (comp) EEPROM/
イーエスシーピー /(n) (comp) ESC-P/
イーエムエス /(n) (comp) EMS/
イーエムエムサンハチロク /(n) (comp) EMM386/
イーエムシー /(n) (comp) EMC/
イーエムビー /(n) (comp) EMB/
イーエルエーピー /(n) (comp) ELAP/
イーオーエス /(n) (comp) EOS/
イーオーエフ /(n) (comp) EOF/
イーオン /(n) eon/very long period of time/
イーグル /(n) eagle (bird of prey, Accipitridae family)/(P)/
イーコム /(n) (comp) ECOM/
イーサ /(n) ether/
イーサーボード /(n) ether(net) board/
イーサトーク /(n) (comp) EtherTalk/
イーサネット /(n) (comp) Ethernet/
イーサネットアドレス /(n) (comp) Ethernet address/
イーシー /(n) European Community/EC/
イーシーエム /(n) (comp) ECM/
イージー /(adj-na,n) easy/(P)/
イージーウェブ /(n) (comp) Ezweb/
イージーエー /(n) (comp) EGA/
イージーオーダー /(n) easy order/
イージーケア /(n) easy care/
イージーゴーイング /(n) easy-going/
イージースカジー /(n) (comp) EZ-SCSI/
イージーパンツ /(n) loose-fitting pants with an elastic or drawcord waist (wasei: easy pants)/
イージーフライ /(n) routine fly ball (baseball) (wasei: easy fly)/
イージーペイメント /(n) easy payment (system)/
イージーミス /(n) silly mistake (was easy miss)/
イージーリスニング /(n) (abbr) easy listening music/
イージーリスニングミュージック /(n) easy listening music/
イージス /(n) (1) aegis (mythical shield)/(2) Aegis (system)/Aegis (missile guidance system)/
イージスシステム /(n) Aegis system/
イージス艦 [イージスかん] /(n) Aegis ship/
イージャーナル /(n) (comp) e-journal/
イースイート /(n) (comp) eSuite/
イースター /(n) Easter/(P)/
イースターアイランドバタフライフィッシュ /(n) Easter Island butterflyfish (Chaetodon litus)/white-tip butterflyfish/
イースターエッグ /(n) easter egg/
イースターバニー /(n) Easter bunny/
イースター島 [イースターとう] /(n) Easter Island/
イースタエッグ /(n) (comp) Easter egging/
イースタン /(n) eastern/
イースタングリップ /(n) eastern grip (in tennis)/
イースタンリーグ /(n) Eastern League/
イースト /(n) (1) east/(2) yeast/(P)/
イーストアトランティックアフリカンスペードフィッシュ /(n) East Atlantic African spadefish (Ephippus goreensis, species of Eastern Atlantic spadefish)/
イーストエンド /(n) East End/
イーストコースト /(n) East Coast/
イーストサイド /(n) East Side/
イーストパシフィックバタフライフィッシュ /(n) threebanded butterflyfish (Chaetodon humeralis)/
イースト菌 [イーストきん] /(n) yeast cell/
イーズィン /(n) (comp) e-zine/
イーゼル /(n) easel/
イーダブリューエス /(n) (comp) EWS/
イーチャン /(n) a game of mahjong (chi:)/
イーティーエックス /(n) (comp) ETX/
イーテキスト /(n) (comp) e-text/
イーディーアイ /(n) (comp) EDI/
イーディーアイファクト /(n) (comp) EDIFACT/
イーディーエス /(n) (comp) EDS/
イーディーオーラム /(n) (comp) EDO RAM/
イーディーユー /(n) (comp) edu/
イートイン /(n) eat in (as in at a fast food restaurant)/
イートンカラー /(n) Eton collar/
イード /(n) Eid (Muslim festival) (ara:)/Id/
イードアルアドハー /(n) Eid ul-Adha (ara:)/Id ul-Adha/
イードアルフィトル /(n) Eid ul-Fitr (ara:)/Id ul-Fitr/
イービジネス /(n) (comp) e-business/
イービル /(n) evil/
イーピーウィング /(n) (comp) EPWING/
イーピーロム /(n) (comp) EPROM/
イーブル /(n) evil/
イーブン /(n) even/
イーブンパー /(n) even par/
イーブンペース /(n) even pace/
イーベイ /(n) (comp) eBay/
イーホームズ /(n) eHomes (Japanese construction certification company)/
イーマシーンズ /(n) (comp) eMachines/
イーマックス /(n) (comp) Emacs/
イーメールカード /(n) (comp) e-mail card/
イーメイル /(n) (comp) e-mail/
イーモール /(n) (comp) EMALL/
イーユーシー /(n) (comp) EUC/
イーユーシージス /(n) (comp) eucjis/
イールド /(n) yield/
イールドカーブ /(n) yield curve/
イールドスプレッド /(n) yield spread/
イーワールド /(n) (comp) eWorld/
イア /(n) (1) ear/
イアースポットエンジェルフィッシュ /(n) goldtail angelfish (Pomacanthus chrysurus)/earspot angelfish/
イアピアス /(n,vs) ear piercing/
イアブック /(n) yearbook/
イアリング /(n) ear-ring/
イイ /(n) (abbr) Iran-Iraq/
イイズナ /(n) (uk) least weasel (Mustela nivalis)/
イイダコ /(n) (uk) ocellated octopus (Octopus ocellatus)/
イイヅナ /(n) (uk) least weasel (Mustela nivalis)/
イェス /(int) yes/
イェティー /(n) yeti/abominable snowman/
イェテボリ /(n) Goteborg/Gothenburg/
イェロー /(adj-na,n) yellow/
イェロウ /(adj-na,n) yellow/
イェンウオ /(n) (uk) swift's nest (used to make bird's nest soup)/
イェンツーユイ /(n) (uk) Chinese high fin banded shark (Myxocyprinus asiaticus) (chi: yanzhiyu)/Chinese sucker/
イエコウモリ /(n) (uk) Japanese house bat (Pipistrellus abramus)/
イエシロアリ /(n) (uk) Formosan subterranean termite (Coptotermes formosanus)/
イエス /(n) (1) Jesus (lat:)/(int,n) (2) yes/(P)/
イエスかノーか /(exp) yes or no/yes-no/all or nothing/
イエスキリスト /(n) Jesus Christ/
イエスタデー /(n) yesterday/
イエスマン /(n) yes-man/
イエズス /(n) (1) Jesus (lat:)/
イエズス会 [イエズスかい] /(n) Society of Jesus/Jesuits/
イエズス会士 [イエズスかいし] /(n) Jesuit/
イエッサー /(exp) (col) Yessir!/
イエティ /(n) yeti/abominable snowman/
イエネコ /(n) domesticated cat/
イエバエ /(n) (uk) housefly (Musca domestica)/house fly/
イエメンオオトカゲ /(n) Yemen monitor (Varanus yemenensis, species of carnivorous monitor lizard found at the base of the Tihama mountains along the western coast of Yemen)/
イエロー /(adj-na,n) yellow/(P)/
イエロー・タン /(n) yellow tang (Zebrasoma flavescens, species of Pacific tang)/
イエローアクシルクロミス /(n) yellow-axil chromis (Chromis xanthochira)/
イエローイアーエンジェルフィッシュ /(n) yellow-ear angelfish (Apolemichthys xanthotis)/Red Sea angelfish/
イエローオーカ /(n) yellow ochre/
イエローオーカー /(n) yellow ochre/
イエローカード /(n) yellow card (e.g. in soccer)/
イエローキャブ /(n) (1) yellow cab/(2) term referring to an ethnic stereotype of Japanese women, and by extension other Asians, suggesting that they are sexually available to foreign men/
イエロークラウンドバタフライフィッシュ /(n) yellow-crowned butterflyfish (Chaetodon flavocoronatus)/
イエローケーキ /(n) yellowcake/
イエローケーブル /(n) (comp) yellow cable/
イエロージャーナリズム /(n) yellow journalism/
イエローストライプコリス /(n) yellowstripe coris (Coris flavovittata)/
イエロースペックルドクロミス /(n) yellow-speckled chromis (Chromis alpha)/
イエロースポテットソウテール /(n) yellowspotted sawtail (Prionurus maculatus, species of Southwest Pacific tang)/
イエローゾーン /(n) yellow zone/
イエロータン /(n) yellow tang (Zebrasoma flavescens, species of Pacific tang)/
イエローテール・タン /(n) yellowtail tang (Zebrasoma xanthurum, species of Western Indian tang)/purple tang/yellowtail surgeonfish/
イエローテールエンジェルフィッシュ /(n) yellowtail angelfish (Apolemichthys xanthurus)/Indian yellowtail angelfish/
イエローテールサージャンフィッシュ /(n) yellowtail surgeonfish (Prionurus punctatus, species of Eastern Central Pacific tang found in reefs from the Gulf of California to El Salvador)/
イエローテールサージョンフィッシュ /(n) yellowtail surgeonfish (Prionurus punctatus, species of Eastern Central Pacific tang found in reefs from the Gulf of California to El Salvador)/
イエローテールスターリー・ラビットフィッシュ /(n) brown-spotted spinefoot (Siganus stellatus, species of rabbitfish from the Indian Ocean)/starspotted spinefoot/tellate rabbitfish/
イエローテールスターリーラビットフィッシュ /(n) brown-spotted spinefoot (Siganus stellatus, species of rabbitfish from the Indian Ocean)/starspotted spinefoot/tellate rabbitfish/
イエローテールタン /(n) yellowtail tang (Zebrasoma xanthurum, species of Western Indian tang)/purple tang/yellowtail surgeonfish/
イエローティアドロップバタフライフィッシュ /(n) yellow teardrop butterflyfish (Chaetodon interruptus)/
イエローティップダムゼルフィッシュ /(n) yellowtip damselfish (Stegastes pictus)/
イエローテイルリーフフィッシュ /(n) yellowtail reeffish (Chromis enchrysura)/Caribbean chromis/
イエローフィンクロミス /(n) yellowfin chromis (Chromis xanthopterygia)/Arabian chromis/
イエローフィンサージャンフィッシュ /(n) yellowfin surgeonfish (Acanthurus xanthopterus, Indo-Pacific species of tang)/
イエローフィンサージョンフィッシュ /(n) yellowfin surgeonfish (Acanthurus xanthopterus, Indo-Pacific species of tang)/
イエローフラッグ /(n) yellow flag/
イエローブック /(n) Yellow Book/
イエロープレス /(n) yellow press/
イエローヘッドバタフライフィッシュ /(n) yellowhead butterflyfish (Chaetodon xanthocephalus)/
イエローヘッドモニター /(n) yellow-head monitor (Varanus melinus, species of carnivorous monitor lizard native to Indonesia)/quince monitor/
イエローページ /(n) Yellow Pages/
イエローペーパー /(n) yellow paper/
イエローペリル /(n) yellow peril/
イエローヤンキー /(n) yellow Yankee/
イオ /(n) Io (moon of Jupiter)/
イオナイザー /(n) ionizer/
イオニア旋法 [イオニアせんぽう] /(n) Ionian mode/
イオニウム /(n) Ionium/
イオマンテ /(n) Ainu bear festival (ain:)/
イオン /(n,adj-no) ion/electrically-charged atom/(P)/
イオンエンジン /(n) ion engine/
イオンチャンネル /(n) ion channel/
イオンデポジションプリンタ /(n) (comp) ion-deposition printer/
イオンビーム /(n) ion beam/
イオンポンプ /(n) ion pump/
イオンロケット /(n) ion rocket/
イオン化 [イオンか] /(n,vs) ionization/ionisation/
イオン化エネルギー [イオンかエネルギー] /(n) energy of ionization/energy of ionisation/
イオン化傾向 [イオンかけいこう] /(n) ionization tendency/ionisation tendency/
イオン価 [イオンか] /(n) electrovalence/
イオン強度 [イオンきょうど] /(n) ionic strength/
イオン結合 [イオンけつごう] /(n) ionic bond/
イオン結晶 [イオンけっしょう] /(n) ionic crystal/
イオン顕微鏡 [イオンけんびきょう] /(n) ion microscope/
イオン交換 [イオンこうかん] /(n) ion exchange/
イオン交換樹脂 [イオンこうかんじゅし] /(n) ion exchange resin/
イオン交換水 [イオンこうかんすい] /(n) deionized water/DI water/
イオン性 [イオンせい] /(n) (1) ionicity/(adj-f) (2) ionic/
イオン注入 [イオンちゅうにゅう] /(n) ion implantation/
イオン半径 [イオンはんけい] /(n) ionic radius/
イオン反応 [イオンはんのう] /(n) ionic reaction/
イカ /(n) (uk) cuttlefish/squid/
イカの甲 [イカのこう] /(n) cuttlebone/
イカの舟 [イカのふね] /(n) cuttlebone/
イカの墨 [イカのすみ] /(n) squid's ink/
イカゲソ /(n) squid tentacles/
イカチー /(adj-f) (sl) grim/stern/
イカナゴ /(n) (uk) Japanese sand lance (Ammodytes personatus)/Pacific sandeel/
イカリソウ /(n) (uk) horny goat weed (Epimedium grandiflorum var. thunbergianum)/
イカル /(n) (uk) Japanese grosbeak (Eophona personata)/
イカ下足 [イカげそ] /(n) squid tentacles/
イカ墨 [イカすみ] /(n) squid ink/
イガ /(n) (uk) Tinea translucens (species of clothes moth)/
イガイ /(n) (uk) Korean mussel (Mytilus coruscus)/
イガイガ /(n) (1) crying of a baby/(2) tickle in the throat/
イキ /(n) (1) living/being alive/(2) freshness/liveliness/vitality/(3) situation in which a group of stones cannot be captured because it contains contains two or more gaps (in go)/(4) (uk) stet/(pref) (5) damned/
イキがいい /(n) fresh (fish)/
イキシア /(n) ixia (lat:)/
イギリスオランダ戦争 [イギリスオランダせんそう] /(n) (obsc) Anglo-Dutch Wars (1652-1654, 1665-1667, 1672-1674)/
イギリスビルマ戦争 [イギリスビルマせんそう] /(n) Anglo-Burmese Wars (1823-1826, 1852-1853, 1885-1887)/
イギリス英語 [イギリスえいご] /(n) British English (i.e. English as spoken in the UK)/
イギリス海峡 [イギリスかいきょう] /(n) English Channel/
イギリス経験論 [イギリスけいけんろん] /(n) British empiricism/
イギリス諸島 [イギリスしょとう] /(n) British Isles/
イギリス人 [イギリスじん] /(n) Englishman/Englishwoman/
イギリス製 [イギリスせい] /(n,adj-no) British made/made in Britain/
イギリス帝国 [イギリスていこく] /(n) British Empire/
イギリス東インド会社 [イギリスひがしインドがいしゃ] /(n) British East India Company/
イギリス文学 [イギリスぶんがく] /(n) English literature/
イギリス放送協会 [イギリスほうそうきょうかい] /(n) British Broadcasting Corporation/BBC/
イギリス領ギアナ [イギリスりょうギアナ] /(n) British Guiana/
イギリス領ホンデュラス [イギリスりょうホンデュラス] /(n) British Honduras/
イギリス領ボルネオ [イギリスりょうボルネオ] /(n) British Borneo/
イギリス領ヴァージン諸島 [イギリスりょうヴァージンしょとう] /(n) (p) British Virgin Islands/
イギリス連邦 [イギリスれんぽう] /(n) Commonwealth of Nations (formerly British Commonwealth)/
イクイップメント /(n) equipment/
イクサイトメント /(n) excitement/
イクスキジットバタフライフィッシュ /(n) blacktail butterflyfish (Chaetodon austriacus)/exquisite butterflyfish/
イクスクイジット・ピグミー・ゴビー /(n) exquisite pygmy goby (Trimma preclarum)/
イクスクイジットピグミーゴビー /(n) exquisite pygmy goby (Trimma preclarum)/
イクチオサウルス /(n) ichthyosaurus (lat:)/ichthyosaur/
イクチオルニス /(n) ichthyornis (extinct Cretaceous-period seabird)/
イクラ /(n) salted salmon roe (i.e. individual mature eggs) (rus: ikra)/(P)/
イグアナ /(n) iguana/
イグアノドン /(n) iguanodon (lat:)/
イグサ /(n) (uk) soft rush (Juncus effusus var. decipiens)/
イグサ科 [イグサか] /(n) Juncaceae (the rush family)/
イグニッション /(n) ignition/
イグニッションキー /(n) ignition key/
イグニッションコイル /(n) ignition coil/
イグニンブライト /(n) ignimbrite/
イグルー /(n) igloo/
イケてる /(adj-f) cool/with-it/turn-on/sexy/
イケア /(n) Ikea (housewares store)/
イケメン /(n) cool guy/good-looking, energetic man/hunk/
イケ面 [イケめん] /(n) cool guy/good-looking, energetic man/hunk/
イコール /(adj-na) (1) equal/(2) (math) the equality sign (=)/(exp) (3) (col) equals (A equals B)/(P)/
イコールオポチューニティー /(n) equal opportunity/
イコールパートナー /(n) equal partner/
イコールフッティング /(n) equal footing/
イコール機能 [イコールきのう] /(n) (comp) equals function/
イコクエイラクブカ /(n) tope shark (Galeorhinus galeus)/soupfin shark/
イコクエイラクブカ属 [イコクエイラクブカぞく] /(n) Galeorhinus (genus whose only member is the school shark, Galeorhinus galeus, in the family Triakidae)/
イコノクラスム /(n) iconoclasme (fre:)/
イコノグラフィー /(n) iconography/
イコノロジー /(n) iconology/
イコライザ /(n) equalizer/equaliser/
イコライザー /(n) equalizer/equaliser/
イコン /(n) icon (religious)/
イサイズドットコム /(n) (comp) ISIZE.COM/
イサキ /(n) (uk) chicken grunt (species of fish, Parapristipoma trilineatum)/threeline grunt/
イサギ /(n) (uk) chicken grunt (species of fish, Parapristipoma trilineatum)/threeline grunt/
イサザ /(n) (1) isaza goby (Gymnogobius isaza)/(2) ice goby (Leucopsarion petersii)/(3) Neomysis intermedia/
イサザアミ /(n) (1) Neomysis awatschensis (shrimp)/(2) (obs) Neomysis intermedia (shrimp)/
イザヤ書 [イザヤしょ] /(n) Isaiah (book of the Bible)/
イザリウオ /(n) (uk) (sens) frogfish (any fish of family Antennariidae, esp. the striated frogfish, Antennarius striatus)/
イシイルカ /(n) (uk) Dall's porpoise (Phocoenoides dalli)/
イシガイ /(n) (uk) Unio douglasiae (species of freshwater mussel)/
イシガキダイ /(n) (uk) rock porgy (Oplegnathus punctatus)/spotted knifejaw/
イシガメ /(n) var. of turtle (Clemmys japonica)/
イシガレイ /(n) stone flounder (Kareius bicoloratus)/
イシダタミガイ /(n) (uk) toothed top shell (Monodonta labio)/
イシチドリ /(n) (uk) stone curlew/thick-knee (Burhinus oedicnemus)/
イシドジョウ /(n) (uk) Cobitis takatsuensis (species of loach)/
イシナギ /(n) (uk) striped jewfish (Stereolepis doederleini)/
イシフエダイ /(n) (uk) small-toothed jobfish (Aphareus furca)/
イシムカデ /(n) (uk) stone centipede (Lithobiomorpha spp.)/
イシモチ /(n) (uk) white croaker/blue drum (Pennahia argentata)/
イジェクト /(n,vs) (comp) eject/
イジェクトボタン /(n) (comp) ejector button/
イジュ /(n) (uk) (rkb:) Chinese guger tree (species of evergreen, Schima wallichii)/
イジュティハード /(n) ijtihad (use of discretionary judgement in deducing a law not specified in scripture) (ara:)/
イスカ /(n) (uk) common crossbill (Loxia curvirostra)/
イスズミ /(n) (uk) brassy chub (Kyphosus vaigiensis)/
イスタブリッシュメント /(n) (comp) establishment/
イスタンブール /(n) Istanbul/(P)/
イスタンブル /(n) Istanbul/
イスラーム /(n,adj-no) Islam/
イスラエル /(n,adj-no) Israel/(P)/
イスラエルロビー /(n) Israel lobby/
イスラム /(n,adj-no) Islam/(P)/
イスラム過激主義 [イスラムかげきしゅぎ] /(n) Islamic extremism/
イスラム教 [イスラムきょう] /(n,adj-no) Islam/(P)/
イスラム教徒 [イスラムきょうと] /(n) Muslim/
イスラム原理主義 [イスラムげんりしゅぎ] /(n) Islamic fundamentalism/
イスラム諸国 [イスラムしょこく] /(n,adj-f) Islamic countries/Islamic world/
イスラム復興 [イスラムふっこう] /(n) Islamic revival/
イスラム文化 [イスラムぶんか] /(n) Islamic culture/
イスラム法 [イスラムほう] /(n) Islamic law (i.e. sharia)/
イスラム暦 [イスラムれき] /(n) Islamic calendar/
イスランド苔 [イスランドごけ] /(n) (obsc) Iceland moss (Cetraria islandica)/Iceland lichen/
イス取りゲーム [イスとりゲーム] /(n) musical chairs/
イズハナトラザメ /(n) Izu cat shark (Scyliorhinus tokubee, species found in Japan)/
イズバスチヤ /(ik) (n) Izvestia (Russian newspaper) (rus:)/
イズベスチヤ /(n) Izvestia (Russian newspaper) (rus:)/
イズム /(n) (1) ism/(suf) (2) -ism/(P)/
イセエビ /(n) (uk) spiny lobster (esp. Japanese spiny lobster, Panulirus japonicus)/
イセゴイ /(n) (1) (uk) striped mullet (Mugil cephalus)/(2) (uk) redlip mullet (Chelon haematocheilus)/(3) (uk) Indo-Pacific tarpon (Megalops cyprinoides)/
イセリアカイガラムシ /(n) (uk) cottony cushion scale (species of scale insect, Icerya purchasi)/
イセリア介殻虫 [イセリアかいがらむし] /(n) (uk) cottony cushion scale (species of scale insect, Icerya purchasi)/
イソ /(pref) (chem) iso-/
イソウロウグモ /(n) (uk) dewdrop spider (any spider of genus Argyrodes)/
イソオクタン /(n) isooctane/
イソガニ /(n) (uk) Asian shore crab (Hemigrapsus sanguineus)/
イソキノリン /(n) isoquinoline/
イソギンチャク /(n) (uk) sea anemone/
イソシアン酸 [イソシアンさん] /(n) isocyanic acid/
イソシアン酸塩 [イソシアンさんえん] /(n) isocyanate/
イソジン /(n) Isodine (iodine based disinfectant)/
イソスズメダイ /(n) yellowtail sergeant (Abudefduf notatus)/
イソップ童話 [イソップどうわ] /(n) Aesop's Fables/
イソップ物語 [イソップものがたり] /(n) Aesop's Fables/
イソニアジド /(n) isoniazid/
イソニコチン酸ヒドラジド [イソニコチンさんヒドラジド] /(n) isonicotinic acid hydrazide/
イソハゼ /(n) Eviota abax (species of pygmy goby ranging from Southern Japan to Hainan Is.)/
イソハゼ属 [イソハゼぞく] /(n) Eviota (genus of very small reef-associated Indo-Pacific gobies in the family Gobiidae)/pygmy gobies/
イソフラボン /(n) isoflavone/
イソブチレン /(n) isobutylene/
イソプレン /(n) isoprene/
イソプレンゴム /(n) isoprene rubber/
イソプロパノール /(n) isopropanol/
イソプロピルアルコール /(n) isopropyl alcohol/
イソマグロ /(n) (uk) dogtooth tuna (Gymnosarda unicolor)/
イソメ /(n) (uk) eunicid (any worm of family Eunicidae)/
イソメラーゼ /(n) isomerase/
イソロイシン /(n) isoleucine (ger: Isoleucin)/
イソ体 [イソたい] /(n) isomer/
イタめし /(n) (abbr) Italian food/
イタイイタイ病 [イタイイタイびょう] /(n) "ouch-ouch disease", caused by cadmium poisoning from industrial wastes in Toyama Prefecture/
イタカジ /(n) (abbr) Italian casual/
イタセンパラ /(n) deepbody bitterling (species of cyprinid, Acheilognathus longipinnis)/
イタチ /(n) (1) (uk) weasel (esp. the Japanese weasel, Mustela itatsi)/(2) mustelid (any other member of the weasel family, inc. badgers, martens, minks, ferrets, otters, polecats, stoats, skunks, etc.)/
イタチアナグマ /(n) (uk) ferret badger (esp. the Chinese ferret-badger, Melogale moschata)/
イタチウオ /(n) (uk) goatsbeard brotula (species of ophidiiform fish, Brotula multibarbata)/
イタチザメ /(n) (uk) tiger shark (Galeocerdo cuvier)/
イタチザメ属 [イタチザメぞく] /(n) Galeocerdo (genus in the family Carcharhinidae whose sole member is the tiger shark)/
イタチハギ /(n) (uk) false indigo (Amorpha fruticosa)/bastard indigo/leadwort/
イタチ科 [イタチか] /(n) Mustelidae/Mustelids/
イタドリ /(n) (uk) Japanese knotweed (Fallopia japonica)/Japanese fleeceflower/Mexican bamboo/Polygonum cuspidatum/Reynoutria japonica/
イタメ /(n) nuisance mail (such as chain mail, etc.)/
イタメール /(n) nuisance mail (such as chain mail, etc.)/
イタメル /(n) nuisance mail (such as chain mail, etc.)/
イタヤカエデ /(n) (uk) painted maple (Acer mono)/
イタヤガイ /(n) (uk) Japanese bay scallop (Pecten albicans)/
イタリー /(n,adj-no) (uk) Italy/
イタリア /(n,adj-no) (uk) Italy/(P)/
イタリアトルコ戦争 [イタリアトルコせんそう] /(n) Italo-Turkish War (1911-1912)/
イタリアルネッサンス /(n) the Italian renaissance/
イタリアン /(n,adj-na) Italian/
イタリアンカット /(n) Italian cut/
イタリアンコーヒー /(n) Italian coffee/
イタリア語 [イタリアご] /(n) Italian (language)/
イタリア人 [イタリアじん] /(n) Italian (person)/
イタリア製 [イタリアせい] /(n,adj-no) Italian made/made in Italy/
イタリア料理 [イタリアりょうり] /(n) Italian food/Italian cooking/
イタリック /(n) italic/
イタリック語派 [イタリックごは] /(n) Italic (branch of languages)/
イタリック体 [イタリックたい] /(n) (comp) Italic/
イタリヤ /(n,adj-no) (uk) Italy/
イタルタス通信 [イタルタスつうしん] /(n) ITAR-TASS News Agency/
イタ公 [イタこう] /(n) (col) Italian person/
イタ車 [イタし] /(n) (col) car painted with anime characters and loaded with figures and stuffed dolls (lit: 'painful car' because some people consider it painful to look at)/
イタ電 [イタでん] /(n) (abbr) prank call/nuisance call/
イタ飯 [イタはん] /(n) Italian food/Italian restaurant/
イチイ /(n) (1) (uk) Japanese yew (Taxus cuspidata)/
イチイ /(n) (uk) Quercus gilva (species of oak)/
イチイガシ /(n) (uk) Quercus gilva (species of oak)/
イチイ科 [イチイか] /(n) Taxaceae (plant family)/yew/
イチイ目 [イチイもく] /(n) (obs) Taxales (order of plants)/
イチゴ /(n) strawberry (esp. the garden strawberry, Fragaria x ananassa)/
イチジク /(n) fig/
イチヂク /(ik) (n) fig/
イチボ /(n) (abbr) aitchbone/
イチマルイチキーボード /(n) (comp) 101 Keyboard/
イチマルロクキーボード /(n) (comp) 106 Keyboard/
イチモンジハゼ /(n) Trimma grammistes (species of small goby found in Japan and Taiwan)/
イチョウ /(n) (uk) ginkgo (Ginkgo biloba)/gingko/maidenhair tree/
イチョウ科 [イチョウか] /(n) Ginkgoaceae (plant family)/ginkgo/
イチョウ目 [イチョウもく] /(n) Ginkgoales (order of plants)/
イッカク /(n) (1) (uk) narwhal (Monodon monoceros)/
イッカク科 [イッカクか] /(n) Monodontidae/
イッキ飲み [イッキのみ] /(n,vs) chugging an entire drink without stopping to take a breath/
イッシー /(n) Isshi (lake monster said to be living in Kyushu's Lake Ikeda)/
イッチ /(n) itch/
イッテルビウム /(n) ytterbium (Yb)/
イッテンオオメイガ /(n) (uk) (obsc) yellow stem borer (species of moth, Scirpophaga incertulas)/
イッテンチョウチョウウオ /(n) teardrop butterflyfish (Chaetodon unimaculatus)/teardrop coralfish/one-spot butterfly/
イット /(n) it/(P)/
イットウダイ /(n) (uk) North Pacific squirrelfish (Sargocentron spinosissimum)/
イットリウム /(n) yttrium (Y)/
イッヒロマン /(n) first-person novel (ger: Ich-Roman)/
イッピー /(n) Yippie/
イデー /(n) idea (ger: Idee)/
イデア /(n) idea (in Platonic thought) (gre:)/
イデアル /(n,adj-no) (1) ideal/(2) (math) ideal in a ring (i.e. subset of a ring closed under addition and multiplication by elements of the ambient ring)/
イディオム /(n) idiom/
イディッシュ語 [イディッシュご] /(n) Yiddish/
イデオム /(n) idiom/
イデオローグ /(n) ideologue (fre:)/
イデオロギ /(n,adj-no) ideology (ger: Ideologie)/
イデオロギー /(n,adj-no) ideology (ger: Ideologie)/(P)/
イトヒキアカボウ /(n) Bodianus thoracotaeniatus (species of hogfish)/
イトヒキアジ /(n) (uk) African pompano (Alectis ciliaris)/
イトヒキイワシ /(n) (uk) attenuated spider fish (Bathypterois atricolor)/
イトヒキギンザメ /(n) Hydrolagus alberti (species of Atlantic cartilaginous shortnose chimaera fish)/
イトヒキハゼ /(n) (uk) Myersina filifer (species of goby)/
イトヒキフエダイ /(n) (uk) chinamanfish (Symphorus nematophorus)/
イトマキフグ /(n) (uk) basketfish (Kentrocapros aculeatus)/
イトマキボラ /(n) (uk) trapezium horse conch (Pleuroploca trapezium)/
イトヨ /(n) (uk) three-spined stickleback (Gasterosteus aculeatus)/
イトヨリダイ /(n) (uk) golden threadfin bream (Nemipterus virgatus)/besugo/
イド /(n) id/
イナゴマメ /(n) carob/locust bean/
イナズマヤッコ /(n) bluegirdled angelfish (Pomacanthus navarchus)/majestic angelfish/
イナズマヨコバイ /(n) (uk) zig-zag rice leafhopper (Recilia dorsalis)/
イナダ /(n) young Japanese amberjack/
イナバウアー /(n) Ina Bauer (figure skating technique first performed in 1957 by West German skater Ina Bauer)/(P)/
イニ /(n) (comp) .ini/
イニシアチブ /(n) initiative/
イニシアティブ /(n) initiative/
イニシアライズ /(n,vs) initialize/initialise/
イニシアル /(n) (1) initial/the first/(2) (one's) initials/
イニシエーション /(n) initiation/
イニシエータ /(n) initiator/
イニシエーター /(n) initiator/
イニシャライザルーチン /(n) (comp) initializer routine/
イニシャライズ /(n,vs) initialize/initialise/
イニシャル /(n) (1) initial/the first/(2) (one's) initials/
イニシャルコスト /(n) (comp) initial cost/
イニシャルプログラムロード /(n) (comp) initial program load/IPL/
イニット /(n) (comp) init/INIT/
イニング /(n) inning/(P)/
イヌイット /(n) Inuit/
イヌクグ /(n) (uk) Pacific island flatsedge (Cyperus cyperoides)/
イヌコウジュ /(n) (uk) Mosla punctulata (plant)/
イヌサフラン /(n) (uk) meadow saffron (Colchicum autumnale)/autumn crocus/naked lady/
イヌザメ /(n) brownbanded bambooshark (Chiloscyllium punctatum, species from the Indo-West Pacific)/
イヌシデ /(n) (uk) Chonowski's hornbeam (Carpinus tschonoskii)/
イヌツゲ /(n) (uk) Japanese holly (Ilex crenata)/
イヌハッカ /(n) (uk) catnip (Nepeta cataria)/catmint/
イヌビワ /(n) (uk) Ficus erecta (species of ficus)/
イヌブナ /(n) (uk) Japanese beech (Fagus japonica)/
イヌホシザメ /(n) dusky smooth-hound (Mustelus canis, species of hound shark found in the Western Atlantic)/
イヌマキ /(n) (uk) yew plum pine (Podocarpus macrophyllus)/
イヌリン /(n) inulin (ger:)/
イヌワシ /(n) (uk) golden eagle (Aquila chrysaetos)/
イヌ亜目 [イヌあもく] /(n) Caniformia/
イネーブラ /(n) (comp) enabler/
イネーブル /(n) (comp) enable/
イネーブル信号 [イネーブルしんごう] /(n) (comp) enable signal/
イネゾウムシ /(n) (uk) rice plant weevil (Echinocnemus squameus)/
イネネクイハムシ /(n) (uk) Donacia provostii (species of leaf beetle)/
イネミズゾウムシ /(n) (uk) rice water weevil (Lissorhoptrus oryzophilus)/
イネ科 [イネか] /(n) Poaceae (grass family of plants)/Gramineae/
イノシシ /(n) (uk) wild boar/
イノシトール /(n) inositol/
イノシン酸 [イノシンさん] /(n) inosinic acid/
イノセンス /(n) innocence/
イノセント /(adj-na) innocent/
イノベーション /(n) innovation/(P)/
イノベイション /(n) innovation/
イバラ /(n) (1) thorny shrub/(2) wild rose/briar/(3) thorn/(4) (architectural) cusp/
イヒチオール /(n) Ichthyol/ichthammol/
イフシェム /(n) (comp) IFSHEM/
イフリート /(n) efreet/
イブ /(n) eve (esp. Christmas Eve)/the night before/(P)/
イブキ /(n) (uk) Chinese juniper (Juniperus chinensis)/
イブキトラノオ /(n) (uk) common bistort (species of flowering plant, Polygonum bistorta)/
イブキビャクシン /(n) (uk) Chinese juniper (Juniperus chinensis)/
イブニング /(n) evening/(P)/
イブニングコート /(n) evening coat/
イブニングドレス /(n) evening dress/
イブプロフェン /(n) ibuprofen/
イベサー /(n) (abbr) special-event club/
イベント /(n) event/(P)/
イベントを生成する [イベントをせいせいする] /(exp,vs-i) (comp) to generate an event/to trigger an event/
イベントカテゴリ /(n) (comp) event category/
イベントキュー /(n) (comp) event queue/
イベントクラス /(n) (comp) event class/
イベントサークル /(n) special-event club (esp. at university) (wasei: event circle)/
イベントスケジューリング /(n) event-scheduling/
イベントドリブン /(n) (comp) event driven/
イベントドリブンプログラミング /(n) (comp) event-driven programming/
イベントハンドラ /(n) (comp) event handler/
イベントプロバイダ /(n) (comp) event provider/
イベントプロパティ /(n) (comp) event property/
イベントログ /(n) (comp) event log/event logging/
イベントログエントリー /(n) (comp) event log entry/
イベント駆動 [イベントくどう] /(n) (comp) event driven/
イベント駆動型 [イベントくどうがた] /(n) (comp) event driven/
イベント指定子 [イベントしていし] /(n) (comp) event descriptor/
イベント処理 [イベントしょり] /(n) (comp) event processing/
イベント報告 [イベントほうこく] /(n) (comp) event reporting/
イペリット /(n) mustard gas (fre: yperite)/
イボイノシシ /(n) (uk) warthog (Phacochoerus aethiopicus)/
イボガエル /(n) (col) toad with wart-covered skin (esp. the Japanese toad or the wrinkled frog)/
イボガンギエイ /(n) (uk) thornback ray (Raja clavata)/thornback skate/
イボタ /(n) (uk) Ligustrum japonicum/
イボダイ /(n) (uk) Japanese butterfish (Psenopsis anomala)/melon seed/
イボニシ /(n) (uk) Thais clavigera (species of rock shell)/
イマーゴ /(n) imago/
イマージェンシー /(n) emergency/
イマージュ /(n) image (fre: image)/
イマーム /(n) imam (ara:)/Imam/
イマイチ /(adj-na,adv) (1) (uk) (col) one more/another/the other/(2) not quite/not very good/lacking/
イマジズム /(n) imagism/
イマジニアリング /(n) imagineering/
イマジネーション /(n) imagination/
イマジネイション /(n) imagination/
イマジン /(vs) imagine/
イマメガシ /(n) (uk) (obsc) ubame oak (Quercus phillyraeoides)/
イマラチオ /(n) (vulg) (sl) irrumatio (fellatio wherein the majority of movement is performed by the felatee) (lat:)/
イミグレーション /(n) immigration/
イミダゾール /(n) imidazole/
イミテーション /(n) imitation/
イミテイション /(n) imitation/
イミディエイト /(adj-na) immediate/
イミド /(n) imide/
イミドール /(n) Imidol (Japanese brand of imipramine, the first tricyclic antidepressant)/
イミフ /(adj-na) (abbr) (sl) of uncertain meaning/ambiguous/
イミプラミン /(n) imipramine/
イメージ /(n,vs) (1) (one's) image/(2) (comp) (computer) image/(3) artist's impression/(P)/
イメージＤＶＤ [イメージディーブイディー] /(n) DVD containing a slideshow of still images (usually of women) (wasei: image DVD)/
イメージアップ /(n,vs) creating a better image (wasei: image up)/
イメージオルシコン /(n) image orthicon/
イメージカード /(n) (comp) image card/
イメージキャラクター /(n) image character/
イメージクラブ /(n) sex establishment in which staff dress in costumes (schoolgirl, nurse, etc.) (wasei: image club)/
イメージサーベイ /(n) image survey/
イメージサイズ /(n) (comp) image size/
イメージスキャナ /(n) (comp) image scanner/
イメージスキャナー /(n) (comp) image scanner/
イメージセッター /(n) (comp) imagesetter/
イメージダウン /(n,vs) ruining one's image (wasei: image down)/
イメージチェンジ /(n) image change/changing one's image/
イメージデータ /(n) (comp) image data/
イメージトレーニング /(n) image training/
イメージバッファ /(n) (comp) image buffer/
イメージビデオ /(n) video containing a slideshow of still images (usually of women) (wasei: image video)/
イメージファイル /(n) image file/
イメージプリンタ /(n) image printer/
イメージマップ /(n) (comp) imagemap/
イメージメーカー /(n) image maker/
イメージリサーチ /(n) image research/
イメージング /(n) (comp) imaging/
イメージ管 [イメージかん] /(n) image tube/
イメージ広告 [イメージこうこく] /(n) image advertising/
イメージ処理 [イメージしょり] /(n) (comp) image processing/
イメージ調査 [イメージちょうさ] /(n) image survey/
イメクラ /(n) (abbr) sex establishment in which staff dress in costumes (schoolgirl, nurse, etc.) (wasei: image club)/
イメジ /(n,vs) (1) (one's) image/(2) (comp) (computer) image/(3) artist's impression/
イメチェン /(n,vs) (abbr) image change (esp. for teen idols)/
イメレス /(n) (comp) (abbr) (sl) image response/
イモビライザー /(n) immobiliser (electronic device that prevents an automobile engine from running without the key)/immobilizer/
イモムシ /(n) hornworm (caterpillar of a hawk moth)/(hairless) caterpillar/
イモリ /(n) (uk) newt (esp. the Japanese fire belly newt, Cynops pyrrhogaster)/
イモリザメ /(n) salamander shark (Parmaturus pilosus, found in China and Japan)/
イモリザメ属 [イモリザメぞく] /(n) Parmaturus (genus containing 9 species of catshark in the family Scyliorhinidae)/
イヤ /(n) (1) ear/
イヤー /(n) (1) ear/(2) year/
イヤーブック /(n) yearbook/
イヤドロップ /(n) eardrop (earring with a pendant)/
イヤバルブ /(n) ear valve/
イヤフォン /(n) earphone/(P)/
イヤプロテクター /(n) ear protector/
イヤホーン /(n) earphone/
イヤホン /(n) earphone/(P)/
イヤマーク /(n) earmark/
イヤラウンドファッション /(n) year-round fashion/
イヤリング /(n) earring/(P)/
イヨカン /(n) (uk) iyokan (Citrus iyo)/type of citrus fruit/
イヨマンテ /(n) Ainu bear festival (ain:)/
イヨミズキ /(n) (uk) iyomizugi winter hazel (Corylopsis spicata)/
イラつく /(v5k,vi) (uk) to get irritated/
イライト /(n) illite/
イライラさせる /(exp,v1) to get beneath someone's skin/to in someone's hair/to irritate/
イラガ /(n) (uk) Monema flavescens (species of slug moth)/
イラク /(n,adj-no) Iraq/(P)/
イラクサ /(n) (uk) nettle (Urtica thunbergiana)/
イラクサ目 [イラクサもく] /(n) (obs) Urticales (order of plants)/
イラク軍 [イラクぐん] /(n) Iraq military/
イラク戦争 [イラクせんそう] /(n) Iraq War (2003-)/
イラショナル /(n) irrational/
イラジエーション /(n) irradiation/
イラステシティ /(n) elasticity/
イラスト /(n) (abbr) illustration/(P)/
イラストマップ /(n) illustrated map/
イラストラ /(n) (comp) Illustra/
イラストレーション /(n) illustration/
イラストレーター /(n) illustrator/(P)/
イラプション /(n) eruption/
イラマチオ /(n) (vulg) (sl) irrumatio (fellatio wherein the majority of movement is performed by the felatee) (lat:)/
イラン /(n) (uk) Iran/
イランイラク戦争 [イランイラクせんそう] /(n) Iran-Iraq War (1980-1988)/
イランイラン /(n) ylang-ylang (Cananga odorata)/ilang-ilang/
イランコントラ事件 [イランコントラじけん] /(n) Iran-Contra affair/Irangate/
イランド /(n) eland/
イラン革命 [イランかくめい] /(n) Iranian Revolution/
イラン語 [イランご] /(n) Iranian (any member language of the Iranian language branch, esp. Farsi)/
イラン語派 [イランごは] /(n) Iranian (branch of languages)/
イリーガル /(n) (comp) illegal/
イリエワニ /(n) (uk) saltwater crocodile (Crocodylus porosus)/estuarine crocodile/
イリガリティー /(n) illegality/
イリジウム /(n) iridium (Ir)/
イリジウム計画 [イリジウムけいかく] /(n) (comp) IRIDIUM project/
イリノイ /(n) Illinois/(P)/
イリュージョン /(n) illusion/(P)/
イリュミネイション /(n) illumination/
イリュリア語 [イリュリアご] /(n) Illyrian (language)/
イルージョン /(n) illusion/
イルカ /(n) (uk) dolphin (or other small toothed whales, such as porpoises, belugas, etc.)/
イルコン /(n) (abbr) illumination control/
イルドフランス /(n) Ile de France (region around Paris)/
イルミ /(n) (abbr) illumination/
イルミナティ /(n) Illuminati (Name of group)/
イルミネーション /(n) illumination/(P)/
イレーザー /(n) eraser/rubber/
イレーズ /(n) (comp) erase/
イレウス /(n) ileus/
イレギュラー /(adj-na) irregular/
イレギュラーバウンド /(n,vs) irregular bound (tennis)/bad bounce/bad hop/
イレクト /(n,vs) (1) elect/(2) erect/
イレズミエイラクブカ /(n) Hemitriakis complicofasciata (species of houndshark found in the Ryukyu Islands and Taiwan)/
イレズミコンニャクアジ /(n) (uk) ragfish (Icosteus aenigmaticus)/
イレズミニザ /(n) white-freckled surgeonfish (Acanthurus maculiceps, species of tang from the Indo-West Pacific)/spot-face surgeon/pale-lined surgeonfish/yellow-freckled surgeon fish/
イレデンティズム /(n) irredentism/
イレブる /(v5r) to go to a Seven-Eleven/
イレブン /(n) eleven/(P)/
イレブンナイン /(n) eleven nines/99.999999999 percent/
イレヴン /(n) eleven/
イロコイ /(n) Iroquois/
イロチ /(n,adj-no) (abbr) (sl) being of a different color/
イロチ買い [イロチがい] /(n,vs) (sl) buying the same item multiple times, each one being a different color (colour)/
イロニー /(n) irony (fre: ironie, ger: Ironie)/
イロハ /(n) (1) (uk) traditional ordering of the Japanese syllabary/(2) fundamentals/the ABCs of .../
イロハモミジ /(n) (uk) Japanese maple (Acer palmatum)/
イロハ順 [イロハじゅん] /(n) Traditional ordering of Japanese syllabary based on a Buddhist poem/
イワイソメ /(n) (uk) Marphysa sanguinea (species of eunicid worm)/
イワオモダカ /(n) (uk) Pyrrosia tricuspis (species of felt fern)/
イワガニ /(n) (uk) striped shore crab (Pachygrapsus crassipes)/
イワシクジラ /(n) (uk) sei whale (Balaenoptera borealis)/
イワシャコ /(n) (uk) chukar partridge (Alectoris chukar)/
イワダヌキ /(n) (uk) hyrax/
イワツバメ /(n) (uk) Asian house martin (species of songbird, Delichon dasypus)/
イワトビペンギン /(n) (uk) rockhopper penguin (Eudyptes chrysocome)/
イワナ属 [イワナぞく] /(n) Salvelinus (genus of salmonid fish of the family Salmonidae)/char or charr/
イワニガナ /(n) (uk) creeping lettuce (Ixeris stolonifera)/
イワネシボリ /(n) (uk) Camellia japonica 'Iwaneshibori' (cultivar of common camellia)/
イワヒバリ /(n) (uk) alpine accentor (Prunella collaris)/
イワヒメオオトカゲ /(n) Storr's pygmy monitor (Varanus storri, species of small carnivorous monitor lizard native to Australia)/Storr's goanna/Storr's monitor/
イワブクロ /(n) (uk) Penstemon frutescens (species of beardtongue)/
イワベンケイ /(n) (uk) roseroot (Rhodiola rosea)/
イワムシ /(n) (uk) Marphysa sanguinea (species of eunicid worm)/
イワレンゲ /(n) (uk) Chinese dunce cap (species of succulent plant, Orostachys iwarenge)/
イン /(n) (1) in/(2) inn/(P)/
インアクティブウィンドウ /(n) (comp) inactive window/IAW/
インカム /(n) income/
インカムゲイン /(n) income gain/
インカムタックス /(n) income tax/
インカレ /(adj-no,n) (abbr) intercollegiate/
インカ帝国 [インカていこく] /(n) Incan Empire/
インキ /(n,adj-no) ink (dut: inkt)/(P)/
インキー /(vs) shutting yourself out of your car with the key left inside (wasei: in key)/
インキーパー /(n) innkeeper/
インキュナブラ /(n) (comp) incunabulum/
インキュバス /(n) incubus/
インキュベーション /(n) incubation/
インキュベータ /(n) incubator/
インキュベーター /(n) incubator/
インキュベート /(n) incubate/
インキング /(n) (comp) inking/
インク /(n,adj-no) ink (dut: inkt)/(P)/
インクカートリッジ /(n) (comp) ink cartridge/
インクジェット /(n) ink jet/
インクジェットプリンタ /(n) (comp) ink-jet printer/
インクジェットプリンター /(n) (comp) ink-jet printer/
インクジェット印字装置 [インクジェットいんじそうち] /(n) (comp) ink jet printer/
インクジェット方式 [インクジェットほうしき] /(n) (comp) ink-jet method/
インクスタンド /(n) inkstand/
インクデスクトップ /(n) (comp) ink desktop/
インクトミ /(n) (comp) Inktomi/
インクブロットテスト /(n) inkblot test/
インクライン /(n) incline/
インクリビジネス /(n) (abbr) incremental business/
インクリボン /(n) (comp) inked ribbon/
インクリメンタリズム /(n) incrementalism/
インクリメンタル /(adj-na) incremental/
インクリメンタルサーチ /(n) (comp) incremental search/
インクリメンタルバックアップ /(n) (comp) incremental backup/
インクリメント /(n,vs) increment/
インクルード /(n) include/
インク消し [インクけし] /(n) ink eraser/
インク瓶 [インクびん] /(n) bottle of ink/
インク壺 [インクつぼ] /(n) inkwell/
イングランド /(n,adj-no) England/(P)/
イングランド銀行 [イングランドぎんこう] /(n) Bank of England/
イングリッシュ /(adj-f) (1) English/(n) (2) Engrish/
イングリッシュグリップ /(n) English grip (tennis)/
イングリッシュブルーベル /(n) (English) bluebell/
イングリッシュブレックファースト /(n) English breakfast/
イングリッシュホーン /(n) English horn (music)/cor anglais/
イングリッシュホルン /(n) English horn (music)/cor anglais/
イングリッシュマフィン /(n) English muffin/
イングレス /(n) (comp) Ingres/
インコ /(n) (uk) true parrot (esp. small parrots such as the parakeet, lory and conure)/
インコース /(n) (1) inside track (wasei: in course)/(2) inside pitch (baseball)/
インコーナー /(n) (abbr) inside corner/
インコンシステンシー /(n) inconsistency/
インゴール /(n) in-goal area (rugby)/
インゴット /(n) ingot/
インサーキットエミュレータ /(n) (comp) incircuit emulator/
インサーキットテスタ /(n) in-circuit tester/
インサーション /(n) insertion/
インサート /(n,vs) insert/
インサートモード /(n) (comp) insert mode/
インサート編集 [インサートへんしゅう] /(n) (comp) insert edit/
インサイダー /(n) insider/(P)/
インサイダー取引 [インサイダーとりひき] /(n) insider trading/
インサイト /(n) insight/
インサイド /(n) inside (e.g. of home plate)/
インサイドアウト /(n) inside out/swinging golf club with an inside out motion/
インサイドストーリー /(n) inside story/
インサイドベースボール /(n) inside baseball/
インサイドベルト /(n) inside belt/
インサイドレポート /(n) inside report/
インサイドワーク /(n) inside work/catcher's game/
インザホール /(n) in the hole/
インシデンス /(n) incidence/
インシデント /(n) incident/
インシネレタ /(n) incinerator/
インシネレター /(n) incinerator/
インシュージアスト /(n) enthusiast/
インシュート /(n) inshoot/
インシュアランス /(n) insurance/
インシュラリティー /(n) insularity/
インシュリン /(n) insulin/(P)/
インシュリンショック療法 [インシュリンショックりょうほう] /(n) insulin shock therapy/
インシュレーション /(n) insulation/
インシュレーションボード /(n) insulation board/
インシュレータ /(n) insulator/
インジーニャス /(adj-f) ingenious/
インジウム /(n) indium (In)/
インジェクション /(n) injection/
インジェクタ /(n) injector/
インジェクター /(n) injector/
インジケータ /(n) indicator/
インジケーター /(n) indicator/
インジケータランプ /(n) (comp) indicator light/
インジゴ /(n) indigo/
インジゴイド染料 [インジゴイドせんりょう] /(n) (obsc) indigoid dye/
インジゴブルー /(n) indigo (blue)/
インジニアス /(adj-f) ingenious/
インジャリータイム /(n) injury time/
インジャンクション /(n) injunction/
インジュリータイム /(n) injury time/
インジレース /(n) Indianapolis 500 mile race/
インス /(n) (comp) INS/
インスージアスト /(n) enthusiast/
インスインガー /(n) inswinger (baseball)/
インスコ /(n,vs) (comp) (sl) install/
インスタマチックカメラ /(n) Instamatic camera/
インスタレーション /(n) installation/
インスタンス /(n) instance/
インスタンス化 [インスタンスか] /(n) (comp) instantiate/
インスタンス変数 [インスタンスへんすう] /(n) (comp) instance variable/
インスタント /(adj-na,n) instant/(P)/
インスタントカメラ /(n) instant camera/
インスタントコーヒー /(n) instant coffee/
インスタントメッセージ /(n) instant message/IM/
インスタントメッセージング /(n) (comp) instant messaging/IM/
インスタントメッセンジャー /(n) instant messenger/IM/
インスタントラーメン /(n) instant ramen/precooked Chinese noodles/
インスタント食品 [インスタントしょくひん] /(n) instant foods/
インスティチューショナリズム /(n) institutionalism/
インスティチューション /(n) institution/
インスティチュート /(n) institute/
インスティテューション /(n) institution/
インスティンクト /(n) instinct/
インステップキック /(n) instep kick (soccer)/
インスト /(n) (abbr) instant/installation/instructions (e.g. briefings for market researchers)/
インストーラ /(n) (comp) installer/
インストーラー /(n) (comp) installer/
インストール /(n,vs) install/
インストールプログラム /(n) (comp) installation program/
インストールメント /(n) installment/instalment/
インストールログファイル /(n) (comp) installation log file/
インストール可能デバイスドライバ [インストールかのうデバイスドライバ] /(n) (comp) installable device driver/
インストール後の作業 [インストールごのさぎょう] /(n) (comp) post installation step/
インストアマーチャンダイジング /(n) in-store merchandising/
インストゥルメント /(n) instrument/
インストラクション /(n) instruction/
インストラクションセット /(n) (comp) instruction set/
インストラクションセットアーキテクチャ /(n) (comp) instruction set/
インストラクター /(n) instructor/(P)/
インストルメンタリズム /(n) instrumentalism/
インストルメンタル /(adj-f) instrumental/
インストルメンタルポップ /(n) instrumental pop/
インストルメンタルロック /(n) instrumental rock/
インストルメント /(n) instrument/
インストルメントパネル /(n) instrument panel/
インストレーション /(n,vs) (comp) installation/
インストレーションプログラム /(n) (comp) installation program/
インスパイア /(vs) (1) to inspire/(n) (2) inspiration/
インスパイアー /(vs) (1) to inspire/(n) (2) inspiration/
インスピレーション /(n) inspiration/(P)/
インスピレイション /(n) inspiration/
インスペクション /(n) inspection/
インスペクター /(n) inspector/
インスラ /(n) (abbr) inside slider (baseball)/
インスリノーマ /(n) insulinoma/
インスリン /(n) insulin/(P)/
インスリン・ショック /(n) insulin shock/
インスリン・ショック療法 [インスリン・ショックりょうほう] /(n) insulin shock therapy/
インスリンショック /(n) insulin shock/
インスリンショック療法 [インスリンショックりょうほう] /(n) insulin shock therapy/
インスリン抵抗性症候群 [インスリンていこうせいしょうこうぐん] /(n) insulin-resistance syndrome/
インセキュリティー /(n) insecurity/
インセスト /(n) incest/
インセストタブー /(n) incest taboo/
インセンス /(n) incense/
インセンティブ /(n) incentive/(P)/
インセンティブセール /(n) incentive sale/
インソール /(n) insole/
インター /(n) (1) (abbr) interchange/(2) (abbr) international/(P)/
インターアクション /(n) interaction/
インターエクスチェンジ /(n) (comp) interexchange/
インターオペラビリティ /(n) (comp) interoperability/
インターオペラビリティー /(n) interoperability/
インターカット /(n) intercut/
インターカレッジ /(n) intercollegiate (games)/
インターキャスト /(n) (comp) Intercast/
インターキャフィス /(n) (comp) InterCAFIS/
インターキュー /(n) (comp) interQ/
インターコース /(n) intercourse/
インターコム /(n) intercom/intercommunication system/
インターコンチネンタル /(n) intercontinental (e.g. hotel)/
インターステートハイウエー /(n) interstate highway/
インタースリップ /(n) (comp) InterSLIP/
インターセプション /(n) interception/
インターセプター /(n) interceptor/
インターセプト /(n) intercept/
インターゼミ /(n) (abbr) inter seminar/
インターゼミナール /(n) inter seminar/
インターチェンジ /(n) interchange/service interchange/
インターテキスト /(n) (comp) InterText/
インタートップ /(n) (comp) INTERTop/
インターナショナライゼーション /(n) (comp) internationalization/
インターナショナリズム /(n) internationalism/
インターナショナリゼーション /(n) (comp) internationalization/
インターナショナル /(adj-na,n) international/(P)/
インターナショナルバカロレア /(n) International Baccalaureat/
インターナションアリズム /(n) internationalism/
インターナル /(n) internal/
インターニック /(n) (comp) InterNIC/
インターネット /(n,adj-no) (comp) the Internet/(P)/
インターネットＶＰＮ [インターネットブイピーエン] /(n) (comp) Internet Virtual Private Network/
インターネットで結ぶ [インターネットでむすぶ] /(exp,v5b) (comp) to link to the Internet/
インターネットによる願書提出 [インターネットによるがんしょていしゅつ] /(n) (comp) on-line submission of an application form/
インターネットのベテランユーザ /(n) (comp) Internet veteran/
インターネットアクセス /(n) (comp) Internet access/
インターネットアドレス /(n) (comp) Internet address/
インターネットエクスプローラ /(n) (comp) Internet Explorer/
インターネットオークション /(n) Internet auction/
インターネットカフェ /(n) (comp) Internet cafe/cybercafe/
インターネットギャンブル /(n) Internet gambling/
インターネットサービス /(n) (comp) Internet service/Internet-based service/
インターネットサービスプロバイダ /(n) (comp) Internet Service Provider/ISP/
インターネットサービスプロバイダー /(n) (comp) Internet Service Provider/ISP/
インターネットサイト /(n) (comp) Internet site/
インターネットショッピング /(n) (comp) Internet shopping/
インターネットセキュリティ /(n) Internet security/
インターネットソサエティ /(n) (comp) Internet Society/
インターネットテレビ /(n) (comp) Internet television/Internet TV/
インターネットデータセンター /(n) (comp) Internet Data Center/
インターネットバブル /(n) dot-com bubble/
インターネットバンキング /(n) (comp) Internet banking/
インターネットビジネス /(n) (comp) Internet business/
インターネットフォン /(n) (comp) Internet Phone/
インターネットプロトコル /(n) (comp) Internet Protocol/IP/
インターネットプロトコルアドレス /(n) (comp) Internet Protocol address/IP address/
インターネットプロバイダ /(n) (comp) Internet provider/
インターネットプロバイダー /(n) (comp) Internet Service Provider/ISP/
インターネットマーケティング /(n) (comp) Internet marketing/
インターネットメール /(n) (comp) Internet mail/
インターネットユーザー /(n) Internet user/
インターネットラジオ /(n) Internet radio/
インターネットリレーチャット /(n) (comp) Internet relay chat/IRC/
インターネットワーキング /(n) (comp) internetworking/
インターネットワーク /(n) (comp) internetwork/
インターネットワーム /(n) (comp) Internet worm/
インターネットワールド /(n) (comp) Internet World (trade show)/
インターネット閲覧ソフト [インターネットえつらんソフト] /(n) (comp) Web browser/Web-browsing software/
インターネット学会 [インターネットがっかい] /(n) (comp) Internet Society/ISOC/
インターネット技術推進グループ [インターネットぎじゅつすいしんグループ] /(n) (comp) Internet Engineering Steering Group/IESG/
インターネット技術特別調査委員会 [インターネットぎじゅつとくべつちょうさいいんかい] /(n) (comp) Internet Engineering Task Force/IETF/
インターネット検索 [インターネットけんさく] /(n) (comp) Web search/
インターネット研究推進グループ [インターネットけんきゅうすいしんグループ] /(n) (comp) Internet Research Steering Group/IRSG/
インターネット研究特別調査委員会 [インターネットけんきゅうとくべつちょうさいいんかい] /(n) (comp) Internet Research Task Force/IRTF/
インターネット接続 [インターネットせつぞく] /(n) (comp) Internet connection/
インターネット接続共有 [インターネットせつぞくきょうゆう] /(n) (comp) Internet Connection Sharing/ICS/
インターネット接続業者 [インターネットせつぞくぎょうしゃ] /(n) Internet service provider/ISP/
インターネット電話 [インターネットでんわ] /(n) (1) (comp) Internet telephony/(2) Internet telephone/
インターネット放送 [インターネットほうそう] /(n) Webcast/Internet broadcast/
インターハイ /(n) (abbr) inter high school/
インターバル /(n) interval/
インターバルタイマ /(n) (comp) interval timer/
インターバルトレーニング /(n) interval training/
インターバンク /(n) interbank/
インターバンクローン /(n) inter-bank loan/
インターバンク取引 [インターバンクとりひき] /(n) interbank exchange dealings/
インタービュー /(n,vs) interview (i.e. television, newspaper, etc.)/
インターフェース /(n) (comp) interface/
インターフェースアダプタ /(n) (comp) interface adapter/
インターフェースビルダ /(n) (comp) interface builder/
インターフェア /(n) interfere/
インターフェアランス /(n) interference/
インターフェイス /(n) (comp) interface/
インターフェイスボード /(n) (comp) interface board/
インターフェイスメッセージプロセッサー /(n) (comp) Interface Message Processor/IMP/
インターフェロン /(n) interferon/
インターフォン /(n) intercom (wasei: interphone)/
インターブロックギャップ /(n) (comp) interblock gap/IBG/
インタープリタ /(n) (comp) interpreter/
インタープリター /(n) (comp) interpreter/
インタープリタ型言語 [インタープリタかたげんご] /(n) (comp) interpretive language/
インターホン /(n) intercom (wasei: interphone)/
インターポール /(n) Interpol/International Criminal Police Organization (Organisation)/
インターポル /(n) Interpol/International Criminal Police Organization (Organisation)/
インターミッション /(n) intermission/
インターメディア /(n) (comp) InterMedia/
インターラプト /(n) interrupt/
インターリービング /(n) (comp) interleaving/
インターリーブ /(n) interleave/
インターリーブメモリ /(n) (comp) interleaved memory/
インタールード /(n) interlude/
インターレース /(n) (comp) interlace/
インターレースＧＩＦ [インターレースギッフ] /(n) (comp) interlaced GIF/
インターレースＧＩＦ [インターレースジッフ] /(n) (comp) interlaced GIF/
インターロイキン /(n) interleukin/
インターロッキング・システム /(n) interlocking system/
インターロッキンググリップ /(n) interlocking grip (golf)/
インターロッキングシステム /(n) interlocking system/
インターロック /(n,pref) interlock/
インターロック回路 [インターロックかいろ] /(n) interlock circuit/interlocking circuit/
インターワーキング /(n) (comp) interworking/
インターン /(n) intern/(P)/
インターンシップ /(n) internship/
インターン制度 [インターンせいど] /(n) internship system/
インタアクティブ /(adj-na,n) interactive/
インタセプト /(n) intercept/
インタネット /(n,adj-no) (comp) the Internet/
インタバル /(n) interval/
インタビュ /(n,vs) interview (i.e. television, newspaper, etc.)/
インタビュー /(n,vs) interview (i.e. television, newspaper, etc.)/(P)/
インタビューアー /(n) interviewer/
インタビュアー /(n) interviewer/
インタビュウ /(ik) (n,vs) interview (i.e. television, newspaper, etc.)/
インタファクス通信 [インタファクスつうしん] /(n) Interfax news agency/
インタフェース /(n) (comp) interface/
インタフェースアドレス /(n) (comp) interface address/
インタフェースカード /(n) (comp) interface card/
インタフェースモジュール /(n) (comp) interface module/
インタフェース種別 [インタフェースしゅべつ] /(n) (comp) interface type/
インタフェース定義言語 [インタフェースていぎげんご] /(n) (comp) Interface Definition Language/
インタフェイス /(n) (comp) interface/
インタフェス /(n) (comp) interface/
インタプリータ型言語 [インタプリータかたげんご] /(n) (comp) interpretive language/
インタプリタ /(n) (1) (comp) interpreter/(2) interpretive program/
インタプリタ型言語 [インタプリタかたげんご] /(n) (comp) interpretive language/
インタプリティブ /(n) interpretive/
インタプリト /(n) interpret/
インタラクション /(n) interaction/
インタラクティビティー /(n) interactivity/
インタラクティブ /(adj-na,n) interactive/(P)/
インタラクティブテレビ /(n) (comp) interactive television/
インタラクティブボタン /(n) (comp) interactive button/
インタラクティヴ /(adj-na,n) interactive/
インタラプト /(n) (comp) interrupt/
インタリーブ /(n,vs) (comp) interleave/
インタリオ /(n) intaglio/
インタレース /(n) (comp) interlace/
インタレスト /(n) interest/
インタレストグループ /(n) (comp) interest group/
インタロゲーション /(n,adj-f) interrogation/
インタロゲーションマーク /(n) interrogation mark/
インタロゲイション /(n,adj-f) interrogation/
インタロゲイションマーク /(n) interrogation mark/
インタヴュー /(n,vs) interview (i.e. television, newspaper, etc.)/
インタヴュアー /(n) interviewer/
インダイレクト /(adj-na) indirect/
インダクション /(n) induction/
インダクションコイル /(n) induction coil/
インダクションモーター /(n) induction motor/
インダクタ /(n) inductor/
インダクター /(n) inductor/
インダクタンス /(n) inductance/
インダストゥリアル /(ik) (adj-na,n) industrial/
インダストリ /(n) industry/
インダストリー /(n) industry/
インダストリアル /(adj-na,n) industrial/(P)/
インダストリアルエンジニアリング /(n) industrial engineering/
インダストリアルデザイナー /(n) industrial designer/
インダストリアルデザイン /(n) industrial design/
インダストリアルパーク /(n) industrial park/
インダス文明 [インダスぶんめい] /(n) Indus (valley) civilization (civilisation)/
インチ /(n) (uk) inch/(P)/
インチキ /(adj-na,n,vs) (1) cheating/fake/bogus/(2) travelling seller of trinkets, magic tricks, etc. (traveling)/(P)/
インチネジ /(n) (comp) inch screw threads/
インツーリスト /(n) Inturist (rus:)/
インテーク /(n) intake/
インティファーダ /(n) intifada (ara:)/
インティメート /(adj-no) intimate/
インテグラル /(n) integral/
インテグレーション /(n) integration/(P)/
インテグレーティドルーチング /(n) (comp) integrated routing/
インテグレーテット /(n) integrated/
インテグレーテッドマーケティング /(n) integrated marketing/
インテグレート /(n) integrate/
インテジャ /(n) integer/
インテラクティブ /(adj-na,n) interactive/
インテリ /(n,adj-no) (abbr) egghead/intelligentsia/(P)/
インテリやくざ /(n) intellectual-type gangster/
インテリア /(n) interior/(P)/
インテリアアドバイサー /(n) interior adviser/interior advisor/
インテリアクラフト /(n) interior craft/
インテリアコーディネーター /(n) interior coordinator/
インテリアデコレーション /(n) interior decoration/
インテリアデザイナー /(n) interior designer/
インテリアデザイン /(n) interior design/
インテリアバール /(n) prying tool used in interior decoration (wasei: interior bar)/
インテリアファブリック /(n) interior fabric/
インテリゲンチア /(n) intelligentsia (rus:)/
インテリゲンチャ /(n) intelligentsia (rus:)/
インテリジェンス /(n) intelligence/(P)/
インテリジェンスサービス /(n) intelligence service/
インテリジェンステスト /(n) intelligence test/
インテリジェント /(adj-na,n) intelligent/(P)/
インテリジェントＩＭフィルタ [インテリジェントアイエムフィルタ] /(n) (comp) intelligent IM filter/
インテリジェントケーブル /(n) (comp) intelligent cable/
インテリジェントシティー /(n) intelligent city/
インテリジェントステーション /(n) (comp) intelligent station/
インテリジェントターミナル /(n) (comp) intelligent terminal/
インテリジェントデータベース /(n) (comp) intelligent database/
インテリジェントデザイン /(n) intelligent design (theory that life or the universe must have been designed by an intelligent being)/
インテリジェントネットワーク /(n) (comp) intelligent network/
インテリジェントハブ /(n) (comp) intelligent hub/
インテリジェントビル /(n) (abbr) intelligent building/
インテリジェントマルチプレクサ /(n) (comp) intelligent mux/intelligent multiplexer/
インテリジェント装置 [インテリジェントそうち] /(n) (comp) intelligent device/
インテリジェント端末 [インテリジェントたんまつ] /(n) (comp) intelligent (as opposed to dumb) terminal/
インテリ層 [インテリそう] /(n) intellectuals/intelligentsia/educated class/
インテル /(n) (1) (comp) Intel (chip manufacturer)/(2) interline leads/(P)/
インテルクチュアル /(n) intellectual/
インテルサット /(n) Intelsat/International Telecommunications Satellite Organization (Organisation)/
インテルメッツォ /(n) intermezzo (ita:)/
インテレクチュアル /(n) intellectual/
インテレクト /(n) intellect/
インテンシティ /(n) intensity/
インテンシブ /(adj-na) intensive/
インテンショナル /(adj-na) intentional/
インデアン /(n) Indian/
インディー /(n) indie/
インディーズ /(n) indies/independent film or music/
インディーズビデオ /(n) (abbr) pornographic videos (wasei: indecent videos)/
インディア /(n) India/
インディアナ /(n) Indiana/(P)/
インディアナポリス５００マイルレース [インディアナポリスごひゃくマイルレース] /(n) Indianapolis 500-mile race (each year on May 30th)/
インディアペーパー /(n) India paper/
インディアン /(n) Indian/(P)/
インディアン・スウェル・シャーク /(n) Indian swellshark (Cephaloscyllium silasi, species of catshark from the western Indian Ocean)/
インディアンオーシャンミミックサージャンフィッシュ /(n) Indian Ocean mimic surgeonfish (Acanthurus tristis, species of tang from the Indian Ocean)/
インディアンオーシャンミミックサージョンフィッシュ /(n) Indian Ocean mimic surgeonfish (Acanthurus tristis, species of tang from the Indian Ocean)/
インディアンクロミス /(n) blacktail chromis (Chromis nigrura)/
インディアングレゴリー /(n) Western gregory (Stegastes obreptus)/
インディアンゴールドバードバタフライフィッシュ /(n) Indian golden-barred butterflyfish (Roa jayakari, was Chaetodon jayakari)/
インディアンゴールドリングブリストルトゥース /(n) Indian gold-ring bristle-tooth (Ctenochaetus truncatus, species of bristletooth tang native to the Indian Ocean)/
インディアンサマー /(n) Indian summer/
インディアンジュエリー /(n) Indian jewellery (jewelry)/
インディアンスウェルシャーク /(n) Indian swellshark (Cephaloscyllium silasi, species of catshark from the western Indian Ocean)/
インディアンバタフライフィッシュ /(n) Indian butterflyfish (Chaetodon mitratus)/
インディアンバナーフィッシュ /(n) phantom bannerfish (Heniochus pleurotaenia)/Indian Ocean bannerfish/
インディアンブルー /(n) Indian blue/
インディアンヴァガボンドバタフライフィッシュ /(n) Indian vagabond butterflyfish (Chaetodon decussatus)/blackened butterflyfish/black-finned vagabond/
インディアン座 [インディアンざ] /(n) Indus (constellation)/
インディア紙 [インディアかみ] /(n) India paper/
インディオ /(n) (1) an Indian/(2) Indeo/
インディケータ /(n) indicator/
インディケーター /(n) indicator/
インディゴ /(n) indigo/
インディビジュアリスト /(n) individualist/
インディビジュアリズム /(n) individualism/
インディビジュアリティー /(n) (obsc) individuality/
インディビジュアル /(n) individual/
インディヘナ /(n) native (spa: indigena)/
インディペンデンス /(n) independence/
インディペンデント /(adj-na,n) independent/(P)/
インディペンデントリビング運動 [インディペンデントリビングうんどう] /(n) independent living movement/
インデキシング /(n) indexing/
インデクサ /(n) (comp) indexer/
インデクシング /(n) indexing/
インデクセーション /(n) indexation/
インデックス /(n) index/indices/indexes/(P)/
インデックスアドレッシング /(n) (comp) index addressing/
インデックストラック /(n) (comp) index track/
インデックスバッファ /(n) (comp) index buffer/
インデックスファイル /(n) (comp) indexed file/
インデックスファンド /(n) index fund/
インデックスホール /(n) (comp) index hole/
インデックスレジスタ /(n) (comp) index register/
インデックス付きアドレス [インデックスつきアドレス] /(n) (comp) indexed address/
インデックス付きサーチ [インデックスつきサーチ] /(n) (comp) indexed search/
インデペンデンス /(n) independence/
インデンテーション /(n) indentation/
インデンテイション /(n) indentation/
インデント /(n) indent/
イントネーション /(n) intonation/(P)/
イントラ /(n) (abbr) Intranet/
イントラスタット /(n) (comp) intrastat/
イントラネット /(n) (comp) Intranet/
イントラネットウェア /(n) (comp) IntranetWare/
イントランス /(n) entrance/
イントラント /(n) entrant/
イントレランス /(n) intolerance/
イントロ /(n) (abbr) intro/introduction/(P)/
イントロダクション /(n) introduction/
イントロパック /(n) (comp) intro-pack/
イントロビジョン /(n) intro-vision/
イントロン /(n) intron/
インド /(n,adj-no) (uk) India/Hindustan/
インド・アーリア語派 [インド・アーリアごは] /(n) Indic languages/Indo-Aryan languages/
インド・ヨーロッパ祖語 [インド・ヨーロッパそご] /(n) Proto-Indo-European (hypothetical language from which all Indo-European languages are derived)/
インドール /(n) indole/
インドール酢酸 [インドールさくさん] /(n) indoleacetic acid/
インドール酪酸 [インドールらくさん] /(n) indolebutyric acid/
インドア /(n) indoor/(P)/
インドアーリア語派 [インドアーリアごは] /(n) Indic languages/Indo-Aryan languages/
インドアゲーム /(n) indoor game/
インドアスポーツ /(n) indoor sports/
インドカレー屋 [インドカレーや] /(n) Indian curry shop/
インドクジャク /(n) (uk) Indian peafowl/common peafowl (Pavo cristatus)/
インドクトリネーション /(n) indoctrination/
インドゲルマン語族 [インドゲルマンごぞく] /(n) (obs) Indo-Germanic (family of languages)/
インドコブラ /(n) Indian cobra/spectacled cobra/Asian cobra (Naja naja)/
インドゴムの木 [インドゴムのき] /(n) India rubber tree/
インドサイ /(n) Indian rhinoceros/great one-horned rhinoceros (Rhinoceros unicornis)/
インドサリー /(n) Indian sari/
インドシアニン /(n) indocyanine/
インドシナ語族 [インドシナごぞく] /(n) Indo-Chinese (family of languages)/
インドシナ戦争 [インドシナせんそう] /(n) (first) Indochina War (1946-1954)/
インドシュモクザメ /(n) (uk) winghead shark (Eusphyra blochii, species of Indo-West Pacific hammerhead shark)/
インドシュモクザメ属 [インドシュモクザメぞく] /(n) Eusphyra (genus of hammerhead shark in the family Sphyrnidae whose sole member is the winghead shark)/
インドスダレ /(n) blackwedged butterflyfish (Chaetodon falcula)/saddled butterflyfish/pigface coralfish/sickle butterflyfish/Indian double-saddle butterflyfish/
インドネシア /(n,adj-no) Indonesia/(P)/
インドネシア語 [インドネシアご] /(n) Indonesian (language)/Bahasa Indonesia/
インドネシア語派 [インドネシアごは] /(n) Indonesian (branch of languages)/
インドネシア人 [インドネシアじん] /(n) Indonesian (person)/
インドハッカ /(n) (uk) common myna/Indian myna (species of mynah bird, Acridotheres tristis)/
インドヒメジ /(n) bicolor goatfish (Parupeneus barberinoides)/half-and-half goatfish/
インドフウライ /(n) Indian vagabond butterflyfish (Chaetodon decussatus)/blackened butterflyfish/black-finned vagabond/
インドメタシン /(n) indomethacin/
インドヨーロッパ語族 [インドヨーロッパごぞく] /(n) Indo-European languages/
インドヨーロッパ祖語 [インドヨーロッパそご] /(n) Proto-Indo-European (hypothetical language from which all Indo-European languages are derived)/
インドライオン /(n) Asiatic lion (from Indian lion)/
インドリ /(n) indri (short-tailed lemur) (Indri indri)/
インドレント /(adj-f) indolent/
インドワタノキ /(n) (uk) (obsc) Indian silk-cotton tree (Bombax ceiba)/
インド亜大陸 [インドあたいりく] /(n) Indian subcontinent/
インド医学 [インドいがく] /(n) Indian medicine/
インド語派 [インドごは] /(n) Indic languages/Indo-Aryan languages/
インド孔雀 [インドくじゃく] /(n) (uk) Indian peafowl/common peafowl (Pavo cristatus)/
インド犀 [インドさい] /(n) Indian rhinoceros/great one-horned rhinoceros (Rhinoceros unicornis)/
インド象 [インドぞう] /(n) Indian elephant/Asian elephant/
インド水牛 [インドすいぎゅう] /(n) Indian buffalo/
インド総督 [インドそうとく] /(n) Viceroy of India/
インド太平洋 [インドたいへいよう] /(n) Indo-Pacific/
インド大反乱 [インドだいはんらん] /(n) Indian Mutiny (1857-1858)/
インド大叛乱 [インドだいはんらん] /(n) Indian Mutiny (1857-1858)/
インド大麻 [インドたいま] /(n) Indian hemp/
インド哲学 [インドてつがく] /(n) Indian philosophy/
インド八哥 [インドはっか] /(n) (uk) common myna/Indian myna (species of mynah bird, Acridotheres tristis)/
インド綿の木 [インドわたのき] /(n) (uk) (obsc) Indian silk-cotton tree (Bombax ceiba)/
インド洋 [インドよう] /(n) Indian Ocean/
インド藍 [インドあい] /(n) indigo/
インド料理 [インドりょうり] /(n) Indian food/Indian cooking/
インナー /(adj-f) (1) inner/(n) (2) underwear/innerwear/
インナーキャビネット /(n) inner cabinet/
インナーシティ /(n) inner city/
インナーシティー /(n) inner city/
インナースペース /(n) inner space/
インナートリップ /(n) inner trip/
インナーベンチャー /(n) inner venture/
インナーライフ /(n) inner life/
インニング /(n) inning/
インハイ /(n) in high/
インハウス /(n) in-house/
インハラベイビー /(n) (sl) being pregnant/
インハラベビー /(n) (sl) being pregnant/
インバー /(n) Invar (trademarked nickel-steel alloy)/
インバース /(n) inverse/
インバータ /(n) (comp) inverter/
インバーター /(n) (comp) inverter/(P)/
インバイアロンメント /(n) environment/
インバウンド /(n) (comp) inbound/
インバネス /(n) Inverness (e.g. coat, cape)/
インバランス /(n,adj-na) imbalance/
インバリッド /(n) invalid/
インパクト /(n) impact/(P)/
インパクトプリンタ /(n) (comp) impact printer/
インパクトローン /(n) impact loan/
インパスト /(n) impasto (ita:)/
インパチェンス /(n) impatiens (Impatiens sultanii, Impatiens walleriana)/
インパチエンス /(n) impatiens (Impatiens sultanii, Impatiens walleriana)/
インパネ /(n) (abbr) instrument panel/
インパラ /(n) impala/
インパルス /(n) impulse/
インビジブル /(adj-na) invisible/
インビジブルリスク /(n) invisible risk/
インビテーション /(n) invitation/
インビトロ /(exp) in vitro (lat:)/
インビボ /(exp) in vivo (lat:)/
インピーダンス /(n) impedance/
インピーダンス管理グラウンド層 [インピーダンスかんりグラウンドそう] /(n) (comp) impedance-controlling ground plane/
インピーダンス整合 [インピーダンスせいごう] /(n) impedance matching/
インファイト /(n) infighting (boxing)/
インファント /(n) infant/
インフィールダー /(n) (obsc) infielder/
インフィールド /(n) infield/
インフィールドフライ /(n) infield fly/
インフィックス表記法 [インフィックスひょうきほう] /(n) (comp) infix notation/
インフィニティ /(n) infinity/
インフィニティー /(n) infinity/
インフェリオリティーコンプレックス /(n) inferiority complex/
インフェルノ /(n) inferno/
インフォ /(n) (abbr) information/
インフォーマー /(n) informer/
インフォーマル /(adj-na) informal/
インフォーマルオーガニゼーション /(n) informal organization/informal organisation/
インフォーマルケア /(n) informal care/
インフォーマルドレス /(n) informal dress/
インフォーマント /(n) informant (often with regard to survey respondents)/
インフォームドコンセント /(n) informed consent/
インフォーメーシオン /(ik) (n) information/
インフォーメーション /(n) information/
インフォウェッブ /(n) (comp) Info-Web/
インフォシーク /(n) (comp) Infoseek/
インフォストラクチャー /(n) (comp) infostructure/information structure/
インフォスフィア /(n) (comp) InfoSphere/
インフォテイメント /(n) (comp) infortainment/
インフォナビゲーター /(n) (comp) InfoNavigator/
インフォマーシャル /(n) (abbr) information commercial/
インフォマック /(n) (comp) Info-Mac/
インフォミックス /(n) (comp) Informix/
インフォメーション /(n) information/(P)/
インフォメーション・テクノロジー /(n) information technology/IT/
インフォメーションアナリスト /(n) information analyst/
インフォメーションギャプ /(n) information gap/
インフォメーションサイエンス /(n) information science/
インフォメーションシステム /(n) information system/
インフォメーションシンジケート /(n) information syndicate/
インフォメーションスーパーハイウェイ /(n) (comp) information superhighway/
インフォメーションセオリー /(n) information theory/
インフォメーションセンター /(n) information kiosk/information centre/
インフォメーションソサイエティー /(n) information society/
インフォメーションテクノロジー /(n) information technology/IT/
インフォメーションディスクロージャー /(n) information disclosure/
インフォメーションデモクラシー /(n) information democracy/
インフォメーションブローカー /(n) information broker/
インフォメーションプロセッサー /(n) information processor/
インフォメーションプロセッシング /(n) information processing/
インフォメーションプロバイダー /(n) information provider/
インフォメーションユーティリティー /(n) information utility/
インフォメーションリテラシー /(n) information literacy/
インフォメーションリトリーバル /(n) information retrieval/
インフォメーションレボリューション /(n) information revolution/
インフォモザイク /(n) (comp) Infomosaic/
インフラ /(n) (abbr) infrastructure/(P)/
インフラストラクチャ /(n) infrastructure/
インフラストラクチャー /(n) infrastructure/
インフラストラクチャモード /(n) (comp) infrastructure mode/
インフラ開発 [インフラかいはつ] /(n) infrastructure development/
インフラ整備 [インフラせいび] /(n) infrastructure improvement/
インフルエンザ /(n,adj-no) influenza/(P)/
インフルエンザの予防接種 [インフルエンザのよぼうせっしゅ] /(n) influenza vaccination/flu shot/
インフルエンザウイルス /(n) influenza virus/
インフルエンザワクチン /(n) flu vaccine/influenza vaccine/
インフルエンザ脳症 [インフルエンザのうしょう] /(n) influenza-associated encephalopathy/
インフルエンス /(n) influence/
インフレ /(n,adj-no) (abbr) inflation/(P)/
インフレーション /(n) inflation/
インフレーション宇宙 [インフレーションうちゅう] /(n) inflationary universe/
インフレーション会計 [インフレーションかいけい] /(n) inflation accounting/
インフレーション率 [インフレーションりつ] /(n) inflation rate/
インフレアドインタフェース /(n) (comp) infrared interface/
インフレギャップ /(n) inflationary gap/
インフレターゲット /(n) inflation target/
インフレヘッジ /(n) inflation hedge (hedge against inflation)/
インフレ傾向 [インフレけいこう] /(n) inflationary tendency/
インフレ懸念 [インフレけねん] /(n) inflation fear/inflation worries/
インフレ政策 [インフレせいさく] /(n) inflationary policy/
インフレ対策 [インフレたいさく] /(n) counter-inflation measures/
インフレ率 [インフレりつ] /(n) (abbr) inflation rate/
インフロー /(n) inflow/
インブリード /(vs) to inbreed/
インプット /(n,vs) input/(P)/
インプットポート /(n) (comp) input port/
インプットメソッド /(n) (comp) input method/IM/
インプライズ /(n) (comp) INPRISE/
インプラント /(n,vs) implant (esp. dental)/
インプリケーション /(n) implication/
インプリメンタ /(n) implementor/
インプリメンテーション /(n) implementation/
インプリメンテイション /(n) implementation/
インプリメント /(n) (1) implement/(2) (abbr) implementation/
インプリンティング /(n) imprinting/
インプレー /(n) in play (sports)/
インプレッシブ /(adj-na) impressive/
インプレッショニズム /(n) impressionism/
インプレッション /(n) impression/
インプレメント /(n) implement/
インプロ /(n) (1) (abbr) improvisation/(2) improvisational theatre/
インプロセス /(n) (comp) in-process/
インプロビゼーション /(n) improvisation/improvization/
インプロヴァイゼィション /(n) improvisation/improvization/
インプロヴィゼーション /(n) improvisation/improvization/
インヘリタンス /(n) (comp) inheritance/
インベーダー /(n) invader/
インベスター /(n) investor/
インベスターリレーションズ /(n) investor relations/
インベステメントカウンセラー /(n) investment counselor/investment counsellor/
インベステメントバンク /(n) investment bank/
インベストメント /(n) investment/
インベストメントアナリスト /(n) investment analyst/
インベストメントバンキング /(n) investment banking/
インベストメントバンク /(n) investment bank/
インベルターゼ /(n) invertase (ger: Invertase)/
インベンション /(n) invention/
インベントリ /(n) inventory/stock/goods/list/
インベントリー /(n) inventory/stock/goods/list/
インベントリーサイクル /(n) inventory cycles/
インベントリーファイナンス /(n) inventory finance/
インベントリーリカバリー /(n) inventory recovery/
インベントリーリセッション /(n) inventory recession/
インベントリー分析 [インベントリーぶんせき] /(n) inventory analysis/
インベントリ分析 [インベントリぶんせき] /(n) inventory analysis/
インペーダンス /(n) impedance/
インペラ /(n) impeller/
インペリアリズム /(n) imperialism/
インペリアル /(n) imperial/(P)/
インペル /(vs) to impel/
インボイス /(n) invoice/
インボックス /(n) (comp) in-box/
インボックスドライバ /(n) (comp) in-box driver/
インボリュート /(n) (math) involute/
インボリュート曲線 [インボリュートきょくせん] /(n) (math) involute curve/
インボリュート歯車 [インボリュートはぐるま] /(n) involute gear/
インボルブ /(n) involve/
インポ /(n) (abbr) impotence/
インポータント /(n) important/
インポート /(n,vs) import/(P)/
インポシブル /(adj-na) (col) impossible/
インポッシブル /(adj-na) (col) impossible/
インポテンス /(n) impotence (ger: Impotenz)/
インポテンツ /(n) impotence (ger: Impotenz)/
インポ薬 [インポやく] /(n) (abbr) anti-impotence medication/
インマルサット /(n) International Maritime Satellite Organization (Organisation)/INMARSAT/
インメガチャート /(n) TV test pattern chart/megacycles chart/
インモーラル /(adj-na,adj-no) immoral/
インモラル /(adj-na,adj-no) immoral/
インヨウカク /(n) horny goat weed (Epimedium grandiflorum var. thunbergianum)/rowdy lamb herb/barrenwort/bishop's hat/fairy wings/yin yang huo/
インライン /(n,adj-no) (comp) in-line/
インライン・スケート /(n) inline skates/
インラインイメージ /(n) (comp) inline image/
インラインオブジェクト /(n) (comp) inline object/
インラインコード /(n) (comp) in-line code/
インラインサブルーチン /(n) (comp) in-line subroutine/
インラインスケート /(n) inline skates/
インラインスタイル /(n) (comp) inline style/
インラインディスカッション /(n) (comp) inline discussion/
インライン画像 [インラインがぞう] /(n) (comp) inline graphic/
インライン展開 [インラインてんかい] /(n) (comp) in-line expansion/
インライン変換 [インラインへんかん] /(n) (comp) in-line translation/
インレー /(n) inlay/
インレット /(n) inlet/
インロー /(n) seal case/pill box/medicine case/
インヴァース /(n) inverse/
インヴァリアント /(n) invariant/
インヴェンション /(n) invention/
インヴォイス /(n) invoice/
イン腹ベイビー [インはらベイビー] /(n) (sl) being pregnant/
イン腹ベビー [インはらベビー] /(n) (sl) being pregnant/
イヴ /(n) eve (esp. Christmas Eve)/the night before/
イヴニング /(n) evening/
イ音便 [イおんびん] /(n) euphonic change wherein some mora ('ki', 'gi', 'shi' and 'ri') are pronounced 'i'/
イ形容詞 [イけいようし] /(n) adjective ending in "i"/i-adjective/
イ短調 [イたんちょう] /(n) A minor/
イ調 [イちょう] /(n) key of A (music)/
イ長調 [イちょうちょう] /(n) A major/
ウージ /(n) (rkb:) sugar cane/sugarcane/
ウースターソース /(n) Worcester (Worcestershire) sauce/
ウーステッド /(n) worsted/
ウーゾ /(n) ouzo (gre:)/
ウード /(n) oud (lute-like instrument of Arabic origin) (ara: ud)/
ウーハー /(n) woofer (speaker system)/
ウーハイ /(n) (abbr) (sl) oolong tea highball/
ウーパールーパー /(n) (col) axolotl (esp. an albino) (wasei: wooper looper)/
ウーファー /(n) woofer (speaker system)/
ウーマン /(n,adj-no) woman/(P)/
ウーマンハンター /(n) woman hunter/
ウーマンパワー /(n) woman power/
ウーマンリブ /(n) (abbr) women's liberation/
ウーリーコットン /(n) woolly cotton/
ウーリーナイロン /(n) woolly nylon/
ウーリーモンキー /(n) woolly monkey (any New World monkey of genus Lagothrix)/
ウール /(n) wool/(P)/
ウールマーク /(n) wool mark/
ウーロンハイ /(n) oolong tea highball/
ウーロン茶 [ウーロンちゃ] /(n) Oolong tea/
ウーン /(int) hmm/well/
ウァギナ /(n) vagina (lat:)/
ウィ /(int) yes (fre: oui)/
ウィーク /(n) (1) week/(2) weak/(P)/
ウィークエンド /(n) weekend/(P)/
ウィークエンドハウス /(n) weekend house/
ウィークデー /(n) weekday/
ウィークデイ /(n) weekday/
ウィークボソン /(n) weak boson/
ウィークポイント /(n) weak point/
ウィークリ /(n,adv) weekly/
ウィークリー /(n,adv) weekly/(P)/
ウィークリーマンション /(n) small apartment rented by the week (wasei: weekly mansion)/
ウィード /(n) weed/
ウィービング /(n,vs) weaving/
ウィーンアピール /(n) Vienna Appeal/
ウィーン学団 [ウィーンがくだん] /(n) Vienna Circle/
ウィキ /(n) (comp) Wiki/
ウィキペディア /(n) Wikipedia (free online encyclopedia)/
ウィク /(n) wick/
ウィクショナリー /(n) Wiktionary (a wiki based open content dictionary)/
ウィグワム /(n) wigwam (North American Indian tent) (alg:)/
ウィケット /(n) wicket (e.g. in cricket)/
ウィザ /(vs) to wither/
ウィザー /(vs) to wither/
ウィザード /(n) wizard/
ウィザードリー /(n) (comp) Wizardry/
ウィザァド /(n) wizard/
ウィジウィズ /(n) (comp) WYSIWYS/
ウィジェット /(n) widget/(P)/
ウィジャ板 [ウィジャばん] /(n) ouija board/
ウィスカー /(n) whisker/
ウィスキー /(n) whisky/whiskey/(P)/
ウィスキーサウー /(n) whisky sour/whiskey sour/
ウィスキーボンボン /(n) whisky bonbon (fre:)/whiskey bonbon/liqueur candy/
ウィスパー /(n) whisper/
ウィダール反応 [ウィダールはんのう] /(n) Widal reaction (for typhoid fever)/
ウィッカ /(n) Wicca/
ウィッグ /(n) wig/
ウィッケット /(n) wicket (cricket)/
ウィッチヘーゼル /(n) witch hazel/
ウィット /(n) wit/
ウィドー /(n) widow/
ウィドウ /(n) widow/
ウィドウア /(n) widower/
ウィニングボール /(n) winning ball/
ウィラメット /(n) (comp) Willamette/
ウィリー /(n) wheelie/
ウィルス /(n) (1) virus (lat:, ger:)/(adj-no) (2) viral/(P)/
ウィルスプロテクション /(n) (comp) virus protection/
ウィルス隔離 [ウィルスかくり] /(n) (comp) virus removal/virus sweep/
ウィルトンカーペット /(n) Wilton carpet/
ウィルム /(n) wyrm (variety of wyvern)/
ウィローグリーン /(n) willow green/
ウィンイニ /(n) (comp) WIN.INI/
ウィンエフティーピー /(n) (comp) WinFTP/
ウィンカー /(n) (1) Winker (automobile)/(2) (car) blinker/(car) turning indicator/
ウィンク /(n,vs) wink/
ウィング /(n) wing/
ウィングス /(n) wings/
ウィングチェア /(n) wing chair/
ウィングヘッド・シャーク /(n) winghead shark (Eusphyra blochii, species of Indo-West Pacific hammerhead shark)/
ウィングヘッドシャーク /(n) winghead shark (Eusphyra blochii, species of Indo-West Pacific hammerhead shark)/
ウィンサンジューニ /(n) (comp) Win32/
ウィンサンジューニエス /(n) (comp) Win32s/
ウィンザーチェア /(n) Windsor chair/
ウィンザー家 [ウィンザーけ] /(n) House of Windsor/
ウィンジー /(n) (comp) WinG/
ウィンジップ /(n) (comp) WinZip/
ウィンジューロク /(n) (comp) Win16/
ウィンズ /(n) (comp) WINS/
ウィンソック /(n) (comp) WindSock/Winsock/
ウィンタ /(n) winter/
ウィンター /(n) winter/(P)/
ウィンタースポーツ /(n) winter sports/
ウィンタッチ /(n) (comp) WinTach/
ウィンチ /(n) winch/
ウィンチェスターディスク /(n) (comp) Winchester disk/
ウィンチェスタテクノロジ /(n) (comp) winchester technology/
ウィンチェスタディスク /(n) (comp) Winchester disk/
ウィンテル /(n) (comp) Wintel/
ウィンド /(n) wind/(P)/
ウィンドー /(n) (1) (comp) window/(2) window (shop display)/
ウィンドーショッピング /(n,vs) window-gazing window-shopping/
ウィンドーディスプレー /(n) window display/
ウィンドードレッシング /(n) window dressing/
ウィンドゥズ /(n) (comp) Windows (Microsoft operating system)/
ウィンドウ /(n) (1) (comp) window/(2) window (shop display)/(P)/
ウィンドウを最大化する [ウィンドウをさいだいかする] /(exp,vs-i) (comp) to maximize a window's size/to maximise a window's size/
ウィンドウを最大表示する [ウィンドウをさいだいひょうじする] /(exp,vs-i) (comp) to maximize a window/
ウィンドウアクセラレータボード /(exp) (comp) Windows accelerator board/
ウィンドウシステム /(n) (comp) window system/
ウィンドウショッピング /(n,vs) window-gazing window-shopping/
ウィンドウズ /(n) (comp) Windows (Microsoft operating system)/
ウィンドウズアクセラレータ /(n) (comp) Windows accelerator/
ウィンドウズエックスピー /(n) (comp) Windows XP/
ウィンドウズエヌティー /(n) (comp) WindowsNT/
ウィンドウズキュージューゴ /(n) (comp) Windows95/
ウィンドウズキュージューハチ /(n) (comp) Windows98/
ウィンドウズサンテンイチ /(n) (comp) Windows3.1/
ウィンドウズニセン /(n) (comp) Windows2000/
ウィンドウズミー /(n) (comp) WindowsMe/
ウィンドウソフトウェア /(n) (comp) windowing software/
ウィンドウディスプレイ /(n) window display/
ウィンドウビューイング変換 [ウィンドウビューイングへんかん] /(n) (comp) normalization transformation/Viewing transformation/window-to-viewport transformation/
ウィンドウビューポート変換 [ウィンドウビューポートへんかん] /(n) (comp) window/viewport transformation/viewing transformation/
ウィンドウマネージャ /(n) (comp) window manager/
ウィンドウ下限 [ウィンドウかげん] /(n) (comp) lower window edge/
ウィンドウ環境 [ウィンドウかんきょう] /(n) (comp) windowing environment/
ウィンドウ上限 [ウィンドウじょうげん] /(n) (comp) upper window edge/
ウィンドウ情報 [ウィンドウじょうほう] /(n) (comp) window information/
ウィンドオーケストラ /(n) wind band (wasei: wind orchestra)/symphonic band/
ウィンドクラスト /(n) windcrust/crust formed on snow by strong wind/
ウィンドサーフィン /(n) windsurfing/
ウィンドシアー /(n) wind shear/
ウィンドブレーカー /(n) windbreaker/jacket/
ウィンドミル /(n) windmill/
ウィンドローズ /(n) wind rose/
ウィンナーシュニッツェル /(n) Wiener schnitzel/
ウィンビフ /(n) (comp) Winbiff/
ウィンブイエヌ /(n) (comp) WinVN/
ウィンブルドン /(n) Wimbledon/
ウィンヘック /(n) (comp) WinHEC/
ウイ /(int) yes (fre: oui)/
ウイーク /(n) (1) week/(2) weak/
ウイークエンド /(n) weekend/(P)/
ウイークエンドカーペンター /(n) weekend carpenter/
ウイークエンドファーザー /(n) weekend father/
ウイークエンドペインター /(n) weekend painter/
ウイークデー /(n) weekday/
ウイークデイ /(n) weekday/
ウイークボソン /(n) weak boson/
ウイークポイント /(n) weak point/
ウイークリー /(n,adv) weekly/
ウイービング /(n,vs) weaving/
ウイグル /(n) (uk) Uighur (Turkic people and language in NW China)/Uygur/
ウイグル語 [ウイグルご] /(n) Uighur language (Uigur, Uygur)/
ウイザード /(n) wizard/
ウイスカー /(n) whisker/
ウイスキ /(n) whisky/whiskey/
ウイスキー /(n) whisky/whiskey/(P)/
ウイスキーサウー /(n) whisky sour/whiskey sour/
ウイスキーボンボン /(n) whisky bonbon (fre:)/whiskey bonbon/liqueur candy/
ウイスケ /(n) whisky/whiskey/
ウイック /(n) wick/
ウイック回転 [ウイックかいてん] /(n) (math) Wick rotation/
ウイッグ /(n) wig/
ウイッチ /(n) witch/
ウイット /(n) wit/
ウイドー /(n) widow/
ウイドウ /(n) widow/
ウイナー /(n) winner/
ウイナーテイクオール /(n) winner-take-all/
ウイニング /(n) winning/
ウイニングショット /(n) winning shot (tennis, ball games)/
ウイニングボール /(n) winning ball/
ウイニングポスト /(n) winning post/
ウイニングラン /(n) winning run/
ウイリー /(n) wheelie/
ウイルス /(n) (1) virus (lat:, ger:)/(adj-no) (2) viral/(P)/
ウイルスを排除する [ウイルスをはいじょする] /(exp,vs-i) (1) to fight off a virus/(2) (comp) to screen out computer viruses/
ウイルスシグネチャ /(n) (comp) virus signature/
ウイルススキャンＡＰＩ [ウイルススキャンエーピーアイ] /(n) (comp) virus scanning API/
ウイルススキャンをする /(exp,vs-i) (comp) to run a virus scan program/
ウイルスチェッカ /(n) (comp) virus checker/
ウイルスチェック /(n) (comp) virus check/
ウイルスチェックソフトウェア /(n) (comp) virus checker software/
ウイルス学 [ウイルスがく] /(n) virology/
ウイルス監視機能 [ウイルスかんしきのう] /(n) (comp) virus protection/
ウイルス警報 [ウイルスけいほう] /(n) (comp) virus alert/
ウイルス検出ソフトウェア [ウイルスけんしゅつソフトウェア] /(n) (comp) virus detection software/
ウイルス性肝炎 [ウイルスせいかんえん] /(n) viral hepatitis/
ウイルス性疾患 [ウイルスせいしっかん] /(n) viral disease/
ウイルス性出血熱 [ウイルスせいしゅっけつねつ] /(n) viral hemorrhagic fever/
ウイルス性脳炎 [ウイルスせいのうえん] /(n) viral encephalitis/
ウイルス病 [ウイルスびょう] /(n) virus disease/viral disease/
ウイルス防衛用ソフト [ウイルスぼうえいようソフト] /(n) (comp) virus detection software/
ウイルス防止 [ウイルスぼうし] /(n) (comp) virus check/
ウイロイド /(n) viroid/
ウインカー /(n) (1) Winker (automobile)/(2) (car) blinker/(car) turning indicator/(P)/
ウインク /(n,vs) wink/(P)/
ウイング /(n) wing/(P)/
ウイングカラー /(n) wing collar/
ウイングチップ /(n) wing tip/
ウイングバック /(n) wingback/
ウイングポンプ /(n) wing pump/
ウインザーチェア /(n) Windsor char/
ウインター /(n) winter/
ウインタースポーツ /(n) winter sports/(P)/
ウインターリゾート /(n) winter resort/
ウインチ /(n) winch/
ウインド /(n) wind/(P)/
ウインドー /(n) (1) (comp) window/(2) window (shop display)/
ウインドーショッピング /(n,vs) window-gazing window-shopping/
ウインドーディスプレー /(n) window display/
ウインドードレッシング /(n) window dressing/
ウインドーペーン /(n) windowpane/
ウインドウ /(n) (1) (comp) window/(2) window (shop display)/(P)/
ウインドウズ /(n) (comp) Windows (Microsoft operating system)/
ウインドウメニュー /(n) (comp) window menu/
ウインドクラスト /(n) windcrust/crust formed on snow by strong wind/
ウインドサーファー /(n) windsurfer/
ウインドサーフィン /(n) windsurfing/
ウインドシールドワイパー /(n) windshield wiper/windscreen wiper/
ウインドフォール /(n) windfall/
ウインドブレーカー /(n) windbreaker/jacket/
ウインドミル /(n) windmill/
ウインドヤッケ /(n) windjacket (ger: Windjacke)/
ウインドラス /(n) windlass/
ウインドローズ /(n) wind rose/
ウインナ /(n) Wiener/Viennese/
ウインナーソーセージ /(n) Vienna sausage/
ウインナコーヒー /(n) Vienna coffee/
ウインナソーセージ /(n) Vienna sausage/
ウインナワルツ /(n) Viennese waltz (wasei: Vienna waltz)/
ウインブルドン /(n) Wimbledon/
ウェー /(n) way/(P)/
ウェーター /(n) waiter/
ウェート /(n) (1) wait/(2) weight/
ウェートリフティング /(n) weight lifting/
ウェートレス /(n) waitress/
ウェーバ /(n) weber/
ウェーバー /(n) (1) waiver/(2) weber (Wb) (unit of magnetic flux)/
ウェーバーの法則 [ウェーバーのほうそく] /(n) Weber's law/
ウェーバーフェヒナーの法則 [ウェーバーフェヒナーのほうそく] /(n) Weber-Fechner law/
ウェーブ /(n,vs) (1) wave (on water)/(2) wave (electromagnetic, sound, etc.)/(3) wavy hairstyle/(4) audience wave/the wave/(n) (5) (comp) WAVeform audio format/WAV/
ウェーブフロント /(n) wavefront/
ウェーブレット /(n) wavelet (physics)/
ウェールズ /(n) Wales/(P)/
ウェールズ語 [ウェールズご] /(n) Welsh (language)/
ウェア /(n,suf) (1) -ware/(2) -wear (clothing)/(sports) wear/
ウェアウルフ /(n) werewolf/
ウェアハウス /(n) warehouse/
ウェアラブルパソコン /(n) (comp) wearable personal computer/
ウェイ /(n) way/
ウェイジ /(n) wage/
ウェイジドリフト /(n) wage drift/
ウェイズ /(n) (comp) WAIS/
ウェイタ /(n) waiter/
ウェイター /(n) waiter/
ウェイト /(n) (1) wait/(2) weight/(P)/
ウェイトリフティング /(n) weight lifting/
ウェイトレス /(n) waitress/(P)/
ウェイト状態 [ウェイトじょうたい] /(n) (comp) wait state/
ウェイハー /(n) wafer/
ウェイファー /(n) wafer/
ウェイブ /(n,vs) (1) wave (on water)/(2) wave (electromagnetic, sound, etc.)/(3) wavy hairstyle/(4) audience wave/the wave/(n) (5) (comp) WAVeform audio format/WAV/
ウェイン /(n,vs) wane/
ウェザ /(n) weather/
ウェザー /(n) weather/
ウェス /(n) rag (for wiping)/waste (cloth)/
ウェスタ /(n) Vesta (Roman goddess of hearth, home and family)/
ウェスタン /(n) Western/
ウェスタン・ウォビゴン /(n) western wobbegon (Orectolobus hutchinsi, species of carpet shark from Western Australia)/
ウェスタンウォビゴン /(n) western wobbegon (Orectolobus hutchinsi, species of carpet shark from Western Australia)/
ウェスタンキングラス /(n) Western king wrasse (Coris auricularis)/
ウェスタングリップ /(n) Western grip (tennis)/
ウェスト /(n) (1) waist/(2) west/(n,vs) (3) waste/(P)/
ウェストオーストラリアンクロミス /(n) West Australian chromis (Chromis westaustralis)/
ウェストオーストラリアンバタフライフィッシュ /(n) West Australian butterflyfish (Chaetodon assarius)/Assarius butterflyfish/Western butterflyfish/
ウェストコート /(n) waistcoat/
ウェストニッパー /(n) waist nipper/
ウェストバージニア /(n) West Virginia/
ウェストボール /(n) waste ball (baseball)/taking a pitch/
ウェストポーチ /(n) waist pouch/waist bag/
ウェストミンスター憲章 [ウェストミンスターけんしょう] /(n) Statute of Westminster (1931)/
ウェストライン /(n) waistline/
ウェッジ /(n) wedge/
ウェッジソール /(n) wedge sole/
ウェッジヒール /(n) wedge heel/wedgie/
ウェッディング /(n) wedding/
ウェッデルアザラシ /(n) (uk) Weddell seal (Leptonychotes weddellii)/
ウェッデル海豹 [ウェッデルあざらし] /(n) (uk) Weddell seal (Leptonychotes weddellii)/
ウェット /(adj-na,n) wet/
ウェットスーツ /(n) wet suit/
ウェットストーン /(n) (comp) Whetstone/
ウェットティッシュ /(n) wet wipes/moist towelette/baby wipes/
ウェットフライ /(n) wet fly/
ウェッブ /(n,adj-no) (1) web/(2) (comp) World Wide Web/WWW/Web/
ウェディング /(n) wedding/
ウェディングケーキ /(n) wedding cake/
ウェディングドレス /(n) wedding dress/(P)/
ウェディングブルー /(n) pre-nuptial doubts (wasei: wedding blue)/
ウェディングベール /(n) wedding veil/
ウェディングベル /(n) wedding bell/
ウェディングマーチ /(n) wedding march/
ウェディングリング /(n) wedding ring/
ウェヌス /(n) Venus/
ウェハ /(n) wafer/
ウェハー /(n) wafer/
ウェファ /(n) wafer/
ウェファース /(n) wafers/
ウェブ /(n,adj-no) (1) web/(2) (comp) World Wide Web/WWW/Web/(P)/
ウェブアーカイブ /(n) (comp) Web archive/
ウェブアドレス /(n) (comp) Web address/
ウェブアプリケーション /(n) (comp) web application/
ウェブエクスプローラ /(n) (comp) Web Explorer/
ウェブカム /(n) webcam/
ウェブカメラ /(n) (comp) web camera/webcam/
ウェブサーバ /(n) (comp) Web server/
ウェブサーバー /(n) (comp) Web server/
ウェブサービス /(n) web service/web services/
ウェブサーファー /(n) (comp) Web surfer/
ウェブサイト /(n) (comp) web site/website/(P)/
ウェブジン /(n) (comp) WebZine/
ウェブティービー /(n) (comp) WebTV/
ウェブテキスト /(n) (comp) Web text/text from the Web/
ウェブデービー /(n) (comp) WebDB/
ウェブデザイナ /(n) (comp) web designer/
ウェブデザイン /(n) web design/
ウェブデュー /(n) (comp) WebdeW/
ウェブトラフィック /(n) web traffic/
ウェブフォーム /(n) web form/
ウェブブラウザ /(n) (comp) web browser/web-browsing software/
ウェブブラウザー /(n) (comp) web browser/web-browsing software/
ウェブベース企業管理 [ウェブベースきぎょうかんり] /(n) (comp) Web-Based Enterprise Management/WBEM/
ウェブページ /(n) (comp) Web page/(P)/
ウェブページテキスト /(n) (comp) Web-page text/
ウェブマスター /(n) (comp) Webmaster/
ウェブログ /(n) weblog/blog/(P)/
ウェブ検索 [ウェブけんさく] /(n) web search/
ウェブ上 [ウェブじょう] /(adv) over the Web/
ウェブ拍手 [ウェブはくしゅ] /(n) system for showing appreciation to the author of a web-site (lit: web-applause)/virtual applause/
ウェポン /(n) weapon/
ウェルウィッチア /(n) welwitschia/
ウェルカム /(n) welcome/(P)/
ウェルカムボード /(n) welcome board (e.g. placed outside wedding reception to greet guests, and confirm location)/
ウェルシュコーギー /(n) Welsh corgi/
ウェルダン /(n) well-done/
ウェルディングステーション /(n) welding station/
ウェルニッケ失語症 [ウェルニッケしつごしょう] /(n) Wernicke's aphasia/
ウェルニッケ中枢 [ウェルニッケちゅうすう] /(n) Wernicke's area/
ウェルニッケ領 [ウェルニッケりょう] /(n) (obsc) Wernicke's area/
ウェルニッケ領域 [ウェルニッケりょういき] /(n) (obsc) Wernicke's area/
ウェルネス /(n) wellness/
ウェルプ /(n) whelp/
ウエー /(n) way/
ウエーター /(n) waiter/
ウエーティング /(n) (abbr) waiting game/
ウエーティングサークル /(n) waiting circle (baseball)/on-deck batter's circle/
ウエーティングシステム /(n) waiting system/
ウエーティングルーム /(n) waiting room/
ウエーデルン /(n) wedeling (skiing term) (ger: Wedeln)/
ウエート /(n) (1) wait/(2) weight/
ウエートトレーニング /(n) weight training/
ウエートリフティング /(n) weight lifting/
ウエートレス /(n) waitress/
ウエーバー /(n) (1) waiver/(2) weber (Wb) (unit of magnetic flux)/
ウエーファー /(n) wafer/
ウエーブ /(n,vs) (1) wave (on water)/(2) wave (electromagnetic, sound, etc.)/(3) wavy hairstyle/(4) audience wave/the wave/(n) (5) (comp) WAVeform audio format/WAV/(P)/
ウエーブフロント /(n) wave-front/
ウエア /(n,suf) (1) -ware/(2) -wear (clothing)/(sports) wear/(P)/
ウエアインジケーター /(n) wear indicator/
ウエアハウス /(n) warehouse/
ウエアハウスストア /(n) warehouse store/
ウエイター /(n) waiter/
ウエイト /(n) (1) wait/(2) weight/(P)/
ウエイトコントロール /(n) weight control/
ウエイトトレーニング /(n) weight training/
ウエイトリフティング /(n) weight lifting/
ウエイトレス /(n) waitress/
ウエザー /(n) weather/
ウエザーコック /(n) weathercock/
ウエザーマーチャンダイジング /(n) weather merchandising/
ウエス /(n) rag (for wiping)/waste (cloth)/
ウエスタン /(n) Western/(P)/
ウエスタングリップ /(n) Western grip (tennis)/
ウエスタンスイング /(n) western swing/
ウエスタンデジタル /(n) (comp) WesternDigital/
ウエスタンミュージック /(n) Western music/
ウエスタンリーグ /(n) Western league/
ウエスティングハウス /(n) Westinghouse/
ウエスト /(n) (1) waist/(2) west/(n,vs) (3) waste/(P)/
ウエストアフリカンスペードフィッシュ /(n) West African spadefish (Chaetodipterus lippei, species of Eastern Atlantic spadefish found from Senegal to Angola)/
ウエストエンド /(n) West End/
ウエストコースト /(n) West Coast/
ウエストコート /(n) waistcoat/
ウエストサイド /(n) West Side/
ウエストナイルウイルス /(n) West Nile virus/
ウエストナイル熱 [ウエストナイルねつ] /(n) West Nile fever/
ウエストニッパー /(n) waist nipper/
ウエストバッグ /(n) waist pouch/waist bag/
ウエストボール /(n) waste ball (baseball)/taking a pitch/
ウエストポイント /(n) West Point/
ウエストモール /(n) weatherstrip molding/weatherstrip moulding/
ウエストライン /(n) waistline/
ウエッジ /(n) wedge/
ウエッジソール /(n) wedge sole/
ウエッディング /(n) wedding/
ウエット /(adj-na,n) wet/(P)/
ウエットカット /(n) wet cut/
ウエットクリーニング /(n) wet cleaning/
ウエットコア /(n) wet core/
ウエットスーツ /(n) wet suit/
ウエットフライ /(n) wet fly/
ウエディング /(n) wedding/
ウエディングケーキ /(n) wedding cake/
ウエディングドレス /(n) wedding dress/(P)/
ウエディングベール /(n) wedding veil/
ウエディングベル /(n) wedding bell/
ウエディングマーチ /(n) wedding march/
ウエディングリング /(n) wedding ring/
ウエハー /(n) wafer/
ウエハース /(n) wafers/
ウエハスケールインテグレーション /(n) (comp) wafer-scale integration/
ウエブ /(n,adj-no) (1) web/(2) (comp) World Wide Web/WWW/Web/
ウエブサイト /(n) (comp) web site/website/
ウエブマスター /(n) (comp) Webmaster/
ウエポン /(n) weapon/
ウエルカム /(n) welcome/(P)/
ウエルカムドリンク /(n) free drink served to hotel guests upon arrival (from welcome drink)/
ウエルカムプラン２１ [ウエルカムプランにじゅういち] /(n) Welcome Plan 21/
ウエルター級 [ウエルターきゅう] /(n) welterweight class (boxing)/
ウエルダン /(n) well-done/
ウエルネス /(n) wellness/
ウエンズデー /(n) Wednesday/
ウォーカー /(n) walker/
ウォーカソン /(n) walkathon/
ウォーキートーキー /(n) walkie-talkie/
ウォーキールッキー /(n) walkie-lookie/
ウォーキング /(n) walking/
ウォーキングシューズ /(n) walking shoes/
ウォーキングディクショナリー /(n) walking dictionary/
ウォーク /(n) walk/
ウォークインクロゼット /(n) walkin closet/
ウォークスルー /(n) (comp) (structured) walk through/
ウォークマン /(n) Walkman/(P)/
ウォークライ /(n) war cry/
ウォークラリー /(n) walk rally/
ウォーゲーム /(n) war game/
ウォーサ /(n) (comp) WOSA/
ウォータ /(n) water/
ウォーター /(n) water/
ウォーターカラー /(n) watercolor/watercolour/
ウォータークーラー /(n) watercooler/water cooler/
ウォータークレス /(n) watercress/
ウォータークロゼット /(n) water closet/
ウォーターゲート /(n) Watergate/
ウォーターゲート事件 [ウォーターゲートじけん] /(n) Watergate scandal/
ウォーターシュート /(n) water chute/
ウォータージャケット /(n) water jacket/
ウォータースパニエル /(n) water spaniel/
ウォータースライダー /(n) water slide/water slider/
ウォータータイト /(n) watertight/
ウォーターハザード /(n) water hazard/
ウォーターフォール /(n) waterfall/
ウォーターフロント /(n) waterfront/
ウォータープルーフ /(n) waterproof/
ウォーターベッド /(n) waterbed/
ウォーターボーディング /(n) waterboarding/
ウォーターポロ /(n) water polo/
ウォーターメロン /(n) watermelon/
ウォーターヤム /(n) (obsc) water yam (Dioscorea alata)/winged yam/purple yam/
ウォータフォール /(n) waterfall/
ウォーダイヤラ /(n) (comp) war dialer/
ウォーダイヤリング /(n) (comp) war dialing/
ウォードライビング /(n) (comp) war driving/
ウォードローブ /(n) wardrobe/
ウォードロウブ /(n) wardrobe/
ウォーニング /(n) warning/
ウォーニングランプ /(n) warning lamp/
ウォーホール型ワーム [ウォーホールかたワーム] /(n) (comp) Warhol worm/
ウォーマー /(n) warmer/
ウォーミング /(n) warming/
ウォーミングアップ /(n,vs) warming-up/
ウォーム /(n) (1) worm/(2) warm/
ウォームアップ /(n,vs) warm-up/
ウォームギア /(n) worm gear/
ウォームスタート /(n) (comp) warm start/
ウォームビズ /(n) WARM BIZ (Japanese government campaign encouraging companies to set their heater thermostats to 20 degrees Celsius over the winter)/
ウォームブート /(n) (comp) warm boot/
ウォーム歯車 [ウォームはぐるま] /(n) worm gear/
ウォーラント /(n) warrant/
ウォール /(n) wall/
ウォールアイ /(n) walleye (Sander vitreus)/
ウォールサーキットブレーカ /(n) (comp) wall circuit breaker/
ウォールツ /(n) waltz/
ウォールナット /(n) walnut/
ウォールフラワー /(n) wallflower/
ウォールペーパー /(n) (comp) wall paper/
ウォール街 [ウォールがい] /(n) Wall Street/(P)/
ウォーレス線 [ウォーレスせん] /(n) Wallace's line (hypothetical line separating the Oriental and Australian zoogeographical regions)/
ウォシュレット /(n) toilet seat with bidet functions (wasei: wash toilet)/
ウォストーク /(n) Vostok (rus:)/
ウォッカ /(n) vodka (rus:)/(P)/
ウォッシャー /(n) washer/
ウォッシャブル /(adj-f) washable/
ウォッシュアンドウェア /(n) wash-and-wear/
ウォッシュアンドウエア /(n) wash-and-wear/
ウォッシュレット /(n) toilet seat with bidet functions (wasei: wash toilet)/
ウォッチ /(n,vs) (1) watch (timepiece)/(2) watch (turn to watch or guard something)/
ウォッチドッグ /(n) watchdog/surveillance/
ウォッチドッグタイマ /(n) (comp) watchdog timer/
ウォッチドッグタイマー /(n) (comp) watchdog timer/
ウォッチドッグドライバ /(n) (comp) watchdog driver/
ウォッチマン /(n) watchman/
ウォッチャー /(n) (comp) (industry) watcher/analyst/
ウォッチング /(n) watching/(P)/
ウォツカ /(n) vodka (rus:)/
ウォトカ /(n) vodka (rus:)/
ウォビゴン /(n) wobbegong (eleven species of carpet shark in the family Orectolobidae)/
ウォラント /(n) warrant/
ウォルナット /(n) walnut/
ウォルフ /(n) wolf/
ウォルフラム /(n) tungsten (ger: Wolfram)/wolfram/
ウォレット /(n) wallet/
ウォレマイパイン /(n) Wollemi pine (Wollemia nobilis)/
ウォン /(n) won (unit of Korean currency) (kor:)/(P)/
ウォンテット /(n) wanted/
ウォンテッド /(adj-no) wanted/
ウォンド /(n) (1) wand/
ウォンバット /(n) wombat/
ウオー /(n) war/
ウオーカー /(n) walker/
ウオーキング /(n) walking/
ウオーキングシューズ /(n) walking shoes/
ウオーキングディクショナリー /(n) walking dictionary/
ウオーク /(n) walk/
ウオークインクロゼット /(n) walk-in closet/
ウオークライ /(n) war cry/
ウオーター /(n) water/
ウオータークーラー /(n) watercooler/water cooler/
ウオータークレス /(n) watercress/
ウオータークロゼット /(n) water closet/
ウオーターシュート /(n) water chute/
ウオータージェット /(n) waterjet/
ウオータースポット /(n) water spot/
ウオータースライダー /(n) water slide/water slider/
ウオーターハザード /(n) water hazard/
ウオーターバス /(n) water bath/
ウオーターフロント /(n) waterfront/
ウオータープルーフ /(n) waterproof/
ウオーターポロ /(n) water polo/
ウオーデン /(n) warden/
ウオーニング /(n) warning/
ウオーマー /(n) warmer/
ウオーミングアップ /(n,vs) warming-up/
ウオームアップ /(n,vs) warm-up/
ウオームカラー /(n) warm color/
ウオームギア /(n) worm gear/
ウオール /(n) wall/
ウオッカ /(n) vodka (rus:)/
ウオッシャブル /(adj-no) washable/
ウオッシュ /(n,vs) wash/
ウオッシュアンドウエア /(n) wash-and-wear/
ウオッチ /(n,vs) (1) watch (timepiece)/(2) watch (turn to watch or guard something)/
ウオッチポケット /(n) watch pocket/
ウオッチャー /(n) watcher/
ウオッチング /(n) watching/
ウオツカ /(n) vodka (rus:)/
ウオノエ科 [ウオノエか] /(n) Cymothoidae (family of isopods)/
ウオルナット /(n) walnut/
ウオン /(n) won (unit of Korean currency) (kor:)/(P)/
ウガンダ /(n,adj-no) Uganda/
ウキウキ /(adv,adv-to,vs) (uk) cheerful/buoyant/cheery/lighthearted/
ウキゴリ /(n) (1) (uk) common freshwater goby (Gymnogobius urotaenia)/(2) floating goby (Gymnogobius petschiliensis)/(3) Gymnogobius opperiens (fish)/(4) isaza goby (Gymnogobius isaza)/
ウキヤガラ /(n) (uk) Scirpus yagara (species of club-rush)/
ウクライナ /(n) Ukraine/(P)/
ウクライナヤツメ属 [ウクライナヤツメぞく] /(n) Eudontomyzon (genus of lamprey in the family Petromyzontidae)/
ウクレレ /(n) ukulele/(P)/
ウグイ /(n) (uk) Japanese dace (Tribolodon hakonensis)/
ウグイス /(n) (1) (uk) Japanese bush warbler/Japanese nightingale (Cettia diphone)/(2) (abbr) greenish brown/(n-pref) (3) having a beautiful voice/
ウグイスガイ /(n) (uk) Pteria brevialata (species of wing oyster)/
ウケクチウグイ /(n) (uk) Tribolodon nakamurai (species of cyprinid)/
ウコギ /(n) (uk) fiveleaf aralia (Acanthopanax sieboldianus)/
ウコギ科 [ウコギか] /(n) Araliaceae (plant family)/aralia or ginseng/
ウコン /(n) (uk) turmeric (Curcuma domestica)/
ウサギ /(n) (uk) rabbit/hare/cony/
ウサギ科 [ウサギか] /(n) Leporidae/Leporids/
ウサギ跳び [ウサギとび] /(n,vs) jumping along in a squatting position/rabbit jumping/
ウシアブ /(n) (uk) Tabanus trigonus (species of horsefly)/
ウシエビ /(n) (uk) giant tiger prawn (Penaeus monodon)/black tiger prawn/
ウシガエル /(n) (uk) American bullfrog (Lithobates catesbeianus)/
ウシザメ /(n) (uk) bull shark (Carcharhinus leucas)/
ウシツツキ /(n) (uk) oxpecker/
ウシノケグサ /(n) (uk) sheep's fescue (Festuca ovina)/
ウシバエ /(n) (uk) ox warble fly (Hypoderma bovis)/
ウスケ /(n) whisky/whiskey/
ウスターソース /(n) Worcester (Worcestershire) sauce/
ウスバカゲロウ /(n) (uk) ant lion (esp. species Hagenomyia micans)/
ウスバハギ /(n) (uk) unicorn leatherjacket (Aluterus monoceros)/
ウスベニタチアオイ /(n) (uk) common marshmallow (Althaea officinalis)/marsh mallow/
ウスユキソウ /(n) (uk) Leontopodium japonicum (species of perennial closely related to edelweiss)/
ウスユキバト /(n) (uk) diamond dove (Geopelia cuneata)/
ウズベキスタン /(n) Uzbekistan/
ウズラ /(n) (1) (uk) quail/(2) Japanese quail (Coturnix japonica)/
ウズラクイナ /(n) (uk) corn crake/corncrake/land rail (Crex crex)/
ウソ /(n) (uk) Eurasian bullfinch (Pyrrhula pyrrhula)/Japanese bullfinch/
ウゾ /(n) ouzo (gre:)/
ウタリ /(n) (1) human (in Ainu) (ain:)/one's fellow man/kin/comrade/(2) self-referential term used by the Ainu about their people/
ウダイカンバ /(n) (uk) monarch birch (Betula maximowicziana)/Japanese birch/
ウチナーグチ /(n) (uk) words and phrases only used in Okinawa/Okinawa dialect/
ウチワエビ /(n) (uk) fan lobster (Ibacus spp., esp. the Japanese fan lobster, Ibacus ciliatus)/sand crayfish/
ウチワシュモクザメ /(n) (uk) bonnethead (Sphyrna tiburo, species of hammerhead shark found in the Western Hemisphere)/
ウチワヤンマ /(n) (uk) Sinictinogomphus clavatus (species of clubtail dragonfly)/
ウッ /(int) oof/ough/ulp/
ウッズクロミス /(n) Wood's chromis (Chromis woodsi)/
ウッディー /(n) woody/
ウッド /(n) wood/(P)/
ウッドカーペット /(n) wood carpet/fabric (or linoleum) backed wooden floor covering/
ウッドクラフト /(n) woodcraft/
ウッドクリップ /(n) wooden clip/wooden clothespin/
ウッドストックフェスティバル /(n) Woodstock Music and Art Festival (1969)/
ウッドチップ /(n) woodchip/
ウッドチップコース /(n) woodchip course/
ウッドチャック /(n) woodchuck/
ウッドパルプ /(n) woodpulp/
ウッドブロック /(n) woodblock (musical instrument)/
ウッドペッカー /(n) woodpecker/
ウッドメタル /(n) Wood's metal/
ウツボ /(n) (uk) moray (eel) (Gymnothorax kidako)/muraenid/
ウツボグサ /(n) (uk) common self-heal (Prunella vulgaris subsp. asiatica)/common selfheal/
ウド /(n) (uk) udo (plant related to ginseng, used in medicine and cooking) (Aralia cordata)/
ウドムルト語 [ウドムルトご] /(n) Udmurt (language)/
ウドンコ病 [ウドンコびょう] /(n) powdery mildew/
ウニ /(n,adj-no) sea urchin/sea urchin eggs/
ウネウ /(n) fur seal (esp. the northern fur seal, Callorhinus ursinus) (ain:)/
ウバーレ /(n) uvala (composite karst depression) (ger: Uvale)/
ウバウオ /(n) (uk) Aspasma minima (species of clingfish)/
ウバガイ /(n) (uk) Sakhalin surf clam (Pseudocardium sachalinense)/
ウバザメ /(n) (uk) basking shark (Cetorhinus maximus)/
ウバザメ科 [ウバザメか] /(n) Cetorhinidae (family whose only member is the basking shark)/
ウバザメ属 [ウバザメぞく] /(n) Cetorhinus (sole genus of the only species of basking shark in the family Cetorhinidae)/
ウバタマ /(n,adj-no) (1) jet black/pitch dark/(n) (2) (uk) peyote (Lophophora williamsii)/mescaline/
ウバヒガン /(n) (uk) (obsc) double weeping rosebud cherry (Prunus pendula)/
ウバメガシ /(n) (uk) ubame oak (Quercus phillyraeoides)/
ウパニシャッド /(n) Upanishad (sacred Hindu treatises) (san: Upanisad)/
ウフッ /(n,adv-to) chuckle/chuckling/
ウベ /(n) water yam (Dioscorea alata) (fil: ube)/winged yam/purple yam/
ウマゴヤシ /(n) (1) toothed medick (Medicago polymorpha)/hairy medick/bur clover/(2) (col) white clover (Trifolium repens)/
ウマン /(n,adj-no) woman/
ウミイグアナ /(n) (uk) marine iguana (Amblyrhynchus cristatus)/
ウミウ /(n) (uk) Japanese cormorant (Phalacrocorax capillatus)/Temminck's cormorant/
ウミウシ /(n) (uk) sea slug (various orthogastropod species, esp. of order Nudibranchia)/nudibranch/
ウミエラ /(n) (uk) sea pen (any coelenterate of the family Pennatulidae or related families)/sea feather/
ウミガラス /(n) (uk) common murre/common guillemot (Uria aalge)/
ウミグモ類 [ウミグモるい] /(n) sea spiders (Pycnogonida spp.)/
ウミケムシ /(n) (uk) Chloeia flava (species of bristle worm)/
ウミサソリ /(n) (uk) eurypterid/
ウミザリガニ /(n) (uk) (obsc) lobster/
ウミスズメ /(n) (1) (uk) murrelet (esp. the ancient murrelet, Synthliboramphus antiquus)/(2) roundbelly cowfish (Lactoria diaphana)/
ウミタケガイ /(n) (uk) dilate piddock (Barnea dilatata)/
ウミタナゴ /(n) (uk) sea chub (Ditrema temminckii temminckii)/
ウミツバメ /(n) (uk) storm petrel (any bird of family Hydrobatidae)/
ウミヅキチョウチョウウオ /(n) bluelashed butterflyfish (Chaetodon bennetti)/Bennett's butterflyfish/
ウミテング /(n) (uk) short dragonfish (Eurypegasus draconis)/
ウミニナ /(n) (uk) many-formed cerith (Batillaria multiformis)/
ウミバト /(n) (uk) pigeon guillemot (Cepphus columba)/
ウミヒゴイ /(n) yellow striped goatfish (Parupeneus chrysopleuron)/
ウミヒゴイ属 [ウミヒゴイぞく] /(n) Parupeneus (genus of goatfishes of the family Mullidae)/
ウミヘビ /(n) (1) (uk) sea snake/(2) (uk) worm eel (Ophichthidae spp.)/snake eel/
ウミヤツメ /(n) sea lamprey (Petromyzon marinus)/
ウミヤツメ属 [ウミヤツメぞく] /(n) Petromyzon (genus of lamprey in the family Petromyzontidae)/
ウミユリ /(n) (uk) sea lily/crinoid/
ウミワニ /(n) (obsc) (uk) saltwater crocodile (Crocodylus porosus)/estuarine crocodile/
ウムラウト /(n) umlaut (ger:)/
ウムラウト符号 [ウムラウトふごう] /(n) umlaut/
ウメ /(n) (1) plum/Japanese apricot/prunus mume/(2) lowest (of a three-tier ranking system)/
ウメバチソウ /(n) (uk) marsh grass of Parnassus (Parnassia palustris)/
ウメモドキ /(n) (uk) Japanese winterberry/Ilex serrata/
ウラウズガイ /(n) (uk) Astralium haematragum (species of turban shell)/
ウラウチイソハゼ /(n) Eviota ocellifer (species of pygmy goby from the Ryukyu Islands, Japan)/
ウラウチフエダイ /(n) (uk) Papuan black snapper (Lutjanus goldiei)/
ウラウラ /(adv-to) (on-mim) gently and clearly shining (like the sun in springtime)/
ウラシマソウ /(n) (uk) Arisaema urashima (species of cobra lily)/
ウラシマチョウチョウウオ /(n) guyot butterflyfish (Prognathodes guyotensis)/
ウラシル /(n) uracil/
ウラジロノキ /(n) fern with white-backed leaves/sorbus japonica/
ウラニウム /(n) uranium (U) (ger: Uran)/(P)/
ウラヌス /(n) Uranus/
ウラノス /(n) Uranus/
ウラバナ /(n) story not generally known/inside story/the real story (behind something)/
ウラマー /(n) ulama (body of authoritative Muslim scholars) (ara:)/ulema/
ウラルアルタイ語族 [ウラルアルタイごぞく] /(n) (ling) Ural-Altaic/
ウラル語族 [ウラルごぞく] /(n) Uralic (family of languages)/
ウラン /(n) uranium (U) (ger: Uran)/(P)/
ウラン・ガラス /(n) uranium glass/
ウラン２３５ [ウランにひゃくさんじゅうご] /(n) uranium-235 (U-235)/
ウランガラス /(n) uranium glass/
ウラン鉛法 [ウランなまりほう] /(n) uranium-lead method/
ウラン系列 [ウランけいれつ] /(n) uranium series/
ウラン鉱 [ウランこう] /(n) uranium ore/
ウラン二三五 [ウランにひゃくさんじゅうご] /(n) uranium-235 (U-235)/
ウラン濃縮 [ウランのうしゅく] /(n) uranium enrichment/
ウリザネジョウチュウ /(n) (uk) dog tapeworm (Dipylidium caninum)/cucumber tapeworm/double-pore tapeworm/
ウリジン /(n) uridine/
ウリノキ /(n) alangium platanifolium var. trilobum/
ウリノキ科 [ウリノキか] /(n) Alangiaceae (plant family)/(common name) the Alangium family/
ウリハムシ /(n) (uk) cucurbit leaf beetle (Aulacophora femoralis)/
ウリバエ /(n) (uk) (obsc) cucurbit leaf beetle (Aulacophora femoralis)/
ウリミバエ /(n) (uk) melon fly (Bactrocera cucurbitae)/
ウリ専 [ウリせん] /(n) (1) male prostitute/rent boy/rentboy/(2) gay brothel/
ウルカヌス /(n) Vulcan (Roman god) (lat: Vulcanus)/
ウルガタ /(n) Vulgate (Catholic Latin bible) (lat:)/
ウルグアイ /(n) Uruguay/(P)/
ウルグアイラウンド /(n) Uruguay round/
ウルシオール /(n) urushiol/
ウルシ科 [ウルシか] /(n) Anacardiaceae (plant family)/(common name) the sumac family/
ウルツ鉱 [ウルツこう] /(n) wurtzite/
ウルティマ /(n) (comp) Ultima/
ウルトラ /(n) ultra/(P)/
ウルトラスカジー /(n) (comp) Ultla SCSI/
ウルトラスパーク /(n) (comp) UltraSPARC/
ウルトラナショナリズム /(n) ultranationalism/
ウルトラマリン /(n) ultramarine/
ウルトラモダン /(n) ultramodern/
ウルトラモバイルＰＣ [ウルトラモバイルピーシー] /(n) (comp) ultra-mobile PC/
ウルトラモンタニズム /(n) ultramontanism/
ウルドゥー語 [ウルドゥーご] /(n) Urdu (language)/
ウルフ /(n) wolf/(P)/
ウルフハウンド /(n) wolfhound/
ウルメ /(n) (uk) (abbr) round herring (Etrumeus teres)/
ウルメイワシ /(n) (uk) round herring (Etrumeus teres)/
ウレアーゼ /(n) urease/
ウレタン /(n) (1) urethane foam (ger: Urethan)/(2) polyurethane/
ウレタンゴム /(n) (abbr) polyurethane rubber (ger: Urethan, dut: gom)/
ウレタンフォーム /(n) Urethane foam/
ウレタン樹脂 [ウレタンじゅし] /(n) urethane resin/
ウロつく /(v5k,vi) (1) (uk) to loiter/to putter/to prowl/to wander aimlessly/to knock around/(2) to be confused from not knowing what to do/
ウロキナーゼ /(n) urokinase/
ウロコベニハゼ /(n) Emery's goby (Trimma emeryi)/
ウロハゼ /(n) (uk) Glossogobius olivaceus (species of goby)/
ウロビリノーゲン /(n) urobilinogen/
ウロビリノゲン /(n) urobilinogen/
ウロビリン /(n) urobilin/
ウロボロス /(n) uroboros/ouroboros (image of a serpent or dragon swallowing its own tail)/
ウロン酸 [ウロンさん] /(n) uronic acid/
ウワミズザクラ /(n) (uk) Japanese bird cherry (Prunus grayana)/Gray's bird cherry/Gray's chokecherry/
ウヰスキー /(n) whisky/whiskey/
ウヰスケ /(n) whisky/whiskey/
ウンウン /(int) uh-huh/sound indicating agreement/grunting or groaning sound/
ウンウンオクチウム /(n) ununoctium (Uuo)/
ウンウンクアジウム /(n) ununquadium (Uuq)/
ウンウンセプチウム /(n) Ununseptium (Uus)/
ウンウントリウム /(n) ununtrium (Uut)/
ウンウンビウム /(n) ununbium (Uub)/
ウンウンヘキシウム /(n) ununhexium (Uuh)/
ウンウンペンチウム /(n) ununpentium (Uup)/
ウンカ /(n) (uk) plant hopper (any insect of family Delphacidae)/leafhopper/
ウンシュウミカン /(n) satsuma mandarin (Citrus unshiu)/
ウンスンカルタ /(n) Edo-period Japanese card game (por: um sum carta)/
ウンタイ /(n) rape (seed oil plant, Brassica campestris)/Chinese colza/yuntai/
ウンダイ /(n) rape (seed oil plant, Brassica campestris)/Chinese colza/yuntai/
ウンディーネ /(n) undine/
ウンピョウ /(n) (uk) clouded leopard (Neofelis nebulosa)/
ウ音便 [ウおんびん] /(n) euphonic change wherein some mora ('ku', 'gu', 'hi', 'bi' and 'mi') are pronounced 'u'/
ウ冠 [ウかんむり] /(n) "roof" kanji radical at top (radical 40)/
エーアールジェイ /(n) (comp) ARJ/
エーアイエックス /(n) (comp) AIX/
エーアイエフ /(n) (comp) AIF/
エーアイエフエフ /(n) (comp) AIFF/
エーアイエムエム /(n) (comp) AIMM/
エーエスーピーアイ /(n) (comp) ASPI/
エーエスピー /(n) (comp) ASP/
エーエスヨンヒャク /(n) (comp) AS-400/
エーエヌエス /(n) (comp) ANS/
エーエフエス /(n) (comp) AFS/
エーエムーディー /(n) (comp) AMD/
エーエムディーケーシックス /(n) (comp) AMD-K6/
エーエムディーケーセブン /(n) (comp) AMD-K7/
エーエルユー /(n) (comp) ALU/
エーカー /(n) acre/
エークラス /(n) A class/
エーゲ文明 [エーゲぶんめい] /(n) Aegean civilization/
エーコッコシー /(adj-f) (ksb:) someone who is overly concerned with status. Can be used enviously with reference to someone of real accomplishment/
エーコン管 [エーコンかん] /(n) acorn tube/
エーシック /(n) (comp) ASIC/
エージ /(n) age/
エージェンシー /(n) agency/(P)/
エージェント /(n) agent/(P)/
エージェントの役割 [エージェントのやくわり] /(n) (comp) agent role/
エージェントオレンジ /(n) Agent Orange (dioxin-laden defoliant used during the Vietnam War)/
エージェント指向 [エージェントしこう] /(n) (comp) agent oriented/
エージグループ /(n) age-group/
エージシューター /(n) age shooter/
エージズム /(n) agism/ageism/
エージドビーフ /(n) aged beef/
エージレス /(adj-no) ageless/
エージング /(n) aging/ageing/
エージント /(n) (comp) agent/
エース /(n) ace/(P)/
エースアタッカー /(n) ace attacker/
エーススパイカー /(n) ace spiker/
エーティーアンドティー /(n) (comp) AT&T/
エーティーエー /(n) (comp) ATA/
エーティーコマンド /(n) (comp) AT command/
エーテル /(n) ether (dut:)/
エーテル結合 [エーテルけつごう] /(n) ether linkage/
エーディーオー /(n) (comp) ADO/
エーディーコンバーター /(n) A-D converter/
エーディージェイ /(n) (comp) ADJ/
エーディービー /(n) (comp) ADB/
エーディーピーシーエム /(n) (comp) ADPCM/
エーデルワイス /(n) alpine flower (ger: Edelweiss)/
エートゥビー /(n) (comp) A-to-B/
エートス /(n) ethos/
エービーイー /(n) (comp) ABE/
エービーシー /(n) alphabet/ABC/
エービー型 [エービーがた] /(n) type AB (blood, etc.)/
エーピーアイ /(n) (comp) API/
エーピーエル /(n) (comp) APL/
エーブイアイ /(n) (comp) AVI/
エープリル /(n) April/
エープリルフール /(n) April fool/April Fool's Day/April Fools' Day/
エーユーエックス /(n) (comp) A-UX/
エーリアン /(n) alien/
エール /(n) (1) yell/cheerleading shout/(2) ale/(P)/
エールフランス /(n) Air France/
エーログラム /(n) aerogram/aerogramme/
エーロゾル /(n) aerosol/
エー型 [エーがた] /(n) type A (blood, influenza, hepatitis, etc.)/
エー系 [エーけい] /(n,adj-no) (abbr) (sl) Akihabara style/nerdy/
エア /(n) air/(P)/
エアー /(n) air/(P)/
エアーエヌエフエス /(n) (comp) AIR NFS/
エアーパッキン /(n) plastic packing material with air bubbles (wasei: air packing)/bubble wrap/
エアーマネジメント /(n) air management/
エアウェー /(n) airway/
エアカーゴ /(n) air cargo/
エアカーテン /(n) air curtain/
エアガール /(n) air girl/stewardess/
エアガン /(n) air gun/
エアキャップ /(n) (1) plastic packing material with air bubbles (wasei: air cap)/bubble wrap/(2) cap on a tyre valve/(3) brand of lawn mower/
エアギター /(n) air guitar (imaginary instrument used when pretending to play the guitar)/
エアクッション /(n) air cushion/
エアクラフト /(n) aircraft/
エアクリーナー /(n) air cleaner/
エアコン /(n,adj-no) air-conditioner/air-conditioning/(P)/
エアコンディショナー /(n) air conditioner/
エアコンディショニング /(n) air-conditioning/
エアコンプレッサー /(n) air compressor/
エアサービス /(n) air service/
エアサイクルシステム /(n) air circulating system/
エアサス /(n) (abbr) air suspension/
エアサスペンション /(n) air suspension/
エアシック /(n) air sick/
エアシックネス /(n) airsickness/
エアシックバッグ /(n) airsick bag/
エアシップ /(n) airship/
エアシャトル /(n) air shuttle/
エアシューター /(n) pneumatic tube (wasei: air shooter)/
エアシュート /(n) air shoot/
エアシリンダ /(n) air cylinder/pneumatic cylinder/
エアステーション /(n) air station/
エアゾール /(n) aerosol/(P)/
エアターミナル /(n) air terminal/
エアタオル /(n) air towel/
エアダクト /(n) air duct/
エアダムチーズ /(n) Edam cheese/
エアチェック /(n) air check/
エアチャンバー /(n) air chamber/
エアドーム /(n) air dome/
エアドア /(n) air door/
エアハンマー /(n) air hammer/
エアバス /(n) airbus/
エアバッグ /(n) air bag/(P)/
エアパッド /(n) air pad/
エアピープル /(n) air people/
エアピストル /(n) air pistol/
エアフィールド /(n) airfield/
エアフィルタ /(n) air filter/
エアフィルター /(n) air filter/
エアフォース /(n) air force/
エアブラシ /(n) airbrush/
エアブリージングエンジン /(n) air breathing engine/
エアブレーキ /(n) air brake/
エアプランツ /(n) air plant (Tillandsia)/
エアページェント /(n) air pageant/
エアホール /(n) air hole/
エアホステス /(n) air hostess/stewardess/
エアボーン /(n) airborne/
エアポート /(n) airport/
エアポートタックス /(n) airport tax/
エアポケット /(n) air pocket/
エアポット /(n) air pot/
エアポンプ /(n) air pump/
エアマック /(n) (comp) AirMac/
エアマット /(n) (abbr) air mattress/
エアマネ /(n) (abbr) air management/
エアメール /(n) air mail/(P)/
エアモザイク /(n) (comp) Air Mosaic/
エアモニ /(n) (abbr) on-air monitor/
エアライト /(n) air right/
エアライフル /(n) air rifle/
エアライン /(n) airline/
エアリアル /(n) aerial/
エアリアルスキー /(n) aerial skiing/
エアレーション /(n) aeration/
エアレーションタンク /(n) aeration tank/
エアレション /(n,vs) aeration/
エアロ /(n) (abbr) aerobics/
エアログラム /(n) aerogram/aerogramme/
エアロゾル /(n) aerosol/
エアロダイナミックス /(n) aerodynamics/
エアロック /(n) air lock/
エアロノート /(n) aeronaut/
エアロバイク /(n) exercise bike (wasei: aero(bic) bike)/
エアロビ /(n) (abbr) aerobics/
エアロビクス /(n) aerobics/(P)/
エアロビサイズ /(n,vs) aerobicising/exercising with aerobics/
エアロビックダンシング /(n) aerobic dancing/
エアロビックフィットネス /(n) aerobic fitness/
エイ /(n) (uk) ray (fish)/stingray/
エイコサペンタエン酸 [エイコサペンタエンさん] /(n) eicosapentaenoic acid/EPA/
エイコンドライト /(n) achondrite/
エイジス /(n) (1) aegis (mythical shield)/(2) Aegis (system)/Aegis (missile guidance system)/
エイジス艦 [エイジスかん] /(n) Aegis ship/
エイジズム /(n) ageism/
エイジング /(n) aging/ageing/
エイズウイルス /(n) AIDS virus/
エイズワクチン /(n) AIDS vaccine/
エイダ /(n) (comp) Ada/
エイチエスブイ /(n) (comp) HSV/
エイチエムエー /(n) (comp) HMA/
エイチティーエムエル /(n) (comp) HTML/
エイチティーティーピーディー /(n) (comp) httpd/
エイチディー /(n) (comp) HD/
エイチディーエルシー /(n) (comp) HDLC/
エイチピーエフエス /(n) (comp) HPFS/
エイチピーユーエックス /(n) (comp) HP-UX/
エイティーン /(n) eighteen/
エイト /(n) eight/(P)/
エイトック /(n) (comp) ATOK (Advanced Technology Of Kana-kanji transfer)/
エイトビート /(n) eight beat/
エイド /(n) aid/
エイドス /(n) (1) form (in Aristotelian philosophy) (gre: eidos)/(2) idea (in Platonic philosophy)/
エイドリス /(n) (comp) EDLIS/
エイプリルフール /(n) April fool/April Fool's Day/April Fools' Day/(P)/
エイペック /(n) Asia-Pacific Economic Cooperation/APEC/
エイラクブカ /(n) Japanese topeshark (Hemitriakis japanica)/
エイラクブカ属 [エイラクブカぞく] /(n) Hemitriakis (genus of houndshark in the family Triakidae)/
エイランタイ /(n) (uk) (obsc) Iceland moss (Cetraria islandica)/Iceland lichen/
エイリアシング /(n) (comp) aliasing/
エイリアス /(n) alias/
エイリアン /(n) alien/(P)/
エウスタキオ管 [エウスタキオかん] /(n) Eustachian tube/
エウテュプローンのジレンマ /(n) Euthyphro dilemma/
エオアントロプス /(n) (obsc) Piltdown man (manufactured fossil of a fraudulent ape-human missing link, Eoanthropus dawsoni) (lat: Eoanthropus)/
エオシン /(n) eosine/
エオニズム /(n) (obsc) eonism/transvestism/
エオヒップス /(n) eohippus (lat:)/hyracotherium (earliest fossil ancestor of the horse)/
エオラプトル /(n) eoraptor (late-Triassic dinosaur; Eoraptor lunensis) (lat:)/
エオリア旋法 [エオリアせんぽう] /(n) Aeolian mode/
エオルス音 [エオルスおん] /(n) aeolian sound/eolian sound/aeolian tone/
エキウム /(n) echium (flower)/
エキサイティング /(adj-na,n) exciting/(P)/
エキサイティングゲーム /(n) exciting game/
エキサイト /(n,vs) excite/(P)/
エキササイズ /(n,vs) exercise/
エキササイズウォーキング /(n) exercise walking/
エキシビション /(n) exhibition/
エキシビションゲーム /(n) exhibition game or match/
エキジビション /(n) exhibition/
エキジビションゲーム /(n) exhibition game or match/
エキス /(n) (uk) (abbr) extract (esp. of food, fruit, etc.)/essence/(P)/
エキストラ /(n) extra/(P)/
エキストライニング /(n) extra inning/
エキストラクト /(n) extract (dut:)/
エキストラネット /(n) (comp) extra-net/
エキストラベッド /(n) extra bed/
エキストラホール /(n) extra hole (golf)/
エキスパート /(n) expert/(P)/
エキスパートシステム /(n) (comp) expert system/
エキスパンションキャビネットパネル /(n) (comp) expansion cabinet panel/
エキスパンションジョイント /(n) expansion joint/
エキスパンダー /(n) expander/
エキスパンドブック /(n) (comp) Expand Book/
エキスプレス /(n) express/(P)/
エキスプレッション /(n) expression/
エキスポ /(n) expo/exposition/(P)/
エキス剤 [エキスざい] /(n) extract/
エキセントリック /(adj-na,n) eccentric/
エキソヌクレアーゼ /(n) exonuclease/
エキソン /(n) exon/
エキゾースト /(n) exhaust/
エキゾーストパイプ /(n) exhaust pipe/
エキゾチ /(n) exoticism/
エキゾチシズム /(n) exoticism/
エキゾチズム /(n) exoticism/
エキゾチック /(adj-na,n) exotic/(P)/
エキゾチックアニマル /(n) exotic animal (e.g. tarantula)/
エキノコッカス /(n) echinococcus (lat:)/
エキノコッカス症 [エキノコッカスしょう] /(n) echinococcosis/hydatid disease/
エキノコックス /(n) echinococcus (lat:)/
エキノコックス症 [エキノコックスしょう] /(n) echinococcosis/hydatid disease/
エキノマイシン /(n) echinomycin/
エキパイ /(n) (abbr) exhaust pipe/
エキマニ /(n) (abbr) exhaust manifold/
エキュー /(n) European Currency Unit/ECU/
エキュメニズム /(n) ecumenism/
エキュメノポリス /(n) ecumenopolis/
エギーユ /(n) aiguille (sharp rock peak) (fre:)/
エクアドル /(n) Ecuador/(P)/
エクイタブル /(n) equitable/
エクイティ /(n,adj-no) equity/
エクイティー /(n,adj-no) equity/
エクイティーファイナンス /(n) equity finance/
エクイティファイナンス /(n) equity finance/
エクサ /(n,pref) exa-/10^18/
エクササイズ /(n) exercise/
エクサバイト /(n) (comp) Exabyte/
エクジソン /(n) ecdysone/
エクスカーション /(n) excursion/
エクスカーションチケット /(n) excursion ticket/
エクスカーションフェア /(n) excursion fare/
エクスカージョン /(n) excursion/
エクスカリバー /(n) Excalibur/
エクスキューショナー /(n) executioner/
エクスキューズミー /(n) excuse me/
エクスキューター /(n) executor/
エクスクラメーションマーク /(n) exclamation mark/
エクスクルーシブオア /(n) (comp) exclusive OR/
エクスターナル /(n) external/
エクスタシー /(n) ecstasy/
エクスチェンジ /(n) exchange/
エクスチェンジオーダー /(n) exchange order/
エクステ /(n) (abbr) (sl) (hair) extensions/
エクステリア /(n) exterior/
エクステンション /(n) extension/(P)/
エクステント /(n) extent/
エクステンドメモリ /(n) (comp) extended memory/
エクステンドメモリプロック /(n) (comp) extended memory block/EMB/
エクステンドメモリ仕様 [エクステンドメモリしよう] /(n) (comp) extended memory specification/XMS/
エクストラネット /(n) (comp) extra-net (as opposed to Internet)/
エクストリーム /(adj-f) extreme/
エクストリームスポーツ /(n) extreme sports/
エクスパート /(n) expert/
エクスパイア /(n) expire/
エクスプレス /(n) express/(P)/
エクスプレスウエー /(n) expressway/freeway/motorway/highway/
エクスプレッショニズム /(n) expressionism/
エクスプレッション /(n) expression/
エクスプロージョン /(n) explosion/
エクスプロージョンショット /(n) explosion shot/
エクスプローラ /(n) explorer/
エクスプロイテーション /(n) exploitation/
エクスペディション /(n) expedition/
エクスペリエンス /(n) experience/(P)/
エクスペリメント /(n) experiment/
エクスペンシブ /(n) expensive/
エクスペンス /(n) expense/
エクスポ /(n) expo/(international) exposition/
エクスポート /(n,vs) export/
エクスリブリス /(n) ex libris (lat:)/bookplate/
エクスルブリス /(n) ex libris (lat:)/bookplate/
エクセプション /(n) exception/
エクセラン /(n) Excelan/
エクセル /(n) (comp) EXCEL/
エクセルシート /(n) Excel spreadsheet/
エクセレント /(adj-na) excellent/
エクセントリック /(adj-na) eccentric/
エクソシスト /(n) exorcist/
エクソダス /(n) exodus/
エクダイソン /(n) ecdysone/
エクトプラズム /(n) ectoplasm/
エクメーネ /(n) ecumenism (gre: Oekumene, ger:)/
エクリチュール /(n) literature (fre: ecriture)/
エクリプス /(n) eclipse/
エクリン腺 [エクリンせん] /(n) eccrine gland/
エクレーア /(n) eclair (fre:)/
エクレア /(n) eclair (fre:)/
エクレクティシズム /(n) eclecticism/
エクロジャイト /(n) eclogite/
エグザミネーション /(n) examination/
エグザンプル /(n) example/
エグジスタンシアリスム /(n) existentialisme (fre:)/
エグジスタンス /(n) existence/
エグジット /(n) exit/
エグセクティブクラス /(n) executive class/
エグゼキュート /(n) (comp) execute/
エグゼクティブ /(n) executive/(P)/
エグゼック /(n) (comp) exec/
エグゼンプション /(n) exemption/
エグゼンプト /(n) exempt/
エゲレス /(n) (arch) Great Britain (dut: Engelsch)/United Kingdom/
エコ /(n) (abbr) ecology/
エコー /(n,vs) echo/(P)/
エコーキャンセラ /(n) (comp) echo canceller/
エコーキャンセル /(n) (comp) echo cancellation/
エコーチェック /(n) (comp) echo check/
エコーチェンバー /(n) echo chamber/
エコーバック /(n) (comp) echo back/
エコールーム /(n) echo room/
エコールドパリ /(n) Ecole de Paris (fre:)/
エコーロケーション /(n) echolocation/
エコー減衰器 [エコーげんすいき] /(n) (comp) echo suppressor/
エコー葉書 [エコーはがき] /(n) (uk) postcards with the bottom third of the front side reserved for an advertisement, and sold at a lower cost than regular postcards/
エコー立体 [エコーりったい] /(n) (comp) echo area/echo volume/
エコー領域 [エコーりょういき] /(n) (comp) echo area/echo volume/
エコカー /(n) eco-car/
エコサイド /(n) ecocide/
エコシステム /(n) ecosystem/
エコステーション /(n) a service station for cars that run on alternative fuels/
エコツーリズム /(n) ecotourism/
エコツアー /(n) ecotour/
エコノマイザー /(n) economizer (of a boiler)/economiser/
エコノミ /(n) economy/
エコノミー /(n) economy/(P)/
エコノミークラス /(n) economy class/
エコノミークラス症候群 [エコノミークラスしょうこうぐん] /(n) economy class syndrome (occurrence of deep vein thrombosis in air travelers)/
エコノミカル /(adj-na,n) economical/
エコノミクス /(n) economics/
エコノミスト /(n) economist/(P)/
エコノミック /(adj-no) economic/
エコノミックアニマル /(n) economic animal/
エコノミックス /(n) economics/
エコノメトリックス /(n) econometrics/
エコビジネス /(n) eco-business/
エコファーマー /(n) environmentally friendly farmer (as recognized by law) (wasei: eco-farmer)/
エコフェミニズム /(n) ecofeminism/
エコマーク /(n) (abbr) ecological mark/
エコロケーション /(n) echolocation/
エコロジ /(n) ecology/(P)/
エコロジー /(n) ecology/(P)/
エコロジー運動 [エコロジーうんどう] /(n) ecological movement/
エコロジー神学 [エコロジーしんがく] /(n) ecological theology/
エコロジカル /(adj-no) ecological/
エコロジスト /(n) ecologist/
エゴ /(n) ego (lat:)/(P)/
エゴイスティック /(adj-na) egotistic/
エゴイスト /(n) egotist/
エゴイズム /(n) egoism/
エゴティスト /(n) egotist/
エゴティズム /(n) egotism/
エゴノキ /(n) Japanese snowbell/styrax japonica/
エゴノキ科 [エゴノキか] /(n) Styracaceae (plant family)/(common name) the snowball family/
エサキダイオード /(n) Esaki diode/
エサ箱 [エサばこ] /(n) (animal) feed tray/feed trough/feed box/feed bowl/bait box (e.g. for fishing)/
エシェリキア /(n) escherichia coli/
エシェリヒア /(n) escherichia coli/
エシックス /(n) ethics/
エシャレット /(n) shallot (fre: echalote)/
エシャロット /(n) shallot (fre: echalote)/
エジソン効果 [エジソンこうか] /(n) Edison effect (thermionic emission from a heated metal or semiconductor)/
エジブト /(n,adj-no) (uk) Egypt/
エジプト /(n,adj-no) (uk) Egypt/(P)/
エジプトコブラ /(n) Egyptian cobra (from Egypt cobra)/asp (Naja haje)/
エジプトトルコ戦争 [エジプトトルコせんそう] /(n) Turko-Egyptian Wars (1831-1833; 1839-1840)/
エジプト学 [エジプトがく] /(n) Egyptology/
エジプト語 [エジプトご] /(n) Egyptian (language)/
エジプト人 [エジプトじん] /(n) Egyptian (person)/
エジプト文字 [エジプトもじ] /(n) Egyptian script (i.e. hieroglyphs, hieratic, and demotic)/
エス /(n) (1) Jesus (lat:)/
エスアイエー /(n) (comp) SIA/
エスアイエス /(n) (comp) SIS/
エスイー /(n) (comp) SE/
エスイーダブリュービー /(n) (comp) SEWB/
エスエイピー /(n) (comp) SAP/
エスエイピーアールスリー /(n) (comp) SAP R-3/
エスエヌエー /(n) (comp) SNA/
エスエフエー /(n) (comp) SFA/
エスエム /(n) sado-masochism/
エスエムティーピー /(n) (comp) SMTP/
エスエムピー /(n) (comp) SMP/
エスカッション /(n) (1) escutcheon/(2) ornamental plate or flange/
エスカップ /(n) Economic and Social Commission for Asia and the Pacific/ESCAP/
エスカルゴ /(n) (edible) snail (fre: escargot)/
エスカルゴバター /(n) escargot butter/
エスカレーション /(n) escalation/
エスカレータ /(n) escalator/
エスカレーター /(n) escalator/(P)/
エスカレーター学校 [エスカレーターがっこう] /(n) (col) private school that allows students to advance from one stage of education to the next, often kindergarten to university, without taking entrance exams en route/"escalator school"/
エスカレーター校 [エスカレーターこう] /(n) (col) private school that allows students to advance from one stage of education to the next, often kindergarten to university, without taking entrance exams en route/"escalator school"/
エスカレーター条項 [エスカレーターじょうこう] /(n) escalator clause/
エスカレータ学校 [エスカレータがっこう] /(n) (col) private school that allows students to advance from one stage of education to the next, often kindergarten to university, without taking entrance exams en route/"escalator school"/
エスカレータ校 [エスカレータこう] /(n) (col) private school that allows students to advance from one stage of education to the next, often kindergarten to university, without taking entrance exams en route/"escalator school"/
エスカレート /(n,vs) escalate/escalation/(P)/
エスカロープ /(n) escalope (fre:)/
エスカロップ /(n) escalope (fre:)/
エスキス /(n) sketch (fre: esquisse)/
エスキモー /(n) Eskimo/
エスキモー犬 [エスキモーけん] /(n) Eskimo dog/
エスキューエル /(n) (comp) SQL/
エスキューエルサーバ /(n) (comp) SQL Server/
エスキューエルネット /(n) (comp) SQL*Net/
エスキューエルプラス /(n) (comp) SQL*Plus/
エスキューブ /(n) (comp) S3/
エスクリマ /(n) escrima (Filipino marshal art)/
エスクローサービス /(n) (comp) escrow service/
エスクワイア /(n) esquire/
エスケープ /(n,vs) escape/
エスケープキー /(n) (comp) ESC key/
エスケープクローズ /(n) escape clause/
エスケープシークェンス /(n) (comp) escape sequence/
エスケープシーケンス /(n) (comp) escape sequence/
エスケープ文字 [エスケープもじ] /(n) (comp) escape character/ESC/
エスケープ要素 [エスケープようそ] /(n) (comp) escape elements/
エスコート /(n,vs) escort/(P)/
エスコートガール /(n) escort girl/
エスサイズ /(n) S size/small size/
エスシーオー /(n) (comp) SCO/
エスジーエムエル /(n) (comp) SGML/
エスジス /(n) (comp) sjis/
エススリー /(n) (comp) S3/
エスタブリシュメント /(n) establishment/
エスタブリッシュメント /(n) establishment/
エスツェット /(n) eszet (German character for ss)/eszett/
エステ /(adj-na) (1) (abbr) esthetic (fre: esthetique)/aesthetic/(n) (2) (abbr) beauty salon/beauty-treatment clinic/
エステート /(n) estate/(P)/
エスティーエヌ /(n) (comp) STN/
エスティディー /(n) (comp) STD/
エステサロン /(n) (abbr) salon where people go to get makeovers, massages, facials, etc. (wasei: esthetic salon)/beauty salon/
エステシャン /(n) esthetician (fre:)/
エステティシャン /(n) esthetician (fre:)/
エステティック /(adj-f) esthetic (fre: esthetique)/aesthetic/(P)/
エステティックサロン /(n) beauty salon (wasei: esthetic salon)/beauty-treatment clinic/(P)/
エステラーゼ /(n) esterase/
エステル /(n) ester/(P)/
エステル化 [エステルか] /(n,vs) esterification/
エステル記 [エステルき] /(n) Esther (book of the Bible)/
エステル変換 [エステルへんかん] /(n) transesterification/
エスディーケー /(n) (comp) SDK/
エスディーラム /(n) (comp) SD-RAM/
エストッペル /(n) estoppel/
エストニア /(n) Estonia/(P)/
エストニア語 [エストニアご] /(n) Estonian (language)/
エストラゴン /(n) tarragon (fre: estragon)/
エストラジオール /(n) estradiol/oestradiol/
エストリオール /(n) estriol/oestriol/
エストロゲン /(n) estrogen/(P)/
エストロン /(n) estrone/
エスニシズム /(n) ethnicism/
エスニシティ /(n) ethnicity/
エスニシティー /(n) ethnicity/
エスニック /(adj-na,n) ethnic/(P)/
エスニッククレンジング /(n) ethnic cleansing/
エスニックグループ /(n) ethnic group/
エスニックフード /(n) ethnic food/
エスニックファッション /(n) ethnic fashion/
エスニックマイノリティー /(n) ethnic minority/
エスニックルック /(n) ethnic look/
エスニック料理 [エスニックりょうり] /(n) ethnic food (esp. Asian, African, etc.)/
エスノ /(pref) ethno/
エスノグラフィー /(n) ethnography/
エスノサイエンス /(n) ethnoscience/
エスノセントリズム /(n) ethnocentrism/
エスノメソドロジー /(n) ethnomethodology/
エスノロジー /(n) ethnology/
エスパー /(n) ESPer/one who has ESP (extrasensory perception)/
エスパドリーユ /(n) espadrille (type of women's sandals) (fre:)/
エスパニョールソース /(n) sauce Espagnole/
エスピー盤 [エスピーばん] /(n) 78-rpm record/standard-play record/
エスブイアールフォー /(n) (comp) SVR4/
エスブイジーエー /(n) (comp) SVGA/
エスプラネード /(n) esplanade/
エスプリ /(n) esprit (fre:)/spirit/(P)/
エスプリヌーボー /(n) esprit nouveau (fre:)/
エスプレッソ /(n) espresso (coffee) (ita:)/expresso/
エスベース /(n) (comp) Essbase/
エスペラント /(n) Esperanto (epo:)/
エスポワール /(n) hope (fre: espoir)/
エスラム /(n) (comp) SRAM/
エス字型 [エスじがた] /(n) S-shape/
エス波 [エスは] /(n) S-wave (e.g. of earthquake)/secondary wave/
エズラ記 [エズラき] /(n) Ezra (book of the Bible)/
エゼキエル書 [エゼキエルしょ] /(n) Ezekiel (book of the Bible)/
エソ /(n) (uk) lizardfish (any fish of family Synodontidae)/
エソロジー /(n) ethology/science of animal behaviour/science of animal behavior/
エゾクロテン /(n) (uk) Japanese sable (subspecies of sable native to Hokkaido, Martes zibellina brachyura)/
エゾシカ /(n) (uk) Hokkaido sika (deer) (Cervus nippon yesoensis)/Yezo sika/
エゾネギ /(n) (uk) chives (Allium schoenoprasum var. schoenoprasum)/
エゾバイ /(n) (uk) Middendorf's whelk (Buccinum middendorffi)/
エゾバイ科 [エゾバイか] /(n) Buccinidae (family of gastropod mollusc comprising the true whelks)/
エゾヒグマ /(n) (uk) Hokkaido brown bear (Ursus arctos yesoensis)/
エゾボラ /(n) (uk) Ezo neptune (species of whelk, Neptunea polycostata)/
エゾボラモドキ /(n) (uk) double-sculptured neptune (species of whelk, Neptunea intersculpta)/
エゾマツ /(n) (uk) Yezo spruce (Picea jezoensis)/Jezo spruce/
エゾモモンガ /(n) (uk) Pteromys volans orii (subspecies of the Siberian flying squirrel, endemic to Hokkaido)/
エゾヤマザクラ /(n) (uk) sargent cherry (Prunus sargentii)/
エゾライチョウ /(n) (uk) hazel grouse (Bonasa bonasia)/
エゾリス /(n) (uk) Hokkaido squirrel (subspecies of red squirrel, Sciurus vulgaris orientis)/
エターナル /(n) eternal/
エターニティー /(n) eternity/
エタクリン酸 [エタクリンさん] /(n) ethacrynic acid/
エタニティ /(n) eternity/
エタニティー /(n) eternity/
エタノール /(n) ethanol (ger: A"thanol)/
エタロン /(n) etalon (optical element with parallel surfaces used to increase the coherent length of a laser)/
エタン /(n) ethane (ger: A"than)/
エタンジオール /(n) ethanediol/
エダムチーズ /(n) Edam cheese/
エチオピア /(n) Ethiopia/
エチオピア区 [エチオピアく] /(n) Ethiopian (zoogeographical region)/
エチオピア語 [エチオピアご] /(n) Ethiopic (language, languages)/
エチオピア狼 [エチオピアおおかみ] /(n) Ethiopian wolf (carnivore, Canis simensis)/Abyssinia jackal/simian jackal/simenian jackal/simenian wolf/
エチケット /(n) etiquette (fre:)/(P)/
エチケット袋 [エチケットぶくろ] /(n) airsickness bag/motion sickness bag/
エチモロジー /(n) etymology/
エチュード /(n) etude (fre:)/
エチル /(n) ethyl (ger: A"thyl)/
エチルアルコール /(n) ethanol (ger: A"thylalkohol)/ethyl alcohol/
エチルエーテル /(n) ethyl ether/
エチレン /(n) ethylene/
エチレンオキシド /(n) ethylene oxide/
エチレングリコール /(n) ethylene glycol/ethanediol/
エチレンジアミン /(n) ethylenediamine/
エチレンジアミン四酢酸 [エチレンジアミンしさくさん] /(n) ethylenediaminetetraacetic acid/EDTA/
エチレン系炭化水素 [エチレンけいたんかすいそ] /(n) (obsc) alkene/olefin/olefine/
エックスウィンドウ /(n) (comp) X-Window/
エックスエー /(n) (comp) XA/
エックスエムエス /(n) (comp) XMS/
エックスオープン /(n) (comp) X-Open/
エックスオア /(n) (comp) XOR/
エックスジーエー /(n) (comp) XGA/
エックスディエスエル /(n) (comp) xDSL/
エックスニーゴー /(n) (comp) X.25/
エックスファー /(n) (comp) XFER/
エックスフィット /(n) (comp) XFIT/
エックスモデム /(n) (comp) XMODEM/
エックスモデムイチケー /(n) (comp) XMODEM-1k/
エックスモデムシーアールシー /(n) (comp) XMODEM-CRC/
エックスヨンヒャク /(n) (comp) X.400/
エックス脚 [エックスきゃく] /(n) knock-kneed/
エックス線 [エックスせん] /(n) X-ray/(P)/
エックス線撮影 [エックスせんさつえい] /(n) x-ray photography/
エッグ /(n) egg (esp. chicken eggs)/
エッグカップ /(n) eggcup/
エッグノッグ /(n) eggnog/
エッグプラント /(n) eggplant/
エッサッサ /(int) heave-ho (chant when doing heavy work)/
エッジ /(n) edge/(P)/
エッジサブスクリプション /(n) (comp) edge subscription/
エッジサブスクリプションファイル /(n) (comp) edge subscription file/
エッジトリガ方式 [エッジトリガほうしき] /(n) (comp) edge trigger method/
エッジボール /(n) edge ball/
エッジワースカイパーベルト天体 [エッジワースカイパーベルトてんたい] /(n) Edgeworth-Kuiper belt objects/
エッジング /(n) edging/
エッセー /(n,adj-no) essay/(P)/
エッセィ /(n,adj-no) essay/
エッセイ /(n,adj-no) essay/(P)/
エッセイスト /(n) essayist/(P)/
エッセネ派 [エッセネは] /(n) the Essenes/
エッセン /(n) meal (ger: Essen)/
エッセンシャル /(n) essential/
エッセンス /(n) essence/extract/(P)/
エッチな映画 [エッチなえいが] /(n) pornographic film/salacious film/
エッチュウバイ /(n) (uk) finely-striate buccinum (species of whelk, Buccinum striatissimum)/
エッチング /(n,vs) etching/(P)/
エッフェル塔 [エッフェルとう] /(n) Eiffel Tower/(P)/
エッペンチューブ /(n) Eppendorf tube/microcentrifuge tube/microfuge tube/
エツ /(n) (uk) Japanese grenadier anchovy (Coilia nasus)/
エティモロジー /(n) etymology/
エディアカラ化石群 [エディアカラかせきぐん] /(n) (obsc) Ediacara fossil biota/
エディアカラ動物群 [エディアカラどうぶつぐん] /(n) Ediacara fauna/
エディション /(n) edition/(P)/
エディタ /(n) (comp) editor/
エディター /(n) (comp) editor/(P)/
エディット /(n) edit/(P)/
エディットボックス /(n) (comp) edit box/
エディティング /(n) editing/
エディト /(n) edit/
エディトリアル /(n) editorial/
エディトリアルデザイン /(n) editorial design/
エディファクト /(n) (comp) EDIFACT/
エディブルフラワー /(n) edible flower/
エディプスコンプレックス /(n) Oedipus complex/sexual attraction to one's mother/
エディンバラ /(n) Edinburgh/(P)/
エデュ /(n) (comp) edu/
エデュケーション /(n) education/
エデュコム /(n) (comp) EDUCOM/
エデュテイメント /(n) (comp) edutainment/
エデュテインメント /(n) (comp) edutainment/
エデン /(n) Eden/(P)/
エデンの園 [エデンのその] /(n) Garden of Eden/
エトス /(n) ethos/
エトセトラ /(n) et cetera (lat:)/and so forth/
エトピリカ /(n) tufted puffin (ain:)/
エトランゼ /(n) stranger (fre: etranger)/
エトルリア語 [エトルリアご] /(n) Etruscan (language)/
エトルリア人 [エトルリアじん] /(n) Etruscan (person)/
エトルリア文字 [エトルリアもじ] /(n) Etruscan character/Etruscan alphabet/
エトワール /(n) star (fre: etoile)/
エトワス /(exp) somewhat (ger: etwas)/
エドアブラザメ /(n) sharpnose sevengill shark (Heptranchias perlo, species of circumglobal cow shark)/
エドアブラザメ属 [エドアブラザメぞく] /(n) Heptranchias (genus of cow shark in the family Hexanchidae containing the sharpnose seven-gill shark as its only member)/
エドガー /(n) (comp) EDGAR/
エドサック /(n) (comp) EDSAC/
エドバック /(n) (comp) EDVAC/
エドヒガン /(n) (uk) double weeping rosebud cherry (Prunus pendula)/
エナージー /(n) energy/
エナジー /(n) energy/(P)/
エナジーセーバ /(n) (comp) energy saver/
エナジーセーブの即時実行 [エナジーセーブのそくじじっこう] /(n) (comp) quick energy saver/
エナジーセーブモード /(n) (comp) energy save mode/low power mode/
エナミン /(n) enamine/
エナメル /(n) enamel/(P)/
エナメルドグラス /(n) enameled glass/
エナメルペイント /(n) enamel paint/
エナメル質 [エナメルしつ] /(n,adj-f) (tooth) enamel/adamantine/
エナメル線 [エナメルせん] /(n) enameled wire/
エニアック /(n) (comp) ENIAC (Electronic Numerical Integrator And Calculator)/
エニグマ /(n) enigma/
エニコム /(n) (comp) ENICOM/
エニシダ /(n) (uk) common broom (Cytisus scoparius, Genista scoparia)/Scotch broom/English broom/
エヌアールイーエヌ /(n) (comp) NREN/
エヌアイアイ /(n) (comp) NII/
エヌアイエスオー /(n) (comp) NISO/
エヌアイエスティー /(n) (comp) NIST/
エヌアイエム /(n) (comp) NIM/
エヌイーシー /(n) (comp) NEC/
エヌエスエーピーアイ /(n) (comp) NSAPI/
エヌエスエフネット /(n) (comp) NSFnet/
エヌエスピー /(n) (comp) NSP/
エヌエスピーアイエックスピー /(n) (comp) NSPIXP/
エヌエッチケー教育テレビ [エヌエッチケーきょういくテレビ] /(n) NHK Educational TV/
エヌエッチケー教育テレビジョン [エヌエッチケーきょういくテレビジョン] /(n) NHK Educational TV/
エヌエヌティーピー /(n) (comp) NNTP/
エヌエフエス /(n) (comp) NFS/
エヌエフエスネット /(n) (comp) NFSNET/
エヌオーエス /(n) (comp) NOS/
エヌオーシー /(n) (comp) NOC/
エヌサピ /(n) (comp) NSAPI/
エヌシー /(n) (comp) NC/
エヌシーアール /(n) (comp) NCR/
エヌシーエー /(n) (comp) NCA/
エヌシーエスエー /(n) (comp) NCSA/
エヌシーエフティーピー /(n) (comp) ncftp/
エヌシーティービー /(n) (comp) NCTV/
エヌシーユー /(n) (comp) NCU/
エヌティーティーディレクトリ /(n) (comp) NTT Directory/
エヌティーピー /(n) (comp) NTP/
エヌピーティーエヌ /(n) (comp) NPTN/
エヌファー /(n) (comp) NFER/
エヌライトン /(n) (comp) NlightN/
エヌレン /(n) (comp) NREN/
エネ /(n) (abbr) energy/(P)/
エネーブル /(n) enable/
エネトピア /(n) (abbr) housing development designed with an eye toward energy conservation/
エネミー /(n) enemy/
エネルギー /(n) energy (ger: Energie)/(P)/
エネルギースター /(n) (comp) Energy Star/
エネルギースポット /(n) location thought to be flowing with mystical energy (wasei: energy spot)/
エネルギー革命 [エネルギーかくめい] /(n) energy revolution/
エネルギー源 [エネルギーげん] /(n) energy source/
エネルギー交代 [エネルギーこうたい] /(n) (obsc) energy metabolism/
エネルギー効率 [エネルギーこうりつ] /(n) energy efficiency/
エネルギー産業 [エネルギーさんぎょう] /(n) energy industry/
エネルギー資源 [エネルギーしげん] /(n) energy resources/
エネルギー準位 [エネルギーじゅんい] /(n) energy level/
エネルギー帯 [エネルギーたい] /(n) energy band/
エネルギー代謝 [エネルギーたいしゃ] /(n) energy metabolism/
エネルギー代謝率 [エネルギーたいしゃりつ] /(n) relative metabolic rate/
エネルギー保存の法則 [エネルギーほぞんのほうそく] /(n) law of conservation of energy/
エネルギー問題 [エネルギーもんだい] /(n) energy problems/
エネルギー論 [エネルギーろん] /(n) energetics/
エネルギッシュ /(adj-na) energetic (ger: Energisch)/(P)/
エネルゲイア /(n) energeia (gre:)/
エノキタケ /(n) (uk) enoki mushroom (long, thin and white)/Flammulina velutipes/winter mushroom/
エノキダケ /(n) (uk) enoki mushroom (long, thin and white)/Flammulina velutipes/winter mushroom/
エノコログサ /(n) (uk) green foxtail (species of annual grass, Setaria viridis)/
エノハ /(n) (uk) landlocked masu salmon/
エバ /(adv) ever/
エバー /(adv) ever/(P)/
エバーオンワード /(n) ever onward/
エバーグリーン /(n) evergreen/
エバーグレーズ /(n) Everglaze/
エバーソフト /(n) foam rubber (from Eversoft (tm))/
エバープリーツ /(n) Everpleats/
エバーホワイト /(n) Everwhite/
エバキュエーション /(n,vs) evacuation/
エバチップ /(n) (abbr) special version of a product with features that allow it to be used for evaluation (wasei: evaluation chip)/
エバポレーテッドミルク /(n) evaporated milk/
エバミルク /(n) (abbr) evaporated milk/
エバリュエーション /(n) evaluation/
エバリュエータ /(n) evaluator/
エバンジェリスト /(n) evangelist/
エビ /(n) prawn/shrimp/lobster/crayfish/(P)/
エビガニ /(n) (uk) (col) crayfish (esp. red swamp crayfish, Procambarus clarkii)/
エビガライチゴ /(n) (uk) Japanese wineberry (Rubus phoenicolasius Maxim.)/wine raspberry/wineberry/
エビシディック /(n) (comp) EBCDIC/
エビスグサ /(n) (uk) sicklepod (Senna obtusifolia)/
エビスザメ /(n) (uk) broadnose sevengill shark (Notorynchus cepedianus, species of circumglobal cow shark with 7 gill slits)/
エビスザメ属 [エビスザメぞく] /(n) Notorynchus (genus of cow sharks in the family Hexanchidae whose only extant member is the broadnose sevengill shark)/
エビヅル /(n) (uk) Vitis ficifolia (species of grapevine)/
エビヅルムシ /(n) (uk) (obsc) clearwing moth larva/
エビヅル虫 [エビヅルむし] /(n) (uk) (obsc) clearwing moth larva/
エビデンス /(n) evidence/
エビル /(n) evil/
エビ漁 [エビりょう] /(n) shrimp fishing/shrimping/
エピオルニス /(n) aepyornis/elephant bird/
エピキュリアン /(n) epicurean/
エピクロス学派 [エピクロスがくは] /(n) Epicurean school (of philosophy)/
エピクロス主義 [エピクロスしゅぎ] /(n) Epicureanism/
エピグラフ /(n) epigraph/
エピグラム /(n) epigram/
エピゴーネン /(n) epigone (ger: Epigonen)/
エピスコパル教会 [エピスコパルきょうかい] /(n) Episcopal Church/
エピスタシス /(n) epistasis/
エピステーメー /(n) episteme (gre:)/
エピソード /(n) episode/(P)/
エピソーム /(n) episome/
エピタキシー /(n) epitaxy/epitaxial growth/
エピタキシャル /(n) epitaxial/
エピタキシャル成長 [エピタキシャルせいちょう] /(n) epitaxial growth/epitaxy/
エピタフ /(n) epitaph/
エピック /(n) epic/(P)/
エピトープ /(n) epitope/
エピネフリン /(n) epinephrine/
エピローグ /(n) epilogue/
エフィシェンシー /(n) efficiency/
エフイーピー /(n) (comp) FEP/
エフェクタ /(n) (comp) effector/
エフェクター /(n) effector/
エフェクツ /(n) effects/
エフェクティブ /(adj-na) effective/
エフェクト /(n) effect/
エフェクトコンパイラ /(n) (comp) effect compiler/
エフェクトマシン /(n) effect machine/
エフェソの信徒への手紙 [エフェソのしんとへのてがみ] /(n) Epistle to the Ephesians (book of the Bible)/
エフェドリン /(n) ephedrine/
エフエー /(n) (comp) FA/
エフエーキュー /(n) (comp) FAQ/
エフエスエフ /(n) (comp) FSF/
エフエヌシー /(n) (comp) FNC/
エフエムタウンズ /(n) (comp) FM TOWNS/
エフキューディーエヌ /(n) (comp) FQDN/
エフギャル /(n) (comp) FGAL/
エフシーシー /(n) (comp) FCC/
エフジェイ /(n) (comp) fj/
エフティーピー /(n) (comp) FTP/
エフディー /(n) (comp) FD/
エフディーエイチディー /(n) (comp) FDHD/
エフディーディー /(n) (comp) FDD/
エフディーディーアイ /(n) (comp) FDDI/
エフピーユー /(n) (comp) FPU/
エフラボ /(n) (comp) FLABO/
エプロン /(n) apron/(P)/
エプロンステージ /(n) apron stage/
エベレスト /(n) Everest/
エベンキ /(n) Evenki (people of Mongolia and Russia)/
エベント /(n) event/
エペ /(n) epee (fre: epee)/(P)/
エホバ /(n) Jehovah/
エホバの証人 [エホバのしょうにん] /(n) Jehovah's Witnesses/
エボシダイ /(n) (uk) man-of-war fish (Nomeus gronovii)/
エボシドリ /(n) (uk) turaco (any bird of family Musophagidae, esp. the Knysna turaco, Tauraco corythaix)/touraco/loerie/lourie/
エボナイト /(n) ebonite/
エボラウイルス /(n) Ebola virus/
エボラ出血熱 [エボラしゅっけつねつ] /(n) Ebola hemorrhagic fever/
エボリューション /(n) evolution/
エボリュート /(n) (math) evolute/
エボリュート曲線 [エボリュートきょくせん] /(n) (math) (obsc) evolute curve/
エポーレット・シャーク /(n) epaulette shark (Hemiscyllium ocellatum)/blind shark/
エポーレットシャーク /(n) epaulette shark (Hemiscyllium ocellatum)/blind shark/
エポウレットシャーク /(n) epaulette shark (Hemiscyllium ocellatum)/
エポキシ /(n) epoxy/
エポキシ樹脂 [エポキシじゅし] /(n) epoxy resin/
エポック /(n) epoch/(P)/
エポックメーキング /(adj-na) epoch-making/
エポックメイキング /(adj-na) epoch-making/
エポニム /(n,adj-no) eponym (word derived from the name of a place or person)/
エポレット /(n) epaulette (fre:)/
エマージェンシー /(n) emergency/
エマージェンシーランディング /(n) emergency landing/
エマージング /(adj-no) emerging/
エマルション /(n) emulsion/
エマルジオン /(ik) (n) emulsion/
エマルジョン /(n) emulsion/
エマルジョンレーザー記憶装置 [エマルジョンレーザーきおくそうち] /(n) (comp) emulsion laser storage/
エマルジョン塗料 [エマルジョンとりょう] /(n) emulsion paint/
エマンシペーション /(n) emancipation/
エミグラント /(n) (obsc) emigrant/
エミグレーション /(n) emigration/
エミッション /(n) emission/
エミッター /(n) emitter/
エミッタートランジスタ論理回路 [エミッタートランジスタろんりかいろ] /(n) (comp) Emitter-Coupled Transistor Logic/ECTL/
エミッタ結合素子 [エミッタけつごうそし] /(n) (comp) ECL/Emitter Coupled Logic/
エミネント /(n) eminent/
エミフィル /(n) (abbr) EMI (electro-magnetic interference) filter/
エミュ /(n) (abbr) emulator/emulation/
エミュー /(n) emu/
エミュレーション /(n,vs) emulation/
エミュレータ /(n) (comp) emulator/
エミュレーター /(n) (comp) emulator/
エミュレート /(n,vs) emulate/
エムアールエヌエー /(n) mRNA/
エムエス /(n) (comp) MS/
エムエスアイイー /(n) (comp) MSIE/
エムエスエヌ /(n) (comp) MSN/
エムエスシーディーイーエックス /(n) (comp) MSCDEX/
エムエスディーエヌ /(n) (comp) MSDN/
エムエスドス /(n) (comp) MS-DOS/
エムエディタ /(n) (comp) EmEditor/
エムエムイー /(n) (comp) MME/
エムエムエックス /(n) (comp) MMX/
エムエムオー /(n) (comp) MMO/
エムエムユー /(n) (comp) MMU/
エムオー /(n) (comp) MO/
エムオーラップ /(n) (comp) MOLAP/
エムサイズ /(n) M size/medium size/
エムシーアイ /(n) (comp) MCI/
エムティーエス /(n) (comp) MTS/
エムティービーエフ /(n) (comp) MTBF/
エムティーユー /(n) (comp) MTU/
エムディー /(n) (comp) MD/
エムピーシー /(n) (comp) MPC/
エムピーピー /(n) (comp) MPP/
エムピーユー /(n) (comp) MPU/
エムブイエス /(n) (comp) MVS/
エムペグ /(n) (comp) MPEG/
エムペグツー /(n) (comp) MPEG2/
エムペグプラスプラス /(n) (comp) MPEG++/
エムボーン /(n) (comp) MBONE/
エムユーディー /(n) (comp) MUD/
エムルション /(n) emulsion/
エメチン /(n) emetine/
エメラルド /(n) emerald/(P)/
エメラルド・ツリー・モニター /(n) emerald tree monitor (Varanus prasinus, species of arboreal carnivorous monitor lizard found from New Guinea to Queensland, Australia)/green tree monitor/
エメラルドグリーン /(n) emerald green/
エメラルドツリーモニター /(n) emerald tree monitor (Varanus prasinus, species of arboreal carnivorous monitor lizard found from New Guinea to Queensland, Australia)/green tree monitor/
エメリー /(n) emery/
エメリーズグレゴリー /(n) Emery's gregory (Stegastes emeryi)/
エメリーペーパー /(n) emery paper/
エメリーボード /(n) emery board/
エメンタール /(n) Emmental/Emmenthal/Emmenthaler/Emmentaler/Emmenthaler cheese/
エモーショナリスム /(n) emotionalism/
エモーショナル /(adj-no) emotional/
エモーション /(n) emotion/
エモーティコン /(n) (comp) emoticon/
エモリアント /(n) emollient/
エヤー /(n) air/
エヤクラチオン /(n) ejaculation/
エラー /(n) error/(P)/
エラーの検出と訂正 [エラーのけんしゅつとていせい] /(n) (comp) Error Checking and Correcting/ECC/
エラーコード /(n) (comp) error code/
エラーシグナル /(n) error-signal/
エラーチェック /(n) (comp) error check/
エラーハンドリング /(n) (comp) error handling/
エラーバー /(n) (comp) error bar (graph)/
エラーフリー /(n) (comp) error free/
エラーメッセージ /(n) (comp) error message/
エラーレート /(n) (comp) error rate/
エラーレベル /(n) (comp) error level/
エラーログ /(n) (comp) error log/
エラー回復 [エラーかいふく] /(n) (comp) error recovery/
エラー回復ルーチン [エラーかいふくルーチン] /(n) (comp) error recovery routine/
エラー検出符号 [エラーけんしゅつふごう] /(n) (comp) Error-Detecting Code/EDC/
エラー終了 [エラーしゅうりょう] /(n,vs) (comp) error termination/terminate with error/
エラー処理 [エラーしょり] /(n) (comp) error handling/
エラー処理ルーチン [エラーしょりルーチン] /(n) (comp) error handling routine/error-handling routine/
エラー処理手順 [エラーしょりてじゅん] /(n) (comp) error procedure/
エラー処理方法 [エラーしょりほうほう] /(n) (comp) error handling mechanism/error-handling mechanism/
エラー状態 [エラーじょうたい] /(n) (comp) error condition (in calculators)/
エラー状態リスト [エラーじょうたいリスト] /(n) (comp) error state list/
エラー制御 [エラーせいぎょ] /(n) (comp) error control/
エラー制御ロジック [エラーせいぎょロジック] /(n) (comp) error-control logic/
エラー訂正 [エラーていせい] /(n) (comp) error correction/
エラー訂正エンコーディング [エラーていせいエンコーディング] /(n) (comp) error-correcting encoding/
エラー訂正プロトコル [エラーていせいプロトコル] /(n) (comp) error-correcting protocol/
エラー訂正メモリ [エラーていせいメモリ] /(n) (comp) error-correcting memory/
エラー訂正符号 [エラーていせいふごう] /(n) (comp) Error-Correcting Code/ECC/
エラー表示 [エラーひょうじ] /(n) (comp) error indication/
エラー補正後 [エラーほせいご] /(n-adv,n-t) (comp) after error correction/
エラー履歴 [エラーりれき] /(n) (comp) error history/
エラっぽい /(exp) (col) klutzy/clumsy/
エライザ法 [エライザほう] /(n) enzyme-linked immunoSorbent assay (virus detection method)/ELISA/
エラスチック /(n) elastic/
エラスチック織物 [エラスチックおりもの] /(n) elastic fabric/
エラスチン /(n) elastin/
エラスティック /(n) elastic/
エラストマー /(n) elastomer/
エラトステネスの篩 [エラトステネスのふるい] /(n) Eratosthenes' sieve/
エラブウナギ /(n) (uk) Erabu black-banded sea krait (Laticauda semifasciata)/
エラブウミヘビ /(n) (uk) Erabu black-banded sea krait (Laticauda semifasciata)/
エラブオオコウモリ /(n) (uk) northern Ryukyu fruit bat (Pteropus dasymallus dasymallus)/
エラブトキシン /(n) erabutoxin/
エランド /(n) eland/
エランビタール /(n) elan vital (hypothetical driving force behind creative evolution) (fre:)/
エランビタル /(n) elan vital (hypothetical driving force behind creative evolution) (fre:)/
エランヴィタル /(n) elan vital (hypothetical driving force behind creative evolution) (fre:)/
エリート /(n,adj-no) elite (fre:)/(P)/
エリート意識 [エリートいしき] /(n) elitism/
エリア /(n) area/(P)/
エリアコード /(n) (comp) area code/
エリアマーケティング /(n) area marketing/
エリア境界 [エリアきょうかい] /(n) (comp) area boundary/
エリキシル /(n) elixir/
エリキシル剤 [エリキシルざい] /(n) elixir/
エリクシア /(n) elixir/
エリクソン /(n) (comp) Ericsson/
エリサン /(n) (uk) eri silkmoth (Samia cynthia ricini)/eri silkworm/
エリシウム /(n) Elysium/
エリジビリティー /(n) eligibility/
エリス /(n) (1) Eris (dwarf planet)/(2) Eris (Greek goddess of strife)/
エリスリトール /(n) erythritol (artificial sweetener)/
エリスロポイエチン /(n) erythropoietin/
エリスロポエチン /(n) erythropoietin/
エリスロマイシン /(n) erythromycin/
エリダヌス座 [エリダヌスざ] /(n) Eridanus (constellation) (lat:)/
エリテマトーデス /(n) lupus erythematosus (esp. systemic lupus erythematosus) (ger: Erythematodes)/
エリホシベニハゼ /(n) four-eye pygmy goby (Trimma hayashii, found from Japan to the Solomons)/
エリマキシギ /(n) (uk) ruff/reeve (species of sandpiper, Philomachus pugnax)/
エリマキトカゲ /(n) (uk) frilled lizard (Chlamydosaurus kingii)/frill-necked lizard/
エリミネーター /(n) eliminator/
エリヤ /(n) area/
エリンギ /(n) king trumpet mushroom (Pleurotus eryngii)/king oyster mushroom/
エリント /(n) electronic intelligence/ELINT/
エル /(n) ell (unit of length, approx. 45 inches)/
エルード /(n,vs) elude/
エルエーティー /(n) (comp) LAT/
エルエイチアーク /(n) (comp) LHarc/
エルエイチエー /(n) (comp) LHA/
エルエスアイ /(n) (comp) large scale integrated circuit/LSI/
エルク /(n) elk/
エルグ /(n) erg/
エルゴード仮説 [エルゴードかせつ] /(n) ergodic hypothesis/
エルゴード的 [エルゴードてき] /(adj-na) (comp) ergodic/
エルゴカルシフェロール /(n) ergocalciferol/
エルゴステロール /(n) ergosterol/
エルゴタミン /(n) ergotamine/
エルゴノビン /(n) ergonovine/
エルゴノミク /(adj-f) ergonomic/
エルゴノミクス /(n) (comp) ergonomics/
エルゴノミックキーボード /(n) (comp) ergonomic keyboard/
エルゴノミックス /(n) ergonomics/
エルゴメトリン /(n) ergometrine/
エルサイズ /(n) L size/large size/
エルサップ /(n) (comp) LSAP/
エルサルバドル /(n) El Salvador/(P)/
エルステッド /(n) oersted/
エルゼットエイチ /(n) (comp) lzh/
エルダップ /(n) (comp) LDAP/
エルディエーピー /(n) (comp) LDAP/
エルドラド /(n) El Dorado/
エルニーニョ /(n) El Nino (spa:)/
エルビウム /(n) erbium (Er)/
エルピー /(n) LP record/long-play(ing) record/
エルピーレコード /(n) LP record/
エルピー盤 [エルピーばん] /(n) LP/long-playing record/
エルフ /(n) elf/
エルボー /(n) elbow/
エルマン /(n) Herman/
エルム /(n) elm/
エルユー /(n) (comp) LU/
エルヴン /(adj-f) elven/
エレアコ /(n) (abbr) electric acoustic guitar/
エレア学派 [エレアがくは] /(n) Eleatic school (of philosophy)/
エレガンス /(adj-na) elegance/(P)/
エレガンスユニコーンフィッシュ /(n) elegant unicornfish (Naso elegans, species of Indian Ocean tang)/
エレガント /(adj-na,n) elegant/(P)/
エレガントコリス /(n) elegant coris (Coris venusta)/elegant wrasse/
エレガントユニコーンフィッシュ /(n) elegant unicornfish (Naso elegans, species of Indian Ocean tang)/
エレキ /(n) (1) (abbr) electricity/(2) (abbr) electric guitar/(P)/
エレキギター /(n) (col) electric guitar/(P)/
エレキテル /(n) electricity (Edo-period term) (dut: electriciteit)/
エレクション /(n) erection/
エレクト /(n,vs) erect/
エレクトーン /(n) (1) Electone/(2) electronic organ/
エレクトラコンプレックス /(n) Electra complex/
エレクトリカルキー /(n) (comp) electrical key/
エレクトリック /(adj-na,n) electric/(P)/
エレクトリックギター /(n) electric guitar/
エレクトリックコマース /(n) (comp) electric commerce/
エレクトリックベース /(n) electric bass/bass guitar/
エレクトレット /(n) electret/
エレクトロオフィス /(n) (abbr) electronic office/
エレクトロコテージ /(n) (abbr) electronic cottage/
エレクトロセラミックス /(n) electroceramics/
エレクトロタイプ /(n) electrotype/
エレクトロニクス /(n) electronics/(P)/
エレクトロニック /(n) electronic/
エレクトロニックオフィス /(n) electronic office/
エレクトロニックカフェ /(n) (comp) electronic cafe/
エレクトロニックコテージ /(n) electronic cottage/
エレクトロニックコマース /(n) (comp) electronic commerce/
エレクトロニックサウンド /(n) electronic sound/
エレクトロニックバンキング /(n) (comp) electronic banking/
エレクトロニックファイル /(n) electronic file/
エレクトロニックマネー /(n) electronic money/
エレクトロニックミュージック /(n) electronic music/
エレクトロニックメール /(n) electronic mail/
エレクトロバンキング /(n) (abbr) electronic banking/
エレクトロメーター /(n) electrometer/
エレクトロルミネセンス /(n) (comp) electroluminescence/electro-luminescence/electronic luminescence/EL/
エレクトロルミネッセンス /(n) (comp) electroluminescence/electro-luminescence/electronic luminescence/EL/
エレクトロン /(n) electron/
エレクトロンボルト /(n) electron volt/
エレジー /(n) elegy/
エレック /(n) (abbr) electronic cooking/
エレファンタイン /(adj-f) elephantine/
エレファント・ノーズ・フィッシュ /(n) elephantnose fish (Gnathonemus petersii)/
エレファントノーズフィッシュ /(n) elephantnose fish (Gnathonemus petersii)/
エレプシン /(n) erepsin/
エレベ /(n) (abbr) elevation/
エレベーション /(n) elevation/
エレベータ /(n) (1) elevator/lift/(2) elevator (aviation)/
エレベーター /(n) (1) elevator/lift/(2) elevator (aviation)/(P)/
エレベーターホール /(n) elevator landing/elevator hall/
エレベーター力士 [エレベーターりきし] /(n) sumo wrestler that keeps going up and down the rankings/
エレミヤ書 [エレミヤしょ] /(n) Jeremiah (book of the Bible)/
エレメンタリー /(n) elementary/
エレメント /(n) element/elements/
エロ /(adj-na,n,adj-no) erotic/eroticism/(P)/
エロい /(adj-i) (1) (col) erotic/pornographic/risque/(2) (sl) eminent/great/
エロかっこいい /(adj-i) (sl) sexy and cool/
エロアニメ /(n) (abbr) erotic animation/pornographic animation/animation containing explicit sexual content/
エロカワ /(n,adj-na,adj-no) (abbr) (sl) sexy, but still cute/
エロキューション /(n) elocution/
エログラム /(n) aerogram/aerogramme/
エログロ /(adj-na,n,adj-no) (abbr) erotic and grotesque/
エログロナンセンス /(n) (abbr) erotic and grotesque nonsense/
エロゲ /(n) (abbr) erotic game/
エロゲー /(n) (abbr) erotic game/
エロゲーム /(n) erotic game/
エロコイ /(n) purely sexual love/highly sexual love/
エロコメディ /(n) erotic comedy/
エロジナスゾーン /(n) erogenous zone/
エロス /(n) Eros/(P)/
エロダクション /(n) (abbr) erotic production/
エロチカ /(n) erotica/
エロチシズム /(n) eroticism/
エロチズム /(n) erotism/
エロチック /(adj-na,n) erotic/(P)/
エロトマニア /(n) erotomania/
エロプリ /(n) (abbr) (sl) erotic pictures taken at purikura/
エロプリクラ /(n) (sl) erotic pictures taken at purikura/
エロ可愛い [エロかわいい] /(adj-i) (sl) sexy, but still cute/
エロ画 [エロが] /(n) (abbr) (sl) erotic photograph (on a computer, mobile phone, etc.)/
エロ画像 [エロがぞう] /(n) erotic picture/
エロ写真 [エロしゃしん] /(n) erotic photograph/
エロ上戸 [エロじょうご] /(n) (derog) (sl) horny drunkard/
エロ本 [エロほん] /(n) erotic book/
エロ漫画 [エロまんが] /(n) erotic or pornographic manga/
エロ爺 [エロじじい] /(n) (sl) dirty old man/pervert/groper (on trains)/lecher/
エロ恋 [エロこい] /(n) purely sexual love/highly sexual love/
エンカウンター /(n) encounter/
エンカウンターグループ /(n) encounter group/
エンカウント /(n) (1) (abbr) (sl) an encounter (usu. in computer games) (wasei: encount)/(vs) (2) to encounter/
エンカプセレーション /(n) encapsulation/
エンガチョ /(n) (1) (chn) crossed fingers and word said to call someone to be avoided as 'dirty'/(vs) (2) to cross one's fingers (to ward off 'dirt')/
エンキャプシュレーション /(n) (comp) encapsulation/
エンク /(n) (comp) ENQ/
エンクリプト /(n) (comp) encrypt/
エンクロージャー /(n) enclosure/
エンクロージュア /(n) enclosure/
エングラム /(n) engram/n-gram/
エングレーバー /(n) engraver/
エンケファリン /(n) enkephalin/
エンゲージ /(n) engage/
エンゲージブルー /(n) engagement doubts (wasei: engage blue)/
エンゲージメント /(n) engagement/
エンゲージリング /(n) (abbr) engagement ring/
エンゲルの法則 [エンゲルのほうそく] /(n) Engel's law/
エンゲル係数 [エンゲルけいすう] /(n) Engel's coefficient/
エンコーダ /(n) (comp) encoder/
エンコーダー /(n) (comp) encoder/
エンコーディング /(n) encoding/
エンコード /(n) encode/
エンサイクロペディア /(n) encyclopedia/
エンザイム /(n) enzyme/
エンシレージ /(n) ensilage/
エンジェル /(n) angel/(P)/
エンジェルフィッシュ /(n) Bermuda blue angelfish (Holacanthus bermudensis)/
エンジニア /(n) engineer/(P)/
エンジニアリング /(n) engineering/(P)/
エンジニアリングセラミックス /(n) engineering ceramics/
エンジニアリングプラスチック /(n) engineering plastics/
エンジニアリングワークステーション /(n) (comp) engineering workstation/EWS/
エンジムシ /(n) (uk) cochineal insect (Dactylopius coccus)/
エンジュ /(n) (uk) Japanese pagoda tree (Sophora japonica)/
エンジョイ /(n,vs) enjoy/(P)/
エンジン /(n) engine/(P)/
エンジンを吹かす [エンジンをふかす] /(exp,v5s) to rev up the engine/
エンジンオイル /(n) engine oil/motor oil/
エンジンキー /(n) ignition key (wasei: engine key)/
エンジンストップ /(n) engine stall (wasei: engine stop)/
エンジンブレーキ /(n) engine brake/
エンジン故障 [エンジンこしょう] /(n) engine failure/
エンジン発動機 [エンジンはつどうき] /(n) engine/
エンスー /(n) (abbr) enthusiast/
エンスト /(n) (abbr) engine stall/
エンスペース /(n) (comp) en space/
エンゼル /(n) angel/(P)/
エンゼルフィシュ /(n) angelfish/
エンゼルフィッシュ /(n) angelfish/
エンゼルベビー /(n) angel baby/
エンター /(n) enter/
エンターキー /(n) (comp) Enter key/
エンターテイナー /(n) entertainer/
エンターテイメント /(n) entertainment/
エンターテインメント /(n) entertainment/(P)/
エンタープライズ /(n) enterprise/(P)/
エンタープライズＸアーキテクチャ [エンタープライズエックスアーキテクチャ] /(n) (comp) Enterprise X Architecture/
エンタープライズサーバレベルの /(n) (comp) enterprise-server-level/
エンタープライズレベル /(n) (comp) enterprise-level/
エンタイトル /(n) entitled/
エンタイトルツーベース /(n) two-base entitlement (baseball)/
エンタシス /(n) entasis/
エンタテイメンツ /(n) entertainments/
エンタテイメント /(n) entertainment/(P)/
エンタテインメント /(n) entertainment/
エンタブレチュア /(n) entablature/
エンタメ /(n) (abbr) entertainment/
エンタルピー /(n) enthalpy/
エンダイブ /(n) endive/
エンダッシュ /(n) (comp) en dash/
エンチーム /(n) enzyme/
エンチラーダ /(n) enchilada (spa:)/
エンティティ /(n) entity/
エンティティ種類 [エンティティしゅるい] /(n) (comp) entity type/
エンテレケイア /(n) entelechy (gre: entelecheia)/
エンテロウイルス /(n) enterovirus/
エンテロキナーゼ /(n) enterokinase/
エンディアン /(suf) (comp) -endian (i.e. big-endian or little-endian)/
エンディング /(n) ending/(P)/
エンディングノート /(n) booklet constituting an informal living will (containing wishes regarding one's hospitalization or funeral, and perhaps one's life story, messages to loved ones, etc.) (wasei: ending note)/
エントランス /(n) entrance/
エントランスホール /(n) entrance hall/
エントリ /(n,vs) entry/
エントリー /(n,vs) entry/(P)/
エントリーマシン /(n) (comp) entry machine/
エントリーモデル /(n) (comp) entry model/
エントリーレベル /(n) (comp) entry-level/
エントリポイント /(n) (comp) entry point/
エントリマシン /(n) (comp) entry machine/
エントリモデル /(n) (comp) entry model/
エントリ種別 [エントリしゅべつ] /(n) (comp) entry-type/
エントリ順データセット [エントリじゅんデータセット] /(n) (comp) ESDS/Entry-Sequenced Data Set/
エントリ情報 [エントリじょうほう] /(n) (comp) entry-information/
エントリ情報選択 [エントリじょうほうせんたく] /(n) (comp) entry-information-selection/
エントリ状況 [エントリじょうきょう] /(n) (comp) entry-status/
エントロピ /(n) (1) entropy/(2) mean information content/average information content/
エントロピー /(n) (1) entropy/(2) mean information content/average information content/
エンド /(n) end/(P)/
エンドウ豆 [エンドウまめ] /(n) pea (Pisum sativum)/green pea/
エンドエンド /(n) (comp) end to end/
エンドエンド通信パス [エンドエンドつうしんパス] /(n) (comp) end to end communication path/
エンドオブテキスト /(n) (comp) end-of-text/
エンドオブファイル /(n) (comp) end-of-file/
エンドカーラー /(n) end curler/
エンドキー /(n) (comp) End key/
エンドサイトーシス /(n) endocytosis/
エンドシステム /(n) (comp) end system/
エンドセリン /(n) endothelin/
エンドゾーン /(n) end zone/
エンドツーエンド /(n) (comp) end to end/
エンドツエンド /(n) (comp) end-to-end/
エンドトランザクション /(n) (comp) end-transaction/
エンドヌクレアーゼ /(n) endonuclease/
エンドプレート /(n) endplate/
エンドポイント /(n) (comp) endpoint/
エンドミル /(n) endmill/
エンドユーザ /(n) end user/
エンドユーザー /(n) end user/
エンドユーザーコンピューティング /(n) (comp) end user computing/EUC/
エンドラーズ・ライブベアラ /(n) Endler's livebearer (Poecilia wingei)/Endler's guppy/
エンドラーズライブベアラ /(n) Endler's livebearer (Poecilia wingei)/Endler's guppy/
エンドライン /(n) end line/
エンドラン /(n) (abbr) hit-and-run (baseball)/
エンドリン /(n) endrin/
エンドルフィン /(n) endorphin/
エンドレス /(adj-na) endless/(P)/
エンドレステープ /(n) endless tape/
エンドロール /(n) credits roll (at the end of a show or movie) (wasei: endroll)/end credit roll/
エンハンストアイディーイー /(n) (comp) Enhanced IDE/
エンハンストシーユーシーミー /(n) (comp) Enhanced Cu-SeeMe/
エンハンストパラレルインタフェース /(n) (comp) enhanced parallel interface/
エンハンストモード /(n) (comp) enhanced mode/
エンハンスドＣＤ [エンハンスドシーディー] /(n) (comp) enhanced compact disc/
エンハンスドモード /(n) (comp) enhanced mode/
エンハンスメント /(n) enhancement/
エンバーゴー /(n) embargo/
エンバーミング /(n) embalming/
エンバイロメント /(n) environment/
エンバシー /(n) embassy/
エンパイア /(n) empire/
エンパイアステートビル /(n) Empire State Building/
エンパイアチューブ /(n) empire tube/
エンパイアデー /(n) Empire Day/
エンパシー /(n) empathy/
エンパワーメント /(n) empowerment/
エンピツビャクシン /(n) (uk) eastern red cedar (Juniperus virginiana)/
エンファサイズ /(n) emphasize/emphasise/
エンファシス /(n) emphasis/
エンフォースメント /(n) enforcement/
エンブリオ /(n) embryo/
エンブレム /(n) emblem/(P)/
エンブロイダリー /(n) embroidery/
エンブロイダリーレース /(n) embroidery lace/
エンプティー /(n) empty/
エンプティーネスト /(n) empty nest/
エンプティーネストシンドローム /(n) empty nest syndrome/
エンプティオマニア /(n) emptiomania/
エンプラ /(n) (abbr) engineering plastics/
エンプレス /(n) empress/
エンベロープ /(n) envelope/
エンペラ /(n) squid fin/
エンペラー /(n) emperor/
エンペラー・テトラ /(n) emperor tetra (Nematobrycon palmeri)/
エンペラーテトラ /(n) emperor tetra (Nematobrycon palmeri)/
エンペラーペンギン /(n) emperor penguin (Aptenodytes forster)/
エンボス /(n) emboss/
エンボス加工 [エンボスかこう] /(n) embossment/
エンマーク /(n) (comp) Yen mark/
エンラージメント /(n) enlargement/
エンリッチ /(n) enrich/
エンリッチド・エア /(n) enriched air/air with additional oxygen added/
エンリッチドエア /(n) enriched air/air with additional oxygen added/
エンレイソウ /(n) (uk) Trillium smallii (species of trillium)/
オーアールデービー /(n) (comp) ORDB/
オーアールビー /(n) (comp) ORB/
オーイーエム /(n) (comp) OEM/
オーエー /(n) (comp) (abbr) OA/office automation/(P)/
オーエーディージー /(n) (comp) OADG/
オーエス /(int) heave! (fre: oh hisse)/heave-ho/
オーエスアールツー /(n) (comp) OSR2/
オーエスアイ /(n) (comp) OSI/
オーエスツー /(n) (comp) OS-2/
オーエスツーワープ /(n) (comp) OS-2 Warp/
オーエルイー /(n) (comp) OLE/
オーエルティーピー /(n) (comp) OLTP/
オーカー /(n) ochre (fre: ocre)/
オーガ /(n) ogre/(P)/
オーガスト /(n) August/
オーガズム /(n) orgasm (ger: Orgasmus)/
オーガナイザー /(n) organizer/organiser/
オーガナイズ /(n,vs) organize/organise/
オーガナイゼーション /(n) (comp) organization/
オーガニゼーション /(n) organization/organisation/
オーガニゼイション /(n) organization/organisation/
オーガニック /(n) organic/
オーガニック農法 [オーガニックのうほう] /(n) organic farming/
オーガンザ /(n) organza/
オーガンディー /(n) organdy/
オーキシン /(n) auxin (plant growth hormone)/
オーキッド /(n) orchid/
オーク /(n) (1) oak/(2) orc/(P)/
オークション /(n) auction/(P)/
オークションサイト /(n) auction site/
オークションブリッジ /(n) auction bridge/
オークス /(n) oaks/(P)/
オークル /(n) ochre (fre: ocre)/
オーケストラ /(n) orchestra/(P)/
オーケストラピット /(n) orchestra pit/
オーケストラボックス /(n) orchestra box/
オーケストリオン /(n) orchestrion/
オーケストレーション /(n) orchestration/
オーサー /(n) author/
オーサリングシステム /(n) (comp) authoring system/
オーサリングソフト /(n) (comp) authoring software/
オーサリングソフトウェア /(n) (comp) authoring software/
オーサリングツール /(n) (comp) authoring tool (WWW)/
オーサリングプラットフォーム /(n) (comp) authoring platform/
オーサリングプログラム /(n) (comp) authoring program/
オーシーアール /(n) (comp) OCR/
オーシーエックス /(n) (comp) OCX/
オーシーエヌ /(n) (comp) OCN/
オーシャニック・ホワイトティップ・シャーク /(n) oceanic whitetip shark (Carcharhinus longimanus)/
オーシャニックホワイトティップシャーク /(n) oceanic whitetip shark (Carcharhinus longimanus)/
オーシャノート /(n) oceanaut/
オーシャン /(n) ocean/(P)/
オーシャンサージャン /(n) ocean surgeon (Acanthurus bahianus, species of Atlantic tang)/
オーシャンサージョン /(n) ocean surgeon (Acanthurus bahianus, species of Atlantic tang)/
オーシャンレース /(n) ocean race/
オージー /(n) (1) orgy/(2) Australian (Aussie)/
オージーパーティー /(n) (1) orgy party/(2) Australian (Aussie) party/
オージェーティー /(n) on-the-job training/OJT/
オースチン /(n) Austin/
オースティン /(n) Austin/
オーステナイト /(n) austenite/
オーストララシア /(n) Australasia/
オーストラリア /(n) (uk) Australia/
オーストラリアサーモン /(n) Australian salmon (Arripis trutta)/
オーストラリアン・マーブル・キャットシャーク /(n) Australian marbled catshark (Atelomycterus macleayi, species endemic to Australia)/
オーストラリアンスウェルシャーク /(n) Australian swellshark (Cephaloscyllium laticeps, species of catshark which inhabits the continental shelf of southern Australia)/
オーストラリアンマーブルキャットシャーク /(n) Australian marbled catshark (Atelomycterus macleayi, species endemic to Australia)/
オーストラリア区 [オーストラリアく] /(n) Australian (zoogeographical region)/
オーストラリア式フットボール [オーストラリアしきフットボール] /(n) Aussie-Rules Football/Australian-Rules Football/
オーストラリア諸語 [オーストラリアしょご] /(n) Aboriginal languages (of Australia)/
オーストラリア人 [オーストラリアじん] /(n) Australian person/
オーストラロイド /(n) Australoid/
オーストラロピテクス /(n) Australopithecus (lat:)/
オーストリア /(n) Austria/
オーストリア学派 [オーストリアがくは] /(n) Austrian School (of economic theory)/
オーストリア継承戦争 [オーストリアけいしょうせんそう] /(n) War of the Austrian Succession (1740-1748)/
オーストリッチ /(n) ostrich/
オーストリッチレザー /(n) ostrich leather/
オーストロアジア語族 [オーストロアジアごぞく] /(n) Austro-Asiatic languages/
オーストロネシア語族 [オーストロネシアごぞく] /(n) Austronesian languages/
オーセンティシティ /(n) authenticity/
オーセンティック /(adj-na) authentic/
オーソグラフィー /(n) orthography/
オーソスコープ /(n) orthoscope (instrument for examining the iris)/
オーソドキシー /(n) orthodoxy/
オーソドックス /(adj-na,n) orthodox/(P)/
オーソライズ /(n,vs) authorize/authorise/authorization/authorisation/
オーソリティ /(n) authority/
オーソリティー /(n) authority/
オータム /(n) autumn/
オーダ /(n,vs) order/
オーダー /(n,vs) order/(P)/
オーダーエントリー /(n) order entry/
オーダーエントリーシステム /(n) order entry system/
オーダーメード /(n) made-to-order (wasei: order made)/custom-made/(P)/
オーダーメード医療 [オーダーメードいりょう] /(n) personalized medicine (wasei: order-made medicine)/
オーダーメイド /(n) made-to-order (wasei: order made)/custom-made/(P)/
オーダーメイド医療 [オーダーメイドいりょう] /(n) personalized medicine (wasei: order-made medicine)/
オーダシティ /(n) audacity/
オーダスィティ /(ik) (n) audacity/
オーダセティ /(ik) (n) audacity/
オーチャード /(n) orchard/(P)/
オーチャードグラス /(n) orchard grass/
オーツ /(n) oat (Avena sativa)/oats/
オーデービーエムエス /(n) (comp) ODBMS/
オーディーエヌ /(n) (comp) ODN/
オーディービーシー /(n) (comp) ODBC/
オーディーピー /(n) (comp) ODP/
オーディーン /(n) Odin/
オーディエンス /(n) audience/
オーディエンスサーベイ /(n) audience survey/
オーディオ /(n) audio/(P)/
オーディオアンプ /(n) audio amp/audio amplifier/
オーディオカセットプレーヤ /(n) (comp) tape player/audio cassette player/
オーディオクリップ /(n) audio clip/
オーディオビジュアル /(n) audio-visual/
オーディオブック /(n) audio book (book read onto CD or tape)/
オーディオメーター /(n) audiometer/
オーディオ信号発生器 [オーディオしんごうはっせいき] /(n) tone generator/audio signal generator/AF signal generator/
オーディション /(n) audition/(P)/
オーディトリアム /(n) auditorium/
オーディナリー /(n) ordinary/
オーディン /(n) (comp) ODIN/
オーデコロン /(n) eau de Cologne (fre:)/
オート /(n) (1) auto/automobile/automatic/(2) oat/oats/(P)/
オートインクリメント /(n) (comp) auto-increment/
オートインデント /(n) (comp) auto indent/
オートウォーク /(n) moving walkway/
オートエグゼックバット /(n) (comp) AUTOEXEC.BAT/
オートキャンプ /(n) autocamping/(P)/
オートクチュール /(n) haute couture (fre:)/(P)/
オートクラシー /(n) autocracy/
オートクラッチ /(n) automatic clutch/
オートクレーブ /(n) autoclave/
オートクロス /(n) autocross/
オートケーキ /(n) oatcake/
オートショー /(n) auto show/
オートジャイロ /(n) autogyro (helicopter)/
オートスクロール /(n) (comp) auto scroll/
オートスケーリング /(n) (comp) autoscaling/
オートストップ /(n) automatic stop/
オートセーブ /(n) (comp) auto save/
オートダイヤル /(n) (comp) auto dial/
オートチェンジャー /(n) auto-changer (tape recorder)/
オートチューニングデッキ /(n) automatic tuning deck/
オートデクリメント /(n) (comp) auto-decrement/
オートトランスフォーマー /(n) (comp) auto transformer/
オートドア /(n) auto door/
オートナース /(n) auto-nurse/
オートノミックコンピューティング /(n) (comp) autonomic computing/
オートバイ /(n) motorcycle (wasei: auto-bike)/(P)/
オートバイオグラフィー /(n) autobiography/
オートバイレース /(n) motorcycle race/
オートバックス /(n) autobacks/
オートパーラー /(n) auto parlor/auto parlour/
オートパイロット /(n) autopilot/
オートパワーオフ /(n) (comp) auto power off/
オートフォーカス /(n) auto focus/
オートプレーヤー /(n) auto player/
オートホワイトバランス /(n) (comp) auto white balance/AWB/
オートポイエーシス /(n) autopoiesis/
オートマ /(n) (abbr) automatic/
オートマウント /(n) (comp) automount/
オートマチック /(adj-na,n) automatic/(P)/
オートマチック・シフト /(n) automatic transmission/
オートマチックコントロール /(n) automatic control/
オートマチックシフト /(n) automatic transmission/
オートマチックトランスミッション /(n) automatic transmission/
オートマチック車 [オートマチックしゃ] /(n) automatic transmission car/
オートマット /(n) automat/
オートマティスム /(n) automatism/
オートマトン /(n) automaton/
オートマトン理論 [オートマトンりろん] /(n) (comp) automata theory/
オートマニピュレーター /(n) auto-manipulator/
オートマ車 [オートマしゃ] /(n) automatic car/car with automatic transmission/
オートミール /(n) oatmeal/
オートミールクッキー /(n) oatmeal cookie/
オートメ /(n) (abbr) automation/
オートメーション /(n) automation/(P)/
オートメーション理論 [オートメーションりろん] /(n) (comp) automatics/
オートモーチブ /(adj-f) automotive/
オートモービル /(n) automobile/
オートモビル /(n) automobile/
オートラジオグラフィー /(n) autoradiography/
オートリターン /(n) automatic return/
オートリトラクト /(n) (comp) auto retract/
オートリバース /(n) automatic reverse tape-recorder (wasei: auto reverse)/
オートリピート /(n) automatic repeat/
オートレース /(n) autoracing/
オートレイズ /(n) auto-raise/
オートロード /(n) autoload/
オートログイン /(n) (comp) auto login/auto-login/
オートロック /(n) self-locking (wasei: autolock)/(P)/
オート三輪 [オートさんりん] /(n) three-wheeler vehicle/
オート麦 [オートむぎ] /(n) oats/
オード /(n) ode/(P)/
オードコロン /(n) eau de Cologne (fre:)/
オードトワレ /(n) eau de toilette (fre:)/
オードビ /(n) brandy (fre: eau de vie)/
オードブル /(n) hors d'oeuvre (fre:)/(P)/
オーナ /(n) owner/
オーナー /(n) owner/(P)/
オーナーシステム /(n) owner system/
オーナーシップ /(n) (comp) ownership/
オーナードライバー /(n) owner-driver/
オーナーパイロット /(n) owner-pilot/
オーナシェフ /(n) owner-chef/
オーナメント /(n) ornament/
オーニソプター /(n) ornithopter/
オーニング /(n) awning/
オーバ /(adj-na,n,vs) (1) (abbr) overcoat/(2) over/exceeding/going beyond/exaggeration/(3) ball hit over the head of an outfielder (baseball)/(P)/
オーバー /(adj-na,n,vs) (1) (abbr) overcoat/(2) over/exceeding/going beyond/exaggeration/(3) ball hit over the head of an outfielder (baseball)/(P)/
オーバーアクション /(n) overaction/
オーバーウエート /(n) overweight/
オーバーオール /(n) overall/
オーバーオールポジション /(n) overall position/
オーバーキル /(n) overkill/
オーバークロッキング /(n) (comp) overclocking/
オーバークロック /(n) (comp) overclock/
オーバーコート /(n) overcoat/
オーバーコール /(n) over-rule (in tennis) (wasei: over call)/
オーバーシューズ /(n) overshoes (waterproof covers for shoes)/galoshes/
オーバーシューツ /(n) overshoes (waterproof covers for shoes)/galoshes/
オーバーシュート /(n) (comp) overshoot/
オーバースキル /(n) overskill/
オーバーステップ /(n) overstep/(P)/
オーバースライド /(n) overslide/
オーバースロー /(n) (abbr) overhand throw (baseball)/
オーバーゾーン /(n) overzone/
オーバータイム /(n) overtime/
オーバーダビング /(n) overdubbing/
オーバーダブ /(n) overdub/
オーバーチャージ /(n) overcharge/
オーバーチュア /(n) overture/
オーバーテクノロジー /(n) super technology (wasei: over technology)/technology beyond our current capabilities, mainly in science fiction/
オーバートップ /(n) overtop/
オーバードクター /(n) unemployed person with a PhD (wasei: over doctor)/
オーバードライブ /(n) overdrive/
オーバードライブプロセッサ /(n) (comp) over drive processor/ODP/
オーバードラフト /(n) overdraft/overdraught/
オーバーナイト /(n) overnight/
オーバーナイトバッグ /(n) overnight bag/
オーバーナイトフォトサービス /(n) overnight photo service/
オーバーネット /(n) reaching over the net (volleyball, etc.) (wasei: over net)/
オーバーハング /(n) overhang/
オーバーハンド /(n) overhand/
オーバーハンドスロー /(n) overhand throw/
オーバーハンドパス /(n) overhand pass/
オーバーパー /(n) over par (golf)/
オーバーヒート /(n,vs) overheat/(P)/
オーバーフェンス /(n) over fence/
オーバーフロー /(n) overflow/
オーバーフローエラー /(n) (comp) overflow error/
オーバーフロールーチング /(n) (comp) overflow routing/
オーバーフロールート /(n) (comp) overflow route/
オーバーフロー表示 [オーバーフローひょうじ] /(n) (comp) overflow indication/
オーバーブッキング /(n) overbooking/
オーバーブラウス /(n) overblouse/
オーバープルーフ /(n) overproof/
オーバープレゼンス /(n) overpresence/
オーバーヘッド /(n) overhead/
オーバーヘッドキック /(n) overhead kick/
オーバーヘッドスロー /(n) overhead throw/
オーバーヘッドパス /(n) overhead pass/
オーバーヘッドプロジェクター /(n) overhead projector/
オーバーペース /(n) overpace/
オーバーホール /(n,vs) overhaul/
オーバーボローイング /(n) overborrowing/
オーバーライト /(n) overwrite/
オーバーライド /(n) override/
オーバーラップ /(n,vs) overlap/(P)/
オーバーラップウィンドウ /(n) (comp) overlap window/
オーバーラップウィンドウ方式 [オーバーラップウィンドウほうしき] /(n) (comp) overlapped windowing/
オーバーラン /(n,vs) overrun/(P)/
オーバーレー /(n,vs) (1) overlay/(2) (comp) overlay (segment)/
オーバーレイ /(n,vs) (1) overlay/(2) (comp) overlay (segment)/
オーバーレイネットワーク /(n) (comp) overlay network/
オーバーローディング /(n) overloading/
オーバーロード /(n) overload/
オーバーローン /(n) overlent situation in a bank (wasei: overloan)/
オーバーワーク /(n) overwork/
オーバコート /(n) overcoat/
オーバチュア /(n) overture/
オーバパンチ /(n,vs) overpunch/
オーバフロー /(n,vs) (comp) overflow/
オーバヘッド /(n) overhead/
オーバヘッドタイム /(n) (comp) overhead time/
オーバヘッドプロジェクター /(n) (comp) Overhead Projector/
オーバラップ /(n) (comp) overlap/
オーバラン /(n,vs) (comp) overrun/
オーバル /(n) oval/
オーバレイ /(n,vs) (1) overlay/(2) (comp) overlay (segment)/
オーバレイアドレッシング /(n) (comp) overlay addressing/
オーバレイモデル /(n) (comp) overlay model/
オーバレイルーチング /(n) (comp) overlay routing/
オーバレイ区分 [オーバレイくぶん] /(n) (comp) overlay (segment)/
オーバレイ構造 [オーバレイこうぞう] /(n) (comp) overlay structure/
オーパーツ /(n) out of place artifact/OOPArt/
オーパス /(n) opus (lat:, eng:)/
オービス /(n) automatic camera for detecting and recording speeding vehicles (from Orbis - brand name)/
オービター /(n) orbiter/
オーピーエス /(n) (comp) OPS/
オーファンドラッグ /(n) orphan drug/
オーブ /(n) orb/
オーブン /(n) oven/(P)/
オーブントースター /(n) oven toaster/toaster oven/
オーブンレンジ /(n) combination microwave and (gas or electric bar) oven/
オープナー /(n) opener/
オープニング /(n) opening/(P)/
オープニングゲーム /(n) opening game/
オープニングナンバー /(n) opening number/
オープン /(adj-na,n,vs) open/(P)/
オープン・カフェ /(n) pavement cafe (wasei: open cafe)/sidewalk cafe/open-air cafe/
オープン・チケット /(n) open ticket/
オープンアーキテクチャ /(n) (comp) open architecture/
オープンアカウント /(n) open account/
オープンウオーターダイバー /(n) open water diver/
オープンエア /(n) open-air/
オープンエンド /(n) open-end/
オープンエンドスパナ /(n) (comp) open-end wrench/
オープンエンドモーゲージ /(n) open-end mortgage/
オープンカー /(n) convertible (wasei: open car)/(P)/
オープンカット /(n) open-cut/
オープンカフェ /(n) pavement cafe (wasei: open cafe)/sidewalk cafe/open-air cafe/
オープンカラー /(n) open collar/
オープンキッチン /(n) open kitchen/
オープンキャプション /(n) open caption/
オープンキャンパス /(n) open campus/
オープンクライアント /(n) (comp) OpenClient/
オープンゲーム /(n) open game/
オープンコース /(n) open course/
オープンコンピュータネットワーク /(n) (comp) Open Computer Network/OCN/
オープンゴルフ /(n) open golf/
オープンサイド /(n) open side (rugby)/
オープンサンド /(n) (abbr) open sandwich/
オープンサンドイッチ /(n) open sandwich/
オープンシステム /(n) open system/
オープンシステムの会社 [オープンシステムのかいしゃ] /(n) (comp) open systems company/
オープンシステム病院 [オープンシステムびょういん] /(n) open system hospital/
オープンシャツ /(n) open-necked shirt (wasei: open shirt)/
オープンショップ /(n) open shop/
オープンショップ制 [オープンショップせい] /(n) open shop system (employment of both unionists and non-unionists)/
オープンスカイ /(n) airline deregulation policy (wasei: open sky)/
オープンスクール /(n) school(s) with flexible, child-centred curricula (wasei: open school)/
オープンスタンス /(n) open stance/
オープンスペース /(n) open space/clearing/
オープンセサミ /(n) open sesame/
オープンセット /(n) open set/(P)/
オープンソース /(n) (comp) open source (software, etc.)/
オープンソースの会社 [オープンソースのかいしゃ] /(n) (comp) open source vendor/open source company/
オープンソースコード /(n) (comp) open source code/
オープンソースソフトウェア /(n) (comp) open source software/
オープンチケット /(n) open ticket/
オープンテニス /(n) open tennis/
オープンデーティングシステム /(n) open-dating system/
オープンディスカッション /(n) open discussion (style of meeting)/
オープンディスプレー /(n) open display/
オープントレード /(n) open trade/
オープンドア /(n) open door/
オープンドック /(n) (comp) OpenDoc/
オープンネットワーク /(n) (comp) open network/
オープンハウス /(n) open house/
オープンヒールタイプ /(n) type of scuba fin with an open heel, also called "adjustable fins"/
オープンファイル /(n) (comp) open file/
オープンファイル記述 [オープンファイルきじゅつ] /(n) (comp) open file description/
オープンフェース /(n) open face/
オープンフレーム /(n) open frame/
オープンプライス /(n) (comp) open price/
オープンプラットフォーム /(n) (comp) open platform/
オープンプランニング /(n) open planning/
オープンプレー /(n) open play/
オープンマーケット /(n) open market/
オープンマーケットオペレーション /(n) open market operation/
オープンマネーマーケット /(n) open money market/
オープンマリッジ /(n) open marriage/
オープンユニバーシティー /(n) Open University/
オープンリール /(n) open reel/
オープンリールテープ /(n) open-reel tape/
オープンルック /(n) (comp) OPENLOOK/
オープン化 [オープンか] /(n) (comp) opening/
オープン価格 [オープンかかく] /(n) (comp) open price/
オープン勘定 [オープンかんじょう] /(n) open account/
オープン最短パスファースト [オープンさいたんパスファースト] /(n) (comp) open shortest path first/OSPF/
オープン戦 [オープンせん] /(n) exhibition game (baseball)/open game/(P)/
オープン選手権 [オープンせんしゅけん] /(n) open competition/
オープン投信 [オープンとうしん] /(n) open investment trust/
オーベルジュ /(n) auberge (French-style inn and restaurant) (fre:)/
オーペア /(n) au pair/
オーペアガール /(n) au pair girl/
オーペントーナメント /(n) open tournament/
オーボー /(n) oboe (ita:)/
オーボエ /(n) oboe (ita:)/(P)/
オーボエダモーレ /(n) oboe d'amore (ita:)/
オーム /(n) Ohm/
オームの法則 [オームのほうそく] /(n) Ohm's law/
オーメン /(n) omen/
オーラ /(n) aura/(P)/
オーライ /(n) all right/OK/
オーラップ /(n) (comp) OLAP/
オーラミン /(n) auramine/
オーラル /(n) oral/
オーラルアプローチ /(n) oral approach/
オーラルコミュニケーション /(n) aural communication/
オーラルセックス /(n) oral sex/
オーラルピル /(n) (obsc) oral pill (i.e. oral contraceptive pill)/
オーラルメソッド /(n) oral method/
オール /(n) (1) oar/(2) all/(3) (sl) staying up all night long/(P)/
オールＡ [オールエイ] /(n) straight As/all As/
オールイングリッシュ /(n) all English (method of teaching English)/
オールインワン /(n) all-in-one/
オールインワンＰＣ [オールインワンピーシー] /(n) (comp) all-in-one Personal Computer/
オールインワンパソコン /(n) (comp) all-in-one personal computer/
オールウェザー /(adj-no) all-weather/
オールウェザーコート /(n) all-weather coat/
オールウエーブ /(n) all-wave (receiver)/
オールウエザー /(n) all-weather/
オールウエザーコート /(n) all-weather coat/
オールウエザートラック /(n) all-weather track/
オールオーディナリーズ /(n) All Ordinaries (Australian stock index)/
オールオアナシング /(n) all or nothing/
オールオアナッシング /(exp) all-or-nothing/
オールオケージョンドレス /(n) all-occasion dress/
オールギャランティー /(n) all guarantee/
オールシーズンコート /(n) all-season coat/
オールシーズントラック /(n) all-season track/
オールシーズンドレス /(n) all-season dress/
オールスクエア /(n) all square/
オールスター /(n) all-star (cast)/
オールスターキャスト /(n) all-star cast/(P)/
オールスターゲーム /(n) all-star game/
オールスパイス /(n) allspice/
オールターナティブ /(adj-na) alternative/
オールターナティブスクール /(n) alternative school/
オールターナティブスペース /(n) alternative space/
オールタナティブ /(n) alternative/
オールディー /(n) oldie/
オールディーズ /(n) oldies/
オールトーキー /(exp) all talkie/
オールトの雲 [オールトのくも] /(n) Oort cloud/
オールト雲 [オールトうん] /(n) Oort cloud/
オールド /(n) old/
オールドイングリッシュシープドッグ /(n) Old English sheepdog/
オールドウーマンエンジェルフィッシュ /(n) old woman angelfish (Pomacanthus rhomboides)/
オールドエコノミー /(n) Old Economy/
オールドカード /(n) old guard/(P)/
オールドガード /(n) old guard/
オールドタイマー /(n) old-timer/
オールドパー /(n) Old Parr/
オールドパワー /(n) old power/
オールドファッション /(n) old-fashioned/
オールドファッショングラス /(n) oldfashioned glass/
オールドファン /(n) old fan/
オールドボーイ /(n) old boy/
オールドミス /(n) (sens) old maid (wasei: old miss)/
オールドリベラリスト /(n) old liberalist/
オールドローズ /(n) old rose/
オールナイト /(n) all-night/(P)/
オールヌード /(n) totally naked (wasei: all nude)/buck naked/
オールバック /(n) swept back hair (wasei: all back)/
オールパーパス /(n) all-purpose/
オールパス /(n) all pass/
オールボアール /(int) au revoir (fre:)/good-bye/
オールマイティー /(adj-na,n) almighty/(P)/
オールラウンダー /(n) all-rounder/
オールラウンド /(adj-na) all-round/(P)/
オールラウンドプレーヤー /(n) all-round player/
オールリスクス /(n) all risks/
オールロケ /(n) (abbr) all locations/
オールヴォワール /(int) au revoir (fre:)/good-bye/
オール電化 [オールでんか] /(adj-no) all-electric (e.g. heating)/
オーレ /(n) (comp) OLE/
オーレオマイシン /(n) Aureomycin (chlortetracycline)/
オーロックス /(n) aurochs/urus (extinct ancestor of the modern cow, Bos taurus)/
オーロラ /(n) aurora/(P)/
オーロン /(n) Orlon/
オア /(n) (comp) OR/
オアシス /(n) (1) oasis/(2) (comp) OASYS (Fujitsu WP system)/(P)/
オアス /(n) (comp) OAS/
オアペック /(n) Organization of Arab Petroleum Exporting Countries (Organisation)/OAPEC/
オイカワ /(n) (uk) freshwater minnow/pale chub (Zacco platypus)/
オイキムチ /(n) cucumber kimchi (kor: oi kimch'i)/
オイゲノール /(n) eugenol/
オイスター /(n) oyster/
オイスターソース /(n) oyster sauce/
オイタナシー /(n) euthanasia (ger: Euthanasie)/
オイチョカブ /(n) oicho-kabu (traditional Japanese gambling card game)/
オイディプス /(n) Oedipus/(P)/
オイラーの定理 [オイラーのていり] /(n) Euler's theorem/
オイリー /(adj-na) oily/greasy/
オイル /(n) oil/engine oil/kerosene/(P)/
オイルエンジン /(n) oil engine/
オイルカラー /(n) oil color/oil colour/
オイルガス /(n) oilgas/
オイルクーラー /(n) oil cooler/
オイルクロース /(n) oilcloth/
オイルクロス /(n) oilcloth/
オイルサーディン /(n) oiled sardine/
オイルサンド /(n) oil sands/tar sands/bituminous sands/
オイルシェール /(n) oil shale/
オイルシャンプー /(n) oil shampoo/
オイルショック /(n) oil crisis, es. 1973 OPEC oil crisis (wasei: oil shock)/
オイルシルク /(n) oiled silk/
オイルスキン /(n) oilskin/
オイルステイン /(n) oil stain/
オイルストーン /(n) oilstone/
オイルタンカー /(n) oiltanker/
オイルダラー /(n) oil dollar/
オイルダンパー /(n) oil damper/
オイルドレザー /(n) oiled leather/
オイルバーナー /(n) oil burner/
オイルパック /(n) oil pack/
オイルヒーター /(n) oil-heater/
オイルファシリティー /(n) oil facility/
オイルフィニッシュ /(n) oil finish/
オイルフェンス /(n) oil fence/(P)/
オイルブレーキ /(n) oil brake/
オイルペインティング /(n) oil painting/
オイルペイント /(n) oil paint/
オイルボール /(n) oil ball/
オイルポンプ /(n) oil pump/
オイルマッサージ /(n) oil massage/
オイルマネー /(n) oil money/
オイルロード /(n) oil road/
オイル語 [オイルご] /(n) langue d'oil/
オウギチョウチョウウオ /(n) scrawled butterflyfish (Chaetodon meyeri)/Meyer's butterflyfish/
オウギハクジラ /(n) (uk) Stejneger's beaked whale (Mesoplodon stejnegeri)/
オウギバショウ /(n) (uk) traveller's tree (Ravenala madagascariensis)/traveller's palm/
オウゴンヒワ /(n) (uk) American goldfinch (Carduelis tristis)/
オウサマペンギン /(n) (uk) king penguin (Aptenodytes patagonicus)/
オウチュウ /(n) (uk) black drongo (Dicrurus macrocercus)/
オウバーチャージ /(n) overcharge/
オウバイ /(n) (uk) winter jasmine (Jasminum nudiflorum)/
オウム /(n) (uk) (large) parrot (inc. the cockatoo)/
オウムガイ /(n) (uk) chambered nautilus (esp. species Nautilus pompilius)/
オウムブダイ /(n) palenose parrotfish (Scarus psittacus)/
オウム真理教 [オウムしんりきょう] /(n) Aum Shinrikyou religious group/
オウム病 [オウムびょう] /(n) psittacosis/parrot fever/
オウラフィン /(n) olefin/
オウンゴール /(n) own goal (soccer)/
オオアメリカモモンガ /(n) (uk) northern flying squirrel (Glaucomys sabrinus)/
オオアリクイ /(n) (uk) giant anteater (Myrmecophaga tridactyla)/
オオアワガエリ /(n) (uk) timothy (Phleum pratense)/timothy grass/
オオイトカケガイ /(n) (uk) precious wentletrap (Epitonium scalare)/
オオウナギ /(n) (uk) giant mottled eel (Anguilla marmorata)/marbled eel/
オオウミガラス /(n) (uk) great auk (Pinguinus impennis)/
オオウラジロノキ /(n) malus tschonoskii/white angel/
オオカナダモ /(n) (uk) Brazilian elodea (species of aquatic plant, Egeria densa)/
オオカバマダラ /(n) monarch butterfly (Danaus plexippus)/
オオカミ /(n) (uk) wolf (carnivore, Canis lupus)/
オオカミウオ /(n) (uk) Bering wolffish (Anarhichas orientalis)/
オオカミ少年 [オオカミしょうねん] /(n,vs) boy who cried wolf/
オオカメノキ /(n) viburnum furcatum/
オオギハクジラ /(ik) (n) (uk) Stejneger's beaked whale (Mesoplodon stejnegeri)/
オオクチバス /(n) largemouth bass (Micropterus salmoides)/bigmouth bass/
オオクログワイ /(n) (uk) Chinese water chestnut (Eleocharis dulcis)/
オオクロムクドリモドキ /(n) (uk) common grackle (Quiscalus quiscula)/
オオグチバス /(n) largemouth bass (Micropterus salmoides)/bigmouth bass/
オオグンカンドリ /(n) (uk) great frigatebird (Fregata minor)/
オオケタデ /(n) (uk) kiss-me-over-the-garden-gate (species of smartweed, Polygonum orientale)/prince's feather/
オオコウモリ /(n) (uk) fruit bat/flying fox/
オオコノハズク /(n) (uk) collared scops owl (Otus bakkamoena)/
オオゴマダラ /(n) (uk) tree nymph butterfly (Idea leuconoe)/
オオサガ /(n) (uk) Sebastes iracundus (species of rockfish)/
オオサンショウウオ /(n) (uk) Japanese giant salamander (Andrias japonicus)/
オオシマザクラ /(n) (uk) Oshima cherry (Prunus speciosam, P. lannesiana var. speciosa)/
オオシラビソ /(n) (uk) Maries' fir (Abies mariesii)/
オオジカ /(n) (1) large deer/(2) moose/elk/red deer/
オオジシギ /(n) (uk) Latham's snipe (Gallinago hardwickii)/
オオジュリン /(n) (uk) reed bunting (Emberiza schoeniclus)/
オオスジヒメジ /(n) dash-and-dot goatfish (Parupeneus barberinus)/
オオスズメバチ /(n) (uk) Asian giant hornet (Vespa mandarinia)/yak-killer hornet/
オオセ /(n) (uk) Japanese wobbegong (Orectolobus japonicus, species of carpet shark)/Japanese carpet shark/fringe shark/
オオセッカ /(n) (uk) Japanese marsh warbler (Megalurus pryeri)/
オオセ科 [オオセか] /(n) Orectolobidae (family containing 11 species in 3 genera of carpet sharks known as wobbegongs)/
オオセ属 [オオセぞく] /(n) Orectolobus (genus containing 9 species of wobbegong carpet sharks in the family Orectolobidae)/
オオゾウムシ /(n) (uk) Japanese giant weevil (Sipalinus gigas)/
オオタカ /(n) (1) (uk) northern goshawk (Accipiter gentilis)/(2) female hawk (or falcon)/(3) (abbr) falconry (using a northern goshawk)/
オオタナゴ /(n) (uk) Acheilognathus macropterus (species of cyprinid)/
オオタニワタリ /(n) (uk) Asplenium antiquum (species of spleenwort)/
オオタマオシコガネ /(n) (uk) scarab beetle/sacred scarab (Scarabaeus sacer)/
オオツノヒツジ /(n) (uk) (obsc) bighorn sheep (Ovis canadensis)/
オオテンジクザメ /(n) tawny nurse shark (Nebrius ferrugineus, species found in the Indo-Pacific)/
オオテンジクザメ属 [オオテンジクザメぞく] /(n) Nebrius (genus of a single species of nurse shark in the family Ginglymostomatidae)/
オオデマリ /(n) (uk) Japanese snowball/Viburnum plicatum/
オオトカゲ /(n) (uk) monitor lizard/
オオトカゲ科 [オオトカゲか] /(n) Varanidae (family of carnivorous monitor lizards whose only living genus is Varanus)/
オオトカゲ属 [オオトカゲぞく] /(n) Varanus (genus of carnivorous monitor lizards in the family Varanidae)/
オオトリテエ /(ok) (n) authority/
オオノガイ /(n) (uk) Mya arenaria oonogai (subspecies of soft-shell clam)/
オオハクチョウ /(n) (uk) whooper swan (Cygnus cygnus)/
オオハシ /(n) (uk) toucan/
オオハシウミガラス /(n) (uk) razorbill (Alca torda)/
オオバウチワエビ /(n) (uk) smooth fan lobster (Ibacus novemdentatus)/
オオバギボウシ /(n) (uk) ooba (big leaves) plantation lily/Hosta sieboldiana/
オオバコ /(n) (uk) plantain (esp. Asian plantain, Plantago asiatica)/
オオバコ科 [オオバコか] /(n) Plantaginaceae (the plantain family)/
オオバタン /(n) (uk) Moluccan cockatoo (Cacatua moluccensis)/salmon-crested cockatoo/
オオバライチゴ /(n) a variety of raspberry (Rubus croceacanthus H. Lev.)/
オオバン /(n) (uk) coot (Fulica atra)/
オオヒキガエル /(n) (uk) cane toad/marine toad/giant toad (Bufo marinus)/
オオヒゲマワリ /(n) (uk) volvox/
オオヒメグモ /(n) (uk) common house spider (Achaearanea tepidariorum)/
オオフエヤッコダイ /(n) longnose butterflyfish (Forcipiger longirostris)/
オオフルマカモメ /(n) (uk) giant petrel (esp. the southern giant petrel, Macronectes giganteus)/
オオヘビガイ /(n) (uk) scaly worm shell (Serpulorbis imbricatus)/
オオマシコ /(n) (uk) Pallas's rosefinch (Carpodacus roseus)/
オオマツヨイグサ /(n) (uk) red-sepaled evening primrose (Oenothera erythrosepala)/
オオミズ /(n) white angel/malus tschonoskii/
オオミズアオ /(n) (uk) emperor moth (Actias artemis)/Japanese moon moth/
オオミズナギドリ /(n) (uk) streaked shearwater (species of seabird, Calonectris leucomelas)/
オオミズネズミ /(n) rakali (Hydromys chrysogaster)/water-rat/
オオムカデ /(n) (uk) Scolopendra subspinipes (species of centipede)/
オオムラサキ /(n) (1) giant purple butterfly (species of nymphalid butterfly, Sasakia charonda)/(2) Rhododendron oomurasaki (species of purple azalea)/
オオメジロザメ /(n) (uk) bull shark (Carcharhinus leucas)/
オオメハゼ /(n) flame goby (Trimma macrophthalmum)/large-eyed dwarfgoby/red-spotted pygmy-goby/
オオモズ /(n) (uk) northern shrike/great grey shrike (Lanius excubitor)/
オオヨシキリ /(n) (uk) great reed warbler (Acrocephalus arundinaceus)/
オオヨモギ /(n) Artemisia montana/
オオルリ /(n) (uk) blue-and-white flycatcher (Cyanoptila cyanomelana)/
オオワニザメ /(n) smalltooth sand tiger (Odontaspis ferox)/ragged-tooth shark/
オオワニザメ科 [オオワニザメか] /(n) Odontaspididae (family of four species in two genera of lamniform sand sharks, also known as sand tiger sharks or ragged tooth sharks)/
オオワニザメ属 [オオワニザメぞく] /(n) Odontaspis (genus of two species in the sand shark family Odontaspididae)/
オカズ /(n) (1) (uk) accompaniment for rice dishes/side dish/(2) food for thought (esp. in the context of conversation, or material for assisting arousal during masturbation)/
オカチメンコ /(n) (uk) (woman's) ugly or homely face/old bag/
オカトラノオ /(n) (uk) gooseneck loosestrife (Lysimachia clethroides)/
オカヒジキ /(n) (uk) Salsola komarovii (species of saltwort)/
オカピ /(n) okapi (giraffe-like animal)/
オカマ /(n) (1) (pol) pot/(2) volcanic crater/(3) (one's) buttocks/(4) (uk) (col) male homosexual/effeminate man/male transvestite/
オカメインコ /(n) (uk) cockatiel (Nymphicus hollandicus)/
オカヤドカリ /(n) (uk) concave land hermit crab (Coenobita cavipes)/
オカリナ /(n) ocarina (type of flute) (ita:)/(P)/
オカルチャー /(n) (abbr) occult culture/
オカルティズム /(n) occultism/
オカルティック /(adj-na) occult (wasei: occultic)/spooky/eerie/
オカルト /(adj-na,adj-no) occult/(P)/
オカルトブーム /(n) occult fad/occult boom/
オガサワオオコウモリ /(n) (uk) Bonin flying fox (Pteropus pselaphon)/
オガサワラマシコ /(n) (uk) Bonin grosbeak (Chaunoproctus ferreorostris, extinct)/
オガタマノキ /(n) (uk) Michelia compressa (species of Japanese tree similar to champak)/
オガライト /(n) wood briquet/
オキアミ /(n) (uk) krill/euphasiid (any species in the family Euphausiacea)/
オキエソ /(n) (uk) bluntnose lizardfish (Trachinocephalus myops)/snakefish/
オキゴンドウ /(n) (uk) false killer whale (Pseudorca crassidens)/
オキサイド /(n) oxide/
オキサロ酢酸 [オキサロさくさん] /(n) oxaloacetic acid/
オキシゲナーゼ /(n) oxygenase (ger: Oxygenase)/
オキシジェン /(n) oxygen/
オキシダーゼ /(n) oxidase/
オキシダント /(n) oxidant/
オキシダント雲 [オキシダントぐも] /(n) oxidant cloud/
オキシテトラサイクリン /(n) oxytetracycline/
オキシトシン /(n) oxytocin/
オキシドール /(n) (hydrogen) peroxide (solution) (ger: Oxydol)/
オキシドレダクターゼ /(n) oxidoreductase/
オキシフル /(n) Oxyfull (Japanese brand of hydrogen peroxide)/
オキシヘモグロビン /(n) oxyhemoglobin/
オキシラン /(n) oxirane/ethylene oxide/
オキソニウムイオン /(n) oxonium ion/
オキソ酸 [オキソさん] /(n) oxoacid/
オキナエビス /(n) (uk) Beyrich's slit shell (species of sea snail, Pleurotomaria beyrichii)/
オキナエビスガイ /(n) (uk) Beyrich's slit shell (species of sea snail, Pleurotomaria beyrichii)/
オキナヒメジ /(n) blackspot goatfish (Parupeneus spilurus)/
オキナメクラ /(n) Myxine paucidens (species of hagfish from the Sagaminada Sea in Japan)/
オキナワオオコウモリ /(n) (uk) Okinawa flying fox (Pteropus loochoensis) (extinct)/
オキナワベニハゼ /(n) Okinawa rubble goby (Trimma okinawae)/red-spotted dwarfgoby/orange-red goby/Okinawa pygmy-goby/
オキナワヤマイモ /(n) (obsc) water yam (Dioscorea alata)/winged yam/purple yam/
オキニシ /(n) (uk) warty frog shell (Bursa bufonia dunkeri)/
オキフエダイ /(n) blacktail snapper (Lutjanus fulvus)/
オキュパイド /(n) occupied/
オキュペーショナルセラピー /(n) occupational therapy/
オギノ式 [オギノしき] /(n) Ogino method/
オギョウ /(n) (uk) Jersey cudweed (species of cottonweed, Gnaphalium affine)/
オクシデンタリズム /(n) occidentalism/
オクシデンタル /(adj-na) occidental/
オクシデント /(n) Occident/
オクスフォード /(n) Oxford/
オクスブリッジ /(n) Oxbridge (i.e. Oxford and Cambridge)/
オクターブ /(n) octave (fre:)/(P)/
オクターボ /(n) octavo/
オクタボ /(n) octavo/
オクタン /(n) octane/
オクタン価 [オクタンか] /(n) octane value/
オクテット /(n) octet/
オクテット列型 [オクテットれつがた] /(n) (comp) octet-string type/
オクトーバー /(n) October/
オクトパス /(n) (1) (abbr) octopus/(2) octopus regulator/alternate 2nd stage air pressure regulator used as an alternate air source in an emergency/
オクラ /(n) (1) shelving (a play, movie, etc.)/closing down/cancelling/canceling/the shelf/(2) rice storehouse of the Edo shogunate/
オクラ /(n) okra (herb) (Abelmoschus esculentus)/(P)/
オクラホマ /(n) Oklahoma/(P)/
オグロ /(n) graceful shark (Carcharhinus amblyrhynchoides, species of requiem shark found in the tropical Indo-Pacific)/
オグロシギ /(n) (uk) black-tailed godwit (species of sandpiper, Limosa limosa)/
オグロメジロザメ /(n) (uk) blacktail reef shark (Carcharhinus amblyrhynchos, species of Indo-Pacific requiem shark)/grey reef shark/
オケ /(n) (abbr) orchestra/(P)/
オケる /(v5r) (sl) to go to a karaoke bar/
オケラ /(n) (uk) mole cricket (esp. the Oriental mole cricket, Gryllotalpa orientalis)/
オコジョ /(n) stoat/ermine/short-tailed weasel (Mustela erminea)/
オゴポゴ /(n) Ogopogo (lake monster reported to live in Canada's Lake Okanagan)/
オサガメ /(n) (uk) leatherback turtle (Dermochelys coriacea)/
オサゾウムシ /(n) (uk) true weevil (any weevil of family Curculionidae)/
オシザメ /(n) false catshark (species of deep water ground shark, Pseudotriakis microdon)/
オシザメ科 [オシザメか] /(n) Pseudotriakidae (family with only one species of false catshark, Pseudotriakis microdon)/
オシャレ /(adj-na,adj-no) (1) (uk) smartly dressed/stylish/fashion-conscious/(n) (2) someone smartly dressed/(vs) (3) to dress up/to be fashionable/
オショロコマ /(n) dolly varden (species of trout, Salvelinus malma, esp. subspecies Salvelinus malma malma) (ain:)/
オシロ /(n) (abbr) oscilloscope/
オシログラフ /(n) oscillograph/
オシログラム /(n) oscillogram/
オシロスコープ /(n) oscilloscope/
オシロメーター /(n) oscillometer/
オジサン /(n) (1) (hon) (fam) uncle/(2) (fam) old man/mister (vocative)/(3) (uk) manybar goatfish (Parupeneus multifasciatus)/
オジロジカ /(n) (uk) white-tailed deer (Odocoileus virginianus)/whitetail deer/
オス /(n) male (animal)/
オスカー /(n) Oscar/(P)/
オスコネクタ /(n) (comp) male connector/
オスジイソハゼ /(n) zebra goby (Eviota zebrina)/five-bar pygmy-goby/
オスジクロハギ /(n) ringtail surgeonfish (Acanthurus blochii, species of tang from the Indo-Pacific)/blue-banded pualu/dark surgeon/tailring surgeonfish/
オスティナート /(n) ostinato (ita:)/
オステオポローシス /(n) osteoporosis/
オストラシズム /(n) ostracism/
オストリッチ /(n) ostrich/
オストリッチポリシー /(n) ostrich policy/
オストワルト表色系 [オストワルトひょうしょくけい] /(n) (comp) Ostwald color system/
オスネジ /(n) male screw/
オスパー /(n) ocean space explorer/OSPER/
オスマントルコ /(n) Ottoman Turks/
オスマン朝 [オスマンちょう] /(n) Ottoman (Osmanli) dynasty/
オスマン帝国 [オスマンていこく] /(n) Ottoman Empire/
オスマン帝国憲法 [オスマンていこくけんぽう] /(n) First Turkish (Ottoman) Constitution/
オスミウム /(n) osmium (Os)/
オスメス変換 [オスメスへんかん] /(n) (comp) gender bender/
オスメス変換器 [オスメスへんかんき] /(n) (comp) gender changer/sex changer/
オス猿 [オスざる] /(n) male monkey/
オセアニア /(n) Oceania/(P)/
オセロ /(n) Othello (board game)/
オセロゲーム /(n) Othello (board game) (wasei: Othello game)/
オセロット /(n) ocelot (feline, Felis pardalis)/
オゾン /(n) ozone/(P)/
オゾンホール /(n) ozone hole/(P)/
オゾン層 [オゾンそう] /(n) ozone layer/
オゾン層保護法 [オゾンそうほごほう] /(n) Ozone Layer Protection Law/
オタ /(n,suf) (col) (abbr) nerd/geek/enthusiast/
オタク /(n) (col) geek/nerd/enthusiast/otaku/(P)/
オタッキー /(adj-na) geeky/otaku-y/
オタネニンジン /(n) (uk) Asian ginseng (Panax ginseng)/
オタマジャクシ /(n) (1) tadpole/(2) ladle/(3) musical note/
オタリア /(n) South American sea lion (Otaria flavescens) (lat: Otaria)/
オタワ /(n) Ottawa/(P)/
オタ芸 [オタげい] /(n) type of fan who yells and dances at pop concerts, etc./
オタ車 [オタしゃ] /(n) (col) otaku car (painted with anime characters, loaded with figures and stuffed dolls, etc.)/
オダマキ /(n) (uk) fan columbine (Aquilegia flabellata)/
オダリスク /(n) odalisque/odalisk/
オッカムの剃刀 [オッカムのかみそり] /(n) Occam's razor/Ockham's razor/
オックステール /(n) oxtail/
オックスフォード /(n) Oxford/(P)/
オックスフォード学派 [オックスフォードがくは] /(n) (obsc) Oxford school (of analytic philosophy)/
オック語 [オックご] /(n) (1) langue d'oc/(2) Occitan/
オッズ /(n) chances of winning (a bet)/odds/
オッタートロール /(n) otter trawl/
オッターハウンド /(n) otterhound/
オットセイ /(n) (uk) fur seal (esp. the northern fur seal, Callorhinus ursinus)/Alaskan fur seal/
オットマン /(n) ottoman/
オッドアイ /(n) eyes mismatched in colour (color) (wasei: odd eye)/
オッパイ /(n) (1) (chn) breasts/boobies/tits/(2) (chn) breast milk/
オッファー /(n,vs) offer/
オップアート /(n) op art/optical art/
オツネンチョウ /(n) (uk) (obsc) eastern pale clouded yellow (butterfly, Colias erate)/
オデッセイ /(n) Odyssey/
オトギリソウ /(n) (uk) Hypericum erectum (species of St. John's wort)/
オトギリソウ科 [オトギリソウか] /(n) Clusiaceae (family of plants including St. John's worts and mangosteens)/Guttiferae/
オトギリソウ属 [オトギリソウぞく] /(n) Hypericum (plant genus including St. John's worts)/
オトギリソウ目 [オトギリソウもく] /(n) Guttiferales (plant order)/
オトシンクルス /(n) dwarf sucker (Otocinclus spp.) (lat: Otocinclus)/
オトト /(n) (uk) (chn) fish/
オトナ語 [オトナご] /(n) adult language/office jargon/
オトヒメエビ /(n) (uk) banded coral shrimp (Stenopus hispidus)/coral banded shrimp/banded boxer shrimp/
オトメツバキ /(n) (uk) otome camellia (Camellia japonica f. otome)/
オトメベラ /(n) moon wrasse (Thalassoma lunare)/
オドメーター /(n) odometer/
オドリコソウ /(n) (uk) Lamium album var. barbatum (variety of white deadnettle)/
オナー /(n) honor/honour/
オナる /(v5r) (col) to masturbate/
オナカップ /(n) artificial vagina (ger: Onanie, eng: cup)/
オナガガモ /(n) (uk) northern pintail (Anas acuta)/
オナガザメ /(n) (uk) thresher shark (esp. the common thresher shark, Alopias vulpinus)/
オナガザメ科 [オナガザメか] /(n) Alopiidae (family with three species of thresher sharks all within the genus Alopias)/
オナガザメ属 [オナガザメぞく] /(n) Alopias (genus of three extant thresher shark species in the family Alopiidae)/
オナガザル /(n) (uk) cercopithecoid (any Old World monkey of family Cercopithecidae, esp. the guenons of genus Cercopithecus)/
オナガスズメダイ /(n) Allen's chromis (Chromis alleni)/
オナガドチザメ /(n) pygmy ribbontail catshark (Eridacnis radcliffei, found in the Indo-West Pacific)/
オナガドチザメ属 [オナガドチザメぞく] /(n) Eridacnis (genus of finback catshark in the family Proscylliidae)/
オナゴダケ /(n) (uk) (obsc) Simon bamboo (Pleioblastus simonii)/
オナドル /(n) (abbr) fantasy object for masturbation (wasei: onanism idol)/
オナニ /(n) (X) (col) onanism (ger: Onanie)/masturbation/
オナニー /(n) (X) (col) onanism (ger: Onanie)/masturbation/
オナペット /(n) (obs) fantasy object for masturbation (wasei: onanism pet)/
オナホ /(n) sex sleeve (wasei: onanism hole)/masturbation device that mimics female genitalia/
オナホール /(n) sex sleeve (wasei: onanism hole)/masturbation device that mimics female genitalia/
オニイ系 [オニイけい] /(n) men's fashion style characterized by brown hair and deep-tanned skin, expensive brand-name clothes and accessories/
オニオコゼ /(n) (uk) devil stinger (Inimicus japonicus)/
オニオン /(n) onion (edible plant, Allium cepa)/(P)/
オニカサゴ /(n) (uk) scorpionfish (Scorpaenopsis cirrhosa)/hairy stingfish/
オニカッコウ /(n) (uk) Asian koel (Eudynamys scolopacea)/
オニカマス /(n) (uk) great barracuda (Sphyraena barracuda)/
オニキス /(n) onyx/
オニキンメ /(n) (uk) common fangtooth (Anoplogaster cornuta)/
オニグモ /(n) (uk) Araneus ventricosus (species of orb-weaving spider)/
オニグルミ /(n) (uk) Manchurian walnut (Juglans mandshurica)/
オニタビラコ /(n) (uk) Oriental false hawksbeard (Youngia japonica)/
オニダルマオコゼ /(n) (uk) reef stonefish (Synanceia verrucosa)/stonefish/devilfish/
オニックス /(n) onyx/
オニテングハギ /(n) humpback unicornfish (Naso brachycentron, species of Indo-Pacific tang)/
オニネズミ /(n) (uk) greater bandicoot rat (Bandicota indica)/
オニノヤガラ /(n) (uk) Gastrodia elata (species of saprophytic orchid)/
オニハタタテダイ /(n) masked bannerfish (Heniochus monoceros)/pennant coralfish/
オニベニハゼ /(n) Trimma yanagitai (species of goby found in Japan)/
オニボウズギス /(n) (uk) black swallower (Chiasmodon niger)/
オニヤンマ /(n) (uk) Anotogaster sieboldii (largest species of dragonfly in Japan)/
オネジ /(n) male screw/
オネトーム /(n) respectable person (fre: honnete homme)/
オノコロ島 [オノコロじま] /(n) (1) (arch) Onokoro Island (in Japanese mythology, the island formed by drops of water falling from the heavenly jeweled spear)/Onogoro Island/(2) Japan/
オノゴロ島 [オノゴロじま] /(n) (1) (arch) Onokoro Island (in Japanese mythology, the island formed by drops of water falling from the heavenly jeweled spear)/Onogoro Island/(2) Japan/
オノマトピーア /(n) onomatopoeia (fre: onomatopee)/
オノマトペ /(n) onomatopoeia (fre: onomatopee)/
オノマトペー /(n) onomatopoeia (fre: onomatopee)/
オノマトペア /(n) onomatopoeia (fre: onomatopee)/
オノマンネングサ /(n) (uk) needle stonecrop (Sedum lineare)/
オハイオ /(n) Ohio/(P)/
オハグロハギ /(n) Thompson's surgeonfish (Acanthurus thompsoni, species of Indo-Pacific tang whose Indian Ocean population lacks the white caudal fin of the Pacific variety)/
オバールクロミス /(n) Hawaiian chromis (Chromis ovalis)/oval chromis/
オバむ /(v5m) (sl) (various meanings, including) to chant, "Yes we can, yes we can!"/
オバデア書 [オバデアしょ] /(n) Obadiah (book of the Bible)/
オバデヤ書 [オバデヤしょ] /(n) Obadiah (book of the Bible)/
オバルブミン /(n) ovalbumin/
オパール /(n) opal (fre:)/
オパールガラス /(n) opal glass/
オヒシバ /(n) (uk) Indian goosegrass (Eleusine indica)/
オヒョウ /(n) (uk) halibut (esp. the Pacific halibut, Hippoglossus stenolepis)/
オヒョウ /(n) Manchurian elm (Ulmus laciniata) (ain:)/
オヒルギ /(n) (uk) black mangrove (Bruguiera gymnorrhiza)/
オビイソハゼ /(n) broad-banded pygmy goby (Eviota latifasciata)/
オビトウカイスズメダイ /(n) Okinawa chromis (Chromis okamurai)/
オビラプトル /(n) oviraptor (species of dinosaur, Oviraptor philoceratops)/
オピウム /(n) opium/
オピオイド /(n) opioid/
オピオイドペプチド /(n) opioid peptide/
オピニオン /(n) opinion/(P)/
オピニオンリーダー /(n) opinion leader/(P)/
オフ /(n) off/(P)/
オファー /(n,vs) offer/
オフィオライト /(n) ophiolite/
オフィサー /(n) officer/
オフィシャル /(adj-na,n) official/(P)/
オフィシャルゲーム /(n) official game/
オフィシャルサプライヤー /(n) official supplier/
オフィシャルハンデ /(n) official handicap (golf)/
オフィシャルレコード /(n) official record/
オフィス /(n) office/(P)/
オフィスアプリケーション /(n) (comp) office application/
オフィスアメニティ /(n) office amenity/
オフィスアワー /(n) office hours/working day/
オフィスエックスピー /(n) (comp) OfficeXP/
オフィスオートメーション /(n) office automation/
オフィスガール /(n) office girl/
オフィスキュウジュウゴ /(n) (comp) Office95/
オフィスキュウジュウハチ /(n) (comp) Office98/
オフィスコンピュータ /(n) (comp) office computer/
オフィスコンピューター /(n) (comp) office computer/
オフィスソフト /(n) office software package/office suite/
オフィスニセン /(n) (comp) Office2000/
オフィスパーク /(n) office park/
オフィスビル /(n) office building/office complex/
オフィスラブ /(n) love affair with colleague (wasei: office love)/
オフィスランドスケープ /(n) office landscape/
オフィスレディ /(n) female office worker (wasei: office lady)/OL/
オフィスレディー /(n) female office worker (wasei: office lady)/OL/
オフィスワイフ /(n) office wife/
オフェンス /(n) offense/offence/
オフオフブロードウェー /(n) off-off-Broadway/
オフコース /(exp) of course/
オフコン /(n) (comp) (abbr) office computer/
オフサイトセンター /(n) off-site centre (center)/
オフサイド /(n) off-side/(P)/
オフサイドトラップ /(n) offside trap/
オフザジョブトレーニング /(n) off-the-job training/
オフザレコード /(n) off the record/
オフシーズン /(n) off-season/(P)/
オフショア /(n) offshore/
オフショアカンパニー /(n) offshore company/
オフショアセンター /(n) offshore center/offshore centre/
オフショアファンド /(n) offshore fund/
オフショア開発 [オフショアかいはつ] /(n) (comp) offshore development/
オフショア市場 [オフショアいちば] /(n) offshore market/
オフショルダー /(n) off shoulder/
オフショルダーネックライン /(n) off-the-shoulder neckline/
オフスクリーンメモリ /(n) (comp) off-screen memory/
オフセット /(n) offset/
オフセット印刷 [オフセットいんさつ] /(n) (comp) offset printing/
オフタートル /(n) knit top with a loose turtleneck or cowl neck design (wasei: off turtle)/
オフタイム /(n) off-time/
オフトラック /(n) (comp) off-track/
オフビート /(n) off-beat/
オフフック /(n) off hook (line)/OH/
オフブロードウェー /(n) off Broadway/
オフホワイト /(n,adj-no) off-white/
オフマイク /(n) off mike/
オフミ /(n) (comp) (abbr) offline meeting/
オフライン /(n) off-line/
オフラインストレージ /(n) (comp) offline storage/
オフラインフォルダファイル /(n) (comp) offline folder file/
オフラインヘルプ /(n) (comp) offline help/
オフラインミーティング /(n) (comp) off-line meeting/
オフライン記憶装置 [オフラインきおくそうち] /(n) (comp) offline storage/
オフランプ /(n) off-ramp/
オフリミット /(n) off-limits/
オフレコ /(n,adj-no) off-the-record/(P)/
オフロード /(n) off-road/(P)/
オフロードバイク /(n) off-road bike/
オフロードレース /(n) off-road race/
オフ会 [オフかい] /(n) offline meeting (face-to-face meeting by people who normally interact online)/
オブザーバ /(n) observer/(P)/
オブザーバー /(n) observer/(P)/
オブジェ /(n) objet d'art (fre:)/item of artwork/(P)/
オブジェクション /(n) objection/
オブジェクト /(n) object/
オブジェクトのリンクと埋め込み [オブジェクトのリンクとうめこみ] /(n) (comp) Object Linking and Embedding/OLE/
オブジェクトオリエンテッド /(n) (comp) object-oriented/
オブジェクトクラス /(n) (comp) object class/
オブジェクトコード /(n) (comp) object code/
オブジェクトデータベース管理システム [オブジェクトデータベースかんりシステム] /(n) (comp) object database management system/
オブジェクトファイル /(n) (comp) object file/
オブジェクトブラウザ /(n) (comp) object browser/
オブジェクトプログラム /(n) (comp) object program/
オブジェクトモジュール /(n) (comp) object module/
オブジェクトモデリングツール /(n) (comp) object modeling tool/
オブジェクトモデルダイアグラム /(n) (comp) object model diagram/
オブジェクトライブラリ /(n) (comp) object library/
オブジェクト記述子型 [オブジェクトきじゅつしがた] /(n) (comp) object descriptor type/
オブジェクト技術 [オブジェクトぎじゅつ] /(n) (comp) object technology/
オブジェクト指向 [オブジェクトしこう] /(n,adj-no) (comp) object-oriented/
オブジェクト指向インタフェース [オブジェクトしこうインタフェース] /(n) (comp) object-oriented interface/
オブジェクト指向グラフィックス [オブジェクトしこうグラフィックス] /(n) (comp) object-oriented graphics/
オブジェクト指向データベース [オブジェクトしこうデータベース] /(n) (comp) object-oriented database/OODB/
オブジェクト指向プログラミング [オブジェクトしこうプログラミング] /(n) (comp) object-oriented programming/
オブジェクト指向型データベース [オブジェクトしこうがたデータベース] /(n) (comp) object oriented database/
オブジェクト指向言語 [オブジェクトしこうげんご] /(n) (comp) object-oriented language/
オブジェクト識別子 [オブジェクトしきべつし] /(n) (comp) object identifier/
オブジェクト識別子型 [オブジェクトしきべつしがた] /(n) (comp) object identifier type/
オブジェクト修飾 [オブジェクトしゅうしょく] /(n) (comp) object modification/
オブストラクション /(n) obstruction/
オブセッション /(n) obsession/
オブラート /(n) oblate (dut: oblaat, ger: oblate)/(P)/
オブラートに包む [オブラートにつつむ] /(exp,v5m) use an indirect expression/
オブリーク /(n) (abbr) oblique line/
オブリガート /(n) obbligato (ita:)/
オブリクバタフライフィッシュ /(n) oblique butterflyfish (Prognathodes obliquus)/
オブリゲーション /(n) obligation/
オプアート /(n) op art/optical art/
オプショナル /(n) optional/
オプショナルツアー /(n) optional tour/
オプショナルパーツ /(n) optional parts/
オプション /(n) option/(P)/
オプションキー /(n) (comp) Option key/
オプションスイッチ /(n) (comp) option switch/
オプションボタン /(n) (comp) option button/
オプション契約 [オプションけいやく] /(n) option contract/
オプション取引 [オプションとりひき] /(n) option trading/option dealing/option transaction/
オプス /(n) opus (lat:, eng:)/
オプス・デイ /(n) Opus Dei (Roman Catholic organization)/
オプスデイ /(n) Opus Dei (Roman Catholic organization)/
オプソニン /(n) opsonin/
オプチミスティック /(adj-na) optimistic/
オプチミスト /(n) optimist/
オプチミズム /(n) optimism/
オプティカル /(n) optical/
オプティカルアート /(n) optical art/
オプティカルスキャナ /(n) (comp) optical scanner/
オプティカルプリンタ /(n) (comp) optical printer/
オプティカルマウス /(n) (comp) optical mouse/
オプティプレックス /(n) (comp) OptiPlex/
オプティマイザ /(n) optimizer/optimiser/
オプティマイズ /(n) optimize/optimise/
オプティミスティック /(adj-f) optimistic/
オプティミスト /(n) optimist/
オプティミズム /(n) optimism/
オプトエレクトロニクス /(n) optoelectronics/
オプトメカニカルマウス /(n) (comp) optomechanical mouse/
オベリスク /(n) obelisk/
オベルスク /(n) obelisk/
オペ /(n) (abbr) medical operation/(P)/
オペーク /(n) opaque/
オペアンプ /(n) (abbr) operational amplifier/
オペコード /(n) (comp) operation code/op-code/
オペコド /(n) (comp) opcode/
オペック /(n) Organization of Petroleum Exporting Countries (Organisation)/OPEC/
オペラ /(n) opera (ita:)/(P)/
オペラグラス /(n) opera glasses/
オペラコミック /(n) comic opera (fre: opera-comique)/
オペラセリア /(n) opera seria (ita:)/
オペラハウス /(n) opera house/
オペラハット /(n) opera hat/
オペラバッグ /(n) opera bag/
オペラブッファ /(n) opera buffa (ita:)/
オペラント /(n) operant/
オペラント条件づけ [オペラントじょうけんづけ] /(n) operant conditioning/
オペラント条件付け [オペラントじょうけんづけ] /(n) operant conditioning/
オペランド /(n) (comp) operand/
オペラ歌手 [オペラかしゅ] /(n) opera singer/
オペラ座 [オペラざ] /(n) opera house/
オペレーショナル /(adj-na) operational/
オペレーション /(n) operation/(P)/
オペレーションコード /(n) (comp) operation code/op-code/
オペレーションズ /(n) operations/
オペレーションズリサーチ /(n) operations research/OR/
オペレーションセンター /(n) operation center/operation centre/
オペレーションツイスト /(n) operation twist/
オペレーションマニュアル /(n) (comp) Operations manuals/
オペレーションリサーチ /(n) operations research/
オペレータ /(n) operator/
オペレーター /(n) operator/(P)/
オペレーティング /(n) operating/
オペレーティングシステム /(n) (comp) operating-system/OS/
オペレーティングシステムイメージ /(n) (comp) operating system image/
オペレーティングシステムファームウェア /(n) (comp) operating system firmware/
オペレーティングマージン /(n) operating margin/
オペレーティング環境 [オペレーティングかんきょう] /(n) (comp) operating environment/
オペレイティングシステム /(n) (comp) operating-system/OS/
オペレッタ /(n) operetta (ita:)/(P)/
オペロン /(n) operon/
オペロン説 [オペロンせつ] /(n) operon theory (Jacob & Monod, 1961)/
オボアルブミン /(n) ovalbumin/
オボロキンチャクダイ /(n) velvet angelfish (Chaetodontoplus dimidiatus)/phanthom angelfish/
オポジションパーティー /(n) opposition party/
オポチュニスト /(n) opportunist/
オポチュニズム /(n) opportunism/
オポッサム /(n) opossum/
オマージュ /(n) homage (fre: hommage)/
オマール /(n) lobster (fre: homard)/
オマールエビ /(n) lobster/
オマール蝦 [オマールえび] /(n) lobster/
オマール海老 [オマールえび] /(n) lobster/
オマーン /(n) Oman/
オマーンバタフライフィッシュ /(n) Oman butterflyfish (Chaetodon dialeucos)/
オマキザル /(n) (uk) any monkey of family Cebidae (esp. the capuchin monkeys of genus Cebus, but also including marmosets, tamarins and squirrel monkeys)/
オミット /(n) (1) exception/exclusion/(vs) (2) to omit/to disallow (e.g. in a sport after a rule is broken)/to reject (e.g. faulty product)/to eject/to expel/to throw out/
オミナエシ /(n) (uk) golden lace (Patrinia scabiosifolia)/scabious patrinia/yellow patrinia/
オムツ /(n) (uk) diaper/nappy/(P)/
オムツ気触れ [オムツかぶれ] /(n) (uk) diaper rash/nappy rash/
オムニバス /(n) omnibus/(P)/
オムニマックス /(n) (comp) OMNIMAX/
オムライス /(n) (abbr) omelet with a filling of ketchup-seasoned fried rice (omelette) (wasei: omelet rice)/
オムレツ /(n) omelette/omelet/(P)/
オムロン /(n) Omron Corporation (Japanese electronics firm)/(P)/
オメガ３脂肪酸 [オメガさんしぼうさん] /(n) omega-3 fatty acid/
オメガ航法 [オメガこうほう] /(n) omega navigation/
オモダカ /(n) (uk) threeleaf arrowhead (Sagittaria trifolia)/
オモナガフタホシハゼ /(n) Eviota partimaculata (species of Indo-Pacific pygmy goby)/
オモナガフタボシイソハゼ /(n) Eviota partimacula (species of pygmy goby found in the Marshall Islands)/
オモニ /(n) mother (kor:)/
オヤジギャル /(n) (sl) young woman who acts like an old man/
オヤジ化 [オヤジか] /(exp) (sl) growing old/
オヤニラミ /(n) (uk) aucha perch (Coreoperca kawamebari)/
オヤビッチャ /(n) Indo-Pacific sergeant-major fish (Abudefduf vaigiensis)/
オヤビッチャ属 [オヤビッチャぞく] /(n) Abudefduf (genus of damselfish in the family Pomacentridae)/
オヤマスズメ /(n) (uk) (obsc) alpine accentor (Prunella collaris)/
オヨギイソハゼ /(n) twostripe pygmy goby (Eviota bifasciata)/doublebar goby/
オヨギベニハゼ /(n) yellow cave goby (Trimma taylori, species found in Indo-Pacific waters)/cave dwarfgoby/yellow-speckled pygmy-goby/
オライオン /(n) (comp) Orion/
オラクル /(n) oracle/(P)/
オラクルアイエーエス /(n) (comp) Oracle iAS/
オラクルアプリケーション /(n) (comp) Oracle Applications/
オラクルイービーエス /(n) (comp) Oracle EBS/
オラクルエイト /(n) (comp) Oracle 8/
オラクルエイトアイ /(n) (comp) Oracle 8i/
オラクルセブン /(n) (comp) Oracle 7/
オラクルナインアイ /(n) (comp) Oracle 9i/
オラクルナインアイエーエス /(n) (comp) Oracle 9iAS/
オラショ /(n) Horatio/
オラトリオ /(n) oratorio (ita:)/(P)/
オランウータン /(n) orangutan/(P)/
オランダイチゴ /(n) (uk) garden strawberry (Fragaria x ananassa)/
オランダカイウ /(n) (uk) calla lily (Zantedeschia aethiopica)/
オランダ海芋 [オランダかいう] /(n) (uk) calla lily (Zantedeschia aethiopica)/
オランダ語 [オランダご] /(n) Dutch (language)/
オランダ人 [オランダじん] /(n) Dutchman/
オランダ東インド会社 [オランダひがしインドがいしゃ] /(n) Dutch East India Company/
オランダ領ギアナ [オランダりょうギアナ] /(n) Netherlands Guiana/
オランダ苺 [オランダいちご] /(n) (uk) garden strawberry (Fragaria x ananassa)/
オランデーズソース /(n) sauce Hollandaise/
オリーブ /(n,adj-no) olive (fre:)/
オリーブオイル /(n) olive oil/
オリーブグリーン /(n) olive green/
オリーブドラブ /(n) olive drab/
オリーブヒメキツツキ /(n) (uk) olivaceous piculet (species of bird, Picumnus olivaceus)/
オリーブ色 [オリーブいろ] /(n) olive (colour, color)/olive brown/(P)/
オリーブ姫啄木鳥 [オリーブひめきつつき] /(n) (uk) olivaceous piculet (species of bird, Picumnus olivaceus)/
オリーブ油 [オリーブゆ] /(n) olive oil/
オリーヴ /(n,adj-no) olive (fre:)/
オリーヴ色 [オリーヴいろ] /(n) olive (colour, color)/olive brown/
オリエンタリスト /(n) orientalist/
オリエンタリズム /(n) orientalism/(P)/
オリエンタル /(adj-na) oriental/(P)/
オリエンタル・ショートヘア /(n) oriental shorthair/
オリエンタル・バタフライ・フィッシュ /(n) Oriental butterflyfish (Chaetodon auripes, species found mostly from Japan to Taiwan)/
オリエンタル・ロングヘア /(n) oriental longhair/
オリエンタルショートヘア /(n) oriental shorthair/
オリエンタルバタフライフィッシュ /(n) Oriental butterflyfish (Chaetodon auripes, species found mostly from Japan to Taiwan)/
オリエンタルロングヘア /(n) oriental longhair/
オリエンテーション /(n) orientation/(P)/
オリエンテーション教育 [オリエンテーションきょういく] /(n) orientation/
オリエンテーリング /(n) orienteering/(P)/
オリエンテッド /(adj-na) oriented/
オリエント /(n) Orient/(P)/
オリエント急行 [オリエントきゅうこう] /(n) Orient express/
オリエント美術 [オリエントびじゅつ] /(n) Oriental art/
オリオン /(n) Orion/(P)/
オリオンズ /(n) (comp) ORIONS/
オリオン座 [オリオンざ] /(n) Orion/
オリオン星雲 [オリオンせいうん] /(n) Orion Nebula/
オリガーキー /(n) oligarchy/
オリキャラ /(n) (abbr) original character (i.e. not a character from some other existing work)/
オリコン /(n) (abbr) original content/
オリゴヌクレオチド /(n) oligonucleotide/
オリゴポリー /(n) (obsc) oligopoly/
オリゴマー /(n) oligomer/(P)/
オリゴ糖 [オリゴとう] /(n) oligosaccharide (sugar polymer containing several but not many component simple sugars)/
オリザニン /(n) Oryzanin (brand-name vitamin B1; extracted from rice)/
オリジナリティ /(n) originality/
オリジナリティー /(n) originality/(P)/
オリジナル /(adj-no,n) original/(P)/
オリジナル・コンテンツ /(n) original content/
オリジナルカロリー /(n) original calorie/
オリジナルコンテンツ /(n) original content/
オリジナルシナリオ /(n) original scenario/
オリジナルビデオ /(n) film released direct-to-video (wasei: original video)/
オリジナルビデオアニメーション /(n) animated film released direct-to-video (wasei: original video animation)/
オリジナルプリント /(n) original print/
オリジナルプログラム /(n) original program/
オリジナル性 [オリジナルしょう] /(n) originality/
オリジネートモード /(n) (comp) originate mode/
オリジン /(n) origin/
オリストストローム /(n) olistostrome/
オリックス /(n) oryx (esp. the gemsbok, Oryx gazella)/
オリハルコン /(n) orichalcum/
オリフィス /(n) orifice/
オリフラ /(n) (abbr) orientation flat (semiconductors)/
オリブ /(n,adj-no) olive (fre:)/
オリンピア /(n) Olympia/(P)/
オリンピアード /(n) Olympiad/
オリンピア祭 [オリンピアさい] /(n) Festival of Zeus (held at Olympia every four years from 776 BCE to 393 BCE)/
オリンピック /(n) Olympics/(P)/
オリンピック・イヤー /(n) Olympic year/
オリンピック・コングレス /(n) Olympic Congress/
オリンピックイヤー /(n) Olympic year/
オリンピックコングレス /(n) Olympic Congress/
オリンピックデー /(n) Olympic Day (June 23rd)/
オリンピックパーク /(n) Olympic Park/
オリンピック旗 [オリンピックき] /(n) Olympic flag/
オリンピック記録 [オリンピックきろく] /(n) Olympic record/
オリンピック競技 [オリンピックきょうぎ] /(n) Olympic event/Olympic Games/
オリンピック景気 [オリンピックけいき] /(n) economic boom created by the Tokyo Olympic Games (1962-1964)/
オリンピック憲章 [オリンピックけんしょう] /(n) Olympic Charter/
オリンピック種目 [オリンピックしゅもく] /(n) Olympic event/
オリンピック聖火 [オリンピックせいか] /(n) Olympic Flame/Olympic Torch/
オリンピック選手 [オリンピックせんしゅ] /(n) Olympic athlete/
オリンピック村 [オリンピックむら] /(n) Olympic Village/
オリンピック大会 [オリンピックたいかい] /(n) Olympic Games/Olympics/
オリンピック冬季競技大会 [オリンピックとうききょうぎたいかい] /(n) Olympic Winter Games/
オリンポス /(n) Olympus/
オルガスム /(n) orgasm (ger: Orgasmus)/(P)/
オルガスムス /(n) orgasm (ger: Orgasmus)/
オルガナイザー /(n) organizer/organiser/
オルガナイズ /(n,vs) organize/organise/
オルガニスト /(n) organist/
オルガニズム /(n) organism/
オルガネラ /(n) organelle (lat: organella)/
オルガン /(n) organ (musical instrument) (por: orgao)/(P)/
オルグ /(n,vs) (1) (abbr) organizer/organiser/(2) organizing/organising/organization/organisation/(P)/
オルゴール /(n) music box (dut: orgel)/(P)/
オルゴン /(n) orgone energy/
オルシコン /(n) orthicon (early form of television camera tube)/
オルソクロマチック /(adj-no) orthochromatic/
オルソスコープ /(n) orthoscope (instrument for examining the iris)/
オルソパンクロマチック /(adj-no) orthopanchromatic/
オルゾー /(n) orzo (ita:)/
オルターナティブ /(n) alternative/
オルターナティヴ /(n) alternative/
オルタナティブ /(n) alternative/
オルタナティヴ /(n) alternative/
オルタネーター /(n) alternator/
オルタネイト /(n) alternate/
オルタネタ /(n) alternator/
オルト /(adj-no) ortho/
オルトキー /(n) (comp) Alt Key/
オルトフェニルフェノール /(n) orthophenyl phenol/OPP/
オルトリン酸塩 [オルトリンさんえん] /(n) orthophosphate/
オルトルイズム /(n) altruism/
オルト燐酸塩 [オルトりんさんえん] /(n) orthophosphate/
オルド /(n) (1) horde/
オルドビス紀 [オルドビスき] /(n) Ordovician period/
オルニチン /(n) ornithine/
オルニチン回路 [オルニチンかいろ] /(n) ornithine cycle/
オルム /(n) olm (Proteus anguinus)/
オルリオオトカゲ /(n) blue-tailed monitor (Varanus doreanus, species of carnivorous monitor lizard found in Australia, New Guinea, and the Bismarck Archipelago)/Kalabeck's monitor/
オレアンドマイシン /(n) oleandomycin/
オレイン酸 [オレインさん] /(n) oleic acid/
オレオレジン /(n) oleoresin/
オレオレ詐欺 [オレオレさぎ] /(n) type of fraud involving phone calls pretending distress/
オレカ /(n) (abbr) orange card/
オレゴン /(n) Oregon/
オレゴンパイン /(n) Oregon pine (another term for the common Douglas fir, Pseudotsuga menziesii)/
オレフィン /(n) olefin/olefine/alkene/
オレンジ /(n) orange/(P)/
オレンジエード /(n) orangeade/
オレンジカード /(n) orange card (pre-paid ticket)/
オレンジジュース /(n) orange juice/
オレンジスポッティド・スパインフット /(n) goldlined spinefoot (Siganus guttatus, species of Eastern Indian Ocean and Western Pacific rabbitfish)/orange-spotted spinefoot/
オレンジスポッティドスパインフット /(n) goldlined spinefoot (Siganus guttatus, species of Eastern Indian Ocean and Western Pacific rabbitfish)/orange-spotted spinefoot/
オレンジソケットサージャンフィッシュ /(n) orange-socket surgeonfish (Acanthurus auranticavus, species of the Indo-West Pacific)/
オレンジソケットサージョンフィッシュ /(n) orange-socket surgeonfish (Acanthurus auranticavus, species of the Indo-West Pacific)/
オレンジビターズ /(n) orange bitters/
オレンジピール /(n) orange peel/
オレンジフェイスバタフライフィッシュ /(n) hooded butterflyfish (Chaetodon larvatus)/
オレンジペコー /(n) orange pekoe/
オレンジ革命 [オレンジかくめい] /(n) Orange Revolution (Ukraine, 2004-2005)/
オレンジ色 [オレンジいろ] /(n) orange (colour, color)/(P)/
オロイド /(n) oroide (gold-coloured copper-zinc alloy)/
オロチン酸 [オロチンさん] /(n) orotic acid/
オロブロンコ /(n) sweet grapefruit-like citrus fruit/super-grapefruit/
オン /(n,vs) on/(P)/
オンエア /(n,vs) on air/on the air/(P)/
オンエアランプ /(n) on the air lamp/
オンオフ /(n) on-off/
オングストローム /(n) angstrom/
オンコジーン /(n) oncogene/
オンサイト /(n) on-site/
オンサイトサービス /(n) (comp) on-site service/onsite service/
オンサイトサポート /(n) (comp) on-site support/
オンサイド /(n) on-side/
オンザジョブトレーニング /(n) on-the-job training/
オンザフライ印字装置 [オンザフライいんじそうち] /(n) (comp) on-the-fly printer/
オンザフライ書き込み [オンザフライかきこみ] /(n) (comp) on-the- fly recording/
オンザマーク /(n) on the mark/
オンザロック /(n) on the rocks/
オンジエア /(n) on the air/
オンス /(n) ounce/28.35g/(P)/
オンスクリーンディスプレイ /(n) (comp) on-screen display/
オンスクリーン機能 [オンスクリーンきのう] /(n) (comp) on-screen function/
オンステージ /(n) on stage/
オンタリオ /(n) Ontario/
オンチップキャッシュ /(n) (comp) on-chip cache/
オンデマンド /(n) (comp) on demand/
オンデマンドダイヤルアップ接続 [オンデマンドダイヤルアップせつぞく] /(n) (comp) on demand dial-up/
オントレード /(exp) on-trade/
オントロギー /(n) (obsc) ontology (ger: Ontologie)/
オントロジー /(n,adj-no) ontology/
オンドマルトノ /(n) ondes Martenot (electronic musical instrument) (fre:)/
オンドル /(n) (uk) Korean floor heater (kor:)/
オンパレード /(n) display (lit: on parade)/array of/succession of/(P)/
オンフック /(n) (comp) on hook/
オンブズパースン /(n) ombudsperson/
オンブズマン /(n) ombudsman (swe:)/(P)/
オンボード /(n) (comp) on-board/
オンボードコンピュータ /(n) (comp) on-board computer/
オンボードデバイス /(n) (comp) onboard device/
オンマイク /(n) on-mike/
オンメモリ /(n) (comp) on memory/
オンユアマーク /(n) on your mark/
オンライン /(n) (comp) on-line/(P)/
オンラインでの求職活動 [オンラインでのきゅうしょくかつどう] /(n) (comp) on-line job-hunting/
オンラインの友人 [オンラインのゆうじん] /(n) (comp) online buddy/
オンラインイベント /(n) (comp) online event/
オンラインオークション /(n) online auction/
オンラインゲーム /(n) (comp) online game/
オンラインコンピュータ /(n) (comp) online computer/
オンラインコンピューター /(n) (comp) online computer/
オンラインコンピュータシステム /(n) (comp) online computer system/
オンラインサービス /(n) (comp) online service/
オンラインサインアップ /(n) (comp) on-line sign up/online sign-up/
オンラインサポートセンター /(n) (comp) online support center/
オンラインシステム /(n) (comp) on-line system/
オンラインショッピング /(n) online shopping/
オンラインショッピングカート /(n) (comp) online shopping carts/
オンラインショッピングサイト /(n) online shopping site/
オンラインショップ /(n) (comp) online shop/
オンラインストア /(n) online store/
オンラインストレージ /(n) (comp) online storage/
オンラインソフト /(n) (comp) online software/
オンラインソフトウェア /(n) (comp) online software/
オンラインダンプ /(n) (comp) online dump/
オンラインテスト /(n) (comp) online test/online testing/
オンラインテストシステム /(n) (comp) online test system/
オンラインテストセクション /(n) (comp) online test section/
オンラインテストプログラム /(n) (comp) online test program/
オンラインテスト制御プログラム [オンラインテストせいぎょプログラム] /(n) (comp) online test control program/
オンラインテラーズマシン /(n) (comp) online teller-machine/
オンラインデータベース /(n) (comp) on-line database/online database/
オンラインデータベースシステム /(n) (comp) online database system/
オンラインデータ収集システム [オンラインデータしゅうしゅうシステム] /(n) (comp) online data gathering system/
オンラインデータ処理 [オンラインデータしょり] /(n) (comp) on-line data processing/
オンラインデータ入力 [オンラインデータにゅうりょく] /(n) (comp) online data entry/
オンラインディクショナリー /(n) on-line dictionary/
オンラインディレイド処理システム [オンラインディレイドしょりシステム] /(n) (comp) online delayed time system/
オンラインディレクトリー /(n) (comp) online directory/
オンラインデバッギング /(n) (comp) online debugging/
オンラインデバッグ /(n) (comp) online debug/
オンライントランザクション処理 [オンライントランザクションしょり] /(n) (comp) online transaction processing/
オンライントレーディング /(n) (comp) on-line trading/
オンラインネットワークシステム /(n) (comp) on-line network system/
オンラインバックアップ /(n) (comp) online backup/
オンラインバッチ処理システム [オンラインバッチしょりシステム] /(n) (comp) online batch processing system/
オンラインバンキング /(n) (comp) online banking/
オンラインバンキングシステム /(n) (comp) online banking system/
オンラインパターン解析認識システム [オンラインパターンかいせきにんしきシステム] /(n) (comp) online pattern analysis and recognition system/
オンラインパッケージ /(n) (comp) online package/
オンラインプログラミングシステム /(n) (comp) online programming system/
オンラインプロジェクト管理 [オンラインプロジェクトかんり] /(n) (comp) online project management/
オンラインヘルプ /(n) (comp) online help/
オンラインボリューム管理 [オンラインボリュームかんり] /(n) (comp) on-line volume management/
オンラインマガジン /(n) (comp) online magazine/
オンラインマニュアル /(n) (comp) online-manual/online documentation/on-screen electronic book/
オンラインメディアのパイオニア /(n) (comp) online media pioneer/
オンラインモード /(n) (comp) online mode/
オンラインモニタ /(n) (comp) online monitor/
オンラインリアルタイム /(n) (comp) online real time/
オンラインリアルタイムシステム /(n) (comp) on-line real time system/
オンラインリアルタイム監視 [オンラインリアルタイムかんし] /(n) (comp) online real-time surveillance/
オンラインリアルタイム処理 [オンラインリアルタイムしょり] /(n) (comp) online real-time processing/
オンラインリアルタイム処理システム [オンラインリアルタイムしょりシステム] /(n) (comp) online real-time system/
オンライン科学コンピュータ [オンラインかがくコンピュータ] /(n) (comp) online scientific computer/
オンライン機械 [オンラインきかい] /(n) (comp) online machines/
オンライン機器 [オンラインきき] /(n) (comp) online equipment/
オンライン記憶 [オンラインきおく] /(n) (comp) online storage/
オンライン銀行業務設備 [オンラインぎんこうぎょうむせつび] /(n) (comp) online banking facilities/
オンライン計算処理 [オンラインけいさんしょり] /(n) (comp) online computing/
オンライン計測器パッケージ [オンラインけいそくきパッケージ] /(n) (comp) online instrumentation package/
オンライン検査機能 [オンラインけんさきのう] /(n) (comp) online test facility/
オンライン処理 [オンラインしょり] /(n) (comp) online processing/online operation/
オンライン処理環境 [オンラインしょりかんきょう] /(n) (comp) online processing environment/
オンライン情報処理 [オンラインじょうほうしょり] /(n) (comp) online information processing/
オンライン状態 [オンラインじょうたい] /(n) (comp) online state/
オンライン申し込み [オンラインもうしこみ] /(n) (comp) online sign-up/
オンライン診断 [オンラインしんだん] /(n) (comp) online diagnostics/
オンライン制御 [オンラインせいぎょ] /(n) (comp) online control/
オンライン端末テスト [オンラインたんまつテスト] /(n) (comp) online terminal test/
オンライン通信 [オンラインつうしん] /(n) (comp) online communication/
オンライン動作状態 [オンラインどうさじょうたい] /(n) (comp) online working/
オンライン配布 [オンラインはいふ] /(n) (comp) online distribution/
オンライン版 [オンラインはん] /(n) (comp) on-line version/on-line edition/
オンライン分析 [オンラインぶんせき] /(n) (comp) online analysis/
オンライン分析処理 [オンラインぶんせきしょり] /(n) (comp) On-Line Analytical Processing/OLAP/
オンライン問題解決 [オンラインもんだいかいけつ] /(n) (comp) online problem solving/
オンライン利用者 [オンラインりようしゃ] /(n) (comp) online consumers/
オンランプ /(n) on-ramp/
オンリ /(n) only/
オンリー /(n) only/(P)/
オンリーワン /(n) unique (wasei: only one)/
オンリイ /(n) only/
オンリミット /(n) on-limits/
オンワード /(n) onward/
オヴェイション /(n) ovation/
カ /(ctr) counter for the ichi-ni-san counting system (usu. directly preceding the item being counted)/a noun read using its on-yomi/
カー /(n) car/(P)/
カーきち /(n) petrolhead/car nut/
カーエレ /(n) (abbr) automotive electronics/
カーエレクトロニクス /(n) automotive electronics (wasei: car electronics)/
カーカー /(n) caw (sound made by crows)/croak/
カーカス /(n) (1) carcass (inner body of a car tyre) (tire)/(2) carcase/
カーキ /(n) khaki/
カーキチ /(n) petrolhead/car nut/
カーキ色 [カーキいろ] /(n) khaki/
カークーラー /(n) car air-conditioner (wasei: car cooler)/
カーゴ /(n) cargo/
カーゴ・スリング /(n) cargo sling/
カーゴカルト /(n) cargo cult (Melanesian belief system)/
カーゴスリング /(n) cargo sling/
カーゴテナー /(n) (roll) box pallet (from cargo container)/
カーサ /(n) house (spa: casa)/
カーシェール /(n) kasher/kosher/
カージナル /(n) cardinal (Catholic prelate, number characteristic, etc.)/
カージナル・テトラ /(n) cardinal tetra (Paracheirodon axelrodi)/
カージナルス /(n) Cardinals (US baseball team)/
カージナルテトラ /(n) cardinal tetra (Paracheirodon axelrodi)/
カース /(n) curse/
カーステレオ /(n) car stereo/
カースト /(n) caste/(P)/
カースリーパー /(n) sleeping car (car sleeper) (train)/
カーセックス /(n) car sex/
カーソル /(n) (comp) cursor/(P)/
カーソルキー /(n) (comp) cursor keys/
カーソルコントロールキー /(n) (comp) cursor control key/
カーソル移動キー [カーソルいどうキー] /(n) (comp) cursor control key/
カーソル強調 [カーソルきょうちょう] /(n) cursored emphasis/
カーダンパー /(n) car dumper/
カーチェイス /(n) car chase/(P)/
カーテシ /(n) courtesy/
カーテン /(n) curtain/curtains/(P)/
カーテンアンテナ /(n) curtain antenna/
カーテンウォール /(n) curtain wall/
カーテンウオール /(n) curtain wall/
カーテンコール /(n) curtain call/
カーテンリング /(n) curtain ring/
カーテンレール /(n) curtain rail/
カーテンレクチャー /(n) curtain lecture/
カーディガン /(n) cardigan/(P)/
カーディナル /(n) cardinal/
カート /(n) cart/(P)/
カートゥーン /(n) cartoon/
カートリッジ /(n) cartridge/(P)/
カートリッジテープドライブ /(n) (comp) cartridge tape drive/
カートリッジテープドライブモジュール /(n) (comp) cartridge tape drive module/
カートリッジフォント /(n) (comp) cartridge font/
カートレーン /(n) passenger and freight train (wasei: car train)/
カートレイン /(n) car train/
カートン /(n) (1) carton (e.g. of cigarettes)/(2) tray (in which money is placed when paying)/dish/
カード /(n) (1) card/(2) curd/(P)/
カードエッジコネクタ /(n) (comp) edge connector/
カードケージ /(n) (comp) card cage/
カードケージの突出部 [カードケージのとっしゅつぶ] /(n) (comp) card cage extrusion/
カードゲーム /(n) card game/(P)/
カードサービス /(n) (comp) card services/
カードシステム /(n) card system/
カードスタッカ /(n) (comp) card stacker/
カードスロット /(n) (comp) card slot/
カードデック /(n) (comp) card deck/
カードバス /(n) (comp) CardBus/
カードホッパ /(n) (comp) card hopper/
カードリーダー /(n) (comp) card reader/
カードル /(n,vs) (1) curdle/(n) (2) bundle (fre: cadre)/rack for storage or transport/stillage/
カードローン /(n) card loan/
カード会員 [カードかいいん] /(n) (credit) card holder/cardmember/
カード型データベース [カードがたデータベース] /(n) (comp) card-type database/
カード穿孔機構 [カードせんこうきこう] /(n) (comp) card punch/
カード穿孔装置 [カードせんこうそうち] /(n) (comp) card punch/
カード送り機構 [カードおくりきこう] /(n) (comp) card feed/
カード通路 [カードつうろ] /(n) (comp) card path/
カード読み取り装置 [カードよみとりそうち] /(n) (comp) card reader/
カード読取り機構 [カードよみとりきこう] /(n) (comp) card reader/
カード読取り装置 [カードよみとりそうち] /(n) (comp) card reader/
カード破産 [カードはさん] /(n) personal bankruptcy caused by excessive card-loan borrowing/
カード分類機 [カードぶんるいき] /(n) (comp) card sorter/
カーナビ /(n) (abbr) car navigation system/
カーナビゲーション /(n) (comp) car navigation/
カーナビゲーションシステム /(n) car navigation system/
カーナライト /(n) carnallite/
カーニバル /(n) carnival/(P)/
カーニング /(n) (comp) kerning/
カーヌーン /(n) qanun (Near-Eastern string instrument) (ara:)/
カーネーション /(n) carnation/(P)/
カーネージョン /(n) carnation/
カーネル /(n) (comp) kernel/
カーバ /(n) Kaaba/
カーバイド /(n) (1) carbide/(2) (calcium) carbide/
カーヒーター /(n) car heater/
カービン /(n) carbine/
カービング /(n) carving/
カービングナイフ /(n) carving knife/
カービン銃 [カービンじゅう] /(n) carbine/
カーフ /(n) calf/
カーフェリー /(n) car ferry/(P)/
カーフスキン /(n) calfskin/
カーブ /(n,vs) (1) curve/(2) curve ball (baseball)/(P)/
カーブフォロア /(n) (comp) curve follower/
カーブマーケット /(n) curb market/
カーブミラー /(n) (abbr) convex mirror/
カーブ尺 [カーブじゃく] /(n) curved ruler/
カープール /(n) car pool/
カーペット /(n) carpet/(P)/
カーペンター /(n) carpenter/
カーペンタリア湾 [カーペンタリアわん] /(n) Gulf of Carpentaria/
カーボーイ /(n) cowboy/
カーボナタイト /(n) carbonatite/
カーボランダム /(n) carborundum (hard silicon carbide solid, used as an abrasive)/
カーボロイ /(n) carboloy (alloy containing carbon, cobalt, and tungsten)/
カーボン /(n) carbon/(P)/
カーボングラファイト /(n) carbon graphite/
カーボンコピー /(n) carbon copy/
カーボンデーティング /(n) carbon dating/
カーボンナノチューブ /(n) carbon nano-tube/carbon nanotube/
カーボンニュートラル /(n,adj-na,adj-no) carbon-neutral/
カーボンファイバー /(n) carbon fiber/carbon fibre/
カーボンブラック /(n) carbon black/
カーボンヘッド /(n) carbon head/
カーボンマイクロホン /(n) carbon microphone/
カーボンリボン /(n) (comp) carbon ribbon/
カーボンレスペーパー /(n) carbonless paper/
カーボンロッド /(n) carbon rod/
カーボン紙 [カーボンかみ] /(n) carbon paper/
カーボン紙 [カーボンし] /(n) carbon paper/
カーポート /(n) carport/
カーマ /(n) Karma/
カーマイン /(n) carmine/
カーマインレッド /(n) carmine red/
カーマスートラ /(n) Kamasutra/
カーマニア /(n) car enthusiast (wasei: car mania)/car buff/
カーミット /(n) (comp) Kermit/
カーミン /(n) carmine (dut: karmijn)/
カーラー /(n) curler/
カーライフ /(n) car life/
カーラジオ /(n) car radio/
カーラッシュ /(n) Curlash/
カーリース /(n) car lease/
カーリーヘア /(n) curly hair/
カーリング /(n) curling/(P)/
カール /(n,vs) (1) curl/(n) (2) cwm (ger: Kar)/cirque/corrie/(P)/
カーレーサー /(n) racing driver (wasei: car racer)/
カーレース /(n) car race/(P)/
カーワックス /(n) car wax/
カーン /(n) (1) kern/(2) Kahn/(P)/
カーンカーン /(adv-to,n) clanging/dong dong/
カーヴ /(n) curve/
カイアシ類 [カイアシるい] /(n) copepods (small crustaceans of subclass Copepoda)/
カイエンペッパー /(n) cayenne pepper/
カイガラムシ /(n) (uk) scale insect/
カイギュウ /(n) (uk) serenian (any aquatic mammal of order Sirenia, inc. manatees, and dugongs)/sea cow/
カイコ /(n) (uk) silkworm (Bombyx Mori)/
カイザー /(n) Kaiser (ger:)/
カイゼル /(n) Kaiser (ger:)/
カイゼル髭 [カイゼルひげ] /(n) handlebar mustache (lit: Kaiser)/
カイダコ /(n) (uk) greater argonaut (species of paper nautilus, Argonauta argo)/
カイツブリ /(n) (1) (uk) little grebe (Tachybaptus ruficollis)/(2) grebe (any waterbird of family Podicipedidae)/
カイト /(n) kite/(P)/
カイドウ /(n) (1) flowering crab apple (Malus halliana)/(2) Kaido crab apple (Malus micromalus)/(3) Chinese flowering apple (Malus spectabilis)/(4) Siberian crab apple (Malus baccata)/(5) aronia (flower)/
カイネシクス /(n) kinesics/
カイネチン /(n) kinetin/
カイパーベルト /(n) Kuiper belt/
カイブツギンザメ /(n) rabbit fish (Chimaera monstrosa)/
カイマン /(n) caiman/cayman (crocodilian similar to an alligator)/
カイモグラフ /(n) kymograph/
カイヤン /(n) sutchi catfish (Pangasianodon hypophthalmus)/iridescent shark catfish/
カイリックス /(n) (comp) Kylix/
カイロ /(n) Cairo/
カイロテック /(n) (abbr) chiropractic/
カイロプラクター /(n) chiropractor/
カイロプラクチック /(n) chiropractic/
カイロプラクティック /(n) chiropractic/
カイロプラター /(n) chiropractor/
カインコンプレックス /(n) Cain complex (jealousy of a sibling, ultimately leading to hatred)/
カイ二乗検定 [カイにじょうけんてい] /(n) (comp) Chi square test/
カウ /(n) (comp) (abbr) automatically responding with an upload slot to someone who allows you to download (e.g. in P2P systems)/
カウチ /(n) couch/
カウチポテト /(n) couch potato/television addict/(P)/
カウハイド /(n) cowhide/
カウパー腺 [カウパーせん] /(n) Cowper's gland/bulbourethral gland/
カウベル /(n) cowbell/
カウボーイ /(n) cowboy/(P)/
カウボーイハット /(n) cowboy hat/
カウボーイブーツ /(n) cowboy boots/
カウリング /(n) cowling/
カウル /(n) cowl/
カウルネックライン /(n) cowl neckline/
カウンシル /(n) council/
カウンセラー /(n) counselor/counsellor/(P)/
カウンセリング /(n) counseling/(P)/
カウンタ /(n) (1) counter/(2) service counter (e.g. at a bank)/(3) counter (at a bar, cafe, etc.)/(4) (comp) automatically responding with an upload slot to someone who allows you to download (e.g. in P2P systems)/
カウンター /(n) (1) counter/(2) service counter (e.g. at a bank)/(3) counter (at a bar, cafe, etc.)/(4) (comp) automatically responding with an upload slot to someone who allows you to download (e.g. in P2P systems)/(P)/
カウンターアタック /(n) counter attack/
カウンターインテリジェンス /(n) counterintelligence/
カウンターカルチャー /(n) counterculture/
カウンターキッチン /(n) kitchen with a small counter for eating, usu. allowing a view into the living and dining rooms (wasei: counter kitchen)/
カウンターストップ /(n) maximum value in games (e.g. 99, 255, etc.) (wasei: counter stop)/
カウンターテナー /(n) countertenor/
カウンターディスプレー /(n) counter display/
カウンターパーチェス /(n) counterpurchase/
カウンターパート /(n) counterpart/
カウンターパンチ /(n) counterpunch/
カウンターブロー /(n) counterblow/
カウンターブロウ /(n) counterblow/
カウンタープロパゲーション /(n) counter-propagation/
カウンティ /(n) county/
カウント /(n,vs) count/(P)/
カウントアウト /(n) count-out/
カウントダウン /(n) countdown/
カエサル /(n,adj-no) Caesar/
カエサルの物はカエサルに [カエサルのものはカエサルに] /(exp) (uk) render unto Caesar the things which are Caesar's/
カエデチョウ /(n) (1) (uk) black-rumped waxbill (Estrilda troglodytes)/(2) estrildid (any bird of family Estrildidae)/waxbill/
カエデ科 [カエデか] /(n) Aceraceae (plant family)/maple/
カエトドンアンダマネンシス /(n) yellow butterflyfish (Chaetodon andamanensis)/
カエル /(n) (1) (uk) frog/
カエルアンコウ /(n) (uk) frogfish (any fish of family Antennariidae, esp. the striated frogfish, Antennarius striatus)/
カエルツボカビ症 [カエルツボカビしょう] /(n) chytridiomycosis (fatal infectious disease of amphibians)/
カオス /(n) chaos/(P)/
カオス理論 [カオスりろん] /(n) chaos theory/
カオダイ教 [カオダイきょう] /(n) Caodaism/
カオリナイト /(n) kaolinite/
カオリャン /(n) variety of sorghum, esp. used in making spirits (chi: kaoliang)/
カオリン /(n) kaolin/
カカオ /(n) cacao/cocoa/
カカオバター /(n) cacao butter/cocoa butter/
カカオマス /(n) cacao mass/
カガミチョウチョウウオ /(n) Asian butterflyfish (Chaetodon argentatus)/
カキ /(n) kaki/Japanese persimmon (Diospyros kaki)/
カキコ /(n) (abbr) (sl) post (to a BBS)/comment (on a blog)/(P)/
カキツバタ /(n) (uk) rabbitear iris (Iris laevigata)/
カキナ /(n) (uk) kakina (green leafy vegetable of the genus Brassica)/
カキノキ /(n) (Japanese) persimmon tree (Diospyros kaki)/
カキノキ科 [カキノキか] /(n) Ebenaceae (plant family)/ebony/
カキノキ目 [カキノキもく] /(n) Ebenales (order of plants)/
カキパン /(n) heavy petting/
カキピー /(n) kaki mochi and peanuts (a common snack)/
カキ油 [カキあぶら] /(n) oyster sauce/
カギムシ /(n) (uk) velvet worm (Onychophora)/
カギ爪 [カギづめ] /(n) claw/talon/
カクタス /(n) cactus/
カクタスペア /(n) fruit of a cactus in genus Opuntia (inc. prickly pears and cholla)/cactus pear/
カクチョウジョウチュウ /(n) sheep tapeworm (Moniezia expansa)/
カクテイル /(n,adj-no) cocktail/
カクテキ /(n) cubed daikon kimchi (kor: kkakdugi)/
カクテル /(n,adj-no) cocktail/(P)/
カクテルグラス /(n) cocktail glass/
カクテルソース /(n) cocktail sauce/
カクテルドレス /(n) cocktail dress/
カクテルパーティー /(n) cocktail party/
カクテルラウンジ /(n) cocktail lounge/
カクテル療法 [カクテルりょうほう] /(n) cocktail treatment/
カクレウオ /(n) (uk) Encheliophis sagamianus (species of pearlfish)/
カクレガニ /(n) (uk) pea crab (any crab of the family Pinnotheridae)/
カグラザメ /(n) (uk) bluntnose sixgill shark (Hexanchus griseus, species of circumglobal cow shark)/
カグラザメ科 [カグラザメか] /(n) Hexanchidae (family with 4 species and 3 genera of cow sharks characterized by either 1 or 2 additional pairs of gill slits)/
カグラザメ属 [カグラザメぞく] /(n) Hexanchus (genus of sixgill sharks in the family Hexanchidae comprised of 2 extant species)/
カケス /(n) (uk) Eurasian jay (Garrulus glandarius)/
カゴノキ /(n) (uk) Litsea coreana (species of tree in the laurel family)/
カサカサ /(adj-na,vs,adv,adv-to) (1) (on-mim) dry/bone dry/(2) rustle/(P)/
カサガイ /(n) (uk) limpet (esp. species Cellana mazatlandica)/
カササギ /(n) (uk) European magpie (Pica pica)/
カサレヴサ /(n) katharevousa (traditional literary form of modern Greek) (gre:)/
カザリキンチャクフグ /(n) Bennett's sharpnose puffer (Canthigaster bennetti)/
カシア /(n) cassia (Cinnamomum aromaticum)/
カシオ /(n) Casio/(P)/
カシオペア /(n) Cassiopeia/
カシケイタイ /(n) rental mobile phone/rental cell phone/cell phone that is rented/
カシコ /(n) oak flour (esp. as animal food)/acorn flour/
カシゴ /(n) oak flour (esp. as animal food)/acorn flour/
カシス /(n) black currant (fre:)/Cassis (French black currant) liqueur/
カシミール /(n) Kashmir/
カシミールカレー /(n) Kashmir curry/
カシミール語 [カシミールご] /(n) Kashmiri (language)/
カシミール人 [カシミールじん] /(n) Kashmiri (people)/
カシミア /(n) cashmere (fiber, yarn, fleece, clothing, etc. from the cashmere goat)/
カシミア山羊 [カシミアやぎ] /(n) Cashmere goat/
カシミア糸 [カシミアいと] /(n) cashmere yarn/
カシミヤ /(n) cashmere (fiber, yarn, fleece, clothing, etc. from the cashmere goat)/
カシメ /(n) standoff (mechanical fastener)/self-clinch hardware/
カシュー /(n) cashew (Anacardium occidentale)/acajou/
カシューの木 [カシューのき] /(n) (obsc) cashew tree (Anacardium occidentale)/acajou/
カシューアップル /(n) cashew apple/
カシューナッツ /(n) cashew nuts/
カシュクール /(n) crossover cardigan or sweater (fre: cache-coeur)/
カシュルート /(n) kashrut (Jewish dietary laws)/
カジ /(n) (uk) paper mulberry (Broussonetia papyrifera)/
カジイチゴ /(n) (uk) Rubus trifidus (species of raspberry)/
カジカ /(n) (1) (uk) sculpin (any fish of family Cottidae, inc. the bullheads and the miller's-thumb)/(2) Japanese fluvial sculpin (Cottus pollux)/
カジカガエル /(n) (uk) kajika frog (Buergeria buergeri)/
カジノ /(n) casino (fre:)/(P)/
カジノキ /(n) (uk) paper mulberry (Broussonetia papyrifera)/
カジメ /(n) (uk) Ecklonia cava (species of brown alga)/
カジュアル /(adj-na,n) casual/(P)/
カジュアルウエア /(n) casual wear/
カジュアルウォーター /(n) casual water/
カジュアルルック /(n) casual look/
カジュマル /(n) (uk) Chinese banyan (Ficus microcarpa or Ficus retusa)/Malayan banyan/Indian laurel/
カスカス /(n) (1) cuscus (variety of phalanger)/
カスカラサグラダ /(n) cascara sagrada/
カスガマイシン /(n) kasugamycin/
カスケーディングスタイルシート /(n) (comp) cascade style sheets/CSS/
カスケード /(adj-na,n) cascade/
カスケードシャワー /(n) cascade shower/
カスケードメニュー /(n) (comp) cascading menu/
カスケード式けた上げ [カスケードしきけたあげ] /(n) (comp) cascaded carry/
カスケード表示 [カスケードひょうじ] /(n) (comp) cascade/
カスケット /(n) casket/
カスザメ /(n) (uk) Japanese angel shark (Squatina japonica)/
カスター /(n) caster/
カスタード /(n) custard/
カスタードクリーム /(n) custard cream/
カスタードプディング /(n) custard pudding/
カスタードプリン /(n) custard pudding/
カスタネット /(n) castanets/
カスタマ /(n) (comp) customer/
カスタマー /(n) customer/(P)/
カスタマーインストレーションインストラクション /(n) (comp) customer installation instruction/
カスタマーエンジニア /(n) (comp) customer engineer/
カスタマーサービス /(n) customer service/
カスタマーサポート /(n) (comp) customer support/
カスタマーマニュアル /(n) (comp) customer manual/
カスタマイザ /(n) customizer/customiser/
カスタマイズ /(n,vs) customize/customise/
カスタマエンジニア /(n) (comp) customer engineer/CE/
カスタマサービス /(n) (comp) customer service/
カスタム /(n,adj-no) custom/
カスタムＩＣ [カスタムアイシー] /(n) (comp) custom IC/
カスタムＬＳＩ [カスタムエルエスアイ] /(n) (comp) custom LSI/
カスタムアイシー /(n) custom IC/
カスタムアダプタ /(n) (comp) custom adapter/
カスタムカー /(n) customized car/customised car/
カスタムコミュニケーション /(n) customized communication/customised communication/
カスタムコントロール /(n) (comp) custom control/
カスタムサブネットマスク /(n) (comp) custom subnet mask/
カスタムズ /(n) customs/
カスタムソフトウェア /(n) (comp) custom software/
カスタムダイアログボックス /(n) (comp) custom dialog box/
カスタムチップ /(n) (comp) custom IC/custom chip/ASIC/
カスタムパネルウィンドウ /(n) (comp) custom panel pane/
カスタムパレット /(n) (comp) custom palette/
カスタムプラグイン /(n) (comp) custom plug-in/
カスタムプロパティ /(n) (comp) custom property/
カスタムプロパティダイアログボックス /(n) (comp) custom properties dialog box/
カスタムプロファイル /(n) (comp) custom profile/
カスタムメード /(n) custom-made/
カスタムメイド /(n) custom-made/
カスタム化 [カスタムか] /(n,vs) customization/customisation/
カステーラ /(n) sponge cake (por: pao de Castella)/
カステラ /(n) sponge cake (por: pao de Castella)/(P)/
カステン /(n) cabinet, usu. containing medical instruments, medicines, etc. (ger: Kasten)/case/
カスト /(n) caste/
カストラート /(n) castrato (ita:)/
カスバ /(n) kasbah/(P)/
カスピヤツメ属 [カスピヤツメぞく] /(n) Caspiomyzon (genus of lamprey in the family Petromyzontidae)/
カスピ海 [カスピかい] /(n) Caspian Sea/(P)/
カスミアジ /(n) bluefin trevally (Caranx melampygus)/
カスミザクラ /(n) (uk) Korean hill cherry (Prunus verecunda)/
カスミチョウチョウウオ /(n) pyramid butterflyfish (Hemitaurichthys polylepis)/
カスミチョウチョウウオ属 [カスミチョウチョウウオぞく] /(n) Hemitaurichthys (genus of tropical butterflyfish in the family Chaetodontidae)/
カスリイシモチ /(n) iridescent cardinalfish (Apogon kallopterus)/
カスリモヨウベニハゼ /(n) Griffiths' pygmy-goby (Trimma griffithsi, found in the Indo-West Pacific)/princess pygmy goby (Trimma marinae, found in Japan, New Guinea and Palau)/
カズザキヨモギ /(n) (uk) Japanese mugwort/
カズノバ /(n) Casanova/
カズワル /(n) (obsc) cassowary (Casuarius spp.)/
カセクシス /(n) cathexis/
カセット /(n) (1) cassette (tape)/(2) game cartridge/(P)/
カセットテープ /(n) cassette tape/(P)/
カセットテープレコーダー /(n) cassette tape recorder/
カセットデッキ /(n) cassette deck/
カセットブック /(n) cassette book/
カセットレコーダー /(n) cassette recorder/
カセトメーター /(n) cathetometer/
カセドラル /(n) cathedral (fre: cathedrale)/
カセロール /(n) casserole/
カゼ /(n) (abbr) casein/
カゼイン /(n) casein (ger: Kasein)/
カゼトゲタナゴ /(n) Rhodeus atremius atremius (subspecies of Kyushu bitterling)/
カソード /(n) cathode/
カソリック /(n) Catholic/
カタカナ /(n) (uk) katakana/angular Japanese syllabary used primarily for loanwords/(P)/
カタカナ語 [カタカナご] /(n) katakana word (esp. a loanword)/
カタカナ語辞典 [カタカナごじてん] /(n) katakana dictionary/loanword dictionary/
カタクチイワシ /(n) (uk) Japanese anchovy (Engraulis japonica)/
カタコンブ /(n) catacomb (fre: catacombes)/
カタコンベ /(n) catacombe (dut:)/
カタストロフ /(n) catastrophe/
カタストロフィ /(n) catastrophe/
カタストロフィー /(n) catastrophe/
カタツムリ /(n) (1) (uk) snail/
カタパルト /(n) catapult/
カタピラー /(n) caterpillar/endless track/
カタプルト /(n) catapult/
カタボシニシキベニハゼ /(n) Trimma nomurai (species of goby found in Japan, Indonesia and New Caledonia)/
カタマラン /(n) catamaran/
カタマラン船 [カタマランせん] /(n) catamaran ship/
カタラーゼ /(n) catalase (ger: Katalase)/
カタルシス /(n) catharsis (grc: katharsis)/
カタル性 [カタルせい] /(adj-no) catarrhal/
カタル性肺炎 [カタルせいはいえん] /(n) catarrhal pneumonia/
カタレプシー /(n) catalepsy/
カタログ /(n,vs) (uk) catalog/catalogue/(P)/
カタログショッピング /(n) catalog shopping/catalogue shopping/
カタログスペック /(n) (comp) catalog spec/
カタログセット /(n) (comp) catalog set/
カタログドプロシジャ /(n) (comp) cataloged procedure/
カタログプロパティ /(n) (comp) catalog property/
カタログレゾネ /(n) catalogue with the entire works of one artist (used to check authenticity) (fre:)/catalogue raisonne/
カタログ販売 [カタログはんばい] /(n) catalog retailing/catalogue retailing/
カタン糸 [カタンいと] /(n) cotton/
カダベリン /(n) cadaverine/
カダヤシ /(n) (uk) mosquitofish (Gambusia affinis)/mosquito fish/gambusia/
カチオン /(n) cation/
カチッ /(n) klik/plock/
カチューシャ /(n) (1) cloth band worn around hair - named after a character in Tolstoy's novel "Resurrection" (rus: Katyusha)/(2) Katyusha rocket launcher (Soviet)/(3) name of a popular song/(P)/
カチンカチン /(adj-na) (1) rock hard/stiff and unyielding (personality)/(n) (2) clangor/
カチンコ /(n) clapperboard/
カチン語 [カチンご] /(n) Kachin (language)/
カッと /(adv,n,vs) (on-mim) flare up/flying into a rage/(P)/
カッとなる /(exp,v5r) (col) to flare up/to fly into a rage/
カッと来る [カッとくる] /(vk) (uk) to be made angry/to fly into a rage/
カッコ /(ik) (adj-na,n,adj-no) (1) shape/form/posture/appearance/manner/(2) suitability/moderateness (in price)/
カッコー /(ik) (n) (uk) common cuckoo (Cuculus canorus)/
カッコウ /(n) (uk) common cuckoo (Cuculus canorus)/
カッコカワイイ /(exp) (col) cool and cute/
カッコ内 [カッコない] /(exp,adj-no) in parentheses/bracketed/
カッター /(n) cutter/(P)/
カッターシャツ /(n) cutter shirt (long-sleeved sports shirt)/
カッターシューズ /(n) cutter shoes/
カッターナイフ /(n) box cutter (wasei: cutter knife)/utility knife/
カッタウェー /(n) cutaway (coat, jacket, etc.)/
カッタウエイ /(n) cutaway (coat, jacket, etc.)/
カッチ /(n) cutch (catechu)/
カッテージチーズ /(n) cottage cheese/
カッティング /(n,vs) cutting/
カッティングボード /(n) cutting board/
カット /(n,vs) cut/cutting/
カット＆ペースト [カットアンドペースト] /(n) (comp) cut and paste/cut & paste/
カットアウト /(n) (comp) cutout/
カットアンドコピー機能 [カットアンドコピーきのう] /(n) (comp) cut and copy function/
カットアンドソーン /(exp) cut and sewn/
カットイン /(exp) cut-in/
カットオーバ /(n) (comp) cutover/cut-over/starting new (IT) equipment/transferring from the old to a new (hardware and/or software) system./
カットオーバー /(n) (comp) cutover/cut-over/starting new (IT) equipment/transferring from the old to a new (hardware and/or software) system./
カットオフ /(n) cutoff (play) (baseball)/
カットグラス /(n) cut glass/
カットシート /(n) (comp) cut sheet (paper)/
カットシートフィーダ /(n) (comp) cut-sheet feeder/
カットステップ /(n) cut step/
カットソー /(n) (abbr) clothes made from jersey cloth (wasei: cut and sewn)/
カットハウス /(n) beauty parlour (wasei: cut house)/beauty parlor/
カットバック /(n) cutback/
カットバッファ /(n) (comp) cut buffer/
カットバン /(n) (abbr) band aid/(pre-cut) adhesive plaster/
カットフィルム /(n) cut film (i.e. sheet film)/
カットペースト /(n) (comp) cut and paste/cut & paste/
カットワーク /(n) cutwork/
カット紙 [カットし] /(n) (comp) cut paper/
カッパーマイン /(n) (comp) Coppermine/
カッフェー /(n) (1) cafe (fre:)/(2) hostess bar (serving western alcoholic beverages; Taisho and Showa period)/
カップ /(n) cup/(P)/
カップアイス /(n) ice cream cup (wasei: cup ice)/icecream cup/
カップケーキ /(n) cupcake/fairy cake/
カップスタン /(n) capstan/
カップボード /(n) cupboard/
カップラ /(n) coupler/
カップラー /(n) coupler/
カップラーメン /(n) cup noodles/cup ramen/
カップリング /(n) coupling/
カップリングシュガー /(n) coupling sugar/(P)/
カップリング曲 [カップリングきょく] /(n) coupling track/B side/B-side/
カップル /(n) couple/(P)/
カップ麺 [カップめん] /(n) instant noodles purchased in cup (lit: cup noodle(s))/
カッペ /(n) (abbr) (vulg) hick/country bumpkin/yokel/
カツ /(n) (abbr) cutlet/(P)/
カツオノエボシ /(n) (uk) Portuguese man-of-war (Physalia physalis)/
カツオ節 [カツオぶし] /(n) katsuobushi (small pieces of sliced dried bonito)/
カツカツ /(adv-to) (uk) clicking/clopping/clacking/
カツラ /(n) (uk) Japanese Judas tree (Cercidiphyllum japonicum)/
カツラ科 [カツラか] /(n) Cercidiphyllaceae (monotypic plant family containing the Japanese Judas trees)/
カツレツ /(n) cutlet (usu. crumbed and fried)/
カツ丼 [カツどん] /(n) breaded pork on rice/
カテージチーズ /(n) cottage cheese/
カテーテル /(n) catheter (ger: Katheter)/(P)/
カテキズム /(n) catechism/
カテキュー /(n) catechu (vegetable extract containing tannin)/cachou/
カテキン /(n) catechin/
カテコール /(n) catechol/
カテコールアミン /(n) catecholamine/
カテゴライザ /(n) (comp) categorizer/
カテゴライズ /(vs) categorize/
カテゴリ /(n) category (ger: Kategorie)/
カテゴリー /(n) category (ger: Kategorie)/(P)/
カテゴリーキラー /(n) category killer/
カテゴリーミステーク /(n) category mistake/
カテゴリー化 [カテゴリーか] /(n,vs) categorization/
カテゴリィ /(n) (comp) category/
カテゴリプロパティ /(n) (comp) category property/
カテドラル /(n) cathedral (fre: cathedrale)/
カテプシン /(n) cathepsin/
カデンツ /(n) cadence (ger: Kadenz)/(P)/
カデンツァ /(n) cadenza (ita:)/
カト /(n) (1) cat/(2) kat/qat/quat/khat/
カトマイ /(n) (comp) Katmai/
カトラリー /(n) cutlery/
カトリシズム /(n) Catholicism/(P)/
カトリック教会 [カトリックきょうかい] /(n) Catholic Church/(P)/
カトリック信仰 [カトリックしんこう] /(n) Catholicism/
カトレア /(n) cattleya (type of orchid) (lat:)/
カトレヤ /(n) cattleya (type of orchid) (lat:)/(P)/
カドヘリン /(n) cadherin/
カドミウム /(n) cadmium (Cd)/(P)/
カドミウムイエロー /(n) cadmium yellow/
カドミウムオレンジ /(n) cadmium orange/
カドミウムレッド /(n) cadmium red/
カドミウム赤 [カドミウムあか] /(n) cadmium red/
カドミウム中毒 [カドミウムちゅうどく] /(n) cadmium poisoning/
カドミウム標準電池 [カドミウムひょうじゅんでんち] /(n) cadmium standard cell/
カドリール /(n) quadrille/
カナカ /(n) (sens) kanaka/Polynesians, Micronesians, and native Hawaiians/
カナガシラ /(n) (uk) red-whiskered bulbul (Lepidotrigla microptera)/
カナキン /(n) canequim (por:)/unbleached muslin/calico/
カナスタ /(n) canasta/
カナダ /(n) (uk) Canada/
カナダガン /(n) (uk) Canada goose (Branta canadensis)/
カナダデー /(n) Canada Day/
カナダバルサム /(n) Canada balsam (resin obtained from balsam fir)/
カナダ雁 [カナダがん] /(n) (uk) Canada goose (Branta canadensis)/
カナダ自由党 [カナダじゆうとう] /(n) Liberal Party of Canada/
カナダ進歩保守党 [カナダしんぽほしゅとう] /(n) Progressive Conservative Party of Canada/
カナダ人 [カナダじん] /(n) Canadian (person)/
カナダ人権憲章 [カナダじんけんけんしょう] /(n) Canadian Charter of Rights and Freedoms/
カナダ藻 [カナダも] /(n) waterweed (any aquatic plant of genus Elodea, esp. common waterweed, Elodea canadensis)/
カナダ鶴 [カナダづる] /(n) (uk) sandhill crane (Grus canadensis)/
カナッペ /(n) canape (piece of furniture, small open sandwich) (fre:)/
カナディアン /(n,adj-no) Canadian/
カナディアンカヌー /(n) Canadian canoe/
カナディアンベーコン /(n) Canadian bacon/
カナブン /(n) (uk) drone beetle (scarabaeid beetle) (Rhomborrhina japonica)/
カナヘビ /(n) (uk) lacertid (any lizard of family Lacertidae, esp. the Japanese grass lizard, Takydromus tachydromoides)/
カナペ /(n) canape (piece of furniture, small open sandwich) (fre:)/
カナマイシン /(n) kanamycin/
カナマイジン /(n) kanamycin/
カナムグラ /(n) (uk) Japanese hop (Humulus japonicus)/
カナメモチ /(n) Japanese photinia (Photinia glabra)/
カナリー /(n) (uk) canary (esp. the island canary, Serinus canaria) (por:)/
カナリーダムゼル /(n) Canary damsel (Abudefduf luridus)/
カナリア /(n) (uk) canary (esp. the island canary, Serinus canaria) (por:)/(P)/
カナリアナス /(n) (uk) nipplefruit (Solanum mammosum)/apple of Sodom/titty fruit/cow's udder/
カナリア色 [カナリアいろ] /(n) canary/daffodil yellow/
カナリヤ /(n) (uk) canary (esp. the island canary, Serinus canaria) (por:)/
カナンガ /(n) ylang-ylang (Cananga odorata)/ilang-ilang/
カナンガ油 [カナンガゆ] /(n) cananga oil/ylang-ylang oil/ilang-ilang oil/
カニカマ /(n) imitation crab meat/
カニクイアザラシ /(n) (uk) crabeater seal (Lobodon carcinophagus)/
カニクサ /(n) (uk) Japanese climbing fern (Lygodium japonicum)/
カニグモ /(n) (uk) crab spider (any spider of family Thomisidae)/
カニダマシ /(n) (uk) porcelain crab (any decapod crustacean of family Porcellanidae)/
カニバリズム /(n) cannibalism/
カニバル /(n) cannibal/
カニミソ /(n) (uk) miso-like paste found inside a crab's (and arthropods in general) intestinal area/
カニムシ /(n) (uk) pseudoscorpion (any arachnid of order Pseudoscorpionida)/false scorpion/
カニューレ /(n) cannula (ger: Kanuele)/
カニ蒲 [カニかま] /(n) imitation crab meat/
カニ漁 [カニりょう] /(n) crab fishing/crabbing/
カヌー /(n) canoe/(P)/
カヌーイスト /(n) canoeist/
カヌーイング /(n) canoeing/
カヌー競技 [カヌーきょうぎ] /(n) canoeing/
カネヒラ /(n) (uk) Acheilognathus rhombeus (species of cyprinid)/
カネローニ /(n) canneloni (ita:)/
カネロニ /(n) canneloni (ita:)/
カネロニー /(n) canneloni (ita:)/(P)/
カノープス壺 [カノープスつぼ] /(n) Canopic jar/Canopic vase (used to store the internal organs of an Egyptian mummy)/
カノーラ /(n) Canola (oil)/
カノプス壺 [カノプスつぼ] /(n) Canopic jar/Canopic vase (used to store the internal organs of an Egyptian mummy)/
カノポス壺 [カノポスつぼ] /(n) Canopic jar/Canopic vase (used to store the internal organs of an Egyptian mummy)/
カノン /(n) (1) canon/(2) (abbr) cannon (dut: kanon)/
カノン法 [カノンほう] /(n) canon law/
カノン砲 [カノンほう] /(n) cannon (esp. high-velocity artillery)/
カバ /(n) (uk) birch (esp. Japanese white birch)/
カバ /(n) (uk) hippopotamus (Hippopotamus amphibius)/
カバ /(n) kava (Piper methysticum)/kavakava/
カバー /(n,vs) (1) cover (e.g. book)/(P)/
カバーエリア /(n) (comp) coverage area/
カバーオール /(n) coverall/
カバーガール /(n) cover girl/
カバーガラス /(n) cover glass/
カバーグラス /(n) cover glass/
カバーチャージ /(n) cover charge/
カバート /(adj-no) covert/
カバーバージョン /(n) cover version/
カバーリング /(n) covering/
カバーレター /(n) cover letter/covering letter/
カバーロール /(n) coverall/
カバーン /(n) cavern/
カバー曲 [カバーきょく] /(n) remake of another artist's song (a "cover")/
カバキコマチグモ /(n) (uk) Japanese foliage spider (Chiracanthium japonicum)/
カバノキ /(n) (uk) birch tree (esp. the Japanese white birch, Betula platyphylla var. japonica)/
カバノキ科 [カバノキか] /(n) Betulaceae (plant family)/hazelnut/
カバラ /(n) kabbalah (qabalah, cabala) (Jewish mystic tradition)/
カバリエ /(n) cavalier (fre:)/
カバレッジ /(n) coverage/
カビ /(n) mold/mould/mildew/
カビが生える [カビがはえる] /(exp,v1) (1) to get moldy/to get mouldy/(2) (id) to get out-of-fashion/
カビア /(n) caviare/caviar/
カビ臭 [カビしゅう] /(n) mold smell/mould smell/
カビ臭い [カビくさい] /(adj-i) musty/putrid/
カピカピ /(adj-na,adv,adj-no) (on-mim) (col) crusty/flaky/dried out/
カピタル /(n) capital/
カピチュレーション /(n) capitulation/
カピバラ /(n) capybara/
カフェ /(n) (1) cafe (fre:)/(2) hostess bar (serving western alcoholic beverages; Taisho and Showa period)/(P)/
カフェー /(n) (1) cafe (fre:)/(2) hostess bar (serving western alcoholic beverages; Taisho and Showa period)/
カフェる /(v5r) (sl) to go to a cafe/
カフェアラクレーム /(n) cafe a la creme (fre:)/
カフェイン /(n) caffeine (ger: Kaffein)/(P)/
カフェエスプレッソ /(n) expresso coffee (ita: caffe espresso)/
カフェオレ /(n) cafe au lait (fre:)/
カフェキャバ /(n) cafe cabaret/
カフェテラス /(n) sidewalk cafe (fre: cafe terrasse)/footpath cafe/
カフェテリア /(n) cafeteria/(P)/
カフェナポリターノ /(n) Neapolitan coffee (ita: caffe napolitano)/
カフェノワール /(n) black coffee (fre: cafe noir)/
カフェバー /(n) cafe bar (fre:)/
カフェラッテ /(n) cafe latte (ita:)/latte/
カフェラテ /(n) cafe latte (ita:)/latte/
カフェロワイヤル /(n) cafe royal (fre:)/
カフカス人 [カフカスじん] /(n) Caucasian person/
カフス /(n) cuffs/(P)/
カフスカバー /(n) cuffs-cover/
カフスボタン /(n) cuff links (wasei: cuffs button)/
カフタン /(n) caftan/
カフドパンツ /(n) cuffed pants/
カフリンクス /(n) cuff links/
カブ /(n) cub/(P)/
カブスカウト /(n) cub scout/
カブトウオ /(n) (1) (uk) large-headed midnight fish (Poromitra crassiceps)/(2) armored fish/armoured fish/
カブトガニ /(n) (uk) horseshoe crab/
カブトムシ /(n) (uk) rhinoceros beetle (esp. the Japanese rhinoceros beetle, Trypoxylus dichotomus)/
カブト虫 [カブトむし] /(n) (uk) rhinoceros beetle (esp. the Japanese rhinoceros beetle, Trypoxylus dichotomus)/
カブラヤスズメダイ /(n) Ternate chromis (Chromis ternatensis)/
カブリオレ /(n) cabriolet (soft-top convertible) (fre:)/
カプサイシン /(n) capsaicin/
カプセル /(n,adj-no) capsule (ger: Kapsel)/(P)/
カプセルホテル /(n) capsule hotel/
カプセル化 [カプセルか] /(n) (comp) encapsulation/
カプチーノ /(n) cappuccino (ita:)/
カプラ /(n) coupler/
カプラー /(n) coupler/(P)/
カプリオール /(n) capriole/
カプリコン /(n) Capricorn/
カプリチオ /(n) capriccio (ita:)/
カプリッチオ /(n) capriccio (ita:)/(P)/
カプリン酸 [カプリンさん] /(n) capric acid/
カプロラクタム /(n) caprolactam/
カプロン酸 [カプロンさん] /(n) caproic acid/
カベルネ・ソービニヨン /(n) Cabernet Sauvignon (wine grape variety)/
カベルネ・フラン /(n) Cabernet Franc (wine grape variety)/
カベルネソービニヨン /(n) Cabernet Sauvignon (wine grape variety)/
カベルネフラン /(n) Cabernet Franc (wine grape variety)/
カペッリ・ダンジェロ /(n) angel hair pasta (ita: capelli d'angelo)/
カペッリーニ /(n) capellini (ita:)/
カペッリダンジェロ /(n) angel hair pasta (ita: capelli d'angelo)/
カペラ /(n) Capella (star) (lat:)/
カペリン /(n) capelin/caplin (Mallotus villosus)/
カボス /(n) (uk) kabosu (type of citrus fruit) (Citrus sphaerocarpa)/
カボチャ /(n) (uk) pumpkin/squash/
カボベルデ /(n) Cape Verde/
カポー /(n) (sl) couple/
カポエイラ /(n) capoeira (por:)/
カポエラ /(n) capoeira (por:)/
カポシ肉腫 [カポシにくしゅ] /(n) Kaposi's sarcoma/
カポジ肉腫 [カポジにくしゅ] /(n) Kaposi's sarcoma/
カポック /(n) kapok/
カポックの木 [カポックのき] /(n) kapok tree (species of silk-cotton tree, Ceiba pentandra)/
カマーバンド /(n) cummerbund/(P)/
カマアシムシ /(n) (uk) proturan (any wingless insect of order Protura)/
カマアシムシ目 [カマアシムシもく] /(n) Protura (order of wingless insects)/
カマイルカ /(n) (uk) Pacific white-sided dolphin (Lagenorhynchus obliquidens)/
カマキリ /(n) (uk) praying mantis (esp. the narrow-winged mantis, Tenodera angustipennis)/
カマキリモドキ /(n) (uk) mantidfly (any insect of the family Mantispidae)/
カマシア /(n) camassia/wild hyacinth/
カマス /(n) (uk) barracuda/
カマスサワラ /(n) (uk) wahoo (species of fish, Acanthocybium solandri)/
カマストガリザメ /(n) blacktip shark (Carcharhinus limbatus, species of reef-associated requiem shark)/
カマツカ /(n) (1) (uk) sickle handle/(2) goby minnow (Pseudogobio esocinus)/(3) Oriental photinia (species of shrub, Photinia villosa)/(4) Asiatic dayflower (Commelina communis)/(5) Joseph's-coat (species of amaranth, Amaranthus tricolor)/
カマヒレザメ /(n) snaggletooth shark (Hemipristis elongata, species of Indo-West Pacific weasel shark and the only extant member of its genus)/
カマヒレザメ属 [カマヒレザメぞく] /(n) Hemipristis (genus of the weasel shark family Hemigaleidae with the snaggletooth shark as its only extant species)/
カマボコ型 [カマボコがた] /(adj-no) semi-circular/D-shaped/
カマラサウルス /(n) Camarasaurus (genus of Jurassic dinosaurs) (lat:)/
カマンベール /(n) camembert (fre:)/
カミセン /(n) (abbr) younger members of the group (wasei: coming century)/
カミソリ /(n) (uk) razor/
カミツキガメ /(n) (uk) snapping turtle (Chelydra serpentina)/
カミナリ族 [カミナリぞく] /(n) hot rodders/thunder tribe/vrooming motorcycle gangs/
カミニッカーズ /(n) cami-knickers/
カミン /(n) chimney (narrow cleft used to climb a rock face) (ger: Kamin)/
カミングアウト /(n,vs) coming out (of the closet, etc.)/
カミングスーン /(exp) coming soon/
カム /(n) cam/(P)/
カムイ /(n) god (ain: kamuy)/deity/divinity/spirit/kami/
カムコーダー /(n) (comp) camcorder/
カムシャフト /(n) camshaft/
カムバック /(n,vs) comeback/(P)/
カムフラージュ /(n,vs) camouflage (fre:)/
カムルチー /(n) northern snakehead (species of fish, Channa argus) (kor: kamultchi)/
カムルチイ /(n) northern snakehead (species of fish, Channa argus) (kor: kamultchi)/
カメオ /(n) cameo/
カメコ /(n) (abbr) photographer, usually an amateur, who likes to take pictures of models and presenter ladies in exhibitions/
カメムシ /(n) (uk) shield bug/stink bug/
カメムシ目 [カメムシもく] /(n) Hemiptera (taxonomic order comprising the true bugs)/
カメラ /(n) camera/(P)/
カメラアイ /(n) camera-eye/
カメラアングル /(n) camera angle/
カメラオブスキュラ /(n) camera obscura/
カメラオブスクーラ /(n) camera obscura/
カメラポジション /(n) camera position/
カメラマン /(n) cameraman/(P)/
カメラリハーサル /(n) camera rehearsal/
カメラルーシダ /(n) camera lucida (lat:)/
カメラルシダ /(n) camera lucida (lat:)/
カメラルポ /(n) (abbr) camera reportage/
カメラルポルタージュ /(n) camera reportage/
カメラワーク /(n) camera work/
カメラ割り [カメラわり] /(n) camera blocking/
カメラ小僧 [カメラこぞう] /(n) photographer, usually an amateur, who likes to take pictures of models and presenter ladies in exhibitions/
カメリア /(n) camellia (lat:)/
カメリハ /(n) (abbr) camera rehearsal/
カメレオン /(n) chameleon/(P)/
カメンベール /(n) camembert/
カメ虫 [カメむし] /(n) (uk) shield bug/stink bug/
カメ目 [カメもく] /(n) Testudines/
カモシカ /(n) (uk) serow/wild goat/
カモノハシ /(n) (uk) platypus (Ornithorhynchus anatinus)/
カモハシ竜 [カモハシりゅう] /(n) duck-billed dinosaur/hadrosaur/
カモフラージ /(n,vs) camouflage (fre:)/(P)/
カモフラージュ /(n,vs) camouflage (fre:)/
カモマイル /(n) German chamomile (Matricaria recutita)/German camomile/
カモミール /(n) German chamomile (Matricaria recutita)/German camomile/
カモメ /(n) (1) (uk) common gull (Larus canus)/mew gull/(2) gull (Laridae spp.)/seagull/
カモ科 [カモか] /(n) Anatidae (duck family of birds)/
カモ目 [カモもく] /(n) Anseriformes (order of swimming birds)/
カヤ /(n) (uk) Japanese nutmeg tree (Torreya nucifera)/
カヤクグリ /(n) (uk) Japanese accentor (Prunella rubida)/
カヤック /(n,vs) kayak/(P)/
カヤツリグサ /(n) (1) (uk) galingale (any plant of genus Cyperus, esp. species Cyperus microiria)/
カヤネズミ /(n) (uk) harvest mouse (Mus minutus)/
カラー /(n) (1) collar/(2) color/colour/(3) calla (variety of arum lily)/(P)/
カラーアナリスト /(n) color analyst/
カラーアレンジメント /(n) color arrangement/colour arrangement/
カラーイメージ /(n) (comp) color image/
カラーイメージスキャナ /(n) (comp) graphics scanner/
カラーインク /(n) colored ink/coloured ink/
カラーガード /(n) color guard/colour guard/
カラーギャング /(n) Japanese street gang (wasei: color gang)/
カラーグラフィックス /(n) (comp) color graphics/
カラーコーディネーション /(n) color coordination/
カラーコーディネーター /(n) color coordinator/colour coordinator/(P)/
カラーコード /(n) (comp) color code/
カラーコーン /(n) color cone/
カラーコンディショニング /(n) color conditioning/colour conditioning/
カラーコンビネーション /(n) color combination/colour combination/
カラーサークル /(n) color circle/
カラーシャツ /(n) (1) colored shirt (wasei: color shirt)/(2) shirt with a collar (wasei: collar shirt)/
カラースキーム /(n) color scheme/colour scheme/
カラースキャナー /(n) colour scanner (color)/
カラースケール /(n) color scale/
カラースプレー /(n) color spraypaint/colour spraypaint/
カラーセパレーション /(n) (comp) color separation/
カラーダイナミックス /(n) color dynamics/colour dynamics/
カラーチャート /(n) (comp) color chart/
カラーディスプレー /(n) color display/colour display/
カラートーン /(n) color screentone/colour screentone/color mechanical tint/colour mechanical tint/
カラートタン /(n) (abbr) colored steel sheet/coloured steel sheet/
カラード /(n) colored/coloured/(P)/
カラーネガフィルム /(n) color negative film (colour)/
カラーバー /(n) color bars (television test pattern)/colour bars/
カラーパレット /(n) (comp) color pallet/
カラービット /(n) (comp) color bits/
カラーフィールドペインティング /(n) colorfield painting/
カラーフィルム /(n) color film (colour)/
カラープランニング /(n) color planning/colour planning/
カラープリンタ /(n) (comp) color printer/
カラープリント /(n) colour print (color)/
カラーペン /(n) color pen/
カラーボール /(n) (1) colored ball/(2) anti-thief colored ball (filled with a colored dye)/paintball/
カラーボックス /(n) color box/colour box/
カラーマーカー /(n) color marking pen/colour marking pen/
カラーマネジメントシステム /(n) (comp) color management system/
カラーリバーサルフィルム /(n) color reversal film (colour)/
カラーリンス /(n) color rinse/colour rinse/
カラールックアップテーブル /(n) (comp) color look-up table/
カラーレス /(n) (1) collarless/(2) colorless/colourless/
カラー液晶 [カラーえきしょう] /(n) (comp) color LCD/
カラー写真 [カラーしゃしん] /(n) color photo/colour photo/
カライダ /(n) (comp) Kaleida/
カライトソウ /(n) (uk) Sanguisorba hakusanensis/
カライワシ /(n) (uk) Hawaiian ladyfish (Elops hawaiensis)/
カラオケ /(n,adj-no) (uk) karaoke (singing to taped accompaniment)/(P)/
カラオケ・ボックス /(n) karaoke box/club with individual rooms that can be rented with karaoke machines/
カラオケバー /(n) karaoke bar/
カラオケボックス /(n) karaoke box/club with individual rooms that can be rented with karaoke machines/
カラオケ屋 [カラオケや] /(n) karaoke club (bar)/
カラカラ /(n) caracara/
カラカル /(n) caracal (Caracal caracal)/African lynx/
カラギーナン /(n) carrageenan (seaweed-based emulsifying agent)/
カラギナン /(n) carrageenan (seaweed-based emulsifying agent)/
カラクサオオセ /(n) ornate wobbegong (Orectolobus ornatus, species of Western Pacific carpet shark)/
カラゲナン /(n) carrageenan (seaweed-based emulsifying agent)/
カラザ /(n) chalaza (part of egg tissue)/
カラシン科 [カラシンか] /(n) Characidae (family comprising the characins)/
カラス /(n) crow/raven/
カラスアゲハ /(n) (uk) Chinese peacock (species of swallowtail butterfly, Papilio bianor)/
カラスウリ /(n) (uk) Japanese snake gourd (Trichosanthes cucumeroides)/
カラスガイ /(n) (uk) cockscomb pearl mussel (Cristaria plicata)/
カラスムギ /(n) (1) (uk) wild oat (Avena fatua)/wild oats/(2) oat (Avena sativa)/oats/
カラス麦 [カラスむぎ] /(n) (1) (uk) wild oat (Avena fatua)/wild oats/(2) oat (Avena sativa)/oats/
カラタケ /(n) (1) (uk) Japanese timber bamboo (Phyllostachys bambsoides)/giant timber bamboo/madake/(2) Henon bamboo (Phyllostachys nigra var. henonis)/
カラタチ /(n) (uk) trifoliate orange (Poncirus trifoliata)/hardy orange/
カラチ /(n) Karachi/(P)/
カラッと /(adv,vs) (1) (on-mim) changing suddenly and completely/(2) crisp and dry (e.g. skies, weather, tempura, laundry, etc.)/
カラット /(n) carat/karat/(P)/
カラトウキ /(n) (uk) dong quai (aromatic herb used to treat various gynecological symptoms, Angelica sinensis)/
カラナデシコ /(n) (uk) (obsc) China pink (species of flower, Dianthus chinensis)/
カラバラ /(n) ballads sung by Karashima Midori/
カラビナ /(n) carabiner (ger: Karabiner)/snap ring/
カラフ /(n) carafe/
カラフトフクロウ /(n) (uk) great grey owl (Strix nebulosa)/
カラフトマス /(n) (uk) pink salmon (Oncorhynchus gorbuscha)/humpback salmon/
カラフトライチョウ /(n) (uk) willow ptarmigan (Lagopus lagopus)/
カラフル /(adj-na,n) colorful/colourful/(P)/
カラボケ /(n) kara flowering quince/Choenomeles lagenaria/
カラマツ /(n) (uk) (Japanese) larch (Larix leptolepis, Larix kaempferi)/
カラミン /(n) calamine/
カラム /(n) column (esp. in chemistry, file, equipment, etc.)/
カラムシ /(n) (uk) ramie (Boehmeria nivea var. nipononivea)/
カラムチャート /(n) (comp) column chart/
カラメル /(n) caramel/
カラメルソース /(n) caramel sauce/
カラモモ /(n) (1) (uk) apricot (Prunus armeniaca)/(2) Prunus persica var. densa (Chinese variety of peach)/
カラライゼーション /(n) colorization/
カラリスト /(n) colorist/colourist/
カラン /(n) water outlet (ger: Kran, dut: kraan)/tap/faucet/
カランコエ /(n) kalanchoe (esp. species Kalanchoe blossfeldiana) (lat:)/
カランコロン /(n) (on-mim) sound made by geta/clip-clop/
カランツ /(n) currants/
カランティンサービス /(n) (comp) quarantine service/
カリアチード /(n) caryatide (fre:)/
カリアティード /(n) caryatid/
カリウム /(n,adj-no) potassium (K) (ger: kalium)/(P)/
カリウムアルゴン法 [カリウムアルゴンほう] /(n) potassium-argon dating/
カリエス /(n,adj-no) caries (ger: Karies)/
カリカチュール /(n) caricature (fre:)/
カリカチュア /(n) caricature/
カリカチュライズ /(n) caricaturize/caricaturise/
カリガネソウ /(n) (uk) blue spirea (Caryopteris divaricata)/blue mist shrub/
カリガラス /(n) Kaliglas (dut:)/potash glass/
カリキュラム /(n) curriculum/(P)/
カリグラフィー /(n) calligraphy/
カリグラフィック表示装置 [カリグラフィックひょうじそうち] /(n) (comp) calligraphic display device/directed beam display device/
カリコム /(n) Caribbean Community (from CARICOM)/
カリスト /(n) Callisto/
カリスマ /(n,adj-f) (1) charisma (ger: Charisma)/(2) divinely conferred power or talent/(3) charismatic person/(P)/
カリスマチック /(n) charismatic/
カリスマ性 [カリスマせい] /(n) charisma/
カリスマ先生 [カリスマせんせい] /(n) (col) charismatic teacher/charming professor/
カリスマ美容師 [カリスマびようし] /(n) star beautician/famous beautician/
カリット /(n) crunchy/
カリニ肺炎 [カリニはいえん] /(n) pneumocystis carinii pneumonia/
カリバチ /(n) hunter wasp (i.e. potter wasp, sand wasp, etc.)/
カリパス /(n) (pair of) calipers/
カリビアン /(n,adj-no) Caribbean/
カリビアン・リーフ・シャーク /(n) Caribbean reef shark (Carcharhinus perezii, species of requiem shark found in the tropical waters of the western Atlantic Ocean from Florida to Brazil)/
カリビアンリーフシャーク /(n) Caribbean reef shark (Carcharhinus perezii, species of requiem shark found in the tropical waters of the western Atlantic Ocean from Florida to Brazil)/
カリフ /(n) caliph/chief civil and religious Muslim ruler (prior to 1924)/
カリフォルニア /(n) California/(P)/
カリフォルニア・スウェル・シャーク /(n) swellshark (Cephaloscyllium ventriosum, species of catshark in the Eastern Pacific)/
カリフォルニアコンドル /(n) California condor (Gymnogyps californianus)/
カリフォルニアスウェルシャーク /(n) swellshark (Cephaloscyllium ventriosum, species of catshark in the Eastern Pacific)/
カリフォルニアドチザメ /(n) leopard shark (Triakis semifasciata, species found along the Pacific coast of North America)/
カリフォルニアネコザメ /(n) horn shark (Heterodontus francisci, a bullhead shark from the Eastern Pacific)/
カリフォルニアロール /(n) California roll/
カリフラワー /(n) cauliflower/
カリブー /(n) caribou/
カリブヘラザメ /(n) smallfin catshark (Apristurus parvipinnis, species of the western Atlantic)/
カリブ海 [カリブかい] /(n,adj-no) Caribbean Sea/(P)/
カリプソ /(n) calypso/
カリホルニウム /(n) californium (Cf)/
カリヨン /(n) carillon (fre:)/
カリロン /(n) carillon (fre:)/
カリン /(n) (1) (uk) Burmese rosewood (Pterocarpus indicus)/angsana/amboyna/amboina/(2) (uk) flowering quince (of genus Chaenomeles) (Pseudocydonia sinensis)/Chinese quince (Chaenomeles sinensis)/(3) (uk) quince (Cydonia oblonga)/
カリンバ /(n) kalimba (bnt:)/
カリ活用 [カリかつよう] /(n) classical form of i-adjective inflection formed by contraction of the "ku" adverbial form with the classical verb "ari" ("aru")/
カリ岩塩 [カリがんえん] /(n) sylvite/sylvine/
カリ首 [カリくび] /(n) (1) (something resembling a) goose's neck/(2) glans/head of a penis/
カリ石鹸 [カリせっけん] /(n) potash soap/
カリ長石 [カリちょうせき] /(n) potash feldspar/
カリ肥料 [カリひりょう] /(n) potash fertilizer/potash fertiliser/
カリ明礬 [カリみょうばん] /(n) potassium alum/
カルーア /(n) Kahlua (coffee liqueur)/
カルーセル /(n) carousel/
カルウエ /(n) (abbr) calcium wafer/
カルガリー /(n) Calgary/(P)/
カルキ /(n) chalk (ger: Kalk, dut: kalk)/(P)/
カルキュレータ /(n) (comp) calculator/
カルキュレーター /(n) (comp) calculator/
カルク /(n) (comp) spreadsheet (wasei: calc)/
カルシウム /(n) calcium (Ca)/(P)/
カルシウムシアナミド /(n) calcium cyanamide (CaCN2)/
カルシトニン /(n) calcitonin/
カルシフェロール /(n) calciferol/
カルジオスコープ /(n) cardioscope/
カルス /(n) callus/
カルスト /(n,adj-no) karst (geologic formation of irregular limestone deposits) (ger: Karst)/
カルスト地形 [カルストちけい] /(n) karst/
カルセオラリア /(n) calceolaria (lat:)/
カルソン /(n) (1) boy/(2) male waiter (fre: garcon)/
カルタ /(n) (uk) playing cards (por: carta)/card game/
カルタ会 [カルタかい] /(n) card match (esp. using uta-garuta)/
カルダモン /(n) cardamom/(P)/
カルチノイド /(n) carcinoid/
カルチベーター /(n) cultivator/
カルチャー /(n) culture/(P)/
カルチャーショック /(n) culture shock/(P)/
カルチャーセンター /(n) culture center/culture centre/(P)/
カルチュラルスタディーズ /(n) cultural studies/
カルツーン /(n) cartoon/
カルテ /(n) clinical records (ger: Karte)/(P)/
カルティエ /(n) Cartier/
カルテジアン劇場 [カルテジアンげきじょう] /(n) Cartesian theatre/
カルテット /(n) quartet (ita: quartetto)/(P)/
カルテル /(n) cartel (ger: Kartell)/(P)/
カルデア人 [カルデアじん] /(n) Chaldean (person)/
カルデラ /(n) caldera/(P)/
カルデラ湖 [カルデラこ] /(n) caldera lake/
カルト /(n) cult/(P)/
カルトゥーシュ /(n) cartouche (fre:)/
カルトン /(n) (1) carton (e.g. of cigarettes)/(2) tray (in which money is placed when paying)/dish/(3) pasteboard (fre: carton)/
カルト映画 [カルトえいが] /(n) cult film/cult movie/
カルニチン /(n) carnitine/
カルノーサイクル /(n) Carnot cycle/Carnot's cycle/
カルノー図 [カルノーず] /(n) Karnaugh map/Karnaugh diagram (for mapping Boolean expressions)/
カルバドス /(n) calvados (fre:)/(P)/
カルバマゼピン /(n) carbamazepine/
カルバミン酸 [カルバミンさん] /(n) carbamic acid/
カルバン主義 [カルバンしゅぎ] /(n) Calvinism/
カルパ /(n) tent (spa: carpa)/
カルパス /(n) Kolbasa (semi-dry Russian sausage)/calpas/
カルパッチョ /(n) carpaccio (ita:)/
カルビ /(n) beef ribs (kor: galbi)/
カルピス /(n) (1) Calpis (Japanese milk-based soft drink)/(2) (col) sperm/semen/cum/(P)/
カルフォルニア /(n) California/
カルボイ /(n) carboy/
カルボキシル /(n) carboxyl/
カルボキシル基 [カルボキシルき] /(n) carboxyl group/
カルボキシ基 [カルボキシき] /(n) carboxy group/
カルボナーラ /(n) (spaghetti alla) carbonara (type of pasta) (ita:)/
カルボニル化合物 [カルボニルかごうぶつ] /(n) carbonyl compound/
カルボニル基 [カルボニルき] /(n) carbonyl group/
カルボン酸 [カルボンさん] /(n) carboxylic acid/
カルマ /(n) Karma/
カルマンフィルター /(n) (comp) Kalman filter/
カルミア /(n) kalmia (esp. mountain laurel, Kalmia latifolia) (lat:)/
カルミン /(n) carmine (dut: karmijn)/
カルメラ /(n) caramel (por: caramelo)/(P)/
カルメ焼 [カルメやき] /(n) caramel (por: caramelo)/
カルモジュリン /(n) calmodulin/
カルヴァン主義 [カルヴァンしゅぎ] /(n) Calvinism/
カレー /(n) (abbr) curry/(P)/
カレーコーナー /(n) curry corner/
カレーソース /(n) curry sauce/
カレードスコープ /(n) kaleidoscope/
カレーライス /(n) curry and rice/(P)/
カレー饂飩 [カレーうどん] /(n) Udon cooked with curry topping/
カレイ /(n) (uk) righteye flounder (any fish of family Pleuronectidae)/
カレイドスコープ /(n) kaleidoscope/
カレカノ /(n) (abbr) boyfriend and girlfriend matters/
カレセン /(n) (uk) younger woman (usu. 20-30 years old) who is physically attracted to mature older men (usu. 50-60 years old)/
カレッジ /(n) college/(P)/
カレッジペーパー /(n) college paper/
カレッジリング /(n) college ring/
カレッジレベル /(n) college level/
カレドニアン /(n) caledonian/
カレハスズメダイ /(n) agile chromis (Chromis agilis)/bronze reef chromis/
カレンシー /(n) currency/(P)/
カレンズ /(n) currants/
カレンダ /(n) (1) calendar/(2) calender (machine for flattening things)/
カレンダー /(n) (1) calendar/(2) calender (machine for flattening things)/(P)/
カレンダープログラム /(n) (comp) calendar program/
カレンダクロック /(n) (comp) calendar clock/
カレンツ /(n) currants/
カレント /(n) current/
カレントイングリッシュ /(n) current English/
カレントディレクトリ /(n) (comp) current directory/
カレントトピックス /(n) current topics/
カレントトランザクション /(n) (comp) current transaction/
カレントドライブ /(n) (comp) current drive/
カレントドレイン /(n) (comp) current drain/
カレントニュース /(n) current news/
カレントプライス /(n) current price/
カレントループ /(n) (comp) current loop/current-loop/
カレントレコード /(n) (comp) current record/
カレン族 [カレンぞく] /(n) Karen (people)/
カローラ /(n) corolla/(P)/
カロス /(n) kaross (cloak made of animal skin)/
カロチノイド /(n) carotenoid/carotinoid/
カロチン /(n) carotene/(P)/
カロテノイド /(n) carotenoid/carotinoid/
カロテン /(n) carotene/
カロメル /(n) calomel/
カロライナ /(n) Carolina/(P)/
カロライナコガラ /(n) (uk) Carolina chickadee (Parus carolinensis)/
カロライナ小雀 [カロライナこがら] /(n) (uk) Carolina chickadee (Parus carolinensis)/
カロリー /(n,adj-no) calorie/(P)/
カロリーオフ /(n) diet (wasei: calorie off)/low calorie/reduced calorie/
カロリーフリー /(n) diet (wasei: calorie free)/no calorie/non-caloric/
カロリメーター /(n) calorimeter/
カロル /(n) carol/
カワイルカ /(n) (uk) river dolphin/
カワウ /(n) (uk) great cormorant (Phalacrocorax carbo)/
カワウソ /(n) (uk) otter (esp. the Japanese river otter, Lutra lutra whiteleyi)/
カワカマス /(n) (uk) pike (esp. the Amur pike, Esox reichertii)/pickerel/
カワガラス /(n) (uk) brown dipper (Cinclus pallasii)/
カワゲラ /(n) (uk) stonefly (any insect of order Plecoptera, esp. those of family Perlidae)/
カワシンジュガイ /(n) (uk) Margaritifera laevis (species of freshwater pearl mussel)/
カワセミ /(n) (1) kingfisher (esp. the common kingfisher, Alcedo atthis)/
カワトンボ /(n) (uk) broad-winged damselfly (of family Calopterygidae)/
カワネズミ /(n) (uk) Japanese water shrew (Chimarrogale platycephala)/
カワバタモロコ /(n) (uk) golden venus chub (Hemigrammocypris rasborella)/
カワヒガイ /(n) (uk) Sarcocheilichthys variegatus variegatus (subspecies of cyprinid)/
カワヒメマス属 [カワヒメマスぞく] /(n) Thymallus (genus of freshwater fish in the salmon family Salmonidae)/
カワムツ /(n) (uk) dark chub (Nipponocypris temminckii)/
カワモズク /(n) (uk) Batrachospermum gelatinosum (species of red alga)/
カワヤツメ /(n) (uk) arctic lamprey (Lethenteron camtschaticum)/
カワヤツメ属 [カワヤツメぞく] /(n) Lethenteron (genus of lamprey in the family Petromyzontidae)/
カワユス /(int) (abbr) cute!/adorable!/
カワラナデシコ /(n) (uk) large pink (Dianthus superbus var. longicalycinus)/
カワラニンジン /(n) (uk) Artemisia apiacea (species of artemisia)/
カワラバト /(n) (uk) rock pigeon (Columba livia)/rock dove/
カワラヒワ /(n) (uk) Oriental greenfinch (Carduelis sinica)/
カワラマツバ /(n) (uk) our lady's bedstraw (Galium verum)/yellow bedstraw/
カワラヨモギ /(n) (uk) capillary artemisia (Artemisia capillaris)/yin-chen wormwood/
カンアオイ /(n) (uk) Asarum nipponicum (species of wild ginger)/
カンカン /(n) can-can (fre: cancan)/(P)/
カンガルー /(n) kangaroo/(P)/
カンガルーネズミ /(n) (uk) kangaroo rat (of North America; any rodent of genus Dipodomys)/
カンガルー鼠 [カンガルーねずみ] /(n) (uk) kangaroo rat (of North America; any rodent of genus Dipodomys)/
カンコる /(v5r) to be in a slump/
カンコロジー /(n) kan ecology (beautifying an area by picking up cans)/
カンザス /(n) Kansas/(P)/
カンジキウサギ /(n) (uk) snowshoe hare/snowshoe rabbit (Lepus americanus)/
カンジタ /(n) candidal vaginitis/
カンジダ症 [カンジダしょう] /(n) candidiasis/
カンジダ膣炎 [カンジダちつえん] /(n) candidal vaginitis/vaginal yeast infection/
カンスト /(n,vs) (abbr) abbr. of counter stop/max value in games (99, 255 and such)/
カンゾウ /(n) hemerocallis/daylily/
カンゾウタケ /(n) (uk) beefsteak fungus (Fistulina hepatica)/beefsteak mushroom/
カンター /(n) canter/
カンタータ /(n) cantata (ita:)/(P)/
カンタービレ /(n) cantabile (in a smooth, singing manner) (ita:)/
カンタム /(n) (comp) Quantum/
カンタリジン /(n) cantharadin (active ingredient of cantharides)/
カンタリス /(n) cantharides (lat: cantharis)/
カンタループ /(n) cantaloupe/
カンタロープ /(n) cantaloupe/
カンチク /(n) (uk) marbled bamboo (Chimonobambusa marmorea)/
カンチレバー /(n,adj-no) cantilever/
カンツォーナ /(n) canzone (ita:)/
カンツォーネ /(n) canzone (ita:)/(P)/
カンツォネッタ /(n) canzonetta (ita:)/
カンテ /(n) border (ger: Kante)/
カンティレバー /(n,adj-no) cantilever/
カンテラ /(n) torch (dut: kandelaar)/
カンディル /(n) candiru (Vandellia spp., esp. Vandellia cirrhosa)/canero/toothpick fish/
カンデラ /(n) candela/
カント /(n) (1) Kant/(2) cant/(P)/
カントカ /(n) (uk) something/something or other/so-and-so/
カントラプラスの星雲説 [カントラプラスのせいうんせつ] /(n) Kant-Laplace nebular hypothesis/
カントリー /(n) country/
カントリーアンドウェスタン /(n) country and western/
カントリーアンドウエスタン /(n) country and western/
カントリーウエア /(n) country wear/
カントリーウオーク /(n) country walk/
カントリーエレベーター /(n) country elevator/
カントリークラブ /(n) country club/
カントリースクール /(n) country school/
カントリーブルース /(n) country blues/
カントリーミュージック /(n) country music/
カントリーリスク /(n) country risk/
カントリーロック /(n) country rock/
カントリコード /(n) (comp) country code/
カントン料理 [カントンりょうり] /(n) Cantonese food/
カンナ掛け [カンナがけ] /(n) (uk) planing (wood)/
カンニング /(n,vs) cheating (wasei: cunning)/(P)/
カンニングペーパー /(n) (1) crib sheet (wasei: cunning paper)/cheat sheet/(2) large sketchbook used during TV filming to notify the cast of special stage direction, relay messages, etc./
カンバス /(n) (1) canvas/(P)/
カンバセーション /(n) conversation/
カンパ /(n,vs) (1) (abbr) fund raising campaign (rus: kampanya)/(2) campaign/(P)/
カンパチ /(n) (uk) greater amberjack (Seriola dumerili)/purplish amberjack/greater yellowtail/
カンパニー /(n) company/(P)/
カンパニーエコノミスト /(n) company economist/
カンパニーペーパー /(n) company paper/
カンパニーマガジン /(n) company magazine/
カンパニーユニオン /(n) company union/
カンパニア /(n,vs) fund-raising campaign (rus: kampanya)/
カンピロバクター /(n) Campylobacter (lat:)/
カンファー /(n) camphor/
カンファレンシング /(n) (comp) conferencing/
カンファレンス /(n) conference/
カンフル /(n) camphor (dut: kamfer)/(P)/
カンフル丁幾 [カンフルチンキ] /(n) tincture of camphor/
カンブリア紀 [カンブリアき] /(n) Cambrian period/
カンブリア系 [カンブリアけい] /(n,adj-no) Cambrian system (i.e. rock layer deposited during the Cambrian period)/
カンブリア爆発 [カンブリアばくはつ] /(n) Cambrian explosion (of life)/
カンブリック /(n) cambric/
カンプトサウルス /(n) camptosaurus (lat:)/
カンペ /(n) (abbr) large sketchbook used during TV filming to notify the cast of special stage direction, relay messages, etc./cue card/
カンペン /(n) metallic pencil box (wasei: can pencil-case)/
カンボジア /(n) (uk) Cambodia/
カンマ /(n) comma/cedilla/
カンマ表示 [カンマひょうじ] /(n) (comp) comma format/
カンムリカイツブリ /(n) (uk) Great Crested Grebe (Podiceps cristatus)/
カンムリベラ /(n) clown coris (Coris aygula)/
カンムリベラ属 [カンムリベラぞく] /(n) Coris (genus of wrasses in the family Labridae)/
カンムリワシ /(n) (uk) crested serpent eagle (Spilornis cheela)/
カンラン /(n) (1) (uk) Chinese white olive (Canarium album)/(2) olive (Olea europea)/
カンランハギ /(n) black-spot surgeonfish (Acanthurus bariene, species of tang found from Mozambique and Maldives to the western Pacific)/roundspot surgeonfish/bariene surgeonfish/eye-spot surgeon/
カンラン石 [カンランせき] /(n) olivine/peridot/
カヴァ /(n,vs) (1) cover (e.g. book)/(2) kava (Piper methysticum)/
カヴァー /(n,vs) (1) cover (e.g. book)/
カ月 [かげつ] /(ctr) (number of) months/(P)/
カ行 [カぎょう] /(n) classification for Japanese verb with the dictionary form ending in "ku"/"ka" column or row of the kana syllabary/
カ行変格活用 [カぎょうへんかくかつよう] /(n) irregular conjugation (inflection, declension) of the verb "kuru"/
カ国 [かこく] /(ctr) counter for countries/
カ国語 [かこくご] /(ctr) counter for languages/
カ氏 [カし] /(n,adj-no) degrees Fahrenheit/
カ氏温度 [カしおんど] /(n) Fahrenheit temperature/degrees Fahrenheit/
カ所 [かしょ] /(n) passage/place/point/part/
カ変 [カへん] /(n) (abbr) irregular conjugation (inflection, declension) of the verb "kuru"/
ガー /(n) gar (any fish of family Lepisosteidae)/garfish/garpike/
ガーガー /(n) quack (sound made by ducks)/braak/
ガーゴイル /(n) gargoyle/
ガースコントロール /(n) girth control/
ガーゼ /(n) gauze (ger: Gaze)/(P)/
ガーター /(n) garter/
ガータースネーク /(n) garter snake/
ガーター編み [ガーターあみ] /(n) garter stitch/
ガーッ /(n) with a grinding noise/
ガーディアン /(n) guardian/(P)/
ガーデニング /(n) gardening/
ガーデン /(n) garden/(P)/
ガーデンスモーカー /(n) garden smoker/
ガーデントラクター /(n) garden tractor/
ガーデンハウス /(n) garden house/
ガーデンパーティー /(n) garden party/
ガード /(n,vs) (1) guard/(n) (2) girder bridge/(P)/
ガードケーブル /(n) guard cable/
ガードナーズバタフライフィッシュ /(n) Gardner's butterflyfish (Chaetodon gardineri)/
ガードバンカー /(n) guard bunker/
ガードバンド /(n) (comp) guard band/
ガードマン /(n) security guard (wasei: guardman)/(P)/
ガードル /(n) girdle/
ガードレール /(n) guardrail/(P)/
ガーナ /(n) Ghana/
ガーナ共和国 [ガーナきょうわこく] /(n) Republic of Ghana/
ガーニッシュ /(n) garnish/(automotive) trim/
ガーネット /(n) garnet/
ガーパイク /(n) garpike (any fish of family Lepisosteidae)/garfish/gar/
ガーベージ /(n) garbage/
ガーベジコレクション /(n) (comp) garbage collection/
ガーベッジ /(n) (comp) garbage/
ガーベッジコレクション /(n) (comp) garbage collection/GC/
ガーベラ /(n) gerbera (lat:)/African daisy/
ガーボロジー /(n) garbology/
ガーメント /(n) garment/
ガーリック /(n) garlic (edible plant, Allium sativum)/
ガーリック・トースト /(n) garlic toast/
ガーリックソルト /(n) garlic salt/
ガーリックトースト /(n) garlic toast/
ガール /(n) girl/(P)/
ガールスカウト /(n) Girl Scouts/
ガールズラブ /(n) (col) comics or novels about female homosexuality (wasei: girls love)/
ガールハント /(n) girl hunt/
ガールフレンド /(n) girl friend/girlfriend/(P)/
ガーン /(int) (m-sl) sound effect for shock (usu. the disappointing kind)/
ガーンジー /(n) guernsey/
ガーンジー島 [ガーンジーとう] /(n) Guernsey (island)/
ガイ /(n) guy/(P)/
ガイア /(n) Gaia/Gaea/Ge/
ガイアナ /(n,adj-no) Guyana/
ガイアナバタフライフィッシュ /(n) French butterflyfish (Prognathodes guyanensis, was Chaetodon guyanensis)/Guyana butterflyfish/
ガイアナ協同共和国 [ガイアナきょうどうきょうわこく] /(n) Co-operative Republic of Guyana/
ガイガーカウンター /(n) Geiger counter/
ガイガーミュラーカウンター /(n) Geiger-Mueller counter/
ガイガーミュラー計数管 [ガイガーミュラーけいすうかん] /(n) Geiger-Mueller counter/
ガイガー計数管 [ガイガーけいすうかん] /(n) Geiger counter/
ガイザービル /(n) (comp) Geyserville/
ガイスト /(n) spirit (ger: Geist)/
ガイダンス /(n) guidance/(P)/
ガイド /(n,vs) tour guide/(P)/
ガイドナンバー /(n) guide number/
ガイドピン /(n) (comp) guide pin/
ガイドピンネジ /(n) (comp) guide pin screw/
ガイドブック /(n) guidebook/
ガイドポスト /(n) guidepost/
ガイドメロディ /(n) guide melody (karaoke melody to help the singer hold the tune)/
ガイドライン /(n) guideline/
ガイヤルド /(n) galliard (fre: gaillarde)/
ガイル /(n) guile/
ガウシアン /(n) Gaussian/(P)/
ガウス /(n) gauss/
ガウスの法則 [ガウスのほうそく] /(n) Gauss's law/
ガウス曲線 [ガウスきょくせん] /(n) Gaussian curve/
ガウス消去 [ガウスしょうきょ] /(n) (comp) Gaussian elimination/
ガウス分布 [ガウスぶんぷ] /(n) Gaussian distribution/normal distribution/
ガウチョ /(n) gaucho/
ガウチョハット /(n) gaucho hat/
ガウチョパンツ /(n) gaucho pants/
ガウチョルック /(n) gaucho look/
ガウン /(n) gown/(P)/
ガオー /(n) roar/sound made by monsters/
ガガイモ /(n) (uk) rough potato (Metaplexis japonica)/
ガガイモ科 [ガガイモか] /(n) milkweed family (Asclepiadaceae)/
ガキ /(n) (1) (uk) brat/kids/(2) (Buddh) preta (hungry ghost)/ghoul/
ガクアジサイ /(n) (uk) Gaku hydrangea/Hydrangea macrophylla/
ガクガク /(adj-na,adv,n,vs) (on-mim) body trembling/teeth clattering/something coming loose/
ガクガクブルブル /(vs) (on-mim) to tremble/to shiver (from stress, fear or panic)/(figuratively) to experience a sense of stress, fear, or panic/
ガクッ /(adv,adv-to) (sound effect for) collapsing/losing strength/slumping/
ガクブル /(vs) (abbr) (on-mim) to tremble/to shiver (from stress, fear or panic)/(figuratively) to experience a sense of stress, fear, or panic/
ガクリ /(adv,adv-to) (sound effect for) collapsing/losing strength/slumping/
ガクルクス /(n) Gacrux (aka Gamma Crucis)/
ガクンガクン /(adv-to,adv) jerkingly/
ガサ /(n) (sl) household search (conducted by the police)/
ガサッ /(adv-to) (on-mim) with a swoosh/at one fell swoop/
ガサ入れ [ガサいれ] /(n,vs) (sl) premises search/household search/
ガザニア /(n) gazania (esp. species Gazania rigens) (lat:)/
ガザミ /(n) (uk) swimming crab (Portunus trituberculatus)/
ガザ地区 [ガザちく] /(n) Gaza Strip/
ガシる /(v5r) to well up/to be overcome with emotion/to be close to tears/
ガシガシ /(adv,adv-to) (on-mim) boisterously/roughly/briskly/(P)/
ガシッ /(adv-to) firmly/
ガシャポン /(n) capsule-toy vending machine/machine-vended capsule toy/
ガシャン /(int) clash/
ガジェット /(n) gadget/(P)/
ガジェットバッグ /(n) gadget bag/
ガス /(n,adj-no) (uk) gas (dut:, eng:)/(P)/
ガスエンジン /(n) gasengine/
ガスカーボン /(n) gas carbon/
ガスクロ /(n) (abbr) gas chromatography/
ガスクロマトグラフ /(n) gas chromatograph/
ガスクロマトグラフィー /(n) gas chromatography/
ガスケット /(n) gasket/
ガスコンロ /(n) gas range/
ガスステーション /(n) gas station/
ガスストーブ /(n) gas stove/gas heater/
ガスタービン /(n) gas turbine/(P)/
ガスタンク /(n) gas tank/gasholder/gasometer/
ガスト /(n) gust/
ガストアルバイター /(n) foreign worker (ger: Gastarbeiter)/(P)/
ガストリン /(n) gastrin/
ガストロ /(n) butterfly kingfish (Gasterochisma melampus)/butterfly tuna/bigscale mackerel/
ガストロカメラ /(n) gastrocamera/
ガストロノーム /(n) gastronome/
ガストロノミー /(n) gastronomy/
ガストロノミスト /(n) gastronomist/
ガストロノミック /(n) gastronomic/
ガスハイドレート /(n) gas hydrates/
ガスバーナー /(n) blowtorch/gas burner/bunsen burner/
ガスパーチョ /(n) gazpacho (spa:)/
ガスパイプ /(n) gas pipe/
ガスパイプライン /(n) gas pipeline/
ガスパチョ /(n) gazpacho (spa:)/
ガスパネル /(n) (comp) plasma panel/gas panel/
ガスヒーポン /(n) gas heat pump/
ガスボイラー /(n) gas boiler/
ガスボンベ /(n) gas cylinder (ger: Gasbombe)/(P)/
ガスマスク /(n) gas mask/(P)/
ガスマット /(n) aluminum-foil burner liner (wasei: gas mat)/
ガスマントル /(n) gas mantle/
ガスメーター /(n) gas meter/
ガスライター /(n) gas lighter/
ガスランプ /(n) gas lamp/
ガスレンジ /(n) gas cooker/gas range/
ガス液 [ガスえき] /(n) gas liquor/
ガス化学工業 [ガスかがくこうぎょう] /(n) gas chemical industry/
ガス壊疽 [ガスえそ] /(n,adj-no) gas gangrene/
ガス管 [ガスかん] /(n) gas pipe/gas tube/
ガス機関 [ガスきかん] /(n) gas engine/
ガス欠 [ガスけつ] /(n) running out of gasoline (petrol)/
ガス交換 [ガスこうかん] /(n) gas exchange/
ガス糸 [ガスいと] /(n) gassed yarn/
ガス室 [ガスしつ] /(n) gas chamber/
ガス銃 [ガスじゅう] /(n) gas gun/tear gas gun/
ガス状 [ガスじょう] /(adj-no) gaseous/gasiform/
ガス状星雲 [ガスじょうせいうん] /(n) gaseous nebula/
ガス状惑星 [ガスじょうわくせい] /(n) gas giant (e.g. Jupiter, Saturn)/gas planet/
ガス栓 [ガスせん] /(n) gas tap/gas cock/
ガス体 [ガスたい] /(n,adj-no) gas/
ガス弾 [ガスだん] /(n) gas bomb/
ガス中毒 [ガスちゅうどく] /(n) gas poisoning/
ガス田 [ガスでん] /(n) gas field/
ガス灯 [ガスとう] /(n) gas light/gas lamp/
ガス燈 [ガスとう] /(oK) (n) gas light/gas lamp/
ガス突出 [ガスとっしゅつ] /(n) outburst of gas/
ガス抜き [ガスぬき] /(n,vs) degassing/gas venting/
ガス分析 [ガスぶんせき] /(n) gas analysis/
ガス放電ディスプレイ [ガスほうでんディスプレイ] /(n) (comp) gas-discharge display/
ガス油 [ガスゆ] /(n) gas oil/
ガス溶接 [ガスようせつ] /(n) gas welding/
ガス冷却炉 [ガスれいきゃくろ] /(n) gas-cooled reactor/
ガス漏れ [ガスもれ] /(n) gas leak/
ガス漏れ警報器 [ガスもれけいほうき] /(n) gas leak sensor/
ガス焜炉 [ガスこんろ] /(n) gas range/
ガセ /(n,pref) fake/lie/nonsense/
ガセネタ /(n) faked information/bogus intelligence/disinformation/
ガゼット /(n) gadget/
ガゼットバック /(n) gadget bag/
ガゼットバッグ /(n) gadget bag/
ガゼル /(n) gazelle/
ガソール /(n) gasohol/(P)/
ガソホール /(n) gasohol/
ガソリン /(n) gasoline/petrol/(P)/
ガソリンエンジン /(n) gasoline engine/petrol engine/
ガソリンカー /(n) gasoline engine car/petrol engine car/
ガソリンスタンド /(n) gas station (wasei: gasoline stand)/petrol station/(P)/
ガソリン車 [ガソリンしゃ] /(n) gasoline-powered vehicle/gasoline automobile/gasoline car/gasoline truck/
ガソリン代 [ガソリンだい] /(n) gasoline (money)/petrol (cost)/
ガタ /(n) gutter/
ガター /(n) gutter/
ガタがくる /(exp,vk) to show one's age (e.g. to start creaking at the joints)/to wear out (e.g. machinery)/
ガタイ /(n) (sl) body build/
ガタガタ /(adj-na,adv,adv-to,vs,adj-no) (on-mim) rattle/clatter/(P)/
ガタゴト /(adv,adv-to) (on-mim) rattling/clattering/
ガチッと /(adv) (on-mim) with a clashing or clanging sound/
ガチャポン /(n) capsule-toy vending machine/machine-vended capsule toy/
ガチャン /(adv-to,n) (on-mim) (with a) slamming noise/(with a) banging noise/(with a) clash/(with a) clank/(with a) bang/
ガチン /(adv-to,n) (on-mim) (with a) slamming noise/(with a) banging noise/(with a) clash/(with a) clank/(with a) bang/
ガチンコ /(n) (sl) competing in earnest (esp. in sumo)/
ガッと /(adv) vigorously/swiftly/
ガッシュ /(n) (1) gash/(2) gush/(3) gouache (fre:)/
ガッタブル /(n) gattable/
ガッツ /(n) guts/(P)/
ガッツポーズ /(n) triumphant pose assumed by an athlete (wasei: guts pose)/(P)/
ガッツリ /(adv) (sl) firmly/plentifully/with all one's might/
ガット /(n) (1) gut (i.e. used to make violin strings)/catgut/(2) grand unified theory/GUT/(P)/
ガットギター /(n) gut guitar/
ガツ /(n) (food) stomach (esp. a pig's stomach or a cow's rumen)/pork stomach/
ガツガツ /(adv,n,vs) (on-mim) greedily/burning with desire for something/
ガツン /(n) (1) klop/klunk/whonk/(adv,adv-to) (2) with a heavy impact/forcibly/
ガトー /(n) gateau (fre:)/
ガトリングガン /(n) Gatling gun/
ガトリング銃 [ガトリングじゅう] /(n) Gatling gun/
ガトリング砲 [ガトリングほう] /(n) Gatling gun/
ガドリニウム /(n) gadolinium (Gd)/
ガナッシュ /(n) ganache (icing made of mixed chocolate and cream) (fre:)/
ガニメデ /(n) Ganymede (moon of Jupiter)/
ガバージン /(n) gaberdine/gabardine/
ガバナー /(n) governor/
ガバナビリティー /(n) governability/
ガバナンス /(n) governance/
ガバメント /(n) government/
ガビーン /(int) (m-sl) indicates shock and disappointment (not actually said out loud)/
ガビアル /(n) gharial (fre:)/gavial (large crocodilian found on the Indian subcontinent)/
ガベージインガベージアウト /(n) (comp) garbage in, garbage out/
ガベジ /(n) (comp) garbage/
ガベジコレクション /(n) (comp) garbage collection/
ガボット /(n) gavotte (fre:)/(P)/
ガボン /(n) Gabon/
ガボン共和国 [ガボンきょうわこく] /(n) Gabonese Republic/
ガマアンコウ /(n) (uk) toadfish (any fish of family Batrachoididae, esp. the Pacuma toadfish, Batrachoides surinamensis)/
ガマズミ /(n) (uk) linden arrowwood (Viburnum dilatatum)/Japanese bush cranberry/
ガム /(n) chewing gum/(P)/
ガムシロップ /(n) gum syrup/
ガムテ /(n) (abbr) packing tape (wasei: gum tape)/
ガムテープ /(n) packing tape (wasei: gum tape)/
ガムドロップ /(n) gumdrop/
ガムボ /(n) gumbo/
ガムラン /(n) gamelan (traditional Indonesian music ensemble) (ind:)/
ガメ /(n) Gamay (variety of grape)/
ガメる /(v1,vt) (1) to greedily try to win big (e.g. in mahjong)/(2) to swipe/to nick/to pilfer/
ガメイ /(n) Gamay (variety of grape)/
ガメラン /(n) gamelan (traditional Indonesian music ensemble) (ind:)/(P)/
ガヤ /(n) background chatter on a soundtrack/
ガラ・ルファ /(n) doctor fish (Garra rufa)/nibble fish/kangal fish/reddish log sucker/
ガラガラヘビ /(n) (uk) rattlesnake/
ガラガラ抽選 [ガラガラちゅうせん] /(n) tombola/raffle drum/
ガラクトース /(n) galactose/
ガラクトース血症 [ガラクトースけっしょう] /(n) galactosemia/
ガラコンサート /(n) gala concert/
ガラゴ /(n) galago/
ガラス /(n) (uk) glass (dut: glas)/pane/(P)/
ガラスウール /(n) glass wool/
ガラスブロック /(n) glass block/
ガラス絵 [ガラスえ] /(n) picture painted on glass/stained glass/
ガラス球 [ガラスだま] /(n) glass sphere/glass bead/glass marble/
ガラス玉 [ガラスだま] /(n) glass sphere/glass bead/glass marble/
ガラス固化 [ガラスこか] /(n) vitrification/
ガラス戸 [ガラスど] /(n) glass door/(P)/
ガラス工芸 [ガラスこうげい] /(n) glasswork/
ガラス細工 [ガラスざいく] /(n) glasswork/
ガラス障子 [ガラスしょうじ] /(n) glazed sliding door/
ガラス切り [ガラスきり] /(n) glass cutter/
ガラス繊維 [ガラスせんい] /(n) glass fiber/glass fibre/
ガラス窓 [ガラスまど] /(n) glass window/
ガラス体 [ガラスたい] /(n) vitreous body (of the eye)/
ガラス張り [ガラスばり] /(n,adj-no) glass-sided/aboveboard/open to scrutiny/(P)/
ガラス片 [ガラスへん] /(n) splinters of glass/glass shards/
ガラス綿 [ガラスめん] /(n) glass wool/
ガラス壺 [ガラスつぼ] /(n) glass jar/
ガラテヤの信徒への手紙 [ガラテヤのしんとへのてがみ] /(n) Epistle to the Galatians (book of the Bible)/
ガラテヤ書 [ガラテヤしょ] /(n) (obsc) Epistle to the Galatians (book of the Bible)/
ガラテヤ人への手紙 [ガラテヤじんへのてがみ] /(n) Epistle to the Galatians (book of the Bible)/
ガラナ /(n) (1) guarana (tree)/Paullinia cupana/(2) guarana (seed extract as an ingredient used in stamina drinks and foods for restorative and stimulant effect)/
ガラパゴスザメ /(n) Galapagos shark (Carcharhinus galapagensis, species of circumtropical requiem shark found in the reef environments around oceanic islands)/
ガラパゴスゾウガメ /(n) (uk) Galapagos tortoise (Geochelone nigra)/
ガラパゴスネコザメ /(n) Galapagos bullhead shark (Heterodontus quoyi)/
ガラパゴスリクイグアナ /(n) (uk) Galapagos land iguana (Conolophus subcristatus)/
ガラパゴスリングテールダムセルフィッシュ /(n) Southern whitetail major (Stegastes beebei)/Galapagos ringtail damselfish/
ガラパゴス小羽鵜 [ガラパゴスこばねう] /(n) flightless cormorant/Galapagos cormorant/
ガラパゴス象亀 [ガラパゴスぞうがめ] /(n) (uk) Galapagos tortoise (Geochelone nigra)/
ガラパゴス陸イグアナ [ガラパゴスりくイグアナ] /(n) (uk) Galapagos land iguana (Conolophus subcristatus)/
ガラムマサラ /(n) garam masala (hin:)/
ガラルファ /(n) doctor fish (Garra rufa)/nibble fish/kangal fish/reddish log sucker/
ガランタミン /(n) galanthamine/
ガランティン /(n) galantine/
ガリ /(n) (1) gully/
ガリ /(n) sliced ginger prepared in vinegar (served with sushi)/pickled ginger/
ガリー /(n) (1) gully/(2) galley/
ガリア /(n) Gaul (lat: Gallia)/
ガリア戦記 [ガリアせんき] /(n) History of the Gallic Wars/
ガリウム /(n,adj-no) gallium (Ga)/(P)/
ガリウムひ素半導体 [ガリウムひそはんどうたい] /(n) gallium arsenide semiconductor/
ガリウムヒ素 [ガリウムヒそ] /(n) gallium arsenide (GaAs)/
ガリウム砒素 [ガリウムひそ] /(n) gallium arsenide (GaAs)/
ガリウム砒素リン [ガリウムひそリン] /(n) (comp) Gallium Arsenide Phosphide/GaAsP/
ガリウム砒素半導体 [ガリウムひそはんどうたい] /(n) gallium arsenide semiconductor/
ガリガリ /(adj-na,n) (1) (uk) skin and bones/appearing to be underweight/(adv) (2) with a grinding, crunching, scratching (sound)/(3) desperately/recklessly/(adj-no) (4) crunchy hardness/(5) selfishness/selfish person/
ガリセン /(n) person physically attracted to thin people/
ガリバー /(n) (1) Gulliver/(2) preeminent example of its kind/(P)/
ガリバー商品 [ガリバーしょうひん] /(n) outstanding product/market leader/
ガリバルディ /(n) Garibaldi damselfish (Hypsypops rubicundus, damselfish found from Monterey Bay California to Guadalupe Island Baja California)/official state marine fish of California/
ガリレイ衛星 [ガリレイえいせい] /(n) Galilean satellites/
ガリレイ式望遠鏡 [ガリレイしきぼうえんきょう] /(n) Galilean telescope/
ガリレオ /(n) Galileo/(P)/
ガリレオ衛星 [ガリレオえいせい] /(n) Galilean satellites/
ガル /(n) gal (unit of gravitational acceleration)/
ガルソン /(n) (1) boy/(2) male waiter (fre: garcon)/
ガルソンヌ /(n) boyish girl (fre: garconne)/
ガルニ /(n) (abbr) garniture (fre:)/
ガルニチュール /(n) garniture/
ガルバノメーター /(n) galvanometer/
ガルバンソ /(n) garbanzo (spa:)/
ガルフサージャンフィッシュ /(n) Gulf surgeonfish (Acanthurus randalli, species of tang found in Florida and northeastern Gulf of Mexico)/
ガルフサージョンフィッシュ /(n) Gulf surgeonfish (Acanthurus randalli, species of tang found in Florida and northeastern Gulf of Mexico)/
ガレー /(n) galley/
ガレージ /(n) garage (at house)/(P)/
ガレージキット /(n) small scale production model kit (e.g. for figurines) (wasei: garage kit)/
ガレージセール /(n) garage sale/
ガレオン /(n) galleon/
ガレキ /(n) (abbr) small scale production model kit (e.g. for figurines)/
ガレリー /(n) gallery/
ガロア理論 [ガロアりろん] /(n) Galois theory/
ガロップ /(n) (1) galop (dance)/
ガロン /(n) gallon/(P)/
ガロン瓶 [ガロンびん] /(n) gallon bottle/three litre glass bottle used for pharmaceuticals/
ガン /(n) gun/(P)/
ガンガン /(adv,vs) (col) (on-mim) sound of large bell/sound of scolding voice/(pounding of) headache/intense/(P)/
ガンガン食べる [ガンガンたべる] /(exp,v1) (sl) to pig out/to chow down/
ガンギエイ /(n) (uk) skate (Rajinidae spp., esp. the Kwangtung skate, Dipturus kwangtungensis)/
ガンギレ /(n,vs) (sl) losing one's cool/blowing one's top/
ガンクラブチェック /(n) gunclub check/
ガンクロ /(n) darkly tanned face (fashionable among trendy young people ca. 1999-2000)/
ガングリオシド /(n) ganglioside/
ガングリオン /(n) ganglion/
ガンシクロビル /(n) ganciclovir/
ガンショップ /(n) gun shop/
ガンジスメジロザメ /(n) Ganges shark (Glyphis gangeticus, rare species of fresh water requiem shark that dwells in the rivers of India)/
ガンジスメジロザメ属 [ガンジスメジロザメぞく] /(n) Glyphis (genus containing 5 known species of secretive true river sharks in the family Carcharhinidae)/
ガンディー /(n) Ghandi/
ガントチャート /(n) Gantt chart/
ガントリークレーン /(n) gantry crane/
ガントレット /(n) gauntlet/
ガンナー /(n) gunner/
ガンニー /(n) gunny/
ガンバリズム /(n) attitude that one must keep going no matter what (wasei: gambarism)/
ガンビール /(n) gambir (species of climbing plant, Uncaria gambir) (dut:)/gambier/
ガンビア共和国 [ガンビアきょうわこく] /(n) Republic of the Gambia/
ガンビア川 [ガンビアがわ] /(n) Gambia/
ガンピ /(n) (1) (uk) Diplomorpha sikokiana (species of flowering plant)/(2) (abbr) paper made from the fibre of this plant/
ガンピ /(n) (uk) Lychnis coronata/
ガンファイター /(n) gunfighter/
ガンファイト /(n) gunfight/
ガンブー /(adj-na) (1) (derog) (sl) ugly mug/(n) (2) gambuh (Balinese traditional dance)/
ガンプラ /(n) (abbr) Gundam plastic models/
ガンベルト /(n) gun belt/
ガンボ /(n) gumbo/okra/
ガンボージ /(n) gamboge/
ガンボージの木 [ガンボージのき] /(n) (obsc) gamboge tree/
ガンマアミノ酪酸 [ガンマアミノらくさん] /(n) gamma-aminobutyric acid (GABA)/
ガンマイク /(n) (comp) shotgun microphone/
ガンマグロブリン /(n) gamma globulin/
ガンマニア /(n) gun mania/
ガンマフィールド /(n) gamma field/
ガンマランプ /(n) (comp) gamma ramp/
ガンマン /(n) gunman/
ガンマ線 [ガンマせん] /(n,adj-no) gamma rays/
ガンマ補正 [ガンマほせい] /(n) (comp) gamma correction/
ガンマ崩壊 [ガンマほうかい] /(n) gamma decay/
ガンメタル /(n) gunmetal/
ガン見 [ガンみ] /(n,vs) (sl) glaring look/giving the stink eye/
ガン告知 [ガンこくち] /(n) cancer notification/
ガン寝 [ガンね] /(n) fast asleep/bombed/crashed/
ガン切れ [ガンぎれ] /(n,vs) (sl) losing one's cool/blowing one's top/
ガ行 [ガぎょう] /(n) classification for Japanese verb with the dictionary form ending in "gu"/"ga" column or row of the kana syllabary/
ガ目 [ガもく] /(n) Lepidoptera/
キー /(n) (1) key/(2) long squealing sound/(P)/
キーアサイン /(n) (comp) key assign/
キーアドバイザー /(n) key advisor/key adviser/
キーイン /(n) (comp) key in/
キーインダストリー /(n) key industry/
キーウィ /(n) (1) kiwi/(2) kiwi fruit/
キーウィー /(n) (1) kiwi/(2) kiwi fruit/
キーウェブクリエイタ /(n) (comp) KeyWeb Creater/
キーエスキューエル /(n) (comp) KeySQL/
キーエスクロー /(n) (comp) key escrow/
キーカスタマイズ /(n) (comp) key customize/
キーカレンシー /(n) key currency/
キーキー /(adv) (on-mim) creak/squeak/
キークラブ /(n) key club/
キーコード /(n) (comp) key code/
キーシム /(n) keysym/key-symbol/
キーステーション /(n) key station/(P)/
キーストーン /(n) keystone/
キーストーンコンビ /(n) (abbr) keystone combination/
キーストーンコンビネーション /(n) keystone combination/
キーストローク /(n) (comp) key-stroke/
キーセン /(n) Korean female entertainer (kor: gi-saeng)/
キータイトル /(n) (comp) key title/
キータッチ /(n) (comp) key-touch/
キーテクノロジー /(n) (comp) key technology/
キーディスク /(n) (comp) key disk/
キートップ /(n) (comp) keytop/
キーノー /(n) keno/
キーノート /(n) keynote/
キーバインド /(n) (comp) key binding/
キーバッファ /(n) (comp) key buffer/
キーパー /(n) keeper/(P)/
キーパーソン /(n) key person/
キーパーチャージ /(n) keeper charge/
キーパッド /(n) (comp) keypad/
キーパンチ /(n) key punch/
キーパンチャー /(n) key puncher/
キーパンチヤー /(n) keypuncher/
キーフィーチャ /(n) (comp) key feature/
キーフィールド /(n) (comp) key field/
キーフレーム /(n) (comp) key frame/
キープ /(n,vs) (1) keep/(n) (2) quipu/quippu/(P)/
キープアライブ /(n) (comp) keep-alive/
キープアライブメッセージ /(n) (comp) keep alive message/
キープサンプル /(n) reference sample (wasei: keep sample)/
キープボットル /(n) bottle of whiskey (whisky) that a bar customer buys, writes his name on, keeps on a shelf at the bar, and drinks little by little on successive visits (wasei: keep bottle)/
キーベッド /(n) key bed/
キーホール /(n) keyhole/
キーホールジャーナリズム /(n) keyhole journalism/
キーホルダー /(n) (1) key chain (wasei: key holder)/(2) key ring (encryption)/(P)/
キーボード /(n) keyboard/(P)/
キーボードのデザイン /(n) (comp) keyboard design/
キーボードの配置 [キーボードのはいち] /(n) (comp) keyboard layout/
キーボードエンハンサ /(n) (comp) keyboard enhancer/
キーボードショートカット /(n) (comp) keyboard shortcut/
キーボードテンプレート /(n) (comp) keyboard template/
キーボードバッファ /(n) (comp) keyboard buffer/
キーボードパスワード /(n) (comp) keyboard password/
キーボードプログラム入力式計算器 [キーボードプログラムにゅうりょくしきけいさんき] /(n) (comp) calculator with keyboard program input/
キーボードヘルプ /(n) (comp) keyboard help/
キーボードマクロ /(n) (comp) keyboard macro/
キーボードリセット /(n) (comp) keyboard reset/
キーボードロック /(n) (comp) keyboard lock/
キーボード及び外部プログラム入力式計算器 [キーボードおよびがいぶプログラムにゅうりょくしきけいさんき] /(n) (comp) calculator with keyboard and external program input/
キーボード制御式のアドレス指定可能な記憶域をもつ計算器 [キーボードせいぎょしきのアドレスしていかのうなきおくいきをもつけいさんき] /(exp) (comp) calculator with keyboard controlled addressable storage/
キーボード制御装置 [キーボードせいぎょそうち] /(n) (comp) keyboard controller/
キーボード入力 [キーボードにゅうりょく] /(n) (comp) keyboard input/
キーポイント /(n) key point/the key/(P)/
キーマーケット /(n) key market/
キーマクロ /(n) (comp) key macro/
キーマップ /(n) key-map/
キーマン /(n) keyman/(P)/
キーライト /(n) key light/
キーリカバリー /(n) (comp) key recovery/
キーリピート /(n) (comp) key repeat/
キーリング /(n) (comp) key ring (encryption)/
キール /(n) keel/(P)/
キーレスエントリー /(n) keyless entry/
キーレセプタクル /(n) (comp) key receptacle/
キーロガー /(n) (comp) software used to note content typed (typically to steal passwords) (wasei: key logger)/
キーワード /(n) keyword/buzzword/catch-phrase/(P)/
キーワードサーチ /(n) (comp) keyword search/
キーワード検索 [キーワードけんさく] /(n) (comp) keyword search/
キーンコーンカーンコーン /(n) bing-bong bang-bong (Big Ben chimes, used as a bell in Japanese schools)/
キー割り当て [キーわりあて] /(n) (comp) key assignment/
キー割当 [キーわりあて] /(n) (comp) key assignment/
キー局 [キーきょく] /(n) key station/
キー候補 [キーこうほ] /(n) (comp) candidate key/
キー順データセット [キーじゅんデータセット] /(n) (comp) KSDS/Key-Sequenced Data Set/
キー照合 [キーしょうごう] /(n) (comp) key matching/
キー入力 [キーにゅうりょく] /(n) (comp) key (input)/
キー入力検証 [キーにゅうりょくけんしょう] /(n) (comp) keystroke verification/
キー入力待ち [キーにゅうりょくまち] /(n) (comp) waiting for key-in/
キアイ /(n) (1) (uk) anil indigo (Indigofera suffruticosa)/(2) (uk) Assam indigo (Strobilanthes cusia)/
キアシシギ /(n) (uk) grey-tailed tattler (species of sandpiper, Heteroscelus brevipes)/
キアズマ /(n) chiasma/chiasmata/
キアロスクーロ /(n) chiaroscuro (ita:)/
キィキィ /(adv) (on-mim) creak/squeak/
キイキイ /(adv) (on-mim) creak/squeak/
キイチゴ /(n) (uk) raspberry (any plant of genus Rubus, esp. Rubus palmatus var. coptophyllus)/
キイロオオトカゲ /(n) yellow monitor (Varanus flavescens, species of asian carnivorous monitor lizard found in India, Pakistan, Nepal and Bangladesh)/
キイロショウジョウバエ /(n) (uk) Drosophila melanogaster (species of fruit fly)/
キイロスズメバチ /(n) (uk) yellow hornet (Vespa simillima xanthoptera, subspecies of the Japanese hornet, Vespa simillima)/
キイロハギ /(n) yellow tang (Zebrasoma flavescens, species of Pacific tang)/
キウィ /(n) (1) kiwi/(2) kiwi fruit/
キウイ /(n) (1) kiwi/(2) kiwi fruit/(P)/
キウイフルーツ /(n) kiwi fruit/
キオスク /(n) kiosk/(P)/
キオスクモード /(n) (comp) KIOSK mode/
キオスズメダイ /(n) sunshinefish (Chromis insolata)/olive chromis/
キオビスズメダイ /(n) whitebar gregory (Stegastes albifasciatus)/
キオビホオナガスズメバチ /(n) (uk) median wasp (Dolichovespula media)/
キクイタダキ /(n) (uk) goldcrest (species of passerine bird, Regulus regulus)/
キクイムシ /(n) (1) (uk) bark beetle (Scolytidae spp.)/(2) gribble (Limnoria lignorum)/
キクイモ /(n) (uk) Jerusalem artichoke (Helianthus tuberosus)/topinambur/girasol/girasole/
キクヂシャ /(n) (uk) endive (Cichorium endivia)/escarole/
キク科 [キクか] /(n) (uk) Asteraceae, Compositae (plant family)/aster family/daisy family/sunflower family/
キケロ /(n) Cicero/
キササゲ /(n) (uk) yellow catalpa (Catalpa ovata)/Chinese catalpa/
キサンチン /(n) xanthine/
キサントフィル /(n) xanthophyll/
キシャヤスデ /(n) (uk) Parafontaria laminata (species of millipede)/
キシュ /(n) quiche (fre:)/
キショイ /(adj-f) (sl) feel sick/(something is) weird/
キシラン /(n) xylan/
キシリトール /(n) xylitol (artificial sweetener)/artificial wood sugar (xylose)/
キシリトル /(n) xylitol (artificial sweetener)/artificial wood sugar (xylose)/
キシレン /(n) xylene/
キシロース /(n) xylose/
キシロール /(n) xylol/
キジ /(n) (uk) green pheasant (Phasianus versicolor)/Japanese pheasant/
キジカクシ /(n) (uk) Asparagus schoberioides/
キジハタ /(n) (uk) red-spotted grouper (species of fish, Epinephelus akaara)/Hong Kong grouper/
キジバト /(n) (uk) Oriental turtle dove (Streptopelia orientalis)/eastern turtle dove/rufous turtledove/
キジラミ /(n) (uk) psylla (any insect of family Psyllidae)/psyllid/jumping plant louse/
キジ科 [キジか] /(n) Phasianidae (pheasant family of birds)/
キジ目 [キジもく] /(n) Galliformes (galliform order of birds)/
キス /(n) (uk) sillago (any fish of genus Sillago, esp. the Japanese whiting, Sillago japonica)/
キス /(n,vs) kiss/(P)/
キスアンドライド /(n) kiss-and-ride/dropping family member off at a station/
キスカール /(n) kiss curl/spit curl/
キスシーン /(n) kiss scene/
キスジアカボウ /(n) Polylepion russelli (species of wrasse)/
キスジゲンロクダイ /(n) goldengirdled coralfish (Coradion chrysozonus)/orangebanded coralfish/
キスマーク /(n) (1) lipstick mark (wasei: kiss mark)/(2) love bite/hickey/passion mark/
キズイセン /(n) (uk) jonquil (Narcissus jonquilla)/
キセキレイ /(n) (uk) grey wagtail (Motacilla cinerea)/gray wagtail/
キセニア /(n) xenia/
キセノン /(n) xenon (Xe)/
キセノンアークランプ /(n) Xenon arc lamp/
キセノンランプ /(n) Xenon lamp/
キセル /(n) (1) (tobacco) pipe with metal tipped stem (khm: khsier)/(2) stolen train ride (only paying a local fare each end)/
キタカワヒメマス /(n) Arctic grayling (Thymallus arcticus arcticus)/
キタキツネ /(n) Ezo red fox (Vulpes vulpes schrencki)/
キタタキ /(n) (uk) white-bellied woodpecker (Dryocopus javensis)/
キタテハ /(n) (uk) Asian comma butterfly (Polygonia c-aureum)/
キタマクラ /(n) (1) lying with one's head to the north (trad. position for dead bodies; taboo for sleeping)/(2) (uk) brown-lined puffer (species of pufferfish, Canthigaster rivulata)/
キタラ /(n) kithara (ancient Greek musical instrument) (gre:)/cithara/
キタリス /(n) (uk) red squirrel (Sciurus vulgaris)/
キダイ /(n) (uk) yellowback sea bream (Dentex tumifrons)/
キダチヒャクリコウ /(n) (obsc) thyme/
キチ /(n-suf) (sl) mania/enthusiasm/maniac/enthusiast/nut/
キチキチ /(adj-na,adv-to,n) (1) (on-mim) jam-packed (physically or of schedule, etc.)/(2) (used to denote a) grinding noise/(3) precisely/correctly (e.g. when working, etc.)/(n) (4) acrida cinerea/oriental longheaded locust/
キチキチバッタ /(n) (1) (uk) (col) male Oriental longheaded locust (Acrida cinerea)/(2) (obs) Gonista bicolor (species of grasshopper resembling the Oriental longheaded locust)/
キチジ /(n) (uk) broadbanded thornyhead/broadfin thornyhead/kichiji rockfish (Sebastolobus macrochir)/
キチョウ /(n) (1) (uk) large grass yellow (species of butterfly, Eurema hecabe)/common grass yellow/(2) yellow butterfly/
キチン /(n) (1) kitchen/(2) chitin/
キチンのサイクル /(n) Kitchin cycle/
キッカー /(n) kicker (soccer, football, rugby, etc.)/
キック /(n,vs) kick/(P)/
キックアウト /(n) kickout/
キックアンドラッシュ /(n) kick and rush/
キックオフ /(n) kickoff/(P)/
キックスターター /(n) kick starter/
キックステップ /(n) kick step (mountaineering technique)/
キックターン /(n) kick turn/
キックドラム /(n) kick drum/
キックバック /(n) kickback/
キックボール /(n) kickball/
キックボクシング /(n) kickboxing/kick-boxing/(P)/
キッシュ /(n) quiche (fre:)/
キッシング・グラミー /(n) kissing gourami (Helostoma temmincki)/kissing fish/
キッシンググラミー /(n) kissing gourami (Helostoma temmincki)/kissing fish/
キッス /(n,vs) kiss/
キッズ /(n) kids/children/
キッズカフェ /(n) restaurant with a play area for children (wasei: kids' cafe)/
キッズビジネス /(n) kids' business/(P)/
キッズルーム /(n) kids' room/
キッチュ /(adj-na,n) kitsch (ger:)/
キッチン /(n) (1) kitchen/(P)/
キッチンウエア /(n) kitchenware/
キッチンキャビネット /(n) kitchen cabinet/
キッチンドリンカー /(n) kitchen drinker/
キッチンプログラマー /(n) kitchen programmer/
キッチンペーパー /(n) paper towel (wasei: kitchen paper)/
キット /(n) kit/(P)/
キッド /(n) kid/(P)/
キッパー /(n) kipper (i.e. kippered fish)/
キップ /(n) kip/(P)/
キツツキ /(n) (uk) woodpecker/
キツネ /(n) (1) fox (esp. the red fox, Vulpes vulpes)/(2) fox (i.e. a sly person)/(3) soba or udon topped with deep-fried tofu/(4) (abbr) light brown/
キツネザル /(n) (uk) lemur/
キツネダイ /(n) Bodianus oxycephalus (species of hogfish)/
キツネナス /(n) (uk) nipplefruit (Solanum mammosum)/apple of Sodom/titty fruit/cow's udder/
キツネベラ /(n) Hawaiian hogfish (Bodianus albotaeniatus)/tarry hogfish (Bodianus bilunulatus)/saddleback hogfish (Bodianus bilunulatus)/
キツネホシザメ /(n) smalleye smooth-hound (Mustelus higmani, species of houndshark from the western Atlantic)/
キヅタ /(n) (uk) Hedera rhombea (species of ivy)/
キテレツ /(adj-na,n) very strange/odd/queer/
キディ /(n) kiddie/kiddy/
キディー /(n) kiddie/kiddy/
キトン /(n) chiton (gre:)/
キドニー /(n) kidney/
キドニーパイ /(n) kidney-pie/
キドニーパンチ /(n) (obsc) kidney punch/
キナーゼ /(n) kinase/
キナクリン /(n) quinacrine (antimalarial)/
キナプリル /(n) quinapril/
キナ皮 [キナひ] /(n) cinchona bark/
キニーネ /(n) quinine (dut: kinine)/
キニク学派 [キニクがくは] /(n) Cynic school (of philosophy)/
キニジン /(n) quinidine/
キニン /(n) quinine/
キヌゲネズミ /(n) (uk) (obsc) hamster (any rodent of subfamily Cricetinae)/
キヌザル /(n) (uk) (obsc) common marmoset (Callithrix (Callithrix) jacchus)/
キヌヒカリ /(n) Kinuhikari (variety of rice)/
キヌベラ /(n) surge wrasse (Thalassoma purpureum)/
キネシオロジー /(n) kinesiology/(P)/
キネシクス /(n) kinesics/
キネスコープ /(n) kinescope/
キネチン /(n) kinetin/
キネティックアート /(n) kinetic art/
キネトスコープ /(n) kinetoscope/
キネマ /(n) (abbr) kinema/
キネマトグラフ /(n) kinematograph/
キノア /(n) quinoa/
キノコ /(n) mushroom/(P)/
キノドン類 [キノドンるい] /(n) cynodonts/
キノノゲシ /(n) Indian lettuce (Lactuca indica)/
キノホルム /(n) chinoform/(P)/
キノボリウオ /(n) (uk) climbing perch (esp. of genus Anabas)/
キノボリウオ亜目 [キノボリウオあもく] /(n) Anabantoidei (suborder of the order Perciformes known as labyrinth fish that are defined by having an accessory breathing organ for respiration in air)/
キノボリトカゲ /(n) (uk) Ryukyu tree lizard (Japalura polygonata)/
キノリン /(n) quinoline/
キノン /(n) quinone/
キハギ /(n) (uk) Lespedeza buergeri (species of bush clover)/
キハダ /(n) (uk) Amur cork tree (Phellodendron amurense)/
キハダ /(n) (uk) yellowfin tuna (Thunnus albacares)/
キハダマグロ /(n) (uk) yellowfin tuna (Thunnus albacares)/
キハチス /(n) (uk) rose of Sharon (Hibiscus syriacus)/
キバウミニナ /(n) (uk) mud creeper (Terebralia palustris)/
キバシヒワ /(n) (uk) twite (species of finch, Carduelis flavirostris)/
キバシリ /(n) (uk) common treecreeper (species of songbird, Certhia familiaris)/
キバソフト /(n) (comp) KIVASOFT/
キビ /(n) (uk) (common) millet (Panicum miliaceium)/proso millet/
キビタキ /(n) (uk) narcissus flycatcher (Ficedula narcissina)/
キビナゴ /(n) (uk) silver-stripe round herring (Spratelloides gracilis)/
キビレボウズハギ /(n) slender unicorn (Naso minor, species of Indo-West Pacific tang found from Mozambique to the Philippines)/blackspine unicornfish/little unicorn/
キブアンドテーク /(exp) give-and-take/
キブシ /(n) early spiketail (species of flowering plant, Stachyurus praecox)/
キブツ /(n) kibbutz/
キプロス /(n) Cyprus/
キヘリキンチャクダイ /(n) black-velvet angelfish (Chaetodontoplus melanosoma)/
キホシスズメダイ /(n) yellow-spotted chromis (Chromis flavomaculata)/
キホシヤッコ /(n) French angelfish (Pomacanthus paru)/
キボシマルトビムシ /(n) (uk) garden springtail (Bourletiella hortensis)/
キボンヌ /(n) (sl) hope/wish/aspiration/
キマイラ /(n) (1) chimera (mythological)/chimaera/
キマメ /(n) (uk) pigeon pea (Cajanus cajan)/
キミミダレミツスイ /(n) (uk) yellow wattlebird (Anthochaera paradoxa)/
キムタク /(n) (abbr) Kimura Takuya/
キムラグモ /(n) (uk) Heptathela kimurai (species of burrowing spider)/
キメラ /(n) (1) chimera (mythological)/chimaera/(2) chimera (biological)/chimaera/(P)/
キメラマウス /(n) chimeric mouse/
キメ顔 [キメがお] /(n) (sl) posed look (sexy face, etc.)/
キモい /(adj-i) (sl) (abbr) gross/disgusting/
キモカワイイ /(adj-f) (sl) (col) being both repellant and attractive at the same time/being both cute and disgusting/
キモグラフ /(n) kymograph/
キモシン /(n) chymosin/
キモトリプシン /(n) chymotrypsin/
キモメン /(n) (sl) repulsive man/
キモ可愛い [キモかわいい] /(adj-f) (sl) (col) being both repellant and attractive at the same time/being both cute and disgusting/
キャスク /(n) cask/
キャスター /(n) (1) caster/(2) (abbr) newscaster/(P)/
キャスターバッグ /(n) roller bag (wasei: caster bag)/wheelie bag/
キャスチング /(n) casting/
キャスチングボート /(n) casting vote/
キャスチングリール /(n) casting reel/
キャスティング /(n) casting/(P)/
キャスティングボート /(n) casting vote/
キャステリャ /(n) Castilian/
キャスト /(n,vs) cast/(P)/
キャスリング /(n) castling/
キャセイ /(n) Cathay (Airline)/(P)/
キャセロール /(n) casserole (fre:)/
キャタストロフィ /(n) catastrophe/
キャタピラ /(n) caterpillar/endless track/
キャタピラー /(n) caterpillar/endless track/(P)/
キャッ /(int) shriek/scream/
キャッサバ /(n) cassava (Manihot esculenta)/manioc/tapioca/
キャッシャー /(n) cashier/
キャッシュ /(n) (1) cache/(2) cash/(P)/
キャッシュオンデリバリー /(n) cash on delivery/COD/
キャッシュカード /(n) cash card/ATM card/(P)/
キャッシュコーナ /(n) (comp) automatic teller machine/
キャッシュコントローラ /(n) (comp) cache controller/
キャッシュサービスコーナー /(n) automatic teller machine (wasei: cash-service corner)/ATM/flexi-teller/hole-in-the-wall/
キャッシュディスク /(n) (comp) cache disk/
キャッシュディスペンサ /(n) cash dispenser/
キャッシュディスペンサー /(n) cash dispenser/
キャッシュバック /(n) cash-back/rebate/
キャッシュファイル /(n) (comp) cache file/
キャッシュフロー /(n) cash flow/
キャッシュブック /(n) cashbook/
キャッシュプラグイン /(n) (comp) cache plug-in/
キャッシュベルト /(n) money belt (wasei: cash belt)/
キャッシュボックス /(n) cashbox/
キャッシュマシン /(n) cash machine/automatic teller machine/
キャッシュメモリ /(n) (comp) cache memory/
キャッシュメモリー /(n) (comp) cache memory/
キャッシュメモリ機構 [キャッシュメモリきこう] /(n) (comp) cache memory organization/
キャッシュライタ /(n) (comp) cache writer/
キャッシュレジスター /(n) cash register/
キャッシュレス /(adj-f) cashless/
キャッシュレスシステム /(n) cashless system/
キャッシュレスソサイティー /(n) cashless society/
キャッシュレスチェックレスソサイティ /(n) cashless checkless society (chequeless)/
キャッシュレス社会 [キャッシュレスしゃかい] /(n) cashless society/
キャッシュ記憶装置 [キャッシュきおくそうち] /(n) (comp) cache storage/
キャッシング /(n) (1) caching/(2) cashing/(3) taking out small loans/(P)/
キャッスル /(n) (1) castle/(2) (comp) Compact Application Solution Language/CASL/
キャッチ /(n,vs) catch/(P)/
キャッチー /(adj-na) catchy/
キャッチアップ /(n) catch-up/
キャッチアンドリリース /(n) catch and release (fishing)/
キャッチコピー /(n) catch copy (in copywriting, large text that appears in ads or brochures to catch the reader's attention)/
キャッチセールス /(n) unscrupulous sales practice involving expensive hard-to-break contracts (practise) (wasei: catch sales)/
キャッチバー /(n) catch bar/
キャッチフレーズ /(n) catchphrase/(P)/
キャッチホン /(n) call waiting (wasei: catch phone)/
キャッチボール /(n) playing catch (wasei: catch ball)/
キャッチャー /(n) catcher/(P)/
キャッチャーボート /(n) catcher (whaling boat)/
キャッチワード /(n) catchword/
キャッツ /(n) cats (esp. the musical: Cats)/
キャッツアイ /(n) (1) cat's-eye (semiprecious stone)/(2) cat's-eye (light-reflecting road stud)/(P)/
キャット /(n) cat/
キャットウォーク /(n) catwalk/(P)/
キャットウオーク /(n) catwalk/
キャットタン /(n) (sl) unable to take (thermally) hot food (wasei: cat tongue)/have a tongue too sensitive to heat/
キャットフード /(n) cat food/
キャットボンド /(n) cat bond/catastrophe bond/
キャッピング /(n) capping/
キャップ /(n) (1) cap/(2) top reporter at a newspaper's local office/(3) (abbr) captain/(P)/
キャップスリーブ /(n) cap sleeve/
キャップハイト /(n) (comp) cap height/
キャップハンディ /(n) empathetically putting oneself in the place of a handicapped person (wasei: cap handy)/
キャップライト /(n) cap light/
キャップライン /(n) (comp) capline/
キャップランプ /(n) cap lamp/
キャップレス /(n) capless/
キャップロック /(n) cap rock/
キャディ /(n) (comp) caddy/
キャディー /(n) caddie/caddy/(P)/
キャディーバッグ /(n) caddie bag/caddy bag/
キャデラック /(n) Cadillac/
キャドキャム /(n) (comp) CAD-CAM/
キャニオン /(n) canyon/
キャニスター /(n) canister/
キャノーラ /(n) Canola (oil)/
キャノピー /(n) canopy/
キャノン /(n) cannon/
キャノンボール /(n) cannonball/
キャノン砲 [キャノンほう] /(n) cannon/
キャバクラ /(n) (abbr) cabaret club/
キャバクラ嬢 [キャバクラじょう] /(n) female cabaret club employee/
キャバレー /(n) cabaret (fre:)/(P)/
キャバ嬢 [キャバじょう] /(n) female cabaret club employee/
キャパ /(n) (abbr) capacity/
キャパシタ /(n) (comp) capacitor/
キャパシター /(n) capacitor/
キャパシタンス /(n) capacitance/
キャパシティ /(n) capacity/
キャパシティー /(n) capacity/
キャパシティプランニング /(n) (comp) capacity planning/
キャビア /(n) caviar/caviare/(P)/
キャビテーション /(n) cavitation/
キャビネ /(n) cabinet (fre:)/
キャビネット /(n) cabinet/housing (of equipment)/(P)/
キャビネットの筺体 [キャビネットのきょうたい] /(n) (comp) cabinet enclosure/
キャビネットアラーム /(n) (comp) cabinet alarm/
キャビネットタイプ /(n) (comp) cabinet type/
キャビネットファイル /(n) (comp) cabinet file/
キャビネットフレーム /(n) (comp) cabinet frame/
キャビネットフロントドア /(n) (comp) cabinet front door/
キャビネットモニタコントローラ /(n) (comp) cabinet monitoring controller/
キャビネットモニタリング /(n) (comp) cabinet monitoring/
キャビネットルーフ /(n) (comp) cabinet roof/
キャビネット環境 [キャビネットかんきょう] /(n) (comp) cabinet environment/
キャビネット筺体 [キャビネットきょうたい] /(n) (comp) cabinet enclosure/
キャビネ判 [キャビネばん] /(n) cabinet size/
キャビン /(n) cabin/(P)/
キャビンアテンダント /(n) cabin attendant/
キャピタリズム /(n) capitalism/(P)/
キャピタル /(n) capital/
キャピタルゲイン /(n) capital gain/(P)/
キャピタルベース /(n) capital base/
キャピタルリスク /(n) capital risk/
キャピタルレター /(n) capital letter/
キャピタルロス /(n) capital loss/
キャピトル /(n) (1) capital/(2) capitol/
キャフィス /(n) (comp) CAFIS/
キャフェ /(n) (1) cafe (fre:)/(2) hostess bar (serving western alcoholic beverages; Taisho and Showa period)/
キャフェテリア /(n) cafeteria/
キャブタイヤケーブル /(n) cab-tyre cable/
キャブレター /(n) carburetor/carburettor/carburator/carburetter/(P)/
キャプション /(n) caption/legend/cutline/(P)/
キャプスタン /(n) capstan/
キャプスロック /(n) (comp) Caps Lock/
キャプスロックキー /(n) (comp) Caps Lock key/caps lock key/
キャプチャ /(n,vs) (1) capture/(n) (2) (abbr) CAPTCHA/Completely Automated Public Turing test to tell Computers and Humans Apart/
キャプチャー /(n,vs) (1) capture/
キャプチャデバイス /(n) (comp) capture device/
キャプチャバッファ /(n) (comp) capture buffer/
キャプテン /(n) captain/(P)/
キャプテンシステム /(n) Character and Pattern Telephone Access Information System/CAPTAIN System/
キャプテンジャケット /(n) captain jacket/
キャプリーヌ /(n) capeline/
キャベツ /(n) cabbage/(P)/
キャペリン /(n) capelin/caplin (Mallotus villosus)/
キャミソール /(n) camisole/
キャメラ /(n) camera/
キャメル /(n) camel/(P)/
キャラ /(n) (abbr) character (e.g. in a manga, anime, game, etc.)/
キャラウェー /(n) caraway/
キャラウエー /(n) caraway/
キャラクタ /(n) character/
キャラクター /(n) character/(P)/
キャラクターコード /(n) (comp) character code/
キャラクターディスプレー /(n) character display/
キャラクタイメージ /(n) (comp) character image/
キャラクタコード /(n) (comp) character code/
キャラクタジェネレータ /(n) (comp) character generator/
キャラクタセット /(n) (comp) character set/
キャラクタセル /(n) (comp) character cell/
キャラクタディスプレイ /(n) (comp) character display/
キャラクタデバイス /(n) (comp) character device/
キャラクタフォーマット /(n) (comp) character format/
キャラクタプリンタ /(n) (comp) character printer/
キャラクタベース /(n) (comp) character based/
キャラクタマップ /(n) (comp) character map/
キャラクタ集合 [キャラクタしゅうごう] /(n) (comp) character set/
キャラクタ定義テーブル [キャラクタていぎテーブル] /(n) (comp) character definition table/
キャラコ /(n,adj-no) calico/
キャラバン /(n) (1) caravan/(2) group of people touring to sell, investigate, etc./(P)/
キャラバンカー /(n) van or truck with a display, retail, etc. facility (wasei: caravan car)/mobile showroom/
キャラバンサライ /(n) caravansary/
キャラバンシューズ /(n) light mountain-climbing shoes (wasei: caravan shoes)/
キャラベル /(n) caravel/
キャラメル /(n) caramel (por: caramelo)/(P)/
キャリー /(n) (comp) carry/(P)/
キャリーオーバー /(n) carry-over/
キャリートレード /(n) carry-trade/
キャリーバック /(n) (1) large bag with handles/carry bag/(2) small case with wheels/(3) bringing the ball back to one's own position (rugby) (wasei: carry back)/
キャリービット /(n) (comp) carry bit/
キャリー商品 [キャリーしょうひん] /(n) leftover stock/carry-over stock/
キャリア /(n) (1) career/(2) career government employee/(3) carrier/(P)/
キャリアー /(n) (1) career/(2) career government employee/(3) carrier/
キャリアを積む [キャリアをつむ] /(exp,v5m) to build one's career/
キャリアウーマン /(n) career woman/
キャリアガール /(n) career girl/
キャリアコード /(n) (comp) carrier code/
キャリアサイド /(n) (comp) carrier-side/
キャリアセンス /(n) (comp) carrier sense/
キャリアディテクト /(n) (comp) carrier detect/CD/
キャリアトーン /(n) carrier tone/
キャリア検出 [キャリアけんしゅつ] /(n) (comp) carrier detect/
キャリア検知 [キャリアけんち] /(n) (comp) carrier sense/
キャリア検地 [キャリアけんち] /(n) (comp) carrier detect/carrier sense/
キャリア検地多重アクセス衝突回避ネットワーク [キャリアけんちたじゅうアクセスしょうとつかいひネットワーク] /(n) (comp) carrier sense multiple access with collision avoidance network/CSMA/CA network/
キャリア検地多重アクセス衝突検出ネットワーク [キャリアけんちたじゅうアクセスしょうとつけんしゅつネットワーク] /(n) (comp) carrier sense multiple access with collision detection network/CSMA/CD network/
キャリア組 [キャリアぐみ] /(n) career bureaucrats/
キャリコ /(n) calico/
キャリッジ /(n) carriage/
キャリッジリターン /(n) (comp) carriage return/
キャリパー /(n) caliper/
キャリパス /(n) callipers/calipers/
キャリブレーション /(n) calibration/
キャリブレート /(n,vs) (comp) calibration/
キャリヤ /(n) (comp) carrier/
キャリヤー /(n) (1) career/(2) career government employee/(3) carrier/
キャリングケース /(n) carrying case/
キャリングボール /(n) carrying-ball/
キャルス /(n) (comp) CALS/
キャレット /(n) (comp) caret/
キャロット /(n) (1) carrot/(2) calotte (type of hat) (fre:)/
キャロル /(n) carol/(P)/
キャン /(adv-to) (on-mim) yelp/
キャンキャン /(int) yelp/yap/
キャンギャル /(n) (abbr) model featured in an advertising campaign (wasei: campaign girl)/
キャンサー /(n) cancer/
キャンセラー /(n) canceller/canceler/
キャンセル /(n,vs) (comp) cancel/(P)/
キャンセル待ち [キャンセルまち] /(n) waiting list (waiting for a cancellation)/
キャンセル料 [キャンセルりょう] /(n) cancellation charge/
キャンター /(n) canter/
キャンタロープ /(n) cantaloupe/
キャンティ /(n) Chianti (wine) (ita:)/
キャンデー /(n) candy/sweets/(P)/
キャンディ /(n) candy/sweets/
キャンディー /(n) candy/sweets/
キャンディデート /(n) (comp) candidate/
キャンディデート版 [キャンディデートばん] /(n) (comp) candidate release/
キャンドソフトウェア /(n) (comp) canned software/
キャンドル /(n) candle/(P)/
キャンドルーチン /(n) (comp) canned routine/
キャンドルサービス /(n) candle service/
キャンドルスティック /(n) candlestick/
キャンドルライト /(n) candlelight/
キャンバー /(n) camber/
キャンバス /(n) (1) canvas/(2) base (in baseball)/(P)/
キャンバスワーク /(n) canvas work/
キャンパー /(n) camper/(P)/
キャンパス /(n) campus/(P)/
キャンパスウエア /(n) campus wear/
キャンパスシューズ /(n) campus shoes/
キャンパスバックボーン /(n) (comp) campus backbone/
キャンピング /(n) camping/(P)/
キャンピングカー /(n) mobile home (wasei: camping car)/camper-van/RV/(P)/
キャンピングトレーラー /(n) camping trailer/caravan/
キャンブリック /(n) cambric/
キャンプ /(n,vs) camp/(P)/
キャンプを張る [キャンプをはる] /(exp,v5r) to pitch camp/
キャンプイン /(n) camp in/(P)/
キャンプサイト /(n) camp site/
キャンプファイア /(n) campfire (usually large, and for gathering and singing, etc. around)/
キャンプファイアー /(n) campfire (usually large, and for gathering and singing, etc. around)/
キャンプファイヤー /(n) campfire (usually large, and for gathering and singing, etc. around)/
キャンプ場 [キャンプじょう] /(n) camping-ground/
キャンプ村 [キャンプむら] /(n) campsite/
キャンベラ /(n) Canberra/(P)/
キャンペーン /(n) campaign/(P)/
キャンペーンセール /(n) campaign sale/
キャン待ち [キャンまち] /(n) (abbr) (sl) waiting list (waiting for someone to cancel)/
キヤノン /(n) Canon/(P)/
キュー /(n) (1) queue/(2) cue/(P)/
キューから取り出す [キューからとりだす] /(exp,v5s) (comp) to dequeue/
キューに入れる [キューにいれる] /(exp,v1) (comp) to enqueue/to queue in line/
キューイング /(n) (comp) queuing/
キューイング理論 [キューイングりろん] /(n) (comp) queuing theory/
キューエルディー /(n) (comp) QLD/
キューゴ /(n) (comp) 95/
キュージューゴ /(n) (comp) 95/
キューティー /(n) cutie/
キューティクル /(n) cuticle/
キューティクルクリーム /(n) cuticle cream/
キューティクルリムーバー /(n) cuticle remover/
キュート /(adj-na,n) cute/(P)/
キューハチ /(n) (comp) 98/
キューバ /(n,adj-no) (uk) Cuba/(P)/
キューバリーブレ /(n) cuba libre (cocktail)/
キューバリブレ /(n) cuba libre (cocktail)/
キューバンヒール /(n) Cuban heel/
キューバ革命 [キューバかくめい] /(n) Cuban Revolution/
キューバ危機 [キューバきき] /(n) Cuban Missile Crisis (1962)/
キュービクル /(n) cubicle/
キュービジョン /(n) (comp) Q-Vision/
キュービズム /(n) Cubism (art movement) (fre:)/
キュービック /(n) cubic/
キュービックタイプ /(n) cubic type/
キュービック補間 [キュービックほかん] /(n) (comp) cubic interpolation/
キュービット /(n) (1) cubit/(2) qubit/
キューピー /(n) kewpie doll/
キューピッド /(n) Cupid/(P)/
キューブ /(n) cube/
キューポラ /(n) cupola/
キューレット /(n) curette (fre:)/
キュー末尾 [キューまつび] /(n) (comp) end of a queue/
キュア /(n) cure/
キュイジーヌ /(n) cuisine (fre:)/
キュウカンチョウ /(n) (uk) hill myna (species of mynah bird, Gracula religiosa)/
キュウジュウハチ /(n) (comp) 98/
キュウセン /(n) (uk) multicolorfin rainbowfish (Parajulis poecilepterus, was Halichoeres poecilopterus)/
キュウリ /(n) (uk) cucumber/
キュウリウオ /(n) (uk) rainbow smelt (Osmerus mordax dentex)/
キュビスト /(n) Cubist/
キュビスム /(n) Cubism (art movement) (fre:)/
キュビズム /(n) Cubism (art movement) (fre:)/
キュビット /(n) (1) cubit/(2) qubit/
キュビワノ /(n) cubewano/classical Kuiper belt object/
キュプラ /(n) cupra/
キュプロニッケル /(n) (obsc) cupronickel/
キュポラ /(n) cupola/
キュラソー /(n) curacao (fre:)/
キュリー /(n) curie (unit of radioactivity)/(P)/
キュリー温度 [キュリーおんど] /(n) Curie temperature/
キュリー点 [キュリーてん] /(n) Curie point/
キュリウム /(n) curium (Cm)/
キュリオシティー /(n) curiosity/
キュレーター /(n) curator/(P)/
キュレネ学派 [キュレネがくは] /(n) Cyrenaic school (of philosophy)/
キュロット /(n) culotte (fre:)/(P)/
キュロットスカート /(n) culotte skirt/culottes/
キュンメル /(n) kummel (liqueur flavored with caraway seed or cumin) (ger:)/
キョウジョシギ /(n) (uk) ruddy turnstone (species of sandpiper, Arenaria interpres)/
キョクアジサシ /(n) arctic tern/
キョドる /(v5r,vi) (1) (sl) to act suspiciously/to behave in a strange way/(exp) (2) How are you today?/
キョン /(n) Chinese muntjac (species of barking deer, Muntiacus reevesi)/
キヨスク /(n) kiosk/(P)/
キヨミオレンジ /(n) Kiyomi orange/type of tangor (tangerine-orange hybrid)/Citrus unshiu sinensis/
キラー /(n) killer/(P)/
キラーアプリケーション /(n) (comp) "killer" application/
キラーダスト /(n) killer dust/
キラー衛星 [キラーえいせい] /(n) killer satellite/
キラー細胞 [キラーさいぼう] /(n) killer cell/
キラキラ /(adv,adv-to,vs) (on-mim) glitter/sparkle/glisten/twinkle/
キラッ /(adv-to) (on-mim) glittering/glitteringly/sparkling/twinkling/brightly/
キラメキ /(n) glitter/glimmer/sparkle/twinkle/
キランソウ /(n) (uk) creeping bugleweed (Ajuga decumbens)/
キリギリス /(n) (1) (uk) Japanese katydid (Gampsocleis buergeri)/(2) katydid/bush-cricket (Tettigoniidae)/long-horned grasshopper/(3) (arch) cricket/
キリシタン /(n) (uk) early Japanese Christianity (from the later Muromachi period) (por: cristao)/early Japanese Christian/(P)/
キリシタンパテレン /(n) Christian priest (por: cristao padre)/
キリシタン版 [キリシタンばん] /(n) books printed in Japan by the Jesuits (1590-1612)/
キリスト /(n,adj-no) (uk) Christ (por: Cristo)/(P)/
キリスト教 [キリストきょう] /(n) Christianity/(P)/
キリスト教国 [キリストきょうこく] /(n) Christian countries/
キリスト教式 [キリストきょうしき] /(n) Christian rites/
キリスト教社会主義 [キリストきょうしゃかいしゅぎ] /(n) Christian socialism/
キリスト教徒 [キリストきょうと] /(n) Christians/
キリスト教民主同盟 [キリストきょうみんしゅどうめい] /(n) Christian Democratic Union (Germany)/Christian Democrats/CDU/
キリスト降誕祭 [キリストこうたんさい] /(n) Christmas/
キリリク /(n) (col) lucky-number request (the person who is the Nth visitor to a web site gets to make a request, e.g. for a custom drawing, where N is a special number like 10000)/
キリル /(n) Cyrillic/(P)/
キリル文字 [キリルもじ] /(n) Cyrillic character/
キリン /(n) (1) (uk) giraffe/(2) qilin (Chinese unicorn)/(3) Kirin (brand of beer)/
キリンサイ /(n) (uk) Eucheuma muricatum (species of red algae)/
キリンソウ /(n) (uk) Kamchatka stonecrop (Sedum kamtschaticum)/
キリ番 [キリばん] /(n) good turning point number (10000, 12345 etc., often referring to web site visit counts)/
キル /(n) kill/(P)/
キルギスタン /(n) Kyrgyzstan/
キルク /(n) cork (dut: kurk)/
キルシュ /(n) kirsch (ger: Kirsch)/
キルシュワッサー /(n) kirschwasser (ger: Kirschwasser)/
キルティング /(n) quilting/
キルト /(n) (1) quilt/(2) kilt/
キルヒホッフ /(n) Kirchhoff/(P)/
キルヒホッフの法則 [キルヒホッフのほうそく] /(n) Kirchhoff's law/
キルビメーター /(n) curvimeter (fre:)/(P)/
キレート /(n) chelate/
キレート化合物 [キレートかごうぶつ] /(n) chelate compound/
キレート滴定 [キレートてきてい] /(n) chelatometric titration/
キレる /(v1) (sl) to get angry/to snap/to blow one's top/
キレット /(n) (uk) gap (in a mountain ridge)/
キレネ学派 [キレネがくは] /(n) Cyrenaic school (of philosophy)/
キロ /(pref) (1) kilo- (fre:)/10^3/(n) (2) (abbr) kilogram/kilogramme/(3) (abbr) kilometre/kilometer/(pref) (4) (comp) kilo-/2^10/(P)/
キロアンペア /(n) kiloampere/
キロカロリー /(n) kilocalorie/
キログラムカロリー /(n) kilogram calorie/
キログラム原器 [キログラムげんき] /(n) prototype kilogram/
キログラム重 [キログラムじゅう] /(n) kilogram-weight/kilogramme-weight/
キロトン /(n) kiloton/
キロバイト /(n) (comp) kilobyte/kB/
キロビット /(n) (comp) kilobit/
キロヘルツ /(n) (comp) kilohertz/kHz/
キロメーター /(n) kilometer (mis-spelling) (kilometre)/
キロワット /(n) kilowatt/(P)/
キロワット時 [キロワットじ] /(n) kWh/kilowatt hour/
キロ連量 [キロれんりょう] /(n) weight of 1000 sheets of paper/ream weight/
キワダ /(n) (uk) yellowfin tuna (Thunnus albacares)/
キワダマグロ /(n) (uk) yellowfin tuna (Thunnus albacares)/
キンカジュー /(n) kinkajou (Potos flavus)/
キンカチョウ /(n) (uk) zebra finch (Taeniopygia guttata)/
キンカン /(n) (uk) kumquat (Fortunella spp.)/cumquat/
キンキ /(n) broadbanded thornyhead/broadfin thornyhead/kichiji rockfish (Sebastolobus macrochir)/
キンキーブーツ /(n) kinky boots/(P)/
キンキールック /(n) kinky look/
キンクロハジロ /(n) (uk) tufted duck (Aythya fuligula)/
キング /(n) king/(P)/
キングエンゼル /(n) king angelfish (Holacanthus passer)/
キングクリップ /(n) kingklip (Genypterus blacodes)/pink cusk-eel/
キングコブラ /(n) king cobra/hamadryad (Ophiophagus hannah)/
キングサーモン /(n) king salmon/
キングサイズ /(n) king-size/
キングズイングリッシュ /(n) King's English/
キングドーム /(n) King Dome/
キングヒメオオトカゲ /(n) King's goanna (Varanus kingorum, species of small carnivorous monitor lizard native to the Australia)/
キングピン /(n) kingpin/
キングヘビ /(n) (uk) king snake (any snake of genus Lampropeltis)/
キングペンギン /(n) king penguin (Aptenodytes patagonicus)/
キングボルト /(n) kingbolt/
キングメーカー /(n) kingmaker/(P)/
キング蛇 [キングへび] /(n) (uk) king snake (any snake of genus Lampropeltis)/
キンシバイ /(n) (uk) goldencup St. John's wort (Hypericum patulum)/
キンタル /(n) quintal/
キンチャクソウ /(n) (uk) pocketbook plant (any plant of genus Calceolaria)/
キンチャクダイ /(n) bluestriped angelfish (Chaetodontoplus septentrionalis)/
キンチャクダイ属 [キンチャクダイぞく] /(n) Chaetodontoplus (genus of marine angelfishes in the family Pomacanthidae)/
キンチャクフグ属 [キンチャクフグぞく] /(n) Canthigaster (genus of pufferfish in the family Tetraodontidae)/
キントキダイ /(n) (uk) red bigeye (Priacanthus macracanthus)/
キンドル /(n) (comp) Kindle (Amazon's electronic book device)/
キンバーライト /(n) kimberlite/
キンバイソウ /(n) (uk) Trollius hondoensis (species of globeflower)/
キンバエ /(n) (uk) greenbottle fly (esp. species Lucilia caesar)/
キンバト /(n) (uk) emerald dove (Chalcophaps indica)/
キンバリー岩 [キンバリーがん] /(n) (obsc) kimberlite/
キンパ /(n) (abbr) (sl) blond hair/
キンパラ /(n) (uk) chestnut munia (species of passerine bird, Lonchura atricapilla)/black-headed munia/
キンブナ /(n) (uk) Carassius buergeri/
キンホシイソハゼ /(n) storthynx pygmy goby (Eviota storthynx)/belly-spotted pygmy-goby/
キンポウゲ科 [キンポウゲか] /(n) Ranunculaceae (plant family)/crowfoot/
キンポウゲ目 [キンポウゲもく] /(n) Ranunculales (order of plants)/
キンポウジュ /(n) (uk) crimson bottlebrush/Callistemon citrinus/
キンマ /(n) (uk) betel (Piper betle)/
キンモクセイ /(n) (uk) fragrant olive (Osmanthus fragrans var. aurantiacus)/
キンランチョウ /(n) (uk) red bishop (species of African weaverbird, Euplectes orix)/
キンリンサザナミハギ /(n) spotted surgeonfish (Ctenochaetus strigosus, species of bristletooth tang found in Hawaii, Johnston Island, and Australia)/goldring surgeonfish/goldring bristletooth/
キンレンカ /(n) (uk) nasturtium (species of Indian cress, Tropaeolum majus)/
キン族 [キンぞく] /(n) Kinh (people)/Vietnamese (people)/
ギー /(n) ghee/
ギーク /(n) (comp) geek/
ギア /(n) gear/(P)/
ギアシフト /(n) gearshift/
ギアチェンジ /(n) gear change/
ギアナ /(n) Guiana/
ギアナバタフライ /(n) French butterflyfish (Prognathodes guyanensis, was Chaetodon guyanensis)/Guyana butterflyfish/
ギアボックス /(n) gearbox/gear box/
ギアラ /(n) abomasum (fourth compartment of the stomach of a ruminant)/maw/rennet-bag/
ギイア /(n) gear/
ギガ /(n,pref) giga-/10^9/(P)/
ギガトン /(n) gigaton/
ギガバイト /(n) (comp) gigabyte/
ギガビット /(n) (comp) gigabit/
ギガビットイーサネット /(n) (comp) Gigabit Ethernet/
ギガヘルツ /(n) (comp) gigahertz/
ギガモ /(n) (comp) GIGAMO/
ギギ /(n) (uk) forktail bullhead (species of catfish, Pelteobagrus nudiceps)/
ギクシャク /(adv,n,vs) (1) jerkiness/awkwardness/stiltedness/(2) souring (of a relationship)/strain (e.g. in relations)/
ギグ /(n) gig/
ギザギザ /(adj-na,adj-no,n,adv) (on-mim) jagged/notched/corrugated/milled/serrated/
ギシギシ /(n) (uk) Japanese dock (plant) (Rumex japonicus)/
ギシギシ /(n) creak/squeak/creaking sound/
ギター /(n) guitar/(P)/
ギターの弦 [ギターのげん] /(n) guitar string/
ギターアンプ /(n) guitar amplifier/
ギターシンセ /(n) guitar synthesizer/guitar synthesiser/
ギターマガジン /(n) guitar magazine/
ギターリスト /(ik) (n) guitarist/
ギタリスト /(n) guitarist/(P)/
ギックリ腰 [ギックリごし] /(n) strained back/slipped disk/lumbosacral strain/
ギニー /(n) guinea/
ギニーピッグ /(n) guinea pig/
ギニア /(n) Guinea/
ギニアビサウ /(n) Guinea-Bissau/
ギニアビサウ共和国 [ギニアビサウきょうわこく] /(n) Republic of Guinea-Bissau/
ギニアンエンジェルフィッシュ /(n) Guinean angelfish (Holacanthus africanus)/West African angelfish/
ギニア共和国 [ギニアきょうわこく] /(n) Republic of Guinea/
ギニョール /(n) guignol (fre:)/
ギニョル /(n) guignol (fre:)/
ギネスブック /(n) Guinness Book of Records/(P)/
ギバチ /(n) (uk) cut-tailed bullhead (species of catfish, Pseudobagrus aurantiacus)/
ギフト /(n) gift/(P)/
ギフトカード /(n) gift card/gift certificate/
ギフトクーポン /(n) gift coupon/
ギフトショップ /(n) gift shop/
ギフトチェック /(n) gift check/gift cheque/
ギフトパッケージ /(n) gift package/
ギフト券 [ギフトけん] /(n) gift certificate/gift voucher/
ギブ /(n,vs) (1) give/(int) (2) (abbr) uncle! (I give up)/
ギブアップ /(n,vs) give up/(P)/
ギブアンドテーク /(n) give-and-take/give and take/
ギブアンドテイク /(n) give-and-take/give and take/
ギブス /(n) (1) gypsum (ger: Gips)/plaster-of-paris/(2) plaster cast/cast/
ギブスサンプリング /(n) (comp) Gibbs sampling/
ギプス /(n) (1) gypsum (ger: Gips)/plaster-of-paris/(2) plaster cast/cast/(P)/
ギプス包帯 [ギプスほうたい] /(n) plaster cast/
ギベレリン /(n) gibberellin (plant hormone)/
ギボウシ /(n) (1) bridge railing-post knob/(2) (uk) stone-leek flower/hosta (genus of about 40 species of lily-like plants in the family Agavaceae)/
ギボシ /(n) (1) bridge railing-post knob/(2) (uk) stone-leek flower/hosta (genus of about 40 species of lily-like plants in the family Agavaceae)/
ギボシムシ /(n) (uk) acorn worm (any hemichordate of class Enteropneusta)/
ギボン /(n) gibbon/
ギミック /(n) gimmick/
ギムナジウム /(n) gymnasium (ger:)/
ギムネマ /(n) gymnema (Indian herb)/
ギムレット /(n) gimlet (cocktail)/
ギャーザー /(n) gather (e.g. in cloth)/
ギャグ /(n) joke/gag/(P)/
ギャグる /(v5r) to joke/to say something funny/
ギャグマン /(n) gagman/gag man/
ギャザー /(n) gather/
ギャザースカート /(n) gathered skirt/
ギャゼットバッグ /(n) gadget bag/
ギャップ /(n) gap/(P)/
ギャップレース /(n) gap lathe/
ギャッベ /(n) Gabbeh (type of Persian carpet)/Gabbe/Gava/Khersak/
ギャバジン /(n) gabardine/
ギャフ /(n) gaff/
ギャモン /(n) gammon/
ギャラ /(n) (1) (abbr) guarantee/(2) fee paid to performing artists/(P)/
ギャラクシー /(n) galaxy/
ギャラップ調査 [ギャラップちょうさ] /(n) Gallup poll/
ギャラティー /(n) guarantee/
ギャラリー /(n) gallery/(P)/
ギャランティー /(n) guaranty/guarantee/
ギャランティ型 [ギャランティかた] /(n) (comp) guarantee type/
ギャランドゥ /(n) happy trail (line of hair from the navel to the genitals)/pubic hair/
ギャランドゥー /(n) happy trail (line of hair from the navel to the genitals)/pubic hair/
ギャル /(n) gal/(P)/
ギャルゲ /(n) (comp) (abbr) computer game for men featuring beautiful women characters (usu. adult game) (wasei: gal game)/
ギャルゲー /(n) (comp) (abbr) computer game for men featuring beautiful women characters (usu. adult game) (wasei: gal game)/
ギャルソン /(n) (1) boy/(2) male waiter (fre: garcon)/(P)/
ギャルママ /(n) (1) teenage mother/(2) young mother who wears "gal" styles/
ギャル車 [ギャルしゃ] /(n) (sl) girly car (often full of plastic flowers, stuffed animals, etc.) owned by a young, trendy female/
ギャル男 [ギャルお] /(n) man who imitates girls in dress, hair style, etc./
ギャル文字 [ギャルもじ] /(n) obfuscated style of Japanese text, used particularly by young women in keitai emails/
ギャレー /(n) galley/
ギャレージ /(n) garage (at house)/
ギャロッピングインフレ /(n) galloping inflation/(P)/
ギャロップ /(n) (1) gallop/(2) galop (dance)/
ギャング /(n) (1) gang/(2) (abbr) gangster/(P)/
ギャングエージ /(n) gang age/
ギャングスター /(n) gangster/
ギャング映画 [ギャングえいが] /(n) gangster film/
ギャンブラー /(n) gambler/(P)/
ギャンブル /(n) gambling/(P)/
ギャンブル運 [ギャンブルうん] /(n) luck in gambling/
ギャンブレル屋根 [ギャンブレルやね] /(n) gambrel roof/
ギヤ /(n) gear/
ギヤマン /(n) diamant (dut:)/diamond/
ギヤマン石 [ギヤマンせき] /(n) (arch) diamond/
ギュヨー /(n) guyot/
ギョーザ /(n) (uk) gyoza (crescent-shaped pan-fried dumplings stuffed with minced pork and vegetables)/
ギョウザ /(n) (uk) gyoza (crescent-shaped pan-fried dumplings stuffed with minced pork and vegetables)/
ギョッ /(int) shock/
ギョリュウ /(n) (uk) Tamarix chinensis/Chinese tamarisk/
ギョロリ /(adv,adv-to) staring (e.g. eyes)/goggling/
ギヨー /(n) guyot/
ギヨチン /(n) guillotine (fre:)/
ギラつく /(v5k,vi) (1) to glare/to dazzle/(2) to glitter/
ギランバレー症候群 [ギランバレーしょうこうぐん] /(n) Guillain-Barre syndrome/
ギリギリアウト /(exp) (col) too late (by a short time)/just failed (by a small margin)/
ギリギリセーフ /(exp) just safe (e.g. just avoiding being late, failing an exam, etc.)/just (barely) OK/
ギリシア /(n,adj-no) (uk) Greece (por: Grecia)/
ギリシア共和国 [ギリシアきょうわこく] /(n) Republic of Greece/Hellenic Republic/
ギリシア語 [ギリシアご] /(n) Greek (language, word)/
ギリシア神話 [ギリシアしんわ] /(n) Greek mythology/
ギリシア人 [ギリシアじん] /(n) Greek (person)/
ギリシア正教 [ギリシアせいきょう] /(n) Greek Orthodox Church/
ギリシア正教会 [ギリシアせいきょうかい] /(n) Greek Orthodox Church/
ギリシア彫刻 [ギリシアちょうこく] /(n) Greek sculpture/
ギリシア哲学 [ギリシアてつがく] /(n) Greek philosophy/
ギリシア美術 [ギリシアびじゅつ] /(n) Greek art/
ギリシア文字 [ギリシアもじ] /(n) Greek character/Greek characters/
ギリシャ /(n,adj-no) (uk) Greece (por: Grecia)/
ギリシャリクガメ /(n) (uk) European tortoise/Greek tortoise (Testudo graeca)/
ギリシャ共和国 [ギリシャきょうわこく] /(n) Republic of Greece/Hellenic Republic/
ギリシャ語 [ギリシャご] /(n) Greek (language, word)/
ギリシャ神話 [ギリシャしんわ] /(n) Greek mythology/
ギリシャ人 [ギリシャじん] /(n) Greek (person)/
ギリシャ正教 [ギリシャせいきょう] /(n) Greek Orthodox Church/
ギリシャ正教会 [ギリシャせいきょうかい] /(n) Greek Orthodox Church/
ギリシャ彫刻 [ギリシャちょうこく] /(n) Greek sculpture/
ギリシャ哲学 [ギリシャてつがく] /(n) Greek philosophy/
ギリシャ美術 [ギリシャびじゅつ] /(n) Greek art/
ギリシャ文字 [ギリシャもじ] /(n) Greek character/Greek characters/
ギリシャ陸亀 [ギリシャりくがめ] /(n) (uk) European tortoise/Greek tortoise (Testudo graeca)/
ギリセーフ /(exp) (col) (abbr) just safe (e.g. just avoiding being late, failing an exam, etc.)/just (barely) OK/
ギリヤーク /(n) (obs) Gilyak (old name for the Nivkh ethnic minority group of Russia)/
ギルダー /(n) guilder/
ギルト /(n) gilt/
ギルトトップ /(n) gilt-top/
ギルド /(n) guild/(P)/
ギルド社会主義 [ギルドしゃかいしゅぎ] /(n) guild socialism/
ギロチン /(n) guillotine (fre:)/(P)/
ギロチン破断 [ギロチンはだん] /(n) guillotine break/guillotine rupture/
ギンガム /(n) gingham/
ギンガメアジ /(n) (uk) bigeye trevally (Caranx sexfasciatus)/bigeye jack/great trevally/six-banded trevally/dusky jack/
ギンギン /(adv) (1) (on-mim) ecstatic/ecstatically/(2) splitting headache/
ギンザケ /(n) (uk) coho salmon (Oncorhynchus kisutsh)/silver salmon/
ギンザメ /(n) (uk) silver chimaera (Chimaera phantasma, species of deep water cartilaginous ghost shark from the Western Pacific)/
ギンザメダマシ /(n) Hydrolagus ogilbyi (species of cartilaginous fish endemic to Australia)/Ogilbys ghostshark/
ギンザメ科 [ギンザメか] /(n) Chimaeridae (family of shortnose chimaeras, cartilaginous fish with short round snouts)/
ギンザメ属 [ギンザメぞく] /(n) Chimaera (genus of cartilaginous fish in the family Chimaeridae)/
ギンザンマシコ /(n) (uk) pine grosbeak (Pinicola enucleator)/
ギンッ /(n) (sound effect) sproing/spring up/
ギンドロ /(n) (uk) white poplar (Populus alba)/
ギンナン /(n) ginkgo nut/gingko nut/
ギンブナ /(n) (uk) Carassius langsdorfii/
ギンホオミツスイ /(n) (uk) little wattlebird (Anthochaera lunulata)/
ギンポ /(n) (uk) tidepool gunnel (Pholis nebulosa)/
ギンメダイ /(n) (uk) silver eye (species of beardfish, Polymixia japonica)/
ギンモクセイ /(n) (uk) tea olive (Osmanthus fragrans)/fragrant olive/sweet olive/
ギンヤンマ /(n) (uk) lesser emperor (species of dragonfly, Anax parthenope)/
ギンリョウソウ /(n) (uk) Monotropastrum humile (species of saprophytic plant)/
ギンリョウソウモドキ /(n) (uk) Indian pipe (Monotropa uniflora)/
ギ酸 [ギさん] /(n) (1) formic acid/(adj-no) (2) formic/
ギ神 [ギかみ] /(n) Greek god or goddess/
クーガー /(n) cougar/
クーキー /(n) (1) kooky/weird/(2) cookie/cooky/(P)/
クーキーガール /(n) (obsc) kooky girl/
クークラックスクラン /(n) Ku Klux Klan/KKK/
クーシェット /(n) couchette (fre:)/non-private sleeper car or berth on a European train/
クーデター /(n) coup d'etat (fre:)/coup/(P)/
クーバード /(n) (obsc) couvade (custom in which a male acts out the physical process of his own child being born) (fre:)/
クーパーハイタカ /(n) (uk) Cooper's hawk (Accipiter cooperii)/
クーパー鷂 [クーパーはいたか] /(n) (uk) Cooper's hawk (Accipiter cooperii)/
クーペ /(n) coupe (fre:)/(P)/
クーポン /(n) coupon (fre:)/(P)/
クーポンレート /(n) coupon rate/
クーポン券 [クーポンけん] /(n) coupon (ticket)/
クーラー /(n) cooler/air conditioner/(P)/
クーラーボックス /(n) cooler-box/
クーラント /(n) courante (fre:)/
クーリー・ローチ /(n) kuhli loach (Pangio kuhlii)/
クーリーローチ /(n) kuhli loach (Pangio kuhlii)/
クーリエ /(n) courier/
クーリエサービス /(n) courier service/
クーリッジ管 [クーリッジかん] /(n) Coolidge tube/
クーリングオフ /(n) cooling-off (period)/(P)/
クーリングタワー /(n) cooling tower/
クーリングダウン /(n) cooling down/
クーリングファン /(n) (comp) cooling fan/
クール /(adj-na) (1) cool (temperature, color, etc.)/(2) cool (i.e. calm and collected)/(3) cool (i.e. fashionable, attractive, etc.)/(n) (4) course (of medical treatment) (ger: Kur)/(5) season (series) of a television program (usu. 13 installments over a 3-month period) (fre: cours)/(P)/
クールー /(n) kuru (degenerative brain disease usually associated with New Guinean cannabalism)/
クールアイランド /(n) cool island/
クールカラー /(n) cool color/
クールジャズ /(n) cool jazz/
クールダウン /(n) cool down/
クールビズ /(n) COOL BIZ (Japanese government campaign encouraging people to wear lighter clothes, companies to set their air conditioners to 28C, etc.)/
クールボックス /(n) cool-box/
クーロアール /(n) couloir (fre:)/
クーロメーター /(n) coulometer/
クーロワール /(n) couloir (fre:)/
クーロン /(n) (1) coulomb (fre:)/(2) (comp) cron (computer job run at specific time)/
クーロンの法則 [クーロンのほうそく] /(n) Coulomb's law/
クーロン力 [クーロンりょく] /(n) Coulomb's force/
クァルテット /(n) quartet (ita: quartetto)/
クアッガ /(n) quagga (extinct South African zebra) (Equus quagga quagga)/
クアッハ /(n) quagga (extinct South African zebra) (Equus quagga quagga)/
クアドハイト /(n,adj-no) (comp) quad-height/
クアハウス /(n) multi-purpose health facility (ger: Kurhaus)/
クィーン /(n) queen/
クィディッチ /(n) quidditch (fictional sport from Harry Potter series)/
クィンテット /(n) quintet (ita: quintetto)/
クイーン /(n) queen/(P)/
クイーンエンゼル /(n) queen angelfish (Holacanthus ciliaris)/
クイーンサイズ /(adj-no) queen size/large size/
クイーンズイングリッシュ /(n) Queen's English/(P)/
クイーンズランド /(n) Queensland/
クイーンズランドイエローテールエンジェルフィッシュ /(n) Queensland yellowtail angelfish (Chaetodontoplus meredithi)/Meredith's angelfish/
クイーンメリー /(n) the Queen Mary/
クイズ /(n) quiz/(P)/
クイズマニア /(n) quiz mania/
クイズラリー /(n) quiz rally/
クイズ番組 [クイズばんぐみ] /(n) quiz show/
クイック /(n) quick/(P)/
クイックサンド /(n) quicksand/
クイックスタイル /(n) (comp) quick styles/
クイックステップ /(n) quickstep/
クイックソート /(n) (comp) quick sort/
クイックターン /(n) quick turn/
クイックタイム /(n) (comp) QuickTime/
クイックタブ /(n) (comp) quick tabs/
クイックチェンジ /(n) quick change/
クイックドロー /(n) (comp) QuickDraw/
クイックバン /(n) (comp) QUICK-VAN/
クイックパン /(n) quick bread/
クイックビー /(n) (comp) QUICK B/
クイックブレッド /(n) quick bread/bread made with baking powder instead of yeast/
クイックモーション /(n) (1) quick motion/(2) pitcher throwing to first base (baseball)/
クイックランチ /(n) quick lunch/
クイックリファレンス /(n) (comp) quick reference/
クイッケン /(n) (comp) QUICKEN (accounting package)/
クイナ /(n) (uk) rail (any bird of family Rallidae, esp. the water rail, Rallus aquaticus)/
クイルター /(n) quilter/
クインテット /(n) quintet (ita: quintetto)/(P)/
クイント /(n) quinto/
クウェート /(n) Kuwait/(P)/
クウォート /(n) quote/
クウォウタ /(n) (1) quarter/(2) someone with one non-Japanese grandparent/(3) quota/
クェイク /(n) quake/
クェスチョンマーク /(n) question mark/
クエ /(n) (uk) longtooth grouper (species of fish, Epinephelus bruneus)/
クエーカー /(n) Quaker/Society of Friends/(P)/
クエーサー /(n) quasar/QSO/(P)/
クエスチョン /(n) (1) question/(2) question (mark)/
クエスチョンタイム /(n) question time (section of proceedings in parliament)/
クエスチョンマーク /(n) question mark/
クエッションマーク /(n) question mark/
クエリ /(n) (comp) query/
クエリー /(n) (comp) query/
クエリチャネル /(n) (comp) query channel/
クエリデザイン /(n) (comp) query design/
クエン /(n) (obsc) (uk) citron (Citrus medica)/
クエン酸 [クエンさん] /(n) citric acid/
クエン酸塩 [クエンさんえん] /(n) citrate/
クエン酸回路 [クエンさんかいろ] /(n) citric acid cycle/
クォーク /(n) quark/
クォータ /(n) (1) quarter/(2) someone with one non-Japanese grandparent/(3) quota/
クォーター /(n) (1) quarter/(2) someone with one non-Japanese grandparent/(3) quota/
クォーターバック /(n) quarterback/
クォーターファイナル /(n) quarterfinal/
クォータリー /(n) quarterly/
クォーツ /(n) quartz/
クォーテーション /(n) quotation/
クォーテーションマーク /(n) quotation mark/
クォート /(n) (1) quart/(2) quote/(3) quarto/
クォウタ /(n) (1) quarter/(2) someone with one non-Japanese grandparent/(3) quota/
クォウト /(n) quote/
クォドルプル /(n) quad scull (rowing)/
クォリティー /(n) quality/
クォリティーオブライフ /(n) quality of life/
クォリティーペーパー /(n) quality paper/
クォリファイア /(n) (comp) qualifier/
クォンタイズ /(n) quantize/quantise/
クォンティティー /(n) quantity/
クオーク /(n) quark/
クオータ /(n) (1) quarter/(2) someone with one non-Japanese grandparent/(3) quota/
クオーター /(n) (1) quarter/(2) someone with one non-Japanese grandparent/(3) quota/
クオーターバック /(n) quarterback/
クオーターファイナル /(n) quarter-final/
クオーターマスター /(n) quarter-master/
クオータリー /(n) quarterly/
クオーツ /(n) quartz/
クオーテーション /(n) quotation/
クオーテーションマーク /(n) quotation marks/
クオート /(n) (1) quart/(2) quote/(3) quarto/(P)/
クオリア /(n) quale/qualia (qualities or feelings considered independently of their effects on behavior)/
クオリティ /(n) quality/(P)/
クオリティー /(n) quality/
クオリティーオブライフ /(n) quality of life/
クオリティーペーパー /(n) quality paper/
クオリティオブサービス /(n) (comp) quality of service/
クオンツ /(adj-na) (abbr) quantitative/
クオンツ運用 [クオンツうんよう] /(n) quantitative investment management/
クオンツ分析 [クオンツぶんせき] /(n) quantitative analysis (esp. financial)/
クオンティティー /(n) quantity/
クガイソウ /(n) (uk) Veronicastrum sibiricum (species of flowering plant)/
クギベラ /(n) bird wrasse (Gomphosus varius)/
クギベラ属 [クギベラぞく] /(n) Gomphosus (genus of marine wrasse in the family Labridae)/
ククー /(ik) (n) cuckoo/
ククク /(int) evil laughter/
クグ /(n) (uk) Pacific island flatsedge (Cyperus cyperoides)/
クコ /(n) (uk) Chinese matrimony vine (Lycium chinense)/Chinese wolfberry/goji/
クコの実 [クコのみ] /(n) Chinese wolfberry fruit (Lycium chinense)/Chinese matrimony vine fruit/
クサイチゴ /(n) (uk) Rubus hirsutus (species of raspberry)/
クサカゲロウ /(n) (uk) green lacewing (esp. species Chrysopa intima)/
クサガメ /(n) (1) (uk) Chinese pond turtle (Chinemys reevesii)/Reeves' turtle/(2) stink bug/shield bug/
クサギ /(n) (uk) harlequin glorybower (species of flowering plant, Clerodendrum trichotomum)/
クサグモ /(n) (uk) Agelena limbata (species of araneomorph funnel-web spider)/
クサスギカズラ /(n) (uk) Chinese asparagus (Asparagus cochinchinensis)/
クサソテツ /(n) (uk) Ostrich fern/Matteuccia struthiopteris/
クサフグ /(n) (uk) grass puffer (Takifugu niphobles)/
クサリトラザメ /(n) chain catshark (Scyliorhinus retifer, species found in the Western Atlantic)/
クサリヘビ /(n) (uk) viper (esp. a pitless viper)/
クシェット /(n) couchette (fre:)/non-private sleeper car or berth on a European train/
クシクラゲ /(n) (uk) comb jelly (any jellyfish-like animal of the phylum Ctenophora)/
クシクラゲ類 [クシクラゲるい] /(n) comb jellies (jellyfish-like animals of the phylum Ctenophora)/
クシファクティヌス /(n) Xiphactinus (extinct genus of predatory bony fish)/
クシメ鏝 [クシメごて] /(n) notched trowel/
クシャーナ朝 [クシャーナちょう] /(n) Kushan dynasty (of India, approx. 60-375 CE)/
クシャトリヤ /(n) (uk) Kshatriya (member of India's military caste)/
クシャン朝 [クシャンちょう] /(n) Kushan dynasty (of India, approx. 60-375 CE)/
クジメ /(n) (uk) spotbelly greenling (Hexagrammos agrammus)/
クジャク /(n) (uk) peafowl (inc. the male peacock, female peahen, and young peachick)/
クジャクオオトカゲ /(n) peacock monitor (Varanus auffenbergi, species of carnivorous monitor lizard native to the island of Roti in Indonesia)/Auffenberg's monitor/
クジャクシダ /(n) (uk) northern maidenhair (Adiantum pedatum)/
クジャクスズメダイ /(n) sapphire damsel (Pomacentrus pavo, species of marine damselfish from the Indo-Pacific)/
クジャクソウ /(n) (1) (uk) marigold (esp. the French marigold, Tagetes patula)/(2) plains coreopsis (Coreopsis tinctoria)/(3) northern maidenhair (Adiantum pedatum)/
クジャクチョウ /(n) (uk) peacock butterfly (Inachis io)/
クジャクバト /(n) (uk) fantail pigeon/
クス /(n) (uk) camphor tree (Cinnamomum camphora)/camphorwood/camphor laurel/
クスクス /(n) (1) couscous (fre:)/(2) cuscus (variety of phalanger)/
クスクス笑う [クスクスわらう] /(exp,v5u) to giggle/
クスノキ科 [クスノキか] /(n) Lauraceae (laurel family of plants)/
クズネッツの波 [クズネッツのなみ] /(n) Kuznets swings/
クズネッツ循環 [クズネッツじゅんかん] /(n) Kuznets cycle/
クズリ /(n) (uk) wolverine (Gulo gulo)/glutton/carcajou/
クセ /(n) (1) (uk) long segment of a noh play forming its musical highlight/(n-pref) (2) wrong/improper/indecent/
クセノン /(n) xenon (Xe)/
クソトビ /(n) (uk) (col) (obsc) common buzzard (Buteo buteo)/
クソニンジン /(n) annual mugwort (Artemisia annua)/annual wormwood/sweet sagewort/sweet Annie/sweet wormwood/
クソノキ /(n) (uk) camphor tree (Cinnamomum camphora)/camphorwood/camphor laurel/
クソバエ /(n) (col) greenbottle/
クソボケ /(n) (uk) (derog) shit for brains/
クソミソ /(adj-na,n) (1) harsh/severe (e.g. criticism, verbal attack)/(n) (2) (uk) sweeping denunciation/
クソ味噌 [クソみそ] /(adj-na,n) (1) harsh/severe (e.g. criticism, verbal attack)/(n) (2) (uk) sweeping denunciation/
クチクラ /(n) cuticule (lat: cuticula)/
クチコミ /(n) (1) word of mouth/(2) comment on an Internet forum or web page/
クチナシ /(n) (uk) Cape jasmine (Gardenia jasminoides)/Cape jessamine/gardenia/
クチヒゲザル /(n) (uk) mustached monkey (Cercopithecus cephus)/moustached guenon/
クチュリエ /(n) couturier (fre:)/
クチュリエール /(n) couturiere (fre:)/
クチン /(n) cutin/
クッキー /(n) (1) cookie/biscuit/(2) (comp) cookie (browser-related file sent from a WWW server)/(P)/
クッキング /(n) cooking/(P)/
クッキングカード /(n) cooking card/
クッキングスクール /(n) cooking school/
クッキングホイル /(n) cooking foil/
クック /(n) cook/(P)/
クックー /(n) cuckoo/
クックッ /(n,adv-to) (1) chuckle/stifled laughter/giggle/(2) cluck/coo (bird call)/
クックックッ /(int) evil laughter/
クックドソーセージ /(n) cooked sausage/
クッシー /(n) Kusshi (lake monster said to be living in Hokkaido's Lake Kussharo)/
クッション /(n) cushion/(P)/
クッションボール /(n) cushion ball (carom off the outfield wall by a batted ball) (baseball)/
クッシング症候群 [クッシングしょうこうぐん] /(n) Cushing's syndrome/
クッソ /(n) (uk) kousso (African flowering plant, Hagenia abyssinica)/kosso/cusso/koso/brayera/
クッソ花 [クッソか] /(n) (obsc) kousso (vermifuge made from pistillate brayera flowers)/kosso/cusso/koso/
クッパ /(n) gukbap (Korean rice soup)/
クツワムシ /(n) (uk) Mecopoda nipponensis (species of katydid)/
クテノポマ /(n) climbing gourami (of genus Ctenopoma or Microctenopoma) (lat: Ctenopoma)/
クテノポマ属 [クテノポマぞく] /(n) Ctenopoma (genus of freshwater climbing gouramies with terrestrial locomotion ability in the family Anabantidae)/
クトゥルフ /(n) Cthulhu (fictional divinity created by H.P. Lovecraft)/
クニマス /(n) (uk) Oncorhynchus nerka kawamurae (rare Japanese subspecies of sockeye salmon)/
クヌーセンセル /(n) Knudsen cell/
クヌギ /(n) (uk) sawtooth oak (Quercus acutissima)/
クパティーノ /(n) (comp) Cupertino/
クビ /(n) (1) neck/(2) head/(3) unemployed person/
クビット /(n) (1) cubit/(2) qubit/
クビレフェチ /(n) (sl) small waist fetish (from kubire fetish)/wasp waist fetish/
クビワペッカリー /(n) (uk) collared peccary (Tayassu tajacu)/
クプロファン /(n) Cuprophan/
クマアリ /(n) (obsc) (uk) Japanese carpenter ant (Camponotus japonicus)/
クマゲラ /(n) (uk) black woodpecker (Dryocopus martius)/
クマザサ /(n) (uk) Sasa veitchii/
クマシデ /(n) (uk) Japanese hornbeam (Carpinus japonica)/
クマゼミ /(n) (uk) Cryptotympana facialis (species of cicada)/
クマツヅラ科 [クマツヅラか] /(n) Verbenaceae (plant family)/vervain/
クマドリキンチャクフグ /(n) shy toby (Canthigaster ocellicincta)/
クマネズミ /(n) (uk) black rat (Rattus rattus)/roof rat/
クマノミ /(n) (uk) clownfish (Amphiprioninae spp., esp. the yellowtail clownfish, Amphiprion clarkii)/anemone fish/
クマバチ /(n) (1) Japanese carpenter bee (Xylocopa appendiculata circumvolans)/(2) (col) wasp/hornet/yellow jacket/
クマムシ /(n) (uk) water bear/tardigrades/
クマンバチ /(n) (1) (uk) Japanese carpenter bee (Xylocopa appendiculata circumvolans)/(2) (col) wasp/hornet/yellow jacket/
クミン /(n) cumin/
クメールルージュ /(n) Khmer Rouge (Cambodian communist guerrilla organization)/
クモ /(n) (uk) spider/
クモの巣 [クモのす] /(n,adj-no) spiderweb/
クモガニ /(n) spider crab/
クモザル /(n) (uk) spider monkey/
クモノスカビ /(n) (uk) Rhizopus (saprobic fungus)/
クモハダオオセ /(n) spotted wobbegong (Orectolobus maculatus, species of Australian carpet shark)/
クモヒトデ /(n) (1) (uk) brittle star (any starfish-like echinoderm of the order Ophiuroidea)/brittlestar/(2) Ophioplocus japonicus (species of brittlestar)/
クモ恐怖症 [クモきょうふしょう] /(n) arachnophobia/
クモ形類 [クモがたるい] /(n) arachnids/
クモ膜下腔 [クモまくかくう] /(n) subarachnoid space/
クモ類 [クモるい] /(n) (1) arachnids/(2) araneids/
クラーク /(n) clerk/(P)/
クラーケン /(n) kraken/
クラーレ /(n) curare/
クライ /(n) cry/
クライアント /(n) client/(P)/
クライアント・サーバーモデル /(n) (comp) client-server model/
クライアントアクセスポイント /(n) (comp) client access point/
クライアントアクセスライセンス /(n) (comp) client access license/
クライアントサーバ /(n) (comp) client-server/
クライアントサーバー /(n) (comp) client-server/
クライアントサーバーシステム /(n) (comp) client-server system/CSS/
クライアントサーバーモデル /(n) (comp) client-server model/
クライアントサーバアーキテクチャ /(n) (comp) client-server architecture/
クライアントサーバコンピューティング /(n) (comp) client-server computing/
クライアントサーバモデル /(n) (comp) client-server model/
クライアントサブスクリプション /(n) (comp) client subscription/
クライアントスクリプト /(n) (comp) client script/
クライアントハブ /(n) (comp) client hub/
クライアント側アプリケーション [クライアントがわアプリケーション] /(n) (comp) client-side application/
クライエント /(n) client/
クライオエレクトロニクス /(n) cryoelectronics/
クライオジーニクス /(n) cryogenics/
クライシス /(n) crisis/(P)/
クライシスマネージメント /(n) crisis management/
クライストロン /(n) klystron/
クライスラー /(n) Chrysler/(P)/
クライテリア /(n) criteria/
クライト /(n) krait/
クライマー /(n) climber/
クライマックス /(n) climax/(P)/
クライミング /(n) climbing/(P)/
クライムストーリー /(n) crime story/(P)/
クライモグラフ /(n) climograph/
クラインの壺 [クラインのつぼ] /(n) Klein bottle/
クラインフェルター症候群 [クラインフェルターしょうこうぐん] /(n) Klinefelter's syndrome/
クラウチ /(n) crouch/
クラウチングスタート /(n) crouching start/
クラウチングスタイル /(n) crouching style/
クラウディングアウト /(n) crowding out/
クラウド /(n) (1) cloud/(2) crowd/
クラウン /(n) crown/(P)/
クラウン・ローチ /(n) clown loach (Chromobotia macracanthus)/tiger botia/
クラウンエーテル /(n) crown ether/
クラウンギア /(n) crown gear/
クラウンギヤ /(n) crown gear/
クラウンゴール /(n) crown gall/
クラウントビー /(n) clown toado (Canthigaster callisterna)/clown toby/
クラウンロースト /(n) crown roast/
クラウンローチ /(n) clown loach (Chromobotia macracanthus)/tiger botia/
クラウン硝子 [クラウンガラス] /(n) (uk) crown glass/
クラカケアザラシ /(n) (uk) ribbon seal (Histriophoca fasciata)/
クラカケザメ /(n) saddle carpetshark (Cirrhoscyllium japonicum, species found in Japan)/
クラカケザメ科 [クラカケザメか] /(n) Parascylliidae (family of collared carpet sharks containing 8 species and 2 genera)/
クラカケザメ属 [クラカケザメぞく] /(n) Cirrhoscyllium (genus of collared carpet sharks in the family Parascylliidae)/
クラカケチョウチョウウオ /(n) Philippine butterflyfish (Chaetodon adiergastos)/panda butterflyfish/
クラカケトラザメ /(n) slender catshark (Schroederichthys tenuis, found off Suriname and Brazil)/
クラカケトラザメ属 [クラカケトラザメぞく] /(n) Schroederichthys (genus of catshark in the family Scyliorhinidae)/
クラカケモンガラ /(n) (uk) blackbelly triggerfish (Rhinecanthus verrucosus)/
クラクション /(n) Klaxon/car horn/(P)/
クラゲ /(n) (1) (uk) jellyfish/(2) medusa/
クラサバ /(n) (abbr) client server/
クラシカル /(adj-na,n) classical/(P)/
クラシシズム /(n) classicism/
クラシック /(n) (1) (abbr) classical music/(adj-na) (2) classic/classical/(n) (3) (the) classics/(P)/
クラシックカー /(n) classic car/
クラシックギター /(n) classic guitar/
クラシックパンツ /(n) loin cloth (wasei: classic pants)/
クラシックライフ /(n) classic life/
クラシックレース /(n) classic races/
クラシックロック /(n) classic rock/
クラシック音楽 [クラシックおんがく] /(n) classical music/(P)/
クラシファイア /(n) classifier/
クラシフィケイション /(n) classification/
クラス /(n) class/(P)/
クラスＡＩＰアドレス [クラスエーアイピーアドレス] /(n) (comp) class A IP address/
クラスＢＩＰアドレス [クラスビーアイピーアドレス] /(n) (comp) class B IP address/
クラスＣＩＰアドレス [クラスシーアイピーアドレス] /(n) (comp) class C IP address/
クラスＩＤ [クラスアイディー] /(n) (comp) class ID/
クラスアクション /(n) class action/
クラスセレクタ /(n) (comp) class selector/
クラスタ /(n) cluster/
クラスター /(n) cluster/
クラスター爆弾 [クラスターばくだん] /(n) cluster bomb/
クラスター分析 [クラスターぶんせき] /(n) cluster analysis/
クラスタアダプタ /(n) (comp) cluster adapter/
クラスタサイズ /(n) (comp) cluster size/
クラスタリング /(n) (comp) clustering/
クラスタ化されたアプリケーション [クラスタかされたアプリケーション] /(n) (comp) clustered applications/
クラスタ装置 [クラスタそうち] /(n) (comp) clustered device/
クラスタ番号 [クラスタばんごう] /(n) (comp) cluster number/
クラスト /(n) crust/
クラスファクトリ /(n) (comp) class factory/
クラスプ /(n) clasp/
クラスマガジン /(n) class magazine/
クラスメート /(n) classmate/(P)/
クラスメイト /(n) classmate/(P)/
クラスメディア /(n) class media/
クラスライブラリ /(n) (comp) class library (as in C++)/
クラスルーム /(n) classroom/
クラス会 [クラスかい] /(n) class reunion/
クラス階層 [クラスかいそう] /(n) (comp) class hierarchy/
クラス替え [クラスがえ] /(n) (school) class change/class shuffle/rearrangement of which students are in which teachers class/
クラッカ /(n) (comp) cracker/
クラッカー /(n) cracker/(P)/
クラッキング /(n) (comp) cracking/
クラック /(n) crack/(P)/
クラッシク /(n) (1) (abbr) classical music/(adj-na) (2) classic/classical/(n) (3) (the) classics/
クラッシック /(n) (1) (abbr) classical music/(adj-na) (2) classic/classical/(n) (3) (the) classics/(P)/
クラッシック音楽 [クラッシックおんがく] /(n) classical music/
クラッシャー /(n) (1) crusher/(2) crasher/
クラッシュ /(n,vs) crash/(P)/
クラッシュシンドローム /(n) crush syndrome/
クラッシュ回復 [クラッシュかいふく] /(n) (comp) crash recovery/
クラッシュ症候群 [クラッシュしょうこうぐん] /(n) crush syndrome/
クラッチ /(n) clutch/(P)/
クラッチバッグ /(n) clutch bag/
クラッチヒッター /(n) clutch hitter/
クラッチペダル /(n) clutch pedal/
クラッド /(n) (comp) clad/cladding (of a fiber)/
クラッド径 [クラッドけい] /(n) (comp) clad(ding) diameter/
クラドセラケ /(n) Cladoselache (genus of extinct shark)/
クラバー /(n) (comp) clobber/
クラビーア /(n) clavier/
クラビア /(n) clavier/
クラビアインキ /(n) gravure ink/
クラビコード /(n) clavichord/
クラフォード賞 [クラフォードしょう] /(n) Crafoord Prize/
クラフティ /(n) clafoutis (type of dessert) (fre:)/
クラフト /(n) craft/(P)/
クラフトデザイン /(n) craft design/
クラフトパルプ /(n) kraft pulp/
クラフトマン /(n) craftsman/
クラフトユニオン /(n) craft union/
クラフト紙 [クラフトし] /(n) craft paper/
クラブ /(n) (1) club (e.g. golf, tennis)/(2) clubs (card suit)/(3) crab/(P)/
クラブ /(n) (uk) club/fraternity/sorority/clubhouse/(P)/
クラブサン /(n) clavecin (fre:)/
クラブサンドイッチ /(n) club sandwich/
クラブチーム /(n) club team/
クラブハウス /(n) clubhouse/
クラブフェース /(n) club face (golf)/
クラブヘッド /(n) club head/
クラブ活動 [クラブかつどう] /(n) club activities (usu. clubs in association with a school)/extracurricular activities/(P)/
クラマスヤツメ /(n) Klamath river lamprey (Lampetra similis)/
クラミジア /(n) chlamydia (lat:)/
クラムチャウダー /(n) clam chowder/
クラリオネット /(n) clarionet/
クラリオン /(n) clarion/
クラリオンエンゼル /(n) clarion angelfish (Holacanthus clarionensis)/
クラリス /(n) (comp) Claris/
クラリティ /(n) clarity/
クラリティー /(n) clarity/
クラリネット /(n) clarinet/
クラレ /(n) curare/
クラレット /(n) claret/
クラン /(n) clan/(P)/
クランク /(n) crank/(P)/
クランクアップ /(n,vs) finish shooting (wasei: crank up)/
クランクイン /(n,vs) start (of) filming (wasei: crank in)/(P)/
クランクケース /(n) crankcase/
クランクシャフト /(n) crankshaft/
クランクバック /(n) (comp) crankback/
クランケ /(n) diseased persons (ger: Kranke)/
クランチ /(n) crunch/
クランプ /(n) clamp/
クランベリー /(n) cranberry/
クランベリーソース /(n) cranberry sauce/
クランポン /(n) crampon (fre:)/
クラヴィーア /(n) clavier/
クラヴィア /(n) clavier/
クラヴィコード /(n) clavichord/
クラヴサン /(n) clavecin (fre:)/
クリ /(n) (abbr) (vulg) clitoris/
クリ /(n) (uk) Japanese chestnut (Castanea crenata)/
クリーク /(n) (1) cleek (golf - type of fairway wood)/(2) creek/waterway, including irrigation or drainage canal/(3) clique/(4) creak/(P)/
クリーチャー /(n) creature/
クリート /(n) cleat/
クリーナー /(n) cleaner/(P)/
クリーニング /(n,vs) cleaning/dry cleaning/laundry service/(P)/
クリーネ /(n) Kleene/
クリーピングインフレ /(n) creeping inflation/
クリーピングインフレーション /(n) creeping inflation/
クリープ /(n) (1) creep/(2) Creap/
クリーベッジ /(n) cleavage/
クリーミー /(adj-na) creamy (in flavor or texture)/
クリーム /(n) cream/(P)/
クリームサンデー /(n) cream sundae/
クリームスキミング /(n) cream skimming/
クリームソース /(n) cream sauce/
クリームソーダ /(n) ice cream soda/icecream soda/
クリームチーズ /(n) cream cheese/
クリームパン /(n) cream-filled roll/
クリーム色 [クリームいろ] /(n) cream (colour, color)/
クリーン /(adj-na,n) clean/(P)/
クリーンアップ /(n) clean up (esp. baseball)/
クリーンアップトリオ /(n) cleanup trio (baseball)/(P)/
クリーンインストール /(n) (comp) clean install/
クリーンエネルギー /(n) clean energy/
クリーンナップ /(n) cleanup/
クリーンナップトリオ /(n) cleanup trio (baseball)/
クリーンヒーター /(n) vented heater/clean heater/
クリーンヒット /(n) clean hit/(P)/
クリーンビル /(n) clean bill/
クリーンフロート /(n) clean float/
クリーンブート /(n) (comp) clean boot/
クリーンライス /(n) clean rice/
クリーンルーム /(n) clean room (e.g. in semiconductor manufacturing)/cleanroom/
クリーンローン /(n) clean loan/
クリーヴァ /(n) cleaver/
クリちゃん /(n) clitoris/
クリア /(adj-na,vs) clear/
クリアー /(adj-na,vs) clear/
クリアエリア /(n) (comp) clear area/
クリアエントリー機能 [クリアエントリーきのう] /(n) (comp) clear entry function/
クリアキー /(n) (comp) Clear key/
クリアストーリー /(n) clerestory/clearstory/
クリアテキスト /(n) (comp) clear text/
クリアバンド /(n) (comp) clear band/
クリアビジョン /(n) Extended Definition Television (wasei: clear vision)/EDTV/
クリアラッカー /(n) clear lacquer/
クリアランス /(n) clearance/
クリアランスセール /(n) clearance sale/
クリアリングハウス /(n) (comp) clearing house/
クリエ /(n) (comp) Clie/CLIE/
クリエーション /(n) creation/
クリエータ /(n) (comp) creator/
クリエーター /(n) creator/(P)/
クリエーティビティー /(n) creativity/
クリエーティブ /(adj-na) creative/(P)/
クリエーティブエージェンシー /(n) creative agency/
クリエーティブグループ /(n) creative group/
クリエート /(n,vs) create/
クリエイター /(n) creator/inventor/developer/
クリエイティブ /(adj-na) creative/
クリエイティブコンテンツ /(n) (comp) creative content/
クリエイティヴ /(adj-na) creative/(P)/
クリエイト /(n,vs) create/
クリオール /(n) creole/(P)/
クリオネ /(n) clione/sea angel/
クリオメトリクス /(n) cliometrics/
クリケット /(n) cricket (game)/(P)/
クリケットクラブ /(n) cricket club/
クリコン /(n) (abbr) Christmas concert/
クリシェ /(n) cliche/
クリシギゾウムシ /(n) (uk) chestnut weevil (Curculio dentipes)/
クリシュナ /(n) Krishna/
クリスター /(n) klister (warm-weather ski wax)/
クリスタル /(n) crystal/(P)/
クリスタルガラス /(n) crystal glass/
クリスタルグラス /(n) crystal glass/
クリスタルフルーツ /(n) crystal fruit/
クリスタルマイクロフォン /(n) crystal microphone/
クリスタルマイクロホン /(n) crystal microphone/
クリスチャニア /(n) (1) Kristiania (ger:)/(2) Christiania/
クリスチャン /(n) Christian/(P)/
クリスチャンギャングスタラップ /(n) Christian gangsta rap/
クリスチャンサイエンス /(n) Christian Science/
クリスチャンネーム /(n) Christian name/
クリスチャンラップ /(n) Christian rap/
クリスチャンロック /(n) Christian rock/
クリスピー /(adj-na) crispy/
クリスプブレッド /(n) crisp bread/
クリスマス /(n) Christmas/(P)/
クリスマスイブ /(n) Christmas Eve/
クリスマスイヴ /(n) Christmas Eve/(P)/
クリスマスカード /(n) Christmas card/(P)/
クリスマスカロル /(n) Christmas carol/
クリスマスキャロル /(n) Christmas carol/
クリスマスケーキ /(n) Christmas cake/
クリスマスツリー /(n) Christmas tree/(P)/
クリスマスパーティ /(n) Christmas party/
クリスマスパーティー /(n) Christmas party/
クリスマスプレゼント /(n) Christmas present/
クリスマスリース /(n) Christmas wreath/
クリスマスローズ /(n) Christmas rose (Helleborus niger)/
クリスルス /(n) goldtail angelfish (Pomacanthus chrysurus)/earspot angelfish/
クリソツ /(n,adj-na) (sl) the spitting image of/identical/
クリソベリル /(n) chrysoberyl/
クリッカブルイメージマップ /(n) (comp) clickable imagemap/
クリッカブルマップ /(n) (comp) clickable map/
クリック /(n,vs) click/
クリックレート /(n) (comp) click rate/
クリック保証 [クリックほしょう] /(n) (comp) click guaranteed/
クリッパー /(n) clipper/
クリッパーチップ /(n) (comp) Clipper Chip/
クリッパートンエンジェルフィッシュ /(n) Clipperton angelfish (Holacanthus limbaughi)/
クリッピング /(n) clipping/
クリッピングパス /(n) (comp) clipping path/
クリップ /(n) clip/(P)/
クリップアート /(n) (comp) clip art/
クリップコレクション /(n) (comp) clip collection/
クリップボード /(n) clipboard/
クリップボードコンピュータ /(n) (comp) clipboard computer/
クリティーク /(n) critique/
クリティカル /(n,adj-na) critical/
クリティカルエラー /(n) (comp) critical error/
クリティカルエラーハンドラ /(n) (comp) critical-error handler/
クリティカルセクション /(n) (comp) critical section/
クリティカルパス /(n) critical path/
クリティカルパス法 [クリティカルパスほう] /(n) (comp) critical path method/
クリティシズム /(n) criticism/
クリティック /(n) critic/
クリト /(n) (abbr) (vulg) clitoris/
クリトリス /(n) clitoris/
クリニック /(n) clinic/(P)/
クリノメータ /(n) clinometer/
クリノメーター /(n) clinometer/
クリノリン /(n) crinoline/
クリパ /(n) (abbr) Christmas party/
クリビア /(n) clivia (lat:)/
クリプケ /(n) Kripke/
クリプト /(pref) crypto/
クリプトグラフィー /(n) cryptography/
クリプトコッカス症 [クリプトコッカスしょう] /(n) cryptococcosis/
クリプトスポリジウム /(n) Cryptosporidium/
クリプトン /(n) krypton (Kr)/
クリプトン８５ [クリプトンはちじゅうご] /(n) krypton-85/
クリプト藻 [クリプトそう] /(n) cryptophyte/
クリミア戦争 [クリミアせんそう] /(n) Crimean War (1853-1856)/
クリムソン /(n) crimson/
クリムソンレーキ /(n) crimson lake/
クリムゾン /(n) crimson/
クリモグラフ /(n) climograph/
クリヤー /(vs) to clear/
クリンカー /(n) clinker/
クリンカータイル /(n) clinker tile/
クリンゴン語 [クリンゴンご] /(n) Klingon (fictitious language)/
クリンチ /(n,vs) clinch/(P)/
クルー /(n) crew/(P)/
クルーカット /(n) crew-cut (type of haircut)/
クルーガーランド /(n) Krugerrand/
クルーザー /(n) cruiser (i.e. warship or cabin cruiser)/(P)/
クルージング /(n) cruising/(P)/
クルーズ /(n) cruise/(P)/
クルーセーダー /(n) (obsc) crusader/
クルーセード /(n) (obsc) Crusade/
クルーソ /(n) (comp) Crusoe/
クルーソー /(n) (comp) Crusoe/
クルーソックス /(n) crew socks/
クルートン /(n) crouton/
クルーナー /(n) crooner/
クルーネック /(n) crew neck (sweater)/
クループ /(n) croup/
クルーラー /(n) cruller/
クルアーン /(n,adj-no) Koran (ara: kuran)/Qur'an/Quran/the Islamic holy book/
クルス /(n) cross sign (por: cruz)/(P)/
クルックス管 [クルックスかん] /(n) Crookes tube/
クルップ /(n) croup/
クルトン /(n) crouton (fre:)/
クルド /(n) Kurd/Kurdish/(P)/
クルマバソウ /(n) (uk) sweet woodruff (Asperula odorata)/
クルマバツクバネソウ /(n) (uk) Paris verticillata (flowering plant closely related to herb Paris)/
クルミ科 [クルミか] /(n) Juglandaceae (plant family)/(common name) the walnut family/
クルミ目 [クルミもく] /(n) Juglandales (order of plants)/
クルムホルン /(n) krummhorn (ger: Krummhorn)/crumhorn/
クルルホルム /(n) chloroform/
クルルマイセチン /(n) Chloromycetin/
クルンジンガーズクロミス /(n) black-headed chromis (Chromis klunzingeri)/
クルンジンガーズラス /(n) Klunzinger's wrasse (Thalassoma rueppellii)/
クレー /(n) clay/(P)/
クレーコート /(n) clay court (tennis)/(P)/
クレージー /(adj-na) crazy/(P)/
クレーター /(n) crater/(P)/
クレートトレーニング /(n) crate training/housebreaking/house-training/
クレード /(n) clade/
クレードル /(n) (comp) cradle/
クレーピジョン /(n) clay pigeon/
クレープ /(n) crepe (fre:)/pancake/(P)/
クレープシャツ /(n) crepe shirt/
クレープデシン /(n) crepe de Chine/
クレープペーパー /(n) crape paper/
クレーマー /(n) claimer/claimant/
クレーム /(n) (1) customer complaint seeking compensation/claim (for compensation)/(2) (general) complaint/objection/(3) cream (fre: creme)/(P)/
クレームアングレーズ /(n) creme anglaise (fre:)/
クレームトークン /(n) (comp) claim token/
クレームブリュレ /(n) creme brulee (fre:)/
クレーム処理 [クレームしょり] /(n) handling complaints/
クレーン /(n) crane/(P)/
クレーン車 [クレーンしゃ] /(n) (mobile) crane/
クレー射撃 [クレーしゃげき] /(n) clay pigeon shooting/
クレアチニン /(n) creatinine/
クレアチニンクリアランス /(n) creatinine clearance/(P)/
クレアチン /(n) creatine/
クレアチン尿症 [クレアチンにょうしょう] /(n) creatinurea/creatinuria/
クレアチン燐酸 [クレアチンりんさん] /(n) creatine phosphate/
クレアトゥール /(n) creator (fre: createur)/
クレイ /(n) clay/(P)/
クレイジー /(n) crazy/
クレイモア /(n) claymore/
クレイワン /(n) (comp) CRAY-1/
クレオール /(n) (1) creole (pidgin which has become a mother tongue) (fre:)/(2) Creole (person of mixed ancestry, esp.in the Caribbean)/
クレオール語 [クレオールご] /(n) creole (pidgin that has become a mother tongue)/
クレオソート /(n) creosote/(P)/
クレオソート油 [クレオソートゆ] /(n) creosote oil/
クレオパトラの鼻 [クレオパトラのはな] /(exp,n) Cleopatra's nose/a small thing with a huge influence/
クレオメ /(n) cleome (esp. the spider flower, Cleome hassleriana) (lat:)/
クレシェンド /(n) crescendo (ita:)/
クレジット /(n) credit/(P)/
クレジットカード /(n) credit card/(P)/
クレジットカード会社 [クレジットカードがいしゃ] /(n) credit card company/
クレジットカード番号 [クレジットカードばんごう] /(n) credit card number/
クレジットカード与信照会用端末 [クレジットカードよしんしょうかいようたんまつ] /(n) (comp) CAT/Credit Authorization Terminal/
クレジットクランチ /(n) credit crunch/
クレジットタイトル /(n) credit title/
クレジットデリバティブ /(n) credit derivative/
クレジットファシリティ /(n) credit facility/
クレジットベース /(n) (comp) credit-based (flow control mechanism)/
クレジットホリック /(n) creditholic/
クレジットライン /(n) credit line/
クレジットリスク /(n) credit risk/
クレステッドホーンシャーク /(n) crested bullhead shark (Heterodontus galeatus, found in eastern Australia)/
クレセント /(n) crescent/
クレソン /(n) watercress (fre: cresson)/
クレゾール /(n) cresol (ger: Kresol)/
クレゾール石鹸液 [クレゾールせっけんえき] /(n) saponated cresol solution/
クレタケ /(n) (uk) Alternative name for henon bamboo (Phyllostachys nigra var. henonis)/
クレチン病 [クレチンびょう] /(n) cretinism/
クレッシェンド /(n) crescendo (ita:)/
クレッセント /(n) crescent/
クレディビリティーギャップ /(n) credibility gap/(P)/
クレド /(n) credo (lat:)/
クレバス /(n) crevasse (fre:)/
クレバネット /(n) cravenette/
クレパス /(n) (abbr) pastel crayons/
クレブス回路 [クレブスかいろ] /(n) Krebs cycle/
クレペリン /(n) Kraepelin/
クレマチス /(n) clematis (lat:)/
クレムリノロジー /(n) Kremlinology/
クレムリン /(n) Kremlin/(P)/
クレメモ /(n) (abbr) credit memo/
クレヨン /(n) crayon (fre:)/
クレリック /(n) cleric/
クレン /(n) (comp) CREN/
クレンザー /(n) cleanser/(P)/
クレンジング /(n,vs) cleansing/
クレンジングクリーム /(n) cleansing cream/(P)/
クレンジングフォーム /(n) cleansing foam/
クレンジングローション /(n) cleansing lotion/
クレンメ /(n) clamp (ger: Klemme)/forceps/
クローカス /(n) crocus/
クローク /(n) (abbr) cloakroom/checkroom/(P)/
クロークルーム /(n) cloakroom/
クローザー /(n) closer (baseball)/
クローシュ /(n) cloche (fre:)/
クロージャ /(n) closure/
クロース /(n,vs) (1) cross/(2) gross/(3) cloth/
クローズ /(n,vs) close/(P)/
クローズアップ /(n,vs) close-up/(P)/
クローズド /(n) closed/
クローズドアーキテクチャ /(n) (comp) closed architecture/
クローズドエンド /(n) closed-end/
クローズドエンドモーゲージ /(n) closed-end mortgage/
クローズドシステム /(n) closed system/
クローズドショップ /(n) closed shop/
クローズドショップ制 [クローズドショップせい] /(n) closed shop system (employment of only union members)/
クローズドスタンス /(n) closed stance/
クローズドポット /(n) closed pot/
クローズドモーゲージ /(n) closed mortgage/
クローズドユニオン /(n) closed union/
クローズボックス /(n) (comp) close box/
クローゼット /(n) closet/
クローナ /(n) krona (swe:, ice:)/
クローニング /(n) cloning/
クローヌス /(n) clonus/
クローネ /(n) krone (dan:, nor:)/
クローバー /(n) clover/
クローブ /(n) clove/
クローム /(n) chromium (Cr) (ger: Chrom, fre: chrome)/
クロームイエロー /(n) chrome yellow/
クローラー /(n) crawler (e.g. a web crawler or robot)/
クローリングペッグ /(n) crawling peg/
クロール /(n) crawl/(P)/
クローン /(n,adj-no) clone/(P)/
クローンメーカ /(n) (comp) clone maker/
クローン化 [クローンか] /(n,vs) cloning/
クローン技術 [クローンぎじゅつ] /(n) cloning technology/
クローン人間 [クローンにんげん] /(n) (human) clone/
クローン選択説 [クローンせんたくせつ] /(n) clonal selection theory/
クローン動物 [クローンどうぶつ] /(n) cloned animal/
クローン病 [クローンびょう] /(n) Crohn's disease/
クロアゲハ /(n) (uk) spangle (species of black swallowtail butterfly, Papilio protenor)/
クロアシアホウドリ /(n) (uk) black-footed albatross (Diomedea nigripes)/
クロアチア /(n) Croatia/(P)/
クロイサザアミ /(n) (obs) Neomysis awatschensis (shrimp)/
クロイスター /(n) cloister/
クロイツフェルトヤコブ病 [クロイツフェルトヤコブびょう] /(n) Creutzfeldt-Jakob disease/CJD/
クロウ /(n) crow/
クロウカード /(n) (uk) (m-sl) Clow Card/Clow Cards/
クロウシノシタ /(n) (uk) black cow-tongue (species of tonguefish, Paraplagusia japonica)/
クロウタドリ /(n) (uk) blackbird (Turdus merula)/
クロウメモドキ科 [クロウメモドキか] /(n) Rhamnaceae (plant family)/buckthorn/
クロウメモドキ目 [クロウメモドキもく] /(n) Rhamnales (order of plants)/
クロウラー /(n) (comp) (Web) crawler/
クロオオアリ /(n) (uk) Japanese carpenter ant (Camponotus japonicus)/
クロオビスズメダイ /(n) black-bar chromis (Chromis retrofasciata)/
クロオビチョウチョウウオ /(n) reef butterflyfish (Chaetodon sedentarius)/
クロカジキ /(n) (uk) Indo-Pacific blue marlin (Makaira mazara)/
クロカン /(n) (abbr) off-road vehicle (from cross-country)/
クロガラシ /(n) (uk) black mustard (Brassica nigra)/
クロキヅタ /(n) (uk) Caulerpa scalpelliformis (species of green alga)/
クロキンチャクダイ /(n) black angelfish (Chaetodontoplus niger)/
クロクビコブラ /(n) (uk) black-necked spitting cobra (Naja nigricollis)/
クログチニザ /(n) chocolate surgeonfish (Acanthurus pyroferus, Indo-Pacific species of tang)/mimic surgeonfish/orange-gilled surgeonfish/
クログワイ /(n) (1) (food) (uk) Eleocharis kuroguwai (species of spikerush)/(2) Chinese water chestnut (Eleocharis dulcis)/
クロケット /(n) (1) croquet/(2) croquette/
クロコショウ /(n) (uk) black pepper (Piper nigrum)/
クロコダイル /(n) crocodile/
クロコダイル・モニター /(n) crocodile monitor (Varanus salvadorii, species of carnivorous monitor lizard found in New Guinea)/Salvadori's monitor/Papua monitor/artellia/
クロコダイルモニター /(n) crocodile monitor (Varanus salvadorii, species of carnivorous monitor lizard found in New Guinea)/Salvadori's monitor/Papua monitor/artellia/
クロコン /(n) (abbr) cross-country skiing/
クロサイ /(n) (uk) black rhinoceros (Diceros bicornis)/
クロス /(n,vs) (1) cross/(2) gross/(3) cloth/(P)/
クロスアセンブラ /(n) (comp) cross assembler/
クロスエグザミネーション /(n) cross-examination/
クロスオーガニゼーション /(n) cross organization/
クロスオーバー /(n,vs) crossover/
クロスオーバーケーブル /(n) (comp) crossover cable/
クロスカウンター /(n) cross counter/
クロスカントリー /(n) (1) cross-country (skiing)/(2) (abbr) cross-country race/(P)/
クロスカントリースキー /(n) cross country skiing/
クロスカントリーレース /(n) cross-country race/
クロスキック /(n) cross kick (rugby)/
クロスグリ /(n) black-currant (Ribes nigrum)/cassis/
クロスケーブル /(n) (comp) crossover cable/
クロスゲーム /(n) close game/
クロスコネクト /(n) (comp) cross connect/
クロスコマンド /(n) (comp) XCMD/
クロスコンパイラ /(n) (comp) cross compiler/
クロスサイトスクリプティング /(n) (comp) cross-site scripting/
クロスシート /(n) cross seat/
クロスジイソハゼ /(n) Sebree's pygmy goby (Eviota sebreei)/
クロススティッチ /(n) cross-stitch/
クロスステッチ /(n) cross-stitch/
クロスズメダイ /(n) bowtie damselfish (Neoglyphidodon melas, species of Indo-West Pacific damselfish)/
クロスズメバチ /(n) (uk) Vespula flaviceps (species of yellowjacket)/
クロスセクション /(n) cross-section/
クロスセリング /(n) cross-selling/
クロスセル /(n) cross-selling (selling other products to a customer)/cross sell/
クロスチェック /(n) cross-check/
クロスチェックファン /(n) (comp) cross-checked fan/
クロストーク /(n) (comp) crosstalk/
クロストレーニング /(n) cross-training/
クロスニコル /(n) (abbr) crossed Nichol prism/
クロスハッチ /(n) (comp) cross hatch/
クロスバー /(n) crossbar/
クロスバー交換機 [クロスバーこうかんき] /(n) crossbar switchboard/
クロスバンカー /(n) cross bunker (golf)/
クロスファイア /(n) cross fire/
クロスフッティング /(n) (comp) crossfooting/
クロスプラットフォーム技術 [クロスプラットフォームぎじゅつ] /(n) (comp) cross-platform technology/
クロスプラットホーム /(n) (comp) cross-platform/
クロスプレー /(n) close play/
クロスヘッド /(n) crosshead/
クロスベルト /(n) crossed belt/
クロスボー /(n) crossbow/
クロスボーティング /(n) cross-voting/
クロスボウ /(n) crossbow/
クロスポイント /(n) (comp) crosspoint/
クロスポスト /(n) cross-post/
クロスライセンス /(n) cross-license/cross-licensing/
クロスランゲージ情報アクセス [クロスランゲージじょうほうアクセス] /(n) cross-language information access/
クロスランゲージ情報検索 [クロスランゲージじょうほうけんさく] /(n) (comp) cross-language information retrieval/CLIR/
クロスリファレンス /(n) (comp) cross reference/
クロスリファレンス形式 [クロスリファレンスけいしき] /(n,adj-no) (comp) (obsc) cross-referenced/
クロスレート /(n) cross rate/
クロスレファレンス /(n) cross-reference/
クロスワード /(n) crossword/(P)/
クロスワードパズル /(n) crossword puzzle/
クロス開発 [クロスかいはつ] /(n) (comp) cross development/
クロス集計 [クロスしゅうけい] /(n) (comp) cross tabulation/
クロス商い [クロスあきない] /(n) cross trade/
クロス積 [クロスせき] /(n) cross product/
クロゼット /(n) closet/
クロソイド /(n) clothoid/
クロソラスズメダイ /(n) dusky farmerfish (Stegastes nigricans, species of Indo-Pacific damselfish)/dusky gregory/
クロソラスズメダイ属 [クロソラスズメダイぞく] /(n) Stegastes (genus of damselfish in the family Pomacentridae)/
クロチョウガイ /(n) (uk) black-lip pearl oyster (Pinctada margaritifera)/
クロッカス /(n) crocus/
クロッキー /(n) sketch (fre: croquis)/rough draft/
クロッキー帳 [クロッキーちょう] /(n) (artist's) sketch pad/
クロッキング /(n) (comp) clocking/
クロック /(n) clock/(P)/
クロックアップ /(n) (comp) clock up/
クロックサイクル /(n) (comp) clock cycle/
クロックスピード /(n) (comp) clock speed/
クロックトラック /(n) (comp) clock track/
クロックパルス /(n) (comp) clock signal/clock pulse/
クロックレート /(n) (comp) clock rate/
クロック供給源 [クロックきょうきゅうげん] /(n) (comp) clock source/
クロック周波数 [クロックしゅうはすう] /(n) (comp) clock frequency/
クロック信号 [クロックしんごう] /(n) (comp) clock signal/clock pulse/
クロック速度 [クロックそくど] /(n) (comp) clock speed/clock frequency/clock rate/
クロック発振ロジック [クロックはっしんロジック] /(n) (comp) clock generation logic/
クロック分配 [クロックぶんぱい] /(n) (comp) clock (signal) distribution/
クロッケー /(n) croquet (fre:)/
クロッシングゾーン /(n) crossing zone/
クロップ /(n,vs) (comp) crop/
クロップドパンツ /(n) cropped pants/
クロツグミ /(n) (uk) Japanese thrush (Turdus cardis)/
クロテッドクリーム /(n) clotted cream/
クロテン /(n) (uk) sable (Martes zibellina)/
クロテングギンザメ /(n) Rhinochimaera africana (species of cartilaginous fish from the Southeast Atlantic)/
クロトウゾクカモメ /(n) (uk) parasitic jaeger/Arctic skua (Stercorarius parasiticus)/
クロトガリザメ /(n) (uk) silky shark (Carcharhinus falciformis, species of circumtropical requiem shark)/
クロトン /(n) croton (lat:)/
クロナマコ /(n) black sea cucumber (Holothuria atra)/
クロニクル /(n) chronicle/(P)/
クロネッカー /(n) Kronecker/
クロネッカーのデルタ /(n) Kronecker delta/
クロノ /(n) chrono/
クロノグラフ /(n) chronograph/
クロノスコープ /(n) chronoscope/(P)/
クロノバイオロジー /(n) chronobiology/
クロノメーター /(n) chronometer/
クロノロジー /(n) chronology/
クロハギ /(n) yellowfin surgeonfish (Acanthurus xanthopterus, Indo-Pacific species of tang)/
クロハギ属 [クロハギぞく] /(n) Acanthurus (type genus of surgeonfishes and tangs in the family Acanthuridae which have a pair of sharp spines on either side of the base of the tail)/
クロハコフグ /(n) spotted boxfish (Ostracion meleagris)/
クロバエ /(n) (uk) blowfly (excluding bluebottles and greenbottles)/
クロフウライチョウチョウウオ /(n) Indian vagabond butterflyfish (Chaetodon decussatus)/blackened butterflyfish/black-finned vagabond/
クロフサスグリ /(n) black-currant (Ribes nigrum)/
クロヘリメジロ /(n) (uk) copper shark (Carcharhinus brachyurus, only member of Carcharhinus found mostly at temperate latitudes)/bronze whaler/narrowtooth shark/
クロヘリメジロザメ /(n) (uk) copper shark (Carcharhinus brachyurus, only member of Carcharhinus found mostly at temperate latitudes)/bronze whaler/narrowtooth shark/
クロベ /(n) (uk) Japanese arborvitae (Thuja standishii)/
クロホシイソハゼ /(n) Smaragdus pygmy goby (Eviota smaragdus)/
クロホシマンジュウダイ /(n) (uk) spotted scat (Scatophagus argus, species of Indo-Pacific scat which occurs in green and red morphs)/green scat/red scat/
クロホシマンジュウダイ科 [クロホシマンジュウダイか] /(n) Scatophagidae (family containing 4 species in 2 genera of small Indo-Pacific fish commonly called scats which are known for eating feces)/
クロホシマンジュウダイ属 [クロホシマンジュウダイぞく] /(n) Scatophagus (genus of two species in the scats family Scatophagidae)/
クロホソオオトカゲ /(n) (uk) black tree monitor (Varanus beccarii, species of monitor lizard from the Aru Islands of eastern Indonesia)/Beccari's monitor/
クロマイ /(n) (abbr) chloromycetin/
クロマキー /(n) (comp) chroma key/
クロマクリア /(n) (comp) CROMACLEAR/
クロマクリア管 [クロマクリアかん] /(n) (comp) CromaClear Tube/
クロマチック /(adj-no,adj-na) chromatic/
クロマチン /(n) chromatin/
クロマトグラフィー /(n) chromatography/
クロマトグラム /(n) chromatogram/
クロマトロン /(n) chromatron/
クロマニョン /(n) Cro-Magnon/
クロマニョン人 [クロマニョンじん] /(n) Cro-Magnon man/
クロマルハナバチ /(n) (uk) Bombus ignitus (species of bumblebee)/
クロミスキネラセンス /(n) green puller (Chromis cinerascens)/green chromis/
クロミナンス /(n) (comp) chrominance/
クロミフェン /(n) clomiphene/
クロム /(n) chromium (Cr) (ger: Chrom, fre: chrome)/(P)/
クロムイエロー /(n) chrome yellow/
クロムグリーン /(n) chrome green (pigment made of chromium oxide, Cr2O3)/
クロムバナジウム鋼 [クロムバナジウムこう] /(n) chrome-vanadium steel/
クロムモリブデン鋼 [クロムモリブデンこう] /(n) chromium molybdenum steel/chrome molybdenum steel/
クロム鋼 [クロムこう] /(n) chrome steel/chromium steel/
クロム酸 [クロムさん] /(n) chromic acid/
クロム酸カリウム [クロムさんカリウム] /(n) potassium chromate/
クロム酸鉛 [クロムさんなまり] /(n) lead chromate (PbCrO4)/
クロム酸塩 [クロムさんえん] /(n) chromate/
クロム酸混液 [クロムさんこんえき] /(n) potassium dichromate-sulfuric acid solution/
クロム中毒 [クロムちゅうどく] /(n) chromium poisoning/
クロム鉄鉱 [クロムてっこう] /(n) chromite/
クロム明礬 [クロムみょうばん] /(n) chrome alum/
クロム鞣 [クロムなめし] /(n) tanning using chromium compounds (i.e. potassium dichromate, etc.)/
クロメクラウナギ /(n) brown hagfish (Eptatretus atami, species found in Japan)/
クロモ /(n) (1) (uk) hydrilla (species of aquatic plant, Hydrilla verticillata)/(2) Papenfussiella kuromo (species of brown algae)/
クロモンガラ /(n) pinktail durgon (durgeon) (triggerfish) (Melicthys vidua)/
クロモンツキ /(n) epaulette surgeonfish (Acanthurus nigricauda, Indo-Pacific species of tang)/blackstreak surgeonfish/
クロヤマアリ /(n) (uk) Japanese wood ant (Formica japonica)/
クロラール /(n) chloral (CCl3CHO)/trichloroethanal/
クロライチョウ /(n) (uk) black grouse (Tetrao tetrix)/blackcock (male black grouse)/greyhen (female black grouse)/
クロラミン /(n) chloramine/
クロラムフェニコール /(n) chloramphenicol/
クロルテトラサイクリン /(n) chlortetracycline/
クロルデン /(n) chlordane/
クロルピクリン /(n) chlorpicrin/
クロルプロマジン /(n) chlorpromazine/
クロルヘキシジン /(n) chlorhexidine/
クロレラ /(n) chlorella (alga) (lat:)/(P)/
クロロアセトフェノン /(n) chloroacetophenone/
クロロキン /(n) chloroquine/
クロロシス /(n) chlorosis/
クロロジフェニルアルシン /(n) chlorodiphenylarsine/
クロロピクリン /(n) chloropicrin/
クロロフィル /(n) chlorophyll/
クロロフルオロカーボン /(n) chlorofluorocarbon/CFC/
クロロプレン /(n) chloroprene/
クロロプレンゴム /(n) chloroprene rubber/
クロロベンゼン /(n) chlorobenzene/
クロロホルム /(n) chloroform/
クロロマイセチン /(n) chloromycetin/chloramphenicol/
クロワッサン /(n) croissant (fre:)/
クロン /(n) clone/
クワーティ /(n) (comp) qwerty/
クワイ /(n) (uk) Sagittaria trifolia var. edulis (edible variant of threeleaf arrowhead)/
クワイア /(n) choir/(P)/
クワガタ /(n) (1) hoe-shaped helmet crest/(2) (abbr) (uk) stag beetle/
クワガタムシ /(n) (uk) stag beetle/
クワキジラミ /(n) (uk) mulberry psyllid (Anomoneura mori)/
クワシオルコール /(n) kwashiorkor/
クワス /(n) kvass (fermented beverage resembling beer but made from rye or barley) (rus:)/
クワッガ /(n) quagga (extinct South African zebra) (Equus quagga quagga)/
クワドラント /(n) (comp) quadrant/
クワドラントカードスロット /(n) (comp) quadrant card slot/
クワルテット /(n) quartet (ita: quartetto)/(P)/
クワ科 [クワか] /(n) Moraceae (plant family)/mulberry/
クンクン /(n,adv,vs) (on-mim) sniff/
クンクン鳴く [クンクンなく] /(exp,v5k) to whine (of a dog)/
クンニ /(n) (abbr) cunnilingus/
クンニリングス /(n) cunnilingus/
ク活用 [クかつよう] /(n) classical form of i-adjective inflection (easily recognized by its attributive form ending in "ki" and predicative form ending in "shi")/
ク語法 [クごほう] /(n) creating a noun by affixing "ku" to the end of an inflectable word (i.e. "omowaku", "osoraku", etc.)/
グー /(adj-na) (1) good/(n) (2) goo/(3) rock (in rock-paper-scissors game)/(4) (col) fist/(P)/
グーグー /(adv,adv-to,vs) (1) snoring/(2) growling (low rumbling sound)/
グーグル /(n) (comp) Google (WWW search engine)/
グーグル八分 [グーグルはちぶ] /(n) (of a website) being delisted or censored by the Google search engine/
グースカ /(adv) soundly (of sleeping)/(sleeping) like a log/
グーズベリー /(n) gooseberry bush/
グータラ /(n,adj-na,adj-no) lazybones/good-for-nothing/idler/
グーテンモルゲン /(exp) good morning (ger: Guten Morgen)/
グーラグ /(n) Gulag (Soviet Union labor camp from 1930-1955)/
グーラッシュ /(n) goulash/
グーラミ /(n) gourami/
グーラミー /(n) gourami/
グール /(n) ghoul/(P)/
グールマン /(n) gourmand/
グールメ /(n) gourmet/
グール朝 [グールちょう] /(n) Ghurid Dynasty (of south Asia, approx. 1148-1215 CE)/
グーローシェーディング /(n) (comp) Gouraud shading/
グーングニル /(n) Gungnir (spear of Odin)/
グァテマラ /(n) Guatamala/
グァム /(n) Guam/
グアーガム /(n) guar gum/
グアテマラ /(n) Guatamala/(P)/
グアテマラ共和国 [グアテマラきょうわこく] /(n) Republic of Guatemala/(P)/
グアドループ島 [グアドループとう] /(n) Guadeloupe (island)/
グアナコ /(n) guanaco/
グアニジン /(n) guanidine/
グアニル酸 [グアニルさん] /(n) guanylic acid/
グアニン /(n) guanine/
グアノ /(n) guano/
グアノシン /(n) guanosine/
グアノシン三燐酸 [グアノシンさんりんさん] /(n) guanosine triphosphate/GTP/
グアバ /(n) guava/
グアム /(n) Guam/(P)/
グアム島 [グアムとう] /(n) Guam (island)/
グアヤク /(n) guaiacum/
グアヤコール /(n) guaiacol/
グイ /(adv-to) (on-mim) with a jerk/
グイッ /(adv-to) (on-mim) with a jerk/
グイッと呷る [グイッとあおる] /(exp,v5r) (uk) (vulg) to down another drink/to belt/
グェノン /(n) guenon (any Old World monkey of genus Cercopithecus)/
グエノン /(n) guenon (any Old World monkey of genus Cercopithecus)/
グエン朝 [グエンちょう] /(n) Nguyen Dynasty (Vietnam; 1802-1945)/
グキグキ /(adv,n,vs) (1) throbbing pain/(2) jerkily/awkwardly/
ググる /(v5r) (sl) to Google (i.e. to search for on the WWW using the Google search engine)/
ググル /(n) (comp) Google (WWW search engine)/
グシャグシャ /(adv-to,adv,adj-na,vs) (on-mim) soggy/mushy/crumpled/
グスベリー /(n) gooseberry/
グチグチ /(n,vs) (1) to mumble/to mutter/(2) to complain (continuously) about something/
グッジョブ /(int) (col) good job/
グッズ /(n) goods/promotional items/(P)/
グッタペルカ /(n) guttapercha (may:)/
グッチ /(n) Gucci/
グッド /(adj-na,n) good/(P)/
グッドアイディア /(n) good idea/
グッドアフターヌーン /(n) good afternoon/
グッドイヤー /(n) Goodyear/
グッドウィル /(n) good will/
グッドジョブ /(int) (col) good job/
グッドタイミング /(n) good timing/
グッドデザイン /(n) good design/
グッドデザインマーク /(n) good design mark/
グッドナイト /(exp) good night/
グッドバイ /(exp) goodby/goodbye/
グッドモーニング /(exp) good morning/
グッドラック /(int) Good luck/
グッドルッキング /(adj-f) good-looking/
グッドルックス /(n) good looks/
グッピー /(n) guppy/
グッモーニン /(int) G'morning/Good morning/
グニュー /(n) (comp) GNU (computer OS, project, etc.)/
グヌー /(n) (comp) GNU (computer OS, project, etc.)/
グノーシス /(n) gnosis (gre:)/
グノーシス主義 [グノーシスしゅぎ] /(n) gnosis/Gnosticism/
グプタ /(n) Gupta (dynasty of India, approx. 320-600 CE)/
グプタ朝 [グプタちょう] /(n) Gupta dynasty (of India, approx. 320-600 CE)/
グミ /(n) (uk) oleaster (any plant of genus Elaeagnus)/silverberry (US)/
グミ /(n) gummi (ger:)/gummi candy/gummi drop/
グミベア /(n) gummi bear/gummy bear/
グヤーシュ /(n) goulash/
グラーフ卵胞 [グラーフらんぽう] /(n) Graafian follicle/
グラーフ濾胞 [グラーフろほう] /(n) (obsc) Graafian follicle/
グラーベ /(n) (1) grave (tempo indication in music) (ita:)/(2) grave (accent in French, etc.)/
グラーヴェ /(n) (1) grave (tempo indication in music) (ita:)/(2) grave (accent in French, etc.)/
グライコ /(n) (abbr) graphic equalizer/graphic equaliser/(P)/
グライダー /(n) glider/(P)/
グライディング /(n) gliding/
グライドパス /(n) glide path/
グラインダー /(n) grinder/
グラインド /(n) grind/
グラウコーマ /(n) glaucoma/
グラウチング /(n) grouting/
グラウト /(n) grout/grouting (cement between tile squares)/
グラウンダー /(n) grounder/
グラウンド /(n) sports ground/sports oval/(P)/
グラウンドキーパー /(n) groundkeeper/
グラウンドシーツ /(n) groundsheet/
グラウンドストローク /(n) ground stroke/
グラウンドスマッシュ /(n) ground smash (tennis)/
グラウンドゼロ /(n) ground zero/
グラウンドパルプ /(n) ground pulp/
グラウンドホステス /(n) ground hostess/
グラウンドホッグ /(n) groundhog/
グラウンドボーイ /(n) bat boy/ground boy/
グラウンドマナー /(n) ground manners/
グラウンドルール /(n) ground rule/
グラウンドレスリング /(n) ground wrestling/
グラウンドワーク /(n) groundwork/
グラグ /(n) Gulag (Soviet Union labor camp from 1930-1955)/
グラゴル /(n) Glagolitic/
グラサン /(n) (abbr) (sl) sunglasses/
グラジオラス /(n) gladiolus/
グラス /(n) (1) glass/(2) grass/(P)/
グラスウール /(n) glass wool/
グラスゲージ /(n) glass gauge/
グラスコート /(n) grass court/
グラスジョー /(n) glass jaw/
グラススキー /(n) (1) glass fiber ski/glass fibre ski/(2) grass ski/
グラスステージ /(n) glass stage/
グラスノスチ /(n) glasnost (rus:)/(P)/
グラスハープ /(n) glass harp/
グラスハーモニカ /(n) glass harmonica/
グラスファイバー /(n) glass fiber/glass fibre/(P)/
グラスファイバーポール /(n) glass fiber pole/glass fibre pole/
グラスフィッシュ /(n) Asiatic glassfish (e.g. the Indian glassy fish, Parambassis ranga)/
グラスホッパー /(n) grasshopper/
グラスボート /(n) glass boat/
グラスリスト /(n) Generally Recognized as Safe list (Recognised)/GRAS list/
グラスルートデモクラシー /(n) grassroots democracy/
グラスロッド /(n) glass fiber rod/glass fibre rod/
グラスワーク /(n) glass work/
グラスワイン /(n) glass of wine (wasei: glass wine)/
グラタン /(n,adj-no) gratin (fre:)/(P)/
グラチェ /(exp) thank you (ita: grazie)/(P)/
グラッシ /(n) glacis (fre:)/
グラッセ /(n) glace (fre:)/
グラッパ /(n) grappa (ita:)/
グラデーション /(n) gradation/(P)/
グラディウス /(n) gladius/
グラディエーター /(n) gladiator/
グラディエント /(n) gradient/
グラドル /(n) (col) (abbr) bikini model (usually teenage) (wasei: gravure idol)/pin-up girl/
グラニット /(n) granite/
グラニュー /(n) granulated (sugar)/
グラニュー糖 [グラニューとう] /(n) granulated sugar/
グラニュライト /(n) granulite/
グラニュラリティ /(n) (comp) granularity/
グラノーラ /(n) granola/
グラハムブレッド /(n) graham bread/
グラバーハンド /(n) (comp) grabber hand/
グラビア /(n) gravure/photogravure/rotogravure/gravure picture/(P)/
グラビアアイドル /(n) bikini model (usually teenage) (wasei: gravure idol)/pin-up girl/
グラビアページ /(n) gravure page/
グラビア印刷 [グラビアいんさつ] /(n) photogravure/
グラビトン /(n) graviton/
グラフ /(n) graph/(P)/
グラファイト /(n) graphite/
グラフィカ /(adj-na,n) graphical/
グラフィカル /(adj-na,n) graphical/
グラフィカルインターフェイス /(n) graphical interface/
グラフィカルカーネルシステム /(n) (comp) Graphical Kernel System/GKS/
グラフィカルユーザーインターフェース /(n) (comp) graphical user interface/
グラフィカルユーザーインターフェイス /(n) (comp) graphical user interface/
グラフィカルユーザインタフェース /(n) (comp) graphical user interface/GUI/
グラフィクス /(ik) (n) graphics/
グラフィクス装置 [グラフィクスそうち] /(n) (comp) graphics device/
グラフィクス中核系 [グラフィクスちゅうかくけい] /(n) (comp) GKS/graphical kernel system/
グラフィッカー /(n) (comp) artist (of computer game) (wasei: graphic-er)/
グラフィック /(n,adj-no) (1) graphic/(2) graphic magazine/pictorial magazine/
グラフィックアート /(n) graphic arts/
グラフィックアクセラレータ /(n) (comp) graphics accelerator/
グラフィックイコライザー /(n) graphic equalizer/graphic equaliser/
グラフィックエンジン /(n) (comp) graphic engine/
グラフィックカード /(n) (comp) graphics card/
グラフィックス /(n) graphics/(P)/
グラフィックスアクセラレータ /(n) (comp) graphics accelerator/
グラフィックスアダプタ /(n) (comp) graphics adapter/
グラフィックスカード /(n) (comp) graphics card/
グラフィックスコプロセッサ /(n) (comp) graphics coprocessor/
グラフィックスコントローラ /(n) (comp) Graphics Controller/
グラフィックスサブシステム /(n) (comp) graphics subsystem/
グラフィックスターミナル /(n) (comp) graphics terminal/
グラフィックスタブレット /(n) (comp) graphics tablet/
グラフィックスチップ /(n) (comp) graphics chip/
グラフィックスフォーマット /(n) (comp) graphics format/
グラフィックスプリンタ /(n) (comp) graphics printer/
グラフィックスプロセシングユニット /(n) (comp) graphics processing unit/GPU/
グラフィックスボード /(n) (comp) graphics board/
グラフィックスワークステーション /(n) (comp) graphics workstation/GWS/
グラフィックソフト /(n) (comp) graphics software/software for graphics/
グラフィックソフトウェア /(n) (comp) graphics software/software for graphics/
グラフィックタブレット /(n) (comp) graphic tablet/
グラフィックツール /(n) (comp) graphic(al) tool/
グラフィックディスプレー /(n) graphic display/graphics display/
グラフィックディスプレイ /(n) (comp) graphic display/
グラフィックデザイナー /(n) graphic designer/
グラフィックデザイン /(n) graphic design/
グラフィックフィルタ /(n) (comp) graphic filter/graphics filter/
グラフィックモード /(n) (comp) graphics mode/
グラフィック基本要素 [グラフィックきほんようそ] /(n) (comp) graphical primitive elements/
グラフィック基本要素の表示要相 [グラフィックきほんようそのひょうじようそう] /(n) (comp) aspects of primitives/
グラフィック文字 [グラフィックもじ] /(n) (comp) graphics character/
グラフィティ /(n) graffiti/
グラフィティー /(n) graffiti/
グラフイック /(n,adj-no) (1) graphic/(2) graphic magazine/pictorial magazine/(P)/
グラフエリア /(n) (comp) chart area/
グラフスライド /(n) (comp) chart slide/
グラフマッチング /(n) graph-matching/
グラフ理論 [グラフりろん] /(n) graph theory/
グラフ領域 [グラフりょういき] /(n) (comp) graph area/
グラブ /(n) (1) glove (esp. sports)/mitt/(2) grab/(P)/
グラブバケット /(n) grab bucket/
グラベル /(n) gravel/
グラマー /(adj-na,n) (1) glamour/glamor/glamour girl/glamor girl/(2) buxom/full-breasted/(3) grammar/(P)/
グラマーガール /(n) glamour girl/glamor girl/
グラマースクール /(n) grammar school/
グラマーストック /(n) glamour stock/glamor stock/
グラマトロジー /(n) grammatology/
グラマラス /(adj-na) glamorous/
グラミー /(n) Grammy (award)/(P)/
グラミー賞 [グラミーしょう] /(n) Grammy Awards/Grammy Award/
グラムイオン /(n) gram ion/
グラムカロリー /(n) gram-calorie/
グラムトン /(n) gram-ton/
グラム陰性菌 [グラムいんせいきん] /(n) gram-negative bacteria/
グラム原子 [グラムげんし] /(n) gram atom/
グラム重 [グラムじゅう] /(n) gram-weight/
グラム染色 [グラムせんしょく] /(n) gram stain/
グラム当量 [グラムとうりょう] /(n) gram equivalent/
グラム分子 [グラムぶんし] /(n) gram molecule/
グラム陽性菌 [グラムようせいきん] /(n) gram-positive bacteria/
グランジ /(n) grunge/
グランス /(n) glans (lat:)/(P)/
グランゼコール /(n) grandes ecoles (French elite tertiary education institutions)/
グランデ /(n) grand (ita: grande)/(P)/
グラント /(n) (1) grant/(2) grunt/
グラントエレメント /(n) grant element/
グランド /(n) (1) gland/(2) grand/(3) ground (e.g. land, electrical, base material of textiles, etc.)/(P)/
グランドオペラ /(n) grand opera/
グランドスタンド /(n) grandstand/
グランドスタンドプレー /(n) grandstand play/
グランドスラム /(n) grand slam/
グランドセール /(n) grand sale/
グランドツーリングカー /(n) grand touring car/
グランドデザイン /(n) grand design/
グランドピアノ /(n) grand piano/(P)/
グランドファイナル /(n) grand final/
グランドフィナーレ /(n) grand finale/
グランドホステス /(n) female airline staff working at airports (wasei: grand hostess)/
グランドメニュー /(n) main menu in a restaurant, as opposed to the lunchtime menu/
グランプリ /(n) Grand Prix (fre:)/(P)/
グランプリレース /(n) Grand Prix race/
グリー /(n) glee/
グリーキング /(n) (comp) greeking/
グリーク /(n) Greek/
グリークラブ /(n) glee club/(P)/
グリース /(n) grease/
グリースカップ /(n) grease cup/
グリースガン /(n) grease gun/
グリーティングカード /(n) greeting card/
グリーニズム /(n) greenism/
グリーン /(adj-na,n) green/environmentally friendly/(P)/
グリーン・スキャット /(n) green scat (green morph of the spotted scat, Scatophagus argus)/
グリーン・ネオン・テトラ /(n) green neon tetra (Paracheirodon simulans)/
グリーン・ファイヤー・テトラ /(n) green fire tetra (Aphyocharax rathbuni)/redflank bloodfin/
グリーンＰＣ [グリーンピーシー] /(n) (comp) environmentally friendly computer (e.g. low power consumption) (wasei: green PC)/
グリーンアーキテクチャー /(n) green architecture/
グリーンアスパラガス /(n) green asparagus/
グリーンアノール /(n) green anole (Anolis carolinensis)/
グリーンイグアナ /(n) green iguana (Iguana iguana)/
グリーンエージ /(n) green age/
グリーンカード /(n) (1) green card (United States Permanent Resident Card)/(2) green card (international insurance certificate for United Kingdom motorists)/
グリーンカール /(n) var. of lettuce with curled leaves (wasei: green curl)/
グリーンクロミス /(n) green chromis (Chromis caerulea)/blue-green chromis/
グリーンコーディネーター /(n) green coordinator/
グリーンサラダ /(n) green salad/
グリーンスキャット /(n) green scat (green morph of the spotted scat, Scatophagus argus)/
グリーンスクール /(n) green school/(P)/
グリーンタフ /(n) green tuff/
グリーンツーリズム /(n) taking a relaxed holiday in a rural area (wasei: green tourism)/
グリーンティー /(n) green tea/
グリーンテクノロジー /(n) green technology/
グリーンネオンテトラ /(n) green neon tetra (Paracheirodon simulans)/
グリーンハウス /(n) greenhouse/
グリーンバードマウスラス /(n) green birdmouth wrasse (Gomphosus caeruleus)/checkerboard wrasse/Indian Ocean bird wrasse/
グリーンバック /(n) greenback/
グリーンピース /(n) (1) green peas/(2) Greenpeace/(P)/
グリーンファイヤーテトラ /(n) green fire tetra (Aphyocharax rathbuni)/redflank bloodfin/
グリーンフィー /(n) green fee/(P)/
グリーンブック /(n) (comp) Green Book/
グリーンベルト /(n) green belt/
グリーンベレー /(n) green beret/
グリーンボーイ /(n) green boy/
グリーンメーラー /(n) greenmailer/
グリーンメール /(n) greenmail/
グリーンランド /(n) Greenland/(P)/
グリーンランド島 [グリーンランドとう] /(n) Greenland/
グリーンリーフ /(n) green leaf/
グリーンレート /(n) green rate/
グリーンレボリューション /(n) green revolution/
グリーン券 [グリーンけん] /(n) green (car) ticket/
グリーン車 [グリーンしゃ] /(n) green car (1st class)/
グリア細胞 [グリアさいぼう] /(n) glial cell/glia/neuroglia/
グリオ /(n) Griot/Jeli/type of African poet or bard/
グリオー /(n) Griot/Jeli/type of African poet or bard/
グリオキシソーム /(n) glyoxysome/
グリオキシル酸回路 [グリオキシルさんかいろ] /(n) glyoxylate cycle/
グリグリ /(adv,n,vs) (1) (on-mim) grinding against/rubbing with turning movements (e.g. shoulders)/(2) hard lump under the skin (e.g. an adipous tumor or lymph node tumor)/(3) big and round eyes/googly eyes/(4) rattling sound/
グリグリ目玉 [グリグリめだま] /(n) big and round eyes/googly eyes/
グリコーゲン /(n) glycogen/(P)/
グリコール /(n) glycol/
グリコール酸 [グリコールさん] /(n) glycolic acid/
グリコシダーゼ /(n) glycosidase/
グリコシド /(n) glycoside/
グリシン /(n) glycine/
グリス /(n) grease/
グリズリー /(n) (1) (obsc) grizzly bear (Ursus arctos horribilis)/(2) brown bear (Ursus arctos)/
グリズリーベア /(n) (obsc) grizzly bear (Ursus arctos horribilis)/
グリセード /(n) glissade/
グリセオフルビン /(n) griseofulvin/
グリセリド /(n) glyceride/
グリセリン /(n) glycerin/glycerol/
グリセリン酸 [グリセリンさん] /(n) glyceric acid/
グリセルアルデヒド /(n) glyceraldehyde/
グリセロール /(n) glycerol/
グリッサンド /(n) glissando (ita:)/
グリッシーニ /(n) grissini (ita:)/
グリッチ /(n) (comp) glitch/
グリッディング /(n) gridding/
グリット /(n) (1) grit/(2) grid/
グリッド /(n) grid/
グリッドコンピューティング /(n) (comp) grid computing/
グリッドバイアス /(n) grid bias/
グリッドパターン /(n) (comp) grid pattern/
グリッドプラニング /(n) grid planning/
グリッドプラン /(n) grid plan/
グリップ /(n) grip/(P)/
グリニジ時 [グリニジじ] /(n) (obsc) Greenwich Time/
グリニッジ /(n) Greenwich (Mean Time)/(P)/
グリニッジ時 [グリニッジじ] /(n) (obsc) Greenwich Time/
グリニッジ標準時 [グリニッジひょうじゅんじ] /(n) Greenwich mean time/
グリニッジ平均時 [グリニッジへいきんじ] /(n) (obsc) Greenwich Mean Time/GMT/
グリフ /(n) (comp) glyph/
グリフィスエンジェルフィッシュ /(n) Griffis angelfish (Apolemichthys griffisi)/
グリフォン /(n) griffon/
グリフ形状 [グリフけいじょう] /(n) (comp) glyph shape/
グリフ座標系 [グリフざひょうけい] /(n) (comp) glyph coordinate system/
グリフ手続き [グリフてつづき] /(n) (comp) glyph procedure/
グリフ手続きインタプリタ [グリフてつづきインタプリタ] /(n) (comp) glyph procedure interpreter/
グリフ集合 [グリフしゅうごう] /(n) (comp) glyph collection/
グリフ像 [グリフぞう] /(n) (comp) glyph image/
グリフ配置量 [グリフはいちりょう] /(n) (comp) glyph metrics/
グリフ表現 [グリフひょうげん] /(n) (comp) glyph representation/
グリムの法則 [グリムのほうそく] /(n) Grimm's law/
グリモア /(n) grimoire/manual of black magic/book of magic and spells/
グリモワール /(n) grimoire/manual of black magic/book of magic and spells/
グリュイエール /(n) gruyere (fre:)/
グリル /(n) grill/(P)/
グリルカバー /(n) (comp) grill cover/
グリルコネクタ /(n) (comp) grill-mounted connector/grill-mounting connector/
グリルドチーズサンド /(n) grilled cheese sandwich/grilled cheese/
グリルドチーズサンドイッチ /(n) grilled cheese sandwich/grilled cheese/
グリンゴ /(n) gringo (spa:)/
グリンピース /(n) (1) green peas/(2) Greenpeace/(P)/
グリンプス /(n) glimpse/
グルー /(n) glue/(P)/
グルーオン /(n) gluon/
グルービー /(n) groovy/
グルーピー /(n) groupie/
グルーピング /(n,vs) grouping/
グルーピングエフェクト /(n) grouping-effect/
グループ /(n) group (usu. of people)/(P)/
グループ１動詞 [グループいちどうし] /(n) godan verb/
グループ２動詞 [グループにどうし] /(n) ichidan verb/type II verb/
グループＩＤ [グループアイディー] /(n) (comp) group identifier/GID/
グループアドレス /(n) (comp) group address/
グループインタビュー /(n) group interview/
グループウィンドウ /(n) (comp) group box/group window/
グループウェア /(n) (comp) groupware/
グループウエア /(n) groupware/
グループケア /(n) group care/
グループコミット /(n) (comp) group commit/
グループサウンズ /(n) rock band (wasei: group sounds)/
グループダイナミックス /(n) group dynamics/
グループディスカッション /(n) group discussion/
グループホーム /(n) group home/(P)/
グループボックス /(n) (comp) group box/group window/
グループワーク /(n) group work/
グループ化 [グループか] /(n) (comp) grouping/
グループ見出し [グループみだし] /(n) group heading/
グループ作業 [グループさぎょう] /(n) group interaction/
グループ絶縁 [グループぜつえん] /(n) (comp) grouping isolation/
グループ同報 [グループどうほう] /(n) (comp) group broadcast/
グループ分離キャラクタ [グループぶんりキャラクタ] /(n) (comp) group separator/GS/
グループ料金制 [グループりょうきんせい] /(n) (comp) group rate system/
グルーマー /(n) groomer/
グルーミー /(adj-na) gloomy/
グルーミング /(n) grooming/
グルーヴ /(n) groove/
グルになる /(exp) to conspire/
グルイン /(n) (abbr) group interview/
グルオン /(n) gluon/
グルカ /(n) Gurkha/
グルカゴン /(n) glucagon/
グルクマ /(n) Indian mackerel (Rastrelliger kanagurta)/
グルクロン酸 [グルクロンさん] /(n) glucuronic acid/
グルコース /(n) glucose/
グルココルチコイド /(n) glucocorticoid/
グルコサミン /(n) glucosamine/
グルコシド /(n) glucoside/
グルジア /(n) Georgia (rus: Gruziya)/
グルジアソビエト社会主義共和国 [グルジアソビエトしゃかいしゅぎきょうわこく] /(n) (former) Georgian Soviet Socialist Republic/Georgian SSR/GSSR/
グルタチオン /(n) glutathione/
グルタミン /(n) glutamine/
グルタミン酸 [グルタミンさん] /(n) glutamic acid/
グルタミン酸ソーダ [グルタミンさんソーダ] /(n) monosodium glutamate/MSG/
グルタミン酸ナトリウム [グルタミンさんナトリウム] /(n) monosodium glutamate/MSG/sodium glutamate/
グルテリン /(n) glutelin/
グルテン /(n) gluten/
グルテンミール /(n) gluten meal/
グルデン /(n) gulden/
グルフコース /(ik) (n) golf course/
グルフバッグ /(ik) (n) golf bag/
グルマン /(n) gourmand (fre:)/
グルメ /(n) gourmet (fre:)/(P)/
グレー /(adj-na,n) (1) grey (gray)/(P)/
グレーイング /(n) graying/greying/
グレーエンジェルフィッシュ /(n) Gray angelfish (Pomacanthus arcuatus)/
グレーカラー /(n) gray-collar/grey-collar/
グレーコード /(n) (comp) gray code/
グレーシャー /(n) glacier/
グレースケール /(n) (comp) gray scale/
グレーズ /(n,vs) (1) glaze/(vs) (2) graze/
グレーゾーン /(n) gray zone/grey zone/(P)/
グレーダー /(n) grader/
グレート /(n) great/(P)/
グレート・ハンマーヘッド /(n) great hammerhead (Sphyrna mokarran, the largest species of hammerhead shark)/
グレートデン /(n) Great Dane (type of dog)/
グレートハンマーヘッド /(n) great hammerhead (Sphyrna mokarran, the largest species of hammerhead shark)/
グレートブリテン /(n) Great Britain/
グレード /(n) grade/(P)/
グレードアップ /(n,vs) upgrade (wasei: grade up)/update/
グレーハウンド /(n) greyhound/
グレーバー /(n) graver/
グレービー /(n) gravy/
グレービーシマウマ /(n) (uk) Grevy's zebra (Equus grevyi)/
グレービー縞馬 [グレービーしまうま] /(n) (uk) Grevy's zebra (Equus grevyi)/
グレービー斑馬 [グレービーしまうま] /(n) (uk) Grevy's zebra (Equus grevyi)/
グレープ /(n) grape/
グレープジュース /(n) grape juice/
グレープフルーツ /(n) grapefruit/(P)/
グレーユニコーンフィッシュ /(n) gray unicornfish (Naso caesius, species of Pacific tang)/
グレーン /(n) grain (1-7000 of a pound, approx. 64.80 mg)/
グレーンウイスキー /(n) grain whisky/
グレア /(n) (comp) glare/
グレアフィルタ /(n) (comp) glare filter/
グレイ /(adj-na,n) (1) grey (gray)/(2) gray (SI unit of absorbed dose of radiation)/(P)/
グレイ・リーフ・シャーク /(n) grey reef shark (Carcharhinus amblyrhynchos, species of Indo-Pacific requiem shark)/
グレイオオトカゲ /(n) Gray's monitor (Varanus olivaceus, species of carnivorous monitor lizard from Luzon and the Catanduanes Islands in the Philippines)/
グレイス /(n) grace/
グレイテールエンジェルフィッシュ /(n) Chaetodontoplus poliourus (species for marine angelfish)/
グレイビー /(n) gravy/
グレイブ /(n) grave/
グレイリーフシャーク /(n) grey reef shark (Carcharhinus amblyrhynchos, species of Indo-Pacific requiem shark)/
グレインウイスキー /(n) grain whisky/grain whiskey/
グレコローマン /(n) Greco-Roman (style of wrestling)/
グレコローマンスタイル /(n) Greco-Roman style/(P)/
グレゴリオ /(n) Gregorian (calendar)/(P)/
グレゴリオ聖歌 [グレゴリオせいか] /(n) Gregorian chant/
グレゴリオ暦 [グレゴリオれき] /(n) Gregorian calendar/
グレシャムの法則 [グレシャムのほうそく] /(n) Gresham's Law ("when there is a legal tender currency, bad money drives good money out of circulation")/
グレップ /(n) (comp) grep/
グレナダ /(n,adj-no) Grenada/
グレナダ島 [グレナダとう] /(n) Grenada (island of)/
グレナディンシロップ /(n) grenadine syrup/
グレネード /(n) grenade/
グレビーシマウマ /(n) Grevy's zebra (Equus grevyi)/
グレビー縞馬 [グレビーしまうま] /(n) Grevy's zebra (Equus grevyi)/
グレムリン /(n) gremlin/
グレンチェック /(n) glen check/
グロ /(adj-na,n) (abbr) grotesque/(P)/
グローサリー /(n) grocery/
グロースターター /(n) glow starter/
グロースティック /(n) glowstick/neon light stick/
グロースリセッション /(n) growth recession/
グローバライゼイション /(n) globalization/globalisation/
グローバリスト /(n) globalist/
グローバリズム /(n) globalism/(P)/
グローバリゼーション /(n) globalization/globalisation/
グローバル /(adj-na,n) global/(P)/
グローバルＩＰアドレス [グローバルアイピーアドレス] /(n) (comp) global IP address/
グローバルアドレス /(n) (comp) global address/
グローバルウォー /(n) global war/
グローバルグループ /(n) (comp) global group/
グローバルサプライチェーン /(n) global supply-chain/
グローバルスタンダード /(n) global standards/
グローバルデータ /(n) (comp) global data/
グローバルデフレ /(n) global deflation/
グローバルトランザクション /(n) (comp) global transaction/
グローバルネットワークアドレス領域 [グローバルネットワークアドレスりょういき] /(n) (comp) global network addressing domain/
グローバルパワー /(n) global powers/
グローバルビレッジ /(n) global village/
グローバルマーケット /(n) global market/
グローバルメモリプール /(n) (comp) global memory pool/
グローバルローミング /(n) (comp) global roaming/
グローバル化 [グローバルか] /(n,vs) globalization/(P)/
グローバル形式 [グローバルけいしき] /(n) (comp) global format/
グローバル検索 [グローバルけんさく] /(n) (comp) global search/
グローバル宣言 [グローバルせんげん] /(n) (comp) global declaration/
グローバル変数 [グローバルへんすう] /(n) (comp) global variable/
グローバル名称 [グローバルめいしょう] /(n) (comp) global-title/
グローブ /(n) (1) glove (esp. sports)/(2) globe/(P)/
グローブボックス /(n) glove box/glove compartment/
グローライト・テトラ /(n) glowlight tetra (Hemigrammus erythrozonus)/
グローライトテトラ /(n) glowlight tetra (Hemigrammus erythrozonus)/
グローランプ /(n) glow lamp/
グローリー /(n) glory (i.e. an anticorona)/
グローリア /(n) gloria (lat: gloria)/
グローヴ /(n) glove/
グロー放電 [グローほうでん] /(n) glow discharge/
グロー放電発光分光法 [グローほうでんはっこうぶんこうほう] /(n) glow discharge optical emission spectrometry/
グロい /(adj-i) (sl) grotesque/disgusting/gross/
グロキシニア /(n) gloxinia/
グログラン /(n) grosgrain (silk or silk-like fabric) (fre: gros-grain)/
グロス /(n) (a) gross/
グロスオプティマイザ /(n) (comp) gloss optimizer/
グロストン /(n) gross ton/
グロッキー /(adj-na,n) groggy/
グロッギー /(adj-na,n) groggy/
グロッグ /(n) grog/
グロッサリー /(n) glossary/
グロッシー /(n) glossy/
グロッソラリア /(n) glossolalia (the phenomenon of speaking in tongues)/
グロテスク /(adj-na,n) grotesque/(P)/
グロビュール /(n) globule/
グロビン /(n) globin/
グロブリン /(n) globulin/
グロメット /(n) grommet/
グロリア /(n) gloria (lat: gloria)/(P)/
グロリオーサ /(n) gloriosa (flower) (lat:)/
グワカモーレ /(n) guacamole (spa:)/
グワカモレ /(n) guacamole (spa:)/
グワッシュ /(n) (1) gouache (fre:)/
グンバイヒルガオ /(n) (uk) beach morning glory (Ipomoea pes-caprae)/
グンバイムシ /(n) (uk) lace bug (any insect of family Tingidae)/
ケ /(ctr) (read as "ka") counter for the ichi-ni-san counting system (usu. directly preceding the item being counted)/a noun read using its on-yomi/
ケーエーナインキュー /(n) (comp) KA9Q/
ケーオー /(n,vs) KO/knock-out/(P)/
ケーオス /(n) chaos/
ケーキ /(n) cake/(P)/
ケーキサーバー /(n) cake server/
ケーキ作り [ケーキづくり] /(n) cake making/
ケーゲル /(n) pubococcygeal muscle/Kegel muscle/
ケーゴーロクエックスツー /(n) (comp) K56x2/
ケーゴーロクフレックス /(n) (comp) K56flex/
ケーシックス /(n) (comp) K6/
ケージ /(n) cage/(P)/
ケージャン /(n) Cajun/
ケージャン料理 [ケージャンりょうり] /(n) Cajun food/
ケース /(n) (1) case (e.g. receptacle, condition, event, legal action, letter style, etc.)/(2) (comp) Computer-Aided Software Engineering/CASE/(P)/
ケースアース /(n) chassis ground (wasei: case earth)/frame ground/
ケースカンファレンス /(n) case conference/
ケーススタディ /(n) case study/
ケーススタディー /(n) case study/(P)/
ケースセンシティブ /(n) (comp) case-sensitive/
ケースバイケース /(exp) case-by-case/
ケースブック /(n) casebook/
ケースマネージメント /(n) case management/
ケースメソッド /(n) case method/
ケースワーカー /(n) caseworker/(P)/
ケースワーク /(n) casework/
ケーソン /(n) caisson/
ケーソン工法 [ケーソンこうほう] /(n) caisson method/(P)/
ケーソン病 [ケーソンびょう] /(n) caisson disease/
ケータイ /(n,vs,adj-no) (1) something carried (in the hand)/handheld/(n) (2) (abbr) (col) mobile telephone/cell phone/
ケータイ小説 [ケータイしょうせつ] /(n) cellphone novel/
ケータリング /(n) catering/
ケータリングサービス /(n) catering service/
ケードロ /(n) cops and robbers (hide-and-seek game)/
ケーナ /(n) quena (Andean flute) (spa:)/
ケーバン /(n) (col) (abbr) mobile phone number/
ケーパー /(n) caper (Capparis spinosa)/
ケーパビリティ /(n) capability/
ケービング /(n) caving/
ケーファイブ /(n) (comp) K5/
ケーブル /(n) cable/(P)/
ケーブルＴＶ [ケーブルティービー] /(n) (comp) cable television/
ケーブルとアース線の配置 [ケーブルとアースせんのはいち] /(n) (comp) arrangement of cables and ground wires/
ケーブルの再工事 [ケーブルのさいこうじ] /(n) (comp) recabling/
ケーブルの切断 [ケーブルのせつだん] /(n) (comp) cable cut/
ケーブルアセンブリ /(n) (comp) cable assembly/
ケーブルインターネット /(n) cable internet/
ケーブルオペレータ /(n) (comp) cable operator/
ケーブルカー /(n) cable car/
ケーブルキット /(n) (comp) cable kit/cabling kit/
ケーブルクランプ /(n) (comp) cable clamp/
ケーブルコネクタ /(n) (comp) cable connector/
ケーブルサービスプロバイダ /(n) (comp) global service provider/
ケーブルセレクト /(n) (comp) cable select/
ケーブルテレビ /(n) cable television/
ケーブルテレビジョン /(n) cable television/
ケーブルマッチャー /(n) (comp) cable matcher/
ケーブルマネージャ /(n) (comp) cable manager/
ケーブルモデム /(n) (comp) cable modem/
ケーブルルータ /(n) (comp) cable router/
ケーブルレリーズ /(n) cable release/
ケーブル配線図 [ケーブルはいせんず] /(n) (comp) cabling diagram/
ケープ /(n) cape/(P)/
ケープペンギン /(n) Cape penguin/African penguin/blackfooted penguin/jackass penguin (Spheniscus demersus)/
ケーマン諸島 [ケーマンしょとう] /(n) Cayman (islands)/
ケール /(n) kale/
ケー番 [ケーばん] /(n) (col) (abbr) mobile phone number/
ケア /(n,vs) (1) care/(n) (2) kea (Nestor notabilis)/(P)/
ケアウエル /(n) (abbr) wellness care/
ケアサービス /(n) care service/
ケアハウス /(n) nursing care center/nursing care centre/
ケアプラン /(n) care plan/
ケアマネージメント /(n) care management/
ケアマネージャー /(n) care manager/
ケアマネジャー /(n) care manager/
ケアレスミス /(n) (abbr) careless mistake/
ケアワーカー /(n) care taker/
ケア付き住宅 [ケアつきじゅうたく] /(exp) accommodation facilities for disabled and aged people, with care provided/
ケイオス /(n) chaos/
ケイカー /(n) lightweight car with low registration costs/
ケイサツカン /(n) policemen/policeman/police officer/
ケイジャン /(n) Cajun/
ケイジャン料理 [ケイジャンりょうり] /(n) Cajun food/
ケイス /(n) (1) case (e.g. receptacle, condition, event, legal action, letter style, etc.)/(2) (comp) Computer-Aided Software Engineering/CASE/(P)/
ケイタイ /(n,vs,adj-no) (1) something carried (in the hand)/handheld/(n) (2) (abbr) (col) mobile telephone/cell phone/
ケイタイ小説 [ケイタイしょうせつ] /(n) cellphone novel/
ケイトウ /(n) (uk) silver cock's comb (Celosia argentea, esp. crested cock's comb, Celosia argentea var. cristata)/
ケイドロ /(n) cops and robbers (hide-and-seek game)/
ケイバン /(n) (col) (abbr) mobile phone number/
ケイパー /(n) caper (Capparis spinosa)/
ケイブダイビング /(n) cave diving/
ケイリン /(n) keirin/cycle racing event, usu. 2km with a paced start and sprint finish/
ケイワイ /(exp) to be unable to read the situation/to be unable to pick up on the mood of a conversation (e.g. A and B are complaining about C, and D joins the conversation praising C)/
ケイン /(n) cane/
ケインズ主義 [ケインズしゅぎ] /(n) Keynesianism/
ケイ化 [ケイか] /(n,vs) silicification/
ケイ化物 [ケイかぶつ] /(n) silicide/
ケイ砂 [ケイしゃ] /(n) silica sand/
ケイ酸 [ケイさん] /(n) silicic acid/
ケイ酸ナトリウム [ケイさんナトリウム] /(n) sodium silicate (Na2SiO3)/
ケイ酸塩 [ケイさんえん] /(n) silicate/
ケイ石 [ケイせき] /(n) silica/
ケイ素 [ケイそ] /(n) silicon (Si)/
ケイ素鋼 [ケイそこう] /(n) silicon steel/
ケイ素樹脂 [ケイそじゅし] /(n) silicone resin/
ケイ肺 [ケイはい] /(n) silicosis/
ケカアミ /(n) crosshatching/
ケカビ /(n) (uk) mucor/
ケガ人 [ケガにん] /(n) wounded or injured person/
ケサガケベラ /(n) splitlevel hogfish (Bodianus mesothorax)/mesothorax hogfish/eclipse pigfish/
ケサディージャ /(n) quesadilla (spa:)/
ケサディーヤ /(n) quesadilla (spa:)/
ケサランパサラン /(n) (1) flock from a vine-seed weed, used for face powder, and believed to promote desire and happiness/(2) animal from popular folklore with a white fluffy down made from dandelions and a rabbit's tail resembling a fluffy hairball/
ケショウフグ /(n) (uk) map puffer (Arothron mappa)/
ケシ粒 [ケシつぶ] /(n) (1) poppy seed/(adj-f) (2) pinhead-like/small as ants/
ケセラセラ /(exp) What will be, will be (spa: que sera, sera)/
ケセランパサラン /(n) (1) flock from a vine-seed weed, used for face powder, and believed to promote desire and happiness/(2) animal from popular folklore with a white fluffy down made from dandelions and a rabbit's tail resembling a fluffy hairball/
ケセランパセラン /(n) (1) flock from a vine-seed weed, used for face powder, and believed to promote desire and happiness/(2) animal from popular folklore with a white fluffy down made from dandelions and a rabbit's tail resembling a fluffy hairball/
ケタミン /(n) ketamine/
ケダニ /(n) trombiculid mite (any mite of family Trombiculidae)/
ケチつける /(v1) to find fault with/to rain on one's parade/to nitpick/to quibble/
ケチる /(v5r) (uk) (col) to be stingy/to scrimp/
ケチを付ける [ケチをつける] /(exp,v1) (uk) to find fault with/to rain on one's parade/to nitpick/to quibble/
ケチケチ /(adv,vs) stingy/tightfisted/miserly/
ケチャッパー /(n) (sl) someone who loves ketchup/
ケチャップ /(n) ketchup/catsup/(P)/
ケチュア /(n) Quechua (people)/Quecha/Quichua/
ケチュア族 [ケチュアぞく] /(n) Quechua (people)/Quecha/Quichua/
ケッチ /(n) ketch (two-masted vessel with a small mizzen)/
ケッチリグ /(n) ketch rig/
ケッテイ /(n) (uk) hinny/
ケットル /(n) kettle/
ケッパー /(n) caper (Capparis spinosa)/
ケッヘル番号 [ケッヘルばんごう] /(n) Koechel number (catalogue of Mozart's music)/
ケツの穴が小さい [ケツのあながちいさい] /(exp,adj-f) (id) small-minded/petty/cowardly/chicken-hearted/
ケツァール /(n) resplendent quetzal (Pharomachrus mocinno)/
ケトーシス /(n) ketosis/
ケトース /(n) ketose/
ケトル /(n) kettle/
ケトン /(n) ketone/
ケトン基 [ケトンき] /(n) ketone group/
ケトン酸 [ケトンさん] /(n) ketonic acid/
ケトン体 [ケトンたい] /(n) ketone body/
ケナガイタチ /(n) polecat/fitch/
ケナガネズミ /(n) (uk) Ryukyu long-haired rat (Diplothrix legata)/
ケニア /(n) Kenya/
ケニアンクロミス /(n) Kenyan chromis (Chromis nigroanalis)/
ケニア共和国 [ケニアきょうわこく] /(n) Republic of Kenya/
ケネリーヘビサイド層 [ケネリーヘビサイドそう] /(n) (obsc) Kennelly-Heaviside layer/
ケノトロン /(n) kenotron/
ケバブ /(n) kebab (tur:)/
ケビン /(n) cabin/
ケファリン /(n) cephalin (ger: Kephalin)/
ケフェイド変光星 [ケフェイドへんこうせい] /(n) Cepheid variable/
ケフェウス型変光星 [ケフェウスがたへんこうせい] /(n) Cepheid variable/
ケフェウス座 [ケフェウスざ] /(n) (constellation) Cepheus/
ケブカスズメバチ /(n) (uk) Japanese hornet (Vespa simillima, esp. subspecies Vespa simillima simillima)/yellow hornet/
ケプラーの法則 [ケプラーのほうそく] /(n) Kepler's laws/
ケプラー式望遠鏡 [ケプラーしきぼうえんきょう] /(n) Keplerian telescope/
ケベック /(n) Quebec (fre:)/(P)/
ケミカル /(n) chemical/(P)/
ケミカルシューズ /(n) chemical shoes/
ケミカルパルプ /(n) chemical pulp/
ケミカルヒートポンプ /(n) chemical heat pump/
ケミカルレース /(n) chemical lace/
ケミスト /(n) chemist/
ケミストリ /(n) chemistry/
ケミストリー /(n) chemistry/
ケヤキ /(n) (uk) Japanese zelkova (species of elm-like tree, Zelkowa serrata)/
ケラ /(n) (uk) mole cricket (esp. the Oriental mole cricket, Gryllotalpa orientalis)/
ケラチン /(n,adj-no) keratin (ger:)/
ケラマジカ /(n) Kerama deer/Ryukyu sika (Cervus nippon keramae)/
ケラレ /(n) vignetting (darkening of the perimeter of a photographic image)/
ケリ /(n) (uk) gray-headed lapwing (Microsarcops cinereus)/grey-headed lapwing/
ケルト /(n) Celt/
ケルト語 [ケルトご] /(n) Celtic (language)/
ケルト語派 [ケルトごは] /(n) Celtic (branch of languages)/
ケルビム /(n) cherubim (lat:)/
ケルビン /(n) kelvin/
ケルプ /(n) kelp/
ケルベロス /(n) (comp) Kerberos (computer security protocol)/
ケルメット /(n) (abbr) kelmet alloy/
ケルン /(n) (1) Koeln/Cologne/(2) cairn/(P)/
ケレオソート /(n) creosote/
ケレス /(n) (1) Ceres (dwarf planet)/(2) Ceres (Roman goddess of agriculture)/
ケレド /(n) credo (lat:)/
ケレン /(n) scraping/
ケロイド /(n,adj-no) keloid (ger:)/(P)/
ケロケロ /(n) (on-mim) ribbit (frog sound)/
ケロシン /(n) kerosene/
ケロモンガラ /(n) pinktail durgon (type of triggerfish) (Melichthys vidua)/
ケンタウア /(n) Centaur (gre: Kentauros)/
ケンタウル /(n) Centaur (gre: Kentauros)/
ケンタウルス /(n) Centaur (gre: Kentauros)/
ケンタウルス座 [ケンタウルスざ] /(n) (constellation) Centaurus/
ケンタウロス /(n) Centaur (gre: Kentauros)/
ケンタッキー /(n) Kentucky/
ケンチキ /(n) (abbr) (sl) Kentucky Fried Chicken/
ケント紙 [ケントし] /(n) Kent paper/
ケンネル /(n) kennel/
ケンブリッジ /(n) Cambridge/
ケンブリッジ学派 [ケンブリッジがくは] /(n) Cambridge school (of economics)/
ケンポナシ /(n) (uk) Japanese raisin tree (Hovenia dulcis)/
ケンミジンコ /(n) (uk) cyclops (any minute crustacean of genus Cyclops)/
ケンヤ /(n) Kenya/
ケ月 [かげつ] /(ctr) (number of) months/(P)/
ケ国 [かこく] /(ctr) counter for countries/
ケ国語 [かこくご] /(ctr) counter for languages/
ケ所 [かしょ] /(n) passage/place/point/part/
ゲ /(int) exclamation of surprised disappointment, disgust, or worry (yuck, ick, ack, eeew, crap!, blech, gross)/
ゲーゲー /(vs) to vomit/
ゲージ /(n) gauge/(P)/
ゲージガラス /(n) gauge glass/
ゲージブロック /(n) gauge block/
ゲージ圧力 [ゲージあつりょく] /(n) pressure gauge/
ゲージ理論 [ゲージりろん] /(n) gauge theory/
ゲージ粒子 [ゲージりゅうし] /(n) gauge boson/
ゲーズ語 [ゲーズご] /(n) Ge'ez (language)/
ゲーセン /(n) (abbr) game center/game centre/
ゲーデル /(n) Godel (Goedel)/
ゲート /(n) (1) gate (for entry, boarding, etc.)/(2) (comp) gate/(3) logic element/(P)/
ゲートアレイ /(n) (comp) gate array/
ゲートイン /(n,vs) entering the starting gate (wasei: gate in)/
ゲートウェー /(n) (comp) gateway/
ゲートウェー交換機 [ゲートウェーこうかんき] /(n) (comp) gateway switch/
ゲートウェイ /(n) (comp) gateway/
ゲートウェイサービス /(n) (comp) gateway service/
ゲートウエー /(n) gateway/
ゲートボール /(n) gate ball (game similar to croquet)/(P)/
ゲートル /(n) gaiter (fre: guetre)/spat/spats/
ゲート回路 [ゲートかいろ] /(n) gate circuit/
ゲーブルウインドー /(n) gable window/
ゲーマー /(n) gamer (someone who plays a game)/
ゲーム /(n) game/(P)/
ゲームの理論 [ゲームのりろん] /(n) game theory/theory of games/
ゲームオーバー /(n) game over/the game is over/
ゲームオール /(n) game all/
ゲームカウント /(n) game count/
ゲームカセット /(n) game-cassette/
ゲームコントロールアダプタ /(n) (comp) game control adapter/
ゲームセット /(n) game and set/game over/(P)/
ゲームセンター /(n) game centre (wasei: game center)/game arcade/video arcade/penny arcade/(P)/
ゲームソフト /(n) (comp) game software/
ゲームパッド /(n) gamepad/
ゲームポート /(n) (comp) game port/
ゲームポイント /(n) game point/
ゲームメーカー /(n) game maker/
ゲーム機 [ゲームき] /(n) console/game console/game machine/gaming machine/
ゲーム機エミュレータ [ゲームきエミュレータ] /(n) (game) emulator/
ゲーム差 [ゲームさ] /(n) distance in the standings between two teams expressed as the difference in number of games won or lost (baseball)/
ゲーム理論 [ゲームりろん] /(n) (comp) theory of games/
ゲーリュサックの法則 [ゲーリュサックのほうそく] /(n) Gay-Lussac's law/
ゲール語 [ゲールご] /(n) Gaelic (language)/
ゲイ /(n) gay/(P)/
ゲイセン /(n) (abbr) game center/game centre/
ゲイバー /(n) gay bar/
ゲイボーイ /(n) gay boy/
ゲイムセンター /(n) game centre (wasei: game center)/game arcade/video arcade/penny arcade/
ゲイリブ /(n) gay lib(eration)/(P)/
ゲイリュサックの法則 [ゲイリュサックのほうそく] /(n) Gay-Lussac's law/
ゲイル /(n) gale/
ゲイン /(n) gain/(P)/
ゲエズ語 [ゲエズご] /(n) Ge'ez (language)/
ゲオポリティーク /(n) geopolitic/geopolitics/
ゲシュタポ /(n) Gestapo (ger: Geheime Staatspolizei)/(P)/
ゲシュタルト /(n) gestalt (ger:)/
ゲシュタルト心理学 [ゲシュタルトしんりがく] /(n) Gestalt psychology/
ゲスト /(n) guest/(P)/
ゲストＩＤ [ゲストアイディー] /(n) (comp) guest ID/
ゲストＯＳ [ゲストオーエス] /(n) (comp) guest Operating System/
ゲストコンピュータ /(n) (comp) guest computer/
ゲストハウス /(n) guesthouse/
ゲストメンバー /(n) guest member/
ゲストルーム /(n) guest room/
ゲゼルシャフト /(n) society (ger:)/gesellschaft/
ゲッ /(int) exclamation of surprised disappointment, disgust, or worry (yuck, ick, ack, eeew, crap!, blech, gross)/
ゲッケイジュ /(n) (uk) bay laurel (Laurus nobilis)/bay tree/sweet bay/laurel tree/
ゲッター /(n) getter/
ゲッツー /(n) baseball double-play (wasei: get two)/
ゲット /(n,vs) (1) scoring a goal (point, etc.) (from get)/(vs) (2) to get (something)/to obtain/
ゲットー /(n) ghetto (ita:)/(P)/
ゲットウ /(n) (uk) shell ginger (Alpinia zerumbet)/
ゲットセット /(n) get set/
ゲットツー /(n) baseball double-play (wasei: get two)/
ゲトる /(v5r) (obsc) (sl) to get/
ゲネプロ /(n) costume rehearsal (ger: Generalprobe)/
ゲノム /(n) genome (ger: Genom)/(P)/
ゲノムプロジェクト /(n) genome project/
ゲノム分析 [ゲノムぶんせき] /(n) genome analysis/
ゲノン /(n) guenon (any Old World monkey of genus Cercopithecus)/
ゲバ /(n) (abbr) (political) violence/violent tactics used by political radicals/
ゲバリスタ /(n) Guevarista (spa:)/(P)/
ゲバルト /(n) (political) violence (ger: Gewalt)/violent tactics used by political radicals/
ゲフィルテフィッシュ /(n) gefilte fish/
ゲマインシャフト /(n) community (ger:)/gemeinschaft/
ゲマトリア /(n) gematria/
ゲラ /(n) (1) (abbr) galley (tray used for printing)/(2) galley proof/
ゲラゲラ /(adv,adv-to) (on-mim) guffaw/
ゲラダ狒々 [ゲラダひひ] /(n) gelada baboon/
ゲラダ狒狒 [ゲラダひひ] /(n) gelada baboon/
ゲラ刷り [ゲラずり] /(n) galley proof/
ゲリマンダー /(n) gerrymander/
ゲリラ /(n) guerrilla/(P)/
ゲリラライブ /(n) surprise concert (wasei: guerrilla live)/
ゲリラ戦 [ゲリラせん] /(n) guerrilla warfare/
ゲリラ兵 [ゲリラへい] /(n) guerrilla/
ゲル /(n) (1) gel (ger: Gel)/(2) money (ger: Geld)/(3) yurt (mon: gher)/(P)/
ゲルト /(n) money (ger: Geld)/
ゲルピン /(n) (abbr) money-shortage crisis (ger: Geld, eng: pinch)/
ゲルマニウム /(n) germanium (Ge) (ger:)/
ゲルマン /(n) germane (ger:)/(P)/
ゲルマン語派 [ゲルマンごは] /(n) Germanic (branch of languages)/
ゲルマン人 [ゲルマンじん] /(n) Germanic peoples/
ゲルンジー /(n) guernsey/
ゲル状 [ゲルじょう] /(n) (1) gel/(adj-no) (2) gelatinous/gelled/
ゲレーン /(n) grain (1-7000 of a pound, approx. 64.80 mg)/
ゲレイン /(n) grain (1-7000 of a pound, approx. 64.80 mg)/
ゲレンデ /(n) ski slope (ger: Gelaende)/(P)/
ゲロを吐く [ゲロをはく] /(exp,v5k) (col) to throw up/to spew/
ゲロゲロ /(n) (on-mim) ribbit (frog sound)/
ゲロゲロ鳴く [ゲロゲロなく] /(exp,v5k) to croak (e.g. like a frog)/
ゲン /(n) gene (ger: Gen)/(P)/
ゲンゴロウ /(n) (1) (uk) diving beetle/(2) Japanese predacious diving beetle (Cybister japonicus)/
ゲンゴロウブナ /(n) (uk) Japanese crucian carp (Carassius cuvieri)/white crucian carp/
ゲンソウ /(n) (uk) Thunberg's geranium (Geranium thunbergii)/
ゲンチアナ /(n) gentian (esp. the great yellow gentian, Gentiana lutea) (lat: gentiana)/
ゲンツェン /(n) Gentzen/
ゲンナリ /(adv,vs) wearily/dejectedly/
ゲンノショウコ /(n) (uk) Thunberg's geranium (Geranium thunbergii)/
ゲンロクダイ /(n) brown-banded butterflyfish (Chaetodon modestus)/modest butterflyfish/
コーカサス諸語 [コーカサスしょご] /(n) Caucasian languages/
コーカサス人種 [コーカサスじんしゅ] /(n) Caucasoid/
コーカソイド /(n) Caucasoid/
コーキング /(n,vs) caulking/calking/(P)/
コーク /(n) Coke/
コークス /(n) coke (ger: Koks)/
コークスクリュー /(n) corkscrew/(P)/
コークハイ /(n) Coke highball/
コーケ /(n) Coke/
コーシャー /(n) kosher/
コーション /(n) caution/
コージェネレーション /(n) cogeneration/co-generation/
コージェネレーションシステム /(n) co-generation system/cogeneration system/
コージェライト /(n) cordierite/
コージュロイ /(n) corduroy/
コース /(n) course/(P)/
コースウェア /(n) (comp) courseware/
コースウエア /(n) courseware/
コースオブスタディー /(n) course of study/
コースター /(n) coaster/(P)/
コースターブレーキ /(n) coaster brake/
コースト /(n) coast/
コースライン /(n) courseline/
コースレコード /(n) course record/
コースレット /(n) corselet/
コースロープ /(n) lane marks (wasei: course rope)/
コーダ /(n) coda (ita:)/
コーチ /(n,vs) coach/(P)/
コーチゾン /(n) cortisone/
コーチボックス /(n) coach's box/
コーチャー /(n) coach/coacher/
コーチン /(n) Cochin (breed of chicken)/
コーチングステッチ /(n) couching stitch/
コーテーションマーク /(n) quotation mark/
コーティング /(n,vs) coating/(P)/
コーテッドペーパー /(n) coated paper/
コーテッドレンズ /(n) coated lens/
コーディアライト /(n) cordierite/
コーディネーション /(n) coordination/
コーディネーター /(n) coordinator/(P)/
コーディネート /(n,vs) (1) coordinate/co-ordinate/coordination/(2) matching (e.g. clothes, accessories, furniture, colours)/(n) (3) matching outfit (clothes and accessories)/(P)/
コーディネイト /(n,vs) (1) coordinate/co-ordinate/coordination/(2) matching (e.g. clothes, accessories, furniture, colours)/(n) (3) matching outfit (clothes and accessories)/
コーディング /(n,vs) (comp) coding/
コーディングシステム /(n) coding system/
コーディング体系 [コーディングたいけい] /(n) (comp) coding system/
コーディング用紙 [コーディングようし] /(n) (comp) coding form/
コーデック /(n) (comp) codec/
コーデュロイ /(n) corduroy/
コート /(n) (1) coat/(2) court (i.e. tennis, basketball, etc.)/(P)/
コートジボアール /(n) (Republic of) Ivory Coast/Cote d'Ivoire/
コートジボワール /(n) (Republic of) Ivory Coast/Cote d'Ivoire/
コートドレス /(n) coatdress/
コートハウス /(n) courthouse/
コートヤード /(n) courtyard/
コート紙 [コートし] /(n) coated paper/
コード /(n) (1) code/(2) cord/(3) chord/(P)/
コードインデペンデント /(n) (comp) code-independent/
コードグループ /(n) (comp) code-group/
コードコンバータ /(n) (comp) code converter/
コードサイズ /(n) (comp) code size/
コードセット /(n) (1) code set/(2) cord set (electrical)/
コードセンシティブ /(adj-na) (comp) code-sensitive/
コードトランスペアレント /(adj-na) (comp) code-transparent/
コードネーム /(n) (1) chord-name/(2) code name/
コードバン /(n) cordovan (type of leather)/
コードビット /(n) (comp) code-bit/
コードブック /(n) code book/
コードブックス /(n) code-books/
コードプログラミング /(n) (comp) code programming/
コードページ /(n) (comp) code page/
コードページ切り替え [コードページきりかえ] /(n) (comp) code page switching/
コードペンダント /(n) cord pendant/
コードポイント /(n) (comp) code point/
コードモーフィングソフトウェア /(n) (comp) code morphing software/
コードレス /(n) cordless/(P)/
コードレステレフォニー /(n) (comp) cordless telephony/
コードレスホン /(n) cordless phone/(P)/
コードレス電話 [コードレスでんわ] /(n) cordless phone/
コード化 [コードか] /(n,vs) (comp) encoding/codification/
コード化画像 [コードかがぞう] /(n) (comp) coded image/
コード化集合 [コードかしゅうごう] /(n) (comp) coded set/
コード化表現 [コードかひょうげん] /(n) (comp) code element/code value/coded representation/
コード化文字集合 [コードかもじしゅうごう] /(n) (comp) coded character set/
コード拡張文字 [コードかくちょうもじ] /(n) (comp) code extension character/
コード管理 [コードかんり] /(n) (comp) code management/
コード構成 [コードこうせい] /(n) (comp) coding scheme/
コード刺繍 [コードししゅう] /(n) cord embroidery/
コード進行 [コードしんこう] /(n) chord progression (music)/
コード設計 [コードせっけい] /(n) (comp) code design/
コード体系 [コードたいけい] /(n) (comp) code/coding scheme/
コード値 [コードち] /(n) (comp) code element/code value/coded representation/
コード透過形データ通信 [コードとうかがたデータつうしん] /(n) (comp) code-transparent data communication/
コード独立形データ通信 [コードどくりつがたデータつうしん] /(n) (comp) code-independent data communication/
コード入力 [コードにゅうりょく] /(n) (comp) input by codes/
コード変換 [コードへんかん] /(n) (comp) code conversion/code translation/
コード変換器 [コードへんかんき] /(n) (comp) code converter/
コード名 [コードめい] /(n) (comp) code name/
コード要素 [コードようそ] /(n) (comp) code element/code value/coded representation/
コーナ /(n) corner/
コーナー /(n) corner/(P)/
コーナーカップボード /(n) corner cupboard/
コーナーキック /(n) corner kick (soccer)/
コーナーキャビネット /(n) corner cabinet/
コーナースロー /(n) corner throw/
コーナートップ /(n) corner top/
コーナーワーク /(n) corner work/
コーナリング /(n) cornering/(P)/
コーナリングランプ /(n) cornering lamp/
コーニス /(n) cornice/
コーネリアエ /(n) Aulonocara chizumulu (species of peacock cichlid, Aulonocara korneliae)/Aulonocara blue gold/
コーパス /(n) corpus/corpora/
コーパス言語学 [コーパスげんごがく] /(n) corpus linguistics/
コーパル /(n) copal/
コーヒー /(n,adj-no) (uk) coffee (eng: coffee, dut: koffie)/(P)/
コーヒーの木 [コーヒーのき] /(n) coffee tree/
コーヒーカップ /(n) coffee cup/(P)/
コーヒーショップ /(n) coffee shop/(P)/
コーヒーシロップ /(n) coffee syrup/
コーヒースタンド /(n) coffee stand/
コーヒーハウス /(n) coffee house/
コーヒーフロート /(n) coffee float/
コーヒーブラウン /(n) (brown) coffee/
コーヒーブレーク /(n) coffee break/
コーヒーブレイク /(n) coffee break/
コーヒーポット /(n) coffee pot/
コーヒーマグ /(n) coffee mug/
コーヒーミル /(n) coffee mill/coffee grinder/
コーヒーメーカー /(n) coffee maker/
コーヒー豆 [コーヒーまめ] /(n) coffee bean/
コーヒー粉 [コーヒーこ] /(n) coffee grounds/
コーヒー粉砕機 [コーヒーふんさいき] /(n) coffee grinder/coffee mill/
コーピング /(n) coping/
コープ /(n) coop/(P)/
コープス /(n) corpse/
コーヘン /(n) Cohen/
コーホート /(n) cohort (statistics,, biology, etc.)/
コーボルト /(n) kobold (evil spirit in German folklore) (ger: Kobolt)/goblin/
コーポ /(n) (abbr) corporated house/(P)/
コーポクラシー /(n) corpocracy/
コーポラス /(n) corporated house/
コーポラティズム /(n) corporatism/
コーポラティブハウス /(n) cooperative house/
コーポリマー /(n) copolymer/
コーポレーション /(n) corporation/(P)/
コーポレート /(adj-f) corporate/
コーポレートアイデンティティー /(n) corporate identity/(P)/
コーポレートガバナンス /(n) corporate governance/
コーポレートバンキング /(n) corporate banking/
コーポレートライセンス /(n) (comp) corporate license/
コーマ /(n) coma/
コーム /(n) (comp) comb/
コーラ /(n) cola/(P)/
コーライト /(n) coalite/semi-carbonized coke/semi-coke/
コーラス /(n) chorus/(P)/
コーラスガール /(n) chorus girl/
コーラル /(n) (1) coral/(adj-f) (2) choral/
コーラルアイランド /(n) coral island/
コーラルシーグレゴリー /(n) Coral Sea gregory (Stegastes gascoynei)/
コーラルリーディング /(n) choral reading (reading aloud in a group)/
コーラルリング /(n) coral ring/
コーラン /(n,adj-no) Koran (ara: kuran)/Qur'an/Quran/the Islamic holy book/(P)/
コーラングレ /(n) cor anglais (fre:)/
コーリャン /(n) variety of sorghum, esp. used in making spirits (chi: kaoliang)/
コーリャン酒 [コーリャンしゅ] /(n) kaoliang (strong distilled Chinese alcohol made from sorghum)/
コール /(n,vs) (1) call/(n) (2) coal/(3) (ksb:) cold/(P)/
コール・ド・バレエ /(n) corps de ballet (fre:)/
コールアングレ /(n) cor anglais (fre:)/
コールウエイティング /(n) (comp) call waiting/
コールオプション /(n) call option/
コールカッター /(n) coal cutter/
コールガール /(n) call girl/
コールサイン /(n) call sign/
コールサック /(n) Coalsack Nebula/
コールスロー /(n) coleslaw/
コールセットアップ /(n) (comp) call setup/
コールセンター /(n) (comp) call center/
コールタール /(n) coal tar/
コールタン /(n) (abbr) corded velveteen/
コールテン /(n) corded velveteen/corduroy/
コールド /(n) (1) cold/(2) called/(P)/
コールドウェーブ /(n) cold wave/
コールドウエーブ /(n) cold wave/
コールドウォー /(n) cold war/
コールドウオー /(n) cold war/
コールドカラー /(n) (obsc) cold colour (color)/
コールドクリーム /(n) cold cream/
コールドゲーム /(n) called game (baseball)/(P)/
コールドコーヒー /(n) cold coffee/
コールドスタート /(n) (comp) cold start/
コールドタイプ /(n) cold type/
コールドタイプシステム /(n) cold type system/
コールドチェーン /(n) cold chain/
コールドチキン /(n) cold chicken/
コールドバレエ /(n) corps de ballet (fre:)/
コールドパーマ /(n) (abbr) cold permanent wave/
コールドビーフ /(n) cold beef/
コールドフォルト /(n) (comp) cold fault/
コールドブート /(n) (comp) cold booting/
コールドボルテックス /(n) cold vortex/
コールドミート /(n) cold meat/
コールドリセット /(n) (comp) cold reset/
コールドロード /(n) (comp) cold load/
コールド負け [コールドまけ] /(n) loss of a match that is 'called' part way into the game/
コールナンバー /(n) call number/
コールバック /(n) call-back/
コールバックモデム /(n) (comp) callback modem/
コールバック機能 [コールバックきのう] /(n) (comp) call-back function/
コールピック /(n) coal pick/
コールブローカー /(n) call broker/
コールマネー /(n) call money/
コールユーブンゲン /(n) choir exercises (ger: Choruebungen)/
コールラビ /(n) kohlrabi/
コールレート /(n) call rate/
コールローン /(n) call loan/
コール酸 [コールさん] /(n) cholic acid/
コール市場 [コールいちば] /(n) call (money) market/call trading/
コール市場 [コールしじょう] /(n) call (money) market/call trading/
コール天 [コールてん] /(n) corded velveteen/corduroy/
コーレーグース /(n) (uk) (rkb:) capsicum/chili pepper (chile, chilli)/cayenne/red pepper/
コーレーグス /(n) (uk) (rkb:) capsicum/chili pepper (chile, chilli)/cayenne/red pepper/
コーレル /(n) (comp) Corel/
コーン /(n) (1) cone/(2) corn/(P)/
コーンウイスキー /(n) corn whiskey (whisky)/
コーンオイル /(n) corn oil/
コーンシロップ /(n) corn syrup/
コーンスープ /(n) corn soup/
コーンスターチ /(n) corn starch/(P)/
コーンスネーク /(n) corn snake (Elaphe guttata)/
コーンスノー /(n) corn snow/
コーンスピーカー /(n) cone speaker/
コーンズ /(n) (1) cones/(2) corns/
コーンチャウダー /(n) corn chowder/
コーンビーフ /(n) corned beef/
コーンフラワー /(n) cornflour/
コーンフレーク /(n) cold cereal/breakfast cereal/corn flakes/
コーンフレークス /(n) cold cereal/breakfast cereal/corn flakes/
コーンベルト /(n) corn belt/
コーンミール /(n) cornmeal/
コの字 [コのじ] /(n) U-shaped/
コア /(n) core/(P)/
コアを吐く [コアをはく] /(exp,v5k) (comp) to dump core/to dump memory contents/
コアカリキュラム /(n) core curriculum/
コアキシャルケーブル /(n) (comp) coaxial cable/
コアキシャルスピーカー /(n) coaxial loudspeaker/
コアシステム /(n) core system/
コアジサシ /(n) little tern (the official bird of Chiba)/sterna albifrons/
コアストア /(n) (comp) core store/
コアセルベート /(n) coacervate/
コアタイム /(n) core time/
コアダンプ /(n) (comp) core-dump/
コアックス /(n) (comp) coax/coaxial cable/
コアビジネス /(n) core business/
コアビタシオン /(n) cohabitation (fre:)/(P)/
コアプログラム /(n) (comp) core program/
コアホウドリ /(n) (uk) Laysan albatross (Diomedea immutabilis)/
コアラ /(n) koala/(P)/
コアリズム /(n) weight-loss exercises (wasei: core rhythm)/weight-loss body movements/
コアルータ /(n) (comp) core router/
コア技術 [コアぎじゅつ] /(n) (comp) core technology/
コア径 [コアケイ] /(n) (comp) core diameter (of a fiber)/
コイ /(n) Khoi (people)/Khoikhoi/Khoi-khoin/
コイガ /(n) (uk) common clothes moth (Tineola biselliella)/
コイサン /(n) Khoisan (Khoikhoi and San peoples of Southern Africa)/
コイタス /(n) coitus/(P)/
コイネー /(n) koine (post-classical Greek language) (gre:)/
コイバナ /(n) (abbr) love story/
コイル /(n) coil/(P)/
コイルガン /(n) coilgun (gun in which a magnetic projectile is propelled using electromagnetic coils)/
コイルスプリング /(n) coil spring/
コイルボビン /(n) coil bobbin/
コイワシクジラ /(n) (uk) (obsc) minke whale/piked whale (Balaenoptera acutorostrata)/
コイン /(n) coin/(P)/
コイン・パーキング /(n) coin-operated parking (spaces) (wasei: coin parking)/
コイントス /(n) coin toss/coin flipping/toss of a coin/
コインパーキング /(n) coin-operated parking (spaces) (wasei: coin parking)/
コインランドリー /(n) laundromat (wasei: coin laundry)/laundrette/
コインロッカー /(n) coin locker/(P)/
コイ族 [コイぞく] /(n) (obsc) Khoi (people)/Khoikhoi/Khoi-khoin/
コウイカ /(n) golden cuttlefish (Sepia esculenta)/cuttlefish (any species in the family Sepiidae)/
コウウチョウ /(n) (uk) brown-headed cowbird (Molothrus ater)/
コウカイチョウチョウウオ /(n) white-face butterflyfish (Chaetodon mesoleucos)/
コウカイミスジ /(n) blacktail butterflyfish (Chaetodon austriacus)/exquisite butterflyfish/
コウコナット /(n) coconut/
コウジンメヌケ /(n) (uk) (obsc) Sebastes iracundus (species of rockfish)/
コウゾ /(n) (uk) hybrid mulberry tree used to make Japanese paper (Broussonetia kazinoki x papyrifera)/
コウナゴ /(n) young lancefish/young sand lance/
コウノトリ /(n) (uk) stork (esp. the Oriental stork, Ciconia boyciana)/
コウノトリの揺り籠 [コウノトリのゆりかご] /(n) (uk) baby hatch for unwanted newborns at Jikei Hospital, Kumamoto (lit: stork's cradle)/
コウホネ /(n) (uk) Japanese spatterdock (species of water lily, Nuphar japonica)/
コウモリガ /(n) (uk) swift moth (Hepialidae spp., esp. Endoclita excrescens)/
コウヤノマンネングサ /(n) (uk) Climacium japonicum (species of moss)/
コウヤノマンネンゴケ /(n) (uk) Climacium japonicum (species of moss)/
コウライウグイス /(n) (uk) black-naped oriole (Oriolus chinensis)/
コウライオヤニラミ /(n) (uk) Coreoperca herzi (species of temperate perch)/
コウラウン /(n) (uk) red-whiskered bulbul (Pycnonotus jocosus)/
コウ丸 [コウがん] /(n,adj-no) testicles/testes/balls/
コエビ /(n) (1) shrimp (infraorder Caridea)/(2) small shrimp, prawn or lobster/
コエンザイム /(n) coenzyme/
コエンドロ /(n) coriander (Coriandrum sativum) (por: coentro)/
コオペラティヴシステム /(n) cooperative system/
コカの木 [コカのき] /(n) coca tree/
コカイン /(n) cocaine/(P)/
コカコーラ /(n) Coca-Cola/(P)/
コカトリス /(n) cockatrice/
コガシラベラ /(n) bluntheaded wrasse (Thalassoma amblycephalum)/bluehead wrasse/rainbow wrasse/
コガタスズメバチ /(n) (uk) yellow-vented hornet (Vespa analis)/
コガネオオトカゲ /(n) (uk) quince monitor (Varanus melinus, species of carnivorous monitor lizard native to Indonesia)/yellow-head monitor/
コガネスズメダイ /(n) yellow chromis (Chromis analis)/
コガネチョウチョウウオ /(n) pebbled butterflyfish (Chaetodon multicinctus)/multiband butterflyfish/
コガモ /(n) (uk) green-winged teal (species of duck, Anas crecca)/
コガラ /(n) (uk) willow tit (Parus montanus)/
コキール /(n) shell (fre: coquille)/
コキュ /(n) cuckold (fre: cocu)/
コキュー /(n) cuckold (fre: cocu)/
コギトエルゴスム /(exp) cogito, ergo sum (Descartes) (lat:)/(P)/
コギノコ /(n) (uk) Buckleya lanceolata (species of parasitic deciduous shrub)/
コギャル /(n) (abbr) obsessively trend-conscious teen-age girls/
コクーン /(n) cocoon/
コクる /(v5r,vt) (sl) to confess (one's love)/to propose (marriage)/to ask out (on a date)/
コクサッキーウイルス /(n) Coxsackie virus/
コクシエラバーネッティ /(n) Coxiella burnetii (causative agent of Q fever)/
コ